/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import org.eclipse.fordiac.ide.gef.nat.StyledTextCellEditor;
import org.eclipse.fordiac.ide.structuredtextalgorithm.ui.editor.embedded.STAlgorithmEmbeddedEditorUtil;
import org.eclipse.fordiac.ide.structuredtextcore.ui.document.LibraryElementXtextDocument;
import org.eclipse.fordiac.ide.structuredtextcore.ui.document.LibraryElementXtextDocumentUpdater;
import org.eclipse.fordiac.ide.ui.providers.SourceViewerColorProvider;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

public abstract class XtextStyledTextCellEditor
extends StyledTextCellEditor {
    private EmbeddedEditor embeddedEditor;
    private boolean proposalPopupOpen;
    private final LibraryElementXtextDocumentUpdater updater = STAlgorithmEmbeddedEditorUtil.getLibraryElementXtextDocumentUpdater();

    protected XtextStyledTextCellEditor() {
    }

    protected XtextStyledTextCellEditor(boolean moveSelectionOnEnter) {
        super(false, moveSelectionOnEnter);
    }

    @Override
    protected StyledText createStyledText(Composite parent, int style) {
        this.embeddedEditor = STAlgorithmEmbeddedEditorUtil.getEmbeddedEditorFactory().newEditor(this.createEditedResourceProvider()).withStyle(style).withParent(parent);
        this.embeddedEditor.createPartialEditor();
        SourceViewerColorProvider.initializeSourceViewerColors((ISourceViewer)this.embeddedEditor.getViewer());
        this.embeddedEditor.getViewer().getContentAssistantFacade().addCompletionListener(new ICompletionListener(){

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                XtextStyledTextCellEditor.this.proposalPopupOpen = true;
                FocusListener focusListener = XtextStyledTextCellEditor.this.focusListener;
                if (focusListener instanceof AbstractCellEditor.InlineFocusListener) {
                    AbstractCellEditor.InlineFocusListener inlineFocusListener = (AbstractCellEditor.InlineFocusListener)focusListener;
                    inlineFocusListener.handleFocusChanges = false;
                }
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                XtextStyledTextCellEditor.this.proposalPopupOpen = false;
                FocusListener focusListener = XtextStyledTextCellEditor.this.focusListener;
                if (focusListener instanceof AbstractCellEditor.InlineFocusListener) {
                    AbstractCellEditor.InlineFocusListener inlineFocusListener = (AbstractCellEditor.InlineFocusListener)focusListener;
                    inlineFocusListener.handleFocusChanges = true;
                }
            }
        });
        XtextDocument xtextDocument = this.embeddedEditor.getDocument();
        if (xtextDocument instanceof LibraryElementXtextDocument) {
            LibraryElementXtextDocument libDocument = (LibraryElementXtextDocument)xtextDocument;
            this.updater.install(libDocument);
            this.embeddedEditor.getViewer().getControl().addDisposeListener(event -> this.updater.uninstall());
        }
        return (StyledText)this.embeddedEditor.getViewer().getControl();
    }

    protected abstract IEditedResourceProvider createEditedResourceProvider();

    @Override
    public void setEditorValue(Object value) {
        super.setEditorValue(value);
        this.embeddedEditor.getViewer().getUndoManager().reset();
    }

    @Override
    protected boolean isProposalPopupOpen() {
        return this.proposalPopupOpen;
    }
}

