/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.contractSpec.CausalFuncName;
import org.eclipse.fordiac.ide.contractSpec.CausalRelation;
import org.eclipse.fordiac.ide.contracts.Messages;
import org.eclipse.fordiac.ide.contracts.commands.PrepareContractCommand;
import org.eclipse.fordiac.ide.contracts.dialogs.DefineContractDecisionDialog;
import org.eclipse.fordiac.ide.contracts.helpers.ContractUtils;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class DefineFbInterfaceConstraintHandler
extends AbstractHandler {
    private static final String DEFAULT_TIME = "10ms";
    private static final int CANCEL = -1;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ArrayList<String> pinNames;
        List<Event> eventPins = DefineFbInterfaceConstraintHandler.getSelectedPins(event);
        ArrayList<Event> iPins = new ArrayList<Event>();
        ArrayList<String> iPinN = new ArrayList<String>();
        ArrayList<Event> oPins = new ArrayList<Event>();
        ArrayList<String> oPinN = new ArrayList<String>();
        for (Event pin : eventPins) {
            if (pin.isIsInput()) {
                iPins.add(pin);
                iPinN.add(pin.getName());
                continue;
            }
            oPins.add(pin);
            oPinN.add(pin.getName());
        }
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (iPins.isEmpty() && oPins.isEmpty()) {
            MessageDialog.openError((Shell)shell, (String)Messages.NoPinSelectedErrorDialog_Title, (String)Messages.NoPinSelectedErrorDialog_Info);
            return Status.CANCEL_STATUS;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> templates = new ArrayList<String>();
        ArrayList<Event> pins = iPins.isEmpty() ? oPins : iPins;
        ArrayList<String> arrayList = pinNames = iPinN.isEmpty() ? oPinN : iPinN;
        if (iPins.size() == 1 && oPins.size() == 1) {
            names.add(Messages.ContractRuleCausalReaction);
            templates.add(ContractUtils.createCausalReaction((String)iPinN.get(0), (String)oPinN.get(0), DEFAULT_TIME));
            names.add(Messages.ContractRuleCausalReaction);
            templates.add(ContractUtils.createCausalFuncDecl(CausalFuncName.REACTION, (String)iPinN.get(0), (String)oPinN.get(0), CausalRelation.FIFO));
            names.add(Messages.ContractRuleCausalAge);
            templates.add(ContractUtils.createCausalAge((String)iPinN.get(0), (String)oPinN.get(0), DEFAULT_TIME));
            names.add(Messages.ContractRuleCausalReaction);
            templates.add(ContractUtils.createCausalFuncDecl(CausalFuncName.AGE, (String)oPinN.get(0), (String)iPinN.get(0), CausalRelation.FIFO));
        } else if (iPins.isEmpty() || oPins.isEmpty()) {
            names.add(Messages.ContractRuleSingleEvent);
            templates.add(ContractUtils.createSingleEvent(pinNames, DEFAULT_TIME));
            names.add(Messages.ContractRuleRepetition);
            templates.add(ContractUtils.createRepetition(pinNames, DEFAULT_TIME, null, null));
            names.add(Messages.ContractRuleRepetition);
            templates.add(ContractUtils.createRepetition(pinNames, DEFAULT_TIME, DEFAULT_TIME, null));
            names.add(Messages.ContractRuleRepetition);
            templates.add(ContractUtils.createRepetition(pinNames, DEFAULT_TIME, null, DEFAULT_TIME));
            names.add(Messages.ContractRuleRepetition);
            templates.add(ContractUtils.createRepetition(pinNames, DEFAULT_TIME, DEFAULT_TIME, DEFAULT_TIME));
        }
        if (!iPins.isEmpty() && !oPins.isEmpty()) {
            names.add(Messages.ContractRuleReaction);
            templates.add(ContractUtils.createReaction(iPinN, oPinN, false, false, DEFAULT_TIME, false, 0, 0));
            names.add(Messages.ContractRuleAge);
            templates.add(ContractUtils.createAge(iPinN, oPinN, false, false, DEFAULT_TIME, false, 0, 0));
            if (iPins.size() > 1 || oPins.size() > 1) {
                names.add(Messages.ContractRuleReaction);
                templates.add(ContractUtils.createReaction(iPinN, oPinN, true, true, DEFAULT_TIME, false, 0, 0));
                names.add(Messages.ContractRuleAge);
                templates.add(ContractUtils.createAge(iPinN, oPinN, true, true, DEFAULT_TIME, false, 0, 0));
            }
        }
        names.add(Messages.ContractRuleEmpty);
        templates.add("// TODO");
        DefineContractDecisionDialog dialog = new DefineContractDecisionDialog(shell, names, templates);
        if (dialog.open() != -1) {
            BlockFBNetworkElement fbElem = ((Event)pins.get(0)).getBlockFBNetworkElement();
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            CommandStack cmdStack = (CommandStack)editor.getAdapter(CommandStack.class);
            cmdStack.execute((Command)new PrepareContractCommand((FBNetworkElement)fbElem, iPins, oPins, dialog.getTemplate()));
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private static List<Event> getSelectedPins(ExecutionEvent event) {
        ArrayList<Event> pins = new ArrayList<Event>();
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object selected;
            Object obj = selected = iterator.next();
            if (selected instanceof EditPart) {
                EditPart selectedEP = (EditPart)selected;
                obj = selectedEP.getModel();
            }
            if (!(obj instanceof Event)) continue;
            Event eventPin = (Event)obj;
            pins.add(eventPin);
        }
        boolean sameFb = pins.stream().filter(ev -> ev.getBlockFBNetworkElement() != null).allMatch(ev -> ev.getBlockFBNetworkElement().equals(((Event)pins.get(0)).getBlockFBNetworkElement()));
        if (sameFb) {
            return pins;
        }
        return Collections.emptyList();
    }
}

