/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.impl;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.spec.MatchSpec;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class NotLoadedFragmentMatch
extends MatchSpec {
    private ImmutableList<Match> children;
    private String name;

    public NotLoadedFragmentMatch() {
        this.children = ImmutableList.of();
        this.name = "";
    }

    public NotLoadedFragmentMatch(Match child) {
        this.children = ImmutableList.of((Object)child);
        this.name = "";
    }

    public NotLoadedFragmentMatch(Collection<Match> children) {
        this.children = ImmutableList.copyOf(children);
        this.name = "";
    }

    @Override
    public Comparison getComparison() {
        Comparison ret = null;
        if (!this.children.isEmpty()) {
            Match firstChild = this.getFirstMatchChild();
            EObject eContainer = firstChild.eContainer();
            while (!(eContainer instanceof Comparison) && eContainer != null) {
                eContainer = eContainer.eContainer();
            }
            if (eContainer != null) {
                ret = (Comparison)eContainer;
            }
        }
        return ret;
    }

    public Collection<Match> getChildren() {
        return this.children;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Resource getResource() {
        Match match = this.getFirstMatchChild();
        Resource resource = match != null && match.getLeft() != null ? match.getLeft().eResource() : (match != null && match.getRight() != null ? match.getRight().eResource() : (match != null && match.getOrigin() != null ? match.getOrigin().eResource() : null));
        return resource;
    }

    public Match getFirstMatchChild() {
        Match match;
        if (!this.children.isEmpty()) {
            match = (Match)this.children.iterator().next();
            if (match instanceof NotLoadedFragmentMatch) {
                match = ((NotLoadedFragmentMatch)match).getFirstMatchChild();
            }
        } else {
            match = null;
        }
        return match;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.equals(this.children);
    }

    public int hashCode() {
        return this.children.hashCode();
    }
}

