/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.revision.FileRevisionEditorInput;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class EgitUiEditorUtils {
    public static IEditorPart openEditor(IWorkbenchPage page, IFileRevision revision, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IStorage file = revision.getStorage((IProgressMonitor)progress.newChild(1));
        if (file instanceof IFile) {
            return IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)file), (boolean)OpenStrategy.activateOnOpen());
        }
        FileRevisionEditorInput fileRevEditorInput = FileRevisionEditorInput.createEditorInputFor(revision, (IProgressMonitor)progress.newChild(1));
        IEditorPart part = EgitUiEditorUtils.openEditor(page, fileRevEditorInput);
        return part;
    }

    public static void openTextEditor(IWorkbenchPage page, IFileRevision revision, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        FileRevisionEditorInput fileRevEditorInput = FileRevisionEditorInput.createEditorInputFor(revision, (IProgressMonitor)progress.newChild(1));
        page.openEditor((IEditorInput)fileRevEditorInput, "org.eclipse.ui.DefaultTextEditor");
    }

    public static IEditorPart openEditor(IWorkbenchPage page, FileRevisionEditorInput editorInput) throws PartInitException {
        return EgitUiEditorUtils.openEditor(page, editorInput, EgitUiEditorUtils.getEditor(editorInput));
    }

    private static IEditorPart openEditor(IWorkbenchPage page, FileRevisionEditorInput editorInput, IEditorDescriptor editor) throws PartInitException {
        String editorId = editor.getId();
        try {
            IEditorPart part = page.openEditor((IEditorInput)editorInput, editorId, OpenStrategy.activateOnOpen());
            if (part == null && !editor.isOpenExternal()) {
                throw new PartInitException(NLS.bind((String)UIText.EgitUiUtils_CouldNotOpenEditorMessage, (Object)editorId));
            }
            return part;
        }
        catch (PartInitException e) {
            if (editorId.equals("org.eclipse.ui.DefaultTextEditor")) {
                throw e;
            }
            return page.openEditor((IEditorInput)editorInput, "org.eclipse.ui.DefaultTextEditor");
        }
    }

    @Nullable
    public static IEditorPart openEditor(File file, IWorkbenchPage page) {
        if (!file.exists()) {
            return null;
        }
        Path path = new Path(file.getAbsolutePath());
        IFile ifile = ResourceUtil.getFileForLocation((IPath)path, (boolean)true);
        try {
            if (ifile != null) {
                return IDE.openEditor((IWorkbenchPage)page, (IFile)ifile, (boolean)OpenStrategy.activateOnOpen());
            }
            IFileStore store = EFS.getLocalFileSystem().getStore((IPath)path);
            return IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)store);
        }
        catch (PartInitException e) {
            Activator.handleError(UIText.EgitUiEditorUtils_openFailed, e, true);
            return null;
        }
    }

    public static IEditorPart findEditor(File file, IWorkbenchPage page) {
        if (!file.exists() || page == null) {
            return null;
        }
        Path path = new Path(file.getAbsolutePath());
        IFile iFile = ResourceUtil.getFileForLocation((IPath)path, (boolean)true);
        if (iFile != null) {
            return page.findEditor((IEditorInput)new FileEditorInput(iFile));
        }
        IFileStore store = EFS.getLocalFileSystem().getStore((IPath)path);
        return page.findEditor((IEditorInput)new FileStoreEditorInput(store));
    }

    private static IEditorDescriptor getEditor(FileRevisionEditorInput editorInput) {
        IContentType type;
        String fileName;
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(fileName = editorInput.getFileRevision().getName(), type = EgitUiEditorUtils.getContentType(editorInput));
        if (descriptor != null) {
            descriptor = IDE.overrideDefaultEditorAssociation((IEditorInput)editorInput, (IContentType)type, (IEditorDescriptor)descriptor);
        }
        if (descriptor == null) {
            descriptor = registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        return descriptor;
    }

    private static IContentType getContentType(FileRevisionEditorInput editorInput) {
        IContentType type = null;
        try {
            InputStream contents = editorInput.getStorage().getContents();
            try {
                type = EgitUiEditorUtils.getContentType(editorInput.getFileRevision().getName(), contents);
            }
            finally {
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (CoreException e) {
            Activator.handleError(e.getMessage(), e, false);
        }
        return type;
    }

    private static IContentType getContentType(String fileName, InputStream contents) {
        IContentType type = null;
        if (contents != null) {
            try {
                type = Platform.getContentTypeManager().findContentTypeFor(contents, fileName);
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, false);
            }
        }
        if (type == null) {
            type = Platform.getContentTypeManager().findContentTypeFor(fileName);
        }
        return type;
    }

    public static void revealLine(IEditorPart editor, int lineNo) {
        if (lineNo < 0) {
            return;
        }
        ITextEditor textEditor = EgitUiEditorUtils.getTextEditor(editor);
        if (textEditor == null) {
            return;
        }
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return;
        }
        try {
            textEditor.selectAndReveal(document.getLineOffset(lineNo), 0);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static ITextEditor getTextEditor(IEditorPart editor) {
        Object nestedEditor;
        if (editor instanceof ITextEditor) {
            return (ITextEditor)editor;
        }
        if (editor instanceof MultiPageEditorPart && (nestedEditor = ((MultiPageEditorPart)editor).getSelectedPage()) instanceof ITextEditor) {
            return (ITextEditor)nestedEditor;
        }
        return null;
    }
}

