/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.gef.commands.Command;

public class SetPositionCommand
extends Command {
    private final PositionableElement positionableElement;
    private Position oldPos;
    private Position newPos;

    public PositionableElement getPositionableElement() {
        return this.positionableElement;
    }

    private SetPositionCommand(PositionableElement positionableElement) {
        this.positionableElement = positionableElement;
        this.setLabel(Messages.ViewSetPositionCommand_LABEL_Move);
        if (positionableElement != null) {
            this.oldPos = this.getPositionableElement().getPosition();
        }
    }

    public SetPositionCommand(PositionableElement positionableElement, Position newPos) {
        this(positionableElement);
        this.setLabel(Messages.ViewSetPositionCommand_LABEL_Move);
        this.newPos = newPos;
    }

    public SetPositionCommand(PositionableElement positionableElement, double dx, double dy) {
        this(positionableElement, SetPositionCommand.createNewPosition(positionableElement.getPosition(), dx, dy));
    }

    @Deprecated
    public SetPositionCommand(PositionableElement positionableElement, int dx, int dy) {
        this(positionableElement);
        if (positionableElement != null) {
            this.newPos = SetPositionCommand.createNewPosition(this.oldPos, dx, dy);
        }
    }

    public boolean canExecute() {
        return this.positionableElement != null;
    }

    public void execute() {
        this.setPosition(this.newPos);
    }

    public void redo() {
        this.setPosition(this.newPos);
    }

    public void undo() {
        this.setPosition(this.oldPos);
    }

    private static Position createNewPosition(Position oldPos, double dx, double dy) {
        Position pos = LibraryElementFactory.eINSTANCE.createPosition();
        pos.setX(oldPos.getX() + dx);
        pos.setY(oldPos.getY() + dy);
        return pos;
    }

    private static Position createNewPosition(Position oldPos, int dx, int dy) {
        Position pos = LibraryElementFactory.eINSTANCE.createPosition();
        pos.setX(SetPositionCommand.newPosFromScreenDelta(dx, oldPos.getX()));
        pos.setY(SetPositionCommand.newPosFromScreenDelta(dy, oldPos.getY()));
        return pos;
    }

    private static double newPosFromScreenDelta(int delta, double oldPos) {
        int oldPosScreen = CoordinateConverter.INSTANCE.iec61499ToScreen(oldPos);
        return CoordinateConverter.INSTANCE.screenToIEC61499(oldPosScreen + delta);
    }

    protected void setPosition(Position pos) {
        this.positionableElement.setPosition(pos);
    }
}

