/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.bulkeditor.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.bulkeditor.editors.BulkEditorInput;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenBulkEditorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection iStructuredSelection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        if (iStructuredSelection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)iStructuredSelection;
            HashMap<IProject, List> projectMap = new HashMap<IProject, List>();
            Arrays.stream(treeSelection.getPaths()).forEach(treePath -> {
                IProject project = OpenBulkEditorHandler.getProjectFromPath(treePath);
                if (project == null) {
                    return;
                }
                projectMap.computeIfAbsent(project, key -> new ArrayList());
                Object object = treePath.getLastSegment();
                if (object instanceof UntypedSubApp) {
                    UntypedSubApp untypedSubapp = (UntypedSubApp)object;
                    ((List)projectMap.get(project)).add(EcoreUtil.getURI((EObject)untypedSubapp));
                } else {
                    IFile file;
                    TypeEntry typeEntry;
                    Object object2 = treePath.getLastSegment();
                    if (object2 instanceof IFile && (typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file = (IFile)object2)) instanceof SubAppTypeEntry) {
                        SubAppTypeEntry typeEntry2 = (SubAppTypeEntry)typeEntry;
                        ((List)projectMap.get(project)).add(EcoreUtil.getURI((EObject)typeEntry2.getType()));
                    }
                }
            });
            projectMap.forEach((project, subAppList) -> {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    window.getActivePage().openEditor((IEditorInput)new BulkEditorInput((IProject)project, (List<URI>)subAppList), "org.eclipse.fordiac.ide.bulkeditor.BulkEditor");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        return null;
    }

    private static IProject getProjectFromPath(TreePath treePath) {
        int i = 0;
        while (i < treePath.getSegmentCount()) {
            IProject project;
            Object object = treePath.getSegment(i);
            if (object instanceof IProject && (project = (IProject)object).isOpen()) {
                return project;
            }
            ++i;
        }
        return null;
    }
}

