/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.widgets;

import java.util.List;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeConditionEventCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeECTransitionCommentCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeTransitionDestinationCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.ChangeTransitionPriorityCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.CreateTransitionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.DeleteTransitionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.ECCContentAndLabelProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.StateContentProvider;
import org.eclipse.fordiac.ide.model.commands.change.ChangeConditionExpressionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderListWidget;
import org.eclipse.fordiac.ide.ui.widget.ComboBoxWidgetFactory;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class TransitionEditingComposite {
    private static final String TRANSITION_PRIORITY = "TransitionPriority";
    private static final String TRANSITION_DESTINATION = "TransitionDestination";
    private static final String TRANSITION_EVENT = "TransitionEvent";
    private static final String TRANSITION_CONDITION = "TransitionCondition";
    private static final String TRANSITION_COMMENT = "TransitionComment";
    private static final int TRANSITION_COLUMN_PRIORITY = 0;
    private static final int TRANSITION_COLUMN_DESTINATION = 1;
    private static final int TRANSITION_COLUMN_EVENT = 2;
    private static final int TRANSITION_COLUMN_CONDITION = 3;
    private static final int TRANSITION_COLUMN_COMMENT = 4;
    private TableViewer transitionsOutViewer;
    private final TabbedPropertySheetWidgetFactory transitionWidgetFactory;
    private final Group transitionGroup;
    private final CommandExecutor commandExecutor;
    private ECState type;
    private CommandStack commandStack;

    public TransitionEditingComposite(Composite parent, TabbedPropertySheetWidgetFactory transitionWidgetFactory, CommandExecutor commandExecutor) {
        this.transitionWidgetFactory = transitionWidgetFactory;
        this.transitionGroup = transitionWidgetFactory.createGroup(parent, Messages.TransitionEditingComposite_TransitionsFromSelectedState);
        this.commandExecutor = commandExecutor;
        this.type = null;
        this.commandStack = null;
        this.createGroupLayout();
    }

    private void createGroupLayout() {
        this.transitionGroup.setLayout((Layout)new GridLayout(2, false));
        this.transitionGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        AddDeleteReorderListWidget transitionMgmButtons = new AddDeleteReorderListWidget();
        transitionMgmButtons.createControls((Composite)this.transitionGroup, (FormToolkit)this.transitionWidgetFactory);
        this.transitionsOutViewer = TableWidgetFactory.createTableViewer((Composite)this.transitionGroup);
        this.configureTransitionTableLayout(this.transitionsOutViewer.getTable());
        this.transitionsOutViewer.setContentProvider((IContentProvider)new StateContentProvider());
        this.transitionsOutViewer.setLabelProvider((IBaseLabelProvider)new TransitionListLabelProvider());
        transitionMgmButtons.bindToTableViewer(this.transitionsOutViewer, this.commandExecutor, ref -> new CreateTransitionCommand(this.type, this.getBasicFBType().getECC().getStart(), null), ref -> new DeleteTransitionCommand((ECTransition)ref), ref -> new ChangeTransitionPriorityCommand(this.type, (ECTransition)ref, true), ref -> new ChangeTransitionPriorityCommand(this.type, (ECTransition)ref, false));
    }

    private void configureTransitionTableLayout(Table table) {
        TransitionEditingComposite.addColumn(table);
        TransitionEditingComposite.addColumn(table).setText(Messages.TransitionEditingComposite_ConfigureTransitionTableLayout_Destination);
        TransitionEditingComposite.addColumn(table).setText(Messages.TransitionEditingComposite_ConfigureTransitionTableLayout_Event);
        TransitionEditingComposite.addColumn(table).setText(Messages.TransitionEditingComposite_ConfigureTransitionTableLayout_Condition);
        TransitionEditingComposite.addColumn(table).setText(Messages.TransitionEditingComposite_ConfigureTransitionTableLayout_Comment);
        TableLayout tabLayout = new TableLayout();
        tabLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50));
        tabLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 50));
        tabLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 50));
        tabLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(4, 50));
        tabLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, 50));
        table.setLayout((Layout)tabLayout);
        this.transitionsOutViewer.setColumnProperties(new String[]{TRANSITION_PRIORITY, TRANSITION_DESTINATION, TRANSITION_EVENT, TRANSITION_CONDITION, TRANSITION_COMMENT});
    }

    private static TableColumn addColumn(Table table) {
        return new TableColumn(table, 16384);
    }

    private CellEditor[] createTransitionViewerCellEditors(Table table) {
        BasicFBType fbType = this.getBasicFBType();
        CellEditor[] cellEditorArray = new CellEditor[5];
        cellEditorArray[1] = ComboBoxWidgetFactory.createComboBoxCellEditor((Composite)table, (String[])ECCContentAndLabelProvider.getStateNames(fbType).toArray(new String[0]), (int)8);
        cellEditorArray[2] = ComboBoxWidgetFactory.createComboBoxCellEditor((Composite)table, (String[])ECCContentAndLabelProvider.getTransitionConditionEventNames(fbType).toArray(new String[0]), (int)8);
        cellEditorArray[3] = new TextCellEditor((Composite)table);
        cellEditorArray[4] = new TextCellEditor((Composite)table);
        return cellEditorArray;
    }

    private BasicFBType getBasicFBType() {
        return this.type.getECC().getBasicFBType();
    }

    public void refresh() {
        CommandStack commandStackBuffer = this.commandStack;
        this.commandStack = null;
        if (this.type != null) {
            this.transitionsOutViewer.setInput((Object)this.type);
        }
        this.commandStack = commandStackBuffer;
    }

    public void setTypeAndCommandStack(ECState type, CommandStack commandStack) {
        this.type = type;
        this.commandStack = commandStack;
        this.transitionsOutViewer.setCellEditors(this.createTransitionViewerCellEditors(this.transitionsOutViewer.getTable()));
        this.transitionsOutViewer.setCellModifier((ICellModifier)new TransitionViewerCellModifier());
    }

    private static class TransitionListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TransitionListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ECTransition) {
                ECTransition ecTransition = (ECTransition)element;
                switch (columnIndex) {
                    case 0: {
                        return Integer.toString(ecTransition.getPriority());
                    }
                    case 1: {
                        if (ecTransition.getDestination() == null) break;
                        return ecTransition.getDestination().getName();
                    }
                    case 2: {
                        if (ecTransition.getConditionEvent() == null) break;
                        return ECCContentAndLabelProvider.getEventName(ecTransition.getConditionEvent());
                    }
                    case 3: {
                        return ecTransition.getConditionExpression();
                    }
                    case 4: {
                        return ecTransition.getComment();
                    }
                }
            }
            return ECCContentAndLabelProvider.EMPTY_FIELD;
        }
    }

    private class TransitionViewerCellModifier
    implements ICellModifier {
        private TransitionViewerCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return !property.equals(TransitionEditingComposite.TRANSITION_PRIORITY);
        }

        public Object getValue(Object element, String property) {
            ECTransition selectedTransition = (ECTransition)element;
            return switch (property) {
                case TransitionEditingComposite.TRANSITION_DESTINATION -> {
                    List<String> dest = ECCContentAndLabelProvider.getStateNames(TransitionEditingComposite.this.getBasicFBType());
                    yield selectedTransition.getDestination() != null ? dest.indexOf(selectedTransition.getDestination().getName()) : dest.size();
                }
                case TransitionEditingComposite.TRANSITION_EVENT -> {
                    List<String> events = ECCContentAndLabelProvider.getTransitionConditionEventNames(TransitionEditingComposite.this.getBasicFBType());
                    yield selectedTransition.getConditionEvent() != null ? events.indexOf(selectedTransition.getConditionEvent().getName()) : events.size();
                }
                case TransitionEditingComposite.TRANSITION_CONDITION -> selectedTransition.getConditionExpression();
                case TransitionEditingComposite.TRANSITION_COMMENT -> selectedTransition.getComment();
                default -> "";
            };
        }

        public void modify(Object element, String property, Object value) {
            TableItem tableItem = (TableItem)element;
            ECTransition selectedTransition = (ECTransition)tableItem.getData();
            Command cmd = null;
            switch (property) {
                case "TransitionDestination": {
                    int selectedDest = (Integer)value;
                    List<ECState> destinations = ECCContentAndLabelProvider.getStates(TransitionEditingComposite.this.getBasicFBType());
                    ECState dest = selectedDest >= 0 && selectedDest < destinations.size() ? destinations.get(selectedDest) : null;
                    cmd = new ChangeTransitionDestinationCommand(selectedTransition, dest);
                    break;
                }
                case "TransitionEvent": {
                    int selectedEv = (Integer)value;
                    List<String> events = ECCContentAndLabelProvider.getTransitionConditionEventNames(TransitionEditingComposite.this.getBasicFBType());
                    String ev = selectedEv >= 0 && selectedEv < events.size() ? events.get(selectedEv) : null;
                    cmd = new ChangeConditionEventCommand(selectedTransition, ev);
                    break;
                }
                case "TransitionComment": {
                    cmd = new ChangeECTransitionCommentCommand(selectedTransition, (String)value);
                    break;
                }
                case "TransitionCondition": {
                    cmd = new ChangeConditionExpressionCommand(selectedTransition, (String)value);
                    break;
                }
            }
            if (cmd != null && TransitionEditingComposite.this.commandStack != null) {
                TransitionEditingComposite.this.commandStack.execute(cmd);
                this.refresh();
            }
        }

        private void refresh() {
            TransitionEditingComposite.this.transitionsOutViewer.setInput((Object)TransitionEditingComposite.this.type);
        }
    }
}

