% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-params.R
\name{tidyr_data_masking}
\alias{tidyr_data_masking}
\title{Argument type: data-masking}
\description{
This page describes the \verb{<data-masking>} argument modifier which
indicates that the argument uses \strong{data masking}, a sub-type of
tidy evaluation. If you've never heard of tidy evaluation before,
start with the practical introduction in
\url{https://r4ds.hadley.nz/functions.html#data-frame-functions} then
then read more about the underlying theory in
\url{https://rlang.r-lib.org/reference/topic-data-mask.html}.
}
\section{Key techniques}{
\itemize{
\item To allow the user to supply the column name in a function argument,
embrace the argument, e.g. \code{filter(df, {{ var }})}.

\if{html}{\out{<div class="sourceCode R">}}\preformatted{dist_summary <- function(df, var) \{
  df \%>\%
    summarise(n = n(), min = min(\{\{ var \}\}), max = max(\{\{ var \}\}))
\}
mtcars \%>\% dist_summary(mpg)
mtcars \%>\% group_by(cyl) \%>\% dist_summary(mpg)
}\if{html}{\out{</div>}}
\item To work with a column name recorded as a string, use the \code{.data}
pronoun, e.g. \code{summarise(df, mean = mean(.data[[var]]))}.

\if{html}{\out{<div class="sourceCode R">}}\preformatted{for (var in names(mtcars)) \{
  mtcars \%>\% count(.data[[var]]) \%>\% print()
\}

lapply(names(mtcars), function(var) mtcars \%>\% count(.data[[var]]))
}\if{html}{\out{</div>}}
\item To suppress \verb{R CMD check} \code{NOTE}s about unknown variables
use \code{.data$var} instead of \code{var}:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{# has NOTE
df \%>\% mutate(z = x + y)

# no NOTE
df \%>\% mutate(z = .data$x + .data$y)
}\if{html}{\out{</div>}}

You'll also need to import \code{.data} from rlang with (e.g.)
\verb{@importFrom rlang .data}.
}
}

\section{Dot-dot-dot (...)}{
\code{...} automatically provides indirection, so you can use it as is
(i.e. without embracing) inside a function:

\if{html}{\out{<div class="sourceCode">}}\preformatted{grouped_mean <- function(df, var, ...) \{
  df \%>\%
    group_by(...) \%>\%
    summarise(mean = mean(\{\{ var \}\}))
\}
}\if{html}{\out{</div>}}

You can also use \verb{:=} instead of \code{=} to enable a glue-like syntax for
creating variables from user supplied data:

\if{html}{\out{<div class="sourceCode">}}\preformatted{var_name <- "l100km"
mtcars \%>\% mutate("\{var_name\}" := 235 / mpg)

summarise_mean <- function(df, var) \{
  df \%>\%
    summarise("mean_of_\{\{var\}\}" := mean(\{\{ var \}\}))
\}
mtcars \%>\% group_by(cyl) \%>\% summarise_mean(mpg)
}\if{html}{\out{</div>}}

Learn more in \url{https://rlang.r-lib.org/reference/topic-data-mask-programming.html}.
}

\keyword{internal}
