% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_fun.R
\name{output_table}
\alias{output_table}
\alias{output_figure}
\alias{output_eval}
\alias{output_raw}
\alias{output_str}
\alias{output_shell}
\title{Output filters for code blocks in markdown}
\usage{
output_table(code, language = "R", id = "", ...)

output_figure(code, language = "R", id = "", ...)

output_eval(
  code,
  language = "R",
  id = "",
  echo = TRUE,
  results = TRUE,
  drop_empty = TRUE,
  eval = TRUE,
  formatter = getOption("md_formatter", default = format_traditional),
  capture_warnings = FALSE,
  capture_messages = results,
  muffle_warnings = FALSE,
  muffle_messages = TRUE,
  ...
)

output_raw(code, language = "R", id = "", ...)

output_str(code, language = "R", id = "", ...)

output_shell(
  code,
  language,
  id = "",
  cmd = language,
  echo = TRUE,
  results = TRUE,
  comment_char = "# ",
  ...
)
}
\arguments{
\item{code}{character vector containing the code of the code block}

\item{language}{the language in which the code is written (as specified in
the markdown file).}

\item{id}{the identifier of the code block.}

\item{...}{additional arguments specified as arguments in the code block are
passed on to the filter function. Often these are ignored, or they are
passed on to other functions (see 'Details').}

\item{echo}{the code in \code{code} is repeated in the output.}

\item{results}{include the results of running the code in the output. The
output of code that explicitly writes to standard output is always
included.}

\item{drop_empty}{do not include any output if the resulting code block
would be empty.}

\item{eval}{if FALSE do not run the code and just include the code in the
output.}

\item{formatter}{function that will format the R-code and resulting output
(if requested). See \code{\link{format_traditional}} for possible options.}

\item{capture_warnings}{include warnings in the output.}

\item{capture_messages}{include messages in the output.}

\item{muffle_warnings}{do not show warnings in the console.}

\item{muffle_messages}{do not show messages in the console.}

\item{cmd}{the command to use in the \code{\link{system2}} call. Only needed
when different than the language.}

\item{comment_char}{string prepended to output of commands run by
\code{output_shell}.}
}
\value{
The functions either return a character vector with markdown,
or return a list with the correct structure to include in the pandoc parse
tree.
}
\description{
Output filters for code blocks in markdown
}
\details{
The filter functions \code{output_table} and \code{output_figure} call
\code{\link{md_table}} and \code{\link{md_figure}} respectively; additional
arguments are passed on to those functions. Other filter functions ignore the
additional arguments.

It is also possible to write custom output filter. An output filter should have
\code{code}, \code{language} and \code{id} as its first three arguments. It
should either return a character vector containing the markdown that should be
included in the resulting markdown file or an object that can be directly
included in the pandoc parse tree. If the function does not return a character
vector it is assumed the latter is returned. \code{simplermarkdown} defines a
small number of valid object constructors: \code{\link{raw_block}} and
\code{\link{markdown_block}}.

The custom function should be available when running the markdown document
through pandoc. The easiest way is to \code{\link{source}} or define the
function in the markdown document before using it.

The filter function \code{output_shell} can be used to process chunks of code
from other languages than R. These chunks of code are written to a temporary
file which is then ran using the \code{cmd} using a call to
\code{\link{system2}}. The output of that is captured and when \code{results
= TRUE} included in the output. The output lines are prepended by
\code{comment_char}. When \code{echo = TRUE} the code is also included before
the output.
}
