% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/dimreduc.R, R/seurat.R
\name{FetchData}
\alias{FetchData}
\alias{FetchData.DimReduc}
\alias{FetchData.Seurat}
\title{Access cellular data}
\usage{
FetchData(object, ...)

\method{FetchData}{DimReduc}(object, vars, cells = NULL, ...)

\method{FetchData}{Seurat}(
  object,
  vars,
  cells = NULL,
  layer = NULL,
  clean = TRUE,
  slot = deprecated(),
  ...
)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{vars}{List of all variables to fetch, use keyword \dQuote{ident} to
pull identity classes}

\item{cells}{Cells to collect data for (default is all cells)}

\item{layer}{Layer to pull feature data for}

\item{clean}{Remove cells that are missing data; choose from:
\itemize{
 \item \dQuote{\code{all}}: consider all columns for cleaning
 \item \dQuote{\code{ident}}: consider all columns except the identity
  class for cleaning
 \item \dQuote{\code{project}}: consider all columns except the identity
  class for cleaning; fill missing identity values with the object's project
 \item \dQuote{\code{none}}: do not clean
}
Passing \code{TRUE} is a shortcut for \dQuote{\code{ident}}; passing
\code{FALSE} is a shortcut for \dQuote{\code{none}}}

\item{slot}{Deprecated in favor of \code{layer}}
}
\value{
A data frame with cells as rows and cellular data as columns
}
\description{
Retrieves data (feature expression, PCA scores, metrics, etc.) for a set
of cells in a Seurat object
}
\examples{
pc1 <- FetchData(object = pbmc_small, vars = 'PC_1')
head(x = pc1)
head(x = FetchData(object = pbmc_small, vars = c('groups', 'ident')))

}
\concept{data-access}
