##' rncl: An R interface to the NEXUS Class Library
##'
##' rncl provides an interface to the NEXUS Class Library (NCL), a C++
##' library intended to parse valid NEXUS files as well as other
##' common formats used in phylogenetic analysis. Currently, rncl
##' focuses on parsing trees and supports both NEXUS and Newick
##' formatted files. Because NCL is used by several phylogenetic
##' software (e.g., MrBayes, Garli), rncl can parse files generated by
##' these programs. However, other popular programs (including BEAST)
##' use an extension of the NEXUS file format, and if trees can be
##' imported, associated annotations (e.g., confidence intervals on
##' the time since divergence) cannot.
##'
##' NCL can also parse data associated with species included in NEXUS
##' files. If you are interested in importing such data, see the
##' phylobase package.
##'
##' @name rncl
##' @docType package
##' @useDynLib rncl
##' @importFrom Rcpp evalCpp
NULL
