% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixRegressionTable.R
\name{fixRegressionTable}
\alias{fixRegressionTable}
\title{Expand regression coefficient table}
\usage{
fixRegressionTable(
  x,
  varnames,
  reference.value,
  reference.style = NULL,
  factorlevels,
  scale = NULL,
  nmiss,
  intercept
)
}
\arguments{
\item{x}{object resulting from \code{lm}, \code{glm} or \code{coxph}.}

\item{varnames}{Names of variables}

\item{reference.value}{Reference value for reference categories}

\item{reference.style}{Style for showing results for categorical
variables. If \code{"extraline"} show an additional line for the
reference category.}

\item{factorlevels}{Levels of the categorical variables.}

\item{scale}{Scale for some or all of the variables}

\item{nmiss}{Number of missing values}

\item{intercept}{Intercept}
}
\value{
a table with regression coefficients
}
\description{
Expand regression coefficient table
}
\details{
This function expands results from "regressionTable" with
extralines and columns

For factor variables the reference group is shown.
For continuous variables the units are shown and
for transformed continuous variables also the scale.
For all variables the numbers of missing values are added.
}
\author{
Thomas Alexander Gerds <tag@biostat.ku.dk>
}
