% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-sql-write-table.R
\docType{data}
\name{spec_sql_write_table}
\alias{spec_sql_write_table}
\title{spec_sql_write_table}
\value{
\code{dbWriteTable()} returns \code{TRUE}, invisibly.
}
\description{
spec_sql_write_table
}
\section{Failure modes}{

If the table exists, and both \code{append} and \code{overwrite} arguments are unset,
or \code{append = TRUE} and the data frame with the new data has different
column names,
an error is raised; the remote table remains unchanged.

An error is raised when calling this method for a closed
or invalid connection.
An error is also raised
if \code{name} cannot be processed with \code{\link[DBI:dbQuoteIdentifier]{DBI::dbQuoteIdentifier()}} or
if this results in a non-scalar.
Invalid values for the additional arguments \code{row.names},
\code{overwrite}, \code{append}, \code{field.types}, and \code{temporary}
(non-scalars,
unsupported data types,
\code{NA},
incompatible values,
duplicate
or missing names,
incompatible columns)
also raise an error.
}

\section{Additional arguments}{

The following arguments are not part of the \code{dbWriteTable()} generic
(to improve compatibility across backends)
but are part of the DBI specification:
\itemize{
\item \code{row.names} (default: \code{FALSE})
\item \code{overwrite} (default: \code{FALSE})
\item \code{append} (default: \code{FALSE})
\item \code{field.types} (default: \code{NULL})
\item \code{temporary} (default: \code{FALSE})
}

They must be provided as named arguments.
See the "Specification" and "Value" sections for details on their usage.
}

\section{Specification}{

The \code{name} argument is processed as follows,
to support databases that allow non-syntactic names for their objects:
\itemize{
\item If an unquoted table name as string: \code{dbWriteTable()} will do the quoting,
perhaps by calling \code{dbQuoteIdentifier(conn, x = name)}
\item If the result of a call to \code{\link[DBI:dbQuoteIdentifier]{DBI::dbQuoteIdentifier()}}: no more quoting is done
}

The \code{value} argument must be a data frame
with a subset of the columns of the existing table if \code{append = TRUE}.
The order of the columns does not matter with \code{append = TRUE}.

If the \code{overwrite} argument is \code{TRUE}, an existing table of the same name
will be overwritten.
This argument doesn't change behavior if the table does not exist yet.

If the \code{append} argument is \code{TRUE}, the rows in an existing table are
preserved, and the new data are appended.
If the table doesn't exist yet, it is created.

If the \code{temporary} argument is \code{TRUE}, the table is not available in a
second connection and is gone after reconnecting.
Not all backends support this argument.
A regular, non-temporary table is visible in a second connection,
in a pre-existing connection,
and after reconnecting to the database.

SQL keywords can be used freely in table names, column names, and data.
Quotes, commas, spaces, and other special characters such as newlines and tabs,
can also be used in the data,
and, if the database supports non-syntactic identifiers,
also for table names
and column names.

The following data types must be supported at least,
and be read identically with \code{\link[DBI:dbReadTable]{DBI::dbReadTable()}}:
\itemize{
\item integer
\item numeric
(the behavior for \code{Inf} and \code{NaN} is not specified)
\item logical
\item \code{NA} as NULL
\item 64-bit values (using \code{"bigint"} as field type); the result can be
\itemize{
\item converted to a numeric, which may lose precision,
\item converted a character vector, which gives the full decimal
representation
\item written to another table and read again unchanged
}
\item character (in both UTF-8
and native encodings),
supporting empty strings
before and after a non-empty string
\item factor (returned as character)
\item list of raw
(if supported by the database)
\item objects of type \link[blob:blob]{blob::blob}
(if supported by the database)
\item date
(if supported by the database;
returned as \code{Date}),
also for dates prior to 1970 or 1900 or after 2038
\item time
(if supported by the database;
returned as objects that inherit from \code{difftime})
\item timestamp
(if supported by the database;
returned as \code{POSIXct}
respecting the time zone but not necessarily preserving the
input time zone),
also for timestamps prior to 1970 or 1900 or after 2038
respecting the time zone but not necessarily preserving the
input time zone)
}

Mixing column types in the same table is supported.

The \code{field.types} argument must be a named character vector with at most
one entry for each column.
It indicates the SQL data type to be used for a new column.
If a column is missed from \code{field.types}, the type is inferred
from the input data with \code{\link[DBI:dbDataType]{DBI::dbDataType()}}.

The interpretation of \link{rownames} depends on the \code{row.names} argument,
see \code{\link[DBI:rownames]{DBI::sqlRownamesToColumn()}} for details:
\itemize{
\item If \code{FALSE} or \code{NULL}, row names are ignored.
\item If \code{TRUE}, row names are converted to a column named "row_names",
even if the input data frame only has natural row names from 1 to \code{nrow(...)}.
\item If \code{NA}, a column named "row_names" is created if the data has custom row names,
no extra column is created in the case of natural row names.
\item If a string, this specifies the name of the column in the remote table
that contains the row names,
even if the input data frame only has natural row names.
}

The default is \code{row.names = FALSE}.
}

\seealso{
Other sql specifications: 
\code{\link{spec_sql_append_table}},
\code{\link{spec_sql_create_table}},
\code{\link{spec_sql_exists_table}},
\code{\link{spec_sql_list_fields}},
\code{\link{spec_sql_list_objects}},
\code{\link{spec_sql_list_tables}},
\code{\link{spec_sql_quote_identifier}},
\code{\link{spec_sql_quote_literal}},
\code{\link{spec_sql_quote_string}},
\code{\link{spec_sql_read_table}},
\code{\link{spec_sql_remove_table}},
\code{\link{spec_sql_unquote_identifier}}
}
\concept{sql specifications}
