from __future__ import annotations

from .other_classes import DotDict

theme_light_blue: dict[str, str] = DotDict(
    {
        "popup_menu_fg": "#000000",
        "popup_menu_bg": "#FFFFFF",
        "popup_menu_highlight_bg": "#DCDEE0",
        "popup_menu_highlight_fg": "#000000",
        "index_hidden_rows_expander_bg": "#747775",
        "header_hidden_columns_expander_bg": "#747775",
        "header_bg": "#FFFFFF",
        "header_border_fg": "#C4C7C5",
        "header_grid_fg": "#C4C7C5",
        "header_fg": "#444746",
        "header_editor_bg": "#FFFFFF",
        "header_editor_fg": "#444746",
        "header_editor_select_bg": "#cfd1d1",
        "header_editor_select_fg": "#000000",
        "header_selected_cells_bg": "#D3E3FD",
        "header_selected_cells_fg": "black",
        "index_bg": "#FFFFFF",
        "index_border_fg": "#C4C7C5",
        "index_grid_fg": "#C4C7C5",
        "index_fg": "black",
        "index_editor_bg": "#FFFFFF",
        "index_editor_fg": "black",
        "index_editor_select_bg": "#cfd1d1",
        "index_editor_select_fg": "#000000",
        "index_selected_cells_bg": "#D3E3FD",
        "index_selected_cells_fg": "black",
        "top_left_bg": "#F9FBFD",
        "top_left_fg": "#d9d9d9",
        "top_left_fg_highlight": "#747775",
        "table_bg": "#FFFFFF",
        "table_grid_fg": "#E1E1E1",
        "table_fg": "black",
        "table_editor_bg": "#FFFFFF",
        "table_editor_fg": "black",
        "table_editor_select_bg": "#cfd1d1",
        "table_editor_select_fg": "#000000",
        "table_selected_box_cells_fg": "#0B57D0",
        "table_selected_box_rows_fg": "#0B57D0",
        "table_selected_box_columns_fg": "#0B57D0",
        "table_selected_cells_border_fg": "#0B57D0",
        "table_selected_cells_bg": "#E6EFFD",
        "table_selected_cells_fg": "black",
        "resizing_line_fg": "black",
        "drag_and_drop_bg": "#0B57D0",
        "outline_color": "gray2",
        "header_selected_columns_bg": "#0B57D0",
        "header_selected_columns_fg": "#FFFFFF",
        "index_selected_rows_bg": "#0B57D0",
        "index_selected_rows_fg": "#FFFFFF",
        "table_selected_rows_border_fg": "#0B57D0",
        "table_selected_rows_bg": "#E6EFFD",
        "table_selected_rows_fg": "black",
        "table_selected_columns_border_fg": "#0B57D0",
        "table_selected_columns_bg": "#E6EFFD",
        "table_selected_columns_fg": "black",
        "tree_arrow_fg": "black",
        "selected_cells_tree_arrow_fg": "black",
        "selected_rows_tree_arrow_fg": "#FFFFFF",
        "vertical_scroll_background": "#FFFFFF",
        "horizontal_scroll_background": "#FFFFFF",
        "vertical_scroll_troughcolor": "#f9fbfd",
        "horizontal_scroll_troughcolor": "#f9fbfd",
        "vertical_scroll_lightcolor": "#FFFFFF",
        "horizontal_scroll_lightcolor": "#FFFFFF",
        "vertical_scroll_darkcolor": "gray50",
        "horizontal_scroll_darkcolor": "gray50",
        "vertical_scroll_relief": "flat",
        "horizontal_scroll_relief": "flat",
        "vertical_scroll_troughrelief": "flat",
        "horizontal_scroll_troughrelief": "flat",
        "vertical_scroll_bordercolor": "#f9fbfd",
        "horizontal_scroll_bordercolor": "#f9fbfd",
        "vertical_scroll_active_bg": "#bdc1c6",
        "horizontal_scroll_active_bg": "#bdc1c6",
        "vertical_scroll_not_active_bg": "#DADCE0",
        "horizontal_scroll_not_active_bg": "#DADCE0",
        "vertical_scroll_pressed_bg": "#bdc1c6",
        "horizontal_scroll_pressed_bg": "#bdc1c6",
        "vertical_scroll_active_fg": "#bdc1c6",
        "horizontal_scroll_active_fg": "#bdc1c6",
        "vertical_scroll_not_active_fg": "#DADCE0",
        "horizontal_scroll_not_active_fg": "#DADCE0",
        "vertical_scroll_pressed_fg": "#bdc1c6",
        "horizontal_scroll_pressed_fg": "#bdc1c6",
    }
)

theme_light_green: dict[str, str] = DotDict(
    {
        "popup_menu_fg": "#000000",
        "popup_menu_bg": "#FFFFFF",
        "popup_menu_highlight_bg": "#DCDEE0",
        "popup_menu_highlight_fg": "#000000",
        "index_hidden_rows_expander_bg": "gray30",
        "header_hidden_columns_expander_bg": "gray30",
        "header_bg": "#F5F5F5",
        "header_border_fg": "#ababab",
        "header_grid_fg": "#ababab",
        "header_fg": "black",
        "header_editor_bg": "#F5F5F5",
        "header_editor_fg": "black",
        "header_editor_select_bg": "#cfd1d1",
        "header_editor_select_fg": "#000000",
        "header_selected_cells_bg": "#CAEAD8",
        "header_selected_cells_fg": "#217346",
        "index_bg": "#F5F5F5",
        "index_border_fg": "#ababab",
        "index_grid_fg": "#ababab",
        "index_fg": "black",
        "index_editor_bg": "#F5F5F5",
        "index_editor_fg": "black",
        "index_editor_select_bg": "#cfd1d1",
        "index_editor_select_fg": "#000000",
        "index_selected_cells_bg": "#CAEAD8",
        "index_selected_cells_fg": "#107C41",
        "top_left_bg": "#F5F5F5",
        "top_left_fg": "#d9d9d9",
        "top_left_fg_highlight": "#5f6368",
        "table_bg": "#FFFFFF",
        "table_grid_fg": "#bfbfbf",
        "table_fg": "black",
        "table_editor_bg": "#FFFFFF",
        "table_editor_fg": "black",
        "table_editor_select_bg": "#cfd1d1",
        "table_editor_select_fg": "#000000",
        "table_selected_box_cells_fg": "#107C41",
        "table_selected_box_rows_fg": "#107C41",
        "table_selected_box_columns_fg": "#107C41",
        "table_selected_cells_border_fg": "#107C41",
        "table_selected_cells_bg": "#E3E3E3",
        "table_selected_cells_fg": "black",
        "resizing_line_fg": "black",
        "drag_and_drop_bg": "#107C41",
        "outline_color": "gray2",
        "header_selected_columns_bg": "#107C41",
        "header_selected_columns_fg": "#FFFFFF",
        "index_selected_rows_bg": "#107C41",
        "index_selected_rows_fg": "#FFFFFF",
        "table_selected_rows_border_fg": "#107C41",
        "table_selected_rows_bg": "#E3E3E3",
        "table_selected_rows_fg": "black",
        "table_selected_columns_border_fg": "#107C41",
        "table_selected_columns_bg": "#E3E3E3",
        "table_selected_columns_fg": "black",
        "tree_arrow_fg": "black",
        "selected_cells_tree_arrow_fg": "#107C41",
        "selected_rows_tree_arrow_fg": "#FFFFFF",
        "vertical_scroll_background": "#FFFFFF",
        "horizontal_scroll_background": "#FFFFFF",
        "vertical_scroll_troughcolor": "#f1f1f1",
        "horizontal_scroll_troughcolor": "#f1f1f1",
        "vertical_scroll_lightcolor": "#FFFFFF",
        "horizontal_scroll_lightcolor": "#FFFFFF",
        "vertical_scroll_darkcolor": "gray50",
        "horizontal_scroll_darkcolor": "gray50",
        "vertical_scroll_relief": "flat",
        "horizontal_scroll_relief": "flat",
        "vertical_scroll_troughrelief": "flat",
        "horizontal_scroll_troughrelief": "flat",
        "vertical_scroll_bordercolor": "#f1f1f1",
        "horizontal_scroll_bordercolor": "#f1f1f1",
        "vertical_scroll_active_bg": "#707070",
        "horizontal_scroll_active_bg": "#707070",
        "vertical_scroll_not_active_bg": "#c1c1c1",
        "horizontal_scroll_not_active_bg": "#c1c1c1",
        "vertical_scroll_pressed_bg": "#707070",
        "horizontal_scroll_pressed_bg": "#707070",
        "vertical_scroll_active_fg": "#707070",
        "horizontal_scroll_active_fg": "#707070",
        "vertical_scroll_not_active_fg": "#c1c1c1",
        "horizontal_scroll_not_active_fg": "#c1c1c1",
        "vertical_scroll_pressed_fg": "#707070",
        "horizontal_scroll_pressed_fg": "#707070",
    }
)

theme_dark: dict[str, str] = DotDict(
    {
        "popup_menu_fg": "white",
        "popup_menu_bg": "gray15",
        "popup_menu_highlight_bg": "gray40",
        "popup_menu_highlight_fg": "white",
        "index_hidden_rows_expander_bg": "gray30",
        "header_hidden_columns_expander_bg": "gray30",
        "header_bg": "#141414",
        "header_border_fg": "#505054",
        "header_grid_fg": "#8C8C8C",
        "header_fg": "gray70",
        "header_editor_bg": "#141414",
        "header_editor_fg": "gray70",
        "header_editor_select_bg": "#60696e",
        "header_editor_select_fg": "#FFFFFF",
        "header_selected_cells_bg": "#4b4b4b",
        "header_selected_cells_fg": "#6aa2fc",
        "index_bg": "#141414",
        "index_border_fg": "#505054",
        "index_grid_fg": "#8C8C8C",
        "index_fg": "gray70",
        "index_editor_bg": "#141414",
        "index_editor_fg": "gray70",
        "index_editor_select_bg": "#60696e",
        "index_editor_select_fg": "#FFFFFF",
        "index_selected_cells_bg": "#4b4b4b",
        "index_selected_cells_fg": "#6aa2fc",
        "top_left_bg": "#28282a",
        "top_left_fg": "#505054",
        "top_left_fg_highlight": "white",
        "table_bg": "#000000",
        "table_grid_fg": "#595959",
        "table_fg": "#E3E3E3",
        "table_editor_bg": "#000000",
        "table_editor_fg": "#E3E3E3",
        "table_editor_select_bg": "#60696e",
        "table_editor_select_fg": "#FFFFFF",
        "table_selected_box_cells_fg": "#6aa2fc",
        "table_selected_box_rows_fg": "#6aa2fc",
        "table_selected_box_columns_fg": "#6aa2fc",
        "table_selected_cells_border_fg": "#6aa2fc",
        "table_selected_cells_bg": "#404040",
        "table_selected_cells_fg": "#F7F7F7",
        "resizing_line_fg": "white",
        "drag_and_drop_bg": "#ecf0f2",
        "outline_color": "gray95",
        "header_selected_columns_bg": "#4489F7",
        "header_selected_columns_fg": "white",
        "index_selected_rows_bg": "#4489F7",
        "index_selected_rows_fg": "white",
        "table_selected_rows_border_fg": "#4489F7",
        "table_selected_rows_bg": "#404040",
        "table_selected_rows_fg": "#F7F7F7",
        "table_selected_columns_border_fg": "#4489F7",
        "table_selected_columns_bg": "#404040",
        "table_selected_columns_fg": "#F7F7F7",
        "tree_arrow_fg": "#8C8C8C",
        "selected_cells_tree_arrow_fg": "#6aa2fc",
        "selected_rows_tree_arrow_fg": "white",
        "vertical_scroll_background": "#3b3b3d",
        "horizontal_scroll_background": "#3b3b3d",
        "vertical_scroll_troughcolor": "#000000",
        "horizontal_scroll_troughcolor": "#000000",
        "vertical_scroll_lightcolor": "gray50",
        "horizontal_scroll_lightcolor": "gray50",
        "vertical_scroll_darkcolor": "gray20",
        "horizontal_scroll_darkcolor": "gray20",
        "vertical_scroll_relief": "flat",
        "horizontal_scroll_relief": "flat",
        "vertical_scroll_troughrelief": "flat",
        "horizontal_scroll_troughrelief": "flat",
        "vertical_scroll_bordercolor": "#000000",
        "horizontal_scroll_bordercolor": "#000000",
        "vertical_scroll_active_bg": "#a0a0a0",
        "horizontal_scroll_active_bg": "#a0a0a0",
        "vertical_scroll_not_active_bg": "#3b3b3d",
        "horizontal_scroll_not_active_bg": "#3b3b3d",
        "vertical_scroll_pressed_bg": "#a0a0a0",
        "horizontal_scroll_pressed_bg": "#a0a0a0",
        "vertical_scroll_active_fg": "#a0a0a0",
        "horizontal_scroll_active_fg": "#a0a0a0",
        "vertical_scroll_not_active_fg": "#3b3b3d",
        "horizontal_scroll_not_active_fg": "#3b3b3d",
        "vertical_scroll_pressed_fg": "#a0a0a0",
        "horizontal_scroll_pressed_fg": "#a0a0a0",
    }
)

theme_black: dict[str, str] = DotDict(
    {
        "popup_menu_fg": "white",
        "popup_menu_bg": "gray15",
        "popup_menu_highlight_bg": "gray40",
        "popup_menu_highlight_fg": "white",
        "index_hidden_rows_expander_bg": "gray30",
        "header_hidden_columns_expander_bg": "gray30",
        "header_bg": "#000000",
        "header_border_fg": "#505054",
        "header_grid_fg": "#8C8C8C",
        "header_fg": "#FBB86C",
        "header_editor_bg": "#000000",
        "header_editor_fg": "#FBB86C",
        "header_editor_select_bg": "#545c61",
        "header_editor_select_fg": "#FBB86C",
        "header_selected_cells_bg": "#4b4b4b",
        "header_selected_cells_fg": "#FBB86C",
        "index_bg": "#000000",
        "index_border_fg": "#505054",
        "index_grid_fg": "#8C8C8C",
        "index_fg": "#FBB86C",
        "index_editor_bg": "#000000",
        "index_editor_fg": "#FBB86C",
        "index_editor_select_bg": "#545c61",
        "index_editor_select_fg": "#FBB86C",
        "index_selected_cells_bg": "#4b4b4b",
        "index_selected_cells_fg": "#FBB86C",
        "top_left_bg": "#141416",
        "top_left_fg": "#505054",
        "top_left_fg_highlight": "#FBB86C",
        "table_bg": "#000000",
        "table_grid_fg": "#595959",
        "table_fg": "#E3E3E3",
        "table_editor_bg": "#000000",
        "table_editor_fg": "#E3E3E3",
        "table_editor_select_bg": "#545c61",
        "table_editor_select_fg": "#E3E3E3",
        "table_selected_box_cells_fg": "#FBB86C",
        "table_selected_box_rows_fg": "#FBB86C",
        "table_selected_box_columns_fg": "#FBB86C",
        "table_selected_cells_border_fg": "#FBB86C",
        "table_selected_cells_bg": "#404040",
        "table_selected_cells_fg": "#F7F7F7",
        "resizing_line_fg": "white",
        "drag_and_drop_bg": "#ecf0f2",
        "outline_color": "gray95",
        "header_selected_columns_bg": "#FBB86C",
        "header_selected_columns_fg": "#000000",
        "index_selected_rows_bg": "#FBB86C",
        "index_selected_rows_fg": "#000000",
        "table_selected_rows_border_fg": "#FBB86C",
        "table_selected_rows_bg": "#404040",
        "table_selected_rows_fg": "#F7F7F7",
        "table_selected_columns_border_fg": "#FBB86C",
        "table_selected_columns_bg": "#404040",
        "table_selected_columns_fg": "#F7F7F7",
        "tree_arrow_fg": "#8C8C8C",
        "selected_cells_tree_arrow_fg": "#FBB86C",
        "selected_rows_tree_arrow_fg": "#000000",
        "vertical_scroll_background": "#3b3a39",
        "horizontal_scroll_background": "#3b3a39",
        "vertical_scroll_troughcolor": "#000000",
        "horizontal_scroll_troughcolor": "#000000",
        "vertical_scroll_lightcolor": "gray50",
        "horizontal_scroll_lightcolor": "gray50",
        "vertical_scroll_darkcolor": "gray20",
        "horizontal_scroll_darkcolor": "gray20",
        "vertical_scroll_relief": "flat",
        "horizontal_scroll_relief": "flat",
        "vertical_scroll_troughrelief": "flat",
        "horizontal_scroll_troughrelief": "flat",
        "vertical_scroll_bordercolor": "#000000",
        "horizontal_scroll_bordercolor": "#000000",
        "vertical_scroll_active_bg": "#a0a0a0",
        "horizontal_scroll_active_bg": "#a0a0a0",
        "vertical_scroll_not_active_bg": "#3b3a39",
        "horizontal_scroll_not_active_bg": "#3b3a39",
        "vertical_scroll_pressed_bg": "#a0a0a0",
        "horizontal_scroll_pressed_bg": "#a0a0a0",
        "vertical_scroll_active_fg": "#a0a0a0",
        "horizontal_scroll_active_fg": "#a0a0a0",
        "vertical_scroll_not_active_fg": "#3b3a39",
        "horizontal_scroll_not_active_fg": "#3b3a39",
        "vertical_scroll_pressed_fg": "#a0a0a0",
        "horizontal_scroll_pressed_fg": "#a0a0a0",
    }
)

theme_dark_blue: dict[str, str] = DotDict(theme_dark.copy())
theme_dark_blue["top_left_fg_highlight"] = "#94EBEB"
theme_dark_blue["table_selected_box_cells_fg"] = "#94EBEB"
theme_dark_blue["table_selected_box_rows_fg"] = "#94EBEB"
theme_dark_blue["table_selected_box_columns_fg"] = "#94EBEB"
theme_dark_blue["table_selected_cells_border_fg"] = "#94EBEB"
theme_dark_blue["table_selected_rows_border_fg"] = "#94EBEB"
theme_dark_blue["table_selected_columns_border_fg"] = "#94EBEB"
theme_dark_blue["header_fg"] = "#94EBEB"
theme_dark_blue["header_selected_cells_fg"] = "#94EBEB"
theme_dark_blue["header_selected_columns_fg"] = "#000000"
theme_dark_blue["header_selected_columns_bg"] = "#94EBEB"
theme_dark_blue["index_fg"] = "#94EBEB"
theme_dark_blue["index_selected_rows_bg"] = "#94EBEB"
theme_dark_blue["index_selected_rows_fg"] = "#000000"
theme_dark_blue["index_selected_cells_fg"] = "#94EBEB"
theme_dark_blue["selected_rows_tree_arrow_fg"] = "#000000"
theme_dark_blue["selected_cells_tree_arrow_fg"] = "#94EBEB"
theme_dark_blue["header_editor_fg"] = "#94EBEB"
theme_dark_blue["header_editor_select_fg"] = "#94EBEB"
theme_dark_blue["index_editor_fg"] = "#94EBEB"
theme_dark_blue["index_editor_select_fg"] = "#94EBEB"
theme_dark_blue["header_editor_select_bg"] = "#545c61"
theme_dark_blue["index_editor_select_bg"] = "#545c61"
theme_dark_blue["table_editor_select_bg"] = "#545c61"


theme_dark_green: dict[str, str] = DotDict(theme_dark.copy())
theme_dark_green["header_fg"] = "#66FFBF"
theme_dark_green["header_selected_cells_fg"] = "#66FFBF"
theme_dark_green["index_fg"] = "#66FFBF"
theme_dark_green["index_selected_cells_fg"] = "#66FFBF"
theme_dark_green["top_left_fg_highlight"] = "#66FFBF"
theme_dark_green["table_selected_box_cells_fg"] = "#66FFBF"
theme_dark_green["table_selected_box_rows_fg"] = "#66FFBF"
theme_dark_green["table_selected_box_columns_fg"] = "#66FFBF"
theme_dark_green["table_selected_cells_border_fg"] = "#66FFBF"
theme_dark_green["header_selected_columns_bg"] = "#66FFBF"
theme_dark_green["header_selected_columns_fg"] = "#000000"
theme_dark_green["index_selected_rows_bg"] = "#66FFBF"
theme_dark_green["index_selected_rows_fg"] = "#000000"
theme_dark_green["table_selected_rows_border_fg"] = "#66FFBF"
theme_dark_green["table_selected_columns_border_fg"] = "#66FFBF"
theme_dark_green["selected_rows_tree_arrow_fg"] = "#000000"
theme_dark_green["selected_cells_tree_arrow_fg"] = "#000000"
theme_dark_green["header_editor_fg"] = "#66FFBF"
theme_dark_green["header_editor_select_fg"] = "#66FFBF"
theme_dark_green["index_editor_fg"] = "#66FFBF"
theme_dark_green["index_editor_select_fg"] = "#66FFBF"
theme_dark_green["header_editor_select_bg"] = "#545c61"
theme_dark_green["index_editor_select_bg"] = "#545c61"
theme_dark_green["table_editor_select_bg"] = "#545c61"
