# This file is auto-generated by /codegen/x86_64_test_encoding.py
# Reference opcodes are generated by:
#     GNU assembler (GNU Binutils) 2.28.51.20170402

from peachpy.x86_64 import *
import unittest


class TestMOVSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x10, 0xCE]), MOVSS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x10, 0x4C, 0xCC, 0x9D]), MOVSS(xmm1, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xF3, 0x45, 0x0F, 0x11, 0x74, 0xCC, 0x9D]), MOVSS(dword[r12 + rcx*8 - 99], xmm14).encode())


class TestEXTRACTPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x44, 0x0F, 0x3A, 0x17, 0xF5, 0x02]), EXTRACTPS(ebp, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0x3A, 0x17, 0x74, 0xCC, 0x9D, 0x02]), EXTRACTPS(dword[r12 + rcx*8 - 99], xmm14, 2).encode())


class TestINSERTPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x21, 0xCE, 0x02]), INSERTPS(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x21, 0x4C, 0xCC, 0x9D, 0x02]), INSERTPS(xmm1, dword[r12 + rcx*8 - 99], 2).encode())


class TestADDSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x58, 0xCE]), ADDSS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x58, 0x4C, 0xCC, 0x9D]), ADDSS(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestSUBSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x5C, 0xCE]), SUBSS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x5C, 0x4C, 0xCC, 0x9D]), SUBSS(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestMULSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x59, 0xCE]), MULSS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x59, 0x4C, 0xCC, 0x9D]), MULSS(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestDIVSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x5E, 0xCE]), DIVSS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x5E, 0x4C, 0xCC, 0x9D]), DIVSS(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestSQRTSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x51, 0xCE]), SQRTSS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x51, 0x4C, 0xCC, 0x9D]), SQRTSS(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestROUNDSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x0A, 0xCE, 0x02]), ROUNDSS(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x0A, 0x4C, 0xCC, 0x9D, 0x02]), ROUNDSS(xmm1, dword[r12 + rcx*8 - 99], 2).encode())


class TestMINSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x5D, 0xCE]), MINSS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x5D, 0x4C, 0xCC, 0x9D]), MINSS(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestMAXSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x5F, 0xCE]), MAXSS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x5F, 0x4C, 0xCC, 0x9D]), MAXSS(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestRCPSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x53, 0xCE]), RCPSS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x53, 0x4C, 0xCC, 0x9D]), RCPSS(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestRSQRTSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x52, 0xCE]), RSQRTSS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x52, 0x4C, 0xCC, 0x9D]), RSQRTSS(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestCMPSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0xC2, 0xCE, 0x02]), CMPSS(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0xC2, 0x4C, 0xCC, 0x9D, 0x02]), CMPSS(xmm1, dword[r12 + rcx*8 - 99], 2).encode())


class TestCOMISS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x2F, 0xCE]), COMISS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x2F, 0x4C, 0xCC, 0x9D]), COMISS(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestUCOMISS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x2E, 0xCE]), UCOMISS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x2E, 0x4C, 0xCC, 0x9D]), UCOMISS(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestMOVSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x10, 0xCE]), MOVSD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x10, 0x4C, 0xD3, 0xA8]), MOVSD(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xF2, 0x45, 0x0F, 0x11, 0x74, 0xD3, 0xA8]), MOVSD(qword[r11 + rdx*8 - 88], xmm14).encode())


class TestADDSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x58, 0xCE]), ADDSD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x58, 0x4C, 0xD3, 0xA8]), ADDSD(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestSUBSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x5C, 0xCE]), SUBSD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x5C, 0x4C, 0xD3, 0xA8]), SUBSD(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestMULSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x59, 0xCE]), MULSD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x59, 0x4C, 0xD3, 0xA8]), MULSD(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestDIVSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x5E, 0xCE]), DIVSD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x5E, 0x4C, 0xD3, 0xA8]), DIVSD(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestSQRTSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x51, 0xCE]), SQRTSD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x51, 0x4C, 0xD3, 0xA8]), SQRTSD(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestROUNDSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x0B, 0xCE, 0x02]), ROUNDSD(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x0B, 0x4C, 0xD3, 0xA8, 0x02]), ROUNDSD(xmm1, qword[r11 + rdx*8 - 88], 2).encode())


class TestMINSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x5D, 0xCE]), MINSD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x5D, 0x4C, 0xD3, 0xA8]), MINSD(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestMAXSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x5F, 0xCE]), MAXSD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x5F, 0x4C, 0xD3, 0xA8]), MAXSD(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestCMPSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0xC2, 0xCE, 0x02]), CMPSD(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0xC2, 0x4C, 0xD3, 0xA8, 0x02]), CMPSD(xmm1, qword[r11 + rdx*8 - 88], 2).encode())


class TestCOMISD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x2F, 0xCE]), COMISD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x2F, 0x4C, 0xD3, 0xA8]), COMISD(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestUCOMISD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x2E, 0xCE]), UCOMISD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x2E, 0x4C, 0xD3, 0xA8]), UCOMISD(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestMOVAPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x28, 0xCE]), MOVAPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x28, 0x4C, 0xC2, 0xB3]), MOVAPS(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0x29, 0x74, 0xC2, 0xB3]), MOVAPS(oword[r10 + rax*8 - 77], xmm14).encode())


class TestMOVUPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x10, 0xCE]), MOVUPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x10, 0x4C, 0xC2, 0xB3]), MOVUPS(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0x11, 0x74, 0xC2, 0xB3]), MOVUPS(oword[r10 + rax*8 - 77], xmm14).encode())


class TestMOVLPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x12, 0x4C, 0xD3, 0xA8]), MOVLPS(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0x13, 0x74, 0xD3, 0xA8]), MOVLPS(qword[r11 + rdx*8 - 88], xmm14).encode())


class TestMOVNTPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x45, 0x0F, 0x2B, 0x74, 0xC2, 0xB3]), MOVNTPS(oword[r10 + rax*8 - 77], xmm14).encode())


class TestMOVHPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x16, 0x4C, 0xD3, 0xA8]), MOVHPS(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x45, 0x0F, 0x17, 0x74, 0xD3, 0xA8]), MOVHPS(qword[r11 + rdx*8 - 88], xmm14).encode())


class TestMOVSLDUP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x12, 0xCE]), MOVSLDUP(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x12, 0x4C, 0xC2, 0xB3]), MOVSLDUP(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestMOVSHDUP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x16, 0xCE]), MOVSHDUP(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x16, 0x4C, 0xC2, 0xB3]), MOVSHDUP(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestMOVAPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x28, 0xCE]), MOVAPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x28, 0x4C, 0xC2, 0xB3]), MOVAPD(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0x29, 0x74, 0xC2, 0xB3]), MOVAPD(oword[r10 + rax*8 - 77], xmm14).encode())


class TestMOVUPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x10, 0xCE]), MOVUPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x10, 0x4C, 0xC2, 0xB3]), MOVUPD(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0x11, 0x74, 0xC2, 0xB3]), MOVUPD(oword[r10 + rax*8 - 77], xmm14).encode())


class TestMOVLPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x12, 0x4C, 0xD3, 0xA8]), MOVLPD(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0x13, 0x74, 0xD3, 0xA8]), MOVLPD(qword[r11 + rdx*8 - 88], xmm14).encode())


class TestMOVNTPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0x2B, 0x74, 0xC2, 0xB3]), MOVNTPD(oword[r10 + rax*8 - 77], xmm14).encode())


class TestMOVHPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x16, 0x4C, 0xD3, 0xA8]), MOVHPD(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0x17, 0x74, 0xD3, 0xA8]), MOVHPD(qword[r11 + rdx*8 - 88], xmm14).encode())


class TestMOVDDUP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x12, 0xCE]), MOVDDUP(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x12, 0x4C, 0xD3, 0xA8]), MOVDDUP(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestADDPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x58, 0xCE]), ADDPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x58, 0x4C, 0xC2, 0xB3]), ADDPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestHADDPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x7C, 0xCE]), HADDPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x7C, 0x4C, 0xC2, 0xB3]), HADDPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestSUBPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x5C, 0xCE]), SUBPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x5C, 0x4C, 0xC2, 0xB3]), SUBPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestHSUBPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x7D, 0xCE]), HSUBPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x7D, 0x4C, 0xC2, 0xB3]), HSUBPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestADDSUBPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0xD0, 0xCE]), ADDSUBPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0xD0, 0x4C, 0xC2, 0xB3]), ADDSUBPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestMULPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x59, 0xCE]), MULPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x59, 0x4C, 0xC2, 0xB3]), MULPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestDIVPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x5E, 0xCE]), DIVPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x5E, 0x4C, 0xC2, 0xB3]), DIVPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestSQRTPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x51, 0xCE]), SQRTPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x51, 0x4C, 0xC2, 0xB3]), SQRTPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestADDPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x58, 0xCE]), ADDPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x58, 0x4C, 0xC2, 0xB3]), ADDPD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestHADDPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x7C, 0xCE]), HADDPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x7C, 0x4C, 0xC2, 0xB3]), HADDPD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestSUBPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x5C, 0xCE]), SUBPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x5C, 0x4C, 0xC2, 0xB3]), SUBPD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestHSUBPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x7D, 0xCE]), HSUBPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x7D, 0x4C, 0xC2, 0xB3]), HSUBPD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestADDSUBPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD0, 0xCE]), ADDSUBPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD0, 0x4C, 0xC2, 0xB3]), ADDSUBPD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestMULPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x59, 0xCE]), MULPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x59, 0x4C, 0xC2, 0xB3]), MULPD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestDIVPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x5E, 0xCE]), DIVPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x5E, 0x4C, 0xC2, 0xB3]), DIVPD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestSQRTPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x51, 0xCE]), SQRTPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x51, 0x4C, 0xC2, 0xB3]), SQRTPD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestROUNDPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x08, 0xCE, 0x02]), ROUNDPS(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x08, 0x4C, 0xC2, 0xB3, 0x02]), ROUNDPS(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestMINPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x5D, 0xCE]), MINPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x5D, 0x4C, 0xC2, 0xB3]), MINPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestMAXPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x5F, 0xCE]), MAXPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x5F, 0x4C, 0xC2, 0xB3]), MAXPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestRCPPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x53, 0xCE]), RCPPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x53, 0x4C, 0xC2, 0xB3]), RCPPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestRSQRTPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x52, 0xCE]), RSQRTPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x52, 0x4C, 0xC2, 0xB3]), RSQRTPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestDPPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x40, 0xCE, 0x02]), DPPS(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x40, 0x4C, 0xC2, 0xB3, 0x02]), DPPS(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestCMPPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0xC2, 0xCE, 0x02]), CMPPS(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xC2, 0x4C, 0xC2, 0xB3, 0x02]), CMPPS(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestMOVMSKPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x50, 0xEE]), MOVMSKPS(ebp, xmm14).encode())


class TestROUNDPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x09, 0xCE, 0x02]), ROUNDPD(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x09, 0x4C, 0xC2, 0xB3, 0x02]), ROUNDPD(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestMINPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x5D, 0xCE]), MINPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x5D, 0x4C, 0xC2, 0xB3]), MINPD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestMAXPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x5F, 0xCE]), MAXPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x5F, 0x4C, 0xC2, 0xB3]), MAXPD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestDPPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x41, 0xCE, 0x02]), DPPD(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x41, 0x4C, 0xC2, 0xB3, 0x02]), DPPD(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestCMPPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xC2, 0xCE, 0x02]), CMPPD(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xC2, 0x4C, 0xC2, 0xB3, 0x02]), CMPPD(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestMOVMSKPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x50, 0xEE]), MOVMSKPD(ebp, xmm14).encode())


class TestANDPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x54, 0xCE]), ANDPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x54, 0x4C, 0xC2, 0xB3]), ANDPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestANDNPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x55, 0xCE]), ANDNPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x55, 0x4C, 0xC2, 0xB3]), ANDNPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestORPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x56, 0xCE]), ORPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x56, 0x4C, 0xC2, 0xB3]), ORPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestXORPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x57, 0xCE]), XORPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x57, 0x4C, 0xC2, 0xB3]), XORPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestBLENDPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x0C, 0xCE, 0x02]), BLENDPS(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x0C, 0x4C, 0xC2, 0xB3, 0x02]), BLENDPS(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestBLENDVPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x14, 0xCE]), BLENDVPS(xmm1, xmm14, xmm0).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x14, 0x4C, 0xC2, 0xB3]), BLENDVPS(xmm1, oword[r10 + rax*8 - 77], xmm0).encode())


class TestANDPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x54, 0xCE]), ANDPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x54, 0x4C, 0xC2, 0xB3]), ANDPD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestANDNPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x55, 0xCE]), ANDNPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x55, 0x4C, 0xC2, 0xB3]), ANDNPD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestORPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x56, 0xCE]), ORPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x56, 0x4C, 0xC2, 0xB3]), ORPD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestXORPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x57, 0xCE]), XORPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x57, 0x4C, 0xC2, 0xB3]), XORPD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestBLENDPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x0D, 0xCE, 0x02]), BLENDPD(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x0D, 0x4C, 0xC2, 0xB3, 0x02]), BLENDPD(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestBLENDVPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x15, 0xCE]), BLENDVPD(xmm1, xmm14, xmm0).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x15, 0x4C, 0xC2, 0xB3]), BLENDVPD(xmm1, oword[r10 + rax*8 - 77], xmm0).encode())


class TestUNPCKLPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x14, 0xCE]), UNPCKLPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x14, 0x4C, 0xC2, 0xB3]), UNPCKLPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestUNPCKHPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x15, 0xCE]), UNPCKHPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x15, 0x4C, 0xC2, 0xB3]), UNPCKHPS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestMOVLHPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x16, 0xCE]), MOVLHPS(xmm1, xmm14).encode())


class TestMOVHLPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x12, 0xCE]), MOVHLPS(xmm1, xmm14).encode())


class TestSHUFPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0xC6, 0xCE, 0x02]), SHUFPS(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xC6, 0x4C, 0xC2, 0xB3, 0x02]), SHUFPS(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestUNPCKLPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x14, 0xCE]), UNPCKLPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x14, 0x4C, 0xC2, 0xB3]), UNPCKLPD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestUNPCKHPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x15, 0xCE]), UNPCKHPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x15, 0x4C, 0xC2, 0xB3]), UNPCKHPD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestSHUFPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xC6, 0xCE, 0x02]), SHUFPD(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xC6, 0x4C, 0xC2, 0xB3, 0x02]), SHUFPD(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestMOVD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x7E, 0xED]), MOVD(ebp, mm5).encode())
        self.assertEqual(bytearray([0x66, 0x44, 0x0F, 0x7E, 0xF5]), MOVD(ebp, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x6E, 0xD8]), MOVD(mm3, r8d).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x6E, 0x5C, 0xCC, 0x9D]), MOVD(mm3, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x6E, 0xC8]), MOVD(xmm1, r8d).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x6E, 0x4C, 0xCC, 0x9D]), MOVD(xmm1, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x7E, 0x6C, 0xCC, 0x9D]), MOVD(dword[r12 + rcx*8 - 99], mm5).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0x7E, 0x74, 0xCC, 0x9D]), MOVD(dword[r12 + rcx*8 - 99], xmm14).encode())


class TestMOVQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x48, 0x0F, 0x7E, 0xE9]), MOVQ(rcx, mm5).encode())
        self.assertEqual(bytearray([0x66, 0x4C, 0x0F, 0x7E, 0xF1]), MOVQ(rcx, xmm14).encode())
        self.assertEqual(bytearray([0x49, 0x0F, 0x6E, 0xDF]), MOVQ(mm3, r15).encode())
        self.assertEqual(bytearray([0x0F, 0x6F, 0xDD]), MOVQ(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x6F, 0x5C, 0xD3, 0xA8]), MOVQ(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x49, 0x0F, 0x6E, 0xCF]), MOVQ(xmm1, r15).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x7E, 0xCE]), MOVQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x7E, 0x4C, 0xD3, 0xA8]), MOVQ(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x7F, 0x6C, 0xD3, 0xA8]), MOVQ(qword[r11 + rdx*8 - 88], mm5).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0xD6, 0x74, 0xD3, 0xA8]), MOVQ(qword[r11 + rdx*8 - 88], xmm14).encode())


class TestMOVDQ2Q(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0xD6, 0xDE]), MOVDQ2Q(mm3, xmm14).encode())


class TestMOVQ2DQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x0F, 0xD6, 0xCD]), MOVQ2DQ(xmm1, mm5).encode())


class TestMOVDQA(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x6F, 0xCE]), MOVDQA(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x6F, 0x4C, 0xC2, 0xB3]), MOVDQA(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0x7F, 0x74, 0xC2, 0xB3]), MOVDQA(oword[r10 + rax*8 - 77], xmm14).encode())


class TestMOVDQU(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x6F, 0xCE]), MOVDQU(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x6F, 0x4C, 0xC2, 0xB3]), MOVDQU(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xF3, 0x45, 0x0F, 0x7F, 0x74, 0xC2, 0xB3]), MOVDQU(oword[r10 + rax*8 - 77], xmm14).encode())


class TestLDDQU(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0xF0, 0x4C, 0xC2, 0xB3]), LDDQU(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestMASKMOVQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xF7, 0xDD]), MASKMOVQ(mm3, mm5).encode())


class TestMASKMOVDQU(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF7, 0xCE]), MASKMOVDQU(xmm1, xmm14).encode())


class TestMOVNTQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0xE7, 0x6C, 0xD3, 0xA8]), MOVNTQ(qword[r11 + rdx*8 - 88], mm5).encode())


class TestMOVNTDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0xE7, 0x74, 0xC2, 0xB3]), MOVNTDQ(oword[r10 + rax*8 - 77], xmm14).encode())


class TestMOVNTDQA(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x2A, 0x4C, 0xC2, 0xB3]), MOVNTDQA(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMOVSXBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x20, 0xCE]), PMOVSXBW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x20, 0x4C, 0xD3, 0xA8]), PMOVSXBW(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestPMOVSXBD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x21, 0xCE]), PMOVSXBD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x21, 0x4C, 0xCC, 0x9D]), PMOVSXBD(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestPMOVSXBQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x22, 0xCE]), PMOVSXBQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x22, 0x4C, 0xED, 0x95]), PMOVSXBQ(xmm1, word[r13 + rbp*8 - 107]).encode())


class TestPMOVSXWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x23, 0xCE]), PMOVSXWD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x23, 0x4C, 0xD3, 0xA8]), PMOVSXWD(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestPMOVSXWQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x24, 0xCE]), PMOVSXWQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x24, 0x4C, 0xCC, 0x9D]), PMOVSXWQ(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestPMOVSXDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x25, 0xCE]), PMOVSXDQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x25, 0x4C, 0xD3, 0xA8]), PMOVSXDQ(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestPMOVZXBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x30, 0xCE]), PMOVZXBW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x30, 0x4C, 0xD3, 0xA8]), PMOVZXBW(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestPMOVZXBD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x31, 0xCE]), PMOVZXBD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x31, 0x4C, 0xCC, 0x9D]), PMOVZXBD(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestPMOVZXBQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x32, 0xCE]), PMOVZXBQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x32, 0x4C, 0xED, 0x95]), PMOVZXBQ(xmm1, word[r13 + rbp*8 - 107]).encode())


class TestPMOVZXWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x33, 0xCE]), PMOVZXWD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x33, 0x4C, 0xD3, 0xA8]), PMOVZXWD(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestPMOVZXWQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x34, 0xCE]), PMOVZXWQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x34, 0x4C, 0xCC, 0x9D]), PMOVZXWQ(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestPMOVZXDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x35, 0xCE]), PMOVZXDQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x35, 0x4C, 0xD3, 0xA8]), PMOVZXDQ(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestPEXTRB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x44, 0x0F, 0x3A, 0x14, 0xF5, 0x02]), PEXTRB(ebp, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0x3A, 0x14, 0x74, 0xBE, 0x85, 0x02]), PEXTRB(byte[r14 + rdi*4 - 123], xmm14, 2).encode())


class TestPEXTRW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xC5, 0xED, 0x02]), PEXTRW(ebp, mm5, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xC5, 0xEE, 0x02]), PEXTRW(ebp, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0x3A, 0x15, 0x74, 0xED, 0x95, 0x02]), PEXTRW(word[r13 + rbp*8 - 107], xmm14, 2).encode())


class TestPEXTRD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x44, 0x0F, 0x3A, 0x16, 0xF5, 0x02]), PEXTRD(ebp, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x45, 0x0F, 0x3A, 0x16, 0x74, 0xCC, 0x9D, 0x02]), PEXTRD(dword[r12 + rcx*8 - 99], xmm14, 2).encode())


class TestPEXTRQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x4C, 0x0F, 0x3A, 0x16, 0xF1, 0x02]), PEXTRQ(rcx, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x4D, 0x0F, 0x3A, 0x16, 0x74, 0xD3, 0xA8, 0x02]), PEXTRQ(qword[r11 + rdx*8 - 88], xmm14, 2).encode())


class TestPINSRB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x20, 0xC8, 0x02]), PINSRB(xmm1, r8d, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x20, 0x4C, 0xBE, 0x85, 0x02]), PINSRB(xmm1, byte[r14 + rdi*4 - 123], 2).encode())


class TestPINSRW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0xC4, 0xD8, 0x02]), PINSRW(mm3, r8d, 2).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xC4, 0x5C, 0xED, 0x95, 0x02]), PINSRW(mm3, word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xC4, 0xC8, 0x02]), PINSRW(xmm1, r8d, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xC4, 0x4C, 0xED, 0x95, 0x02]), PINSRW(xmm1, word[r13 + rbp*8 - 107], 2).encode())


class TestPINSRD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x22, 0xC8, 0x02]), PINSRD(xmm1, r8d, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x22, 0x4C, 0xCC, 0x9D, 0x02]), PINSRD(xmm1, dword[r12 + rcx*8 - 99], 2).encode())


class TestPINSRQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x49, 0x0F, 0x3A, 0x22, 0xCF, 0x02]), PINSRQ(xmm1, r15, 2).encode())
        self.assertEqual(bytearray([0x66, 0x49, 0x0F, 0x3A, 0x22, 0x4C, 0xD3, 0xA8, 0x02]), PINSRQ(xmm1, qword[r11 + rdx*8 - 88], 2).encode())


class TestPMOVMSKB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xD7, 0xED]), PMOVMSKB(ebp, mm5).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD7, 0xEE]), PMOVMSKB(ebp, xmm14).encode())


class TestPTEST(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x17, 0xCE]), PTEST(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x17, 0x4C, 0xC2, 0xB3]), PTEST(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPADDB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xFC, 0xDD]), PADDB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xFC, 0x5C, 0xD3, 0xA8]), PADDB(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xFC, 0xCE]), PADDB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xFC, 0x4C, 0xC2, 0xB3]), PADDB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPADDW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xFD, 0xDD]), PADDW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xFD, 0x5C, 0xD3, 0xA8]), PADDW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xFD, 0xCE]), PADDW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xFD, 0x4C, 0xC2, 0xB3]), PADDW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPADDD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xFE, 0xDD]), PADDD(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xFE, 0x5C, 0xD3, 0xA8]), PADDD(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xFE, 0xCE]), PADDD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xFE, 0x4C, 0xC2, 0xB3]), PADDD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPADDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xD4, 0xDD]), PADDQ(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xD4, 0x5C, 0xD3, 0xA8]), PADDQ(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD4, 0xCE]), PADDQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD4, 0x4C, 0xC2, 0xB3]), PADDQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPADDSB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xEC, 0xDD]), PADDSB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xEC, 0x5C, 0xD3, 0xA8]), PADDSB(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xEC, 0xCE]), PADDSB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xEC, 0x4C, 0xC2, 0xB3]), PADDSB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPADDSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xED, 0xDD]), PADDSW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xED, 0x5C, 0xD3, 0xA8]), PADDSW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xED, 0xCE]), PADDSW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xED, 0x4C, 0xC2, 0xB3]), PADDSW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPADDUSB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xDC, 0xDD]), PADDUSB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xDC, 0x5C, 0xD3, 0xA8]), PADDUSB(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xDC, 0xCE]), PADDUSB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xDC, 0x4C, 0xC2, 0xB3]), PADDUSB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPADDUSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xDD, 0xDD]), PADDUSW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xDD, 0x5C, 0xD3, 0xA8]), PADDUSW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xDD, 0xCE]), PADDUSW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xDD, 0x4C, 0xC2, 0xB3]), PADDUSW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPHADDW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x38, 0x01, 0xDD]), PHADDW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x38, 0x01, 0x5C, 0xD3, 0xA8]), PHADDW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x01, 0xCE]), PHADDW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x01, 0x4C, 0xC2, 0xB3]), PHADDW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPHADDD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x38, 0x02, 0xDD]), PHADDD(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x38, 0x02, 0x5C, 0xD3, 0xA8]), PHADDD(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x02, 0xCE]), PHADDD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x02, 0x4C, 0xC2, 0xB3]), PHADDD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPHADDSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x38, 0x03, 0xDD]), PHADDSW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x38, 0x03, 0x5C, 0xD3, 0xA8]), PHADDSW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x03, 0xCE]), PHADDSW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x03, 0x4C, 0xC2, 0xB3]), PHADDSW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSUBB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xF8, 0xDD]), PSUBB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xF8, 0x5C, 0xD3, 0xA8]), PSUBB(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF8, 0xCE]), PSUBB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF8, 0x4C, 0xC2, 0xB3]), PSUBB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSUBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xF9, 0xDD]), PSUBW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xF9, 0x5C, 0xD3, 0xA8]), PSUBW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF9, 0xCE]), PSUBW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF9, 0x4C, 0xC2, 0xB3]), PSUBW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSUBD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xFA, 0xDD]), PSUBD(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xFA, 0x5C, 0xD3, 0xA8]), PSUBD(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xFA, 0xCE]), PSUBD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xFA, 0x4C, 0xC2, 0xB3]), PSUBD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSUBQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xFB, 0xDD]), PSUBQ(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xFB, 0x5C, 0xD3, 0xA8]), PSUBQ(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xFB, 0xCE]), PSUBQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xFB, 0x4C, 0xC2, 0xB3]), PSUBQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSUBSB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xE8, 0xDD]), PSUBSB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xE8, 0x5C, 0xD3, 0xA8]), PSUBSB(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE8, 0xCE]), PSUBSB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE8, 0x4C, 0xC2, 0xB3]), PSUBSB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSUBSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xE9, 0xDD]), PSUBSW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xE9, 0x5C, 0xD3, 0xA8]), PSUBSW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE9, 0xCE]), PSUBSW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE9, 0x4C, 0xC2, 0xB3]), PSUBSW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSUBUSB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xD8, 0xDD]), PSUBUSB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xD8, 0x5C, 0xD3, 0xA8]), PSUBUSB(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD8, 0xCE]), PSUBUSB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD8, 0x4C, 0xC2, 0xB3]), PSUBUSB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSUBUSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xD9, 0xDD]), PSUBUSW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xD9, 0x5C, 0xD3, 0xA8]), PSUBUSW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD9, 0xCE]), PSUBUSW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD9, 0x4C, 0xC2, 0xB3]), PSUBUSW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPHSUBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x38, 0x05, 0xDD]), PHSUBW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x38, 0x05, 0x5C, 0xD3, 0xA8]), PHSUBW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x05, 0xCE]), PHSUBW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x05, 0x4C, 0xC2, 0xB3]), PHSUBW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPHSUBD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x38, 0x06, 0xDD]), PHSUBD(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x38, 0x06, 0x5C, 0xD3, 0xA8]), PHSUBD(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x06, 0xCE]), PHSUBD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x06, 0x4C, 0xC2, 0xB3]), PHSUBD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPHSUBSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x38, 0x07, 0xDD]), PHSUBSW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x38, 0x07, 0x5C, 0xD3, 0xA8]), PHSUBSW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x07, 0xCE]), PHSUBSW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x07, 0x4C, 0xC2, 0xB3]), PHSUBSW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMAXSB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x3C, 0xCE]), PMAXSB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x3C, 0x4C, 0xC2, 0xB3]), PMAXSB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMAXSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xEE, 0xDD]), PMAXSW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xEE, 0x5C, 0xD3, 0xA8]), PMAXSW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xEE, 0xCE]), PMAXSW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xEE, 0x4C, 0xC2, 0xB3]), PMAXSW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMAXSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x3D, 0xCE]), PMAXSD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x3D, 0x4C, 0xC2, 0xB3]), PMAXSD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMAXUB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xDE, 0xDD]), PMAXUB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xDE, 0x5C, 0xD3, 0xA8]), PMAXUB(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xDE, 0xCE]), PMAXUB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xDE, 0x4C, 0xC2, 0xB3]), PMAXUB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMAXUW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x3E, 0xCE]), PMAXUW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x3E, 0x4C, 0xC2, 0xB3]), PMAXUW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMAXUD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x3F, 0xCE]), PMAXUD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x3F, 0x4C, 0xC2, 0xB3]), PMAXUD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMINSB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x38, 0xCE]), PMINSB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x38, 0x4C, 0xC2, 0xB3]), PMINSB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMINSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xEA, 0xDD]), PMINSW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xEA, 0x5C, 0xD3, 0xA8]), PMINSW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xEA, 0xCE]), PMINSW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xEA, 0x4C, 0xC2, 0xB3]), PMINSW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMINSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x39, 0xCE]), PMINSD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x39, 0x4C, 0xC2, 0xB3]), PMINSD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMINUB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xDA, 0xDD]), PMINUB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xDA, 0x5C, 0xD3, 0xA8]), PMINUB(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xDA, 0xCE]), PMINUB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xDA, 0x4C, 0xC2, 0xB3]), PMINUB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMINUW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x3A, 0xCE]), PMINUW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x3A, 0x4C, 0xC2, 0xB3]), PMINUW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMINUD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x3B, 0xCE]), PMINUD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x3B, 0x4C, 0xC2, 0xB3]), PMINUD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSLLW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x71, 0xF3, 0x02]), PSLLW(mm3, 2).encode())
        self.assertEqual(bytearray([0x0F, 0xF1, 0xDD]), PSLLW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xF1, 0x5C, 0xD3, 0xA8]), PSLLW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x0F, 0x71, 0xF1, 0x02]), PSLLW(xmm1, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF1, 0xCE]), PSLLW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF1, 0x4C, 0xC2, 0xB3]), PSLLW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSLLD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x72, 0xF3, 0x02]), PSLLD(mm3, 2).encode())
        self.assertEqual(bytearray([0x0F, 0xF2, 0xDD]), PSLLD(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xF2, 0x5C, 0xD3, 0xA8]), PSLLD(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x0F, 0x72, 0xF1, 0x02]), PSLLD(xmm1, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF2, 0xCE]), PSLLD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF2, 0x4C, 0xC2, 0xB3]), PSLLD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSLLQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x73, 0xF3, 0x02]), PSLLQ(mm3, 2).encode())
        self.assertEqual(bytearray([0x0F, 0xF3, 0xDD]), PSLLQ(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xF3, 0x5C, 0xD3, 0xA8]), PSLLQ(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x0F, 0x73, 0xF1, 0x02]), PSLLQ(xmm1, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF3, 0xCE]), PSLLQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF3, 0x4C, 0xC2, 0xB3]), PSLLQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSRLW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x71, 0xD3, 0x02]), PSRLW(mm3, 2).encode())
        self.assertEqual(bytearray([0x0F, 0xD1, 0xDD]), PSRLW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xD1, 0x5C, 0xD3, 0xA8]), PSRLW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x0F, 0x71, 0xD1, 0x02]), PSRLW(xmm1, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD1, 0xCE]), PSRLW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD1, 0x4C, 0xC2, 0xB3]), PSRLW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSRLD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x72, 0xD3, 0x02]), PSRLD(mm3, 2).encode())
        self.assertEqual(bytearray([0x0F, 0xD2, 0xDD]), PSRLD(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xD2, 0x5C, 0xD3, 0xA8]), PSRLD(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x0F, 0x72, 0xD1, 0x02]), PSRLD(xmm1, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD2, 0xCE]), PSRLD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD2, 0x4C, 0xC2, 0xB3]), PSRLD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSRLQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x73, 0xD3, 0x02]), PSRLQ(mm3, 2).encode())
        self.assertEqual(bytearray([0x0F, 0xD3, 0xDD]), PSRLQ(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xD3, 0x5C, 0xD3, 0xA8]), PSRLQ(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x0F, 0x73, 0xD1, 0x02]), PSRLQ(xmm1, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD3, 0xCE]), PSRLQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD3, 0x4C, 0xC2, 0xB3]), PSRLQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSRAW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x71, 0xE3, 0x02]), PSRAW(mm3, 2).encode())
        self.assertEqual(bytearray([0x0F, 0xE1, 0xDD]), PSRAW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xE1, 0x5C, 0xD3, 0xA8]), PSRAW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x0F, 0x71, 0xE1, 0x02]), PSRAW(xmm1, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE1, 0xCE]), PSRAW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE1, 0x4C, 0xC2, 0xB3]), PSRAW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSRAD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x72, 0xE3, 0x02]), PSRAD(mm3, 2).encode())
        self.assertEqual(bytearray([0x0F, 0xE2, 0xDD]), PSRAD(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xE2, 0x5C, 0xD3, 0xA8]), PSRAD(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x0F, 0x72, 0xE1, 0x02]), PSRAD(xmm1, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE2, 0xCE]), PSRAD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE2, 0x4C, 0xC2, 0xB3]), PSRAD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMULLW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xD5, 0xDD]), PMULLW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xD5, 0x5C, 0xD3, 0xA8]), PMULLW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD5, 0xCE]), PMULLW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xD5, 0x4C, 0xC2, 0xB3]), PMULLW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMULHW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xE5, 0xDD]), PMULHW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xE5, 0x5C, 0xD3, 0xA8]), PMULHW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE5, 0xCE]), PMULHW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE5, 0x4C, 0xC2, 0xB3]), PMULHW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMULHUW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xE4, 0xDD]), PMULHUW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xE4, 0x5C, 0xD3, 0xA8]), PMULHUW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE4, 0xCE]), PMULHUW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE4, 0x4C, 0xC2, 0xB3]), PMULHUW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMULLD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x40, 0xCE]), PMULLD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x40, 0x4C, 0xC2, 0xB3]), PMULLD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMULDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x28, 0xCE]), PMULDQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x28, 0x4C, 0xC2, 0xB3]), PMULDQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMULUDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xF4, 0xDD]), PMULUDQ(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xF4, 0x5C, 0xD3, 0xA8]), PMULUDQ(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF4, 0xCE]), PMULUDQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF4, 0x4C, 0xC2, 0xB3]), PMULUDQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMULHRSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x38, 0x0B, 0xDD]), PMULHRSW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x38, 0x0B, 0x5C, 0xD3, 0xA8]), PMULHRSW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x0B, 0xCE]), PMULHRSW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x0B, 0x4C, 0xC2, 0xB3]), PMULHRSW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMADDWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xF5, 0xDD]), PMADDWD(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xF5, 0x5C, 0xD3, 0xA8]), PMADDWD(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF5, 0xCE]), PMADDWD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF5, 0x4C, 0xC2, 0xB3]), PMADDWD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPMADDUBSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x38, 0x04, 0xDD]), PMADDUBSW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x38, 0x04, 0x5C, 0xD3, 0xA8]), PMADDUBSW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x04, 0xCE]), PMADDUBSW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x04, 0x4C, 0xC2, 0xB3]), PMADDUBSW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPAVGB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xE0, 0xDD]), PAVGB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xE0, 0x5C, 0xD3, 0xA8]), PAVGB(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE0, 0xCE]), PAVGB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE0, 0x4C, 0xC2, 0xB3]), PAVGB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPAVGW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xE3, 0xDD]), PAVGW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xE3, 0x5C, 0xD3, 0xA8]), PAVGW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE3, 0xCE]), PAVGW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE3, 0x4C, 0xC2, 0xB3]), PAVGW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSADBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xF6, 0xDD]), PSADBW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xF6, 0x5C, 0xD3, 0xA8]), PSADBW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF6, 0xCE]), PSADBW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xF6, 0x4C, 0xC2, 0xB3]), PSADBW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestMPSADBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x42, 0xCE, 0x02]), MPSADBW(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x42, 0x4C, 0xC2, 0xB3, 0x02]), MPSADBW(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestPHMINPOSUW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x41, 0xCE]), PHMINPOSUW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x41, 0x4C, 0xC2, 0xB3]), PHMINPOSUW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPCMPEQB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x74, 0xDD]), PCMPEQB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x74, 0x5C, 0xD3, 0xA8]), PCMPEQB(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x74, 0xCE]), PCMPEQB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x74, 0x4C, 0xC2, 0xB3]), PCMPEQB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPCMPEQW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x75, 0xDD]), PCMPEQW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x75, 0x5C, 0xD3, 0xA8]), PCMPEQW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x75, 0xCE]), PCMPEQW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x75, 0x4C, 0xC2, 0xB3]), PCMPEQW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPCMPEQD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x76, 0xDD]), PCMPEQD(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x76, 0x5C, 0xD3, 0xA8]), PCMPEQD(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x76, 0xCE]), PCMPEQD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x76, 0x4C, 0xC2, 0xB3]), PCMPEQD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPCMPEQQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x29, 0xCE]), PCMPEQQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x29, 0x4C, 0xC2, 0xB3]), PCMPEQQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPCMPGTB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x64, 0xDD]), PCMPGTB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x64, 0x5C, 0xD3, 0xA8]), PCMPGTB(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x64, 0xCE]), PCMPGTB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x64, 0x4C, 0xC2, 0xB3]), PCMPGTB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPCMPGTW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x65, 0xDD]), PCMPGTW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x65, 0x5C, 0xD3, 0xA8]), PCMPGTW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x65, 0xCE]), PCMPGTW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x65, 0x4C, 0xC2, 0xB3]), PCMPGTW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPCMPGTD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x66, 0xDD]), PCMPGTD(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x66, 0x5C, 0xD3, 0xA8]), PCMPGTD(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x66, 0xCE]), PCMPGTD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x66, 0x4C, 0xC2, 0xB3]), PCMPGTD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPCMPGTQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x37, 0xCE]), PCMPGTQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x37, 0x4C, 0xC2, 0xB3]), PCMPGTQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPABSB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x38, 0x1C, 0xDD]), PABSB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x38, 0x1C, 0x5C, 0xD3, 0xA8]), PABSB(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x1C, 0xCE]), PABSB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x1C, 0x4C, 0xC2, 0xB3]), PABSB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPABSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x38, 0x1D, 0xDD]), PABSW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x38, 0x1D, 0x5C, 0xD3, 0xA8]), PABSW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x1D, 0xCE]), PABSW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x1D, 0x4C, 0xC2, 0xB3]), PABSW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPABSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x38, 0x1E, 0xDD]), PABSD(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x38, 0x1E, 0x5C, 0xD3, 0xA8]), PABSD(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x1E, 0xCE]), PABSD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x1E, 0x4C, 0xC2, 0xB3]), PABSD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSIGNB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x38, 0x08, 0xDD]), PSIGNB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x38, 0x08, 0x5C, 0xD3, 0xA8]), PSIGNB(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x08, 0xCE]), PSIGNB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x08, 0x4C, 0xC2, 0xB3]), PSIGNB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSIGNW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x38, 0x09, 0xDD]), PSIGNW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x38, 0x09, 0x5C, 0xD3, 0xA8]), PSIGNW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x09, 0xCE]), PSIGNW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x09, 0x4C, 0xC2, 0xB3]), PSIGNW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSIGND(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x38, 0x0A, 0xDD]), PSIGND(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x38, 0x0A, 0x5C, 0xD3, 0xA8]), PSIGND(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x0A, 0xCE]), PSIGND(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x0A, 0x4C, 0xC2, 0xB3]), PSIGND(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPAND(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xDB, 0xDD]), PAND(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xDB, 0x5C, 0xD3, 0xA8]), PAND(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xDB, 0xCE]), PAND(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xDB, 0x4C, 0xC2, 0xB3]), PAND(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPANDN(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xDF, 0xDD]), PANDN(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xDF, 0x5C, 0xD3, 0xA8]), PANDN(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xDF, 0xCE]), PANDN(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xDF, 0x4C, 0xC2, 0xB3]), PANDN(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPOR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xEB, 0xDD]), POR(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xEB, 0x5C, 0xD3, 0xA8]), POR(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xEB, 0xCE]), POR(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xEB, 0x4C, 0xC2, 0xB3]), POR(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPXOR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0xEF, 0xDD]), PXOR(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0xEF, 0x5C, 0xD3, 0xA8]), PXOR(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xEF, 0xCE]), PXOR(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xEF, 0x4C, 0xC2, 0xB3]), PXOR(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPBLENDW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x0E, 0xCE, 0x02]), PBLENDW(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x0E, 0x4C, 0xC2, 0xB3, 0x02]), PBLENDW(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestPBLENDVB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x10, 0xCE]), PBLENDVB(xmm1, xmm14, xmm0).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x10, 0x4C, 0xC2, 0xB3]), PBLENDVB(xmm1, oword[r10 + rax*8 - 77], xmm0).encode())


class TestPUNPCKLBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x60, 0xDD]), PUNPCKLBW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x60, 0x5C, 0xCC, 0x9D]), PUNPCKLBW(mm3, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x60, 0xCE]), PUNPCKLBW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x60, 0x4C, 0xC2, 0xB3]), PUNPCKLBW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPUNPCKLWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x61, 0xDD]), PUNPCKLWD(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x61, 0x5C, 0xCC, 0x9D]), PUNPCKLWD(mm3, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x61, 0xCE]), PUNPCKLWD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x61, 0x4C, 0xC2, 0xB3]), PUNPCKLWD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPUNPCKLDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x62, 0xDD]), PUNPCKLDQ(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x62, 0x5C, 0xCC, 0x9D]), PUNPCKLDQ(mm3, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x62, 0xCE]), PUNPCKLDQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x62, 0x4C, 0xC2, 0xB3]), PUNPCKLDQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPUNPCKLQDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x6C, 0xCE]), PUNPCKLQDQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x6C, 0x4C, 0xC2, 0xB3]), PUNPCKLQDQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPUNPCKHBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x68, 0xDD]), PUNPCKHBW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x68, 0x5C, 0xD3, 0xA8]), PUNPCKHBW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x68, 0xCE]), PUNPCKHBW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x68, 0x4C, 0xC2, 0xB3]), PUNPCKHBW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPUNPCKHWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x69, 0xDD]), PUNPCKHWD(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x69, 0x5C, 0xD3, 0xA8]), PUNPCKHWD(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x69, 0xCE]), PUNPCKHWD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x69, 0x4C, 0xC2, 0xB3]), PUNPCKHWD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPUNPCKHDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x6A, 0xDD]), PUNPCKHDQ(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x6A, 0x5C, 0xD3, 0xA8]), PUNPCKHDQ(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x6A, 0xCE]), PUNPCKHDQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x6A, 0x4C, 0xC2, 0xB3]), PUNPCKHDQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPUNPCKHQDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x6D, 0xCE]), PUNPCKHQDQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x6D, 0x4C, 0xC2, 0xB3]), PUNPCKHQDQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPACKSSWB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x63, 0xDD]), PACKSSWB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x63, 0x5C, 0xD3, 0xA8]), PACKSSWB(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x63, 0xCE]), PACKSSWB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x63, 0x4C, 0xC2, 0xB3]), PACKSSWB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPACKSSDW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x6B, 0xDD]), PACKSSDW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x6B, 0x5C, 0xD3, 0xA8]), PACKSSDW(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x6B, 0xCE]), PACKSSDW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x6B, 0x4C, 0xC2, 0xB3]), PACKSSDW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPACKUSWB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x67, 0xDD]), PACKUSWB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x67, 0x5C, 0xD3, 0xA8]), PACKUSWB(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x67, 0xCE]), PACKUSWB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x67, 0x4C, 0xC2, 0xB3]), PACKUSWB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPACKUSDW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x2B, 0xCE]), PACKUSDW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x2B, 0x4C, 0xC2, 0xB3]), PACKUSDW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSHUFB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x38, 0x00, 0xDD]), PSHUFB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x38, 0x00, 0x5C, 0xD3, 0xA8]), PSHUFB(mm3, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x00, 0xCE]), PSHUFB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x38, 0x00, 0x4C, 0xC2, 0xB3]), PSHUFB(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestPSHUFW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x70, 0xDD, 0x02]), PSHUFW(mm3, mm5, 2).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x70, 0x5C, 0xD3, 0xA8, 0x02]), PSHUFW(mm3, qword[r11 + rdx*8 - 88], 2).encode())


class TestPSHUFLW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x70, 0xCE, 0x02]), PSHUFLW(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x70, 0x4C, 0xC2, 0xB3, 0x02]), PSHUFLW(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestPSHUFHW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x70, 0xCE, 0x02]), PSHUFHW(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x70, 0x4C, 0xC2, 0xB3, 0x02]), PSHUFHW(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestPSHUFD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x70, 0xCE, 0x02]), PSHUFD(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x70, 0x4C, 0xC2, 0xB3, 0x02]), PSHUFD(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestPSLLDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x0F, 0x73, 0xF9, 0x02]), PSLLDQ(xmm1, 2).encode())


class TestPSRLDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x0F, 0x73, 0xD9, 0x02]), PSRLDQ(xmm1, 2).encode())


class TestPALIGNR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x3A, 0x0F, 0xDD, 0x02]), PALIGNR(mm3, mm5, 2).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x3A, 0x0F, 0x5C, 0xD3, 0xA8, 0x02]), PALIGNR(mm3, qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x0F, 0xCE, 0x02]), PALIGNR(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x0F, 0x4C, 0xC2, 0xB3, 0x02]), PALIGNR(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestPCMPESTRI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x61, 0xCE, 0x02]), PCMPESTRI(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x61, 0x4C, 0xC2, 0xB3, 0x02]), PCMPESTRI(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestPCMPESTRM(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x60, 0xCE, 0x02]), PCMPESTRM(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x60, 0x4C, 0xC2, 0xB3, 0x02]), PCMPESTRM(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestPCMPISTRI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x63, 0xCE, 0x02]), PCMPISTRI(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x63, 0x4C, 0xC2, 0xB3, 0x02]), PCMPISTRI(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestPCMPISTRM(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x62, 0xCE, 0x02]), PCMPISTRM(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x3A, 0x62, 0x4C, 0xC2, 0xB3, 0x02]), PCMPISTRM(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestCVTSS2SI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x2D, 0xEE]), CVTSS2SI(ebp, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x2D, 0x6C, 0xCC, 0x9D]), CVTSS2SI(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0x2D, 0xCE]), CVTSS2SI(rcx, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0x2D, 0x4C, 0xCC, 0x9D]), CVTSS2SI(rcx, dword[r12 + rcx*8 - 99]).encode())


class TestCVTTSS2SI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x2C, 0xEE]), CVTTSS2SI(ebp, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x2C, 0x6C, 0xCC, 0x9D]), CVTTSS2SI(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0x2C, 0xCE]), CVTTSS2SI(rcx, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0x2C, 0x4C, 0xCC, 0x9D]), CVTTSS2SI(rcx, dword[r12 + rcx*8 - 99]).encode())


class TestCVTSI2SS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x2A, 0xC8]), CVTSI2SS(xmm1, r8d).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0x2A, 0xCF]), CVTSI2SS(xmm1, r15).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x2A, 0x4C, 0xCC, 0x9D]), CVTSI2SS(xmm1, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xF3, 0x49, 0x0F, 0x2A, 0x4C, 0xD3, 0xA8]), CVTSI2SS(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestCVTSD2SI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x2D, 0xEE]), CVTSD2SI(ebp, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x2D, 0x6C, 0xD3, 0xA8]), CVTSD2SI(ebp, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xF2, 0x49, 0x0F, 0x2D, 0xCE]), CVTSD2SI(rcx, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x49, 0x0F, 0x2D, 0x4C, 0xD3, 0xA8]), CVTSD2SI(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCVTTSD2SI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x2C, 0xEE]), CVTTSD2SI(ebp, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x2C, 0x6C, 0xD3, 0xA8]), CVTTSD2SI(ebp, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xF2, 0x49, 0x0F, 0x2C, 0xCE]), CVTTSD2SI(rcx, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x49, 0x0F, 0x2C, 0x4C, 0xD3, 0xA8]), CVTTSD2SI(rcx, qword[r11 + rdx*8 - 88]).encode())


class TestCVTSI2SD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x2A, 0xC8]), CVTSI2SD(xmm1, r8d).encode())
        self.assertEqual(bytearray([0xF2, 0x49, 0x0F, 0x2A, 0xCF]), CVTSI2SD(xmm1, r15).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x2A, 0x4C, 0xCC, 0x9D]), CVTSI2SD(xmm1, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xF2, 0x49, 0x0F, 0x2A, 0x4C, 0xD3, 0xA8]), CVTSI2SD(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestCVTPS2DQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x5B, 0xCE]), CVTPS2DQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x5B, 0x4C, 0xC2, 0xB3]), CVTPS2DQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestCVTTPS2DQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x5B, 0xCE]), CVTTPS2DQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x5B, 0x4C, 0xC2, 0xB3]), CVTTPS2DQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestCVTDQ2PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x5B, 0xCE]), CVTDQ2PS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x5B, 0x4C, 0xC2, 0xB3]), CVTDQ2PS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestCVTPD2DQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0xE6, 0xCE]), CVTPD2DQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0xE6, 0x4C, 0xC2, 0xB3]), CVTPD2DQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestCVTTPD2DQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE6, 0xCE]), CVTTPD2DQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0xE6, 0x4C, 0xC2, 0xB3]), CVTTPD2DQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestCVTDQ2PD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0xE6, 0xCE]), CVTDQ2PD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0xE6, 0x4C, 0xD3, 0xA8]), CVTDQ2PD(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestCVTPS2PI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x2D, 0xDE]), CVTPS2PI(mm3, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x2D, 0x5C, 0xD3, 0xA8]), CVTPS2PI(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestCVTTPS2PI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x2C, 0xDE]), CVTTPS2PI(mm3, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x2C, 0x5C, 0xD3, 0xA8]), CVTTPS2PI(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestCVTPI2PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x2A, 0xCD]), CVTPI2PS(xmm1, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x2A, 0x4C, 0xD3, 0xA8]), CVTPI2PS(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestCVTPD2PI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x2D, 0xDE]), CVTPD2PI(mm3, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x2D, 0x5C, 0xC2, 0xB3]), CVTPD2PI(mm3, oword[r10 + rax*8 - 77]).encode())


class TestCVTTPD2PI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x2C, 0xDE]), CVTTPD2PI(mm3, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x2C, 0x5C, 0xC2, 0xB3]), CVTTPD2PI(mm3, oword[r10 + rax*8 - 77]).encode())


class TestCVTPI2PD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x0F, 0x2A, 0xCD]), CVTPI2PD(xmm1, mm5).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x2A, 0x4C, 0xD3, 0xA8]), CVTPI2PD(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestCVTSD2SS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x5A, 0xCE]), CVTSD2SS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x5A, 0x4C, 0xD3, 0xA8]), CVTSD2SS(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestCVTSS2SD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x5A, 0xCE]), CVTSS2SD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF3, 0x41, 0x0F, 0x5A, 0x4C, 0xCC, 0x9D]), CVTSS2SD(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestCVTPD2PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x5A, 0xCE]), CVTPD2PS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x5A, 0x4C, 0xC2, 0xB3]), CVTPD2PS(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestCVTPS2PD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0x5A, 0xCE]), CVTPS2PD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x5A, 0x4C, 0xD3, 0xA8]), CVTPS2PD(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestLDMXCSR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0xAE, 0x54, 0xCC, 0x9D]), LDMXCSR(dword[r12 + rcx*8 - 99]).encode())


class TestSTMXCSR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x41, 0x0F, 0xAE, 0x5C, 0xCC, 0x9D]), STMXCSR(dword[r12 + rcx*8 - 99]).encode())


class TestEMMS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x77]), EMMS().encode())


