/**
* @license Apache-2.0
*
* Copyright (c) 2020 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Compute the arithmetic mean of a strided array using pairwise summation.
*
* @module @stdlib/stats/base/meanpw
*
* @example
* var meanpw = require( '@stdlib/stats/base/meanpw' );
*
* var x = [ 1.0, -2.0, 2.0 ];
* var N = x.length;
*
* var v = meanpw( N, x, 1 );
* // returns ~0.3333
*
* @example
* var floor = require( '@stdlib/math/base/special/floor' );
* var meanpw = require( '@stdlib/stats/base/meanpw' );
*
* var x = [ 2.0, 1.0, 2.0, -2.0, -2.0, 2.0, 3.0, 4.0 ];
* var N = floor( x.length / 2 );
*
* var v = meanpw.ndarray( N, x, 2, 1 );
* // returns 1.25
*/

// MODULES //

var meanpw = require( './main.js' );


// EXPORTS //

module.exports = meanpw;
