/**
* @license Apache-2.0
*
* Copyright (c) 2020 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var addon = require( './../src/addon.node' );


// MAIN //

/**
* Rounds a single-precision floating-point number toward negative infinity.
*
* @private
* @param {number} x - input value
* @returns {number} rounded value
*
* @example
* var v = floorf( -4.2 );
* // returns -5.0
*
* @example
* var v = floorf( 9.99999 );
* // returns 9.0
*
* @example
* var v = floorf( 0.0 );
* // returns 0.0
*
* @example
* var v = floorf( NaN );
* // returns NaN
*/
function floorf( x ) {
	return addon( x );
}


// EXPORTS //

module.exports = floorf;
