## 100+ Free resources for learning Full Stack Web Development.

#### **Hello! I created this list and am constantly updating it with new resources, information, and news. If you want to stay updated on the newest trends, tutorials, and articles in the Web Development world, please subscribe to my once-weekly newsletter!**

### [Subscribe To The Weekly Newsletter Here](https://docs.google.com/forms/d/e/1FAIpQLSeQYYmBCBfJF9MXFmRJ7hnwyXvMwyCtHC5wxVDh5Cq--VT6Fg/viewform)

_Never more than one email per week. Easy to unsubscribe. Your information will **never** be shared._

---

### Table of Contents
1. **[Start Here](#start-here)**
2. **[How to learn](#how-to-learn)**
3. **[What is the Most Useful CS Bookmark You have](#what-is-the-single-most-useful-cs-bookmark-you-have)**
4. **[Programs & Classes](#programs-and-classes)**
5. **[Learn HTML](#learn-html)**
6. **[Learn CSS](#learn-css)**
7. **[Learn JavaScript](#learn-javascript)**
8. **[Learn React.js](#learn-react-js)**
9. **[Full Stack Tutorials](#full-stack-tutorials)**
10. **[Learn Node.js](#learn-node-js)**
11. **[Learn Python](#learn-python)**
12. **[Learn APIs](#learn-apis)**
13. **[Learn Databases](#learn-databases)**
14. **[Learn Authentication](#learn-authentication)**
15. **[Learn Git](#learn-git)**
16. **[Games & Challenge Websites](#games-and-challenge-websites)**
17. **[Free Programming Books](#free-programming-books)**
18. **[Open Source Contribution Opportunities](#open-source-contribution-opportunities)**
19. **[Am I Ready to be a Developer?](#am-i-ready-to-be-a-developer)**
20. **[Software Developer Success Stories](#software-developer-success-stories)**
21. **[Resume's, Portfolio's, LinkedIn, Interview Prep, & Salary Information](#get-the-job)**

---

### Start Here
The list below isn't meant to be exclusive, it's more so a collection of links that have helped me out along the way (and can hopefully help you). As you'll see, I've focused on JavaScript, React, and Node.js. There is also a wealth of information on interview prep and applying to jobs.

More free resources can be found on [codeburst.io](https://codeburst.io)

---

* Take a look at the big picture: 
  * [Web Developer Roadpath - Github Repo](https://github.com/kamranahmedse/developer-roadmap)
  * YouTube video outlining what to learn (similar to above, but in video format) - [Watch this if you want to become a web developer](https://www.youtube.com/watch?v=sBzRwzY7G-k)
* Learn about the common tools associated with full stack web development - [What is the A-Z of Web Development?](https://www.quora.com/What-is-the-A-Z-of-web-development-and-web-design)
* [My journey to becoming a web developer from scratch without a CS degree (and what I learned from it)](https://medium.freecodecamp.com/my-journey-to-becoming-a-web-developer-from-scratch-without-a-cs-degree-2-years-later-and-what-i-4a7fd2ff5503#.vk5vkb18q) (Medium)
* What happens when you type google into your address bar? 
  * [Reddit Link](https://www.reddit.com/r/cscareerquestions/comments/55ydbs/common_interview_question_what_happens_when_you/)
  * [Tuts Plus - The http protocol every web developer must know](https://code.tutsplus.com/tutorials/http-the-protocol-every-web-developer-must-know-part-1--net-31177)
* Find a local Web Development related [Meetup!](https://www.meetup.com/) Don't worry, it's not as scary as you might think, and is one of the best ways to start learning

---
### How to Learn
* How to Learn.
  * Coursera Course (Not CS Specific) - [Learning how to learn](https://www.coursera.org/learn/learning-how-to-learn)
  * Repetition, Repetition, Repetition - [Reddit Discussion on study techniques](https://www.reddit.com/r/learnprogramming/comments/5pyx5t/a_beginners_trick_i_learned_way_too_late_in_the/)
  * What technologies to learn and strategies to learn them - [How to learn web development](https://codetheweb.blog/2017/10/04/how-to-learn-web-development/)

---
### What is the Single most useful CS Bookmark you have?

* What is the single most useful CS Bookmark you have? [Reddit Link to discussion](https://www.reddit.com/r/cscareerquestions/comments/5bsg82/whats_the_single_most_useful_csrelated_link_you/)
  * [Learn X in Y Minutes](https://learnxinyminutes.com/)
  * [What CS Majors Should Know](http://matt.might.net/articles/what-cs-majors-should-know/)
  * [Google's Technical Development Guide](https://www.google.com/about/careers/students/guide-to-technical-development.html)
  * [CSS Tricks - Complete Flexbox Guide](https://css-tricks.com/snippets/css/a-guide-to-flexbox/)
  * [Regex Cheat Sheet](http://regexr.com/)
  * [DevDocs](http://devdocs.io)
  * [Awesome List of Everything Programming](https://github.com/sindresorhus/awesome)
  * [How to Break Into the Tech Industry—a Guide to Job Hunting and Tech Interviews](http://haseebq.com/how-to-break-into-tech-job-hunting-and-interviews/)

---
### Programs and Classes
* Programs
  * [The Odin Project](http://www.theodinproject.com/)
  * [FreeCodeCamp](https://www.freecodecamp.com/)
  * [The Essential Web Developer Course](http://upskillcourses.com/p/essential-web-developer-course)
  * [Epicodus Programming Bootcamp Curriculum](https://www.learnhowtoprogram.com/courses)
* Classes
  * [SANITIZED list of 530+ free online programming/CS courses (MOOCs) with feedback(i.e. exams/homeworks/assignments) that you can start this month (December 2016)](https://www.reddit.com/r/learnprogramming/comments/5gr8nw/heres_a_sanitized_list_of_530_free_online/) - *Needs Updating*
  * [Udacity Free Web Development Courses (Google)](https://www.udacity.com/courses/web-development)
* Bootcamps
  * [The Web Developer Bootcamp by Colt Steele](http://bit.ly/2yEYsoB). I include this paid course because it is worth its weight in gold. Inexpensive (less than $20) and one of the best resources out there. If you're going to buy one course to learn WebDev, buy this one. Also see - [The Advanced Web Dev Bootcamp](http://bit.ly/2z3TnGR)
  * [Thoughts on Coding Boot camps](https://www.reddit.com/r/learnprogramming/comments/5ew1gs/thoughts_on_coding_boot_camps/)
  * [The Complete Guide to Bootcamps](https://www.reddit.com/r/cscareerquestions/comments/506myw/the_complete_guide_to_bootcamps/)
  * Self Study - My programming notes. 275 Pages of Content [[Updated Reddit Link]](https://www.reddit.com/r/learnprogramming/comments/5opg9k/my_programming_notes_275_pages_summaries_of/) [[Original Reddit Link]](https://www.reddit.com/r/learnprogramming/comments/4iewun/my_programming_notes_141_pages_summaries_of/)
* GitHub
  * [A Step by Step Guide to Making Your First GitHub Contribution](https://codeburst.io/a-step-by-step-guide-to-making-your-first-github-contribution-5302260a2940)

---
### Learn HTML

* [Introduction to HTML - Mozilla Docs](https://developer.mozilla.org/en-US/docs/Learn/HTML/Introduction_to_HTML)
* [HTML5 Tutorial](http://www.html5tutorial.info)
* [HTML5 Introduction EDX](https://www.edx.org/course/html5-introduction-w3cx-html5-0x-0)
* [Learn to code HTML & CSS - Shay Howe](http://learn.shayhowe.com/html-css/)
* [HTML Fundamentals - SoloLearn](https://www.sololearn.com/Course/HTML/)
* [HTML Cheat Sheet](https://websitesetup.org/html5-cheat-sheet/)
* [HTML5 Full Tutorial - w3schools](https://www.w3schools.com/html/)
* [HTML5 Tutorial PDF DOWNLOAD - tutorialspoint](https://www.tutorialspoint.com/html5/html5_tutorial.pdf)
* [Learn HTML series - Code The Web](https://codetheweb.blog/learn/html/)

---
### Learn CSS

* [Everything you need to know about Flexbox](https://medium.freecodecamp.com/understanding-flexbox-everything-you-need-to-know-b4013d4dc9af#.nusbqoyuc)
* [Build a Minimalist HTML Card in just 53 lines of code (with Flexbox)](https://codeburst.io/build-a-minimalist-html-card-in-just-53-lines-of-code-with-flexbox-b40801927eb5)
* A visual guide to CSS - [CSS Reference](http://cssreference.io/)
* [CSS Pro Tips](https://github.com/AllThingsSmitty/css-protips?utm_source=mybridge&utm_medium=blog&utm_campaign=read_more) - A collection of tips to help take your CSS skills pro.
* [10 principles for smooth web animations](https://blog.gyrosco.pe/smooth-css-animations-7d8ffc2c1d29#.y6p8vkehd)
* [Css Fundamentals - SoloLearn](https://www.sololearn.com/Course/CSS/)
* [CSS Cheat Sheet](https://websitesetup.org/css3-cheat-sheet/)

---
### Learn JavaScript

* Javascript [Docs](https://developer.mozilla.org/en-US/docs/Web/JavaScript)
* Courses/Tutorials
  * [Recent News, Articles, Tutorials on JavaScript](https://codeburst.io/tagged/javascript)
  * [JavaScript for Beginners - Understand the hard stuff](https://codeburst.io/javascript-for-beginners-a-new-series-22762d8e5c42)
  * [Javascript for Beginners (1) EDX](https://www.edx.org/course/html5-part-1-html5-coding-essentials-w3cx-html5-1x-1)
  * [Javascript for Beginners (2) EDX](https://www.edx.org/course/html5-part-2-advanced-techniques-w3cx-html5-2x-1)
  * Javascript [The Right Way](http://jstherightway.org/)
  * Courses.AngularClass.com - Topics Include: webpack, nodejs, npm, es5, es6, esnext, & rxjs, typescript
    * [[Course Link]](http://courses.angularclass.com/courses/modern-javascript) [[Reddit Post]](https://www.reddit.com/r/learnjavascript/comments/4vz5y6/learn_modern_javascript_for_free_topics_covered/)
  * Edabit - Learn JavaScript With Interactive Challenges: Earn XP, Unlock Achievements & Climb The Leaderboard
    * [[Edabit - Website Link]](https://edabit.com/explore) [[Reddit Post]](https://www.reddit.com/r/learnprogramming/comments/5vc3gb/learn_javascript_with_interactive_challenges_earn/)
  * [Free Advanced JavaScript Courses - Learn Object Oriented Programming, Call Apply, and Bind, Testing, Functional Programming, and much more](https://www.rithmschool.com/courses#advanced-javascript)
  * [Intermediate Course - Udacity - OOP JS](https://www.udacity.com/course/object-oriented-javascript--ud015)
  * [JavaScript Tutorial](https://www.sololearn.com/Course/JavaScript/)
* Understanding Tougher Topics  
  * [JavaScript - The keyword 'this' for beginners](https://codeburst.io/javascript-the-keyword-this-for-beginners-fb5238d99f85)
  * [JavaScript - Arrow Functions for Beginners](https://codeburst.io/javascript-arrow-functions-for-beginners-926947fc0cdc)
  * [JavaScript: What the heck is a Callback?](https://codeburst.io/javascript-what-the-heck-is-a-callback-aba4da2deced)
  * [JavaScript: What the heck is an Immediately-Invoked Function Expression?](https://codeburst.io/javascript-what-the-heck-is-an-immediately-invoked-function-expression-a0ed32b66c18)
  * [JavaScript for Beginners: The new Operator](https://codeburst.io/javascript-for-beginners-the-new-operator-cee35beb669e)
  * [Javascript: Learn Regular Expressions for Beginners](https://codeburst.io/javascript-learn-regular-expressions-for-beginners-bb6107015d91)
  * [JavaScript Template Literals and Tag Functions for Beginners](https://codeburst.io/javascript-template-literals-tag-functions-for-beginners-758a041160e1)
  * [JavaScript & the spread operator](https://codeburst.io/javascript-the-spread-operator-a867a71668ca)
  * [JavaScript: What is short-circuit evaluation?](https://codeburst.io/javascript-what-is-short-circuit-evaluation-ff22b2f5608c)
  * [JavaScript: What is the ternary operator?](https://codeburst.io/javascript-what-is-the-ternary-operator-c819af8a7f6c)
  * [JavaScript: Why does 3 + true = 4? (and 7 other tricky equations)](https://codeburst.io/javascript-why-does-3-true-4-and-7-other-tricky-equations-9dd13cb2a92a)
  * [JavaScript — What’s the difference between Null & Undefined?](https://codeburst.io/javascript-whats-the-difference-between-null-undefined-37793b5bfce6)
  * [Learn and Understand Recursion in JavaScript](https://codeburst.io/learn-and-understand-recursion-in-javascript-b588218e87ea)
  * [Understand Closures in JavaScript](https://codeburst.io/understand-closures-in-javascript-d07852fa51e7)

* Projects
  * [JS 30 For 30 - 30 Projects for 30 Days](https://javascript30.com/)
  * [Learn to Code with Projects - enlight.ml](https://enlight.ml/)
  * **[13 Weeks of JavaScript (Medium)](https://medium.com/@___aerox___/the-beginning-of-an-adventure-13-weeks-of-javascript-78107605d533#.xgqnrstd1)** - TONS of links to JS resources
* Articles/Books
  * [Three awesome (and free) eBooks for learning JavaScript](https://codeburst.io/three-awesome-and-free-ebooks-for-learning-javascript-c874f65bbd7a)
  * [Recursion, Recursion, Recursion (Medium)](https://medium.freecodecamp.com/recursion-recursion-recursion-4db8890a674d#.dtkatvb6j)
  * [Eloquent JS](http://eloquentjavascript.net/) - Free JavaScript Ebook
  * [You don't know JS](https://github.com/getify/You-Dont-Know-JS) - Free, hosted on GitHub
  * [JavaScript Garden](http://bonsaiden.github.io/JavaScript-Garden/) - learn about the quirky parts of JS
  * [Learning js Design patterns](https://addyosmani.com/resources/essentialjsdesignpatterns/book/) - Reusable solutions to commonly occurring problems
  * [Asynchronous Module Definition](http://requirejs.org/docs/api.html)

---
### Learn React JS

* Official React [Docs](https://facebook.github.io/react/docs/hello-world.html)
* Official React [Tutorial](https://facebook.github.io/react/tutorial/tutorial.html)
* 3rd Party Tutorials
  * [10 React Mini Patterns](https://hackernoon.com/10-react-mini-patterns-c1da92f068c5#.nn8nyilyi)
  * [Top 5 Tutorials for getting started with React](http://andrewhfarmer.com/getting-started-tutorials/)
  * [10 best ReactJS tutorials](http://noeticforce.com/best-reactjs-tutorials-with-examples)
  * [Three awesome courses for learning React JS (Paid courses under $20)](https://hackernoon.com/javascript-frameworks-learn-react-js-2ed10c0dc06d)
  * [React Starter Project Search](http://andrewhfarmer.com/starter-project/)
  * [Exploring the react Ecosystem!](https://www.toptal.com/react/navigating-the-react-ecosystem) - Article
  * [Code academy React program](HTTPS://www.codeacademy.com)
  * [Great Free React books](https://github.com/vhf/free-programming-books/blob/master/javascript-frameworks-resources.md) - Use this link first
  * [Code Daily](https://codedaily.io/)
  * [Build a Todo Application with React Native](https://codedaily.io/courses/2/Build-a-React-Native-Todo-Application)
  * [Learn to Animate with React Native](https://codedaily.io/courses/1/Animate-React-Native-UI-Elements)
* Medium Links:
  * [React Components, Elements, and Instances (Medium)](https://medium.com/@dan_abramov/react-components-elements-and-instances-90800811f8ca#.rjx4d6bgw)
  * [Working with React](https://medium.com/@prodia/working-with-react-js-3e21a2ff5443#.ensczdgi0)
  * [Beginners guide to React Router (Medium)](https://medium.com/@dabit3/beginner-s-guide-to-react-router-53094349669#.4lul6fhvy)
  * [Angular JS vs React JS (Medium)](https://medium.com/@paramsingh_66174/angularjs-vs-reactjs-e651a194dfcb#.bbx4qapwu)
  * [React Native: Nine Animation Screencast Tutorials](https://codeburst.io/react-native-nine-animation-screencast-tutorials-9d031e8bb86f)

---
### Full Stack Tutorials

* [Intro to Back End Web Development](https://www.udacity.com/course/intro-to-backend--ud171)
* [Deploying Applications with Heroku](https://www.udacity.com/course/deploying-applications-with-heroku--ud272)
* [Client Server Communication](https://www.udacity.com/course/client-server-communication--ud897)
* [Serverless Stack](http://serverless-stack.com/) is a comprehensive guide to creating full-stack serverless applications. Create a note taking app from scratch using React.js, AWS Lambda, API Gateway, DynamoDB, and Cognito.
* [Express - Using a DB with Mongoose](https://developer.mozilla.org/en-US/docs/Learn/Server-side/Express_Nodejs/mongoose)
* [Node JS and Databases](https://blog.risingstack.com/node-js-database-tutorial/)
* [Node JS and Authentication](https://blog.risingstack.com/node-hero-node-js-authentication-passport-js/)
* [Express JS Database Integration](https://expressjs.com/en/guide/database-integration.html)
* [MERN Stack Tutorial - Mongo, Express, React, Node](https://medium.com/@bryantheastronaut/react-getting-started-the-mern-stack-tutorial-feat-es6-de1a2886be50#.xfd2ixtz6)
* [MongoDB MERN Tutorial Series](https://www.mongodb.com/blog/post/the-modern-application-stack-part-1-introducing-the-mean-stack)
* [Full Stack MERN Tutorial - YouTube](https://www.youtube.com/watch?v=cV-bGvnRZdw)
* [Build a URL Shortener with Node, Hapi, and Mongo](https://codetuts.tech/build-a-url-shortener-node-hapi-js/?utm_source=mybridge&utm_medium=blog&utm_campaign=read_more)
* [How to Create a Complete Express.js + Node.js + MongoDB CRUD and REST Skeleton](https://www.airpair.com/javascript/complete-expressjs-nodejs-mongodb-crud-skeleton)
* [Building web app using react.js, express.js, node.js and mongodb](http://www.codeproject.com/Articles/1067725/Part-Building-web-app-using-react-js-express-js) - Part 1, 2
* [Trello tribute with Phoenix, React, Redux, PostgreSQL](http://codeloveandboards.com/blog/2016/01/04/trello-tribute-with-phoenix-and-react-pt-1/) - 12 parts
* [Create a character voting app using React, Node.js, MongoDB and Socket.IO](http://sahatyalkabov.com/create-a-character-voting-app-using-react-nodejs-mongodb-and-socketio/)
* [Building a React Universal Blog App: A Step-by-Step Guide](https://www.sitepoint.com/building-a-react-universal-blog-app-a-step-by-step-guide/)
* [Building a Secure RESTful Node.js app](http://thejackalofjavascript.com/architecting-a-restful-node-js-app/)
* Cool stuff other people have built:
* [Belgian Beer Explorer with React, Bootstrap, Node.js and Postgres](http://coenraets.org/blog/2015/01/belgian-beer-explorer-with-react-bootstrap-node-js-and-postgres/)
* [90 Full Stack React Examples (some with tuts)](https://react.rocks/tag/FullStack?show=40)
* [Confessions of an Unintentional CTO - lessons in growing a web app](https://www.jackkinsella.ie/books/confessions_of_an_unintentional_cto)

---
### Learn Node JS

* Official Node.js [Docs](https://nodejs.org/en/docs/)
* Resources for learning Node.js [[Reddit Link]](https://www.reddit.com/r/learnprogramming/comments/5xpidt/best_resource_to_learn_nodejs/)
  * [YouTube](https://www.youtube.com/watch?v=w-7RQ46RgxU&list=PL4cUxeGkcC9gcy9lrvMJ75z9maRw4byYp)
  * [Colt Steele's Bootcamp](http://bit.ly/2yEYsoB)
  * [Node School](https://nodeschool.io/#workshoppers)
  * [Medium - Why the hell would you use Node?](https://medium.com/the-node-js-collection/why-the-hell-would-you-use-node-js-4b053b94ab8e#.9s49rbove)
* Courses/Tutorials
  * [Three awesome courses for learning Node.js (Paid courses under $20)](https://codeburst.io/three-awesome-courses-for-learning-node-js-d7f761437101)
  * [Build a simple Twitter Bot with Node.js in just 38 lines of code](https://codeburst.io/build-a-simple-twitter-bot-with-node-js-in-just-38-lines-of-code-ed92db9eb078)
  * [Build a simple Twitter Bot with Node.js - PART 2](https://codeburst.io/build-a-simple-twitter-bot-with-node-js-part-2-do-more-2ef1e039715d)
  * [Build a simple Weather App with Node.js in just 16 lines of code](https://codeburst.io/build-a-simple-weather-app-with-node-js-in-just-16-lines-of-code-32261690901d)
  * [Learn to build an Amazon Alexa Skill with Node.js (and get paid to do it)](https://codeburst.io/learn-to-build-an-amazon-alexa-skill-with-node-js-and-get-paid-to-do-it-cf55ae534650)
  * [Building a modern backend API with Node](https://scotch.io/tutorials/building-and-securing-a-modern-backend-api?utm_source=mybridge&utm_medium=blog&utm_campaign=read_more)
  * [Node JS Login with Passport - YouTube](https://www.youtube.com/watch?v=Z1ktxiqyiLA)
  * [10 Best Practices for Writing Node.js REST APIs](https://blog.risingstack.com/10-best-practices-for-writing-node-js-rest-apis/?utm_source=mybridge&utm_medium=blog&utm_campaign=read_more)
* Optimization Techniques
  * [Make your node server faster by caching responses with redis](https://community.risingstack.com/redis-node-js-introduction-to-caching/)
   


---
### Learn Python
* [15 Free e-books to learn Python](https://medium.com/@bmorelli25/15-free-ebooks-to-learn-python-c299943f9f2c)
* [Programming Foundations with Python - Udacity](https://www.udacity.com/course/programming-foundations-with-python--ud036)
* [Designing RESTful APIs - Udacity](https://www.udacity.com/course/designing-restful-apis--ud388)

---
### Learn APIs

* Where to start with learning APIs [[Reddit Link]](https://www.reddit.com/r/learnprogramming/comments/5761ir/where_to_start_with_learning_how_to_use_apis/)
  * [What is an API? In English Please. (Medium)](https://medium.freecodecamp.com/what-is-an-api-in-english-please-b880a3214a82#.vewp5i2n4)
  * [Build a simple Weather App with Node.js in just 16 lines of code](https://codeburst.io/build-a-simple-weather-app-with-node-js-in-just-16-lines-of-code-32261690901d)
  * [Build Node.js RESTful APIs in 10 Minutes](https://www.codementor.io/olatundegaruba/nodejs-restful-apis-in-10-minutes-q0sgsfhbd)
  * [Free Intro to APIs Book/Course by Zapier](https://zapier.com/learn/apis/)
  * [Google Maps API](https://developers.google.com/maps/documentation/)
  * [Distance Calculator Web Services API](https://developers.google.com/maps/documentation/distance-matrix/start)
  * [Build and Secure a Backend API Server](https://www.udacity.com/course/designing-restful-apis--ud388)

---
### Learn Databases
* [SQL vs NoSQL](https://www.digitalocean.com/community/tutorials/understanding-sql-and-nosql-databases-and-different-database-models)
* [Intro to Relational Databases](https://www.udacity.com/course/intro-to-relational-databases--ud197) - SQL, DB-API, and More!
* [MongoDB University](https://university.mongodb.com/) - Numerous classes on learning MongoDB
* [PostgreSQL Tutorial](https://www.tutorialspoint.com/postgresql/)
* [PostgreSQL Exercises](https://pgexercises.com/)
* [Learn PostgreSQL (GitHub)](https://github.com/dwyl/learn-postgresql)
* [Try Redis](https://try.redis.io/)
* [Redis Tutorial](https://www.tutorialspoint.com/redis/)

---
### Learn Authentication
* [Authentication & Authorization: OAuth](https://www.udacity.com/course/authentication-authorization-oauth--ud330)
* [Learn about JSON Web Tokens](https://jwt.io/introduction/)
* [JWT Sample App Example](https://scotch.io/tutorials/authenticate-a-node-js-api-with-json-web-tokens)
* [OAuth 2](https://aaronparecki.com/oauth-2-simplified/#web-server-apps)
* [Passwordless Authentication with React and Auth0](https://medium.com/javascript-scene/passwordless-authentication-with-react-and-auth0-c4cb003c7cde#.l1joiokr2)

---
### Learn Git
* Official [Tutorial](https://try.github.io/levels/1/challenges/1) - Learn Git in 15 Minutes
* Official [Docs](https://git-scm.com/documentation)
* Other Tuts:
  * [Git, the simple guide](http://rogerdudler.github.io/git-guide/)
  * [Learn Git Branching - Level by Level learning](http://learngitbranching.js.org/)
  * [Learn Git in 30 Minutes - Article](http://tutorialzine.com/2016/06/learn-git-in-30-minutes/)
  * [Here are all the Git commands I used last week and what they do (Medium)](https://medium.freecodecamp.com/git-cheat-sheet-and-best-practices-c6ce5321f52)
* Why to Use GIT [No, I have no side projects to show you](https://www.linkedin.com/pulse/i-have-side-code-projects-show-you-ezekiel-buchheit)

---
### Games and Challenge Websites

* Games to learn Programming in an easy and fun way [[Reddit Link]](https://www.reddit.com/r/learnprogramming/comments/5wwkxi/do_you_recommend_any_games_to_learn_coding_in_an/)
  * [Flex Box Froggy](http://flexboxfroggy.com/)
  * [Flex Box Defense](http://www.flexboxdefense.com/)
  * [Edabit](https://edabit.com/explore)
  * [Coding Game](https://www.codingame.com)
  * [Elevator Saga - JS](http://play.elevatorsaga.com/)
  * [Scratch - Absolute Basics](https://scratch.mit.edu/)
  * [Hacked - Mobile App teaching through puzzles](http://www.hackedapp.com/)

* Coding Challenge Websites [[Reddit Link]](https://www.reddit.com/r/learnprogramming/comments/5oxwjj/any_good_sitesapps_for_small_coding_exercises/) [[Reddit Link #2]](https://www.reddit.com/r/learnprogramming/comments/5g3xgi/anyone_knows_the_name_of_a_website_to_learn_to/)
  * [Medium - 10 most popular coding challenge sites of 2016](https://medium.com/coderbyte/the-10-most-popular-coding-challenge-websites-of-2016-fb8a5672d22f#.fn8c7imvk)
  * [Codechef](https://www.codechef.com/)
  * [Code Wars](https://www.codewars.com/)
  * [Coding Game](https://www.codingame.com)
  * [Hacker Rank (some debate about this being good/bad](https://www.hackerrank.com/domains/cpp/cpp-introduction)
  * [Project Euler (math focus)](https://projecteuler.net/)
  * [Exercism](http://exercism.io/)

---
### Free Programming Books

  * [O'Reilly Offering Programming eBooks for Free (Reddit)](https://www.reddit.com/r/learnprogramming/comments/556kxj/oreilly_offering_programming_ebooks_for_free/)
  * [GitHub - Thousands of free programming Books on every topic](https://github.com/vhf/free-programming-books/blob/master/free-programming-books.md)
  * [Non-Technical Books to make you a better Programmer (Reddit)](https://www.reddit.com/r/learnprogramming/comments/51zz5g/what_non_technical_books_can_i_bring_with_me/)

---
### Open Source Contribution Opportunities

* [Contributing to Open Source on GitHub](https://guides.github.com/activities/contributing-to-open-source/) - The official GitHub guide.
* [Make your first open source contribution in 5 minutes](https://github.com/Roshanjossey/first-contributions)
* [How do I get skilled enough to work on open source projects?](https://www.reddit.com/r/learnprogramming/comments/4xts2c/how_do_i_get_skilled_enough_to_work_on_open/)
* [Exercism](https://github.com/exercism/exercism.io), an open source project to learn programming and a good opportunity to get you started contributing on github.
* Open Source Contribution Opportunites [[Reddit Discussion]](https://www.reddit.com/r/learnprogramming/comments/5wgefy/many_devs_here_on_reddit_and_on_slack_were_asking/)
  * [Redditor Form to fill out to get notified about Open Source Opportunities](https://devchat.devolio.net/hellocode/)
  * [Up For Grabs - Browse a list of projects with curated tasks](http://up-for-grabs.net/#/)
* [Hacktoberfest](https://hacktoberfest.digitalocean.com/) - Open source activity held every October. Easy to participate, and you get a free t-shirt!
* [I'm afraid if I say anything on GitHub people will laugh at me and I will die.](https://www.reddit.com/r/learnprogramming/comments/4pgb44/im_afraid_if_i_say_anything_on_github_people_will/)

---
### Am I Ready to be a Developer?

* Readiness
  * [Self taught front end devs... When did you know that you were "Job ready"?](https://www.reddit.com/r/learnprogramming/comments/59paoi/self_taught_front_end_devs_when_did_you_know_that/)
  * [People who are self-taught developers, how long did it take you to get your first job?](https://www.reddit.com/r/cscareerquestions/comments/53avew/people_who_are_selftaught_developers_how_long_did/)
  * [When do you know when you're ready to start interviewing?](https://www.reddit.com/r/learnprogramming/comments/52c3os/when_do_you_know_when_youre_ready_to_start/)
* [Software developers- what is the best advice you have for people learning CS?](https://www.reddit.com/r/cscareerquestions/comments/516gps/software_developers_what_is_the_best_advice_you/)
* [I want a career in programming](https://www.reddit.com/r/learnprogramming/comments/5516vo/i_want_a_career_in_programming/)
* What should you know as a web dev just out of college?
  * [Reddit Discussion - newer](https://www.reddit.com/r/cscareerquestions/comments/5dg39i/what_should_you_know_as_a_web_dev_just_out_of/)
  * [What CS Majors Should Know - older](http://matt.might.net/articles/what-cs-majors-should-know/)
* How I got started with Side Projects - [link](http://antrikshy.com/blog/how-i-got-started-with-programming-side-projects)
* [What are some goals a beginning Self-Taught Developer should have?](https://www.reddit.com/r/learnprogramming/comments/4vr2of/what_are_some_goals_a_beginning_selftaught/)
* [Computer programmers of Reddit, what is your best advice to someone who is currently learning how to code?](https://www.reddit.com/r/AskReddit/comments/4f1tgy/computer_programmers_of_reddit_what_is_your_best/)
* [I began teaching myself to code a year ago. I got hired at my first job 4 months ago. Here is a breakdown of somethings I was not ready for (FYI job is remote ruby/rails dev)](https://www.reddit.com/r/learnprogramming/comments/4y7e3d/i_began_teaching_myself_to_code_a_year_ago_i_got/)

---
### Software Developer Success Stories

* Success Stories
  * [18 months ago I didn’t know how to code, I’m now a self-taught programmer who’s made apps for the NBA, NHL, and schools like Purdue, Notre Dame, Alabama and Clemson. I’m now releasing my software under the MIT license for anyone’s use — AMA!](https://www.reddit.com/r/IAmA/comments/5pouv4/18_months_ago_i_didnt_know_how_to_code_im_now_a/)
  * [Last year I was unemployed and miserable. Using this sub and resources, I've been full time employed for a year. I did it with all free resources. I wanna share with you how I did it. (IOS)](https://www.reddit.com/r/learnprogramming/comments/590v8l/last_year_i_was_unemployed_and_miserable_using/)
  * [I began teaching myself to code a year ago. I got hired at my first job 4 months ago. Here is a breakdown of somethings I was not ready for (FYI job is remote ruby/rails dev)](https://www.reddit.com/r/learnprogramming/comments/4y7e3d/i_began_teaching_myself_to_code_a_year_ago_i_got/)
  * [I'm 32 years old, and just started my first full-time job as a developer. One year ago my programming knowledge was basically nil. Everything I learned, I found via /r/learnprogramming, so just wanted to share my experience.](https://www.reddit.com/r/learnprogramming/comments/34r807/im_32_years_old_and_just_started_my_first/)
  * [From zero to software developer - Not really a success story, but a lot of redditors share how they learned. Great for beginners with no path](https://www.reddit.com/r/learnprogramming/comments/5elrb5/from_zero_to_software_developer/)

---
### Get The Job
**Resume, Portfolio, LinkedIn, Interview Prep, and Salary Information**
* Make your portfolio
  * [Customizable Web Developer Portfolio](https://github.com/bmorelli25/portfolio-template) - Built with Flexbox. 
  * [10 Awesome Web Developer Portfolios](https://codeburst.io/10-awesome-web-developer-portfolios-d266b32e6154)

* How to Apply
  * [I spent 3 months applying to jobs after a coding bootcamp. Here’s what I learned. (Medium)](https://medium.freecodecamp.com/5-key-learnings-from-the-post-bootcamp-job-search-9a07468d2331#.lpuzt5pnw)
  * [Lessons from my Post-bootcamp Job search (Medium)](https://medium.freecodecamp.com/lessons-from-my-post-bootcamp-job-search-in-london-cb37ea12ec2f#.u83avhawf)
  * [How to land a six figure job in tech with no connections (Medium)](https://medium.freecodecamp.com/how-you-can-land-a-6-figure-job-in-tech-with-no-connections-6eed0de26ea4#.9cc270q7j)

* Resume & LinkedIn
  * [What are some of the best resuмe formats you've seen?](https://www.reddit.com/r/cscareerquestions/comments/5gnmkj/what_are_some_of_the_best_resu%D0%BCe_formats_youve/)
  * [Model examples for Fullstack Developer LinkedIn profiles](https://www.reddit.com/r/cscareerquestions/comments/5f5e3f/what_are_some_model_examples_for_fullstack/)

* Personal Projects
  * [Recruiters, what kind of CS projects impress?](https://www.reddit.com/r/cscareerquestions/comments/586lbg/recruiters_what_kind_of_cs_projects_impress/)

* Interview Prep
  * [CS50 - Prep and Practice for Technical Interviews [YouTube]](https://youtu.be/qIi-tIrcaww?t=2m32s)
  * [How to Break Into the Tech Industry—a Guide to Job Hunting and Tech Interviews](http://haseebq.com/how-to-break-into-tech-job-hunting-and-interviews/)
  * Common JavaScript Interview Questions Repo
    * [GitHub Repo - All questions and answers](https://github.com/kennymkchan/interview-questions-in-javascript)
    * [Reddit Post - Discussion, with additional questions and answers](https://www.reddit.com/r/learnprogramming/comments/5sa35k/fun_github_repo_containing_common_interview/)
  * [Ammon Bartram - Ask an interviewer anything: interview questions, answers, mistakes](https://www.reddit.com/r/cscareerquestions/comments/5y95x6/i_am_ammon_bartram_and_i_have_done_900/)
  * [Sharing some interview tips (Silicon valley employee)](https://www.reddit.com/r/cscareerquestions/comments/5w2oyn/sharing_some_interview_tips/)
  * [Job interview questions to ask the interviewer](https://www.reddit.com/r/AskReddit/comments/5iqnkj/at_the_end_of_a_job_interview_they_always_ask/)
  * [I suck at programming interviews.](https://www.reddit.com/r/cscareerquestions/comments/5dk7we/i_suck_at_programming_interviews_maybe_i_suck_too/)
  * [When solving an interview problem, talk all the time.](https://www.reddit.com/r/cscareerquestions/comments/58htcc/when_solving_an_interview_problem_talk_all_the/)
  * [Hiring managers (or other seasoned developers), what qualities do you look for in your ideal candidate?](https://www.reddit.com/r/cscareerquestions/comments/5557j0/hiring_managers_or_other_seasoned_developers_what/)
  * [Post your best interview questions](https://www.reddit.com/r/cscareerquestions/comments/4rdcy0/post_your_best_interview_questions/)
  * [Been interviewing with a lot of tech startups as a frontend dev, here are the technical questions I've been asked (MID-SENIOR LEVEL)](https://www.reddit.com/r/webdev/comments/3f7q3q/been_interviewing_with_a_lot_of_tech_startups_as/)
  * [10 Interview Questions every JS Developer should know (Medium)](https://medium.com/javascript-scene/10-interview-questions-every-javascript-developer-should-know-6fa6bdf5ad95#.v0dk97v5v)

* Salary Information
  * [How Much Do Software Developers Make in 2017?](https://codeburst.io/how-much-do-software-developers-make-in-2017-e6ae657966be)
  * [12/2016 Salary Sharing Thread (<2 yrs Experience)](https://www.reddit.com/r/cscareerquestions/comments/5h6xvj/official_salary_sharing_thread_for_new_grads/)
  * [Salary Negotiations and how not to set a bunch of money on fire (Medium)](https://medium.freecodecamp.com/salary-negotiation-how-not-to-set-a-bunch-of-money-on-fire-605aabbaf84b#.75xz4zut8)
  * [10 Rules for negotiating a job offer (Medium)](https://medium.freecodecamp.com/ten-rules-for-negotiating-a-job-offer-ee17cccbdab6#.g8u1wnyw8)
  * [How not to bomb your offer negotiation (Medium)](https://medium.freecodecamp.com/how-not-to-bomb-your-offer-negotiation-c46bb9bc7dea#.vdfc82rl7)
  
---
### Assorted Links

* Tutorial/Screencast: [Lets Learn Algorithms: An Intro to Binary Search](https://www.reddit.com/r/learnprogramming/comments/5d56pd/lets_learn_algorithms_an_intro_to_binary_search/)
* JavaScript / Node / Angular 1 & 2 / React / Elm / C# / PHP / SQL / Git [Google Drive](https://drive.google.com/folderview?id=0BztLOG55I2FVT0NNLTVXM1JOYlk&usp=sharing)
* [Watch And Code](https://watchandcode.com/)
* [RegexOne](http://regexone.com/) - Learn Regular Expressions
* [Google University GitHub Repo](https://github.com/jwasham/coding-interview-university)
* [Regex 101 by Daniel Shiffman](https://www.youtube.com/playlist?list=PLRqwX-V7Uu6YEypLuls7iidwHMdCM6o2w)
* [20 Developers to Follow on Twitter](https://codeburst.io/best-web-developers-to-follow-on-twitter-9318a3f6525a)
