// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A structure describing the source of an action.
type ActionSource struct {

	// The URI of the source.
	//
	// This member is required.
	SourceUri *string

	// The ID of the source.
	SourceId *string

	// The type of the source.
	SourceType *string

	noSmithyDocumentSerde
}

// Lists the properties of an action. An action represents an action or activity.
// Some examples are a workflow step and a model deployment. Generally, an action
// involves at least one input artifact or output artifact.
type ActionSummary struct {

	// The Amazon Resource Name (ARN) of the action.
	ActionArn *string

	// The name of the action.
	ActionName *string

	// The type of the action.
	ActionType *string

	// When the action was created.
	CreationTime *time.Time

	// When the action was last modified.
	LastModifiedTime *time.Time

	// The source of the action.
	Source *ActionSource

	// The status of the action.
	Status ActionStatus

	noSmithyDocumentSerde
}

// A structure of additional Inference Specification. Additional Inference
// Specification specifies details about inference jobs that can be run with models
// based on this model package
type AdditionalInferenceSpecificationDefinition struct {

	// The Amazon ECR registry path of the Docker image that contains the inference
	// code.
	//
	// This member is required.
	Containers []ModelPackageContainerDefinition

	// A unique name to identify the additional inference specification. The name must
	// be unique within the list of your additional inference specifications for a
	// particular model package.
	//
	// This member is required.
	Name *string

	// A description of the additional Inference specification
	Description *string

	// The supported MIME types for the input data.
	SupportedContentTypes []string

	// A list of the instance types that are used to generate inferences in real-time.
	SupportedRealtimeInferenceInstanceTypes []ProductionVariantInstanceType

	// The supported MIME types for the output data.
	SupportedResponseMIMETypes []string

	// A list of the instance types on which a transformation job can be run or on
	// which an endpoint can be deployed.
	SupportedTransformInstanceTypes []TransformInstanceType

	noSmithyDocumentSerde
}

// A data source used for training or inference that is in addition to the input
// dataset or model data.
type AdditionalS3DataSource struct {

	// The data type of the additional data source that you specify for use in
	// inference or training.
	//
	// This member is required.
	S3DataType AdditionalS3DataSourceDataType

	// The uniform resource identifier (URI) used to identify an additional data
	// source used in inference or training.
	//
	// This member is required.
	S3Uri *string

	// The type of compression used for an additional data source used in inference or
	// training. Specify None if your additional data source is not compressed.
	CompressionType CompressionType

	noSmithyDocumentSerde
}

// Edge Manager agent version.
type AgentVersion struct {

	// The number of Edge Manager agents.
	//
	// This member is required.
	AgentCount *int64

	// Version of the agent.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// An Amazon CloudWatch alarm configured to monitor metrics on an endpoint.
type Alarm struct {

	// The name of a CloudWatch alarm in your account.
	AlarmName *string

	noSmithyDocumentSerde
}

// Specifies the training algorithm to use in a [CreateTrainingJob] request.
//
// For more information about algorithms provided by SageMaker, see [Algorithms]. For
// information about using your own algorithms, see [Using Your Own Algorithms with Amazon SageMaker].
//
// [Algorithms]: https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html
// [Using Your Own Algorithms with Amazon SageMaker]: https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html
// [CreateTrainingJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html
type AlgorithmSpecification struct {

	// The training input mode that the algorithm supports. For more information about
	// input modes, see [Algorithms].
	//
	// Pipe mode
	//
	// If an algorithm supports Pipe mode, Amazon SageMaker streams data directly from
	// Amazon S3 to the container.
	//
	// File mode
	//
	// If an algorithm supports File mode, SageMaker downloads the training data from
	// S3 to the provisioned ML storage volume, and mounts the directory to the Docker
	// volume for the training container.
	//
	// You must provision the ML storage volume with sufficient capacity to
	// accommodate the data downloaded from S3. In addition to the training data, the
	// ML storage volume also stores the output model. The algorithm container uses the
	// ML storage volume to also store intermediate information, if any.
	//
	// For distributed algorithms, training data is distributed uniformly. Your
	// training duration is predictable if the input data objects sizes are
	// approximately the same. SageMaker does not split the files any further for model
	// training. If the object sizes are skewed, training won't be optimal as the data
	// distribution is also skewed when one host in a training cluster is overloaded,
	// thus becoming a bottleneck in training.
	//
	// FastFile mode
	//
	// If an algorithm supports FastFile mode, SageMaker streams data directly from S3
	// to the container with no code changes, and provides file system access to the
	// data. Users can author their training script to interact with these files as if
	// they were stored on disk.
	//
	// FastFile mode works best when the data is read sequentially. Augmented manifest
	// files aren't supported. The startup time is lower when there are fewer files in
	// the S3 bucket provided.
	//
	// [Algorithms]: https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html
	//
	// This member is required.
	TrainingInputMode TrainingInputMode

	// The name of the algorithm resource to use for the training job. This must be an
	// algorithm resource that you created or subscribe to on Amazon Web Services
	// Marketplace.
	//
	// You must specify either the algorithm name to the AlgorithmName parameter or
	// the image URI of the algorithm container to the TrainingImage parameter.
	//
	// Note that the AlgorithmName parameter is mutually exclusive with the
	// TrainingImage parameter. If you specify a value for the AlgorithmName
	// parameter, you can't specify a value for TrainingImage , and vice versa.
	//
	// If you specify values for both parameters, the training job might break; if you
	// don't specify any value for both parameters, the training job might raise a null
	// error.
	AlgorithmName *string

	// The arguments for a container used to run a training job. See [How Amazon SageMaker Runs Your Training Image] for additional
	// information.
	//
	// [How Amazon SageMaker Runs Your Training Image]: https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-training-algo-dockerfile.html
	ContainerArguments []string

	// The [entrypoint script for a Docker container] used to run a training job. This script takes precedence over the default
	// train processing instructions. See [How Amazon SageMaker Runs Your Training Image]for more information.
	//
	// [entrypoint script for a Docker container]: https://docs.docker.com/engine/reference/builder/
	// [How Amazon SageMaker Runs Your Training Image]: https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-training-algo-dockerfile.html
	ContainerEntrypoint []string

	// To generate and save time-series metrics during training, set to true . The
	// default is false and time-series metrics aren't generated except in the
	// following cases:
	//
	//   - You use one of the SageMaker built-in algorithms
	//
	//   - You use one of the following [Prebuilt SageMaker Docker Images]:
	//
	//   - Tensorflow (version >= 1.15)
	//
	//   - MXNet (version >= 1.6)
	//
	//   - PyTorch (version >= 1.3)
	//
	//   - You specify at least one [MetricDefinition]
	//
	// [MetricDefinition]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_MetricDefinition.html
	// [Prebuilt SageMaker Docker Images]: https://docs.aws.amazon.com/sagemaker/latest/dg/pre-built-containers-frameworks-deep-learning.html
	EnableSageMakerMetricsTimeSeries *bool

	// A list of metric definition objects. Each object specifies the metric name and
	// regular expressions used to parse algorithm logs. SageMaker publishes each
	// metric to Amazon CloudWatch.
	MetricDefinitions []MetricDefinition

	// The registry path of the Docker image that contains the training algorithm. For
	// information about docker registry paths for SageMaker built-in algorithms, see [Docker Registry Paths and Example Code]
	// in the Amazon SageMaker developer guide. SageMaker supports both
	// registry/repository[:tag] and registry/repository[@digest] image path formats.
	// For more information about using your custom training container, see [Using Your Own Algorithms with Amazon SageMaker].
	//
	// You must specify either the algorithm name to the AlgorithmName parameter or
	// the image URI of the algorithm container to the TrainingImage parameter.
	//
	// For more information, see the note in the AlgorithmName parameter description.
	//
	// [Using Your Own Algorithms with Amazon SageMaker]: https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html
	// [Docker Registry Paths and Example Code]: https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html
	TrainingImage *string

	// The configuration to use an image from a private Docker registry for a training
	// job.
	TrainingImageConfig *TrainingImageConfig

	noSmithyDocumentSerde
}

// Specifies the validation and image scan statuses of the algorithm.
type AlgorithmStatusDetails struct {

	// The status of the scan of the algorithm's Docker image container.
	ImageScanStatuses []AlgorithmStatusItem

	// The status of algorithm validation.
	ValidationStatuses []AlgorithmStatusItem

	noSmithyDocumentSerde
}

// Represents the overall status of an algorithm.
type AlgorithmStatusItem struct {

	// The name of the algorithm for which the overall status is being reported.
	//
	// This member is required.
	Name *string

	// The current status.
	//
	// This member is required.
	Status DetailedAlgorithmStatus

	// if the overall status is Failed , the reason for the failure.
	FailureReason *string

	noSmithyDocumentSerde
}

// Provides summary information about an algorithm.
type AlgorithmSummary struct {

	// The Amazon Resource Name (ARN) of the algorithm.
	//
	// This member is required.
	AlgorithmArn *string

	// The name of the algorithm that is described by the summary.
	//
	// This member is required.
	AlgorithmName *string

	// The overall status of the algorithm.
	//
	// This member is required.
	AlgorithmStatus AlgorithmStatus

	// A timestamp that shows when the algorithm was created.
	//
	// This member is required.
	CreationTime *time.Time

	// A brief description of the algorithm.
	AlgorithmDescription *string

	noSmithyDocumentSerde
}

// Defines a training job and a batch transform job that SageMaker runs to
// validate your algorithm.
//
// The data provided in the validation profile is made available to your buyers on
// Amazon Web Services Marketplace.
type AlgorithmValidationProfile struct {

	// The name of the profile for the algorithm. The name must have 1 to 63
	// characters. Valid characters are a-z, A-Z, 0-9, and - (hyphen).
	//
	// This member is required.
	ProfileName *string

	// The TrainingJobDefinition object that describes the training job that SageMaker
	// runs to validate your algorithm.
	//
	// This member is required.
	TrainingJobDefinition *TrainingJobDefinition

	// The TransformJobDefinition object that describes the transform job that
	// SageMaker runs to validate your algorithm.
	TransformJobDefinition *TransformJobDefinition

	noSmithyDocumentSerde
}

// Specifies configurations for one or more training jobs that SageMaker runs to
// test the algorithm.
type AlgorithmValidationSpecification struct {

	// An array of AlgorithmValidationProfile objects, each of which specifies a
	// training job and batch transform job that SageMaker runs to validate your
	// algorithm.
	//
	// This member is required.
	ValidationProfiles []AlgorithmValidationProfile

	// The IAM roles that SageMaker uses to run the training jobs.
	//
	// This member is required.
	ValidationRole *string

	noSmithyDocumentSerde
}

// Configures how labels are consolidated across human workers and processes
// output data.
type AnnotationConsolidationConfig struct {

	// The Amazon Resource Name (ARN) of a Lambda function implements the logic for [annotation consolidation]
	// and to process output data.
	//
	// This parameter is required for all labeling jobs. For [built-in task types], use one of the
	// following Amazon SageMaker Ground Truth Lambda function ARNs for
	// AnnotationConsolidationLambdaArn . For custom labeling workflows, see [Post-annotation Lambda].
	//
	// Bounding box - Finds the most similar boxes from different workers based on the
	// Jaccard index of the boxes.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:ACS-BoundingBox
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:ACS-BoundingBox
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:ACS-BoundingBox
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:ACS-BoundingBox
	//
	//   - arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-BoundingBox
	//
	//   - arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-BoundingBox
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:ACS-BoundingBox
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:ACS-BoundingBox
	//
	//   - arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-BoundingBox
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:ACS-BoundingBox
	//
	//   - arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-BoundingBox
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:ACS-BoundingBox
	//
	// Image classification - Uses a variant of the Expectation Maximization approach
	// to estimate the true class of an image based on annotations from individual
	// workers.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClass
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClass
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClass
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClass
	//
	//   - arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClass
	//
	//   - arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClass
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClass
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClass
	//
	//   - arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClass
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClass
	//
	//   - arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClass
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClass
	//
	// Multi-label image classification - Uses a variant of the Expectation
	// Maximization approach to estimate the true classes of an image based on
	// annotations from individual workers.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:ACS-ImageMultiClassMultiLabel
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:ACS-ImageMultiClassMultiLabel
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:ACS-ImageMultiClassMultiLabel
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:ACS-ImageMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-ImageMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-ImageMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:ACS-ImageMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:ACS-ImageMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-ImageMultiClassMultiLabel
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:ACS-ImageMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-ImageMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:ACS-ImageMultiClassMultiLabel
	//
	// Semantic segmentation - Treats each pixel in an image as a multi-class
	// classification and treats pixel annotations from workers as "votes" for the
	// correct label.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:ACS-SemanticSegmentation
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:ACS-SemanticSegmentation
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:ACS-SemanticSegmentation
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:ACS-SemanticSegmentation
	//
	//   - arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-SemanticSegmentation
	//
	//   - arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-SemanticSegmentation
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:ACS-SemanticSegmentation
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:ACS-SemanticSegmentation
	//
	//   - arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-SemanticSegmentation
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:ACS-SemanticSegmentation
	//
	//   - arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-SemanticSegmentation
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:ACS-SemanticSegmentation
	//
	// Text classification - Uses a variant of the Expectation Maximization approach
	// to estimate the true class of text based on annotations from individual workers.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClass
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClass
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClass
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClass
	//
	//   - arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClass
	//
	//   - arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClass
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClass
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClass
	//
	//   - arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClass
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClass
	//
	//   - arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClass
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClass
	//
	// Multi-label text classification - Uses a variant of the Expectation
	// Maximization approach to estimate the true classes of text based on annotations
	// from individual workers.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:ACS-TextMultiClassMultiLabel
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:ACS-TextMultiClassMultiLabel
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:ACS-TextMultiClassMultiLabel
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:ACS-TextMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-TextMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-TextMultiClassMultiLabel
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:ACS-TextMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:ACS-TextMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-TextMultiClassMultiLabel
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:ACS-TextMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-TextMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:ACS-TextMultiClassMultiLabel
	//
	// Named entity recognition - Groups similar selections and calculates aggregate
	// boundaries, resolving to most-assigned label.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:ACS-NamedEntityRecognition
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:ACS-NamedEntityRecognition
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:ACS-NamedEntityRecognition
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:ACS-NamedEntityRecognition
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-NamedEntityRecognition
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-NamedEntityRecognition
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:ACS-NamedEntityRecognition
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:ACS-NamedEntityRecognition
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-NamedEntityRecognition
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:ACS-NamedEntityRecognition
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-NamedEntityRecognition
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:ACS-NamedEntityRecognition
	//
	// Video Classification - Use this task type when you need workers to classify
	// videos using predefined labels that you specify. Workers are shown videos and
	// are asked to choose one label for each video.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoMultiClass
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoMultiClass
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoMultiClass
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoMultiClass
	//
	//   - arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoMultiClass
	//
	//   - arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoMultiClass
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoMultiClass
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoMultiClass
	//
	//   - arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoMultiClass
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoMultiClass
	//
	//   - arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoMultiClass
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoMultiClass
	//
	// Video Frame Object Detection - Use this task type to have workers identify and
	// locate objects in a sequence of video frames (images extracted from a video)
	// using bounding boxes. For example, you can use this task to ask workers to
	// identify and localize various objects in a series of video frames, such as cars,
	// bikes, and pedestrians.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectDetection
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectDetection
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectDetection
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectDetection
	//
	//   - arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectDetection
	//
	//   - arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectDetection
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectDetection
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectDetection
	//
	//   - arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectDetection
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectDetection
	//
	//   - arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectDetection
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectDetection
	//
	// Video Frame Object Tracking - Use this task type to have workers track the
	// movement of objects in a sequence of video frames (images extracted from a
	// video) using bounding boxes. For example, you can use this task to ask workers
	// to track the movement of objects, such as cars, bikes, and pedestrians.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:ACS-VideoObjectTracking
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:ACS-VideoObjectTracking
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:ACS-VideoObjectTracking
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:ACS-VideoObjectTracking
	//
	//   - arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VideoObjectTracking
	//
	//   - arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VideoObjectTracking
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:ACS-VideoObjectTracking
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:ACS-VideoObjectTracking
	//
	//   - arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VideoObjectTracking
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:ACS-VideoObjectTracking
	//
	//   - arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VideoObjectTracking
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:ACS-VideoObjectTracking
	//
	// 3D Point Cloud Object Detection - Use this task type when you want workers to
	// classify objects in a 3D point cloud by drawing 3D cuboids around objects. For
	// example, you can use this task type to ask workers to identify different types
	// of objects in a point cloud, such as cars, bikes, and pedestrians.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectDetection
	//
	// 3D Point Cloud Object Tracking - Use this task type when you want workers to
	// draw 3D cuboids around objects that appear in a sequence of 3D point cloud
	// frames. For example, you can use this task type to ask workers to track the
	// movement of vehicles across multiple point cloud frames.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudObjectTracking
	//
	// 3D Point Cloud Semantic Segmentation - Use this task type when you want workers
	// to create a point-level semantic segmentation masks by painting objects in a 3D
	// point cloud using different colors where each color is assigned to one of the
	// classes you specify.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:ACS-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:ACS-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:ACS-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:ACS-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:ACS-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:ACS-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:ACS-3DPointCloudSemanticSegmentation
	//
	// Use the following ARNs for Label Verification and Adjustment Jobs
	//
	// Use label verification and adjustment jobs to review and adjust labels. To
	// learn more, see [Verify and Adjust Labels].
	//
	// Semantic Segmentation Adjustment - Treats each pixel in an image as a
	// multi-class classification and treats pixel adjusted annotations from workers as
	// "votes" for the correct label.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentSemanticSegmentation
	//
	// Semantic Segmentation Verification - Uses a variant of the Expectation
	// Maximization approach to estimate the true class of verification judgment for
	// semantic segmentation labels based on annotations from individual workers.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationSemanticSegmentation
	//
	// Bounding Box Adjustment - Finds the most similar boxes from different workers
	// based on the Jaccard index of the adjusted annotations.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentBoundingBox
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentBoundingBox
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentBoundingBox
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentBoundingBox
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentBoundingBox
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentBoundingBox
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentBoundingBox
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentBoundingBox
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentBoundingBox
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentBoundingBox
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentBoundingBox
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentBoundingBox
	//
	// Bounding Box Verification - Uses a variant of the Expectation Maximization
	// approach to estimate the true class of verification judgement for bounding box
	// labels based on annotations from individual workers.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:ACS-VerificationBoundingBox
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:ACS-VerificationBoundingBox
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:ACS-VerificationBoundingBox
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:ACS-VerificationBoundingBox
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-VerificationBoundingBox
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-VerificationBoundingBox
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:ACS-VerificationBoundingBox
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:ACS-VerificationBoundingBox
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-VerificationBoundingBox
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:ACS-VerificationBoundingBox
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-VerificationBoundingBox
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:ACS-VerificationBoundingBox
	//
	// Video Frame Object Detection Adjustment - Use this task type when you want
	// workers to adjust bounding boxes that workers have added to video frames to
	// classify and localize objects in a sequence of video frames.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectDetection
	//
	// Video Frame Object Tracking Adjustment - Use this task type when you want
	// workers to adjust bounding boxes that workers have added to video frames to
	// track object movement across a sequence of video frames.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:ACS-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:ACS-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:ACS-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:ACS-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:ACS-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:ACS-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:ACS-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:ACS-AdjustmentVideoObjectTracking
	//
	// 3D Point Cloud Object Detection Adjustment - Use this task type when you want
	// workers to adjust 3D cuboids around objects in a 3D point cloud.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectDetection
	//
	// 3D Point Cloud Object Tracking Adjustment - Use this task type when you want
	// workers to adjust 3D cuboids around objects that appear in a sequence of 3D
	// point cloud frames.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudObjectTracking
	//
	// 3D Point Cloud Semantic Segmentation Adjustment - Use this task type when you
	// want workers to adjust a point-level semantic segmentation masks using a paint
	// tool.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:ACS-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:ACS-Adjustment3DPointCloudSemanticSegmentation
	//
	// [built-in task types]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html
	// [annotation consolidation]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html
	// [Post-annotation Lambda]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-postlambda
	// [Verify and Adjust Labels]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html
	//
	// This member is required.
	AnnotationConsolidationLambdaArn *string

	noSmithyDocumentSerde
}

// Details about an Amazon SageMaker app.
type AppDetails struct {

	// The name of the app.
	AppName *string

	// The type of app.
	AppType AppType

	// The creation time.
	CreationTime *time.Time

	// The domain ID.
	DomainId *string

	// Specifies the ARN's of a SageMaker image and SageMaker image version, and the
	// instance type that the version runs on.
	ResourceSpec *ResourceSpec

	// The name of the space.
	SpaceName *string

	// The status.
	Status AppStatus

	// The user profile name.
	UserProfileName *string

	noSmithyDocumentSerde
}

// The configuration for running a SageMaker image as a KernelGateway app.
type AppImageConfigDetails struct {

	// The ARN of the AppImageConfig.
	AppImageConfigArn *string

	// The name of the AppImageConfig. Must be unique to your account.
	AppImageConfigName *string

	// The configuration for the file system and the runtime, such as the environment
	// variables and entry point.
	CodeEditorAppImageConfig *CodeEditorAppImageConfig

	// When the AppImageConfig was created.
	CreationTime *time.Time

	// The configuration for the file system and the runtime, such as the environment
	// variables and entry point.
	JupyterLabAppImageConfig *JupyterLabAppImageConfig

	// The configuration for the file system and kernels in the SageMaker image.
	KernelGatewayImageConfig *KernelGatewayImageConfig

	// When the AppImageConfig was last modified.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Configuration to run a processing job in a specified container image.
type AppSpecification struct {

	// The container image to be run by the processing job.
	//
	// This member is required.
	ImageUri *string

	// The arguments for a container used to run a processing job.
	ContainerArguments []string

	// The entrypoint for a container used to run a processing job.
	ContainerEntrypoint []string

	noSmithyDocumentSerde
}

// A structure describing the source of an artifact.
type ArtifactSource struct {

	// The URI of the source.
	//
	// This member is required.
	SourceUri *string

	// A list of source types.
	SourceTypes []ArtifactSourceType

	noSmithyDocumentSerde
}

// The ID and ID type of an artifact source.
type ArtifactSourceType struct {

	// The type of ID.
	//
	// This member is required.
	SourceIdType ArtifactSourceIdType

	// The ID.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Lists a summary of the properties of an artifact. An artifact represents a URI
// addressable object or data. Some examples are a dataset and a model.
type ArtifactSummary struct {

	// The Amazon Resource Name (ARN) of the artifact.
	ArtifactArn *string

	// The name of the artifact.
	ArtifactName *string

	// The type of the artifact.
	ArtifactType *string

	// When the artifact was created.
	CreationTime *time.Time

	// When the artifact was last modified.
	LastModifiedTime *time.Time

	// The source of the artifact.
	Source *ArtifactSource

	noSmithyDocumentSerde
}

// Lists a summary of the properties of an association. An association is an
// entity that links other lineage or experiment entities. An example would be an
// association between a training job and a model.
type AssociationSummary struct {

	// The type of the association.
	AssociationType AssociationEdgeType

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	CreatedBy *UserContext

	// When the association was created.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the destination.
	DestinationArn *string

	// The name of the destination.
	DestinationName *string

	// The destination type.
	DestinationType *string

	// The ARN of the source.
	SourceArn *string

	// The name of the source.
	SourceName *string

	// The source type.
	SourceType *string

	noSmithyDocumentSerde
}

// Configures the behavior of the client used by SageMaker to interact with the
// model container during asynchronous inference.
type AsyncInferenceClientConfig struct {

	// The maximum number of concurrent requests sent by the SageMaker client to the
	// model container. If no value is provided, SageMaker chooses an optimal value.
	MaxConcurrentInvocationsPerInstance *int32

	noSmithyDocumentSerde
}

// Specifies configuration for how an endpoint performs asynchronous inference.
type AsyncInferenceConfig struct {

	// Specifies the configuration for asynchronous inference invocation outputs.
	//
	// This member is required.
	OutputConfig *AsyncInferenceOutputConfig

	// Configures the behavior of the client used by SageMaker to interact with the
	// model container during asynchronous inference.
	ClientConfig *AsyncInferenceClientConfig

	noSmithyDocumentSerde
}

// Specifies the configuration for notifications of inference results for
// asynchronous inference.
type AsyncInferenceNotificationConfig struct {

	// Amazon SNS topic to post a notification to when inference fails. If no topic is
	// provided, no notification is sent on failure.
	ErrorTopic *string

	// The Amazon SNS topics where you want the inference response to be included.
	//
	// The inference response is included only if the response size is less than or
	// equal to 128 KB.
	IncludeInferenceResponseIn []AsyncNotificationTopicTypes

	// Amazon SNS topic to post a notification to when inference completes
	// successfully. If no topic is provided, no notification is sent on success.
	SuccessTopic *string

	noSmithyDocumentSerde
}

// Specifies the configuration for asynchronous inference invocation outputs.
type AsyncInferenceOutputConfig struct {

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that SageMaker uses to encrypt the asynchronous inference output in Amazon S3.
	KmsKeyId *string

	// Specifies the configuration for notifications of inference results for
	// asynchronous inference.
	NotificationConfig *AsyncInferenceNotificationConfig

	// The Amazon S3 location to upload failure inference responses to.
	S3FailurePath *string

	// The Amazon S3 location to upload inference responses to.
	S3OutputPath *string

	noSmithyDocumentSerde
}

// Configuration for Athena Dataset Definition input.
type AthenaDatasetDefinition struct {

	// The name of the data catalog used in Athena query execution.
	//
	// This member is required.
	Catalog *string

	// The name of the database used in the Athena query execution.
	//
	// This member is required.
	Database *string

	// The data storage format for Athena query results.
	//
	// This member is required.
	OutputFormat AthenaResultFormat

	// The location in Amazon S3 where Athena query results are stored.
	//
	// This member is required.
	OutputS3Uri *string

	// The SQL query statements, to be executed.
	//
	// This member is required.
	QueryString *string

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt data generated from an Athena query
	// execution.
	KmsKeyId *string

	// The compression used for Athena query results.
	OutputCompression AthenaResultCompressionType

	// The name of the workgroup in which the Athena query is being started.
	WorkGroup *string

	noSmithyDocumentSerde
}

// The collection of algorithms run on a dataset for training the model candidates
// of an Autopilot job.
type AutoMLAlgorithmConfig struct {

	// The selection of algorithms run on a dataset to train the model candidates of
	// an Autopilot job.
	//
	// Selected algorithms must belong to the list corresponding to the training mode
	// set in [AutoMLJobConfig.Mode]( ENSEMBLING or HYPERPARAMETER_TUNING ). Choose a minimum of 1 algorithm.
	//
	//   - In ENSEMBLING mode:
	//
	//   - "catboost"
	//
	//   - "extra-trees"
	//
	//   - "fastai"
	//
	//   - "lightgbm"
	//
	//   - "linear-learner"
	//
	//   - "nn-torch"
	//
	//   - "randomforest"
	//
	//   - "xgboost"
	//
	//   - In HYPERPARAMETER_TUNING mode:
	//
	//   - "linear-learner"
	//
	//   - "mlp"
	//
	//   - "xgboost"
	//
	// [AutoMLJobConfig.Mode]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html#sagemaker-Type-AutoMLJobConfig-Mode
	//
	// This member is required.
	AutoMLAlgorithms []AutoMLAlgorithm

	noSmithyDocumentSerde
}

// Information about a candidate produced by an AutoML training job, including its
// status, steps, and other properties.
type AutoMLCandidate struct {

	// The name of the candidate.
	//
	// This member is required.
	CandidateName *string

	// The candidate's status.
	//
	// This member is required.
	CandidateStatus CandidateStatus

	// Information about the candidate's steps.
	//
	// This member is required.
	CandidateSteps []AutoMLCandidateStep

	// The creation time.
	//
	// This member is required.
	CreationTime *time.Time

	// The last modified time.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The objective's status.
	//
	// This member is required.
	ObjectiveStatus ObjectiveStatus

	// The properties of an AutoML candidate job.
	CandidateProperties *CandidateProperties

	// The end time.
	EndTime *time.Time

	// The failure reason.
	FailureReason *string

	// The best candidate result from an AutoML training job.
	FinalAutoMLJobObjectiveMetric *FinalAutoMLJobObjectiveMetric

	// The mapping of all supported processing unit (CPU, GPU, etc...) to inference
	// container definitions for the candidate. This field is populated for the AutoML
	// jobs V2 (for example, for jobs created by calling CreateAutoMLJobV2 ) related to
	// image or text classification problem types only.
	InferenceContainerDefinitions map[string][]AutoMLContainerDefinition

	// Information about the recommended inference container definitions.
	InferenceContainers []AutoMLContainerDefinition

	noSmithyDocumentSerde
}

// Stores the configuration information for how a candidate is generated
// (optional).
type AutoMLCandidateGenerationConfig struct {

	// Stores the configuration information for the selection of algorithms used to
	// train the model candidates.
	//
	// The list of available algorithms to choose from depends on the training mode
	// set in [AutoMLJobConfig.Mode]AutoMLJobConfig.Mode .
	//
	//   - AlgorithmsConfig should not be set in AUTO training mode.
	//
	//   - When AlgorithmsConfig is provided, one AutoMLAlgorithms attribute must be
	//   set and one only.
	//
	// If the list of algorithms provided as values for AutoMLAlgorithms is empty,
	//   AutoMLCandidateGenerationConfig uses the full set of algorithms for the given
	//   training mode.
	//
	//   - When AlgorithmsConfig is not provided, AutoMLCandidateGenerationConfig uses
	//   the full set of algorithms for the given training mode.
	//
	// For the list of all algorithms per training mode, see [AutoMLAlgorithmConfig].
	//
	// For more information on each algorithm, see the [Algorithm support] section in Autopilot developer
	// guide.
	//
	// [AutoMLJobConfig.Mode]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobConfig.html
	// [Algorithm support]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support
	// [AutoMLAlgorithmConfig]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html
	AlgorithmsConfig []AutoMLAlgorithmConfig

	// A URL to the Amazon S3 data source containing selected features from the input
	// data source to run an Autopilot job. You can input FeatureAttributeNames
	// (optional) in JSON format as shown below:
	//
	// { "FeatureAttributeNames":["col1", "col2", ...] } .
	//
	// You can also specify the data type of the feature (optional) in the format
	// shown below:
	//
	//     { "FeatureDataTypes":{"col1":"numeric", "col2":"categorical" ... } }
	//
	// These column keys may not include the target column.
	//
	// In ensembling mode, Autopilot only supports the following data types: numeric ,
	// categorical , text , and datetime . In HPO mode, Autopilot can support numeric ,
	// categorical , text , datetime , and sequence .
	//
	// If only FeatureDataTypes is provided, the column keys ( col1 , col2 ,..) should
	// be a subset of the column names in the input data.
	//
	// If both FeatureDataTypes and FeatureAttributeNames are provided, then the
	// column keys should be a subset of the column names provided in
	// FeatureAttributeNames .
	//
	// The key name FeatureAttributeNames is fixed. The values listed in ["col1",
	// "col2", ...] are case sensitive and should be a list of strings containing
	// unique values that are a subset of the column names in the input data. The list
	// of columns provided must not include the target column.
	FeatureSpecificationS3Uri *string

	noSmithyDocumentSerde
}

// Information about the steps for a candidate and what step it is working on.
type AutoMLCandidateStep struct {

	// The ARN for the candidate's step.
	//
	// This member is required.
	CandidateStepArn *string

	// The name for the candidate's step.
	//
	// This member is required.
	CandidateStepName *string

	// Whether the candidate is at the transform, training, or processing step.
	//
	// This member is required.
	CandidateStepType CandidateStepType

	noSmithyDocumentSerde
}

// A channel is a named input source that training algorithms can consume. The
// validation dataset size is limited to less than 2 GB. The training dataset size
// must be less than 100 GB. For more information, see [Channel].
//
// A validation dataset must contain the same headers as the training dataset.
//
// [Channel]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Channel.html
type AutoMLChannel struct {

	// The name of the target variable in supervised learning, usually represented by
	// 'y'.
	//
	// This member is required.
	TargetAttributeName *string

	// The channel type (optional) is an enum string. The default value is training .
	// Channels for training and validation must share the same ContentType and
	// TargetAttributeName . For information on specifying training and validation
	// channel types, see [How to specify training and validation datasets].
	//
	// [How to specify training and validation datasets]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-data-sources-training-or-validation
	ChannelType AutoMLChannelType

	// You can use Gzip or None . The default value is None .
	CompressionType CompressionType

	// The content type of the data from the input source. You can use
	// text/csv;header=present or x-application/vnd.amazon+parquet . The default value
	// is text/csv;header=present .
	ContentType *string

	// The data source for an AutoML channel.
	DataSource *AutoMLDataSource

	// If specified, this column name indicates which column of the dataset should be
	// treated as sample weights for use by the objective metric during the training,
	// evaluation, and the selection of the best model. This column is not considered
	// as a predictive feature. For more information on Autopilot metrics, see [Metrics and validation].
	//
	// Sample weights should be numeric, non-negative, with larger values indicating
	// which rows are more important than others. Data points that have invalid or no
	// weight value are excluded.
	//
	// Support for sample weights is available in [Ensembling] mode only.
	//
	// [Ensembling]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html
	// [Metrics and validation]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-metrics-validation.html
	SampleWeightAttributeName *string

	noSmithyDocumentSerde
}

// A list of container definitions that describe the different containers that
// make up an AutoML candidate. For more information, see [ContainerDefinition].
//
// [ContainerDefinition]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html
type AutoMLContainerDefinition struct {

	// The Amazon Elastic Container Registry (Amazon ECR) path of the container. For
	// more information, see [ContainerDefinition].
	//
	// [ContainerDefinition]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html
	//
	// This member is required.
	Image *string

	// The location of the model artifacts. For more information, see [ContainerDefinition].
	//
	// [ContainerDefinition]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html
	//
	// This member is required.
	ModelDataUrl *string

	// The environment variables to set in the container. For more information, see [ContainerDefinition].
	//
	// [ContainerDefinition]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html
	Environment map[string]string

	noSmithyDocumentSerde
}

// The data source for the Autopilot job.
type AutoMLDataSource struct {

	// The Amazon S3 location of the input data.
	//
	// This member is required.
	S3DataSource *AutoMLS3DataSource

	noSmithyDocumentSerde
}

// This structure specifies how to split the data into train and validation
// datasets.
//
// The validation and training datasets must contain the same headers. For jobs
// created by calling CreateAutoMLJob , the validation dataset must be less than 2
// GB in size.
type AutoMLDataSplitConfig struct {

	// The validation fraction (optional) is a float that specifies the portion of the
	// training dataset to be used for validation. The default value is 0.2, and values
	// must be greater than 0 and less than 1. We recommend setting this value to be
	// less than 0.5.
	ValidationFraction *float32

	noSmithyDocumentSerde
}

// The artifacts that are generated during an AutoML job.
type AutoMLJobArtifacts struct {

	// The URL of the notebook location.
	CandidateDefinitionNotebookLocation *string

	// The URL of the notebook location.
	DataExplorationNotebookLocation *string

	noSmithyDocumentSerde
}

// A channel is a named input source that training algorithms can consume. This
// channel is used for AutoML jobs V2 (jobs created by calling [CreateAutoMLJobV2]).
//
// [CreateAutoMLJobV2]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html
type AutoMLJobChannel struct {

	// The type of channel. Defines whether the data are used for training or
	// validation. The default value is training . Channels for training and validation
	// must share the same ContentType
	//
	// The type of channel defaults to training for the time-series forecasting
	// problem type.
	ChannelType AutoMLChannelType

	// The allowed compression types depend on the input format and problem type. We
	// allow the compression type Gzip for S3Prefix inputs on tabular data only. For
	// all other inputs, the compression type should be None . If no compression type
	// is provided, we default to None .
	CompressionType CompressionType

	// The content type of the data from the input source. The following are the
	// allowed content types for different problems:
	//
	//   - For tabular problem types: text/csv;header=present or
	//   x-application/vnd.amazon+parquet . The default value is
	//   text/csv;header=present .
	//
	//   - For image classification: image/png , image/jpeg , or image/* . The default
	//   value is image/* .
	//
	//   - For text classification: text/csv;header=present or
	//   x-application/vnd.amazon+parquet . The default value is
	//   text/csv;header=present .
	//
	//   - For time-series forecasting: text/csv;header=present or
	//   x-application/vnd.amazon+parquet . The default value is
	//   text/csv;header=present .
	//
	//   - For text generation (LLMs fine-tuning): text/csv;header=present or
	//   x-application/vnd.amazon+parquet . The default value is
	//   text/csv;header=present .
	ContentType *string

	// The data source for an AutoML channel (Required).
	DataSource *AutoMLDataSource

	noSmithyDocumentSerde
}

// How long a job is allowed to run, or how many candidates a job is allowed to
// generate.
type AutoMLJobCompletionCriteria struct {

	// The maximum runtime, in seconds, an AutoML job has to complete.
	//
	// If an AutoML job exceeds the maximum runtime, the job is stopped automatically
	// and its processing is ended gracefully. The AutoML job identifies the best model
	// whose training was completed and marks it as the best-performing model. Any
	// unfinished steps of the job, such as automatic one-click Autopilot model
	// deployment, are not completed.
	MaxAutoMLJobRuntimeInSeconds *int32

	// The maximum number of times a training job is allowed to run.
	//
	// For text and image classification, time-series forecasting, as well as text
	// generation (LLMs fine-tuning) problem types, the supported value is 1. For
	// tabular problem types, the maximum value is 750.
	MaxCandidates *int32

	// The maximum time, in seconds, that each training job executed inside
	// hyperparameter tuning is allowed to run as part of a hyperparameter tuning job.
	// For more information, see the [StoppingCondition]used by the [CreateHyperParameterTuningJob] action.
	//
	// For job V2s (jobs created by calling CreateAutoMLJobV2 ), this field controls
	// the runtime of the job candidate.
	//
	// For [TextGenerationJobConfig] problem types, the maximum time defaults to 72 hours (259200 seconds).
	//
	// [CreateHyperParameterTuningJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHyperParameterTuningJob.html
	// [StoppingCondition]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StoppingCondition.html
	// [TextGenerationJobConfig]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TextClassificationJobConfig.html
	MaxRuntimePerTrainingJobInSeconds *int32

	noSmithyDocumentSerde
}

// A collection of settings used for an AutoML job.
type AutoMLJobConfig struct {

	// The configuration for generating a candidate for an AutoML job (optional).
	CandidateGenerationConfig *AutoMLCandidateGenerationConfig

	// How long an AutoML job is allowed to run, or how many candidates a job is
	// allowed to generate.
	CompletionCriteria *AutoMLJobCompletionCriteria

	// The configuration for splitting the input training dataset.
	//
	// Type: AutoMLDataSplitConfig
	DataSplitConfig *AutoMLDataSplitConfig

	// The method that Autopilot uses to train the data. You can either specify the
	// mode manually or let Autopilot choose for you based on the dataset size by
	// selecting AUTO . In AUTO mode, Autopilot chooses ENSEMBLING for datasets
	// smaller than 100 MB, and HYPERPARAMETER_TUNING for larger ones.
	//
	// The ENSEMBLING mode uses a multi-stack ensemble model to predict classification
	// and regression tasks directly from your dataset. This machine learning mode
	// combines several base models to produce an optimal predictive model. It then
	// uses a stacking ensemble method to combine predictions from contributing
	// members. A multi-stack ensemble model can provide better performance over a
	// single model by combining the predictive capabilities of multiple models. See [Autopilot algorithm support]
	// for a list of algorithms supported by ENSEMBLING mode.
	//
	// The HYPERPARAMETER_TUNING (HPO) mode uses the best hyperparameters to train the
	// best version of a model. HPO automatically selects an algorithm for the type of
	// problem you want to solve. Then HPO finds the best hyperparameters according to
	// your objective metric. See [Autopilot algorithm support]for a list of algorithms supported by
	// HYPERPARAMETER_TUNING mode.
	//
	// [Autopilot algorithm support]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support
	Mode AutoMLMode

	// The security configuration for traffic encryption or Amazon VPC settings.
	SecurityConfig *AutoMLSecurityConfig

	noSmithyDocumentSerde
}

// Specifies a metric to minimize or maximize as the objective of an AutoML job.
type AutoMLJobObjective struct {

	// The name of the objective metric used to measure the predictive quality of a
	// machine learning system. During training, the model's parameters are updated
	// iteratively to optimize its performance based on the feedback provided by the
	// objective metric when evaluating the model on the validation dataset.
	//
	// The list of available metrics supported by Autopilot and the default metric
	// applied when you do not specify a metric name explicitly depend on the problem
	// type.
	//
	//   - For tabular problem types:
	//
	//   - List of available metrics:
	//
	//   - Regression: MAE , MSE , R2 , RMSE
	//
	//   - Binary classification: Accuracy , AUC , BalancedAccuracy , F1 , Precision ,
	//   Recall
	//
	//   - Multiclass classification: Accuracy , BalancedAccuracy , F1macro ,
	//   PrecisionMacro , RecallMacro
	//
	// For a description of each metric, see [Autopilot metrics for classification and regression].
	//
	//   - Default objective metrics:
	//
	//   - Regression: MSE .
	//
	//   - Binary classification: F1 .
	//
	//   - Multiclass classification: Accuracy .
	//
	//   - For image or text classification problem types:
	//
	//   - List of available metrics: Accuracy
	//
	// For a description of each metric, see [Autopilot metrics for text and image classification].
	//
	//   - Default objective metrics: Accuracy
	//
	//   - For time-series forecasting problem types:
	//
	//   - List of available metrics: RMSE , wQL , Average wQL , MASE , MAPE , WAPE
	//
	// For a description of each metric, see [Autopilot metrics for time-series forecasting].
	//
	//   - Default objective metrics: AverageWeightedQuantileLoss
	//
	//   - For text generation problem types (LLMs fine-tuning): Fine-tuning language
	//   models in Autopilot does not require setting the AutoMLJobObjective field.
	//   Autopilot fine-tunes LLMs without requiring multiple candidates to be trained
	//   and evaluated. Instead, using your dataset, Autopilot directly fine-tunes your
	//   target model to enhance a default objective metric, the cross-entropy loss.
	//   After fine-tuning a language model, you can evaluate the quality of its
	//   generated text using different metrics. For a list of the available metrics, see
	//   [Metrics for fine-tuning LLMs in Autopilot].
	//
	// [Metrics for fine-tuning LLMs in Autopilot]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-llms-finetuning-metrics.html
	// [Autopilot metrics for time-series forecasting]: https://docs.aws.amazon.com/sagemaker/latest/dg/timeseries-objective-metric.html
	// [Autopilot metrics for classification and regression]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-metrics-validation.html#autopilot-metrics
	// [Autopilot metrics for text and image classification]: https://docs.aws.amazon.com/sagemaker/latest/dg/text-classification-data-format-and-metric.html
	//
	// This member is required.
	MetricName AutoMLMetricEnum

	noSmithyDocumentSerde
}

// Metadata for an AutoML job step.
type AutoMLJobStepMetadata struct {

	// The Amazon Resource Name (ARN) of the AutoML job.
	Arn *string

	noSmithyDocumentSerde
}

// Provides a summary about an AutoML job.
type AutoMLJobSummary struct {

	// The ARN of the AutoML job.
	//
	// This member is required.
	AutoMLJobArn *string

	// The name of the AutoML job you are requesting.
	//
	// This member is required.
	AutoMLJobName *string

	// The secondary status of the AutoML job.
	//
	// This member is required.
	AutoMLJobSecondaryStatus AutoMLJobSecondaryStatus

	// The status of the AutoML job.
	//
	// This member is required.
	AutoMLJobStatus AutoMLJobStatus

	// When the AutoML job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// When the AutoML job was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The end time of an AutoML job.
	EndTime *time.Time

	// The failure reason of an AutoML job.
	FailureReason *string

	// The list of reasons for partial failures within an AutoML job.
	PartialFailureReasons []AutoMLPartialFailureReason

	noSmithyDocumentSerde
}

// The output data configuration.
type AutoMLOutputDataConfig struct {

	// The Amazon S3 output path. Must be 128 characters or less.
	//
	// This member is required.
	S3OutputPath *string

	// The Key Management Service encryption key ID.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// The reason for a partial failure of an AutoML job.
type AutoMLPartialFailureReason struct {

	// The message containing the reason for a partial failure of an AutoML job.
	PartialFailureMessage *string

	noSmithyDocumentSerde
}

// A collection of settings specific to the problem type used to configure an
// AutoML job V2. There must be one and only one config of the following type.
//
// The following types satisfy this interface:
//
//	AutoMLProblemTypeConfigMemberImageClassificationJobConfig
//	AutoMLProblemTypeConfigMemberTabularJobConfig
//	AutoMLProblemTypeConfigMemberTextClassificationJobConfig
//	AutoMLProblemTypeConfigMemberTextGenerationJobConfig
//	AutoMLProblemTypeConfigMemberTimeSeriesForecastingJobConfig
type AutoMLProblemTypeConfig interface {
	isAutoMLProblemTypeConfig()
}

// Settings used to configure an AutoML job V2 for the image classification
// problem type.
type AutoMLProblemTypeConfigMemberImageClassificationJobConfig struct {
	Value ImageClassificationJobConfig

	noSmithyDocumentSerde
}

func (*AutoMLProblemTypeConfigMemberImageClassificationJobConfig) isAutoMLProblemTypeConfig() {}

// Settings used to configure an AutoML job V2 for the tabular problem type
// (regression, classification).
type AutoMLProblemTypeConfigMemberTabularJobConfig struct {
	Value TabularJobConfig

	noSmithyDocumentSerde
}

func (*AutoMLProblemTypeConfigMemberTabularJobConfig) isAutoMLProblemTypeConfig() {}

// Settings used to configure an AutoML job V2 for the text classification problem
// type.
type AutoMLProblemTypeConfigMemberTextClassificationJobConfig struct {
	Value TextClassificationJobConfig

	noSmithyDocumentSerde
}

func (*AutoMLProblemTypeConfigMemberTextClassificationJobConfig) isAutoMLProblemTypeConfig() {}

// Settings used to configure an AutoML job V2 for the text generation (LLMs
// fine-tuning) problem type.
//
// The text generation models that support fine-tuning in Autopilot are currently
// accessible exclusively in regions supported by Canvas. Refer to the
// documentation of Canvas for the [full list of its supported Regions].
//
// [full list of its supported Regions]: https://docs.aws.amazon.com/sagemaker/latest/dg/canvas.html
type AutoMLProblemTypeConfigMemberTextGenerationJobConfig struct {
	Value TextGenerationJobConfig

	noSmithyDocumentSerde
}

func (*AutoMLProblemTypeConfigMemberTextGenerationJobConfig) isAutoMLProblemTypeConfig() {}

// Settings used to configure an AutoML job V2 for the time-series forecasting
// problem type.
type AutoMLProblemTypeConfigMemberTimeSeriesForecastingJobConfig struct {
	Value TimeSeriesForecastingJobConfig

	noSmithyDocumentSerde
}

func (*AutoMLProblemTypeConfigMemberTimeSeriesForecastingJobConfig) isAutoMLProblemTypeConfig() {}

// Stores resolved attributes specific to the problem type of an AutoML job V2.
//
// The following types satisfy this interface:
//
//	AutoMLProblemTypeResolvedAttributesMemberTabularResolvedAttributes
//	AutoMLProblemTypeResolvedAttributesMemberTextGenerationResolvedAttributes
type AutoMLProblemTypeResolvedAttributes interface {
	isAutoMLProblemTypeResolvedAttributes()
}

// The resolved attributes for the tabular problem type.
type AutoMLProblemTypeResolvedAttributesMemberTabularResolvedAttributes struct {
	Value TabularResolvedAttributes

	noSmithyDocumentSerde
}

func (*AutoMLProblemTypeResolvedAttributesMemberTabularResolvedAttributes) isAutoMLProblemTypeResolvedAttributes() {
}

// The resolved attributes for the text generation problem type.
type AutoMLProblemTypeResolvedAttributesMemberTextGenerationResolvedAttributes struct {
	Value TextGenerationResolvedAttributes

	noSmithyDocumentSerde
}

func (*AutoMLProblemTypeResolvedAttributesMemberTextGenerationResolvedAttributes) isAutoMLProblemTypeResolvedAttributes() {
}

// The resolved attributes used to configure an AutoML job V2.
type AutoMLResolvedAttributes struct {

	// Specifies a metric to minimize or maximize as the objective of an AutoML job.
	AutoMLJobObjective *AutoMLJobObjective

	// Defines the resolved attributes specific to a problem type.
	AutoMLProblemTypeResolvedAttributes AutoMLProblemTypeResolvedAttributes

	// How long a job is allowed to run, or how many candidates a job is allowed to
	// generate.
	CompletionCriteria *AutoMLJobCompletionCriteria

	noSmithyDocumentSerde
}

// Describes the Amazon S3 data source.
type AutoMLS3DataSource struct {

	// The data type.
	//
	//   - If you choose S3Prefix , S3Uri identifies a key name prefix. SageMaker uses
	//   all objects that match the specified key name prefix for model training.
	//
	// The S3Prefix should have the following format:
	//
	// s3://DOC-EXAMPLE-BUCKET/DOC-EXAMPLE-FOLDER-OR-FILE
	//
	//   - If you choose ManifestFile , S3Uri identifies an object that is a manifest
	//   file containing a list of object keys that you want SageMaker to use for model
	//   training.
	//
	// A ManifestFile should have the format shown below:
	//
	// [ {"prefix": "s3://DOC-EXAMPLE-BUCKET/DOC-EXAMPLE-FOLDER/DOC-EXAMPLE-PREFIX/"},
	//
	// "DOC-EXAMPLE-RELATIVE-PATH/DOC-EXAMPLE-FOLDER/DATA-1",
	//
	// "DOC-EXAMPLE-RELATIVE-PATH/DOC-EXAMPLE-FOLDER/DATA-2",
	//
	// ... "DOC-EXAMPLE-RELATIVE-PATH/DOC-EXAMPLE-FOLDER/DATA-N" ]
	//
	//   - If you choose AugmentedManifestFile , S3Uri identifies an object that is an
	//   augmented manifest file in JSON lines format. This file contains the data you
	//   want to use for model training. AugmentedManifestFile is available for V2 API
	//   jobs only (for example, for jobs created by calling CreateAutoMLJobV2 ).
	//
	// Here is a minimal, single-record example of an AugmentedManifestFile :
	//
	// {"source-ref": "s3://DOC-EXAMPLE-BUCKET/DOC-EXAMPLE-FOLDER/cats/cat.jpg",
	//
	// "label-metadata": {"class-name": "cat" }
	//
	// For more information on AugmentedManifestFile , see [Provide Dataset Metadata to Training Jobs with an Augmented Manifest File].
	//
	// [Provide Dataset Metadata to Training Jobs with an Augmented Manifest File]: https://docs.aws.amazon.com/sagemaker/latest/dg/augmented-manifest.html
	//
	// This member is required.
	S3DataType AutoMLS3DataType

	// The URL to the Amazon S3 data source. The Uri refers to the Amazon S3 prefix or
	// ManifestFile depending on the data type.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// Security options.
type AutoMLSecurityConfig struct {

	// Whether to use traffic encryption between the container layers.
	EnableInterContainerTrafficEncryption *bool

	// The key used to encrypt stored data.
	VolumeKmsKeyId *string

	// The VPC configuration.
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// The name and an example value of the hyperparameter that you want to use in
// Autotune. If Automatic model tuning (AMT) determines that your hyperparameter is
// eligible for Autotune, an optimal hyperparameter range is selected for you.
type AutoParameter struct {

	// The name of the hyperparameter to optimize using Autotune.
	//
	// This member is required.
	Name *string

	// An example value of the hyperparameter to optimize using Autotune.
	//
	// This member is required.
	ValueHint *string

	noSmithyDocumentSerde
}

// Automatic rollback configuration for handling endpoint deployment failures and
// recovery.
type AutoRollbackConfig struct {

	// List of CloudWatch alarms in your account that are configured to monitor
	// metrics on an endpoint. If any alarms are tripped during a deployment, SageMaker
	// rolls back the deployment.
	Alarms []Alarm

	noSmithyDocumentSerde
}

// A flag to indicate if you want to use Autotune to automatically find optimal
// values for the following fields:
//
// [ParameterRanges]
//   - : The names and ranges of parameters that a hyperparameter tuning job can
//     optimize.
//
// [ResourceLimits]
//   - : The maximum resources that can be used for a training job. These
//     resources include the maximum number of training jobs, the maximum runtime of a
//     tuning job, and the maximum number of training jobs to run at the same time.
//
// [TrainingJobEarlyStoppingType]
//   - : A flag that specifies whether or not to use early stopping for training
//     jobs launched by a hyperparameter tuning job.
//
// [RetryStrategy]
//   - : The number of times to retry a training job.
//
// [Strategy]
//   - : Specifies how hyperparameter tuning chooses the combinations of
//     hyperparameter values to use for the training jobs that it launches.
//
// [ConvergenceDetected]
//   - : A flag to indicate that Automatic model tuning (AMT) has detected model
//     convergence.
//
// [TrainingJobEarlyStoppingType]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html#sagemaker-Type-HyperParameterTuningJobConfig-TrainingJobEarlyStoppingType
// [ConvergenceDetected]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ConvergenceDetected.html
// [ResourceLimits]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html
// [Strategy]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html
// [ParameterRanges]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html#sagemaker-Type-HyperParameterTuningJobConfig-ParameterRanges
// [RetryStrategy]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html#sagemaker-Type-HyperParameterTrainingJobDefinition-RetryStrategy
type Autotune struct {

	// Set Mode to Enabled if you want to use Autotune.
	//
	// This member is required.
	Mode AutotuneMode

	noSmithyDocumentSerde
}

// Configuration to control how SageMaker captures inference data for batch
// transform jobs.
type BatchDataCaptureConfig struct {

	// The Amazon S3 location being used to capture the data.
	//
	// This member is required.
	DestinationS3Uri *string

	// Flag that indicates whether to append inference id to the output.
	GenerateInferenceId *bool

	// The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service
	// key that SageMaker uses to encrypt data on the storage volume attached to the ML
	// compute instance that hosts the batch transform job.
	//
	// The KmsKeyId can be any of the following formats:
	//
	//   - Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   - Key ARN:
	//   arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   - Alias name: alias/ExampleAlias
	//
	//   - Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias
	KmsKeyId *string

	noSmithyDocumentSerde
}

// The error code and error description associated with the resource.
type BatchDescribeModelPackageError struct {

	//
	//
	// This member is required.
	ErrorCode *string

	//
	//
	// This member is required.
	ErrorResponse *string

	noSmithyDocumentSerde
}

// Provides summary information about the model package.
type BatchDescribeModelPackageSummary struct {

	// The creation time of the mortgage package summary.
	//
	// This member is required.
	CreationTime *time.Time

	// Defines how to perform inference generation after a training job is run.
	//
	// This member is required.
	InferenceSpecification *InferenceSpecification

	// The Amazon Resource Name (ARN) of the model package.
	//
	// This member is required.
	ModelPackageArn *string

	// The group name for the model package
	//
	// This member is required.
	ModelPackageGroupName *string

	// The status of the mortgage package.
	//
	// This member is required.
	ModelPackageStatus ModelPackageStatus

	// The approval status of the model.
	ModelApprovalStatus ModelApprovalStatus

	// The description of the model package.
	ModelPackageDescription *string

	// The version number of a versioned model.
	ModelPackageVersion *int32

	noSmithyDocumentSerde
}

// Input object for the batch transform job.
type BatchTransformInput struct {

	// The Amazon S3 location being used to capture the data.
	//
	// This member is required.
	DataCapturedDestinationS3Uri *string

	// The dataset format for your batch transform job.
	//
	// This member is required.
	DatasetFormat *MonitoringDatasetFormat

	// Path to the filesystem where the batch transform data is available to the
	// container.
	//
	// This member is required.
	LocalPath *string

	// If specified, monitoring jobs subtract this time from the end time. For
	// information about using offsets for scheduling monitoring jobs, see [Schedule Model Quality Monitoring Jobs].
	//
	// [Schedule Model Quality Monitoring Jobs]: https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html
	EndTimeOffset *string

	// The attributes of the input data to exclude from the analysis.
	ExcludeFeaturesAttribute *string

	// The attributes of the input data that are the input features.
	FeaturesAttribute *string

	// The attribute of the input data that represents the ground truth label.
	InferenceAttribute *string

	// In a classification problem, the attribute that represents the class
	// probability.
	ProbabilityAttribute *string

	// The threshold for the class probability to be evaluated as a positive result.
	ProbabilityThresholdAttribute *float64

	// Whether input data distributed in Amazon S3 is fully replicated or sharded by
	// an S3 key. Defaults to FullyReplicated
	S3DataDistributionType ProcessingS3DataDistributionType

	// Whether the Pipe or File is used as the input mode for transferring data for
	// the monitoring job. Pipe mode is recommended for large datasets. File mode is
	// useful for small files that fit in memory. Defaults to File .
	S3InputMode ProcessingS3InputMode

	// If specified, monitoring jobs substract this time from the start time. For
	// information about using offsets for scheduling monitoring jobs, see [Schedule Model Quality Monitoring Jobs].
	//
	// [Schedule Model Quality Monitoring Jobs]: https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html
	StartTimeOffset *string

	noSmithyDocumentSerde
}

// A structure that keeps track of which training jobs launched by your
// hyperparameter tuning job are not improving model performance as evaluated
// against an objective function.
type BestObjectiveNotImproving struct {

	// The number of training jobs that have failed to improve model performance by 1%
	// or greater over prior training jobs as evaluated against an objective function.
	MaxNumberOfTrainingJobsNotImproving *int32

	noSmithyDocumentSerde
}

// Contains bias metrics for a model.
type Bias struct {

	// The post-training bias report for a model.
	PostTrainingReport *MetricsSource

	// The pre-training bias report for a model.
	PreTrainingReport *MetricsSource

	// The bias report for a model
	Report *MetricsSource

	noSmithyDocumentSerde
}

// Update policy for a blue/green deployment. If this update policy is specified,
// SageMaker creates a new fleet during the deployment while maintaining the old
// fleet. SageMaker flips traffic to the new fleet according to the specified
// traffic routing configuration. Only one update policy should be used in the
// deployment configuration. If no update policy is specified, SageMaker uses a
// blue/green deployment strategy with all at once traffic shifting by default.
type BlueGreenUpdatePolicy struct {

	// Defines the traffic routing strategy to shift traffic from the old fleet to the
	// new fleet during an endpoint deployment.
	//
	// This member is required.
	TrafficRoutingConfiguration *TrafficRoutingConfig

	// Maximum execution timeout for the deployment. Note that the timeout value
	// should be larger than the total waiting time specified in
	// TerminationWaitInSeconds and WaitIntervalInSeconds .
	MaximumExecutionTimeoutInSeconds *int32

	// Additional waiting time in seconds after the completion of an endpoint
	// deployment before terminating the old endpoint fleet. Default is 0.
	TerminationWaitInSeconds *int32

	noSmithyDocumentSerde
}

// Details on the cache hit of a pipeline execution step.
type CacheHitResult struct {

	// The Amazon Resource Name (ARN) of the pipeline execution.
	SourcePipelineExecutionArn *string

	noSmithyDocumentSerde
}

// Metadata about a callback step.
type CallbackStepMetadata struct {

	// The pipeline generated token from the Amazon SQS queue.
	CallbackToken *string

	// A list of the output parameters of the callback step.
	OutputParameters []OutputParameter

	// The URL of the Amazon Simple Queue Service (Amazon SQS) queue used by the
	// callback step.
	SqsQueueUrl *string

	noSmithyDocumentSerde
}

// The location of artifacts for an AutoML candidate job.
type CandidateArtifactLocations struct {

	// The Amazon S3 prefix to the explainability artifacts generated for the AutoML
	// candidate.
	//
	// This member is required.
	Explainability *string

	// The Amazon S3 prefix to the accuracy metrics and the inference results observed
	// over the testing window. Available only for the time-series forecasting problem
	// type.
	BacktestResults *string

	// The Amazon S3 prefix to the model insight artifacts generated for the AutoML
	// candidate.
	ModelInsights *string

	noSmithyDocumentSerde
}

// Stores the configuration information for how model candidates are generated
// using an AutoML job V2.
type CandidateGenerationConfig struct {

	// Stores the configuration information for the selection of algorithms used to
	// train model candidates on tabular data.
	//
	// The list of available algorithms to choose from depends on the training mode
	// set in [TabularJobConfig.Mode]TabularJobConfig.Mode .
	//
	//   - AlgorithmsConfig should not be set in AUTO training mode.
	//
	//   - When AlgorithmsConfig is provided, one AutoMLAlgorithms attribute must be
	//   set and one only.
	//
	// If the list of algorithms provided as values for AutoMLAlgorithms is empty,
	//   CandidateGenerationConfig uses the full set of algorithms for the given
	//   training mode.
	//
	//   - When AlgorithmsConfig is not provided, CandidateGenerationConfig uses the
	//   full set of algorithms for the given training mode.
	//
	// For the list of all algorithms per problem type and training mode, see [AutoMLAlgorithmConfig].
	//
	// For more information on each algorithm, see the [Algorithm support] section in Autopilot developer
	// guide.
	//
	// [TabularJobConfig.Mode]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TabularJobConfig.html
	// [Algorithm support]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support
	// [AutoMLAlgorithmConfig]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html
	AlgorithmsConfig []AutoMLAlgorithmConfig

	noSmithyDocumentSerde
}

// The properties of an AutoML candidate job.
type CandidateProperties struct {

	// The Amazon S3 prefix to the artifacts generated for an AutoML candidate.
	CandidateArtifactLocations *CandidateArtifactLocations

	// Information about the candidate metrics for an AutoML job.
	CandidateMetrics []MetricDatum

	noSmithyDocumentSerde
}

// The SageMaker Canvas application settings.
type CanvasAppSettings struct {

	// The model deployment settings for the SageMaker Canvas application.
	DirectDeploySettings *DirectDeploySettings

	// The generative AI settings for the SageMaker Canvas application.
	GenerativeAiSettings *GenerativeAiSettings

	// The settings for connecting to an external data source with OAuth.
	IdentityProviderOAuthSettings []IdentityProviderOAuthSetting

	// The settings for document querying.
	KendraSettings *KendraSettings

	// The model registry settings for the SageMaker Canvas application.
	ModelRegisterSettings *ModelRegisterSettings

	// Time series forecast settings for the SageMaker Canvas application.
	TimeSeriesForecastingSettings *TimeSeriesForecastingSettings

	// The workspace settings for the SageMaker Canvas application.
	WorkspaceSettings *WorkspaceSettings

	noSmithyDocumentSerde
}

// Specifies the type and size of the endpoint capacity to activate for a
// blue/green deployment, a rolling deployment, or a rollback strategy. You can
// specify your batches as either instance count or the overall percentage or your
// fleet.
//
// For a rollback strategy, if you don't specify the fields in this object, or if
// you set the Value to 100%, then SageMaker uses a blue/green rollback strategy
// and rolls all traffic back to the blue fleet.
type CapacitySize struct {

	// Specifies the endpoint capacity type.
	//
	//   - INSTANCE_COUNT : The endpoint activates based on the number of instances.
	//
	//   - CAPACITY_PERCENT : The endpoint activates based on the specified percentage
	//   of capacity.
	//
	// This member is required.
	Type CapacitySizeType

	// Defines the capacity size, either as a number of instances or a capacity
	// percentage.
	//
	// This member is required.
	Value *int32

	noSmithyDocumentSerde
}

// Configuration specifying how to treat different headers. If no headers are
// specified Amazon SageMaker will by default base64 encode when capturing the
// data.
type CaptureContentTypeHeader struct {

	// The list of all content type headers that Amazon SageMaker will treat as CSV
	// and capture accordingly.
	CsvContentTypes []string

	// The list of all content type headers that SageMaker will treat as JSON and
	// capture accordingly.
	JsonContentTypes []string

	noSmithyDocumentSerde
}

// Specifies data Model Monitor will capture.
type CaptureOption struct {

	// Specify the boundary of data to capture.
	//
	// This member is required.
	CaptureMode CaptureMode

	noSmithyDocumentSerde
}

// Environment parameters you want to benchmark your load test against.
type CategoricalParameter struct {

	// The Name of the environment variable.
	//
	// This member is required.
	Name *string

	// The list of values you can pass.
	//
	// This member is required.
	Value []string

	noSmithyDocumentSerde
}

// A list of categorical hyperparameters to tune.
type CategoricalParameterRange struct {

	// The name of the categorical hyperparameter to tune.
	//
	// This member is required.
	Name *string

	// A list of the categories for the hyperparameter.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Defines the possible values for a categorical hyperparameter.
type CategoricalParameterRangeSpecification struct {

	// The allowed categories for the hyperparameter.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// A channel is a named input source that training algorithms can consume.
type Channel struct {

	// The name of the channel.
	//
	// This member is required.
	ChannelName *string

	// The location of the channel data.
	//
	// This member is required.
	DataSource *DataSource

	// If training data is compressed, the compression type. The default value is None
	// . CompressionType is used only in Pipe input mode. In File mode, leave this
	// field unset or set it to None.
	CompressionType CompressionType

	// The MIME type of the data.
	ContentType *string

	// (Optional) The input mode to use for the data channel in a training job. If you
	// don't set a value for InputMode , SageMaker uses the value set for
	// TrainingInputMode . Use this parameter to override the TrainingInputMode
	// setting in a [AlgorithmSpecification]request when you have a channel that needs a different input mode
	// from the training job's general setting. To download the data from Amazon Simple
	// Storage Service (Amazon S3) to the provisioned ML storage volume, and mount the
	// directory to a Docker volume, use File input mode. To stream data directly from
	// Amazon S3 to the container, choose Pipe input mode.
	//
	// To use a model for incremental training, choose File input model.
	//
	// [AlgorithmSpecification]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AlgorithmSpecification.html
	InputMode TrainingInputMode

	// Specify RecordIO as the value when input data is in raw format but the training
	// algorithm requires the RecordIO format. In this case, SageMaker wraps each
	// individual S3 object in a RecordIO record. If the input data is already in
	// RecordIO format, you don't need to set this attribute. For more information, see
	// [Create a Dataset Using RecordIO].
	//
	// In File mode, leave this field unset or set it to None.
	//
	// [Create a Dataset Using RecordIO]: https://mxnet.apache.org/api/architecture/note_data_loading#data-format
	RecordWrapperType RecordWrapper

	// A configuration for a shuffle option for input data in a channel. If you use
	// S3Prefix for S3DataType , this shuffles the results of the S3 key prefix
	// matches. If you use ManifestFile , the order of the S3 object references in the
	// ManifestFile is shuffled. If you use AugmentedManifestFile , the order of the
	// JSON lines in the AugmentedManifestFile is shuffled. The shuffling order is
	// determined using the Seed value.
	//
	// For Pipe input mode, shuffling is done at the start of every epoch. With large
	// datasets this ensures that the order of the training data is different for each
	// epoch, it helps reduce bias and possible overfitting. In a multi-node training
	// job when ShuffleConfig is combined with S3DataDistributionType of ShardedByS3Key
	// , the data is shuffled across nodes so that the content sent to a particular
	// node on the first epoch might be sent to a different node on the second epoch.
	ShuffleConfig *ShuffleConfig

	noSmithyDocumentSerde
}

// Defines a named input source, called a channel, to be used by an algorithm.
type ChannelSpecification struct {

	// The name of the channel.
	//
	// This member is required.
	Name *string

	// The supported MIME types for the data.
	//
	// This member is required.
	SupportedContentTypes []string

	// The allowed input mode, either FILE or PIPE.
	//
	// In FILE mode, Amazon SageMaker copies the data from the input source onto the
	// local Amazon Elastic Block Store (Amazon EBS) volumes before starting your
	// training algorithm. This is the most commonly used input mode.
	//
	// In PIPE mode, Amazon SageMaker streams input data from the source directly to
	// your algorithm without using the EBS volume.
	//
	// This member is required.
	SupportedInputModes []TrainingInputMode

	// A brief description of the channel.
	Description *string

	// Indicates whether the channel is required by the algorithm.
	IsRequired *bool

	// The allowed compression types, if data compression is used.
	SupportedCompressionTypes []CompressionType

	noSmithyDocumentSerde
}

// Contains information about the output location for managed spot training
// checkpoint data.
type CheckpointConfig struct {

	// Identifies the S3 path where you want SageMaker to store checkpoints. For
	// example, s3://bucket-name/key-name-prefix .
	//
	// This member is required.
	S3Uri *string

	// (Optional) The local directory where checkpoints are written. The default
	// directory is /opt/ml/checkpoints/ .
	LocalPath *string

	noSmithyDocumentSerde
}

// The container for the metadata for the ClarifyCheck step. For more information,
// see the topic on [ClarifyCheck step]in the Amazon SageMaker Developer Guide.
//
// [ClarifyCheck step]: https://docs.aws.amazon.com/sagemaker/latest/dg/build-and-manage-steps.html#step-type-clarify-check
type ClarifyCheckStepMetadata struct {

	// The Amazon S3 URI of baseline constraints file to be used for the drift check.
	BaselineUsedForDriftCheckConstraints *string

	// The Amazon S3 URI of the newly calculated baseline constraints file.
	CalculatedBaselineConstraints *string

	// The Amazon Resource Name (ARN) of the check processing job that was run by this
	// step's execution.
	CheckJobArn *string

	// The type of the Clarify Check step
	CheckType *string

	// The model package group name.
	ModelPackageGroupName *string

	// This flag indicates if a newly calculated baseline can be accessed through step
	// properties BaselineUsedForDriftCheckConstraints and
	// BaselineUsedForDriftCheckStatistics . If it is set to False , the previous
	// baseline of the configured check type must also be available. These can be
	// accessed through the BaselineUsedForDriftCheckConstraints property.
	RegisterNewBaseline *bool

	// This flag indicates if the drift check against the previous baseline will be
	// skipped or not. If it is set to False , the previous baseline of the configured
	// check type must be available.
	SkipCheck *bool

	// The Amazon S3 URI of the violation report if violations are detected.
	ViolationReport *string

	noSmithyDocumentSerde
}

// The configuration parameters for the SageMaker Clarify explainer.
type ClarifyExplainerConfig struct {

	// The configuration for SHAP analysis.
	//
	// This member is required.
	ShapConfig *ClarifyShapConfig

	// A JMESPath boolean expression used to filter which records to explain.
	// Explanations are activated by default. See [EnableExplanations]EnableExplanations for additional
	// information.
	//
	// [EnableExplanations]: https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-enable
	EnableExplanations *string

	// The inference configuration parameter for the model container.
	InferenceConfig *ClarifyInferenceConfig

	noSmithyDocumentSerde
}

// The inference configuration parameter for the model container.
type ClarifyInferenceConfig struct {

	// A template string used to format a JSON record into an acceptable model
	// container input. For example, a ContentTemplate string
	// '{"myfeatures":$features}' will format a list of features [1,2,3] into the
	// record string '{"myfeatures":[1,2,3]}' . Required only when the model container
	// input is in JSON Lines format.
	ContentTemplate *string

	// The names of the features. If provided, these are included in the endpoint
	// response payload to help readability of the InvokeEndpoint output. See the [Response]
	// section under Invoke the endpoint in the Developer Guide for more information.
	//
	// [Response]: https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response
	FeatureHeaders []string

	// A list of data types of the features (optional). Applicable only to NLP
	// explainability. If provided, FeatureTypes must have at least one 'text' string
	// (for example, ['text'] ). If FeatureTypes is not provided, the explainer infers
	// the feature types based on the baseline data. The feature types are included in
	// the endpoint response payload. For additional information see the [response]section under
	// Invoke the endpoint in the Developer Guide for more information.
	//
	// [response]: https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response
	FeatureTypes []ClarifyFeatureType

	// Provides the JMESPath expression to extract the features from a model container
	// input in JSON Lines format. For example, if FeaturesAttribute is the JMESPath
	// expression 'myfeatures' , it extracts a list of features [1,2,3] from request
	// data '{"myfeatures":[1,2,3]}' .
	FeaturesAttribute *string

	// A JMESPath expression used to locate the list of label headers in the model
	// container output.
	//
	// Example: If the model container output of a batch request is
	// '{"labels":["cat","dog","fish"],"probability":[0.6,0.3,0.1]}' , then set
	// LabelAttribute to 'labels' to extract the list of label headers
	// ["cat","dog","fish"]
	LabelAttribute *string

	// For multiclass classification problems, the label headers are the names of the
	// classes. Otherwise, the label header is the name of the predicted label. These
	// are used to help readability for the output of the InvokeEndpoint API. See the [response]
	// section under Invoke the endpoint in the Developer Guide for more information.
	// If there are no label headers in the model container output, provide them
	// manually using this parameter.
	//
	// [response]: https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-invoke-endpoint.html#clarify-online-explainability-response
	LabelHeaders []string

	// A zero-based index used to extract a label header or list of label headers from
	// model container output in CSV format.
	//
	// Example for a multiclass model: If the model container output consists of label
	// headers followed by probabilities:
	// '"[\'cat\',\'dog\',\'fish\']","[0.1,0.6,0.3]"' , set LabelIndex to 0 to select
	// the label headers ['cat','dog','fish'] .
	LabelIndex *int32

	// The maximum payload size (MB) allowed of a request from the explainer to the
	// model container. Defaults to 6 MB.
	MaxPayloadInMB *int32

	// The maximum number of records in a request that the model container can process
	// when querying the model container for the predictions of a [synthetic dataset]. A record is a unit
	// of input data that inference can be made on, for example, a single line in CSV
	// data. If MaxRecordCount is 1 , the model container expects one record per
	// request. A value of 2 or greater means that the model expects batch requests,
	// which can reduce overhead and speed up the inferencing process. If this
	// parameter is not provided, the explainer will tune the record count per request
	// according to the model container's capacity at runtime.
	//
	// [synthetic dataset]: https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-synthetic
	MaxRecordCount *int32

	// A JMESPath expression used to extract the probability (or score) from the model
	// container output if the model container is in JSON Lines format.
	//
	// Example: If the model container output of a single request is
	// '{"predicted_label":1,"probability":0.6}' , then set ProbabilityAttribute to
	// 'probability' .
	ProbabilityAttribute *string

	// A zero-based index used to extract a probability value (score) or list from
	// model container output in CSV format. If this value is not provided, the entire
	// model container output will be treated as a probability value (score) or list.
	//
	// Example for a single class model: If the model container output consists of a
	// string-formatted prediction label followed by its probability: '1,0.6' , set
	// ProbabilityIndex to 1 to select the probability value 0.6 .
	//
	// Example for a multiclass model: If the model container output consists of a
	// string-formatted prediction label followed by its probability:
	// '"[\'cat\',\'dog\',\'fish\']","[0.1,0.6,0.3]"' , set ProbabilityIndex to 1 to
	// select the probability values [0.1,0.6,0.3] .
	ProbabilityIndex *int32

	noSmithyDocumentSerde
}

// The configuration for the [SHAP baseline] (also called the background or reference dataset) of
// the Kernal SHAP algorithm.
//
//   - The number of records in the baseline data determines the size of the
//     synthetic dataset, which has an impact on latency of explainability requests.
//     For more information, see the Synthetic data of [Configure and create an endpoint].
//
//   - ShapBaseline and ShapBaselineUri are mutually exclusive parameters. One or
//     the either is required to configure a SHAP baseline.
//
// [SHAP baseline]: https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-feature-attribute-shap-baselines.html
// [Configure and create an endpoint]: https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html
type ClarifyShapBaselineConfig struct {

	// The MIME type of the baseline data. Choose from 'text/csv' or
	// 'application/jsonlines' . Defaults to 'text/csv' .
	MimeType *string

	// The inline SHAP baseline data in string format. ShapBaseline can have one or
	// multiple records to be used as the baseline dataset. The format of the SHAP
	// baseline file should be the same format as the training dataset. For example, if
	// the training dataset is in CSV format and each record contains four features,
	// and all features are numerical, then the format of the baseline data should also
	// share these characteristics. For natural language processing (NLP) of text
	// columns, the baseline value should be the value used to replace the unit of text
	// specified by the Granularity of the TextConfig parameter. The size limit for
	// ShapBasline is 4 KB. Use the ShapBaselineUri parameter if you want to provide
	// more than 4 KB of baseline data.
	ShapBaseline *string

	// The uniform resource identifier (URI) of the S3 bucket where the SHAP baseline
	// file is stored. The format of the SHAP baseline file should be the same format
	// as the format of the training dataset. For example, if the training dataset is
	// in CSV format, and each record in the training dataset has four features, and
	// all features are numerical, then the baseline file should also have this same
	// format. Each record should contain only the features. If you are using a virtual
	// private cloud (VPC), the ShapBaselineUri should be accessible to the VPC. For
	// more information about setting up endpoints with Amazon Virtual Private Cloud,
	// see [Give SageMaker access to Resources in your Amazon Virtual Private Cloud].
	//
	// [Give SageMaker access to Resources in your Amazon Virtual Private Cloud]: https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html
	ShapBaselineUri *string

	noSmithyDocumentSerde
}

// The configuration for SHAP analysis using SageMaker Clarify Explainer.
type ClarifyShapConfig struct {

	// The configuration for the SHAP baseline of the Kernal SHAP algorithm.
	//
	// This member is required.
	ShapBaselineConfig *ClarifyShapBaselineConfig

	// The number of samples to be used for analysis by the Kernal SHAP algorithm.
	//
	// The number of samples determines the size of the synthetic dataset, which has
	// an impact on latency of explainability requests. For more information, see the
	// Synthetic data of [Configure and create an endpoint].
	//
	// [Configure and create an endpoint]: https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html
	NumberOfSamples *int32

	// The starting value used to initialize the random number generator in the
	// explainer. Provide a value for this parameter to obtain a deterministic SHAP
	// result.
	Seed *int32

	// A parameter that indicates if text features are treated as text and
	// explanations are provided for individual units of text. Required for natural
	// language processing (NLP) explainability only.
	TextConfig *ClarifyTextConfig

	// A Boolean toggle to indicate if you want to use the logit function (true) or
	// log-odds units (false) for model predictions. Defaults to false.
	UseLogit *bool

	noSmithyDocumentSerde
}

// A parameter used to configure the SageMaker Clarify explainer to treat text
// features as text so that explanations are provided for individual units of text.
// Required only for natural language processing (NLP) explainability.
type ClarifyTextConfig struct {

	// The unit of granularity for the analysis of text features. For example, if the
	// unit is 'token' , then each token (like a word in English) of the text is
	// treated as a feature. SHAP values are computed for each unit/feature.
	//
	// This member is required.
	Granularity ClarifyTextGranularity

	// Specifies the language of the text features in [ISO 639-1] or [ISO 639-3] code of a supported
	// language.
	//
	// For a mix of multiple languages, use code 'xx' .
	//
	// [ISO 639-1]: https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes
	// [ISO 639-3]: https://en.wikipedia.org/wiki/ISO_639-3
	//
	// This member is required.
	Language ClarifyTextLanguage

	noSmithyDocumentSerde
}

// Details of an instance group in a SageMaker HyperPod cluster.
type ClusterInstanceGroupDetails struct {

	// The number of instances that are currently in the instance group of a SageMaker
	// HyperPod cluster.
	CurrentCount *int32

	// The execution role for the instance group to assume.
	ExecutionRole *string

	// The name of the instance group of a SageMaker HyperPod cluster.
	InstanceGroupName *string

	// The instance type of the instance group of a SageMaker HyperPod cluster.
	InstanceType ClusterInstanceType

	// Details of LifeCycle configuration for the instance group.
	LifeCycleConfig *ClusterLifeCycleConfig

	// The number of instances you specified to add to the instance group of a
	// SageMaker HyperPod cluster.
	TargetCount *int32

	// The number you specified to TreadsPerCore in CreateCluster for enabling or
	// disabling multithreading. For instance types that support multithreading, you
	// can specify 1 for disabling multithreading and 2 for enabling multithreading.
	// For more information, see the reference table of [CPU cores and threads per CPU core per instance type]in the Amazon Elastic Compute
	// Cloud User Guide.
	//
	// [CPU cores and threads per CPU core per instance type]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cpu-options-supported-instances-values.html
	ThreadsPerCore *int32

	noSmithyDocumentSerde
}

// The specifications of an instance group that you need to define.
type ClusterInstanceGroupSpecification struct {

	// Specifies an IAM execution role to be assumed by the instance group.
	//
	// This member is required.
	ExecutionRole *string

	// Specifies the number of instances to add to the instance group of a SageMaker
	// HyperPod cluster.
	//
	// This member is required.
	InstanceCount *int32

	// Specifies the name of the instance group.
	//
	// This member is required.
	InstanceGroupName *string

	// Specifies the instance type of the instance group.
	//
	// This member is required.
	InstanceType ClusterInstanceType

	// Specifies the LifeCycle configuration for the instance group.
	//
	// This member is required.
	LifeCycleConfig *ClusterLifeCycleConfig

	// Specifies the value for Threads per core. For instance types that support
	// multithreading, you can specify 1 for disabling multithreading and 2 for
	// enabling multithreading. For instance types that doesn't support multithreading,
	// specify 1 . For more information, see the reference table of [CPU cores and threads per CPU core per instance type] in the Amazon
	// Elastic Compute Cloud User Guide.
	//
	// [CPU cores and threads per CPU core per instance type]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cpu-options-supported-instances-values.html
	ThreadsPerCore *int32

	noSmithyDocumentSerde
}

// Details of an instance in a SageMaker HyperPod cluster.
type ClusterInstanceStatusDetails struct {

	// The status of an instance in a SageMaker HyperPod cluster.
	//
	// This member is required.
	Status ClusterInstanceStatus

	// The message from an instance in a SageMaker HyperPod cluster.
	Message *string

	noSmithyDocumentSerde
}

// The lifecycle configuration for a SageMaker HyperPod cluster.
type ClusterLifeCycleConfig struct {

	// The file name of the entrypoint script of lifecycle scripts under SourceS3Uri .
	// This entrypoint script runs during cluster creation.
	//
	// This member is required.
	OnCreate *string

	// An Amazon S3 bucket path where your lifecycle scripts are stored.
	//
	// Make sure that the S3 bucket path starts with s3://sagemaker- . The [IAM role for SageMaker HyperPod] has the
	// managed [AmazonSageMakerClusterInstanceRolePolicy]AmazonSageMakerClusterInstanceRolePolicy attached, which allows access
	// to S3 buckets with the specific prefix sagemaker- .
	//
	// [AmazonSageMakerClusterInstanceRolePolicy]: https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-cluster.html
	// [IAM role for SageMaker HyperPod]: https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-prerequisites.html#sagemaker-hyperpod-prerequisites-iam-role-for-hyperpod
	//
	// This member is required.
	SourceS3Uri *string

	noSmithyDocumentSerde
}

// Details of an instance (also called a node interchangeably) in a SageMaker
// HyperPod cluster.
type ClusterNodeDetails struct {

	// The instance group name in which the instance is.
	InstanceGroupName *string

	// The ID of the instance.
	InstanceId *string

	// The status of the instance.
	InstanceStatus *ClusterInstanceStatusDetails

	// The type of the instance.
	InstanceType ClusterInstanceType

	// The time when the instance is launched.
	LaunchTime *time.Time

	// The LifeCycle configuration applied to the instance.
	LifeCycleConfig *ClusterLifeCycleConfig

	// The number of threads per CPU core you specified under CreateCluster .
	ThreadsPerCore *int32

	noSmithyDocumentSerde
}

// Lists a summary of the properties of an instance (also called a node
// interchangeably) of a SageMaker HyperPod cluster.
type ClusterNodeSummary struct {

	// The name of the instance group in which the instance is.
	//
	// This member is required.
	InstanceGroupName *string

	// The ID of the instance.
	//
	// This member is required.
	InstanceId *string

	// The status of the instance.
	//
	// This member is required.
	InstanceStatus *ClusterInstanceStatusDetails

	// The type of the instance.
	//
	// This member is required.
	InstanceType ClusterInstanceType

	// The time when the instance is launched.
	//
	// This member is required.
	LaunchTime *time.Time

	noSmithyDocumentSerde
}

// Lists a summary of the properties of a SageMaker HyperPod cluster.
type ClusterSummary struct {

	// The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
	//
	// This member is required.
	ClusterArn *string

	// The name of the SageMaker HyperPod cluster.
	//
	// This member is required.
	ClusterName *string

	// The status of the SageMaker HyperPod cluster.
	//
	// This member is required.
	ClusterStatus ClusterStatus

	// The time when the SageMaker HyperPod cluster is created.
	//
	// This member is required.
	CreationTime *time.Time

	noSmithyDocumentSerde
}

// The configuration for the file system and kernels in a SageMaker image running
// as a Code Editor app. The FileSystemConfig object is not supported.
type CodeEditorAppImageConfig struct {

	// The configuration used to run the application image container.
	ContainerConfig *ContainerConfig

	// The Amazon Elastic File System storage configuration for a SageMaker image.
	FileSystemConfig *FileSystemConfig

	noSmithyDocumentSerde
}

// The Code Editor application settings.
//
// For more information about Code Editor, see [Get started with Code Editor in Amazon SageMaker].
//
// [Get started with Code Editor in Amazon SageMaker]: https://docs.aws.amazon.com/sagemaker/latest/dg/code-editor.html
type CodeEditorAppSettings struct {

	// A list of custom SageMaker images that are configured to run as a Code Editor
	// app.
	CustomImages []CustomImage

	// Specifies the ARN's of a SageMaker image and SageMaker image version, and the
	// instance type that the version runs on.
	DefaultResourceSpec *ResourceSpec

	// The Amazon Resource Name (ARN) of the Code Editor application lifecycle
	// configuration.
	LifecycleConfigArns []string

	noSmithyDocumentSerde
}

// A Git repository that SageMaker automatically displays to users for cloning in
// the JupyterServer application.
type CodeRepository struct {

	// The URL of the Git repository.
	//
	// This member is required.
	RepositoryUrl *string

	noSmithyDocumentSerde
}

// Specifies summary information about a Git repository.
type CodeRepositorySummary struct {

	// The Amazon Resource Name (ARN) of the Git repository.
	//
	// This member is required.
	CodeRepositoryArn *string

	// The name of the Git repository.
	//
	// This member is required.
	CodeRepositoryName *string

	// The date and time that the Git repository was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The date and time that the Git repository was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// Configuration details for the Git repository, including the URL where it is
	// located and the ARN of the Amazon Web Services Secrets Manager secret that
	// contains the credentials used to access the repository.
	GitConfig *GitConfig

	noSmithyDocumentSerde
}

// Use this parameter to configure your Amazon Cognito workforce. A single Cognito
// workforce is created using and corresponds to a single [Amazon Cognito user pool].
//
// [Amazon Cognito user pool]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html
type CognitoConfig struct {

	// The client ID for your Amazon Cognito user pool.
	//
	// This member is required.
	ClientId *string

	// A [user pool] is a user directory in Amazon Cognito. With a user pool, your users can sign
	// in to your web or mobile app through Amazon Cognito. Your users can also sign in
	// through social identity providers like Google, Facebook, Amazon, or Apple, and
	// through SAML identity providers.
	//
	// [user pool]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html
	//
	// This member is required.
	UserPool *string

	noSmithyDocumentSerde
}

// Identifies a Amazon Cognito user group. A user group can be used in on or more
// work teams.
type CognitoMemberDefinition struct {

	// An identifier for an application client. You must create the app client ID
	// using Amazon Cognito.
	//
	// This member is required.
	ClientId *string

	// An identifier for a user group.
	//
	// This member is required.
	UserGroup *string

	// An identifier for a user pool. The user pool must be in the same region as the
	// service that you are calling.
	//
	// This member is required.
	UserPool *string

	noSmithyDocumentSerde
}

// Configuration for your collection.
//
// The following types satisfy this interface:
//
//	CollectionConfigMemberVectorConfig
type CollectionConfig interface {
	isCollectionConfig()
}

// Configuration for your vector collection type.
//
//   - Dimension : The number of elements in your vector.
type CollectionConfigMemberVectorConfig struct {
	Value VectorConfig

	noSmithyDocumentSerde
}

func (*CollectionConfigMemberVectorConfig) isCollectionConfig() {}

// Configuration information for the Amazon SageMaker Debugger output tensor
// collections.
type CollectionConfiguration struct {

	// The name of the tensor collection. The name must be unique relative to other
	// rule configuration names.
	CollectionName *string

	// Parameter values for the tensor collection. The allowed parameters are "name" ,
	// "include_regex" , "reduction_config" , "save_config" , "tensor_names" , and
	// "save_histogram" .
	CollectionParameters map[string]string

	noSmithyDocumentSerde
}

// A summary of a model compilation job.
type CompilationJobSummary struct {

	// The Amazon Resource Name (ARN) of the model compilation job.
	//
	// This member is required.
	CompilationJobArn *string

	// The name of the model compilation job that you want a summary for.
	//
	// This member is required.
	CompilationJobName *string

	// The status of the model compilation job.
	//
	// This member is required.
	CompilationJobStatus CompilationJobStatus

	// The time when the model compilation job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The time when the model compilation job completed.
	CompilationEndTime *time.Time

	// The time when the model compilation job started.
	CompilationStartTime *time.Time

	// The type of device that the model will run on after the compilation job has
	// completed.
	CompilationTargetDevice TargetDevice

	// The type of accelerator that the model will run on after the compilation job
	// has completed.
	CompilationTargetPlatformAccelerator TargetPlatformAccelerator

	// The type of architecture that the model will run on after the compilation job
	// has completed.
	CompilationTargetPlatformArch TargetPlatformArch

	// The type of OS that the model will run on after the compilation job has
	// completed.
	CompilationTargetPlatformOs TargetPlatformOs

	// The time when the model compilation job was last modified.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Metadata for a Condition step.
type ConditionStepMetadata struct {

	// The outcome of the Condition step evaluation.
	Outcome ConditionOutcome

	noSmithyDocumentSerde
}

// The configuration used to run the application image container.
type ContainerConfig struct {

	// The arguments for the container when you're running the application.
	ContainerArguments []string

	// The entrypoint used to run the application in the container.
	ContainerEntrypoint []string

	// The environment variables to set in the container
	ContainerEnvironmentVariables map[string]string

	noSmithyDocumentSerde
}

// Describes the container, as part of model definition.
type ContainerDefinition struct {

	// This parameter is ignored for models that contain only a PrimaryContainer .
	//
	// When a ContainerDefinition is part of an inference pipeline, the value of the
	// parameter uniquely identifies the container for the purposes of logging and
	// metrics. For information, see [Use Logs and Metrics to Monitor an Inference Pipeline]. If you don't specify a value for this parameter
	// for a ContainerDefinition that is part of an inference pipeline, a unique name
	// is automatically assigned based on the position of the ContainerDefinition in
	// the pipeline. If you specify a value for the ContainerHostName for any
	// ContainerDefinition that is part of an inference pipeline, you must specify a
	// value for the ContainerHostName parameter of every ContainerDefinition in that
	// pipeline.
	//
	// [Use Logs and Metrics to Monitor an Inference Pipeline]: https://docs.aws.amazon.com/sagemaker/latest/dg/inference-pipeline-logs-metrics.html
	ContainerHostname *string

	// The environment variables to set in the Docker container.
	//
	// The maximum length of each key and value in the Environment map is 1024 bytes.
	// The maximum length of all keys and values in the map, combined, is 32 KB. If you
	// pass multiple containers to a CreateModel request, then the maximum length of
	// all of their maps, combined, is also 32 KB.
	Environment map[string]string

	// The path where inference code is stored. This can be either in Amazon EC2
	// Container Registry or in a Docker registry that is accessible from the same VPC
	// that you configure for your endpoint. If you are using your own custom algorithm
	// instead of an algorithm provided by SageMaker, the inference code must meet
	// SageMaker requirements. SageMaker supports both registry/repository[:tag] and
	// registry/repository[@digest] image path formats. For more information, see [Using Your Own Algorithms with Amazon SageMaker].
	//
	// The model artifacts in an Amazon S3 bucket and the Docker image for inference
	// container in Amazon EC2 Container Registry must be in the same region as the
	// model or endpoint you are creating.
	//
	// [Using Your Own Algorithms with Amazon SageMaker]: https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html
	Image *string

	// Specifies whether the model container is in Amazon ECR or a private Docker
	// registry accessible from your Amazon Virtual Private Cloud (VPC). For
	// information about storing containers in a private Docker registry, see [Use a Private Docker Registry for Real-Time Inference Containers].
	//
	// The model artifacts in an Amazon S3 bucket and the Docker image for inference
	// container in Amazon EC2 Container Registry must be in the same region as the
	// model or endpoint you are creating.
	//
	// [Use a Private Docker Registry for Real-Time Inference Containers]: https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html
	ImageConfig *ImageConfig

	// The inference specification name in the model package version.
	InferenceSpecificationName *string

	// Whether the container hosts a single model or multiple models.
	Mode ContainerMode

	// Specifies the location of ML model data to deploy.
	//
	// Currently you cannot use ModelDataSource in conjunction with SageMaker batch
	// transform, SageMaker serverless endpoints, SageMaker multi-model endpoints, and
	// SageMaker Marketplace.
	ModelDataSource *ModelDataSource

	// The S3 path where the model artifacts, which result from model training, are
	// stored. This path must point to a single gzip compressed tar archive (.tar.gz
	// suffix). The S3 path is required for SageMaker built-in algorithms, but not if
	// you use your own algorithms. For more information on built-in algorithms, see [Common Parameters].
	//
	// The model artifacts must be in an S3 bucket that is in the same region as the
	// model or endpoint you are creating.
	//
	// If you provide a value for this parameter, SageMaker uses Amazon Web Services
	// Security Token Service to download model artifacts from the S3 path you provide.
	// Amazon Web Services STS is activated in your Amazon Web Services account by
	// default. If you previously deactivated Amazon Web Services STS for a region, you
	// need to reactivate Amazon Web Services STS for that region. For more
	// information, see [Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region]in the Amazon Web Services Identity and Access Management User
	// Guide.
	//
	// If you use a built-in algorithm to create a model, SageMaker requires that you
	// provide a S3 path to the model artifacts in ModelDataUrl .
	//
	// [Common Parameters]: https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html
	// [Activating and Deactivating Amazon Web Services STS in an Amazon Web Services Region]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html
	ModelDataUrl *string

	// The name or Amazon Resource Name (ARN) of the model package to use to create
	// the model.
	ModelPackageName *string

	// Specifies additional configuration for multi-model endpoints.
	MultiModelConfig *MultiModelConfig

	noSmithyDocumentSerde
}

// A structure describing the source of a context.
type ContextSource struct {

	// The URI of the source.
	//
	// This member is required.
	SourceUri *string

	// The ID of the source.
	SourceId *string

	// The type of the source.
	SourceType *string

	noSmithyDocumentSerde
}

// Lists a summary of the properties of a context. A context provides a logical
// grouping of other entities.
type ContextSummary struct {

	// The Amazon Resource Name (ARN) of the context.
	ContextArn *string

	// The name of the context.
	ContextName *string

	// The type of the context.
	ContextType *string

	// When the context was created.
	CreationTime *time.Time

	// When the context was last modified.
	LastModifiedTime *time.Time

	// The source of the context.
	Source *ContextSource

	noSmithyDocumentSerde
}

// A list of continuous hyperparameters to tune.
type ContinuousParameterRange struct {

	// The maximum value for the hyperparameter. The tuning job uses floating-point
	// values between MinValue value and this value for tuning.
	//
	// This member is required.
	MaxValue *string

	// The minimum value for the hyperparameter. The tuning job uses floating-point
	// values between this value and MaxValue for tuning.
	//
	// This member is required.
	MinValue *string

	// The name of the continuous hyperparameter to tune.
	//
	// This member is required.
	Name *string

	// The scale that hyperparameter tuning uses to search the hyperparameter range.
	// For information about choosing a hyperparameter scale, see [Hyperparameter Scaling]. One of the
	// following values:
	//
	// Auto SageMaker hyperparameter tuning chooses the best scale for the
	// hyperparameter.
	//
	// Linear Hyperparameter tuning searches the values in the hyperparameter range by
	// using a linear scale.
	//
	// Logarithmic Hyperparameter tuning searches the values in the hyperparameter
	// range by using a logarithmic scale.
	//
	// Logarithmic scaling works only for ranges that have only values greater than 0.
	//
	// ReverseLogarithmic Hyperparameter tuning searches the values in the
	// hyperparameter range by using a reverse logarithmic scale.
	//
	// Reverse logarithmic scaling works only for ranges that are entirely within the
	// range 0<=x<1.0.
	//
	// [Hyperparameter Scaling]: https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type
	ScalingType HyperParameterScalingType

	noSmithyDocumentSerde
}

// Defines the possible values for a continuous hyperparameter.
type ContinuousParameterRangeSpecification struct {

	// The maximum floating-point value allowed.
	//
	// This member is required.
	MaxValue *string

	// The minimum floating-point value allowed.
	//
	// This member is required.
	MinValue *string

	noSmithyDocumentSerde
}

// A flag to indicating that automatic model tuning (AMT) has detected model
// convergence, defined as a lack of significant improvement (1% or less) against
// an objective metric.
type ConvergenceDetected struct {

	// A flag to stop a tuning job once AMT has detected that the job has converged.
	CompleteOnConvergence CompleteOnConvergence

	noSmithyDocumentSerde
}

// A file system, created by you, that you assign to a user profile or space for
// an Amazon SageMaker Domain. Permitted users can access this file system in
// Amazon SageMaker Studio.
//
// The following types satisfy this interface:
//
//	CustomFileSystemMemberEFSFileSystem
type CustomFileSystem interface {
	isCustomFileSystem()
}

// A custom file system in Amazon EFS.
type CustomFileSystemMemberEFSFileSystem struct {
	Value EFSFileSystem

	noSmithyDocumentSerde
}

func (*CustomFileSystemMemberEFSFileSystem) isCustomFileSystem() {}

// The settings for assigning a custom file system to a user profile or space for
// an Amazon SageMaker Domain. Permitted users can access this file system in
// Amazon SageMaker Studio.
//
// The following types satisfy this interface:
//
//	CustomFileSystemConfigMemberEFSFileSystemConfig
type CustomFileSystemConfig interface {
	isCustomFileSystemConfig()
}

// The settings for a custom Amazon EFS file system.
type CustomFileSystemConfigMemberEFSFileSystemConfig struct {
	Value EFSFileSystemConfig

	noSmithyDocumentSerde
}

func (*CustomFileSystemConfigMemberEFSFileSystemConfig) isCustomFileSystemConfig() {}

// A custom SageMaker image. For more information, see [Bring your own SageMaker image].
//
// [Bring your own SageMaker image]: https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html
type CustomImage struct {

	// The name of the AppImageConfig.
	//
	// This member is required.
	AppImageConfigName *string

	// The name of the CustomImage. Must be unique to your account.
	//
	// This member is required.
	ImageName *string

	// The version number of the CustomImage.
	ImageVersionNumber *int32

	noSmithyDocumentSerde
}

// A customized metric.
type CustomizedMetricSpecification struct {

	// The name of the customized metric.
	MetricName *string

	// The namespace of the customized metric.
	Namespace *string

	// The statistic of the customized metric.
	Statistic Statistic

	noSmithyDocumentSerde
}

// Details about the POSIX identity that is used for file system operations.
type CustomPosixUserConfig struct {

	// The POSIX group ID.
	//
	// This member is required.
	Gid *int64

	// The POSIX user ID.
	//
	// This member is required.
	Uid *int64

	noSmithyDocumentSerde
}

// Configuration to control how SageMaker captures inference data.
type DataCaptureConfig struct {

	// Specifies data Model Monitor will capture. You can configure whether to collect
	// only input, only output, or both
	//
	// This member is required.
	CaptureOptions []CaptureOption

	// The Amazon S3 location used to capture the data.
	//
	// This member is required.
	DestinationS3Uri *string

	// The percentage of requests SageMaker will capture. A lower value is recommended
	// for Endpoints with high traffic.
	//
	// This member is required.
	InitialSamplingPercentage *int32

	// Configuration specifying how to treat different headers. If no headers are
	// specified SageMaker will by default base64 encode when capturing the data.
	CaptureContentTypeHeader *CaptureContentTypeHeader

	// Whether data capture should be enabled or disabled (defaults to enabled).
	EnableCapture *bool

	// The Amazon Resource Name (ARN) of an Key Management Service key that SageMaker
	// uses to encrypt the captured data at rest using Amazon S3 server-side
	// encryption.
	//
	// The KmsKeyId can be any of the following formats:
	//
	//   - Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   - Key ARN:
	//   arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   - Alias name: alias/ExampleAlias
	//
	//   - Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias
	KmsKeyId *string

	noSmithyDocumentSerde
}

// The currently active data capture configuration used by your Endpoint.
type DataCaptureConfigSummary struct {

	// Whether data capture is currently functional.
	//
	// This member is required.
	CaptureStatus CaptureStatus

	// The percentage of requests being captured by your Endpoint.
	//
	// This member is required.
	CurrentSamplingPercentage *int32

	// The Amazon S3 location being used to capture the data.
	//
	// This member is required.
	DestinationS3Uri *string

	// Whether data capture is enabled or disabled.
	//
	// This member is required.
	EnableCapture *bool

	// The KMS key being used to encrypt the data in Amazon S3.
	//
	// This member is required.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// The meta data of the Glue table which serves as data catalog for the
// OfflineStore .
type DataCatalogConfig struct {

	// The name of the Glue table catalog.
	//
	// This member is required.
	Catalog *string

	// The name of the Glue table database.
	//
	// This member is required.
	Database *string

	// The name of the Glue table.
	//
	// This member is required.
	TableName *string

	noSmithyDocumentSerde
}

// The data structure used to specify the data to be used for inference in a batch
// transform job and to associate the data that is relevant to the prediction
// results in the output. The input filter provided allows you to exclude input
// data that is not needed for inference in a batch transform job. The output
// filter provided allows you to include input data relevant to interpreting the
// predictions in the output from the job. For more information, see [Associate Prediction Results with their Corresponding Input Records].
//
// [Associate Prediction Results with their Corresponding Input Records]: https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html
type DataProcessing struct {

	// A [JSONPath] expression used to select a portion of the input data to pass to the
	// algorithm. Use the InputFilter parameter to exclude fields, such as an ID
	// column, from the input. If you want SageMaker to pass the entire input dataset
	// to the algorithm, accept the default value $ .
	//
	// Examples: "$" , "$[1:]" , "$.features"
	//
	// [JSONPath]: https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators
	InputFilter *string

	// Specifies the source of the data to join with the transformed data. The valid
	// values are None and Input . The default value is None , which specifies not to
	// join the input with the transformed data. If you want the batch transform job to
	// join the original input data with the transformed data, set JoinSource to Input
	// . You can specify OutputFilter as an additional filter to select a portion of
	// the joined dataset and store it in the output file.
	//
	// For JSON or JSONLines objects, such as a JSON array, SageMaker adds the
	// transformed data to the input JSON object in an attribute called SageMakerOutput
	// . The joined result for JSON must be a key-value pair object. If the input is
	// not a key-value pair object, SageMaker creates a new JSON file. In the new JSON
	// file, and the input data is stored under the SageMakerInput key and the results
	// are stored in SageMakerOutput .
	//
	// For CSV data, SageMaker takes each row as a JSON array and joins the
	// transformed data with the input by appending each transformed row to the end of
	// the input. The joined data has the original input data followed by the
	// transformed data and the output is a CSV file.
	//
	// For information on how joining in applied, see [Workflow for Associating Inferences with Input Records].
	//
	// [Workflow for Associating Inferences with Input Records]: https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#batch-transform-data-processing-workflow
	JoinSource JoinSource

	// A [JSONPath] expression used to select a portion of the joined dataset to save in the
	// output file for a batch transform job. If you want SageMaker to store the entire
	// input dataset in the output file, leave the default value, $ . If you specify
	// indexes that aren't within the dimension size of the joined dataset, you get an
	// error.
	//
	// Examples: "$" , "$[0,5:]" , "$['id','SageMakerOutput']"
	//
	// [JSONPath]: https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html#data-processing-operators
	OutputFilter *string

	noSmithyDocumentSerde
}

// Information about the container that a data quality monitoring job runs.
type DataQualityAppSpecification struct {

	// The container image that the data quality monitoring job runs.
	//
	// This member is required.
	ImageUri *string

	// The arguments to send to the container that the monitoring job runs.
	ContainerArguments []string

	// The entrypoint for a container used to run a monitoring job.
	ContainerEntrypoint []string

	// Sets the environment variables in the container that the monitoring job runs.
	Environment map[string]string

	// An Amazon S3 URI to a script that is called after analysis has been performed.
	// Applicable only for the built-in (first party) containers.
	PostAnalyticsProcessorSourceUri *string

	// An Amazon S3 URI to a script that is called per row prior to running analysis.
	// It can base64 decode the payload and convert it into a flattened JSON so that
	// the built-in container can use the converted data. Applicable only for the
	// built-in (first party) containers.
	RecordPreprocessorSourceUri *string

	noSmithyDocumentSerde
}

// Configuration for monitoring constraints and monitoring statistics. These
// baseline resources are compared against the results of the current job from the
// series of jobs scheduled to collect data periodically.
type DataQualityBaselineConfig struct {

	// The name of the job that performs baselining for the data quality monitoring
	// job.
	BaseliningJobName *string

	// The constraints resource for a monitoring job.
	ConstraintsResource *MonitoringConstraintsResource

	// The statistics resource for a monitoring job.
	StatisticsResource *MonitoringStatisticsResource

	noSmithyDocumentSerde
}

// The input for the data quality monitoring job. Currently endpoints are
// supported for input.
type DataQualityJobInput struct {

	// Input object for the batch transform job.
	BatchTransformInput *BatchTransformInput

	// Input object for the endpoint
	EndpointInput *EndpointInput

	noSmithyDocumentSerde
}

// Configuration for Dataset Definition inputs. The Dataset Definition input must
// specify exactly one of either AthenaDatasetDefinition or
// RedshiftDatasetDefinition types.
type DatasetDefinition struct {

	// Configuration for Athena Dataset Definition input.
	AthenaDatasetDefinition *AthenaDatasetDefinition

	// Whether the generated dataset is FullyReplicated or ShardedByS3Key (default).
	DataDistributionType DataDistributionType

	// Whether to use File or Pipe input mode. In File (default) mode, Amazon
	// SageMaker copies the data from the input source onto the local Amazon Elastic
	// Block Store (Amazon EBS) volumes before starting your training algorithm. This
	// is the most commonly used input mode. In Pipe mode, Amazon SageMaker streams
	// input data from the source directly to your algorithm without using the EBS
	// volume.
	InputMode InputMode

	// The local path where you want Amazon SageMaker to download the Dataset
	// Definition inputs to run a processing job. LocalPath is an absolute path to the
	// input data. This is a required parameter when AppManaged is False (default).
	LocalPath *string

	// Configuration for Redshift Dataset Definition input.
	RedshiftDatasetDefinition *RedshiftDatasetDefinition

	noSmithyDocumentSerde
}

// Describes the location of the channel data.
type DataSource struct {

	// The file system that is associated with a channel.
	FileSystemDataSource *FileSystemDataSource

	// The S3 location of the data source that is associated with a channel.
	S3DataSource *S3DataSource

	noSmithyDocumentSerde
}

// Configuration information for the Amazon SageMaker Debugger hook parameters,
// metric and tensor collections, and storage paths. To learn more about how to
// configure the DebugHookConfig parameter, see [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job].
//
// [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job]: https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html
type DebugHookConfig struct {

	// Path to Amazon S3 storage location for metrics and tensors.
	//
	// This member is required.
	S3OutputPath *string

	// Configuration information for Amazon SageMaker Debugger tensor collections. To
	// learn more about how to configure the CollectionConfiguration parameter, see [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job].
	//
	// [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job]: https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html
	CollectionConfigurations []CollectionConfiguration

	// Configuration information for the Amazon SageMaker Debugger hook parameters.
	HookParameters map[string]string

	// Path to local storage location for metrics and tensors. Defaults to
	// /opt/ml/output/tensors/ .
	LocalPath *string

	noSmithyDocumentSerde
}

// Configuration information for SageMaker Debugger rules for debugging. To learn
// more about how to configure the DebugRuleConfiguration parameter, see [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job].
//
// [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job]: https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html
type DebugRuleConfiguration struct {

	// The name of the rule configuration. It must be unique relative to other rule
	// configuration names.
	//
	// This member is required.
	RuleConfigurationName *string

	// The Amazon Elastic Container (ECR) Image for the managed rule evaluation.
	//
	// This member is required.
	RuleEvaluatorImage *string

	// The instance type to deploy a custom rule for debugging a training job.
	InstanceType ProcessingInstanceType

	// Path to local storage location for output of rules. Defaults to
	// /opt/ml/processing/output/rule/ .
	LocalPath *string

	// Runtime configuration for rule container.
	RuleParameters map[string]string

	// Path to Amazon S3 storage location for rules.
	S3OutputPath *string

	// The size, in GB, of the ML storage volume attached to the processing instance.
	VolumeSizeInGB *int32

	noSmithyDocumentSerde
}

// Information about the status of the rule evaluation.
type DebugRuleEvaluationStatus struct {

	// Timestamp when the rule evaluation status was last modified.
	LastModifiedTime *time.Time

	// The name of the rule configuration.
	RuleConfigurationName *string

	// The Amazon Resource Name (ARN) of the rule evaluation job.
	RuleEvaluationJobArn *string

	// Status of the rule evaluation.
	RuleEvaluationStatus RuleEvaluationStatus

	// Details from the rule evaluation.
	StatusDetails *string

	noSmithyDocumentSerde
}

// A collection of default EBS storage settings that apply to spaces created
// within a domain or user profile.
type DefaultEbsStorageSettings struct {

	// The default size of the EBS storage volume for a space.
	//
	// This member is required.
	DefaultEbsVolumeSizeInGb *int32

	// The maximum size of the EBS storage volume for a space.
	//
	// This member is required.
	MaximumEbsVolumeSizeInGb *int32

	noSmithyDocumentSerde
}

// A collection of settings that apply to spaces created in the domain.
type DefaultSpaceSettings struct {

	// The settings for assigning a custom file system to a domain. Permitted users
	// can access this file system in Amazon SageMaker Studio.
	CustomFileSystemConfigs []CustomFileSystemConfig

	// Details about the POSIX identity that is used for file system operations.
	CustomPosixUserConfig *CustomPosixUserConfig

	// The ARN of the execution role for the space.
	ExecutionRole *string

	// The settings for the JupyterLab application.
	JupyterLabAppSettings *JupyterLabAppSettings

	// The JupyterServer app settings.
	JupyterServerAppSettings *JupyterServerAppSettings

	// The KernelGateway app settings.
	KernelGatewayAppSettings *KernelGatewayAppSettings

	// The security group IDs for the Amazon VPC that the space uses for communication.
	SecurityGroups []string

	// The default storage settings for a space.
	SpaceStorageSettings *DefaultSpaceStorageSettings

	noSmithyDocumentSerde
}

// The default storage settings for a space.
type DefaultSpaceStorageSettings struct {

	// The default EBS storage settings for a space.
	DefaultEbsStorageSettings *DefaultEbsStorageSettings

	noSmithyDocumentSerde
}

// Gets the Amazon EC2 Container Registry path of the docker image of the model
// that is hosted in this [ProductionVariant].
//
// If you used the registry/repository[:tag] form to specify the image path of the
// primary container when you created the model hosted in this ProductionVariant ,
// the path resolves to a path of the form registry/repository[@digest] . A digest
// is a hash value that identifies a specific version of an image. For information
// about Amazon ECR paths, see [Pulling an Image]in the Amazon ECR User Guide.
//
// [ProductionVariant]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ProductionVariant.html
// [Pulling an Image]: https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html
type DeployedImage struct {

	// The date and time when the image path for the model resolved to the
	// ResolvedImage
	ResolutionTime *time.Time

	// The specific digest path of the image hosted in this ProductionVariant .
	ResolvedImage *string

	// The image path you specified when you created the model.
	SpecifiedImage *string

	noSmithyDocumentSerde
}

// The deployment configuration for an endpoint, which contains the desired
// deployment strategy and rollback configurations.
type DeploymentConfig struct {

	// Automatic rollback configuration for handling endpoint deployment failures and
	// recovery.
	AutoRollbackConfiguration *AutoRollbackConfig

	// Update policy for a blue/green deployment. If this update policy is specified,
	// SageMaker creates a new fleet during the deployment while maintaining the old
	// fleet. SageMaker flips traffic to the new fleet according to the specified
	// traffic routing configuration. Only one update policy should be used in the
	// deployment configuration. If no update policy is specified, SageMaker uses a
	// blue/green deployment strategy with all at once traffic shifting by default.
	BlueGreenUpdatePolicy *BlueGreenUpdatePolicy

	// Specifies a rolling deployment strategy for updating a SageMaker endpoint.
	RollingUpdatePolicy *RollingUpdatePolicy

	noSmithyDocumentSerde
}

// A set of recommended deployment configurations for the model. To get more
// advanced recommendations, see [CreateInferenceRecommendationsJob]to create an inference recommendation job.
//
// [CreateInferenceRecommendationsJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceRecommendationsJob.html
type DeploymentRecommendation struct {

	// Status of the deployment recommendation. The status NOT_APPLICABLE means that
	// SageMaker is unable to provide a default recommendation for the model using the
	// information provided. If the deployment status is IN_PROGRESS , retry your API
	// call after a few seconds to get a COMPLETED deployment recommendation.
	//
	// This member is required.
	RecommendationStatus RecommendationStatus

	// A list of [RealTimeInferenceRecommendation] items.
	//
	// [RealTimeInferenceRecommendation]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_RealTimeInferenceRecommendation.html
	RealTimeInferenceRecommendations []RealTimeInferenceRecommendation

	noSmithyDocumentSerde
}

// Contains information about a stage in an edge deployment plan.
type DeploymentStage struct {

	// Configuration of the devices in the stage.
	//
	// This member is required.
	DeviceSelectionConfig *DeviceSelectionConfig

	// The name of the stage.
	//
	// This member is required.
	StageName *string

	// Configuration of the deployment details.
	DeploymentConfig *EdgeDeploymentConfig

	noSmithyDocumentSerde
}

// Contains information summarizing the deployment stage results.
type DeploymentStageStatusSummary struct {

	// Configuration of the deployment details.
	//
	// This member is required.
	DeploymentConfig *EdgeDeploymentConfig

	// General status of the current state.
	//
	// This member is required.
	DeploymentStatus *EdgeDeploymentStatus

	// Configuration of the devices in the stage.
	//
	// This member is required.
	DeviceSelectionConfig *DeviceSelectionConfig

	// The name of the stage.
	//
	// This member is required.
	StageName *string

	noSmithyDocumentSerde
}

// Information that SageMaker Neo automatically derived about the model.
type DerivedInformation struct {

	// The data input configuration that SageMaker Neo automatically derived for the
	// model. When SageMaker Neo derives this information, you don't need to specify
	// the data input configuration when you create a compilation job.
	DerivedDataInputConfig *string

	noSmithyDocumentSerde
}

// Specifies weight and capacity values for a production variant.
type DesiredWeightAndCapacity struct {

	// The name of the variant to update.
	//
	// This member is required.
	VariantName *string

	// The variant's capacity.
	DesiredInstanceCount *int32

	// The variant's weight.
	DesiredWeight *float32

	// Specifies the serverless update concurrency configuration for an endpoint
	// variant.
	ServerlessUpdateConfig *ProductionVariantServerlessUpdateConfig

	noSmithyDocumentSerde
}

// Information of a particular device.
type Device struct {

	// The name of the device.
	//
	// This member is required.
	DeviceName *string

	// Description of the device.
	Description *string

	// Amazon Web Services Internet of Things (IoT) object name.
	IotThingName *string

	noSmithyDocumentSerde
}

// Contains information summarizing device details and deployment status.
type DeviceDeploymentSummary struct {

	// The ARN of the device.
	//
	// This member is required.
	DeviceArn *string

	// The name of the device.
	//
	// This member is required.
	DeviceName *string

	// The ARN of the edge deployment plan.
	//
	// This member is required.
	EdgeDeploymentPlanArn *string

	// The name of the edge deployment plan.
	//
	// This member is required.
	EdgeDeploymentPlanName *string

	// The name of the stage in the edge deployment plan.
	//
	// This member is required.
	StageName *string

	// The name of the deployed stage.
	DeployedStageName *string

	// The time when the deployment on the device started.
	DeploymentStartTime *time.Time

	// The description of the device.
	Description *string

	// The deployment status of the device.
	DeviceDeploymentStatus DeviceDeploymentStatus

	// The detailed error message for the deployoment status result.
	DeviceDeploymentStatusMessage *string

	// The name of the fleet to which the device belongs to.
	DeviceFleetName *string

	noSmithyDocumentSerde
}

// Summary of the device fleet.
type DeviceFleetSummary struct {

	// Amazon Resource Name (ARN) of the device fleet.
	//
	// This member is required.
	DeviceFleetArn *string

	// Name of the device fleet.
	//
	// This member is required.
	DeviceFleetName *string

	// Timestamp of when the device fleet was created.
	CreationTime *time.Time

	// Timestamp of when the device fleet was last updated.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Contains information about the configurations of selected devices.
type DeviceSelectionConfig struct {

	// Type of device subsets to deploy to the current stage.
	//
	// This member is required.
	DeviceSubsetType DeviceSubsetType

	// A filter to select devices with names containing this name.
	DeviceNameContains *string

	// List of devices chosen to deploy.
	DeviceNames []string

	// Percentage of devices in the fleet to deploy to the current stage.
	Percentage *int32

	noSmithyDocumentSerde
}

// Status of devices.
type DeviceStats struct {

	// The number of devices connected with a heartbeat.
	//
	// This member is required.
	ConnectedDeviceCount *int64

	// The number of registered devices.
	//
	// This member is required.
	RegisteredDeviceCount *int64

	noSmithyDocumentSerde
}

// Summary of the device.
type DeviceSummary struct {

	// Amazon Resource Name (ARN) of the device.
	//
	// This member is required.
	DeviceArn *string

	// The unique identifier of the device.
	//
	// This member is required.
	DeviceName *string

	// Edge Manager agent version.
	AgentVersion *string

	// A description of the device.
	Description *string

	// The name of the fleet the device belongs to.
	DeviceFleetName *string

	// The Amazon Web Services Internet of Things (IoT) object thing name associated
	// with the device..
	IotThingName *string

	// The last heartbeat received from the device.
	LatestHeartbeat *time.Time

	// Models on the device.
	Models []EdgeModelSummary

	// The timestamp of the last registration or de-reregistration.
	RegistrationTime *time.Time

	noSmithyDocumentSerde
}

// The model deployment settings for the SageMaker Canvas application.
//
// In order to enable model deployment for Canvas, the SageMaker Domain's or user
// profile's Amazon Web Services IAM execution role must have the
// AmazonSageMakerCanvasDirectDeployAccess policy attached. You can also turn on
// model deployment permissions through the SageMaker Domain's or user profile's
// settings in the SageMaker console.
type DirectDeploySettings struct {

	// Describes whether model deployment permissions are enabled or disabled in the
	// Canvas application.
	Status FeatureStatus

	noSmithyDocumentSerde
}

// A collection of settings that configure the domain's Docker interaction.
type DockerSettings struct {

	// Indicates whether the domain can access Docker.
	EnableDockerAccess FeatureStatus

	// The list of Amazon Web Services accounts that are trusted when the domain is
	// created in VPC-only mode.
	VpcOnlyTrustedAccounts []string

	noSmithyDocumentSerde
}

// The domain's details.
type DomainDetails struct {

	// The creation time.
	CreationTime *time.Time

	// The domain's Amazon Resource Name (ARN).
	DomainArn *string

	// The domain ID.
	DomainId *string

	// The domain name.
	DomainName *string

	// The last modified time.
	LastModifiedTime *time.Time

	// The status.
	Status DomainStatus

	// The domain's URL.
	Url *string

	noSmithyDocumentSerde
}

// A collection of settings that apply to the SageMaker Domain . These settings are
// specified through the CreateDomain API call.
type DomainSettings struct {

	// A collection of settings that configure the domain's Docker interaction.
	DockerSettings *DockerSettings

	// The configuration for attaching a SageMaker user profile name to the execution
	// role as a [sts:SourceIdentity key].
	//
	// [sts:SourceIdentity key]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html
	ExecutionRoleIdentityConfig ExecutionRoleIdentityConfig

	// A collection of settings that configure the RStudioServerPro Domain-level app.
	RStudioServerProDomainSettings *RStudioServerProDomainSettings

	// The security groups for the Amazon Virtual Private Cloud that the Domain uses
	// for communication between Domain-level apps and user apps.
	SecurityGroupIds []string

	noSmithyDocumentSerde
}

// A collection of Domain configuration settings to update.
type DomainSettingsForUpdate struct {

	// A collection of settings that configure the domain's Docker interaction.
	DockerSettings *DockerSettings

	// The configuration for attaching a SageMaker user profile name to the execution
	// role as a [sts:SourceIdentity key]. This configuration can only be modified if there are no apps in the
	// InService or Pending state.
	//
	// [sts:SourceIdentity key]: https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html
	ExecutionRoleIdentityConfig ExecutionRoleIdentityConfig

	// A collection of RStudioServerPro Domain-level app settings to update. A single
	// RStudioServerPro application is created for a domain.
	RStudioServerProDomainSettingsForUpdate *RStudioServerProDomainSettingsForUpdate

	// The security groups for the Amazon Virtual Private Cloud that the Domain uses
	// for communication between Domain-level apps and user apps.
	SecurityGroupIds []string

	noSmithyDocumentSerde
}

// Represents the drift check baselines that can be used when the model monitor is
// set using the model package.
type DriftCheckBaselines struct {

	// Represents the drift check bias baselines that can be used when the model
	// monitor is set using the model package.
	Bias *DriftCheckBias

	// Represents the drift check explainability baselines that can be used when the
	// model monitor is set using the model package.
	Explainability *DriftCheckExplainability

	// Represents the drift check model data quality baselines that can be used when
	// the model monitor is set using the model package.
	ModelDataQuality *DriftCheckModelDataQuality

	// Represents the drift check model quality baselines that can be used when the
	// model monitor is set using the model package.
	ModelQuality *DriftCheckModelQuality

	noSmithyDocumentSerde
}

// Represents the drift check bias baselines that can be used when the model
// monitor is set using the model package.
type DriftCheckBias struct {

	// The bias config file for a model.
	ConfigFile *FileSource

	// The post-training constraints.
	PostTrainingConstraints *MetricsSource

	// The pre-training constraints.
	PreTrainingConstraints *MetricsSource

	noSmithyDocumentSerde
}

// Represents the drift check explainability baselines that can be used when the
// model monitor is set using the model package.
type DriftCheckExplainability struct {

	// The explainability config file for the model.
	ConfigFile *FileSource

	// The drift check explainability constraints.
	Constraints *MetricsSource

	noSmithyDocumentSerde
}

// Represents the drift check data quality baselines that can be used when the
// model monitor is set using the model package.
type DriftCheckModelDataQuality struct {

	// The drift check model data quality constraints.
	Constraints *MetricsSource

	// The drift check model data quality statistics.
	Statistics *MetricsSource

	noSmithyDocumentSerde
}

// Represents the drift check model quality baselines that can be used when the
// model monitor is set using the model package.
type DriftCheckModelQuality struct {

	// The drift check model quality constraints.
	Constraints *MetricsSource

	// The drift check model quality statistics.
	Statistics *MetricsSource

	noSmithyDocumentSerde
}

// An object with the recommended values for you to specify when creating an
// autoscaling policy.
type DynamicScalingConfiguration struct {

	// The recommended maximum capacity to specify for your autoscaling policy.
	MaxCapacity *int32

	// The recommended minimum capacity to specify for your autoscaling policy.
	MinCapacity *int32

	// The recommended scale in cooldown time for your autoscaling policy.
	ScaleInCooldown *int32

	// The recommended scale out cooldown time for your autoscaling policy.
	ScaleOutCooldown *int32

	// An object of the scaling policies for each metric.
	ScalingPolicies []ScalingPolicy

	noSmithyDocumentSerde
}

// A collection of EBS storage settings that apply to both private and shared
// spaces.
type EbsStorageSettings struct {

	// The size of an EBS storage volume for a space.
	//
	// This member is required.
	EbsVolumeSizeInGb *int32

	noSmithyDocumentSerde
}

// A directed edge connecting two lineage entities.
type Edge struct {

	// The type of the Association(Edge) between the source and destination. For
	// example ContributedTo , Produced , or DerivedFrom .
	AssociationType AssociationEdgeType

	// The Amazon Resource Name (ARN) of the destination lineage entity of the
	// directed edge.
	DestinationArn *string

	// The Amazon Resource Name (ARN) of the source lineage entity of the directed
	// edge.
	SourceArn *string

	noSmithyDocumentSerde
}

// Contains information about the configuration of a deployment.
type EdgeDeploymentConfig struct {

	// Toggle that determines whether to rollback to previous configuration if the
	// current deployment fails. By default this is turned on. You may turn this off if
	// you want to investigate the errors yourself.
	//
	// This member is required.
	FailureHandlingPolicy FailureHandlingPolicy

	noSmithyDocumentSerde
}

// Contains information about the configuration of a model in a deployment.
type EdgeDeploymentModelConfig struct {

	// The edge packaging job associated with this deployment.
	//
	// This member is required.
	EdgePackagingJobName *string

	// The name the device application uses to reference this model.
	//
	// This member is required.
	ModelHandle *string

	noSmithyDocumentSerde
}

// Contains information summarizing an edge deployment plan.
type EdgeDeploymentPlanSummary struct {

	// The name of the device fleet used for the deployment.
	//
	// This member is required.
	DeviceFleetName *string

	// The number of edge devices that failed the deployment.
	//
	// This member is required.
	EdgeDeploymentFailed *int32

	// The number of edge devices yet to pick up the deployment, or in progress.
	//
	// This member is required.
	EdgeDeploymentPending *int32

	// The ARN of the edge deployment plan.
	//
	// This member is required.
	EdgeDeploymentPlanArn *string

	// The name of the edge deployment plan.
	//
	// This member is required.
	EdgeDeploymentPlanName *string

	// The number of edge devices with the successful deployment.
	//
	// This member is required.
	EdgeDeploymentSuccess *int32

	// The time when the edge deployment plan was created.
	CreationTime *time.Time

	// The time when the edge deployment plan was last updated.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Contains information summarizing the deployment stage results.
type EdgeDeploymentStatus struct {

	// The number of edge devices that failed the deployment in current stage.
	//
	// This member is required.
	EdgeDeploymentFailedInStage *int32

	// The number of edge devices yet to pick up the deployment in current stage, or
	// in progress.
	//
	// This member is required.
	EdgeDeploymentPendingInStage *int32

	// The number of edge devices with the successful deployment in the current stage.
	//
	// This member is required.
	EdgeDeploymentSuccessInStage *int32

	// The general status of the current stage.
	//
	// This member is required.
	StageStatus StageStatus

	// The time when the deployment API started.
	EdgeDeploymentStageStartTime *time.Time

	// A detailed message about deployment status in current stage.
	EdgeDeploymentStatusMessage *string

	noSmithyDocumentSerde
}

// The model on the edge device.
type EdgeModel struct {

	// The name of the model.
	//
	// This member is required.
	ModelName *string

	// The model version.
	//
	// This member is required.
	ModelVersion *string

	// The timestamp of the last inference that was made.
	LatestInference *time.Time

	// The timestamp of the last data sample taken.
	LatestSampleTime *time.Time

	noSmithyDocumentSerde
}

// Status of edge devices with this model.
type EdgeModelStat struct {

	// The number of devices that have this model version, a heart beat, and are
	// currently running.
	//
	// This member is required.
	ActiveDeviceCount *int64

	// The number of devices that have this model version and have a heart beat.
	//
	// This member is required.
	ConnectedDeviceCount *int64

	// The name of the model.
	//
	// This member is required.
	ModelName *string

	// The model version.
	//
	// This member is required.
	ModelVersion *string

	// The number of devices that have this model version and do not have a heart beat.
	//
	// This member is required.
	OfflineDeviceCount *int64

	// The number of devices with this model version and are producing sample data.
	//
	// This member is required.
	SamplingDeviceCount *int64

	noSmithyDocumentSerde
}

// Summary of model on edge device.
type EdgeModelSummary struct {

	// The name of the model.
	//
	// This member is required.
	ModelName *string

	// The version model.
	//
	// This member is required.
	ModelVersion *string

	noSmithyDocumentSerde
}

// The output configuration.
type EdgeOutputConfig struct {

	// The Amazon Simple Storage (S3) bucker URI.
	//
	// This member is required.
	S3OutputLocation *string

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt data on the storage volume after
	// compilation job. If you don't provide a KMS key ID, Amazon SageMaker uses the
	// default KMS key for Amazon S3 for your role's account.
	KmsKeyId *string

	// The configuration used to create deployment artifacts. Specify configuration
	// options with a JSON string. The available configuration options for each type
	// are:
	//
	//   - ComponentName (optional) - Name of the GreenGrass V2 component. If not
	//   specified, the default name generated consists of "SagemakerEdgeManager" and the
	//   name of your SageMaker Edge Manager packaging job.
	//
	//   - ComponentDescription (optional) - Description of the component.
	//
	//   - ComponentVersion (optional) - The version of the component.
	//
	// Amazon Web Services IoT Greengrass uses semantic versions for components.
	//   Semantic versions follow a major.minor.patch number system. For example, version
	//   1.0.0 represents the first major release for a component. For more information,
	//   see the [semantic version specification].
	//
	//   - PlatformOS (optional) - The name of the operating system for the platform.
	//   Supported platforms include Windows and Linux.
	//
	//   - PlatformArchitecture (optional) - The processor architecture for the
	//   platform.
	//
	// Supported architectures Windows include: Windows32_x86, Windows64_x64.
	//
	// Supported architectures for Linux include: Linux x86_64, Linux ARMV8.
	//
	// [semantic version specification]: https://semver.org/
	PresetDeploymentConfig *string

	// The deployment type SageMaker Edge Manager will create. Currently only supports
	// Amazon Web Services IoT Greengrass Version 2 components.
	PresetDeploymentType EdgePresetDeploymentType

	noSmithyDocumentSerde
}

// Summary of edge packaging job.
type EdgePackagingJobSummary struct {

	// The Amazon Resource Name (ARN) of the edge packaging job.
	//
	// This member is required.
	EdgePackagingJobArn *string

	// The name of the edge packaging job.
	//
	// This member is required.
	EdgePackagingJobName *string

	// The status of the edge packaging job.
	//
	// This member is required.
	EdgePackagingJobStatus EdgePackagingJobStatus

	// The name of the SageMaker Neo compilation job.
	CompilationJobName *string

	// The timestamp of when the job was created.
	CreationTime *time.Time

	// The timestamp of when the edge packaging job was last updated.
	LastModifiedTime *time.Time

	// The name of the model.
	ModelName *string

	// The version of the model.
	ModelVersion *string

	noSmithyDocumentSerde
}

// The output of a SageMaker Edge Manager deployable resource.
type EdgePresetDeploymentOutput struct {

	// The deployment type created by SageMaker Edge Manager. Currently only supports
	// Amazon Web Services IoT Greengrass Version 2 components.
	//
	// This member is required.
	Type EdgePresetDeploymentType

	// The Amazon Resource Name (ARN) of the generated deployable resource.
	Artifact *string

	// The status of the deployable resource.
	Status EdgePresetDeploymentStatus

	// Returns a message describing the status of the deployed resource.
	StatusMessage *string

	noSmithyDocumentSerde
}

// A file system, created by you in Amazon EFS, that you assign to a user profile
// or space for an Amazon SageMaker Domain. Permitted users can access this file
// system in Amazon SageMaker Studio.
type EFSFileSystem struct {

	// The ID of your Amazon EFS file system.
	//
	// This member is required.
	FileSystemId *string

	noSmithyDocumentSerde
}

// The settings for assigning a custom Amazon EFS file system to a user profile or
// space for an Amazon SageMaker Domain.
type EFSFileSystemConfig struct {

	// The ID of your Amazon EFS file system.
	//
	// This member is required.
	FileSystemId *string

	// The path to the file system directory that is accessible in Amazon SageMaker
	// Studio. Permitted users can access only this directory and below.
	FileSystemPath *string

	noSmithyDocumentSerde
}

// The configurations and outcomes of an Amazon EMR step execution.
type EMRStepMetadata struct {

	// The identifier of the EMR cluster.
	ClusterId *string

	// The path to the log file where the cluster step's failure root cause is
	// recorded.
	LogFilePath *string

	// The identifier of the EMR cluster step.
	StepId *string

	// The name of the EMR cluster step.
	StepName *string

	noSmithyDocumentSerde
}

// A hosted endpoint for real-time inference.
type Endpoint struct {

	// The time that the endpoint was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// This member is required.
	EndpointArn *string

	// The endpoint configuration associated with the endpoint.
	//
	// This member is required.
	EndpointConfigName *string

	// The name of the endpoint.
	//
	// This member is required.
	EndpointName *string

	// The status of the endpoint.
	//
	// This member is required.
	EndpointStatus EndpointStatus

	// The last time the endpoint was modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The currently active data capture configuration used by your Endpoint.
	DataCaptureConfig *DataCaptureConfigSummary

	// If the endpoint failed, the reason it failed.
	FailureReason *string

	// A list of monitoring schedules for the endpoint. For information about model
	// monitoring, see [Amazon SageMaker Model Monitor].
	//
	// [Amazon SageMaker Model Monitor]: https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html
	MonitoringSchedules []MonitoringSchedule

	// A list of the production variants hosted on the endpoint. Each production
	// variant is a model.
	ProductionVariants []ProductionVariantSummary

	// A list of the shadow variants hosted on the endpoint. Each shadow variant is a
	// model in shadow mode with production traffic replicated from the production
	// variant.
	ShadowProductionVariants []ProductionVariantSummary

	// A list of the tags associated with the endpoint. For more information, see [Tagging Amazon Web Services resources] in
	// the Amazon Web Services General Reference Guide.
	//
	// [Tagging Amazon Web Services resources]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
	Tags []Tag

	noSmithyDocumentSerde
}

// Provides summary information for an endpoint configuration.
type EndpointConfigSummary struct {

	// A timestamp that shows when the endpoint configuration was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the endpoint configuration.
	//
	// This member is required.
	EndpointConfigArn *string

	// The name of the endpoint configuration.
	//
	// This member is required.
	EndpointConfigName *string

	noSmithyDocumentSerde
}

// Details about a customer endpoint that was compared in an Inference Recommender
// job.
type EndpointInfo struct {

	// The name of a customer's endpoint.
	EndpointName *string

	noSmithyDocumentSerde
}

// Input object for the endpoint
type EndpointInput struct {

	// An endpoint in customer's account which has enabled DataCaptureConfig enabled.
	//
	// This member is required.
	EndpointName *string

	// Path to the filesystem where the endpoint data is available to the container.
	//
	// This member is required.
	LocalPath *string

	// If specified, monitoring jobs substract this time from the end time. For
	// information about using offsets for scheduling monitoring jobs, see [Schedule Model Quality Monitoring Jobs].
	//
	// [Schedule Model Quality Monitoring Jobs]: https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html
	EndTimeOffset *string

	// The attributes of the input data to exclude from the analysis.
	ExcludeFeaturesAttribute *string

	// The attributes of the input data that are the input features.
	FeaturesAttribute *string

	// The attribute of the input data that represents the ground truth label.
	InferenceAttribute *string

	// In a classification problem, the attribute that represents the class
	// probability.
	ProbabilityAttribute *string

	// The threshold for the class probability to be evaluated as a positive result.
	ProbabilityThresholdAttribute *float64

	// Whether input data distributed in Amazon S3 is fully replicated or sharded by
	// an Amazon S3 key. Defaults to FullyReplicated
	S3DataDistributionType ProcessingS3DataDistributionType

	// Whether the Pipe or File is used as the input mode for transferring data for
	// the monitoring job. Pipe mode is recommended for large datasets. File mode is
	// useful for small files that fit in memory. Defaults to File .
	S3InputMode ProcessingS3InputMode

	// If specified, monitoring jobs substract this time from the start time. For
	// information about using offsets for scheduling monitoring jobs, see [Schedule Model Quality Monitoring Jobs].
	//
	// [Schedule Model Quality Monitoring Jobs]: https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor-model-quality-schedule.html
	StartTimeOffset *string

	noSmithyDocumentSerde
}

// The endpoint configuration for the load test.
type EndpointInputConfiguration struct {

	//  The parameter you want to benchmark against.
	EnvironmentParameterRanges *EnvironmentParameterRanges

	// The inference specification name in the model package version.
	InferenceSpecificationName *string

	// The instance types to use for the load test.
	InstanceType ProductionVariantInstanceType

	// Specifies the serverless configuration for an endpoint variant.
	ServerlessConfig *ProductionVariantServerlessConfig

	noSmithyDocumentSerde
}

// The metadata of the endpoint.
type EndpointMetadata struct {

	// The name of the endpoint.
	//
	// This member is required.
	EndpointName *string

	// The name of the endpoint configuration.
	EndpointConfigName *string

	//  The status of the endpoint. For possible values of the status of an endpoint,
	// see [EndpointSummary].
	//
	// [EndpointSummary]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_EndpointSummary.html
	EndpointStatus EndpointStatus

	//  If the status of the endpoint is Failed , or the status is InService but
	// update operation fails, this provides the reason why it failed.
	FailureReason *string

	noSmithyDocumentSerde
}

// The endpoint configuration made by Inference Recommender during a
// recommendation job.
type EndpointOutputConfiguration struct {

	// The name of the endpoint made during a recommendation job.
	//
	// This member is required.
	EndpointName *string

	// The name of the production variant (deployed model) made during a
	// recommendation job.
	//
	// This member is required.
	VariantName *string

	// The number of instances recommended to launch initially.
	InitialInstanceCount *int32

	// The instance type recommended by Amazon SageMaker Inference Recommender.
	InstanceType ProductionVariantInstanceType

	// Specifies the serverless configuration for an endpoint variant.
	ServerlessConfig *ProductionVariantServerlessConfig

	noSmithyDocumentSerde
}

// The performance results from running an Inference Recommender job on an
// existing endpoint.
type EndpointPerformance struct {

	// Details about a customer endpoint that was compared in an Inference Recommender
	// job.
	//
	// This member is required.
	EndpointInfo *EndpointInfo

	// The metrics for an existing endpoint.
	//
	// This member is required.
	Metrics *InferenceMetrics

	noSmithyDocumentSerde
}

// Provides summary information for an endpoint.
type EndpointSummary struct {

	// A timestamp that shows when the endpoint was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// This member is required.
	EndpointArn *string

	// The name of the endpoint.
	//
	// This member is required.
	EndpointName *string

	// The status of the endpoint.
	//
	//   - OutOfService : Endpoint is not available to take incoming requests.
	//
	//   - Creating : [CreateEndpoint]is executing.
	//
	//   - Updating : [UpdateEndpoint]or [UpdateEndpointWeightsAndCapacities]is executing.
	//
	//   - SystemUpdating : Endpoint is undergoing maintenance and cannot be updated or
	//   deleted or re-scaled until it has completed. This maintenance operation does not
	//   change any customer-specified values such as VPC config, KMS encryption, model,
	//   instance type, or instance count.
	//
	//   - RollingBack : Endpoint fails to scale up or down or change its variant
	//   weight and is in the process of rolling back to its previous configuration. Once
	//   the rollback completes, endpoint returns to an InService status. This
	//   transitional status only applies to an endpoint that has autoscaling enabled and
	//   is undergoing variant weight or capacity changes as part of an [UpdateEndpointWeightsAndCapacities]call or when
	//   the [UpdateEndpointWeightsAndCapacities]operation is called explicitly.
	//
	//   - InService : Endpoint is available to process incoming requests.
	//
	//   - Deleting : [DeleteEndpoint]is executing.
	//
	//   - Failed : Endpoint could not be created, updated, or re-scaled. Use
	//   DescribeEndpointOutput$FailureReason for information about the failure. [DeleteEndpoint]is
	//   the only operation that can be performed on a failed endpoint.
	//
	// To get a list of endpoints with a specified status, use the StatusEquals filter
	// with a call to [ListEndpoints].
	//
	// [UpdateEndpoint]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpoint.html
	// [ListEndpoints]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListEndpoints.html
	// [UpdateEndpointWeightsAndCapacities]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpointWeightsAndCapacities.html
	// [CreateEndpoint]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html
	// [DeleteEndpoint]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteEndpoint.html
	//
	// This member is required.
	EndpointStatus EndpointStatus

	// A timestamp that shows when the endpoint was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// A list of environment parameters suggested by the Amazon SageMaker Inference
// Recommender.
type EnvironmentParameter struct {

	// The environment key suggested by the Amazon SageMaker Inference Recommender.
	//
	// This member is required.
	Key *string

	// The value suggested by the Amazon SageMaker Inference Recommender.
	//
	// This member is required.
	Value *string

	// The value type suggested by the Amazon SageMaker Inference Recommender.
	//
	// This member is required.
	ValueType *string

	noSmithyDocumentSerde
}

// Specifies the range of environment parameters
type EnvironmentParameterRanges struct {

	// Specified a list of parameters for each category.
	CategoricalParameterRanges []CategoricalParameter

	noSmithyDocumentSerde
}

// The properties of an experiment as returned by the [Search] API.
//
// [Search]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html
type Experiment struct {

	// Who created the experiment.
	CreatedBy *UserContext

	// When the experiment was created.
	CreationTime *time.Time

	// The description of the experiment.
	Description *string

	// The name of the experiment as displayed. If DisplayName isn't specified,
	// ExperimentName is displayed.
	DisplayName *string

	// The Amazon Resource Name (ARN) of the experiment.
	ExperimentArn *string

	// The name of the experiment.
	ExperimentName *string

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	LastModifiedBy *UserContext

	// When the experiment was last modified.
	LastModifiedTime *time.Time

	// The source of the experiment.
	Source *ExperimentSource

	// The list of tags that are associated with the experiment. You can use [Search] API to
	// search on the tags.
	//
	// [Search]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html
	Tags []Tag

	noSmithyDocumentSerde
}

// Associates a SageMaker job as a trial component with an experiment and trial.
// Specified when you call the following APIs:
//
// [CreateProcessingJob]
//
// [CreateTrainingJob]
//
// [CreateTransformJob]
//
// [CreateTransformJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTransformJob.html
// [CreateTrainingJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html
// [CreateProcessingJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html
type ExperimentConfig struct {

	// The name of an existing experiment to associate with the trial component.
	ExperimentName *string

	// The name of the experiment run to associate with the trial component.
	RunName *string

	// The display name for the trial component. If this key isn't specified, the
	// display name is the trial component name.
	TrialComponentDisplayName *string

	// The name of an existing trial to associate the trial component with. If not
	// specified, a new trial is created.
	TrialName *string

	noSmithyDocumentSerde
}

// The source of the experiment.
type ExperimentSource struct {

	// The Amazon Resource Name (ARN) of the source.
	//
	// This member is required.
	SourceArn *string

	// The source type.
	SourceType *string

	noSmithyDocumentSerde
}

// A summary of the properties of an experiment. To get the complete set of
// properties, call the [DescribeExperiment]API and provide the ExperimentName .
//
// [DescribeExperiment]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeExperiment.html
type ExperimentSummary struct {

	// When the experiment was created.
	CreationTime *time.Time

	// The name of the experiment as displayed. If DisplayName isn't specified,
	// ExperimentName is displayed.
	DisplayName *string

	// The Amazon Resource Name (ARN) of the experiment.
	ExperimentArn *string

	// The name of the experiment.
	ExperimentName *string

	// The source of the experiment.
	ExperimentSource *ExperimentSource

	// When the experiment was last modified.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Contains explainability metrics for a model.
type Explainability struct {

	// The explainability report for a model.
	Report *MetricsSource

	noSmithyDocumentSerde
}

// A parameter to activate explainers.
type ExplainerConfig struct {

	// A member of ExplainerConfig that contains configuration parameters for the
	// SageMaker Clarify explainer.
	ClarifyExplainerConfig *ClarifyExplainerConfig

	noSmithyDocumentSerde
}

// The container for the metadata for Fail step.
type FailStepMetadata struct {

	// A message that you define and then is processed and rendered by the Fail step
	// when the error occurs.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// A list of features. You must include FeatureName and FeatureType . Valid feature
// FeatureType s are Integral , Fractional and String .
type FeatureDefinition struct {

	// The name of a feature. The type must be a string. FeatureName cannot be any of
	// the following: is_deleted , write_time , api_invocation_time .
	//
	// The name:
	//
	//   - Must start with an alphanumeric character.
	//
	//   - Can only include alphanumeric characters, underscores, and hyphens. Spaces
	//   are not allowed.
	//
	// This member is required.
	FeatureName *string

	// The value type of a feature. Valid values are Integral, Fractional, or String.
	//
	// This member is required.
	FeatureType FeatureType

	// Configuration for your collection.
	CollectionConfig CollectionConfig

	// A grouping of elements where each element within the collection must have the
	// same feature type ( String , Integral , or Fractional ).
	//
	//   - List : An ordered collection of elements.
	//
	//   - Set : An unordered collection of unique elements.
	//
	//   - Vector : A specialized list that represents a fixed-size array of elements.
	//   The vector dimension is determined by you. Must have elements with fractional
	//   feature types.
	CollectionType CollectionType

	noSmithyDocumentSerde
}

// Amazon SageMaker Feature Store stores features in a collection called Feature
// Group. A Feature Group can be visualized as a table which has rows, with a
// unique identifier for each row where each column in the table is a feature. In
// principle, a Feature Group is composed of features and values per features.
type FeatureGroup struct {

	// The time a FeatureGroup was created.
	CreationTime *time.Time

	// A free form description of a FeatureGroup .
	Description *string

	// The name of the feature that stores the EventTime of a Record in a FeatureGroup .
	//
	// A EventTime is point in time when a new event occurs that corresponds to the
	// creation or update of a Record in FeatureGroup . All Records in the FeatureGroup
	// must have a corresponding EventTime .
	EventTimeFeatureName *string

	// The reason that the FeatureGroup failed to be replicated in the OfflineStore .
	// This is failure may be due to a failure to create a FeatureGroup in or delete a
	// FeatureGroup from the OfflineStore .
	FailureReason *string

	// A list of Feature s. Each Feature must include a FeatureName and a FeatureType .
	//
	// Valid FeatureType s are Integral , Fractional and String .
	//
	// FeatureName s cannot be any of the following: is_deleted , write_time ,
	// api_invocation_time .
	//
	// You can create up to 2,500 FeatureDefinition s per FeatureGroup .
	FeatureDefinitions []FeatureDefinition

	// The Amazon Resource Name (ARN) of a FeatureGroup .
	FeatureGroupArn *string

	// The name of the FeatureGroup .
	FeatureGroupName *string

	// A FeatureGroup status.
	FeatureGroupStatus FeatureGroupStatus

	// A timestamp indicating the last time you updated the feature group.
	LastModifiedTime *time.Time

	// A value that indicates whether the feature group was updated successfully.
	LastUpdateStatus *LastUpdateStatus

	// The configuration of an OfflineStore .
	//
	// Provide an OfflineStoreConfig in a request to CreateFeatureGroup to create an
	// OfflineStore .
	//
	// To encrypt an OfflineStore using at rest data encryption, specify Amazon Web
	// Services Key Management Service (KMS) key ID, or KMSKeyId , in S3StorageConfig .
	OfflineStoreConfig *OfflineStoreConfig

	// The status of OfflineStore .
	OfflineStoreStatus *OfflineStoreStatus

	// Use this to specify the Amazon Web Services Key Management Service (KMS) Key
	// ID, or KMSKeyId , for at rest data encryption. You can turn OnlineStore on or
	// off by specifying the EnableOnlineStore flag at General Assembly.
	//
	// The default value is False .
	OnlineStoreConfig *OnlineStoreConfig

	// The name of the Feature whose value uniquely identifies a Record defined in the
	// FeatureGroup FeatureDefinitions .
	RecordIdentifierFeatureName *string

	// The Amazon Resource Name (ARN) of the IAM execution role used to create the
	// feature group.
	RoleArn *string

	// Tags used to define a FeatureGroup .
	Tags []Tag

	noSmithyDocumentSerde
}

// The name, ARN, CreationTime , FeatureGroup values, LastUpdatedTime and
// EnableOnlineStorage status of a FeatureGroup .
type FeatureGroupSummary struct {

	// A timestamp indicating the time of creation time of the FeatureGroup .
	//
	// This member is required.
	CreationTime *time.Time

	// Unique identifier for the FeatureGroup .
	//
	// This member is required.
	FeatureGroupArn *string

	// The name of FeatureGroup .
	//
	// This member is required.
	FeatureGroupName *string

	// The status of a FeatureGroup. The status can be any of the following: Creating ,
	// Created , CreateFail , Deleting or DetailFail .
	FeatureGroupStatus FeatureGroupStatus

	// Notifies you if replicating data into the OfflineStore has failed. Returns
	// either: Active or Blocked .
	OfflineStoreStatus *OfflineStoreStatus

	noSmithyDocumentSerde
}

// The metadata for a feature. It can either be metadata that you specify, or
// metadata that is updated automatically.
type FeatureMetadata struct {

	// A timestamp indicating when the feature was created.
	CreationTime *time.Time

	// An optional description that you specify to better describe the feature.
	Description *string

	// The Amazon Resource Number (ARN) of the feature group.
	FeatureGroupArn *string

	// The name of the feature group containing the feature.
	FeatureGroupName *string

	// The name of feature.
	FeatureName *string

	// The data type of the feature.
	FeatureType FeatureType

	// A timestamp indicating when the feature was last modified.
	LastModifiedTime *time.Time

	// Optional key-value pairs that you specify to better describe the feature.
	Parameters []FeatureParameter

	noSmithyDocumentSerde
}

// A key-value pair that you specify to describe the feature.
type FeatureParameter struct {

	// A key that must contain a value to describe the feature.
	Key *string

	// The value that belongs to a key.
	Value *string

	noSmithyDocumentSerde
}

// Contains details regarding the file source.
type FileSource struct {

	// The Amazon S3 URI for the file source.
	//
	// This member is required.
	S3Uri *string

	// The digest of the file source.
	ContentDigest *string

	// The type of content stored in the file source.
	ContentType *string

	noSmithyDocumentSerde
}

// The Amazon Elastic File System storage configuration for a SageMaker image.
type FileSystemConfig struct {

	// The default POSIX group ID (GID). If not specified, defaults to 100 .
	DefaultGid *int32

	// The default POSIX user ID (UID). If not specified, defaults to 1000 .
	DefaultUid *int32

	// The path within the image to mount the user's EFS home directory. The directory
	// should be empty. If not specified, defaults to /home/sagemaker-user.
	MountPath *string

	noSmithyDocumentSerde
}

// Specifies a file system data source for a channel.
type FileSystemDataSource struct {

	// The full path to the directory to associate with the channel.
	//
	// This member is required.
	DirectoryPath *string

	// The access mode of the mount of the directory associated with the channel. A
	// directory can be mounted either in ro (read-only) or rw (read-write) mode.
	//
	// This member is required.
	FileSystemAccessMode FileSystemAccessMode

	// The file system id.
	//
	// This member is required.
	FileSystemId *string

	// The file system type.
	//
	// This member is required.
	FileSystemType FileSystemType

	noSmithyDocumentSerde
}

// A conditional statement for a search expression that includes a resource
// property, a Boolean operator, and a value. Resources that match the statement
// are returned in the results from the [Search]API.
//
// If you specify a Value , but not an Operator , SageMaker uses the equals
// operator.
//
// In search, there are several property types:
//
// Metrics To define a metric filter, enter a value using the form "Metrics." ,
// where is a metric name. For example, the following filter searches for training
// jobs with an "accuracy" metric greater than "0.9" :
//
//	{
//
//	"Name": "Metrics.accuracy",
//
//	"Operator": "GreaterThan",
//
//	"Value": "0.9"
//
// }
//
// HyperParameters To define a hyperparameter filter, enter a value with the form
// "HyperParameters." . Decimal hyperparameter values are treated as a decimal in a
// comparison if the specified Value is also a decimal value. If the specified
// Value is an integer, the decimal hyperparameter values are treated as integers.
// For example, the following filter is satisfied by training jobs with a
// "learning_rate" hyperparameter that is less than "0.5" :
//
//	{
//
//	"Name": "HyperParameters.learning_rate",
//
//	"Operator": "LessThan",
//
//	"Value": "0.5"
//
// }
//
// Tags To define a tag filter, enter a value with the form Tags. .
//
// [Search]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html
type Filter struct {

	// A resource property name. For example, TrainingJobName . For valid property
	// names, see [SearchRecord]. You must specify a valid property for the resource.
	//
	// [SearchRecord]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SearchRecord.html
	//
	// This member is required.
	Name *string

	// A Boolean binary operator that is used to evaluate the filter. The operator
	// field contains one of the following values:
	//
	// Equals The value of Name equals Value .
	//
	// NotEquals The value of Name doesn't equal Value .
	//
	// Exists The Name property exists.
	//
	// NotExists The Name property does not exist.
	//
	// GreaterThan The value of Name is greater than Value . Not supported for text
	// properties.
	//
	// GreaterThanOrEqualTo The value of Name is greater than or equal to Value . Not
	// supported for text properties.
	//
	// LessThan The value of Name is less than Value . Not supported for text
	// properties.
	//
	// LessThanOrEqualTo The value of Name is less than or equal to Value . Not
	// supported for text properties.
	//
	// In The value of Name is one of the comma delimited strings in Value . Only
	// supported for text properties.
	//
	// Contains The value of Name contains the string Value . Only supported for text
	// properties.
	//
	// A SearchExpression can include the Contains operator multiple times when the
	// value of Name is one of the following:
	//
	//   - Experiment.DisplayName
	//
	//   - Experiment.ExperimentName
	//
	//   - Experiment.Tags
	//
	//   - Trial.DisplayName
	//
	//   - Trial.TrialName
	//
	//   - Trial.Tags
	//
	//   - TrialComponent.DisplayName
	//
	//   - TrialComponent.TrialComponentName
	//
	//   - TrialComponent.Tags
	//
	//   - TrialComponent.InputArtifacts
	//
	//   - TrialComponent.OutputArtifacts
	//
	// A SearchExpression can include only one Contains operator for all other values
	// of Name . In these cases, if you include multiple Contains operators in the
	// SearchExpression , the result is the following error message: " 'CONTAINS'
	// operator usage limit of 1 exceeded. "
	Operator Operator

	// A value used with Name and Operator to determine which resources satisfy the
	// filter's condition. For numerical properties, Value must be an integer or
	// floating-point decimal. For timestamp properties, Value must be an ISO 8601
	// date-time string of the following format: YYYY-mm-dd'T'HH:MM:SS .
	Value *string

	noSmithyDocumentSerde
}

// The best candidate result from an AutoML training job.
type FinalAutoMLJobObjectiveMetric struct {

	// The name of the metric with the best result. For a description of the possible
	// objective metrics, see [AutoMLJobObjective$MetricName].
	//
	// [AutoMLJobObjective$MetricName]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLJobObjective.html
	//
	// This member is required.
	MetricName AutoMLMetricEnum

	// The value of the metric with the best result.
	//
	// This member is required.
	Value *float32

	// The name of the standard metric. For a description of the standard metrics, see [Autopilot candidate metrics]
	// .
	//
	// [Autopilot candidate metrics]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-metrics-validation.html#autopilot-metrics
	StandardMetricName AutoMLMetricEnum

	// The type of metric with the best result.
	Type AutoMLJobObjectiveType

	noSmithyDocumentSerde
}

// Shows the latest objective metric emitted by a training job that was launched
// by a hyperparameter tuning job. You define the objective metric in the
// HyperParameterTuningJobObjective parameter of [HyperParameterTuningJobConfig].
//
// [HyperParameterTuningJobConfig]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobConfig.html
type FinalHyperParameterTuningJobObjectiveMetric struct {

	// The name of the objective metric. For SageMaker built-in algorithms, metrics
	// are defined per algorithm. See the [metrics for XGBoost]as an example. You can also use a custom
	// algorithm for training and define your own metrics. For more information, see [Define metrics and environment variables].
	//
	// [metrics for XGBoost]: https://docs.aws.amazon.com/sagemaker/latest/dg/xgboost-tuning.html
	// [Define metrics and environment variables]: https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html
	//
	// This member is required.
	MetricName *string

	// The value of the objective metric.
	//
	// This member is required.
	Value *float32

	// Select if you want to minimize or maximize the objective metric during
	// hyperparameter tuning.
	Type HyperParameterTuningJobObjectiveType

	noSmithyDocumentSerde
}

// Contains information about where human output will be stored.
type FlowDefinitionOutputConfig struct {

	// The Amazon S3 path where the object containing human output will be made
	// available.
	//
	// To learn more about the format of Amazon A2I output data, see [Amazon A2I Output Data].
	//
	// [Amazon A2I Output Data]: https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-output-data.html
	//
	// This member is required.
	S3OutputPath *string

	// The Amazon Key Management Service (KMS) key ID for server-side encryption.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Contains summary information about the flow definition.
type FlowDefinitionSummary struct {

	// The timestamp when SageMaker created the flow definition.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the flow definition.
	//
	// This member is required.
	FlowDefinitionArn *string

	// The name of the flow definition.
	//
	// This member is required.
	FlowDefinitionName *string

	// The status of the flow definition. Valid values:
	//
	// This member is required.
	FlowDefinitionStatus FlowDefinitionStatus

	// The reason why the flow definition creation failed. A failure reason is
	// returned only when the flow definition status is Failed .
	FailureReason *string

	noSmithyDocumentSerde
}

// The generative AI settings for the SageMaker Canvas application.
//
// Configure these settings for Canvas users starting chats with generative AI
// foundation models. For more information, see [Use generative AI with foundation models].
//
// [Use generative AI with foundation models]: https://docs.aws.amazon.com/sagemaker/latest/dg/canvas-fm-chat.html
type GenerativeAiSettings struct {

	// The ARN of an Amazon Web Services IAM role that allows fine-tuning of large
	// language models (LLMs) in Amazon Bedrock. The IAM role should have Amazon S3
	// read and write permissions, as well as a trust relationship that establishes
	// bedrock.amazonaws.com as a service principal.
	AmazonBedrockRoleArn *string

	noSmithyDocumentSerde
}

// Specifies configuration details for a Git repository in your Amazon Web
// Services account.
type GitConfig struct {

	// The URL where the Git repository is located.
	//
	// This member is required.
	RepositoryUrl *string

	// The default branch for the Git repository.
	Branch *string

	// The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager
	// secret that contains the credentials used to access the git repository. The
	// secret must have a staging label of AWSCURRENT and must be in the following
	// format:
	//
	//     {"username": UserName, "password": Password}
	SecretArn *string

	noSmithyDocumentSerde
}

// Specifies configuration details for a Git repository when the repository is
// updated.
type GitConfigForUpdate struct {

	// The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager
	// secret that contains the credentials used to access the git repository. The
	// secret must have a staging label of AWSCURRENT and must be in the following
	// format:
	//
	//     {"username": UserName, "password": Password}
	SecretArn *string

	noSmithyDocumentSerde
}

// Stores the holiday featurization attributes applicable to each item of
// time-series datasets during the training of a forecasting model. This allows the
// model to identify patterns associated with specific holidays.
type HolidayConfigAttributes struct {

	// The country code for the holiday calendar.
	//
	// For the list of public holiday calendars supported by AutoML job V2, see [Country Codes]. Use
	// the country code corresponding to the country of your choice.
	//
	// [Country Codes]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-timeseries-forecasting-holiday-calendars.html#holiday-country-codes
	CountryCode *string

	noSmithyDocumentSerde
}

// Any dependencies related to hub content, such as scripts, model artifacts,
// datasets, or notebooks.
type HubContentDependency struct {

	// The hub content dependency copy path.
	DependencyCopyPath *string

	// The hub content dependency origin path.
	DependencyOriginPath *string

	noSmithyDocumentSerde
}

// Information about hub content.
type HubContentInfo struct {

	// The date and time that the hub content was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The version of the hub content document schema.
	//
	// This member is required.
	DocumentSchemaVersion *string

	// The Amazon Resource Name (ARN) of the hub content.
	//
	// This member is required.
	HubContentArn *string

	// The name of the hub content.
	//
	// This member is required.
	HubContentName *string

	// The status of the hub content.
	//
	// This member is required.
	HubContentStatus HubContentStatus

	// The type of hub content.
	//
	// This member is required.
	HubContentType HubContentType

	// The version of the hub content.
	//
	// This member is required.
	HubContentVersion *string

	// A description of the hub content.
	HubContentDescription *string

	// The display name of the hub content.
	HubContentDisplayName *string

	// The searchable keywords for the hub content.
	HubContentSearchKeywords []string

	noSmithyDocumentSerde
}

// Information about a hub.
type HubInfo struct {

	// The date and time that the hub was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the hub.
	//
	// This member is required.
	HubArn *string

	// The name of the hub.
	//
	// This member is required.
	HubName *string

	// The status of the hub.
	//
	// This member is required.
	HubStatus HubStatus

	// The date and time that the hub was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// A description of the hub.
	HubDescription *string

	// The display name of the hub.
	HubDisplayName *string

	// The searchable keywords for the hub.
	HubSearchKeywords []string

	noSmithyDocumentSerde
}

// The Amazon S3 storage configuration of a hub.
type HubS3StorageConfig struct {

	// The Amazon S3 bucket prefix for hosting hub content.
	S3OutputPath *string

	noSmithyDocumentSerde
}

// Defines under what conditions SageMaker creates a human loop. Used within [CreateFlowDefinition]. See [HumanLoopActivationConditionsConfig]
// for the required format of activation conditions.
//
// [CreateFlowDefinition]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateFlowDefinition.html
// [HumanLoopActivationConditionsConfig]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HumanLoopActivationConditionsConfig.html
type HumanLoopActivationConditionsConfig struct {

	// JSON expressing use-case specific conditions declaratively. If any condition is
	// matched, atomic tasks are created against the configured work team. The set of
	// conditions is different for Rekognition and Textract. For more information about
	// how to structure the JSON, see [JSON Schema for Human Loop Activation Conditions in Amazon Augmented AI]in the Amazon SageMaker Developer Guide.
	//
	// [JSON Schema for Human Loop Activation Conditions in Amazon Augmented AI]: https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-human-fallback-conditions-json-schema.html
	//
	// This value conforms to the media type: application/json
	//
	// This member is required.
	HumanLoopActivationConditions *string

	noSmithyDocumentSerde
}

// Provides information about how and under what conditions SageMaker creates a
// human loop. If HumanLoopActivationConfig is not given, then all requests go to
// humans.
type HumanLoopActivationConfig struct {

	// Container structure for defining under what conditions SageMaker creates a
	// human loop.
	//
	// This member is required.
	HumanLoopActivationConditionsConfig *HumanLoopActivationConditionsConfig

	noSmithyDocumentSerde
}

// Describes the work to be performed by human workers.
type HumanLoopConfig struct {

	// The Amazon Resource Name (ARN) of the human task user interface.
	//
	// You can use standard HTML and Crowd HTML Elements to create a custom worker
	// task template. You use this template to create a human task UI.
	//
	// To learn how to create a custom HTML template, see [Create Custom Worker Task Template].
	//
	// To learn how to create a human task UI, which is a worker task template that
	// can be used in a flow definition, see [Create and Delete a Worker Task Templates].
	//
	// [Create Custom Worker Task Template]: https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-custom-templates.html
	// [Create and Delete a Worker Task Templates]: https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-worker-template-console.html
	//
	// This member is required.
	HumanTaskUiArn *string

	// The number of distinct workers who will perform the same task on each object.
	// For example, if TaskCount is set to 3 for an image classification labeling job,
	// three workers will classify each input image. Increasing TaskCount can improve
	// label accuracy.
	//
	// This member is required.
	TaskCount *int32

	// A description for the human worker task.
	//
	// This member is required.
	TaskDescription *string

	// A title for the human worker task.
	//
	// This member is required.
	TaskTitle *string

	// Amazon Resource Name (ARN) of a team of workers. To learn more about the types
	// of workforces and work teams you can create and use with Amazon A2I, see [Create and Manage Workforces].
	//
	// [Create and Manage Workforces]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-management.html
	//
	// This member is required.
	WorkteamArn *string

	// Defines the amount of money paid to an Amazon Mechanical Turk worker for each
	// task performed.
	//
	// Use one of the following prices for bounding box tasks. Prices are in US
	// dollars and should be based on the complexity of the task; the longer it takes
	// in your initial testing, the more you should offer.
	//
	//   - 0.036
	//
	//   - 0.048
	//
	//   - 0.060
	//
	//   - 0.072
	//
	//   - 0.120
	//
	//   - 0.240
	//
	//   - 0.360
	//
	//   - 0.480
	//
	//   - 0.600
	//
	//   - 0.720
	//
	//   - 0.840
	//
	//   - 0.960
	//
	//   - 1.080
	//
	//   - 1.200
	//
	// Use one of the following prices for image classification, text classification,
	// and custom tasks. Prices are in US dollars.
	//
	//   - 0.012
	//
	//   - 0.024
	//
	//   - 0.036
	//
	//   - 0.048
	//
	//   - 0.060
	//
	//   - 0.072
	//
	//   - 0.120
	//
	//   - 0.240
	//
	//   - 0.360
	//
	//   - 0.480
	//
	//   - 0.600
	//
	//   - 0.720
	//
	//   - 0.840
	//
	//   - 0.960
	//
	//   - 1.080
	//
	//   - 1.200
	//
	// Use one of the following prices for semantic segmentation tasks. Prices are in
	// US dollars.
	//
	//   - 0.840
	//
	//   - 0.960
	//
	//   - 1.080
	//
	//   - 1.200
	//
	// Use one of the following prices for Textract AnalyzeDocument Important Form Key
	// Amazon Augmented AI review tasks. Prices are in US dollars.
	//
	//   - 2.400
	//
	//   - 2.280
	//
	//   - 2.160
	//
	//   - 2.040
	//
	//   - 1.920
	//
	//   - 1.800
	//
	//   - 1.680
	//
	//   - 1.560
	//
	//   - 1.440
	//
	//   - 1.320
	//
	//   - 1.200
	//
	//   - 1.080
	//
	//   - 0.960
	//
	//   - 0.840
	//
	//   - 0.720
	//
	//   - 0.600
	//
	//   - 0.480
	//
	//   - 0.360
	//
	//   - 0.240
	//
	//   - 0.120
	//
	//   - 0.072
	//
	//   - 0.060
	//
	//   - 0.048
	//
	//   - 0.036
	//
	//   - 0.024
	//
	//   - 0.012
	//
	// Use one of the following prices for Rekognition DetectModerationLabels Amazon
	// Augmented AI review tasks. Prices are in US dollars.
	//
	//   - 1.200
	//
	//   - 1.080
	//
	//   - 0.960
	//
	//   - 0.840
	//
	//   - 0.720
	//
	//   - 0.600
	//
	//   - 0.480
	//
	//   - 0.360
	//
	//   - 0.240
	//
	//   - 0.120
	//
	//   - 0.072
	//
	//   - 0.060
	//
	//   - 0.048
	//
	//   - 0.036
	//
	//   - 0.024
	//
	//   - 0.012
	//
	// Use one of the following prices for Amazon Augmented AI custom human review
	// tasks. Prices are in US dollars.
	//
	//   - 1.200
	//
	//   - 1.080
	//
	//   - 0.960
	//
	//   - 0.840
	//
	//   - 0.720
	//
	//   - 0.600
	//
	//   - 0.480
	//
	//   - 0.360
	//
	//   - 0.240
	//
	//   - 0.120
	//
	//   - 0.072
	//
	//   - 0.060
	//
	//   - 0.048
	//
	//   - 0.036
	//
	//   - 0.024
	//
	//   - 0.012
	PublicWorkforceTaskPrice *PublicWorkforceTaskPrice

	// The length of time that a task remains available for review by human workers.
	TaskAvailabilityLifetimeInSeconds *int32

	// Keywords used to describe the task so that workers can discover the task.
	TaskKeywords []string

	// The amount of time that a worker has to complete a task. The default value is
	// 3,600 seconds (1 hour).
	TaskTimeLimitInSeconds *int32

	noSmithyDocumentSerde
}

// Container for configuring the source of human task requests.
type HumanLoopRequestSource struct {

	// Specifies whether Amazon Rekognition or Amazon Textract are used as the
	// integration source. The default field settings and JSON parsing rules are
	// different based on the integration source. Valid values:
	//
	// This member is required.
	AwsManagedHumanLoopRequestSource AwsManagedHumanLoopRequestSource

	noSmithyDocumentSerde
}

// Information required for human workers to complete a labeling task.
type HumanTaskConfig struct {

	// Configures how labels are consolidated across human workers.
	//
	// This member is required.
	AnnotationConsolidationConfig *AnnotationConsolidationConfig

	// The number of human workers that will label an object.
	//
	// This member is required.
	NumberOfHumanWorkersPerDataObject *int32

	// The Amazon Resource Name (ARN) of a Lambda function that is run before a data
	// object is sent to a human worker. Use this function to provide input to a custom
	// labeling job.
	//
	// For [built-in task types], use one of the following Amazon SageMaker Ground Truth Lambda function
	// ARNs for PreHumanTaskLambdaArn . For custom labeling workflows, see [Pre-annotation Lambda].
	//
	// Bounding box - Finds the most similar boxes from different workers based on the
	// Jaccard index of the boxes.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:PRE-BoundingBox
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:PRE-BoundingBox
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:PRE-BoundingBox
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:PRE-BoundingBox
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:PRE-BoundingBox
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:PRE-BoundingBox
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:PRE-BoundingBox
	//
	//   - arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-BoundingBox
	//
	//   - arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-BoundingBox
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:PRE-BoundingBox
	//
	//   - arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-BoundingBox
	//
	//   - arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-BoundingBox
	//
	// Image classification - Uses a variant of the Expectation Maximization approach
	// to estimate the true class of an image based on annotations from individual
	// workers.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClass
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClass
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClass
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClass
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClass
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClass
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClass
	//
	//   - arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClass
	//
	//   - arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClass
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClass
	//
	//   - arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClass
	//
	//   - arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClass
	//
	// Multi-label image classification - Uses a variant of the Expectation
	// Maximization approach to estimate the true classes of an image based on
	// annotations from individual workers.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClassMultiLabel
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClassMultiLabel
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClassMultiLabel
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClassMultiLabel
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClassMultiLabel
	//
	// Semantic segmentation - Treats each pixel in an image as a multi-class
	// classification and treats pixel annotations from workers as "votes" for the
	// correct label.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:PRE-SemanticSegmentation
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:PRE-SemanticSegmentation
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:PRE-SemanticSegmentation
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:PRE-SemanticSegmentation
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:PRE-SemanticSegmentation
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:PRE-SemanticSegmentation
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:PRE-SemanticSegmentation
	//
	//   - arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-SemanticSegmentation
	//
	//   - arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-SemanticSegmentation
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:PRE-SemanticSegmentation
	//
	//   - arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-SemanticSegmentation
	//
	//   - arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-SemanticSegmentation
	//
	// Text classification - Uses a variant of the Expectation Maximization approach
	// to estimate the true class of text based on annotations from individual workers.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClass
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClass
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClass
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClass
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClass
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClass
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClass
	//
	//   - arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClass
	//
	//   - arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClass
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClass
	//
	//   - arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClass
	//
	//   - arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClass
	//
	// Multi-label text classification - Uses a variant of the Expectation
	// Maximization approach to estimate the true classes of text based on annotations
	// from individual workers.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClassMultiLabel
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClassMultiLabel
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClassMultiLabel
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClassMultiLabel
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClassMultiLabel
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClassMultiLabel
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClassMultiLabel
	//
	// Named entity recognition - Groups similar selections and calculates aggregate
	// boundaries, resolving to most-assigned label.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:PRE-NamedEntityRecognition
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:PRE-NamedEntityRecognition
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:PRE-NamedEntityRecognition
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:PRE-NamedEntityRecognition
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:PRE-NamedEntityRecognition
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:PRE-NamedEntityRecognition
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:PRE-NamedEntityRecognition
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-NamedEntityRecognition
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-NamedEntityRecognition
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:PRE-NamedEntityRecognition
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-NamedEntityRecognition
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-NamedEntityRecognition
	//
	// Video Classification - Use this task type when you need workers to classify
	// videos using predefined labels that you specify. Workers are shown videos and
	// are asked to choose one label for each video.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoMultiClass
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoMultiClass
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoMultiClass
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoMultiClass
	//
	//   - arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoMultiClass
	//
	//   - arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoMultiClass
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoMultiClass
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoMultiClass
	//
	//   - arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoMultiClass
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoMultiClass
	//
	//   - arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoMultiClass
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoMultiClass
	//
	// Video Frame Object Detection - Use this task type to have workers identify and
	// locate objects in a sequence of video frames (images extracted from a video)
	// using bounding boxes. For example, you can use this task to ask workers to
	// identify and localize various objects in a series of video frames, such as cars,
	// bikes, and pedestrians.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectDetection
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectDetection
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectDetection
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectDetection
	//
	//   - arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectDetection
	//
	//   - arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectDetection
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectDetection
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectDetection
	//
	//   - arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectDetection
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectDetection
	//
	//   - arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectDetection
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectDetection
	//
	// Video Frame Object Tracking - Use this task type to have workers track the
	// movement of objects in a sequence of video frames (images extracted from a
	// video) using bounding boxes. For example, you can use this task to ask workers
	// to track the movement of objects, such as cars, bikes, and pedestrians.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectTracking
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectTracking
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectTracking
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectTracking
	//
	//   - arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectTracking
	//
	//   - arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectTracking
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectTracking
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectTracking
	//
	//   - arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectTracking
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectTracking
	//
	//   - arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectTracking
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectTracking
	//
	// 3D Point Cloud Modalities
	//
	// Use the following pre-annotation lambdas for 3D point cloud labeling modality
	// tasks. See [3D Point Cloud Task types]to learn more.
	//
	// 3D Point Cloud Object Detection - Use this task type when you want workers to
	// classify objects in a 3D point cloud by drawing 3D cuboids around objects. For
	// example, you can use this task type to ask workers to identify different types
	// of objects in a point cloud, such as cars, bikes, and pedestrians.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectDetection
	//
	// 3D Point Cloud Object Tracking - Use this task type when you want workers to
	// draw 3D cuboids around objects that appear in a sequence of 3D point cloud
	// frames. For example, you can use this task type to ask workers to track the
	// movement of vehicles across multiple point cloud frames.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectTracking
	//
	// 3D Point Cloud Semantic Segmentation - Use this task type when you want workers
	// to create a point-level semantic segmentation masks by painting objects in a 3D
	// point cloud using different colors where each color is assigned to one of the
	// classes you specify.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudSemanticSegmentation
	//
	// Use the following ARNs for Label Verification and Adjustment Jobs
	//
	// Use label verification and adjustment jobs to review and adjust labels. To
	// learn more, see [Verify and Adjust Labels].
	//
	// Bounding box verification - Uses a variant of the Expectation Maximization
	// approach to estimate the true class of verification judgement for bounding box
	// labels based on annotations from individual workers.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationBoundingBox
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationBoundingBox
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationBoundingBox
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationBoundingBox
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationBoundingBox
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationBoundingBox
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationBoundingBox
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationBoundingBox
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationBoundingBox
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationBoundingBox
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationBoundingBox
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationBoundingBox
	//
	// Bounding box adjustment - Finds the most similar boxes from different workers
	// based on the Jaccard index of the adjusted annotations.
	//
	//   - arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentBoundingBox
	//
	//   - arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentBoundingBox
	//
	//   - arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentBoundingBox
	//
	//   - arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentBoundingBox
	//
	//   - arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentBoundingBox
	//
	//   - arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentBoundingBox
	//
	//   - arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentBoundingBox
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentBoundingBox
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentBoundingBox
	//
	//   - arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentBoundingBox
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentBoundingBox
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentBoundingBox
	//
	// Semantic segmentation verification - Uses a variant of the Expectation
	// Maximization approach to estimate the true class of verification judgment for
	// semantic segmentation labels based on annotations from individual workers.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationSemanticSegmentation
	//
	// Semantic segmentation adjustment - Treats each pixel in an image as a
	// multi-class classification and treats pixel adjusted annotations from workers as
	// "votes" for the correct label.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentSemanticSegmentation
	//
	// Video Frame Object Detection Adjustment - Use this task type when you want
	// workers to adjust bounding boxes that workers have added to video frames to
	// classify and localize objects in a sequence of video frames.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectDetection
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectDetection
	//
	// Video Frame Object Tracking Adjustment - Use this task type when you want
	// workers to adjust bounding boxes that workers have added to video frames to
	// track object movement across a sequence of video frames.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectTracking
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectTracking
	//
	// 3D point cloud object detection adjustment - Adjust 3D cuboids in a point cloud
	// frame.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectDetection
	//
	// 3D point cloud object tracking adjustment - Adjust 3D cuboids across a sequence
	// of point cloud frames.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectTracking
	//
	// 3D point cloud semantic segmentation adjustment - Adjust semantic segmentation
	// masks in a 3D point cloud.
	//
	//   -
	//   arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	//   -
	//   arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudSemanticSegmentation
	//
	// [built-in task types]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html
	// [3D Point Cloud Task types]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-task-types.html
	// [Pre-annotation Lambda]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-prelambda
	// [Verify and Adjust Labels]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html
	//
	// This member is required.
	PreHumanTaskLambdaArn *string

	// A description of the task for your human workers.
	//
	// This member is required.
	TaskDescription *string

	// The amount of time that a worker has to complete a task.
	//
	// If you create a custom labeling job, the maximum value for this parameter is 8
	// hours (28,800 seconds).
	//
	// If you create a labeling job using a [built-in task type] the maximum for this parameter depends on
	// the task type you use:
	//
	//   - For [image]and [text]labeling jobs, the maximum is 8 hours (28,800 seconds).
	//
	//   - For [3D point cloud]and [video frame]labeling jobs, the maximum is 30 days (2952,000 seconds) for non-AL
	//   mode. For most users, the maximum is also 30 days.
	//
	// [built-in task type]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html
	// [image]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-images.html
	// [video frame]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-video.html
	// [3D point cloud]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud.html
	// [text]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-text.html
	//
	// This member is required.
	TaskTimeLimitInSeconds *int32

	// A title for the task for your human workers.
	//
	// This member is required.
	TaskTitle *string

	// Information about the user interface that workers use to complete the labeling
	// task.
	//
	// This member is required.
	UiConfig *UiConfig

	// The Amazon Resource Name (ARN) of the work team assigned to complete the tasks.
	//
	// This member is required.
	WorkteamArn *string

	// Defines the maximum number of data objects that can be labeled by human workers
	// at the same time. Also referred to as batch size. Each object may have more than
	// one worker at one time. The default value is 1000 objects. To increase the
	// maximum value to 5000 objects, contact Amazon Web Services Support.
	MaxConcurrentTaskCount *int32

	// The price that you pay for each task performed by an Amazon Mechanical Turk
	// worker.
	PublicWorkforceTaskPrice *PublicWorkforceTaskPrice

	// The length of time that a task remains available for labeling by human workers.
	// The default and maximum values for this parameter depend on the type of
	// workforce you use.
	//
	//   - If you choose the Amazon Mechanical Turk workforce, the maximum is 12 hours
	//   (43,200 seconds). The default is 6 hours (21,600 seconds).
	//
	//   - If you choose a private or vendor workforce, the default value is 30 days
	//   (2592,000 seconds) for non-AL mode. For most users, the maximum is also 30 days.
	TaskAvailabilityLifetimeInSeconds *int32

	// Keywords used to describe the task so that workers on Amazon Mechanical Turk
	// can discover the task.
	TaskKeywords []string

	noSmithyDocumentSerde
}

// Container for human task user interface information.
type HumanTaskUiSummary struct {

	// A timestamp when SageMaker created the human task user interface.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the human task user interface.
	//
	// This member is required.
	HumanTaskUiArn *string

	// The name of the human task user interface.
	//
	// This member is required.
	HumanTaskUiName *string

	noSmithyDocumentSerde
}

// The configuration for Hyperband , a multi-fidelity based hyperparameter tuning
// strategy. Hyperband uses the final and intermediate results of a training job
// to dynamically allocate resources to utilized hyperparameter configurations
// while automatically stopping under-performing configurations. This parameter
// should be provided only if Hyperband is selected as the StrategyConfig under
// the HyperParameterTuningJobConfig API.
type HyperbandStrategyConfig struct {

	// The maximum number of resources (such as epochs) that can be used by a training
	// job launched by a hyperparameter tuning job. Once a job reaches the MaxResource
	// value, it is stopped. If a value for MaxResource is not provided, and Hyperband
	// is selected as the hyperparameter tuning strategy, HyperbandTraining attempts
	// to infer MaxResource from the following keys (if present) in [StaticsHyperParameters]:
	//
	//   - epochs
	//
	//   - numepochs
	//
	//   - n-epochs
	//
	//   - n_epochs
	//
	//   - num_epochs
	//
	// If HyperbandStrategyConfig is unable to infer a value for MaxResource , it
	// generates a validation error. The maximum value is 20,000 epochs. All metrics
	// that correspond to an objective metric are used to derive [early stopping decisions]. For [distributed] training jobs,
	// ensure that duplicate metrics are not printed in the logs across the individual
	// nodes in a training job. If multiple nodes are publishing duplicate or incorrect
	// metrics, training jobs may make an incorrect stopping decision and stop the job
	// prematurely.
	//
	// [StaticsHyperParameters]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html#sagemaker-Type-HyperParameterTrainingJobDefinition-StaticHyperParameters
	// [early stopping decisions]: https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html
	// [distributed]: https://docs.aws.amazon.com/sagemaker/latest/dg/distributed-training.html
	MaxResource *int32

	// The minimum number of resources (such as epochs) that can be used by a training
	// job launched by a hyperparameter tuning job. If the value for MinResource has
	// not been reached, the training job is not stopped by Hyperband .
	MinResource *int32

	noSmithyDocumentSerde
}

// Specifies which training algorithm to use for training jobs that a
// hyperparameter tuning job launches and the metrics to monitor.
type HyperParameterAlgorithmSpecification struct {

	// The training input mode that the algorithm supports. For more information about
	// input modes, see [Algorithms].
	//
	// Pipe mode
	//
	// If an algorithm supports Pipe mode, Amazon SageMaker streams data directly from
	// Amazon S3 to the container.
	//
	// File mode
	//
	// If an algorithm supports File mode, SageMaker downloads the training data from
	// S3 to the provisioned ML storage volume, and mounts the directory to the Docker
	// volume for the training container.
	//
	// You must provision the ML storage volume with sufficient capacity to
	// accommodate the data downloaded from S3. In addition to the training data, the
	// ML storage volume also stores the output model. The algorithm container uses the
	// ML storage volume to also store intermediate information, if any.
	//
	// For distributed algorithms, training data is distributed uniformly. Your
	// training duration is predictable if the input data objects sizes are
	// approximately the same. SageMaker does not split the files any further for model
	// training. If the object sizes are skewed, training won't be optimal as the data
	// distribution is also skewed when one host in a training cluster is overloaded,
	// thus becoming a bottleneck in training.
	//
	// FastFile mode
	//
	// If an algorithm supports FastFile mode, SageMaker streams data directly from S3
	// to the container with no code changes, and provides file system access to the
	// data. Users can author their training script to interact with these files as if
	// they were stored on disk.
	//
	// FastFile mode works best when the data is read sequentially. Augmented manifest
	// files aren't supported. The startup time is lower when there are fewer files in
	// the S3 bucket provided.
	//
	// [Algorithms]: https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html
	//
	// This member is required.
	TrainingInputMode TrainingInputMode

	// The name of the resource algorithm to use for the hyperparameter tuning job. If
	// you specify a value for this parameter, do not specify a value for TrainingImage
	// .
	AlgorithmName *string

	// An array of [MetricDefinition] objects that specify the metrics that the algorithm emits.
	//
	// [MetricDefinition]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_MetricDefinition.html
	MetricDefinitions []MetricDefinition

	//  The registry path of the Docker image that contains the training algorithm.
	// For information about Docker registry paths for built-in algorithms, see [Algorithms Provided by Amazon SageMaker: Common Parameters].
	// SageMaker supports both registry/repository[:tag] and
	// registry/repository[@digest] image path formats. For more information, see [Using Your Own Algorithms with Amazon SageMaker].
	//
	// [Algorithms Provided by Amazon SageMaker: Common Parameters]: https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-algo-docker-registry-paths.html
	// [Using Your Own Algorithms with Amazon SageMaker]: https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html
	TrainingImage *string

	noSmithyDocumentSerde
}

// Defines a hyperparameter to be used by an algorithm.
type HyperParameterSpecification struct {

	// The name of this hyperparameter. The name must be unique.
	//
	// This member is required.
	Name *string

	// The type of this hyperparameter. The valid types are Integer , Continuous ,
	// Categorical , and FreeText .
	//
	// This member is required.
	Type ParameterType

	// The default value for this hyperparameter. If a default value is specified, a
	// hyperparameter cannot be required.
	DefaultValue *string

	// A brief description of the hyperparameter.
	Description *string

	// Indicates whether this hyperparameter is required.
	IsRequired *bool

	// Indicates whether this hyperparameter is tunable in a hyperparameter tuning job.
	IsTunable *bool

	// The allowed range for this hyperparameter.
	Range *ParameterRange

	noSmithyDocumentSerde
}

// Defines the training jobs launched by a hyperparameter tuning job.
type HyperParameterTrainingJobDefinition struct {

	// The [HyperParameterAlgorithmSpecification] object that specifies the resource algorithm to use for the training jobs
	// that the tuning job launches.
	//
	// [HyperParameterAlgorithmSpecification]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterAlgorithmSpecification.html
	//
	// This member is required.
	AlgorithmSpecification *HyperParameterAlgorithmSpecification

	// Specifies the path to the Amazon S3 bucket where you store model artifacts from
	// the training jobs that the tuning job launches.
	//
	// This member is required.
	OutputDataConfig *OutputDataConfig

	// The Amazon Resource Name (ARN) of the IAM role associated with the training
	// jobs that the tuning job launches.
	//
	// This member is required.
	RoleArn *string

	// Specifies a limit to how long a model hyperparameter training job can run. It
	// also specifies how long a managed spot training job has to complete. When the
	// job reaches the time limit, SageMaker ends the training job. Use this API to cap
	// model training costs.
	//
	// This member is required.
	StoppingCondition *StoppingCondition

	// Contains information about the output location for managed spot training
	// checkpoint data.
	CheckpointConfig *CheckpointConfig

	// The job definition name.
	DefinitionName *string

	// To encrypt all communications between ML compute instances in distributed
	// training, choose True . Encryption provides greater security for distributed
	// training, but training might take longer. How long it takes depends on the
	// amount of communication between compute instances, especially if you use a deep
	// learning algorithm in distributed training.
	EnableInterContainerTrafficEncryption *bool

	// A Boolean indicating whether managed spot training is enabled ( True ) or not (
	// False ).
	EnableManagedSpotTraining *bool

	// Isolates the training container. No inbound or outbound network calls can be
	// made, except for calls between peers within a training cluster for distributed
	// training. If network isolation is used for training jobs that are configured to
	// use a VPC, SageMaker downloads and uploads customer data and model artifacts
	// through the specified VPC, but the training container does not have network
	// access.
	EnableNetworkIsolation *bool

	// An environment variable that you can pass into the SageMaker [CreateTrainingJob] API. You can use
	// an existing [environment variable from the training container]or use your own. See [Define metrics and variables] for more information.
	//
	// The maximum number of items specified for Map Entries refers to the maximum
	// number of environment variables for each TrainingJobDefinition and also the
	// maximum for the hyperparameter tuning job itself. That is, the sum of the number
	// of environment variables for all the training job definitions can't exceed the
	// maximum number specified.
	//
	// [Define metrics and variables]: https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html
	// [environment variable from the training container]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html#sagemaker-CreateTrainingJob-request-Environment
	// [CreateTrainingJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html
	Environment map[string]string

	// Specifies ranges of integer, continuous, and categorical hyperparameters that a
	// hyperparameter tuning job searches. The hyperparameter tuning job launches
	// training jobs with hyperparameter values within these ranges to find the
	// combination of values that result in the training job with the best performance
	// as measured by the objective metric of the hyperparameter tuning job.
	//
	// The maximum number of items specified for Array Members refers to the maximum
	// number of hyperparameters for each range and also the maximum for the
	// hyperparameter tuning job itself. That is, the sum of the number of
	// hyperparameters for all the ranges can't exceed the maximum number specified.
	HyperParameterRanges *ParameterRanges

	// The configuration for the hyperparameter tuning resources, including the
	// compute instances and storage volumes, used for training jobs launched by the
	// tuning job. By default, storage volumes hold model artifacts and incremental
	// states. Choose File for TrainingInputMode in the AlgorithmSpecification
	// parameter to additionally store training data in the storage volume (optional).
	HyperParameterTuningResourceConfig *HyperParameterTuningResourceConfig

	// An array of [Channel] objects that specify the input for the training jobs that the
	// tuning job launches.
	//
	// [Channel]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Channel.html
	InputDataConfig []Channel

	// The resources, including the compute instances and storage volumes, to use for
	// the training jobs that the tuning job launches.
	//
	// Storage volumes store model artifacts and incremental states. Training
	// algorithms might also use storage volumes for scratch space. If you want
	// SageMaker to use the storage volume to store the training data, choose File as
	// the TrainingInputMode in the algorithm specification. For distributed training
	// algorithms, specify an instance count greater than 1.
	//
	// If you want to use hyperparameter optimization with instance type flexibility,
	// use HyperParameterTuningResourceConfig instead.
	ResourceConfig *ResourceConfig

	// The number of times to retry the job when the job fails due to an
	// InternalServerError .
	RetryStrategy *RetryStrategy

	// Specifies the values of hyperparameters that do not change for the tuning job.
	StaticHyperParameters map[string]string

	// Defines the objective metric for a hyperparameter tuning job. Hyperparameter
	// tuning uses the value of this metric to evaluate the training jobs it launches,
	// and returns the training job that results in either the highest or lowest value
	// for this metric, depending on the value you specify for the Type parameter. If
	// you want to define a custom objective metric, see [Define metrics and environment variables].
	//
	// [Define metrics and environment variables]: https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html
	TuningObjective *HyperParameterTuningJobObjective

	// The [VpcConfig] object that specifies the VPC that you want the training jobs that this
	// hyperparameter tuning job launches to connect to. Control access to and from
	// your training container by configuring the VPC. For more information, see [Protect Training Jobs by Using an Amazon Virtual Private Cloud].
	//
	// [VpcConfig]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html
	// [Protect Training Jobs by Using an Amazon Virtual Private Cloud]: https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// The container for the summary information about a training job.
type HyperParameterTrainingJobSummary struct {

	// The date and time that the training job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the training job.
	//
	// This member is required.
	TrainingJobArn *string

	// The name of the training job.
	//
	// This member is required.
	TrainingJobName *string

	// The status of the training job.
	//
	// This member is required.
	TrainingJobStatus TrainingJobStatus

	// A list of the hyperparameters for which you specified ranges to search.
	//
	// This member is required.
	TunedHyperParameters map[string]string

	// The reason that the training job failed.
	FailureReason *string

	// The [FinalHyperParameterTuningJobObjectiveMetric] object that specifies the value of the objective metric of the tuning job
	// that launched this training job.
	//
	// [FinalHyperParameterTuningJobObjectiveMetric]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_FinalHyperParameterTuningJobObjectiveMetric.html
	FinalHyperParameterTuningJobObjectiveMetric *FinalHyperParameterTuningJobObjectiveMetric

	// The status of the objective metric for the training job:
	//
	//   - Succeeded: The final objective metric for the training job was evaluated by
	//   the hyperparameter tuning job and used in the hyperparameter tuning process.
	//
	//   - Pending: The training job is in progress and evaluation of its final
	//   objective metric is pending.
	//
	//   - Failed: The final objective metric for the training job was not evaluated,
	//   and was not used in the hyperparameter tuning process. This typically occurs
	//   when the training job failed or did not emit an objective metric.
	ObjectiveStatus ObjectiveStatus

	// Specifies the time when the training job ends on training instances. You are
	// billed for the time interval between the value of TrainingStartTime and this
	// time. For successful jobs and stopped jobs, this is the time after model
	// artifacts are uploaded. For failed jobs, this is the time when SageMaker detects
	// a job failure.
	TrainingEndTime *time.Time

	// The training job definition name.
	TrainingJobDefinitionName *string

	// The date and time that the training job started.
	TrainingStartTime *time.Time

	// The HyperParameter tuning job that launched the training job.
	TuningJobName *string

	noSmithyDocumentSerde
}

// The configuration for hyperparameter tuning resources for use in training jobs
// launched by the tuning job. These resources include compute instances and
// storage volumes. Specify one or more compute instance configurations and
// allocation strategies to select resources (optional).
type HyperParameterTuningInstanceConfig struct {

	// The number of instances of the type specified by InstanceType . Choose an
	// instance count larger than 1 for distributed training algorithms. See [Step 2: Launch a SageMaker Distributed Training Job Using the SageMaker Python SDK]for more
	// information.
	//
	// [Step 2: Launch a SageMaker Distributed Training Job Using the SageMaker Python SDK]: https://docs.aws.amazon.com/sagemaker/latest/dg/data-parallel-use-api.html
	//
	// This member is required.
	InstanceCount *int32

	// The instance type used for processing of hyperparameter optimization jobs.
	// Choose from general purpose (no GPUs) instance types: ml.m5.xlarge,
	// ml.m5.2xlarge, and ml.m5.4xlarge or compute optimized (no GPUs) instance types:
	// ml.c5.xlarge and ml.c5.2xlarge. For more information about instance types, see [instance type descriptions].
	//
	// [instance type descriptions]: https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html
	//
	// This member is required.
	InstanceType TrainingInstanceType

	// The volume size in GB of the data to be processed for hyperparameter
	// optimization (optional).
	//
	// This member is required.
	VolumeSizeInGB *int32

	noSmithyDocumentSerde
}

// A structure that contains runtime information about both current and completed
// hyperparameter tuning jobs.
type HyperParameterTuningJobCompletionDetails struct {

	// The time in timestamp format that AMT detected model convergence, as defined by
	// a lack of significant improvement over time based on criteria developed over a
	// wide range of diverse benchmarking tests.
	ConvergenceDetectedTime *time.Time

	// The number of training jobs launched by a tuning job that are not improving (1%
	// or less) as measured by model performance evaluated against an objective
	// function.
	NumberOfTrainingJobsObjectiveNotImproving *int32

	noSmithyDocumentSerde
}

// Configures a hyperparameter tuning job.
type HyperParameterTuningJobConfig struct {

	// The [ResourceLimits] object that specifies the maximum number of training and parallel training
	// jobs that can be used for this hyperparameter tuning job.
	//
	// [ResourceLimits]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html
	//
	// This member is required.
	ResourceLimits *ResourceLimits

	// Specifies how hyperparameter tuning chooses the combinations of hyperparameter
	// values to use for the training job it launches. For information about search
	// strategies, see [How Hyperparameter Tuning Works].
	//
	// [How Hyperparameter Tuning Works]: https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html
	//
	// This member is required.
	Strategy HyperParameterTuningJobStrategyType

	// The [HyperParameterTuningJobObjective] specifies the objective metric used to evaluate the performance of
	// training jobs launched by this tuning job.
	//
	// [HyperParameterTuningJobObjective]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTuningJobObjective.html
	HyperParameterTuningJobObjective *HyperParameterTuningJobObjective

	// The [ParameterRanges] object that specifies the ranges of hyperparameters that this tuning job
	// searches over to find the optimal configuration for the highest model
	// performance against your chosen objective metric.
	//
	// [ParameterRanges]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ParameterRanges.html
	ParameterRanges *ParameterRanges

	// A value used to initialize a pseudo-random number generator. Setting a random
	// seed and using the same seed later for the same tuning job will allow
	// hyperparameter optimization to find more a consistent hyperparameter
	// configuration between the two runs.
	RandomSeed *int32

	// The configuration for the Hyperband optimization strategy. This parameter
	// should be provided only if Hyperband is selected as the strategy for
	// HyperParameterTuningJobConfig .
	StrategyConfig *HyperParameterTuningJobStrategyConfig

	// Specifies whether to use early stopping for training jobs launched by the
	// hyperparameter tuning job. Because the Hyperband strategy has its own advanced
	// internal early stopping mechanism, TrainingJobEarlyStoppingType must be OFF to
	// use Hyperband . This parameter can take on one of the following values (the
	// default value is OFF ):
	//
	// OFF Training jobs launched by the hyperparameter tuning job do not use early
	// stopping.
	//
	// AUTO SageMaker stops training jobs launched by the hyperparameter tuning job
	// when they are unlikely to perform better than previously completed training
	// jobs. For more information, see [Stop Training Jobs Early].
	//
	// [Stop Training Jobs Early]: https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-early-stopping.html
	TrainingJobEarlyStoppingType TrainingJobEarlyStoppingType

	// The tuning job's completion criteria.
	TuningJobCompletionCriteria *TuningJobCompletionCriteria

	noSmithyDocumentSerde
}

// The total resources consumed by your hyperparameter tuning job.
type HyperParameterTuningJobConsumedResources struct {

	// The wall clock runtime in seconds used by your hyperparameter tuning job.
	RuntimeInSeconds *int32

	noSmithyDocumentSerde
}

// Defines the objective metric for a hyperparameter tuning job. Hyperparameter
// tuning uses the value of this metric to evaluate the training jobs it launches,
// and returns the training job that results in either the highest or lowest value
// for this metric, depending on the value you specify for the Type parameter. If
// you want to define a custom objective metric, see [Define metrics and environment variables].
//
// [Define metrics and environment variables]: https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html
type HyperParameterTuningJobObjective struct {

	// The name of the metric to use for the objective metric.
	//
	// This member is required.
	MetricName *string

	// Whether to minimize or maximize the objective metric.
	//
	// This member is required.
	Type HyperParameterTuningJobObjectiveType

	noSmithyDocumentSerde
}

// An entity returned by the [SearchRecord] API containing the properties of a hyperparameter
// tuning job.
//
// [SearchRecord]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SearchRecord.html
type HyperParameterTuningJobSearchEntity struct {

	// The container for the summary information about a training job.
	BestTrainingJob *HyperParameterTrainingJobSummary

	// The total amount of resources consumed by a hyperparameter tuning job.
	ConsumedResources *HyperParameterTuningJobConsumedResources

	// The time that a hyperparameter tuning job was created.
	CreationTime *time.Time

	// The error that was created when a hyperparameter tuning job failed.
	FailureReason *string

	// The time that a hyperparameter tuning job ended.
	HyperParameterTuningEndTime *time.Time

	// The Amazon Resource Name (ARN) of a hyperparameter tuning job.
	HyperParameterTuningJobArn *string

	// Configures a hyperparameter tuning job.
	HyperParameterTuningJobConfig *HyperParameterTuningJobConfig

	// The name of a hyperparameter tuning job.
	HyperParameterTuningJobName *string

	// The status of a hyperparameter tuning job.
	HyperParameterTuningJobStatus HyperParameterTuningJobStatus

	// The time that a hyperparameter tuning job was last modified.
	LastModifiedTime *time.Time

	// Specifies the number of training jobs that this hyperparameter tuning job
	// launched, categorized by the status of their objective metric. The objective
	// metric status shows whether the final objective metric for the training job has
	// been evaluated by the tuning job and used in the hyperparameter tuning process.
	ObjectiveStatusCounters *ObjectiveStatusCounters

	// The container for the summary information about a training job.
	OverallBestTrainingJob *HyperParameterTrainingJobSummary

	// The tags associated with a hyperparameter tuning job. For more information see [Tagging Amazon Web Services resources].
	//
	// [Tagging Amazon Web Services resources]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
	Tags []Tag

	// Defines the training jobs launched by a hyperparameter tuning job.
	TrainingJobDefinition *HyperParameterTrainingJobDefinition

	// The job definitions included in a hyperparameter tuning job.
	TrainingJobDefinitions []HyperParameterTrainingJobDefinition

	// The numbers of training jobs launched by a hyperparameter tuning job,
	// categorized by status.
	TrainingJobStatusCounters *TrainingJobStatusCounters

	// Information about either a current or completed hyperparameter tuning job.
	TuningJobCompletionDetails *HyperParameterTuningJobCompletionDetails

	// Specifies the configuration for a hyperparameter tuning job that uses one or
	// more previous hyperparameter tuning jobs as a starting point. The results of
	// previous tuning jobs are used to inform which combinations of hyperparameters to
	// search over in the new tuning job.
	//
	// All training jobs launched by the new hyperparameter tuning job are evaluated
	// by using the objective metric, and the training job that performs the best is
	// compared to the best training jobs from the parent tuning jobs. From these, the
	// training job that performs the best as measured by the objective metric is
	// returned as the overall best training job.
	//
	// All training jobs launched by parent hyperparameter tuning jobs and the new
	// hyperparameter tuning jobs count against the limit of training jobs for the
	// tuning job.
	WarmStartConfig *HyperParameterTuningJobWarmStartConfig

	noSmithyDocumentSerde
}

// The configuration for a training job launched by a hyperparameter tuning job.
// Choose Bayesian for Bayesian optimization, and Random for random search
// optimization. For more advanced use cases, use Hyperband , which evaluates
// objective metrics for training jobs after every epoch. For more information
// about strategies, see [How Hyperparameter Tuning Works].
//
// [How Hyperparameter Tuning Works]: https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html
type HyperParameterTuningJobStrategyConfig struct {

	// The configuration for the object that specifies the Hyperband strategy. This
	// parameter is only supported for the Hyperband selection for Strategy within the
	// HyperParameterTuningJobConfig API.
	HyperbandStrategyConfig *HyperbandStrategyConfig

	noSmithyDocumentSerde
}

// Provides summary information about a hyperparameter tuning job.
type HyperParameterTuningJobSummary struct {

	// The date and time that the tuning job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the tuning job.
	//
	// This member is required.
	HyperParameterTuningJobArn *string

	// The name of the tuning job.
	//
	// This member is required.
	HyperParameterTuningJobName *string

	// The status of the tuning job.
	//
	// This member is required.
	HyperParameterTuningJobStatus HyperParameterTuningJobStatus

	// The [ObjectiveStatusCounters] object that specifies the numbers of training jobs, categorized by
	// objective metric status, that this tuning job launched.
	//
	// [ObjectiveStatusCounters]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ObjectiveStatusCounters.html
	//
	// This member is required.
	ObjectiveStatusCounters *ObjectiveStatusCounters

	// Specifies the search strategy hyperparameter tuning uses to choose which
	// hyperparameters to evaluate at each iteration.
	//
	// This member is required.
	Strategy HyperParameterTuningJobStrategyType

	// The [TrainingJobStatusCounters] object that specifies the numbers of training jobs, categorized by status,
	// that this tuning job launched.
	//
	// [TrainingJobStatusCounters]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TrainingJobStatusCounters.html
	//
	// This member is required.
	TrainingJobStatusCounters *TrainingJobStatusCounters

	// The date and time that the tuning job ended.
	HyperParameterTuningEndTime *time.Time

	// The date and time that the tuning job was modified.
	LastModifiedTime *time.Time

	// The [ResourceLimits] object that specifies the maximum number of training jobs and parallel
	// training jobs allowed for this tuning job.
	//
	// [ResourceLimits]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ResourceLimits.html
	ResourceLimits *ResourceLimits

	noSmithyDocumentSerde
}

// Specifies the configuration for a hyperparameter tuning job that uses one or
// more previous hyperparameter tuning jobs as a starting point. The results of
// previous tuning jobs are used to inform which combinations of hyperparameters to
// search over in the new tuning job.
//
// All training jobs launched by the new hyperparameter tuning job are evaluated
// by using the objective metric, and the training job that performs the best is
// compared to the best training jobs from the parent tuning jobs. From these, the
// training job that performs the best as measured by the objective metric is
// returned as the overall best training job.
//
// All training jobs launched by parent hyperparameter tuning jobs and the new
// hyperparameter tuning jobs count against the limit of training jobs for the
// tuning job.
type HyperParameterTuningJobWarmStartConfig struct {

	// An array of hyperparameter tuning jobs that are used as the starting point for
	// the new hyperparameter tuning job. For more information about warm starting a
	// hyperparameter tuning job, see [Using a Previous Hyperparameter Tuning Job as a Starting Point].
	//
	// Hyperparameter tuning jobs created before October 1, 2018 cannot be used as
	// parent jobs for warm start tuning jobs.
	//
	// [Using a Previous Hyperparameter Tuning Job as a Starting Point]: https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-warm-start.html
	//
	// This member is required.
	ParentHyperParameterTuningJobs []ParentHyperParameterTuningJob

	// Specifies one of the following:
	//
	// IDENTICAL_DATA_AND_ALGORITHM The new hyperparameter tuning job uses the same
	// input data and training image as the parent tuning jobs. You can change the
	// hyperparameter ranges to search and the maximum number of training jobs that the
	// hyperparameter tuning job launches. You cannot use a new version of the training
	// algorithm, unless the changes in the new version do not affect the algorithm
	// itself. For example, changes that improve logging or adding support for a
	// different data format are allowed. You can also change hyperparameters from
	// tunable to static, and from static to tunable, but the total number of static
	// plus tunable hyperparameters must remain the same as it is in all parent jobs.
	// The objective metric for the new tuning job must be the same as for all parent
	// jobs.
	//
	// TRANSFER_LEARNING The new hyperparameter tuning job can include input data,
	// hyperparameter ranges, maximum number of concurrent training jobs, and maximum
	// number of training jobs that are different than those of its parent
	// hyperparameter tuning jobs. The training image can also be a different version
	// from the version used in the parent hyperparameter tuning job. You can also
	// change hyperparameters from tunable to static, and from static to tunable, but
	// the total number of static plus tunable hyperparameters must remain the same as
	// it is in all parent jobs. The objective metric for the new tuning job must be
	// the same as for all parent jobs.
	//
	// This member is required.
	WarmStartType HyperParameterTuningJobWarmStartType

	noSmithyDocumentSerde
}

// The configuration of resources, including compute instances and storage volumes
// for use in training jobs launched by hyperparameter tuning jobs.
// HyperParameterTuningResourceConfig is similar to ResourceConfig , but has the
// additional InstanceConfigs and AllocationStrategy fields to allow for flexible
// instance management. Specify one or more instance types, count, and the
// allocation strategy for instance selection.
//
// HyperParameterTuningResourceConfig supports the capabilities of ResourceConfig
// with the exception of KeepAlivePeriodInSeconds . Hyperparameter tuning jobs use
// warm pools by default, which reuse clusters between training jobs.
type HyperParameterTuningResourceConfig struct {

	// The strategy that determines the order of preference for resources specified in
	// InstanceConfigs used in hyperparameter optimization.
	AllocationStrategy HyperParameterTuningAllocationStrategy

	// A list containing the configuration(s) for one or more resources for processing
	// hyperparameter jobs. These resources include compute instances and storage
	// volumes to use in model training jobs launched by hyperparameter tuning jobs.
	// The AllocationStrategy controls the order in which multiple configurations
	// provided in InstanceConfigs are used.
	//
	// If you only want to use a single instance configuration inside the
	// HyperParameterTuningResourceConfig API, do not provide a value for
	// InstanceConfigs . Instead, use InstanceType , VolumeSizeInGB and InstanceCount .
	// If you use InstanceConfigs , do not provide values for InstanceType ,
	// VolumeSizeInGB or InstanceCount .
	InstanceConfigs []HyperParameterTuningInstanceConfig

	// The number of compute instances of type InstanceType to use. For [distributed training], select a
	// value greater than 1.
	//
	// [distributed training]: https://docs.aws.amazon.com/sagemaker/latest/dg/data-parallel-use-api.html
	InstanceCount *int32

	// The instance type used to run hyperparameter optimization tuning jobs. See [descriptions of instance types] for
	// more information.
	//
	// [descriptions of instance types]: https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html
	InstanceType TrainingInstanceType

	// A key used by Amazon Web Services Key Management Service to encrypt data on the
	// storage volume attached to the compute instances used to run the training job.
	// You can use either of the following formats to specify a key.
	//
	// KMS Key ID:
	//
	//     "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	// Amazon Resource Name (ARN) of a KMS key:
	//
	//     "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	// Some instances use local storage, which use a [hardware module to encrypt] storage volumes. If you choose
	// one of these instance types, you cannot request a VolumeKmsKeyId . For a list of
	// instance types that use local storage, see [instance store volumes]. For more information about Amazon
	// Web Services Key Management Service, see [KMS encryption]for more information.
	//
	// [KMS encryption]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security-kms-permissions.html
	// [hardware module to encrypt]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html
	// [instance store volumes]: http://aws.amazon.com/releasenotes/host-instance-storage-volumes-table/
	VolumeKmsKeyId *string

	// The volume size in GB for the storage volume to be used in processing
	// hyperparameter optimization jobs (optional). These volumes store model
	// artifacts, incremental states and optionally, scratch space for training
	// algorithms. Do not provide a value for this parameter if a value for
	// InstanceConfigs is also specified.
	//
	// Some instance types have a fixed total local storage size. If you select one of
	// these instances for training, VolumeSizeInGB cannot be greater than this total
	// size. For a list of instance types with local instance storage and their sizes,
	// see [instance store volumes].
	//
	// SageMaker supports only the [General Purpose SSD (gp2)] storage volume type.
	//
	// [instance store volumes]: http://aws.amazon.com/releasenotes/host-instance-storage-volumes-table/
	// [General Purpose SSD (gp2)]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volume-types.html
	VolumeSizeInGB *int32

	noSmithyDocumentSerde
}

// The IAM Identity details associated with the user. These details are associated
// with model package groups, model packages and project entities only.
type IamIdentity struct {

	// The Amazon Resource Name (ARN) of the IAM identity.
	Arn *string

	// The ID of the principal that assumes the IAM identity.
	PrincipalId *string

	// The person or application which assumes the IAM identity.
	SourceIdentity *string

	noSmithyDocumentSerde
}

// Use this parameter to specify a supported global condition key that is added to
// the IAM policy.
type IamPolicyConstraints struct {

	// When SourceIp is Enabled the worker's IP address when a task is rendered in the
	// worker portal is added to the IAM policy as a Condition used to generate the
	// Amazon S3 presigned URL. This IP address is checked by Amazon S3 and must match
	// in order for the Amazon S3 resource to be rendered in the worker portal.
	SourceIp EnabledOrDisabled

	// When VpcSourceIp is Enabled the worker's IP address when a task is rendered in
	// private worker portal inside the VPC is added to the IAM policy as a Condition
	// used to generate the Amazon S3 presigned URL. To render the task successfully
	// Amazon S3 checks that the presigned URL is being accessed over an Amazon S3 VPC
	// Endpoint, and that the worker's IP address matches the IP address in the IAM
	// policy. To learn more about configuring private worker portal, see [Use Amazon VPC mode from a private worker portal].
	//
	// [Use Amazon VPC mode from a private worker portal]: https://docs.aws.amazon.com/sagemaker/latest/dg/samurai-vpc-worker-portal.html
	VpcSourceIp EnabledOrDisabled

	noSmithyDocumentSerde
}

// The Amazon SageMaker Canvas application setting where you configure OAuth for
// connecting to an external data source, such as Snowflake.
type IdentityProviderOAuthSetting struct {

	// The name of the data source that you're connecting to. Canvas currently
	// supports OAuth for Snowflake and Salesforce Data Cloud.
	DataSourceName DataSourceName

	// The ARN of an Amazon Web Services Secrets Manager secret that stores the
	// credentials from your identity provider, such as the client ID and secret,
	// authorization URL, and token URL.
	SecretArn *string

	// Describes whether OAuth for a data source is enabled or disabled in the Canvas
	// application.
	Status FeatureStatus

	noSmithyDocumentSerde
}

// A SageMaker image. A SageMaker image represents a set of container images that
// are derived from a common base container image. Each of these container images
// is represented by a SageMaker ImageVersion .
type Image struct {

	// When the image was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The ARN of the image.
	//
	// This member is required.
	ImageArn *string

	// The name of the image.
	//
	// This member is required.
	ImageName *string

	// The status of the image.
	//
	// This member is required.
	ImageStatus ImageStatus

	// When the image was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The description of the image.
	Description *string

	// The name of the image as displayed.
	DisplayName *string

	// When a create, update, or delete operation fails, the reason for the failure.
	FailureReason *string

	noSmithyDocumentSerde
}

// The collection of settings used by an AutoML job V2 for the image
// classification problem type.
type ImageClassificationJobConfig struct {

	// How long a job is allowed to run, or how many candidates a job is allowed to
	// generate.
	CompletionCriteria *AutoMLJobCompletionCriteria

	noSmithyDocumentSerde
}

// Specifies whether the model container is in Amazon ECR or a private Docker
// registry accessible from your Amazon Virtual Private Cloud (VPC).
type ImageConfig struct {

	// Set this to one of the following values:
	//
	//   - Platform - The model image is hosted in Amazon ECR.
	//
	//   - Vpc - The model image is hosted in a private Docker registry in your VPC.
	//
	// This member is required.
	RepositoryAccessMode RepositoryAccessMode

	// (Optional) Specifies an authentication configuration for the private docker
	// registry where your model image is hosted. Specify a value for this property
	// only if you specified Vpc as the value for the RepositoryAccessMode field, and
	// the private Docker registry where the model image is hosted requires
	// authentication.
	RepositoryAuthConfig *RepositoryAuthConfig

	noSmithyDocumentSerde
}

// A version of a SageMaker Image . A version represents an existing container
// image.
type ImageVersion struct {

	// When the version was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The ARN of the image the version is based on.
	//
	// This member is required.
	ImageArn *string

	// The ARN of the version.
	//
	// This member is required.
	ImageVersionArn *string

	// The status of the version.
	//
	// This member is required.
	ImageVersionStatus ImageVersionStatus

	// When the version was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The version number.
	//
	// This member is required.
	Version *int32

	// When a create or delete operation fails, the reason for the failure.
	FailureReason *string

	noSmithyDocumentSerde
}

// Defines the compute resources to allocate to run a model that you assign to an
// inference component. These resources include CPU cores, accelerators, and
// memory.
type InferenceComponentComputeResourceRequirements struct {

	// The minimum MB of memory to allocate to run a model that you assign to an
	// inference component.
	//
	// This member is required.
	MinMemoryRequiredInMb *int32

	// The maximum MB of memory to allocate to run a model that you assign to an
	// inference component.
	MaxMemoryRequiredInMb *int32

	// The number of accelerators to allocate to run a model that you assign to an
	// inference component. Accelerators include GPUs and Amazon Web Services
	// Inferentia.
	NumberOfAcceleratorDevicesRequired *float32

	// The number of CPU cores to allocate to run a model that you assign to an
	// inference component.
	NumberOfCpuCoresRequired *float32

	noSmithyDocumentSerde
}

// Defines a container that provides the runtime environment for a model that you
// deploy with an inference component.
type InferenceComponentContainerSpecification struct {

	// The Amazon S3 path where the model artifacts, which result from model training,
	// are stored. This path must point to a single gzip compressed tar archive
	// (.tar.gz suffix).
	ArtifactUrl *string

	// The environment variables to set in the Docker container. Each key and value in
	// the Environment string-to-string map can have length of up to 1024. We support
	// up to 16 entries in the map.
	Environment map[string]string

	// The Amazon Elastic Container Registry (Amazon ECR) path where the Docker image
	// for the model is stored.
	Image *string

	noSmithyDocumentSerde
}

// Details about the resources that are deployed with this inference component.
type InferenceComponentContainerSpecificationSummary struct {

	// The Amazon S3 path where the model artifacts are stored.
	ArtifactUrl *string

	// Gets the Amazon EC2 Container Registry path of the docker image of the model
	// that is hosted in this [ProductionVariant].
	//
	// If you used the registry/repository[:tag] form to specify the image path of the
	// primary container when you created the model hosted in this ProductionVariant ,
	// the path resolves to a path of the form registry/repository[@digest] . A digest
	// is a hash value that identifies a specific version of an image. For information
	// about Amazon ECR paths, see [Pulling an Image]in the Amazon ECR User Guide.
	//
	// [ProductionVariant]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ProductionVariant.html
	// [Pulling an Image]: https://docs.aws.amazon.com/AmazonECR/latest/userguide/docker-pull-ecr-image.html
	DeployedImage *DeployedImage

	// The environment variables to set in the Docker container.
	Environment map[string]string

	noSmithyDocumentSerde
}

// Runtime settings for a model that is deployed with an inference component.
type InferenceComponentRuntimeConfig struct {

	// The number of runtime copies of the model container to deploy with the
	// inference component. Each copy can serve inference requests.
	//
	// This member is required.
	CopyCount *int32

	noSmithyDocumentSerde
}

// Details about the runtime settings for the model that is deployed with the
// inference component.
type InferenceComponentRuntimeConfigSummary struct {

	// The number of runtime copies of the model container that are currently deployed.
	CurrentCopyCount *int32

	// The number of runtime copies of the model container that you requested to
	// deploy with the inference component.
	DesiredCopyCount *int32

	noSmithyDocumentSerde
}

// Details about the resources to deploy with this inference component, including
// the model, container, and compute resources.
type InferenceComponentSpecification struct {

	// The compute resources allocated to run the model assigned to the inference
	// component.
	//
	// This member is required.
	ComputeResourceRequirements *InferenceComponentComputeResourceRequirements

	// Defines a container that provides the runtime environment for a model that you
	// deploy with an inference component.
	Container *InferenceComponentContainerSpecification

	// The name of an existing SageMaker model object in your account that you want to
	// deploy with the inference component.
	ModelName *string

	// Settings that take effect while the model container starts up.
	StartupParameters *InferenceComponentStartupParameters

	noSmithyDocumentSerde
}

// Details about the resources that are deployed with this inference component.
type InferenceComponentSpecificationSummary struct {

	// The compute resources allocated to run the model assigned to the inference
	// component.
	ComputeResourceRequirements *InferenceComponentComputeResourceRequirements

	// Details about the container that provides the runtime environment for the model
	// that is deployed with the inference component.
	Container *InferenceComponentContainerSpecificationSummary

	// The name of the SageMaker model object that is deployed with the inference
	// component.
	ModelName *string

	// Settings that take effect while the model container starts up.
	StartupParameters *InferenceComponentStartupParameters

	noSmithyDocumentSerde
}

// Settings that take effect while the model container starts up.
type InferenceComponentStartupParameters struct {

	// The timeout value, in seconds, for your inference container to pass health
	// check by Amazon S3 Hosting. For more information about health check, see [How Your Container Should Respond to Health Check (Ping) Requests].
	//
	// [How Your Container Should Respond to Health Check (Ping) Requests]: https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests
	ContainerStartupHealthCheckTimeoutInSeconds *int32

	// The timeout value, in seconds, to download and extract the model that you want
	// to host from Amazon S3 to the individual inference instance associated with this
	// inference component.
	ModelDataDownloadTimeoutInSeconds *int32

	noSmithyDocumentSerde
}

// A summary of the properties of an inference component.
type InferenceComponentSummary struct {

	// The time when the inference component was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the endpoint that hosts the inference
	// component.
	//
	// This member is required.
	EndpointArn *string

	// The name of the endpoint that hosts the inference component.
	//
	// This member is required.
	EndpointName *string

	// The Amazon Resource Name (ARN) of the inference component.
	//
	// This member is required.
	InferenceComponentArn *string

	// The name of the inference component.
	//
	// This member is required.
	InferenceComponentName *string

	// The time when the inference component was last updated.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The name of the production variant that hosts the inference component.
	//
	// This member is required.
	VariantName *string

	// The status of the inference component.
	InferenceComponentStatus InferenceComponentStatus

	noSmithyDocumentSerde
}

// Specifies details about how containers in a multi-container endpoint are run.
type InferenceExecutionConfig struct {

	// How containers in a multi-container are run. The following values are valid.
	//
	//   - SERIAL - Containers run as a serial pipeline.
	//
	//   - DIRECT - Only the individual container that you specify is run.
	//
	// This member is required.
	Mode InferenceExecutionMode

	noSmithyDocumentSerde
}

// The Amazon S3 location and configuration for storing inference request and
// response data.
type InferenceExperimentDataStorageConfig struct {

	// The Amazon S3 bucket where the inference request and response data is stored.
	//
	// This member is required.
	Destination *string

	// Configuration specifying how to treat different headers. If no headers are
	// specified Amazon SageMaker will by default base64 encode when capturing the
	// data.
	ContentType *CaptureContentTypeHeader

	//  The Amazon Web Services Key Management Service key that Amazon SageMaker uses
	// to encrypt captured data at rest using Amazon S3 server-side encryption.
	KmsKey *string

	noSmithyDocumentSerde
}

// The start and end times of an inference experiment.
//
// The maximum duration that you can set for an inference experiment is 30 days.
type InferenceExperimentSchedule struct {

	// The timestamp at which the inference experiment ended or will end.
	EndTime *time.Time

	// The timestamp at which the inference experiment started or will start.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// Lists a summary of properties of an inference experiment.
type InferenceExperimentSummary struct {

	// The timestamp at which the inference experiment was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The timestamp when you last modified the inference experiment.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The name of the inference experiment.
	//
	// This member is required.
	Name *string

	// The status of the inference experiment.
	//
	// This member is required.
	Status InferenceExperimentStatus

	// The type of the inference experiment.
	//
	// This member is required.
	Type InferenceExperimentType

	// The timestamp at which the inference experiment was completed.
	CompletionTime *time.Time

	// The description of the inference experiment.
	Description *string

	//  The ARN of the IAM role that Amazon SageMaker can assume to access model
	// artifacts and container images, and manage Amazon SageMaker Inference endpoints
	// for model deployment.
	RoleArn *string

	// The duration for which the inference experiment ran or will run.
	//
	// The maximum duration that you can set for an inference experiment is 30 days.
	Schedule *InferenceExperimentSchedule

	// The error message for the inference experiment status result.
	StatusReason *string

	noSmithyDocumentSerde
}

// The metrics for an existing endpoint compared in an Inference Recommender job.
type InferenceMetrics struct {

	// The expected maximum number of requests per minute for the instance.
	//
	// This member is required.
	MaxInvocations *int32

	// The expected model latency at maximum invocations per minute for the instance.
	//
	// This member is required.
	ModelLatency *int32

	noSmithyDocumentSerde
}

// A list of recommendations made by Amazon SageMaker Inference Recommender.
type InferenceRecommendation struct {

	// Defines the endpoint configuration parameters.
	//
	// This member is required.
	EndpointConfiguration *EndpointOutputConfiguration

	// The metrics used to decide what recommendation to make.
	//
	// This member is required.
	Metrics *RecommendationMetrics

	// Defines the model configuration.
	//
	// This member is required.
	ModelConfiguration *ModelConfiguration

	// A timestamp that shows when the benchmark completed.
	InvocationEndTime *time.Time

	// A timestamp that shows when the benchmark started.
	InvocationStartTime *time.Time

	// The recommendation ID which uniquely identifies each recommendation.
	RecommendationId *string

	noSmithyDocumentSerde
}

// A structure that contains a list of recommendation jobs.
type InferenceRecommendationsJob struct {

	// A timestamp that shows when the job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the recommendation job.
	//
	// This member is required.
	JobArn *string

	// The job description.
	//
	// This member is required.
	JobDescription *string

	// The name of the job.
	//
	// This member is required.
	JobName *string

	// The recommendation job type.
	//
	// This member is required.
	JobType RecommendationJobType

	// A timestamp that shows when the job was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to
	// perform tasks on your behalf.
	//
	// This member is required.
	RoleArn *string

	// The status of the job.
	//
	// This member is required.
	Status RecommendationJobStatus

	// A timestamp that shows when the job completed.
	CompletionTime *time.Time

	// If the job fails, provides information why the job failed.
	FailureReason *string

	// The name of the created model.
	ModelName *string

	// The Amazon Resource Name (ARN) of a versioned model package.
	ModelPackageVersionArn *string

	// The Amazon Simple Storage Service (Amazon S3) path where the sample payload is
	// stored. This path must point to a single gzip compressed tar archive (.tar.gz
	// suffix).
	SamplePayloadUrl *string

	noSmithyDocumentSerde
}

// A returned array object for the Steps response field in the [ListInferenceRecommendationsJobSteps] API command.
//
// [ListInferenceRecommendationsJobSteps]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListInferenceRecommendationsJobSteps.html
type InferenceRecommendationsJobStep struct {

	// The name of the Inference Recommender job.
	//
	// This member is required.
	JobName *string

	// The current status of the benchmark.
	//
	// This member is required.
	Status RecommendationJobStatus

	// The type of the subtask.
	//
	// BENCHMARK : Evaluate the performance of your model on different instance types.
	//
	// This member is required.
	StepType RecommendationStepType

	// The details for a specific benchmark.
	InferenceBenchmark *RecommendationJobInferenceBenchmark

	noSmithyDocumentSerde
}

// Defines how to perform inference generation after a training job is run.
type InferenceSpecification struct {

	// The Amazon ECR registry path of the Docker image that contains the inference
	// code.
	//
	// This member is required.
	Containers []ModelPackageContainerDefinition

	// The supported MIME types for the input data.
	SupportedContentTypes []string

	// A list of the instance types that are used to generate inferences in real-time.
	//
	// This parameter is required for unversioned models, and optional for versioned
	// models.
	SupportedRealtimeInferenceInstanceTypes []ProductionVariantInstanceType

	// The supported MIME types for the output data.
	SupportedResponseMIMETypes []string

	// A list of the instance types on which a transformation job can be run or on
	// which an endpoint can be deployed.
	//
	// This parameter is required for unversioned models, and optional for versioned
	// models.
	SupportedTransformInstanceTypes []TransformInstanceType

	noSmithyDocumentSerde
}

// Configuration information for the infrastructure health check of a training
// job. A SageMaker-provided health check tests the health of instance hardware and
// cluster network connectivity.
type InfraCheckConfig struct {

	// Enables an infrastructure health check.
	EnableInfraCheck *bool

	noSmithyDocumentSerde
}

// Contains information about the location of input model artifacts, the name and
// shape of the expected data inputs, and the framework in which the model was
// trained.
type InputConfig struct {

	// Identifies the framework in which the model was trained. For example:
	// TENSORFLOW.
	//
	// This member is required.
	Framework Framework

	// The S3 path where the model artifacts, which result from model training, are
	// stored. This path must point to a single gzip compressed tar archive (.tar.gz
	// suffix).
	//
	// This member is required.
	S3Uri *string

	// Specifies the name and shape of the expected data inputs for your trained model
	// with a JSON dictionary form. The data inputs are Framework specific.
	//
	//   - TensorFlow : You must specify the name and shape (NHWC format) of the
	//   expected data inputs using a dictionary format for your trained model. The
	//   dictionary formats required for the console and CLI are different.
	//
	//   - Examples for one input:
	//
	//   - If using the console, {"input":[1,1024,1024,3]}
	//
	//   - If using the CLI, {\"input\":[1,1024,1024,3]}
	//
	//   - Examples for two inputs:
	//
	//   - If using the console, {"data1": [1,28,28,1], "data2":[1,28,28,1]}
	//
	//   - If using the CLI, {\"data1\": [1,28,28,1], \"data2\":[1,28,28,1]}
	//
	//   - KERAS : You must specify the name and shape (NCHW format) of expected data
	//   inputs using a dictionary format for your trained model. Note that while Keras
	//   model artifacts should be uploaded in NHWC (channel-last) format,
	//   DataInputConfig should be specified in NCHW (channel-first) format. The
	//   dictionary formats required for the console and CLI are different.
	//
	//   - Examples for one input:
	//
	//   - If using the console, {"input_1":[1,3,224,224]}
	//
	//   - If using the CLI, {\"input_1\":[1,3,224,224]}
	//
	//   - Examples for two inputs:
	//
	//   - If using the console, {"input_1": [1,3,224,224], "input_2":[1,3,224,224]}
	//
	//   - If using the CLI, {\"input_1\": [1,3,224,224], \"input_2\":[1,3,224,224]}
	//
	//   - MXNET/ONNX/DARKNET : You must specify the name and shape (NCHW format) of
	//   the expected data inputs in order using a dictionary format for your trained
	//   model. The dictionary formats required for the console and CLI are different.
	//
	//   - Examples for one input:
	//
	//   - If using the console, {"data":[1,3,1024,1024]}
	//
	//   - If using the CLI, {\"data\":[1,3,1024,1024]}
	//
	//   - Examples for two inputs:
	//
	//   - If using the console, {"var1": [1,1,28,28], "var2":[1,1,28,28]}
	//
	//   - If using the CLI, {\"var1\": [1,1,28,28], \"var2\":[1,1,28,28]}
	//
	//   - PyTorch : You can either specify the name and shape (NCHW format) of
	//   expected data inputs in order using a dictionary format for your trained model
	//   or you can specify the shape only using a list format. The dictionary formats
	//   required for the console and CLI are different. The list formats for the console
	//   and CLI are the same.
	//
	//   - Examples for one input in dictionary format:
	//
	//   - If using the console, {"input0":[1,3,224,224]}
	//
	//   - If using the CLI, {\"input0\":[1,3,224,224]}
	//
	//   - Example for one input in list format: [[1,3,224,224]]
	//
	//   - Examples for two inputs in dictionary format:
	//
	//   - If using the console, {"input0":[1,3,224,224], "input1":[1,3,224,224]}
	//
	//   - If using the CLI, {\"input0\":[1,3,224,224], \"input1\":[1,3,224,224]}
	//
	//   - Example for two inputs in list format: [[1,3,224,224], [1,3,224,224]]
	//
	//   - XGBOOST : input data name and shape are not needed.
	//
	// DataInputConfig supports the following parameters for CoreML TargetDevice (ML
	// Model format):
	//
	//   - shape : Input shape, for example {"input_1": {"shape": [1,224,224,3]}} . In
	//   addition to static input shapes, CoreML converter supports Flexible input
	//   shapes:
	//
	//   - Range Dimension. You can use the Range Dimension feature if you know the
	//   input shape will be within some specific interval in that dimension, for
	//   example: {"input_1": {"shape": ["1..10", 224, 224, 3]}}
	//
	//   - Enumerated shapes. Sometimes, the models are trained to work only on a
	//   select set of inputs. You can enumerate all supported input shapes, for example:
	//   {"input_1": {"shape": [[1, 224, 224, 3], [1, 160, 160, 3]]}}
	//
	//   - default_shape : Default input shape. You can set a default shape during
	//   conversion for both Range Dimension and Enumerated Shapes. For example
	//   {"input_1": {"shape": ["1..10", 224, 224, 3], "default_shape": [1, 224, 224,
	//   3]}}
	//
	//   - type : Input type. Allowed values: Image and Tensor . By default, the
	//   converter generates an ML Model with inputs of type Tensor (MultiArray). User
	//   can set input type to be Image. Image input type requires additional input
	//   parameters such as bias and scale .
	//
	//   - bias : If the input type is an Image, you need to provide the bias vector.
	//
	//   - scale : If the input type is an Image, you need to provide a scale factor.
	//
	// CoreML ClassifierConfig parameters can be specified using [OutputConfig]CompilerOptions .
	// CoreML converter supports Tensorflow and PyTorch models. CoreML conversion
	// examples:
	//
	//   - Tensor type input:
	//
	//   - "DataInputConfig": {"input_1": {"shape": [[1,224,224,3], [1,160,160,3]],
	//   "default_shape": [1,224,224,3]}}
	//
	//   - Tensor type input without input name (PyTorch):
	//
	//   - "DataInputConfig": [{"shape": [[1,3,224,224], [1,3,160,160]],
	//   "default_shape": [1,3,224,224]}]
	//
	//   - Image type input:
	//
	//   - "DataInputConfig": {"input_1": {"shape": [[1,224,224,3], [1,160,160,3]],
	//   "default_shape": [1,224,224,3], "type": "Image", "bias": [-1,-1,-1], "scale":
	//   0.007843137255}}
	//
	//   - "CompilerOptions": {"class_labels": "imagenet_labels_1000.txt"}
	//
	//   - Image type input without input name (PyTorch):
	//
	//   - "DataInputConfig": [{"shape": [[1,3,224,224], [1,3,160,160]],
	//   "default_shape": [1,3,224,224], "type": "Image", "bias": [-1,-1,-1], "scale":
	//   0.007843137255}]
	//
	//   - "CompilerOptions": {"class_labels": "imagenet_labels_1000.txt"}
	//
	// Depending on the model format, DataInputConfig requires the following
	// parameters for ml_eia2[OutputConfig:TargetDevice] .
	//
	//   - For TensorFlow models saved in the SavedModel format, specify the input
	//   names from signature_def_key and the input model shapes for DataInputConfig .
	//   Specify the signature_def_key in [OutputConfig:CompilerOptions]OutputConfig:CompilerOptions if the model
	//   does not use TensorFlow's default signature def key. For example:
	//
	//   - "DataInputConfig": {"inputs": [1, 224, 224, 3]}
	//
	//   - "CompilerOptions": {"signature_def_key": "serving_custom"}
	//
	//   - For TensorFlow models saved as a frozen graph, specify the input tensor
	//   names and shapes in DataInputConfig and the output tensor names for
	//   output_names in [OutputConfig:CompilerOptions]OutputConfig:CompilerOptions . For example:
	//
	//   - "DataInputConfig": {"input_tensor:0": [1, 224, 224, 3]}
	//
	//   - "CompilerOptions": {"output_names": ["output_tensor:0"]}
	//
	// [OutputConfig:CompilerOptions]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html#sagemaker-Type-OutputConfig-CompilerOptions
	// [OutputConfig]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html
	// [OutputConfig:TargetDevice]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html#sagemaker-Type-OutputConfig-TargetDevice
	DataInputConfig *string

	// Specifies the framework version to use. This API field is only supported for
	// the MXNet, PyTorch, TensorFlow and TensorFlow Lite frameworks.
	//
	// For information about framework versions supported for cloud targets and edge
	// devices, see [Cloud Supported Instance Types and Frameworks]and [Edge Supported Frameworks].
	//
	// [Cloud Supported Instance Types and Frameworks]: https://docs.aws.amazon.com/sagemaker/latest/dg/neo-supported-cloud.html
	// [Edge Supported Frameworks]: https://docs.aws.amazon.com/sagemaker/latest/dg/neo-supported-devices-edge-frameworks.html
	FrameworkVersion *string

	noSmithyDocumentSerde
}

// Defines an instance group for heterogeneous cluster training. When requesting a
// training job using the [CreateTrainingJob]API, you can configure multiple instance groups .
//
// [CreateTrainingJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html
type InstanceGroup struct {

	// Specifies the number of instances of the instance group.
	//
	// This member is required.
	InstanceCount *int32

	// Specifies the name of the instance group.
	//
	// This member is required.
	InstanceGroupName *string

	// Specifies the instance type of the instance group.
	//
	// This member is required.
	InstanceType TrainingInstanceType

	noSmithyDocumentSerde
}

// Information on the IMDS configuration of the notebook instance
type InstanceMetadataServiceConfiguration struct {

	// Indicates the minimum IMDS version that the notebook instance supports. When
	// passed as part of CreateNotebookInstance , if no value is selected, then it
	// defaults to IMDSv1. This means that both IMDSv1 and IMDSv2 are supported. If
	// passed as part of UpdateNotebookInstance , there is no default.
	//
	// This member is required.
	MinimumInstanceMetadataServiceVersion *string

	noSmithyDocumentSerde
}

// For a hyperparameter of the integer type, specifies the range that a
// hyperparameter tuning job searches.
type IntegerParameterRange struct {

	// The maximum value of the hyperparameter to search.
	//
	// This member is required.
	MaxValue *string

	// The minimum value of the hyperparameter to search.
	//
	// This member is required.
	MinValue *string

	// The name of the hyperparameter to search.
	//
	// This member is required.
	Name *string

	// The scale that hyperparameter tuning uses to search the hyperparameter range.
	// For information about choosing a hyperparameter scale, see [Hyperparameter Scaling]. One of the
	// following values:
	//
	// Auto SageMaker hyperparameter tuning chooses the best scale for the
	// hyperparameter.
	//
	// Linear Hyperparameter tuning searches the values in the hyperparameter range by
	// using a linear scale.
	//
	// Logarithmic Hyperparameter tuning searches the values in the hyperparameter
	// range by using a logarithmic scale.
	//
	// Logarithmic scaling works only for ranges that have only values greater than 0.
	//
	// [Hyperparameter Scaling]: https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-ranges.html#scaling-type
	ScalingType HyperParameterScalingType

	noSmithyDocumentSerde
}

// Defines the possible values for an integer hyperparameter.
type IntegerParameterRangeSpecification struct {

	// The maximum integer value allowed.
	//
	// This member is required.
	MaxValue *string

	// The minimum integer value allowed.
	//
	// This member is required.
	MinValue *string

	noSmithyDocumentSerde
}

// The configuration for the file system and kernels in a SageMaker image running
// as a JupyterLab app. The FileSystemConfig object is not supported.
type JupyterLabAppImageConfig struct {

	// The configuration used to run the application image container.
	ContainerConfig *ContainerConfig

	// The Amazon Elastic File System storage configuration for a SageMaker image.
	FileSystemConfig *FileSystemConfig

	noSmithyDocumentSerde
}

// The settings for the JupyterLab application.
type JupyterLabAppSettings struct {

	// A list of Git repositories that SageMaker automatically displays to users for
	// cloning in the JupyterLab application.
	CodeRepositories []CodeRepository

	// A list of custom SageMaker images that are configured to run as a JupyterLab
	// app.
	CustomImages []CustomImage

	// Specifies the ARN's of a SageMaker image and SageMaker image version, and the
	// instance type that the version runs on.
	DefaultResourceSpec *ResourceSpec

	// The Amazon Resource Name (ARN) of the lifecycle configurations attached to the
	// user profile or domain. To remove a lifecycle config, you must set
	// LifecycleConfigArns to an empty list.
	LifecycleConfigArns []string

	noSmithyDocumentSerde
}

// The JupyterServer app settings.
type JupyterServerAppSettings struct {

	// A list of Git repositories that SageMaker automatically displays to users for
	// cloning in the JupyterServer application.
	CodeRepositories []CodeRepository

	// The default instance type and the Amazon Resource Name (ARN) of the default
	// SageMaker image used by the JupyterServer app. If you use the
	// LifecycleConfigArns parameter, then this parameter is also required.
	DefaultResourceSpec *ResourceSpec

	//  The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the
	// JupyterServerApp. If you use this parameter, the DefaultResourceSpec parameter
	// is also required.
	//
	// To remove a Lifecycle Config, you must set LifecycleConfigArns to an empty list.
	LifecycleConfigArns []string

	noSmithyDocumentSerde
}

// The Amazon SageMaker Canvas application setting where you configure document
// querying.
type KendraSettings struct {

	// Describes whether the document querying feature is enabled or disabled in the
	// Canvas application.
	Status FeatureStatus

	noSmithyDocumentSerde
}

// The KernelGateway app settings.
type KernelGatewayAppSettings struct {

	// A list of custom SageMaker images that are configured to run as a KernelGateway
	// app.
	CustomImages []CustomImage

	// The default instance type and the Amazon Resource Name (ARN) of the default
	// SageMaker image used by the KernelGateway app.
	//
	// The Amazon SageMaker Studio UI does not use the default instance type value set
	// here. The default instance type set here is used when Apps are created using the
	// CLI or CloudFormation and the instance type parameter value is not passed.
	DefaultResourceSpec *ResourceSpec

	//  The Amazon Resource Name (ARN) of the Lifecycle Configurations attached to the
	// the user profile or domain.
	//
	// To remove a Lifecycle Config, you must set LifecycleConfigArns to an empty list.
	LifecycleConfigArns []string

	noSmithyDocumentSerde
}

// The configuration for the file system and kernels in a SageMaker image running
// as a KernelGateway app.
type KernelGatewayImageConfig struct {

	// The specification of the Jupyter kernels in the image.
	//
	// This member is required.
	KernelSpecs []KernelSpec

	// The Amazon Elastic File System storage configuration for a SageMaker image.
	FileSystemConfig *FileSystemConfig

	noSmithyDocumentSerde
}

// The specification of a Jupyter kernel.
type KernelSpec struct {

	// The name of the Jupyter kernel in the image. This value is case sensitive.
	//
	// This member is required.
	Name *string

	// The display name of the kernel.
	DisplayName *string

	noSmithyDocumentSerde
}

// Provides a breakdown of the number of objects labeled.
type LabelCounters struct {

	// The total number of objects that could not be labeled due to an error.
	FailedNonRetryableError *int32

	// The total number of objects labeled by a human worker.
	HumanLabeled *int32

	// The total number of objects labeled by automated data labeling.
	MachineLabeled *int32

	// The total number of objects labeled.
	TotalLabeled *int32

	// The total number of objects not yet labeled.
	Unlabeled *int32

	noSmithyDocumentSerde
}

// Provides counts for human-labeled tasks in the labeling job.
type LabelCountersForWorkteam struct {

	// The total number of data objects labeled by a human worker.
	HumanLabeled *int32

	// The total number of data objects that need to be labeled by a human worker.
	PendingHuman *int32

	// The total number of tasks in the labeling job.
	Total *int32

	noSmithyDocumentSerde
}

// Provides configuration information for auto-labeling of your data objects. A
// LabelingJobAlgorithmsConfig object must be supplied in order to use
// auto-labeling.
type LabelingJobAlgorithmsConfig struct {

	// Specifies the Amazon Resource Name (ARN) of the algorithm used for
	// auto-labeling. You must select one of the following ARNs:
	//
	//   - Image classification
	//
	//   arn:aws:sagemaker:region:027400017018:labeling-job-algorithm-specification/image-classification
	//
	//   - Text classification
	//
	//   arn:aws:sagemaker:region:027400017018:labeling-job-algorithm-specification/text-classification
	//
	//   - Object detection
	//
	//   arn:aws:sagemaker:region:027400017018:labeling-job-algorithm-specification/object-detection
	//
	//   - Semantic Segmentation
	//
	//   arn:aws:sagemaker:region:027400017018:labeling-job-algorithm-specification/semantic-segmentation
	//
	// This member is required.
	LabelingJobAlgorithmSpecificationArn *string

	// At the end of an auto-label job Ground Truth sends the Amazon Resource Name
	// (ARN) of the final model used for auto-labeling. You can use this model as the
	// starting point for subsequent similar jobs by providing the ARN of the model
	// here.
	InitialActiveLearningModelArn *string

	// Provides configuration information for a labeling job.
	LabelingJobResourceConfig *LabelingJobResourceConfig

	noSmithyDocumentSerde
}

// Attributes of the data specified by the customer. Use these to describe the
// data to be labeled.
type LabelingJobDataAttributes struct {

	// Declares that your content is free of personally identifiable information or
	// adult content. SageMaker may restrict the Amazon Mechanical Turk workers that
	// can view your task based on this information.
	ContentClassifiers []ContentClassifier

	noSmithyDocumentSerde
}

// Provides information about the location of input data.
//
// You must specify at least one of the following: S3DataSource or SnsDataSource .
//
// Use SnsDataSource to specify an SNS input topic for a streaming labeling job.
// If you do not specify and SNS input topic ARN, Ground Truth will create a
// one-time labeling job.
//
// Use S3DataSource to specify an input manifest file for both streaming and
// one-time labeling jobs. Adding an S3DataSource is optional if you use
// SnsDataSource to create a streaming labeling job.
type LabelingJobDataSource struct {

	// The Amazon S3 location of the input data objects.
	S3DataSource *LabelingJobS3DataSource

	// An Amazon SNS data source used for streaming labeling jobs. To learn more, see [Send Data to a Streaming Labeling Job]
	// .
	//
	// [Send Data to a Streaming Labeling Job]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-send-data
	SnsDataSource *LabelingJobSnsDataSource

	noSmithyDocumentSerde
}

// Provides summary information for a work team.
type LabelingJobForWorkteamSummary struct {

	// The date and time that the labeling job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// A unique identifier for a labeling job. You can use this to refer to a specific
	// labeling job.
	//
	// This member is required.
	JobReferenceCode *string

	// The Amazon Web Services account ID of the account used to start the labeling
	// job.
	//
	// This member is required.
	WorkRequesterAccountId *string

	// Provides information about the progress of a labeling job.
	LabelCounters *LabelCountersForWorkteam

	// The name of the labeling job that the work team is assigned to.
	LabelingJobName *string

	// The configured number of workers per data object.
	NumberOfHumanWorkersPerDataObject *int32

	noSmithyDocumentSerde
}

// Input configuration information for a labeling job.
type LabelingJobInputConfig struct {

	// The location of the input data.
	//
	// This member is required.
	DataSource *LabelingJobDataSource

	// Attributes of the data specified by the customer.
	DataAttributes *LabelingJobDataAttributes

	noSmithyDocumentSerde
}

// Specifies the location of the output produced by the labeling job.
type LabelingJobOutput struct {

	// The Amazon S3 bucket location of the manifest file for labeled data.
	//
	// This member is required.
	OutputDatasetS3Uri *string

	// The Amazon Resource Name (ARN) for the most recent SageMaker model trained as
	// part of automated data labeling.
	FinalActiveLearningModelArn *string

	noSmithyDocumentSerde
}

// Output configuration information for a labeling job.
type LabelingJobOutputConfig struct {

	// The Amazon S3 location to write output data.
	//
	// This member is required.
	S3OutputPath *string

	// The Amazon Web Services Key Management Service ID of the key used to encrypt
	// the output data, if any.
	//
	// If you provide your own KMS key ID, you must add the required permissions to
	// your KMS key described in [Encrypt Output Data and Storage Volume with Amazon Web Services KMS].
	//
	// If you don't provide a KMS key ID, Amazon SageMaker uses the default Amazon Web
	// Services KMS key for Amazon S3 for your role's account to encrypt your output
	// data.
	//
	// If you use a bucket policy with an s3:PutObject permission that only allows
	// objects with server-side encryption, set the condition key of
	// s3:x-amz-server-side-encryption to "aws:kms" . For more information, see [KMS-Managed Encryption Keys] in
	// the Amazon Simple Storage Service Developer Guide.
	//
	// [Encrypt Output Data and Storage Volume with Amazon Web Services KMS]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security-permission.html#sms-security-kms-permissions
	// [KMS-Managed Encryption Keys]: https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html
	KmsKeyId *string

	// An Amazon Simple Notification Service (Amazon SNS) output topic ARN. Provide a
	// SnsTopicArn if you want to do real time chaining to another streaming job and
	// receive an Amazon SNS notifications each time a data object is submitted by a
	// worker.
	//
	// If you provide an SnsTopicArn in OutputConfig , when workers complete labeling
	// tasks, Ground Truth will send labeling task output data to the SNS output topic
	// you specify here.
	//
	// To learn more, see [Receive Output Data from a Streaming Labeling Job].
	//
	// [Receive Output Data from a Streaming Labeling Job]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-labeling-job.html#sms-streaming-how-it-works-output-data
	SnsTopicArn *string

	noSmithyDocumentSerde
}

// Configure encryption on the storage volume attached to the ML compute instance
// used to run automated data labeling model training and inference.
type LabelingJobResourceConfig struct {

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt data on the storage volume attached to the
	// ML compute instance(s) that run the training and inference jobs used for
	// automated data labeling.
	//
	// You can only specify a VolumeKmsKeyId when you create a labeling job with
	// automated data labeling enabled using the API operation CreateLabelingJob . You
	// cannot specify an Amazon Web Services KMS key to encrypt the storage volume used
	// for automated data labeling model training and inference when you create a
	// labeling job using the console. To learn more, see [Output Data and Storage Volume Encryption].
	//
	// The VolumeKmsKeyId can be any of the following formats:
	//
	//   - KMS Key ID
	//
	// "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//   - Amazon Resource Name (ARN) of a KMS Key
	//
	// "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	// [Output Data and Storage Volume Encryption]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-security.html
	VolumeKmsKeyId *string

	// Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs,
	// hosted models, and compute resources have access to. You can control access to
	// and from your resources by configuring a VPC. For more information, see [Give SageMaker Access to Resources in your Amazon VPC].
	//
	// [Give SageMaker Access to Resources in your Amazon VPC]: https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// The Amazon S3 location of the input data objects.
type LabelingJobS3DataSource struct {

	// The Amazon S3 location of the manifest file that describes the input data
	// objects.
	//
	// The input manifest file referenced in ManifestS3Uri must contain one of the
	// following keys: source-ref or source . The value of the keys are interpreted as
	// follows:
	//
	//   - source-ref : The source of the object is the Amazon S3 object specified in
	//   the value. Use this value when the object is a binary object, such as an image.
	//
	//   - source : The source of the object is the value. Use this value when the
	//   object is a text value.
	//
	// If you are a new user of Ground Truth, it is recommended you review [Use an Input Manifest File] in the
	// Amazon SageMaker Developer Guide to learn how to create an input manifest file.
	//
	// [Use an Input Manifest File]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-input-data-input-manifest.html
	//
	// This member is required.
	ManifestS3Uri *string

	noSmithyDocumentSerde
}

// An Amazon SNS data source used for streaming labeling jobs.
type LabelingJobSnsDataSource struct {

	// The Amazon SNS input topic Amazon Resource Name (ARN). Specify the ARN of the
	// input topic you will use to send new data objects to a streaming labeling job.
	//
	// This member is required.
	SnsTopicArn *string

	noSmithyDocumentSerde
}

// A set of conditions for stopping a labeling job. If any of the conditions are
// met, the job is automatically stopped. You can use these conditions to control
// the cost of data labeling.
//
// Labeling jobs fail after 30 days with an appropriate client error message.
type LabelingJobStoppingConditions struct {

	// The maximum number of objects that can be labeled by human workers.
	MaxHumanLabeledObjectCount *int32

	// The maximum number of input data objects that should be labeled.
	MaxPercentageOfInputDatasetLabeled *int32

	noSmithyDocumentSerde
}

// Provides summary information about a labeling job.
type LabelingJobSummary struct {

	// The date and time that the job was created (timestamp).
	//
	// This member is required.
	CreationTime *time.Time

	// Counts showing the progress of the labeling job.
	//
	// This member is required.
	LabelCounters *LabelCounters

	// The Amazon Resource Name (ARN) assigned to the labeling job when it was created.
	//
	// This member is required.
	LabelingJobArn *string

	// The name of the labeling job.
	//
	// This member is required.
	LabelingJobName *string

	// The current status of the labeling job.
	//
	// This member is required.
	LabelingJobStatus LabelingJobStatus

	// The date and time that the job was last modified (timestamp).
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of a Lambda function. The function is run before
	// each data object is sent to a worker.
	//
	// This member is required.
	PreHumanTaskLambdaArn *string

	// The Amazon Resource Name (ARN) of the work team assigned to the job.
	//
	// This member is required.
	WorkteamArn *string

	// The Amazon Resource Name (ARN) of the Lambda function used to consolidate the
	// annotations from individual workers into a label for a data object. For more
	// information, see [Annotation Consolidation].
	//
	// [Annotation Consolidation]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-annotation-consolidation.html
	AnnotationConsolidationLambdaArn *string

	// If the LabelingJobStatus field is Failed , this field contains a description of
	// the error.
	FailureReason *string

	// Input configuration for the labeling job.
	InputConfig *LabelingJobInputConfig

	// The location of the output produced by the labeling job.
	LabelingJobOutput *LabelingJobOutput

	noSmithyDocumentSerde
}

// Metadata for a Lambda step.
type LambdaStepMetadata struct {

	// The Amazon Resource Name (ARN) of the Lambda function that was run by this step
	// execution.
	Arn *string

	// A list of the output parameters of the Lambda step.
	OutputParameters []OutputParameter

	noSmithyDocumentSerde
}

// A value that indicates whether the update was successful.
type LastUpdateStatus struct {

	// A value that indicates whether the update was made successful.
	//
	// This member is required.
	Status LastUpdateStatusValue

	// If the update wasn't successful, indicates the reason why it failed.
	FailureReason *string

	noSmithyDocumentSerde
}

// Lists a summary of the properties of a lineage group. A lineage group provides
// a group of shareable lineage entity resources.
type LineageGroupSummary struct {

	// The creation time of the lineage group summary.
	CreationTime *time.Time

	// The display name of the lineage group summary.
	DisplayName *string

	// The last modified time of the lineage group summary.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the lineage group resource.
	LineageGroupArn *string

	// The name or Amazon Resource Name (ARN) of the lineage group.
	LineageGroupName *string

	noSmithyDocumentSerde
}

// Defines an Amazon Cognito or your own OIDC IdP user group that is part of a
// work team.
type MemberDefinition struct {

	// The Amazon Cognito user group that is part of the work team.
	CognitoMemberDefinition *CognitoMemberDefinition

	// A list user groups that exist in your OIDC Identity Provider (IdP). One to ten
	// groups can be used to create a single private work team. When you add a user
	// group to the list of Groups , you can add that user group to one or more private
	// work teams. If you add a user group to a private work team, all workers in that
	// user group are added to the work team.
	OidcMemberDefinition *OidcMemberDefinition

	noSmithyDocumentSerde
}

// Metadata properties of the tracking entity, trial, or trial component.
type MetadataProperties struct {

	// The commit ID.
	CommitId *string

	// The entity this entity was generated by.
	GeneratedBy *string

	// The project ID.
	ProjectId *string

	// The repository.
	Repository *string

	noSmithyDocumentSerde
}

// The name, value, and date and time of a metric that was emitted to Amazon
// CloudWatch.
type MetricData struct {

	// The name of the metric.
	MetricName *string

	// The date and time that the algorithm emitted the metric.
	Timestamp *time.Time

	// The value of the metric.
	Value *float32

	noSmithyDocumentSerde
}

// Information about the metric for a candidate produced by an AutoML job.
type MetricDatum struct {

	// The name of the metric.
	MetricName AutoMLMetricEnum

	// The dataset split from which the AutoML job produced the metric.
	Set MetricSetSource

	// The name of the standard metric.
	//
	// For definitions of the standard metrics, see [Autopilot candidate metrics]Autopilot candidate metrics .
	//
	// [Autopilot candidate metrics]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-metrics
	StandardMetricName AutoMLMetricExtendedEnum

	// The value of the metric.
	Value *float32

	noSmithyDocumentSerde
}

// Specifies a metric that the training algorithm writes to stderr or stdout . You
// can view these logs to understand how your training job performs and check for
// any errors encountered during training. SageMaker hyperparameter tuning captures
// all defined metrics. Specify one of the defined metrics to use as an objective
// metric using the [TuningObjective]parameter in the HyperParameterTrainingJobDefinition API to
// evaluate job performance during hyperparameter tuning.
//
// [TuningObjective]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_HyperParameterTrainingJobDefinition.html#sagemaker-Type-HyperParameterTrainingJobDefinition-TuningObjective
type MetricDefinition struct {

	// The name of the metric.
	//
	// This member is required.
	Name *string

	// A regular expression that searches the output of a training job and gets the
	// value of the metric. For more information about using regular expressions to
	// define metrics, see [Defining metrics and environment variables].
	//
	// [Defining metrics and environment variables]: https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-define-metrics-variables.html
	//
	// This member is required.
	Regex *string

	noSmithyDocumentSerde
}

// An object containing information about a metric.
//
// The following types satisfy this interface:
//
//	MetricSpecificationMemberCustomized
//	MetricSpecificationMemberPredefined
type MetricSpecification interface {
	isMetricSpecification()
}

// Information about a customized metric.
type MetricSpecificationMemberCustomized struct {
	Value CustomizedMetricSpecification

	noSmithyDocumentSerde
}

func (*MetricSpecificationMemberCustomized) isMetricSpecification() {}

// Information about a predefined metric.
type MetricSpecificationMemberPredefined struct {
	Value PredefinedMetricSpecification

	noSmithyDocumentSerde
}

func (*MetricSpecificationMemberPredefined) isMetricSpecification() {}

// Details about the metrics source.
type MetricsSource struct {

	// The metric source content type.
	//
	// This member is required.
	ContentType *string

	// The S3 URI for the metrics source.
	//
	// This member is required.
	S3Uri *string

	// The hash key used for the metrics source.
	ContentDigest *string

	noSmithyDocumentSerde
}

// The properties of a model as returned by the [Search] API.
//
// [Search]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html
type Model struct {

	// The containers in the inference pipeline.
	Containers []ContainerDefinition

	// A timestamp that indicates when the model was created.
	CreationTime *time.Time

	// A set of recommended deployment configurations for the model.
	DeploymentRecommendation *DeploymentRecommendation

	// Isolates the model container. No inbound or outbound network calls can be made
	// to or from the model container.
	EnableNetworkIsolation *bool

	// The Amazon Resource Name (ARN) of the IAM role that you specified for the model.
	ExecutionRoleArn *string

	// Specifies details about how containers in a multi-container endpoint are run.
	InferenceExecutionConfig *InferenceExecutionConfig

	// The Amazon Resource Name (ARN) of the model.
	ModelArn *string

	// The name of the model.
	ModelName *string

	// Describes the container, as part of model definition.
	PrimaryContainer *ContainerDefinition

	// A list of key-value pairs associated with the model. For more information, see [Tagging Amazon Web Services resources]
	// in the Amazon Web Services General Reference Guide.
	//
	// [Tagging Amazon Web Services resources]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
	Tags []Tag

	// Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs,
	// hosted models, and compute resources have access to. You can control access to
	// and from your resources by configuring a VPC. For more information, see [Give SageMaker Access to Resources in your Amazon VPC].
	//
	// [Give SageMaker Access to Resources in your Amazon VPC]: https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// The access configuration file to control access to the ML model. You can
// explicitly accept the model end-user license agreement (EULA) within the
// ModelAccessConfig .
//
//   - If you are a Jumpstart user, see the [End-user license agreements]section for more details on accepting
//     the EULA.
//
//   - If you are an AutoML user, see the Optional Parameters section of Create an
//     AutoML job to fine-tune text generation models using the API for details on [How to set the EULA acceptance when fine-tuning a model using the AutoML API].
//
// [End-user license agreements]: https://docs.aws.amazon.com/sagemaker/latest/dg/jumpstart-foundation-models-choose.html#jumpstart-foundation-models-choose-eula
// [How to set the EULA acceptance when fine-tuning a model using the AutoML API]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-create-experiment-finetune-llms.html#autopilot-llms-finetuning-api-optional-params
type ModelAccessConfig struct {

	// Specifies agreement to the model end-user license agreement (EULA). The
	// AcceptEula value must be explicitly defined as True in order to accept the EULA
	// that this model requires. You are responsible for reviewing and complying with
	// any applicable license terms and making sure they are acceptable for your use
	// case before downloading or using a model.
	//
	// This member is required.
	AcceptEula *bool

	noSmithyDocumentSerde
}

// Provides information about the location that is configured for storing model
// artifacts.
//
// Model artifacts are outputs that result from training a model. They typically
// consist of trained parameters, a model definition that describes how to compute
// inferences, and other metadata. A SageMaker container stores your trained model
// artifacts in the /opt/ml/model directory. After training has completed, by
// default, these artifacts are uploaded to your Amazon S3 bucket as compressed
// files.
type ModelArtifacts struct {

	// The path of the S3 object that contains the model artifacts. For example,
	// s3://bucket-name/keynameprefix/model.tar.gz .
	//
	// This member is required.
	S3ModelArtifacts *string

	noSmithyDocumentSerde
}

// Docker container image configuration object for the model bias job.
type ModelBiasAppSpecification struct {

	// JSON formatted S3 file that defines bias parameters. For more information on
	// this JSON configuration file, see [Configure bias parameters].
	//
	// [Configure bias parameters]: https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-config-json-monitor-bias-parameters.html
	//
	// This member is required.
	ConfigUri *string

	// The container image to be run by the model bias job.
	//
	// This member is required.
	ImageUri *string

	// Sets the environment variables in the Docker container.
	Environment map[string]string

	noSmithyDocumentSerde
}

// The configuration for a baseline model bias job.
type ModelBiasBaselineConfig struct {

	// The name of the baseline model bias job.
	BaseliningJobName *string

	// The constraints resource for a monitoring job.
	ConstraintsResource *MonitoringConstraintsResource

	noSmithyDocumentSerde
}

// Inputs for the model bias job.
type ModelBiasJobInput struct {

	// Location of ground truth labels to use in model bias job.
	//
	// This member is required.
	GroundTruthS3Input *MonitoringGroundTruthS3Input

	// Input object for the batch transform job.
	BatchTransformInput *BatchTransformInput

	// Input object for the endpoint
	EndpointInput *EndpointInput

	noSmithyDocumentSerde
}

// An Amazon SageMaker Model Card.
type ModelCard struct {

	// The content of the model card. Content uses the [model card JSON schema] and provided as a string.
	//
	// [model card JSON schema]: https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html#model-cards-json-schema
	Content *string

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	CreatedBy *UserContext

	// The date and time that the model card was created.
	CreationTime *time.Time

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	LastModifiedBy *UserContext

	// The date and time that the model card was last modified.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the model card.
	ModelCardArn *string

	// The unique name of the model card.
	ModelCardName *string

	// The approval status of the model card within your organization. Different
	// organizations might have different criteria for model card review and approval.
	//
	//   - Draft : The model card is a work in progress.
	//
	//   - PendingReview : The model card is pending review.
	//
	//   - Approved : The model card is approved.
	//
	//   - Archived : The model card is archived. No more updates should be made to the
	//   model card, but it can still be exported.
	ModelCardStatus ModelCardStatus

	// The version of the model card.
	ModelCardVersion *int32

	// The unique name (ID) of the model.
	ModelId *string

	// The model package group that contains the model package. Only relevant for
	// model cards created for model packages in the Amazon SageMaker Model Registry.
	ModelPackageGroupName *string

	// The risk rating of the model. Different organizations might have different
	// criteria for model card risk ratings. For more information, see [Risk ratings].
	//
	// [Risk ratings]: https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards-risk-rating.html
	RiskRating *string

	// The security configuration used to protect model card data.
	SecurityConfig *ModelCardSecurityConfig

	// Key-value pairs used to manage metadata for the model card.
	Tags []Tag

	noSmithyDocumentSerde
}

// The artifacts of the model card export job.
type ModelCardExportArtifacts struct {

	// The Amazon S3 URI of the exported model artifacts.
	//
	// This member is required.
	S3ExportArtifacts *string

	noSmithyDocumentSerde
}

// The summary of the Amazon SageMaker Model Card export job.
type ModelCardExportJobSummary struct {

	// The date and time that the model card export job was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The date and time that the model card export job was last modified..
	//
	// This member is required.
	LastModifiedAt *time.Time

	// The Amazon Resource Name (ARN) of the model card export job.
	//
	// This member is required.
	ModelCardExportJobArn *string

	// The name of the model card export job.
	//
	// This member is required.
	ModelCardExportJobName *string

	// The name of the model card that the export job exports.
	//
	// This member is required.
	ModelCardName *string

	// The version of the model card that the export job exports.
	//
	// This member is required.
	ModelCardVersion *int32

	// The completion status of the model card export job.
	//
	// This member is required.
	Status ModelCardExportJobStatus

	noSmithyDocumentSerde
}

// Configure the export output details for an Amazon SageMaker Model Card.
type ModelCardExportOutputConfig struct {

	// The Amazon S3 output path to export your model card PDF.
	//
	// This member is required.
	S3OutputPath *string

	noSmithyDocumentSerde
}

// Configure the security settings to protect model card data.
type ModelCardSecurityConfig struct {

	// A Key Management Service [key ID] to use for encrypting a model card.
	//
	// [key ID]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id
	KmsKeyId *string

	noSmithyDocumentSerde
}

// A summary of the model card.
type ModelCardSummary struct {

	// The date and time that the model card was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the model card.
	//
	// This member is required.
	ModelCardArn *string

	// The name of the model card.
	//
	// This member is required.
	ModelCardName *string

	// The approval status of the model card within your organization. Different
	// organizations might have different criteria for model card review and approval.
	//
	//   - Draft : The model card is a work in progress.
	//
	//   - PendingReview : The model card is pending review.
	//
	//   - Approved : The model card is approved.
	//
	//   - Archived : The model card is archived. No more updates should be made to the
	//   model card, but it can still be exported.
	//
	// This member is required.
	ModelCardStatus ModelCardStatus

	// The date and time that the model card was last modified.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// A summary of a specific version of the model card.
type ModelCardVersionSummary struct {

	// The date and time that the model card version was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the model card.
	//
	// This member is required.
	ModelCardArn *string

	// The name of the model card.
	//
	// This member is required.
	ModelCardName *string

	// The approval status of the model card version within your organization.
	// Different organizations might have different criteria for model card review and
	// approval.
	//
	//   - Draft : The model card is a work in progress.
	//
	//   - PendingReview : The model card is pending review.
	//
	//   - Approved : The model card is approved.
	//
	//   - Archived : The model card is archived. No more updates should be made to the
	//   model card, but it can still be exported.
	//
	// This member is required.
	ModelCardStatus ModelCardStatus

	// A version of the model card.
	//
	// This member is required.
	ModelCardVersion *int32

	// The time date and time that the model card version was last modified.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Configures the timeout and maximum number of retries for processing a transform
// job invocation.
type ModelClientConfig struct {

	// The maximum number of retries when invocation requests are failing. The default
	// value is 3.
	InvocationsMaxRetries *int32

	// The timeout value in seconds for an invocation request. The default value is
	// 600.
	InvocationsTimeoutInSeconds *int32

	noSmithyDocumentSerde
}

// Defines the model configuration. Includes the specification name and
// environment parameters.
type ModelConfiguration struct {

	// The name of the compilation job used to create the recommended model artifacts.
	CompilationJobName *string

	// Defines the environment parameters that includes key, value types, and values.
	EnvironmentParameters []EnvironmentParameter

	// The inference specification name in the model package version.
	InferenceSpecificationName *string

	noSmithyDocumentSerde
}

// An endpoint that hosts a model displayed in the Amazon SageMaker Model
// Dashboard.
type ModelDashboardEndpoint struct {

	// A timestamp that indicates when the endpoint was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// This member is required.
	EndpointArn *string

	// The endpoint name.
	//
	// This member is required.
	EndpointName *string

	// The endpoint status.
	//
	// This member is required.
	EndpointStatus EndpointStatus

	// The last time the endpoint was modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// An alert action taken to light up an icon on the Amazon SageMaker Model
// Dashboard when an alert goes into InAlert status.
type ModelDashboardIndicatorAction struct {

	// Indicates whether the alert action is turned on.
	Enabled *bool

	noSmithyDocumentSerde
}

// A model displayed in the Amazon SageMaker Model Dashboard.
type ModelDashboardModel struct {

	// The endpoints that host a model.
	Endpoints []ModelDashboardEndpoint

	// A batch transform job. For information about SageMaker batch transform, see [Use Batch Transform].
	//
	// [Use Batch Transform]: https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html
	LastBatchTransformJob *TransformJob

	// A model displayed in the Model Dashboard.
	Model *Model

	// The model card for a model.
	ModelCard *ModelDashboardModelCard

	// The monitoring schedules for a model.
	MonitoringSchedules []ModelDashboardMonitoringSchedule

	noSmithyDocumentSerde
}

// The model card for a model displayed in the Amazon SageMaker Model Dashboard.
type ModelDashboardModelCard struct {

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	CreatedBy *UserContext

	// A timestamp that indicates when the model card was created.
	CreationTime *time.Time

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	LastModifiedBy *UserContext

	// A timestamp that indicates when the model card was last updated.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) for a model card.
	ModelCardArn *string

	// The name of a model card.
	ModelCardName *string

	// The model card status.
	ModelCardStatus ModelCardStatus

	// The model card version.
	ModelCardVersion *int32

	// For models created in SageMaker, this is the model ARN. For models created
	// outside of SageMaker, this is a user-customized string.
	ModelId *string

	// A model card's risk rating. Can be low, medium, or high.
	RiskRating *string

	// The KMS Key ID ( KMSKeyId ) for encryption of model card information.
	SecurityConfig *ModelCardSecurityConfig

	// The tags associated with a model card.
	Tags []Tag

	noSmithyDocumentSerde
}

// A monitoring schedule for a model displayed in the Amazon SageMaker Model
// Dashboard.
type ModelDashboardMonitoringSchedule struct {

	// Input object for the batch transform job.
	BatchTransformInput *BatchTransformInput

	// A timestamp that indicates when the monitoring schedule was created.
	CreationTime *time.Time

	// The endpoint which is monitored.
	EndpointName *string

	// If a monitoring job failed, provides the reason.
	FailureReason *string

	// A timestamp that indicates when the monitoring schedule was last updated.
	LastModifiedTime *time.Time

	// Summary of information about the last monitoring job to run.
	LastMonitoringExecutionSummary *MonitoringExecutionSummary

	// A JSON array where each element is a summary for a monitoring alert.
	MonitoringAlertSummaries []MonitoringAlertSummary

	// The Amazon Resource Name (ARN) of a monitoring schedule.
	MonitoringScheduleArn *string

	// Configures the monitoring schedule and defines the monitoring job.
	MonitoringScheduleConfig *MonitoringScheduleConfig

	// The name of a monitoring schedule.
	MonitoringScheduleName *string

	// The status of the monitoring schedule.
	MonitoringScheduleStatus ScheduleStatus

	// The monitor type of a model monitor.
	MonitoringType MonitoringType

	noSmithyDocumentSerde
}

// Data quality constraints and statistics for a model.
type ModelDataQuality struct {

	// Data quality constraints for a model.
	Constraints *MetricsSource

	// Data quality statistics for a model.
	Statistics *MetricsSource

	noSmithyDocumentSerde
}

// Specifies the location of ML model data to deploy. If specified, you must
// specify one and only one of the available data sources.
type ModelDataSource struct {

	// Specifies the S3 location of ML model data to deploy.
	S3DataSource *S3ModelDataSource

	noSmithyDocumentSerde
}

// Specifies how to generate the endpoint name for an automatic one-click
// Autopilot model deployment.
type ModelDeployConfig struct {

	// Set to True to automatically generate an endpoint name for a one-click
	// Autopilot model deployment; set to False otherwise. The default value is False .
	//
	// If you set AutoGenerateEndpointName to True , do not specify the EndpointName ;
	// otherwise a 400 error is thrown.
	AutoGenerateEndpointName *bool

	// Specifies the endpoint name to use for a one-click Autopilot model deployment
	// if the endpoint name is not generated automatically.
	//
	// Specify the EndpointName if and only if you set AutoGenerateEndpointName to
	// False ; otherwise a 400 error is thrown.
	EndpointName *string

	noSmithyDocumentSerde
}

// Provides information about the endpoint of the model deployment.
type ModelDeployResult struct {

	// The name of the endpoint to which the model has been deployed.
	//
	// If model deployment fails, this field is omitted from the response.
	EndpointName *string

	noSmithyDocumentSerde
}

// Provides information to verify the integrity of stored model artifacts.
type ModelDigests struct {

	// Provides a hash value that uniquely identifies the stored model artifacts.
	ArtifactDigest *string

	noSmithyDocumentSerde
}

// Docker container image configuration object for the model explainability job.
type ModelExplainabilityAppSpecification struct {

	// JSON formatted Amazon S3 file that defines explainability parameters. For more
	// information on this JSON configuration file, see [Configure model explainability parameters].
	//
	// [Configure model explainability parameters]: https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-config-json-monitor-model-explainability-parameters.html
	//
	// This member is required.
	ConfigUri *string

	// The container image to be run by the model explainability job.
	//
	// This member is required.
	ImageUri *string

	// Sets the environment variables in the Docker container.
	Environment map[string]string

	noSmithyDocumentSerde
}

// The configuration for a baseline model explainability job.
type ModelExplainabilityBaselineConfig struct {

	// The name of the baseline model explainability job.
	BaseliningJobName *string

	// The constraints resource for a monitoring job.
	ConstraintsResource *MonitoringConstraintsResource

	noSmithyDocumentSerde
}

// Inputs for the model explainability job.
type ModelExplainabilityJobInput struct {

	// Input object for the batch transform job.
	BatchTransformInput *BatchTransformInput

	// Input object for the endpoint
	EndpointInput *EndpointInput

	noSmithyDocumentSerde
}

// The configuration for the infrastructure that the model will be deployed to.
type ModelInfrastructureConfig struct {

	// The inference option to which to deploy your model. Possible values are the
	// following:
	//
	//   - RealTime : Deploy to real-time inference.
	//
	// This member is required.
	InfrastructureType ModelInfrastructureType

	// The infrastructure configuration for deploying the model to real-time inference.
	//
	// This member is required.
	RealTimeInferenceConfig *RealTimeInferenceConfig

	noSmithyDocumentSerde
}

// Input object for the model.
type ModelInput struct {

	// The input configuration object for the model.
	//
	// This member is required.
	DataInputConfig *string

	noSmithyDocumentSerde
}

// The model latency threshold.
type ModelLatencyThreshold struct {

	// The model latency percentile threshold. Acceptable values are P95 and P99 . For
	// custom load tests, specify the value as P95 .
	Percentile *string

	// The model latency percentile value in milliseconds.
	ValueInMilliseconds *int32

	noSmithyDocumentSerde
}

// Part of the search expression. You can specify the name and value (domain,
// task, framework, framework version, task, and model).
type ModelMetadataFilter struct {

	// The name of the of the model to filter by.
	//
	// This member is required.
	Name ModelMetadataFilterType

	// The value to filter the model metadata.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// One or more filters that searches for the specified resource or resources in a
// search. All resource objects that satisfy the expression's condition are
// included in the search results
type ModelMetadataSearchExpression struct {

	// A list of filter objects.
	Filters []ModelMetadataFilter

	noSmithyDocumentSerde
}

// A summary of the model metadata.
type ModelMetadataSummary struct {

	// The machine learning domain of the model.
	//
	// This member is required.
	Domain *string

	// The machine learning framework of the model.
	//
	// This member is required.
	Framework *string

	// The framework version of the model.
	//
	// This member is required.
	FrameworkVersion *string

	// The name of the model.
	//
	// This member is required.
	Model *string

	// The machine learning task of the model.
	//
	// This member is required.
	Task *string

	noSmithyDocumentSerde
}

// Contains metrics captured from a model.
type ModelMetrics struct {

	// Metrics that measure bias in a model.
	Bias *Bias

	// Metrics that help explain a model.
	Explainability *Explainability

	// Metrics that measure the quality of the input data for a model.
	ModelDataQuality *ModelDataQuality

	// Metrics that measure the quality of a model.
	ModelQuality *ModelQuality

	noSmithyDocumentSerde
}

// A versioned model that can be deployed for SageMaker inference.
type ModelPackage struct {

	// An array of additional Inference Specification objects.
	AdditionalInferenceSpecifications []AdditionalInferenceSpecificationDefinition

	// A description provided when the model approval is set.
	ApprovalDescription *string

	// Whether the model package is to be certified to be listed on Amazon Web
	// Services Marketplace. For information about listing model packages on Amazon Web
	// Services Marketplace, see [List Your Algorithm or Model Package on Amazon Web Services Marketplace].
	//
	// [List Your Algorithm or Model Package on Amazon Web Services Marketplace]: https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html
	CertifyForMarketplace *bool

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	CreatedBy *UserContext

	// The time that the model package was created.
	CreationTime *time.Time

	// The metadata properties for the model package.
	CustomerMetadataProperties map[string]string

	// The machine learning domain of your model package and its components. Common
	// machine learning domains include computer vision and natural language
	// processing.
	Domain *string

	// Represents the drift check baselines that can be used when the model monitor is
	// set using the model package.
	DriftCheckBaselines *DriftCheckBaselines

	// Defines how to perform inference generation after a training job is run.
	InferenceSpecification *InferenceSpecification

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, or project.
	LastModifiedBy *UserContext

	// The last time the model package was modified.
	LastModifiedTime *time.Time

	// Metadata properties of the tracking entity, trial, or trial component.
	MetadataProperties *MetadataProperties

	// The approval status of the model. This can be one of the following values.
	//
	//   - APPROVED - The model is approved
	//
	//   - REJECTED - The model is rejected.
	//
	//   - PENDING_MANUAL_APPROVAL - The model is waiting for manual approval.
	ModelApprovalStatus ModelApprovalStatus

	// Metrics for the model.
	ModelMetrics *ModelMetrics

	// The Amazon Resource Name (ARN) of the model package.
	ModelPackageArn *string

	// The description of the model package.
	ModelPackageDescription *string

	// The model group to which the model belongs.
	ModelPackageGroupName *string

	// The name of the model.
	ModelPackageName *string

	// The status of the model package. This can be one of the following values.
	//
	//   - PENDING - The model package is pending being created.
	//
	//   - IN_PROGRESS - The model package is in the process of being created.
	//
	//   - COMPLETED - The model package was successfully created.
	//
	//   - FAILED - The model package failed.
	//
	//   - DELETING - The model package is in the process of being deleted.
	ModelPackageStatus ModelPackageStatus

	// Specifies the validation and image scan statuses of the model package.
	ModelPackageStatusDetails *ModelPackageStatusDetails

	// The version number of a versioned model.
	ModelPackageVersion *int32

	// The Amazon Simple Storage Service path where the sample payload are stored.
	// This path must point to a single gzip compressed tar archive (.tar.gz suffix).
	SamplePayloadUrl *string

	// Indicates if you want to skip model validation.
	SkipModelValidation SkipModelValidation

	// A list of algorithms that were used to create a model package.
	SourceAlgorithmSpecification *SourceAlgorithmSpecification

	// The URI of the source for the model package.
	SourceUri *string

	// A list of the tags associated with the model package. For more information, see [Tagging Amazon Web Services resources]
	// in the Amazon Web Services General Reference Guide.
	//
	// [Tagging Amazon Web Services resources]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
	Tags []Tag

	// The machine learning task your model package accomplishes. Common machine
	// learning tasks include object detection and image classification.
	Task *string

	// Specifies batch transform jobs that SageMaker runs to validate your model
	// package.
	ValidationSpecification *ModelPackageValidationSpecification

	noSmithyDocumentSerde
}

// Describes the Docker container for the model package.
type ModelPackageContainerDefinition struct {

	// The Amazon EC2 Container Registry (Amazon ECR) path where inference code is
	// stored.
	//
	// If you are using your own custom algorithm instead of an algorithm provided by
	// SageMaker, the inference code must meet SageMaker requirements. SageMaker
	// supports both registry/repository[:tag] and registry/repository[@digest] image
	// path formats. For more information, see [Using Your Own Algorithms with Amazon SageMaker].
	//
	// [Using Your Own Algorithms with Amazon SageMaker]: https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html
	//
	// This member is required.
	Image *string

	// The additional data source that is used during inference in the Docker
	// container for your model package.
	AdditionalS3DataSource *AdditionalS3DataSource

	// The DNS host name for the Docker container.
	ContainerHostname *string

	// The environment variables to set in the Docker container. Each key and value in
	// the Environment string to string map can have length of up to 1024. We support
	// up to 16 entries in the map.
	Environment map[string]string

	// The machine learning framework of the model package container image.
	Framework *string

	// The framework version of the Model Package Container Image.
	FrameworkVersion *string

	// An MD5 hash of the training algorithm that identifies the Docker image used for
	// training.
	ImageDigest *string

	// Specifies the location of ML model data to deploy during endpoint creation.
	ModelDataSource *ModelDataSource

	// The Amazon S3 path where the model artifacts, which result from model training,
	// are stored. This path must point to a single gzip compressed tar archive (
	// .tar.gz suffix).
	//
	// The model artifacts must be in an S3 bucket that is in the same region as the
	// model package.
	ModelDataUrl *string

	// A structure with Model Input details.
	ModelInput *ModelInput

	// The name of a pre-trained machine learning benchmarked by Amazon SageMaker
	// Inference Recommender model that matches your model. You can find a list of
	// benchmarked models by calling ListModelMetadata .
	NearestModelName *string

	// The Amazon Web Services Marketplace product ID of the model package.
	ProductId *string

	noSmithyDocumentSerde
}

// A group of versioned models in the model registry.
type ModelPackageGroup struct {

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	CreatedBy *UserContext

	// The time that the model group was created.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the model group.
	ModelPackageGroupArn *string

	// The description for the model group.
	ModelPackageGroupDescription *string

	// The name of the model group.
	ModelPackageGroupName *string

	// The status of the model group. This can be one of the following values.
	//
	//   - PENDING - The model group is pending being created.
	//
	//   - IN_PROGRESS - The model group is in the process of being created.
	//
	//   - COMPLETED - The model group was successfully created.
	//
	//   - FAILED - The model group failed.
	//
	//   - DELETING - The model group is in the process of being deleted.
	//
	//   - DELETE_FAILED - SageMaker failed to delete the model group.
	ModelPackageGroupStatus ModelPackageGroupStatus

	// A list of the tags associated with the model group. For more information, see [Tagging Amazon Web Services resources]
	// in the Amazon Web Services General Reference Guide.
	//
	// [Tagging Amazon Web Services resources]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
	Tags []Tag

	noSmithyDocumentSerde
}

// Summary information about a model group.
type ModelPackageGroupSummary struct {

	// The time that the model group was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the model group.
	//
	// This member is required.
	ModelPackageGroupArn *string

	// The name of the model group.
	//
	// This member is required.
	ModelPackageGroupName *string

	// The status of the model group.
	//
	// This member is required.
	ModelPackageGroupStatus ModelPackageGroupStatus

	// A description of the model group.
	ModelPackageGroupDescription *string

	noSmithyDocumentSerde
}

// Specifies the validation and image scan statuses of the model package.
type ModelPackageStatusDetails struct {

	// The validation status of the model package.
	//
	// This member is required.
	ValidationStatuses []ModelPackageStatusItem

	// The status of the scan of the Docker image container for the model package.
	ImageScanStatuses []ModelPackageStatusItem

	noSmithyDocumentSerde
}

// Represents the overall status of a model package.
type ModelPackageStatusItem struct {

	// The name of the model package for which the overall status is being reported.
	//
	// This member is required.
	Name *string

	// The current status.
	//
	// This member is required.
	Status DetailedModelPackageStatus

	// if the overall status is Failed , the reason for the failure.
	FailureReason *string

	noSmithyDocumentSerde
}

// Provides summary information about a model package.
type ModelPackageSummary struct {

	// A timestamp that shows when the model package was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the model package.
	//
	// This member is required.
	ModelPackageArn *string

	// The overall status of the model package.
	//
	// This member is required.
	ModelPackageStatus ModelPackageStatus

	// The approval status of the model. This can be one of the following values.
	//
	//   - APPROVED - The model is approved
	//
	//   - REJECTED - The model is rejected.
	//
	//   - PENDING_MANUAL_APPROVAL - The model is waiting for manual approval.
	ModelApprovalStatus ModelApprovalStatus

	// A brief description of the model package.
	ModelPackageDescription *string

	// If the model package is a versioned model, the model group that the versioned
	// model belongs to.
	ModelPackageGroupName *string

	// The name of the model package.
	ModelPackageName *string

	// If the model package is a versioned model, the version of the model.
	ModelPackageVersion *int32

	noSmithyDocumentSerde
}

// Contains data, such as the inputs and targeted instance types that are used in
// the process of validating the model package.
//
// The data provided in the validation profile is made available to your buyers on
// Amazon Web Services Marketplace.
type ModelPackageValidationProfile struct {

	// The name of the profile for the model package.
	//
	// This member is required.
	ProfileName *string

	// The TransformJobDefinition object that describes the transform job used for the
	// validation of the model package.
	//
	// This member is required.
	TransformJobDefinition *TransformJobDefinition

	noSmithyDocumentSerde
}

// Specifies batch transform jobs that SageMaker runs to validate your model
// package.
type ModelPackageValidationSpecification struct {

	// An array of ModelPackageValidationProfile objects, each of which specifies a
	// batch transform job that SageMaker runs to validate your model package.
	//
	// This member is required.
	ValidationProfiles []ModelPackageValidationProfile

	// The IAM roles to be used for the validation of the model package.
	//
	// This member is required.
	ValidationRole *string

	noSmithyDocumentSerde
}

// Model quality statistics and constraints.
type ModelQuality struct {

	// Model quality constraints.
	Constraints *MetricsSource

	// Model quality statistics.
	Statistics *MetricsSource

	noSmithyDocumentSerde
}

// Container image configuration object for the monitoring job.
type ModelQualityAppSpecification struct {

	// The address of the container image that the monitoring job runs.
	//
	// This member is required.
	ImageUri *string

	// An array of arguments for the container used to run the monitoring job.
	ContainerArguments []string

	// Specifies the entrypoint for a container that the monitoring job runs.
	ContainerEntrypoint []string

	// Sets the environment variables in the container that the monitoring job runs.
	Environment map[string]string

	// An Amazon S3 URI to a script that is called after analysis has been performed.
	// Applicable only for the built-in (first party) containers.
	PostAnalyticsProcessorSourceUri *string

	// The machine learning problem type of the model that the monitoring job monitors.
	ProblemType MonitoringProblemType

	// An Amazon S3 URI to a script that is called per row prior to running analysis.
	// It can base64 decode the payload and convert it into a flattened JSON so that
	// the built-in container can use the converted data. Applicable only for the
	// built-in (first party) containers.
	RecordPreprocessorSourceUri *string

	noSmithyDocumentSerde
}

// Configuration for monitoring constraints and monitoring statistics. These
// baseline resources are compared against the results of the current job from the
// series of jobs scheduled to collect data periodically.
type ModelQualityBaselineConfig struct {

	// The name of the job that performs baselining for the monitoring job.
	BaseliningJobName *string

	// The constraints resource for a monitoring job.
	ConstraintsResource *MonitoringConstraintsResource

	noSmithyDocumentSerde
}

// The input for the model quality monitoring job. Currently endpoints are
// supported for input for model quality monitoring jobs.
type ModelQualityJobInput struct {

	// The ground truth label provided for the model.
	//
	// This member is required.
	GroundTruthS3Input *MonitoringGroundTruthS3Input

	// Input object for the batch transform job.
	BatchTransformInput *BatchTransformInput

	// Input object for the endpoint
	EndpointInput *EndpointInput

	noSmithyDocumentSerde
}

// The model registry settings for the SageMaker Canvas application.
type ModelRegisterSettings struct {

	// The Amazon Resource Name (ARN) of the SageMaker model registry account.
	// Required only to register model versions created by a different SageMaker Canvas
	// Amazon Web Services account than the Amazon Web Services account in which
	// SageMaker model registry is set up.
	CrossAccountModelRegisterRoleArn *string

	// Describes whether the integration to the model registry is enabled or disabled
	// in the Canvas application.
	Status FeatureStatus

	noSmithyDocumentSerde
}

// Metadata for Model steps.
type ModelStepMetadata struct {

	// The Amazon Resource Name (ARN) of the created model.
	Arn *string

	noSmithyDocumentSerde
}

// Provides summary information about a model.
type ModelSummary struct {

	// A timestamp that indicates when the model was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the model.
	//
	// This member is required.
	ModelArn *string

	// The name of the model that you want a summary for.
	//
	// This member is required.
	ModelName *string

	noSmithyDocumentSerde
}

// Contains information about the deployment options of a model.
type ModelVariantConfig struct {

	// The configuration for the infrastructure that the model will be deployed to.
	//
	// This member is required.
	InfrastructureConfig *ModelInfrastructureConfig

	// The name of the Amazon SageMaker Model entity.
	//
	// This member is required.
	ModelName *string

	// The name of the variant.
	//
	// This member is required.
	VariantName *string

	noSmithyDocumentSerde
}

// Summary of the deployment configuration of a model.
type ModelVariantConfigSummary struct {

	// The configuration of the infrastructure that the model has been deployed to.
	//
	// This member is required.
	InfrastructureConfig *ModelInfrastructureConfig

	// The name of the Amazon SageMaker Model entity.
	//
	// This member is required.
	ModelName *string

	// The status of deployment for the model variant on the hosted inference endpoint.
	//
	//   - Creating - Amazon SageMaker is preparing the model variant on the hosted
	//   inference endpoint.
	//
	//   - InService - The model variant is running on the hosted inference endpoint.
	//
	//   - Updating - Amazon SageMaker is updating the model variant on the hosted
	//   inference endpoint.
	//
	//   - Deleting - Amazon SageMaker is deleting the model variant on the hosted
	//   inference endpoint.
	//
	//   - Deleted - The model variant has been deleted on the hosted inference
	//   endpoint. This can only happen after stopping the experiment.
	//
	// This member is required.
	Status ModelVariantStatus

	// The name of the variant.
	//
	// This member is required.
	VariantName *string

	noSmithyDocumentSerde
}

// A list of alert actions taken in response to an alert going into InAlert status.
type MonitoringAlertActions struct {

	// An alert action taken to light up an icon on the Model Dashboard when an alert
	// goes into InAlert status.
	ModelDashboardIndicator *ModelDashboardIndicatorAction

	noSmithyDocumentSerde
}

// Provides summary information of an alert's history.
type MonitoringAlertHistorySummary struct {

	// The current alert status of an alert.
	//
	// This member is required.
	AlertStatus MonitoringAlertStatus

	// A timestamp that indicates when the first alert transition occurred in an alert
	// history. An alert transition can be from status InAlert to OK , or from OK to
	// InAlert .
	//
	// This member is required.
	CreationTime *time.Time

	// The name of a monitoring alert.
	//
	// This member is required.
	MonitoringAlertName *string

	// The name of a monitoring schedule.
	//
	// This member is required.
	MonitoringScheduleName *string

	noSmithyDocumentSerde
}

// Provides summary information about a monitor alert.
type MonitoringAlertSummary struct {

	// A list of alert actions taken in response to an alert going into InAlert status.
	//
	// This member is required.
	Actions *MonitoringAlertActions

	// The current status of an alert.
	//
	// This member is required.
	AlertStatus MonitoringAlertStatus

	// A timestamp that indicates when a monitor alert was created.
	//
	// This member is required.
	CreationTime *time.Time

	// Within EvaluationPeriod , how many execution failures will raise an alert.
	//
	// This member is required.
	DatapointsToAlert *int32

	// The number of most recent monitoring executions to consider when evaluating
	// alert status.
	//
	// This member is required.
	EvaluationPeriod *int32

	// A timestamp that indicates when a monitor alert was last updated.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The name of a monitoring alert.
	//
	// This member is required.
	MonitoringAlertName *string

	noSmithyDocumentSerde
}

// Container image configuration object for the monitoring job.
type MonitoringAppSpecification struct {

	// The container image to be run by the monitoring job.
	//
	// This member is required.
	ImageUri *string

	// An array of arguments for the container used to run the monitoring job.
	ContainerArguments []string

	// Specifies the entrypoint for a container used to run the monitoring job.
	ContainerEntrypoint []string

	// An Amazon S3 URI to a script that is called after analysis has been performed.
	// Applicable only for the built-in (first party) containers.
	PostAnalyticsProcessorSourceUri *string

	// An Amazon S3 URI to a script that is called per row prior to running analysis.
	// It can base64 decode the payload and convert it into a flattened JSON so that
	// the built-in container can use the converted data. Applicable only for the
	// built-in (first party) containers.
	RecordPreprocessorSourceUri *string

	noSmithyDocumentSerde
}

// Configuration for monitoring constraints and monitoring statistics. These
// baseline resources are compared against the results of the current job from the
// series of jobs scheduled to collect data periodically.
type MonitoringBaselineConfig struct {

	// The name of the job that performs baselining for the monitoring job.
	BaseliningJobName *string

	// The baseline constraint file in Amazon S3 that the current monitoring job
	// should validated against.
	ConstraintsResource *MonitoringConstraintsResource

	// The baseline statistics file in Amazon S3 that the current monitoring job
	// should be validated against.
	StatisticsResource *MonitoringStatisticsResource

	noSmithyDocumentSerde
}

// Configuration for the cluster used to run model monitoring jobs.
type MonitoringClusterConfig struct {

	// The number of ML compute instances to use in the model monitoring job. For
	// distributed processing jobs, specify a value greater than 1. The default value
	// is 1.
	//
	// This member is required.
	InstanceCount *int32

	// The ML compute instance type for the processing job.
	//
	// This member is required.
	InstanceType ProcessingInstanceType

	// The size of the ML storage volume, in gigabytes, that you want to provision.
	// You must specify sufficient ML storage for your scenario.
	//
	// This member is required.
	VolumeSizeInGB *int32

	// The Key Management Service (KMS) key that Amazon SageMaker uses to encrypt data
	// on the storage volume attached to the ML compute instance(s) that run the model
	// monitoring job.
	VolumeKmsKeyId *string

	noSmithyDocumentSerde
}

// The constraints resource for a monitoring job.
type MonitoringConstraintsResource struct {

	// The Amazon S3 URI for the constraints resource.
	S3Uri *string

	noSmithyDocumentSerde
}

// Represents the CSV dataset format used when running a monitoring job.
type MonitoringCsvDatasetFormat struct {

	// Indicates if the CSV data has a header.
	Header *bool

	noSmithyDocumentSerde
}

// Represents the dataset format used when running a monitoring job.
type MonitoringDatasetFormat struct {

	// The CSV dataset used in the monitoring job.
	Csv *MonitoringCsvDatasetFormat

	// The JSON dataset used in the monitoring job
	Json *MonitoringJsonDatasetFormat

	// The Parquet dataset used in the monitoring job
	Parquet *MonitoringParquetDatasetFormat

	noSmithyDocumentSerde
}

// Summary of information about the last monitoring job to run.
type MonitoringExecutionSummary struct {

	// The time at which the monitoring job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// A timestamp that indicates the last time the monitoring job was modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The status of the monitoring job.
	//
	// This member is required.
	MonitoringExecutionStatus ExecutionStatus

	// The name of the monitoring schedule.
	//
	// This member is required.
	MonitoringScheduleName *string

	// The time the monitoring job was scheduled.
	//
	// This member is required.
	ScheduledTime *time.Time

	// The name of the endpoint used to run the monitoring job.
	EndpointName *string

	// Contains the reason a monitoring job failed, if it failed.
	FailureReason *string

	// The name of the monitoring job.
	MonitoringJobDefinitionName *string

	// The type of the monitoring job.
	MonitoringType MonitoringType

	// The Amazon Resource Name (ARN) of the monitoring job.
	ProcessingJobArn *string

	noSmithyDocumentSerde
}

// The ground truth labels for the dataset used for the monitoring job.
type MonitoringGroundTruthS3Input struct {

	// The address of the Amazon S3 location of the ground truth labels.
	S3Uri *string

	noSmithyDocumentSerde
}

// The inputs for a monitoring job.
type MonitoringInput struct {

	// Input object for the batch transform job.
	BatchTransformInput *BatchTransformInput

	// The endpoint for a monitoring job.
	EndpointInput *EndpointInput

	noSmithyDocumentSerde
}

// Defines the monitoring job.
type MonitoringJobDefinition struct {

	// Configures the monitoring job to run a specified Docker container image.
	//
	// This member is required.
	MonitoringAppSpecification *MonitoringAppSpecification

	// The array of inputs for the monitoring job. Currently we support monitoring an
	// Amazon SageMaker Endpoint.
	//
	// This member is required.
	MonitoringInputs []MonitoringInput

	// The array of outputs from the monitoring job to be uploaded to Amazon S3.
	//
	// This member is required.
	MonitoringOutputConfig *MonitoringOutputConfig

	// Identifies the resources, ML compute instances, and ML storage volumes to
	// deploy for a monitoring job. In distributed processing, you specify more than
	// one instance.
	//
	// This member is required.
	MonitoringResources *MonitoringResources

	// The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume
	// to perform tasks on your behalf.
	//
	// This member is required.
	RoleArn *string

	// Baseline configuration used to validate that the data conforms to the specified
	// constraints and statistics
	BaselineConfig *MonitoringBaselineConfig

	// Sets the environment variables in the Docker container.
	Environment map[string]string

	// Specifies networking options for an monitoring job.
	NetworkConfig *NetworkConfig

	// Specifies a time limit for how long the monitoring job is allowed to run.
	StoppingCondition *MonitoringStoppingCondition

	noSmithyDocumentSerde
}

// Summary information about a monitoring job.
type MonitoringJobDefinitionSummary struct {

	// The time that the monitoring job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The name of the endpoint that the job monitors.
	//
	// This member is required.
	EndpointName *string

	// The Amazon Resource Name (ARN) of the monitoring job.
	//
	// This member is required.
	MonitoringJobDefinitionArn *string

	// The name of the monitoring job.
	//
	// This member is required.
	MonitoringJobDefinitionName *string

	noSmithyDocumentSerde
}

// Represents the JSON dataset format used when running a monitoring job.
type MonitoringJsonDatasetFormat struct {

	// Indicates if the file should be read as a JSON object per line.
	Line *bool

	noSmithyDocumentSerde
}

// The networking configuration for the monitoring job.
type MonitoringNetworkConfig struct {

	// Whether to encrypt all communications between the instances used for the
	// monitoring jobs. Choose True to encrypt communications. Encryption provides
	// greater security for distributed jobs, but the processing might take longer.
	EnableInterContainerTrafficEncryption *bool

	// Whether to allow inbound and outbound network calls to and from the containers
	// used for the monitoring job.
	EnableNetworkIsolation *bool

	// Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs,
	// hosted models, and compute resources have access to. You can control access to
	// and from your resources by configuring a VPC. For more information, see [Give SageMaker Access to Resources in your Amazon VPC].
	//
	// [Give SageMaker Access to Resources in your Amazon VPC]: https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// The output object for a monitoring job.
type MonitoringOutput struct {

	// The Amazon S3 storage location where the results of a monitoring job are saved.
	//
	// This member is required.
	S3Output *MonitoringS3Output

	noSmithyDocumentSerde
}

// The output configuration for monitoring jobs.
type MonitoringOutputConfig struct {

	// Monitoring outputs for monitoring jobs. This is where the output of the
	// periodic monitoring jobs is uploaded.
	//
	// This member is required.
	MonitoringOutputs []MonitoringOutput

	// The Key Management Service (KMS) key that Amazon SageMaker uses to encrypt the
	// model artifacts at rest using Amazon S3 server-side encryption.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Represents the Parquet dataset format used when running a monitoring job.
type MonitoringParquetDatasetFormat struct {
	noSmithyDocumentSerde
}

// Identifies the resources to deploy for a monitoring job.
type MonitoringResources struct {

	// The configuration for the cluster resources used to run the processing job.
	//
	// This member is required.
	ClusterConfig *MonitoringClusterConfig

	noSmithyDocumentSerde
}

// Information about where and how you want to store the results of a monitoring
// job.
type MonitoringS3Output struct {

	// The local path to the Amazon S3 storage location where Amazon SageMaker saves
	// the results of a monitoring job. LocalPath is an absolute path for the output
	// data.
	//
	// This member is required.
	LocalPath *string

	// A URI that identifies the Amazon S3 storage location where Amazon SageMaker
	// saves the results of a monitoring job.
	//
	// This member is required.
	S3Uri *string

	// Whether to upload the results of the monitoring job continuously or after the
	// job completes.
	S3UploadMode ProcessingS3UploadMode

	noSmithyDocumentSerde
}

// A schedule for a model monitoring job. For information about model monitor, see [Amazon SageMaker Model Monitor]
// .
//
// [Amazon SageMaker Model Monitor]: https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html
type MonitoringSchedule struct {

	// The time that the monitoring schedule was created.
	CreationTime *time.Time

	// The endpoint that hosts the model being monitored.
	EndpointName *string

	// If the monitoring schedule failed, the reason it failed.
	FailureReason *string

	// The last time the monitoring schedule was changed.
	LastModifiedTime *time.Time

	// Summary of information about the last monitoring job to run.
	LastMonitoringExecutionSummary *MonitoringExecutionSummary

	// The Amazon Resource Name (ARN) of the monitoring schedule.
	MonitoringScheduleArn *string

	// Configures the monitoring schedule and defines the monitoring job.
	MonitoringScheduleConfig *MonitoringScheduleConfig

	// The name of the monitoring schedule.
	MonitoringScheduleName *string

	// The status of the monitoring schedule. This can be one of the following values.
	//
	//   - PENDING - The schedule is pending being created.
	//
	//   - FAILED - The schedule failed.
	//
	//   - SCHEDULED - The schedule was successfully created.
	//
	//   - STOPPED - The schedule was stopped.
	MonitoringScheduleStatus ScheduleStatus

	// The type of the monitoring job definition to schedule.
	MonitoringType MonitoringType

	// A list of the tags associated with the monitoring schedlue. For more
	// information, see [Tagging Amazon Web Services resources]in the Amazon Web Services General Reference Guide.
	//
	// [Tagging Amazon Web Services resources]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
	Tags []Tag

	noSmithyDocumentSerde
}

// Configures the monitoring schedule and defines the monitoring job.
type MonitoringScheduleConfig struct {

	// Defines the monitoring job.
	MonitoringJobDefinition *MonitoringJobDefinition

	// The name of the monitoring job definition to schedule.
	MonitoringJobDefinitionName *string

	// The type of the monitoring job definition to schedule.
	MonitoringType MonitoringType

	// Configures the monitoring schedule.
	ScheduleConfig *ScheduleConfig

	noSmithyDocumentSerde
}

// Summarizes the monitoring schedule.
type MonitoringScheduleSummary struct {

	// The creation time of the monitoring schedule.
	//
	// This member is required.
	CreationTime *time.Time

	// The last time the monitoring schedule was modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the monitoring schedule.
	//
	// This member is required.
	MonitoringScheduleArn *string

	// The name of the monitoring schedule.
	//
	// This member is required.
	MonitoringScheduleName *string

	// The status of the monitoring schedule.
	//
	// This member is required.
	MonitoringScheduleStatus ScheduleStatus

	// The name of the endpoint using the monitoring schedule.
	EndpointName *string

	// The name of the monitoring job definition that the schedule is for.
	MonitoringJobDefinitionName *string

	// The type of the monitoring job definition that the schedule is for.
	MonitoringType MonitoringType

	noSmithyDocumentSerde
}

// The statistics resource for a monitoring job.
type MonitoringStatisticsResource struct {

	// The Amazon S3 URI for the statistics resource.
	S3Uri *string

	noSmithyDocumentSerde
}

// A time limit for how long the monitoring job is allowed to run before stopping.
type MonitoringStoppingCondition struct {

	// The maximum runtime allowed in seconds.
	//
	// The MaxRuntimeInSeconds cannot exceed the frequency of the job. For data
	// quality and model explainability, this can be up to 3600 seconds for an hourly
	// schedule. For model bias and model quality hourly schedules, this can be up to
	// 1800 seconds.
	//
	// This member is required.
	MaxRuntimeInSeconds *int32

	noSmithyDocumentSerde
}

// Specifies additional configuration for hosting multi-model endpoints.
type MultiModelConfig struct {

	// Whether to cache models for a multi-model endpoint. By default, multi-model
	// endpoints cache models so that a model does not have to be loaded into memory
	// each time it is invoked. Some use cases do not benefit from model caching. For
	// example, if an endpoint hosts a large number of models that are each invoked
	// infrequently, the endpoint might perform better if you disable model caching. To
	// disable model caching, set the value of this parameter to Disabled .
	ModelCacheSetting ModelCacheSetting

	noSmithyDocumentSerde
}

// The [VpcConfig] configuration object that specifies the VPC that you want the compilation
// jobs to connect to. For more information on controlling access to your Amazon S3
// buckets used for compilation job, see [Give Amazon SageMaker Compilation Jobs Access to Resources in Your Amazon VPC].
//
// [VpcConfig]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html
// [Give Amazon SageMaker Compilation Jobs Access to Resources in Your Amazon VPC]: https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html
type NeoVpcConfig struct {

	// The VPC security group IDs. IDs have the form of sg-xxxxxxxx . Specify the
	// security groups for the VPC that is specified in the Subnets field.
	//
	// This member is required.
	SecurityGroupIds []string

	// The ID of the subnets in the VPC that you want to connect the compilation job
	// to for accessing the model in Amazon S3.
	//
	// This member is required.
	Subnets []string

	noSmithyDocumentSerde
}

// A list of nested [Filter] objects. A resource must satisfy the conditions of all
// filters to be included in the results returned from the [Search]API.
//
// For example, to filter on a training job's InputDataConfig property with a
// specific channel name and S3Uri prefix, define the following filters:
//
//   - '{Name:"InputDataConfig.ChannelName", "Operator":"Equals",
//     "Value":"train"}',
//
//   - '{Name:"InputDataConfig.DataSource.S3DataSource.S3Uri",
//     "Operator":"Contains", "Value":"mybucket/catdata"}'
//
// [Filter]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Filter.html
// [Search]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html
type NestedFilters struct {

	// A list of filters. Each filter acts on a property. Filters must contain at
	// least one Filters value. For example, a NestedFilters call might include a
	// filter on the PropertyName parameter of the InputDataConfig property:
	// InputDataConfig.DataSource.S3DataSource.S3Uri .
	//
	// This member is required.
	Filters []Filter

	// The name of the property to use in the nested filters. The value must match a
	// listed property name, such as InputDataConfig .
	//
	// This member is required.
	NestedPropertyName *string

	noSmithyDocumentSerde
}

// Networking options for a job, such as network traffic encryption between
// containers, whether to allow inbound and outbound network calls to and from
// containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
type NetworkConfig struct {

	// Whether to encrypt all communications between distributed processing jobs.
	// Choose True to encrypt communications. Encryption provides greater security for
	// distributed processing jobs, but the processing might take longer.
	EnableInterContainerTrafficEncryption *bool

	// Whether to allow inbound and outbound network calls to and from the containers
	// used for the processing job.
	EnableNetworkIsolation *bool

	// Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs,
	// hosted models, and compute resources have access to. You can control access to
	// and from your resources by configuring a VPC. For more information, see [Give SageMaker Access to Resources in your Amazon VPC].
	//
	// [Give SageMaker Access to Resources in your Amazon VPC]: https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Provides a summary of a notebook instance lifecycle configuration.
type NotebookInstanceLifecycleConfigSummary struct {

	// The Amazon Resource Name (ARN) of the lifecycle configuration.
	//
	// This member is required.
	NotebookInstanceLifecycleConfigArn *string

	// The name of the lifecycle configuration.
	//
	// This member is required.
	NotebookInstanceLifecycleConfigName *string

	// A timestamp that tells when the lifecycle configuration was created.
	CreationTime *time.Time

	// A timestamp that tells when the lifecycle configuration was last modified.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Contains the notebook instance lifecycle configuration script.
//
// Each lifecycle configuration script has a limit of 16384 characters.
//
// The value of the $PATH environment variable that is available to both scripts
// is /sbin:bin:/usr/sbin:/usr/bin .
//
// View Amazon CloudWatch Logs for notebook instance lifecycle configurations in
// log group /aws/sagemaker/NotebookInstances in log stream
// [notebook-instance-name]/[LifecycleConfigHook] .
//
// Lifecycle configuration scripts cannot run for longer than 5 minutes. If a
// script runs for longer than 5 minutes, it fails and the notebook instance is not
// created or started.
//
// For information about notebook instance lifestyle configurations, see [Step 2.1: (Optional) Customize a Notebook Instance].
//
// [Step 2.1: (Optional) Customize a Notebook Instance]: https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html
type NotebookInstanceLifecycleHook struct {

	// A base64-encoded string that contains a shell script for a notebook instance
	// lifecycle configuration.
	Content *string

	noSmithyDocumentSerde
}

// Provides summary information for an SageMaker notebook instance.
type NotebookInstanceSummary struct {

	// The Amazon Resource Name (ARN) of the notebook instance.
	//
	// This member is required.
	NotebookInstanceArn *string

	// The name of the notebook instance that you want a summary for.
	//
	// This member is required.
	NotebookInstanceName *string

	// An array of up to three Git repositories associated with the notebook instance.
	// These can be either the names of Git repositories stored as resources in your
	// account, or the URL of Git repositories in [Amazon Web Services CodeCommit]or in any other Git repository.
	// These repositories are cloned at the same level as the default repository of
	// your notebook instance. For more information, see [Associating Git Repositories with SageMaker Notebook Instances].
	//
	// [Amazon Web Services CodeCommit]: https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html
	// [Associating Git Repositories with SageMaker Notebook Instances]: https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html
	AdditionalCodeRepositories []string

	// A timestamp that shows when the notebook instance was created.
	CreationTime *time.Time

	// The Git repository associated with the notebook instance as its default code
	// repository. This can be either the name of a Git repository stored as a resource
	// in your account, or the URL of a Git repository in [Amazon Web Services CodeCommit]or in any other Git
	// repository. When you open a notebook instance, it opens in the directory that
	// contains this repository. For more information, see [Associating Git Repositories with SageMaker Notebook Instances].
	//
	// [Amazon Web Services CodeCommit]: https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html
	// [Associating Git Repositories with SageMaker Notebook Instances]: https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html
	DefaultCodeRepository *string

	// The type of ML compute instance that the notebook instance is running on.
	InstanceType InstanceType

	// A timestamp that shows when the notebook instance was last modified.
	LastModifiedTime *time.Time

	// The name of a notebook instance lifecycle configuration associated with this
	// notebook instance.
	//
	// For information about notebook instance lifestyle configurations, see [Step 2.1: (Optional) Customize a Notebook Instance].
	//
	// [Step 2.1: (Optional) Customize a Notebook Instance]: https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html
	NotebookInstanceLifecycleConfigName *string

	// The status of the notebook instance.
	NotebookInstanceStatus NotebookInstanceStatus

	// The URL that you use to connect to the Jupyter notebook running in your
	// notebook instance.
	Url *string

	noSmithyDocumentSerde
}

// Configures Amazon SNS notifications of available or expiring work items for
// work teams.
type NotificationConfiguration struct {

	// The ARN for the Amazon SNS topic to which notifications should be published.
	NotificationTopicArn *string

	noSmithyDocumentSerde
}

// Specifies the number of training jobs that this hyperparameter tuning job
// launched, categorized by the status of their objective metric. The objective
// metric status shows whether the final objective metric for the training job has
// been evaluated by the tuning job and used in the hyperparameter tuning process.
type ObjectiveStatusCounters struct {

	// The number of training jobs whose final objective metric was not evaluated and
	// used in the hyperparameter tuning process. This typically occurs when the
	// training job failed or did not emit an objective metric.
	Failed *int32

	// The number of training jobs that are in progress and pending evaluation of
	// their final objective metric.
	Pending *int32

	// The number of training jobs whose final objective metric was evaluated by the
	// hyperparameter tuning job and used in the hyperparameter tuning process.
	Succeeded *int32

	noSmithyDocumentSerde
}

// The configuration of an OfflineStore .
//
// Provide an OfflineStoreConfig in a request to CreateFeatureGroup to create an
// OfflineStore .
//
// To encrypt an OfflineStore using at rest data encryption, specify Amazon Web
// Services Key Management Service (KMS) key ID, or KMSKeyId , in S3StorageConfig .
type OfflineStoreConfig struct {

	// The Amazon Simple Storage (Amazon S3) location of OfflineStore .
	//
	// This member is required.
	S3StorageConfig *S3StorageConfig

	// The meta data of the Glue table that is autogenerated when an OfflineStore is
	// created.
	DataCatalogConfig *DataCatalogConfig

	// Set to True to disable the automatic creation of an Amazon Web Services Glue
	// table when configuring an OfflineStore . If set to False , Feature Store will
	// name the OfflineStore Glue table following [Athena's naming recommendations].
	//
	// The default value is False .
	//
	// [Athena's naming recommendations]: https://docs.aws.amazon.com/athena/latest/ug/tables-databases-columns-names.html
	DisableGlueTableCreation *bool

	// Format for the offline store table. Supported formats are Glue (Default) and [Apache Iceberg].
	//
	// [Apache Iceberg]: https://iceberg.apache.org/
	TableFormat TableFormat

	noSmithyDocumentSerde
}

// The status of OfflineStore .
type OfflineStoreStatus struct {

	// An OfflineStore status.
	//
	// This member is required.
	Status OfflineStoreStatusValue

	// The justification for why the OfflineStoreStatus is Blocked (if applicable).
	BlockedReason *string

	noSmithyDocumentSerde
}

// Use this parameter to configure your OIDC Identity Provider (IdP).
type OidcConfig struct {

	// The OIDC IdP authorization endpoint used to configure your private workforce.
	//
	// This member is required.
	AuthorizationEndpoint *string

	// The OIDC IdP client ID used to configure your private workforce.
	//
	// This member is required.
	ClientId *string

	// The OIDC IdP client secret used to configure your private workforce.
	//
	// This member is required.
	ClientSecret *string

	// The OIDC IdP issuer used to configure your private workforce.
	//
	// This member is required.
	Issuer *string

	// The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private
	// workforce.
	//
	// This member is required.
	JwksUri *string

	// The OIDC IdP logout endpoint used to configure your private workforce.
	//
	// This member is required.
	LogoutEndpoint *string

	// The OIDC IdP token endpoint used to configure your private workforce.
	//
	// This member is required.
	TokenEndpoint *string

	// The OIDC IdP user information endpoint used to configure your private workforce.
	//
	// This member is required.
	UserInfoEndpoint *string

	noSmithyDocumentSerde
}

// Your OIDC IdP workforce configuration.
type OidcConfigForResponse struct {

	// The OIDC IdP authorization endpoint used to configure your private workforce.
	AuthorizationEndpoint *string

	// The OIDC IdP client ID used to configure your private workforce.
	ClientId *string

	// The OIDC IdP issuer used to configure your private workforce.
	Issuer *string

	// The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private
	// workforce.
	JwksUri *string

	// The OIDC IdP logout endpoint used to configure your private workforce.
	LogoutEndpoint *string

	// The OIDC IdP token endpoint used to configure your private workforce.
	TokenEndpoint *string

	// The OIDC IdP user information endpoint used to configure your private workforce.
	UserInfoEndpoint *string

	noSmithyDocumentSerde
}

// A list of user groups that exist in your OIDC Identity Provider (IdP). One to
// ten groups can be used to create a single private work team. When you add a user
// group to the list of Groups , you can add that user group to one or more private
// work teams. If you add a user group to a private work team, all workers in that
// user group are added to the work team.
type OidcMemberDefinition struct {

	// A list of comma seperated strings that identifies user groups in your OIDC IdP.
	// Each user group is made up of a group of private workers.
	Groups []string

	noSmithyDocumentSerde
}

// Use this to specify the Amazon Web Services Key Management Service (KMS) Key
// ID, or KMSKeyId , for at rest data encryption. You can turn OnlineStore on or
// off by specifying the EnableOnlineStore flag at General Assembly.
//
// The default value is False .
type OnlineStoreConfig struct {

	// Turn OnlineStore off by specifying False for the EnableOnlineStore flag. Turn
	// OnlineStore on by specifying True for the EnableOnlineStore flag.
	//
	// The default value is False .
	EnableOnlineStore *bool

	// Use to specify KMS Key ID ( KMSKeyId ) for at-rest encryption of your
	// OnlineStore .
	SecurityConfig *OnlineStoreSecurityConfig

	// Option for different tiers of low latency storage for real-time data retrieval.
	//
	//   - Standard : A managed low latency data store for feature groups.
	//
	//   - InMemory : A managed data store for feature groups that supports very low
	//   latency retrieval.
	StorageType StorageType

	// Time to live duration, where the record is hard deleted after the expiration
	// time is reached; ExpiresAt = EventTime + TtlDuration . For information on
	// HardDelete, see the [DeleteRecord]API in the Amazon SageMaker API Reference guide.
	//
	// [DeleteRecord]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html
	TtlDuration *TtlDuration

	noSmithyDocumentSerde
}

// Updates the feature group online store configuration.
type OnlineStoreConfigUpdate struct {

	// Time to live duration, where the record is hard deleted after the expiration
	// time is reached; ExpiresAt = EventTime + TtlDuration . For information on
	// HardDelete, see the [DeleteRecord]API in the Amazon SageMaker API Reference guide.
	//
	// [DeleteRecord]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html
	TtlDuration *TtlDuration

	noSmithyDocumentSerde
}

// The security configuration for OnlineStore .
type OnlineStoreSecurityConfig struct {

	// The Amazon Web Services Key Management Service (KMS) key ARN that SageMaker
	// Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3
	// server-side encryption.
	//
	// The caller (either user or IAM role) of CreateFeatureGroup must have below
	// permissions to the OnlineStore KmsKeyId :
	//
	//   - "kms:Encrypt"
	//
	//   - "kms:Decrypt"
	//
	//   - "kms:DescribeKey"
	//
	//   - "kms:CreateGrant"
	//
	//   - "kms:RetireGrant"
	//
	//   - "kms:ReEncryptFrom"
	//
	//   - "kms:ReEncryptTo"
	//
	//   - "kms:GenerateDataKey"
	//
	//   - "kms:ListAliases"
	//
	//   - "kms:ListGrants"
	//
	//   - "kms:RevokeGrant"
	//
	// The caller (either user or IAM role) to all DataPlane operations ( PutRecord ,
	// GetRecord , DeleteRecord ) must have the following permissions to the KmsKeyId :
	//
	//   - "kms:Decrypt"
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Contains information about the output location for the compiled model and the
// target device that the model runs on. TargetDevice and TargetPlatform are
// mutually exclusive, so you need to choose one between the two to specify your
// target device or platform. If you cannot find your device you want to use from
// the TargetDevice list, use TargetPlatform to describe the platform of your edge
// device and CompilerOptions if there are specific settings that are required or
// recommended to use for particular TargetPlatform.
type OutputConfig struct {

	// Identifies the S3 bucket where you want Amazon SageMaker to store the model
	// artifacts. For example, s3://bucket-name/key-name-prefix .
	//
	// This member is required.
	S3OutputLocation *string

	// Specifies additional parameters for compiler options in JSON format. The
	// compiler options are TargetPlatform specific. It is required for NVIDIA
	// accelerators and highly recommended for CPU compilations. For any other cases,
	// it is optional to specify CompilerOptions.
	//
	//   - DTYPE : Specifies the data type for the input. When compiling for ml_*
	//   (except for ml_inf ) instances using PyTorch framework, provide the data type
	//   (dtype) of the model's input. "float32" is used if "DTYPE" is not specified.
	//   Options for data type are:
	//
	//   - float32: Use either "float" or "float32" .
	//
	//   - int64: Use either "int64" or "long" .
	//
	// For example, {"dtype" : "float32"} .
	//
	//   - CPU : Compilation for CPU supports the following compiler options.
	//
	//   - mcpu : CPU micro-architecture. For example, {'mcpu': 'skylake-avx512'}
	//
	//   - mattr : CPU flags. For example, {'mattr': ['+neon', '+vfpv4']}
	//
	//   - ARM : Details of ARM CPU compilations.
	//
	//   - NEON : NEON is an implementation of the Advanced SIMD extension used in
	//   ARMv7 processors.
	//
	// For example, add {'mattr': ['+neon']} to the compiler options if compiling for
	//   ARM 32-bit platform with the NEON support.
	//
	//   - NVIDIA : Compilation for NVIDIA GPU supports the following compiler options.
	//
	//   - gpu_code : Specifies the targeted architecture.
	//
	//   - trt-ver : Specifies the TensorRT versions in x.y.z. format.
	//
	//   - cuda-ver : Specifies the CUDA version in x.y format.
	//
	// For example, {'gpu-code': 'sm_72', 'trt-ver': '6.0.1', 'cuda-ver': '10.1'}
	//
	//   - ANDROID : Compilation for the Android OS supports the following compiler
	//   options:
	//
	//   - ANDROID_PLATFORM : Specifies the Android API levels. Available levels range
	//   from 21 to 29. For example, {'ANDROID_PLATFORM': 28} .
	//
	//   - mattr : Add {'mattr': ['+neon']} to compiler options if compiling for ARM
	//   32-bit platform with NEON support.
	//
	//   - INFERENTIA : Compilation for target ml_inf1 uses compiler options passed in
	//   as a JSON string. For example, "CompilerOptions": "\"--verbose 1
	//   --num-neuroncores 2 -O2\"" .
	//
	// For information about supported compiler options, see [Neuron Compiler CLI Reference Guide].
	//
	//   - CoreML : Compilation for the CoreML [OutputConfig]TargetDevice supports the following
	//   compiler options:
	//
	//   - class_labels : Specifies the classification labels file name inside input
	//   tar.gz file. For example, {"class_labels": "imagenet_labels_1000.txt"} .
	//   Labels inside the txt file should be separated by newlines.
	//
	//   - EIA : Compilation for the Elastic Inference Accelerator supports the
	//   following compiler options:
	//
	//   - precision_mode : Specifies the precision of compiled artifacts. Supported
	//   values are "FP16" and "FP32" . Default is "FP32" .
	//
	//   - signature_def_key : Specifies the signature to use for models in SavedModel
	//   format. Defaults is TensorFlow's default signature def key.
	//
	//   - output_names : Specifies a list of output tensor names for models in
	//   FrozenGraph format. Set at most one API field, either: signature_def_key or
	//   output_names .
	//
	// For example: {"precision_mode": "FP32", "output_names": ["output:0"]}
	//
	// [OutputConfig]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OutputConfig.html
	// [Neuron Compiler CLI Reference Guide]: https://awsdocs-neuron.readthedocs-hosted.com/en/latest/compiler/neuronx-cc/api-reference-guide/neuron-compiler-cli-reference-guide.html
	CompilerOptions *string

	// The Amazon Web Services Key Management Service key (Amazon Web Services KMS)
	// that Amazon SageMaker uses to encrypt your output models with Amazon S3
	// server-side encryption after compilation job. If you don't provide a KMS key ID,
	// Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.
	// For more information, see [KMS-Managed Encryption Keys]in the Amazon Simple Storage Service Developer Guide.
	//
	// The KmsKeyId can be any of the following formats:
	//
	//   - Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   - Key ARN:
	//   arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   - Alias name: alias/ExampleAlias
	//
	//   - Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias
	//
	// [KMS-Managed Encryption Keys]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html
	KmsKeyId *string

	// Identifies the target device or the machine learning instance that you want to
	// run your model on after the compilation has completed. Alternatively, you can
	// specify OS, architecture, and accelerator using [TargetPlatform]fields. It can be used instead
	// of TargetPlatform .
	//
	// Currently ml_trn1 is available only in US East (N. Virginia) Region, and ml_inf2
	// is available only in US East (Ohio) Region.
	//
	// [TargetPlatform]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_TargetPlatform.html
	TargetDevice TargetDevice

	// Contains information about a target platform that you want your model to run
	// on, such as OS, architecture, and accelerators. It is an alternative of
	// TargetDevice .
	//
	// The following examples show how to configure the TargetPlatform and
	// CompilerOptions JSON strings for popular target platforms:
	//
	//   - Raspberry Pi 3 Model B+
	//
	// "TargetPlatform": {"Os": "LINUX", "Arch": "ARM_EABIHF"},
	//
	// "CompilerOptions": {'mattr': ['+neon']}
	//
	//   - Jetson TX2
	//
	// "TargetPlatform": {"Os": "LINUX", "Arch": "ARM64", "Accelerator": "NVIDIA"},
	//
	// "CompilerOptions": {'gpu-code': 'sm_62', 'trt-ver': '6.0.1', 'cuda-ver': '10.0'}
	//
	//   - EC2 m5.2xlarge instance OS
	//
	// "TargetPlatform": {"Os": "LINUX", "Arch": "X86_64", "Accelerator": "NVIDIA"},
	//
	// "CompilerOptions": {'mcpu': 'skylake-avx512'}
	//
	//   - RK3399
	//
	// "TargetPlatform": {"Os": "LINUX", "Arch": "ARM64", "Accelerator": "MALI"}
	//
	//   - ARMv7 phone (CPU)
	//
	// "TargetPlatform": {"Os": "ANDROID", "Arch": "ARM_EABI"},
	//
	// "CompilerOptions": {'ANDROID_PLATFORM': 25, 'mattr': ['+neon']}
	//
	//   - ARMv8 phone (CPU)
	//
	// "TargetPlatform": {"Os": "ANDROID", "Arch": "ARM64"},
	//
	// "CompilerOptions": {'ANDROID_PLATFORM': 29}
	TargetPlatform *TargetPlatform

	noSmithyDocumentSerde
}

// Provides information about how to store model training results (model
// artifacts).
type OutputDataConfig struct {

	// Identifies the S3 path where you want SageMaker to store the model artifacts.
	// For example, s3://bucket-name/key-name-prefix .
	//
	// This member is required.
	S3OutputPath *string

	// The model output compression type. Select None to output an uncompressed model,
	// recommended for large model outputs. Defaults to gzip.
	CompressionType OutputCompressionType

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that SageMaker uses to encrypt the model artifacts at rest using Amazon S3
	// server-side encryption. The KmsKeyId can be any of the following formats:
	//
	//   - // KMS Key ID
	//
	// "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//   - // Amazon Resource Name (ARN) of a KMS Key
	//
	// "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//   - // KMS Key Alias
	//
	// "alias/ExampleAlias"
	//
	//   - // Amazon Resource Name (ARN) of a KMS Key Alias
	//
	// "arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"
	//
	// If you use a KMS key ID or an alias of your KMS key, the SageMaker execution
	// role must include permissions to call kms:Encrypt . If you don't provide a KMS
	// key ID, SageMaker uses the default KMS key for Amazon S3 for your role's
	// account.
	//
	// For more information, see [KMS-Managed Encryption Keys] in the Amazon Simple Storage Service Developer
	// Guide. If the output data is stored in Amazon S3 Express One Zone, it is
	// encrypted with server-side encryption with Amazon S3 managed keys (SSE-S3). KMS
	// key is not supported for Amazon S3 Express One Zone
	//
	// The KMS key policy must grant permission to the IAM role that you specify in
	// your CreateTrainingJob , CreateTransformJob , or CreateHyperParameterTuningJob
	// requests. For more information, see [Using Key Policies in Amazon Web Services KMS]in the Amazon Web Services Key Management
	// Service Developer Guide.
	//
	// [KMS-Managed Encryption Keys]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html
	// [Using Key Policies in Amazon Web Services KMS]: https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html
	KmsKeyId *string

	noSmithyDocumentSerde
}

// An output parameter of a pipeline step.
type OutputParameter struct {

	// The name of the output parameter.
	//
	// This member is required.
	Name *string

	// The value of the output parameter.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The collection of ownership settings for a space.
type OwnershipSettings struct {

	// The user profile who is the owner of the space.
	//
	// This member is required.
	OwnerUserProfileName *string

	noSmithyDocumentSerde
}

// Specifies summary information about the ownership settings.
type OwnershipSettingsSummary struct {

	// The user profile who is the owner of the space.
	OwnerUserProfileName *string

	noSmithyDocumentSerde
}

// Configuration that controls the parallelism of the pipeline. By default, the
// parallelism configuration specified applies to all executions of the pipeline
// unless overridden.
type ParallelismConfiguration struct {

	// The max number of steps that can be executed in parallel.
	//
	// This member is required.
	MaxParallelExecutionSteps *int32

	noSmithyDocumentSerde
}

// Assigns a value to a named Pipeline parameter.
type Parameter struct {

	// The name of the parameter to assign a value to. This parameter name must match
	// a named parameter in the pipeline definition.
	//
	// This member is required.
	Name *string

	// The literal value for the parameter.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Defines the possible values for categorical, continuous, and integer
// hyperparameters to be used by an algorithm.
type ParameterRange struct {

	// A CategoricalParameterRangeSpecification object that defines the possible
	// values for a categorical hyperparameter.
	CategoricalParameterRangeSpecification *CategoricalParameterRangeSpecification

	// A ContinuousParameterRangeSpecification object that defines the possible values
	// for a continuous hyperparameter.
	ContinuousParameterRangeSpecification *ContinuousParameterRangeSpecification

	// A IntegerParameterRangeSpecification object that defines the possible values
	// for an integer hyperparameter.
	IntegerParameterRangeSpecification *IntegerParameterRangeSpecification

	noSmithyDocumentSerde
}

// Specifies ranges of integer, continuous, and categorical hyperparameters that a
// hyperparameter tuning job searches. The hyperparameter tuning job launches
// training jobs with hyperparameter values within these ranges to find the
// combination of values that result in the training job with the best performance
// as measured by the objective metric of the hyperparameter tuning job.
//
// The maximum number of items specified for Array Members refers to the maximum
// number of hyperparameters for each range and also the maximum for the
// hyperparameter tuning job itself. That is, the sum of the number of
// hyperparameters for all the ranges can't exceed the maximum number specified.
type ParameterRanges struct {

	// A list containing hyperparameter names and example values to be used by
	// Autotune to determine optimal ranges for your tuning job.
	AutoParameters []AutoParameter

	// The array of [CategoricalParameterRange] objects that specify ranges of categorical hyperparameters that a
	// hyperparameter tuning job searches.
	//
	// [CategoricalParameterRange]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CategoricalParameterRange.html
	CategoricalParameterRanges []CategoricalParameterRange

	// The array of [ContinuousParameterRange] objects that specify ranges of continuous hyperparameters that a
	// hyperparameter tuning job searches.
	//
	// [ContinuousParameterRange]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContinuousParameterRange.html
	ContinuousParameterRanges []ContinuousParameterRange

	// The array of [IntegerParameterRange] objects that specify ranges of integer hyperparameters that a
	// hyperparameter tuning job searches.
	//
	// [IntegerParameterRange]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_IntegerParameterRange.html
	IntegerParameterRanges []IntegerParameterRange

	noSmithyDocumentSerde
}

// The trial that a trial component is associated with and the experiment the
// trial is part of. A component might not be associated with a trial. A component
// can be associated with multiple trials.
type Parent struct {

	// The name of the experiment.
	ExperimentName *string

	// The name of the trial.
	TrialName *string

	noSmithyDocumentSerde
}

// A previously completed or stopped hyperparameter tuning job to be used as a
// starting point for a new hyperparameter tuning job.
type ParentHyperParameterTuningJob struct {

	// The name of the hyperparameter tuning job to be used as a starting point for a
	// new hyperparameter tuning job.
	HyperParameterTuningJobName *string

	noSmithyDocumentSerde
}

// The summary of an in-progress deployment when an endpoint is creating or
// updating with a new endpoint configuration.
type PendingDeploymentSummary struct {

	// The name of the endpoint configuration used in the deployment.
	//
	// This member is required.
	EndpointConfigName *string

	// An array of [PendingProductionVariantSummary] objects, one for each model hosted behind this endpoint for the
	// in-progress deployment.
	//
	// [PendingProductionVariantSummary]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html
	ProductionVariants []PendingProductionVariantSummary

	// An array of [PendingProductionVariantSummary] objects, one for each model hosted behind this endpoint in shadow
	// mode with production traffic replicated from the model specified on
	// ProductionVariants for the in-progress deployment.
	//
	// [PendingProductionVariantSummary]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_PendingProductionVariantSummary.html
	ShadowProductionVariants []PendingProductionVariantSummary

	// The start time of the deployment.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// The production variant summary for a deployment when an endpoint is creating or
// updating with the [CreateEndpoint]or [UpdateEndpoint] operations. Describes the VariantStatus , weight and
// capacity for a production variant associated with an endpoint.
//
// [UpdateEndpoint]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpoint.html
// [CreateEndpoint]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html
type PendingProductionVariantSummary struct {

	// The name of the variant.
	//
	// This member is required.
	VariantName *string

	// The size of the Elastic Inference (EI) instance to use for the production
	// variant. EI instances provide on-demand GPU computing for inference. For more
	// information, see [Using Elastic Inference in Amazon SageMaker].
	//
	// [Using Elastic Inference in Amazon SageMaker]: https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html
	AcceleratorType ProductionVariantAcceleratorType

	// The number of instances associated with the variant.
	CurrentInstanceCount *int32

	// The serverless configuration for the endpoint.
	CurrentServerlessConfig *ProductionVariantServerlessConfig

	// The weight associated with the variant.
	CurrentWeight *float32

	// An array of DeployedImage objects that specify the Amazon EC2 Container
	// Registry paths of the inference images deployed on instances of this
	// ProductionVariant .
	DeployedImages []DeployedImage

	// The number of instances requested in this deployment, as specified in the
	// endpoint configuration for the endpoint. The value is taken from the request to
	// the [CreateEndpointConfig]operation.
	//
	// [CreateEndpointConfig]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html
	DesiredInstanceCount *int32

	// The serverless configuration requested for this deployment, as specified in the
	// endpoint configuration for the endpoint.
	DesiredServerlessConfig *ProductionVariantServerlessConfig

	// The requested weight for the variant in this deployment, as specified in the
	// endpoint configuration for the endpoint. The value is taken from the request to
	// the [CreateEndpointConfig]operation.
	//
	// [CreateEndpointConfig]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html
	DesiredWeight *float32

	// The type of instances associated with the variant.
	InstanceType ProductionVariantInstanceType

	// Settings that control the range in the number of instances that the endpoint
	// provisions as it scales up or down to accommodate traffic.
	ManagedInstanceScaling *ProductionVariantManagedInstanceScaling

	// Settings that control how the endpoint routes incoming traffic to the instances
	// that the endpoint hosts.
	RoutingConfig *ProductionVariantRoutingConfig

	// The endpoint variant status which describes the current deployment stage status
	// or operational status.
	VariantStatus []ProductionVariantStatus

	noSmithyDocumentSerde
}

// Defines the traffic pattern.
type Phase struct {

	// Specifies how long a traffic phase should be. For custom load tests, the value
	// should be between 120 and 3600. This value should not exceed
	// JobDurationInSeconds .
	DurationInSeconds *int32

	// Specifies how many concurrent users to start with. The value should be between
	// 1 and 3.
	InitialNumberOfUsers *int32

	// Specified how many new users to spawn in a minute.
	SpawnRate *int32

	noSmithyDocumentSerde
}

// A SageMaker Model Building Pipeline instance.
type Pipeline struct {

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	CreatedBy *UserContext

	// The creation time of the pipeline.
	CreationTime *time.Time

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	LastModifiedBy *UserContext

	// The time that the pipeline was last modified.
	LastModifiedTime *time.Time

	// The time when the pipeline was last run.
	LastRunTime *time.Time

	// The parallelism configuration applied to the pipeline.
	ParallelismConfiguration *ParallelismConfiguration

	// The Amazon Resource Name (ARN) of the pipeline.
	PipelineArn *string

	// The description of the pipeline.
	PipelineDescription *string

	// The display name of the pipeline.
	PipelineDisplayName *string

	// The name of the pipeline.
	PipelineName *string

	// The status of the pipeline.
	PipelineStatus PipelineStatus

	// The Amazon Resource Name (ARN) of the role that created the pipeline.
	RoleArn *string

	// A list of tags that apply to the pipeline.
	Tags []Tag

	noSmithyDocumentSerde
}

// The location of the pipeline definition stored in Amazon S3.
type PipelineDefinitionS3Location struct {

	// Name of the S3 bucket.
	//
	// This member is required.
	Bucket *string

	// The object key (or key name) uniquely identifies the object in an S3 bucket.
	//
	// This member is required.
	ObjectKey *string

	// Version Id of the pipeline definition file. If not specified, Amazon SageMaker
	// will retrieve the latest version.
	VersionId *string

	noSmithyDocumentSerde
}

// An execution of a pipeline.
type PipelineExecution struct {

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	CreatedBy *UserContext

	// The creation time of the pipeline execution.
	CreationTime *time.Time

	// If the execution failed, a message describing why.
	FailureReason *string

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	LastModifiedBy *UserContext

	// The time that the pipeline execution was last modified.
	LastModifiedTime *time.Time

	// The parallelism configuration applied to the pipeline execution.
	ParallelismConfiguration *ParallelismConfiguration

	// The Amazon Resource Name (ARN) of the pipeline that was executed.
	PipelineArn *string

	// The Amazon Resource Name (ARN) of the pipeline execution.
	PipelineExecutionArn *string

	// The description of the pipeline execution.
	PipelineExecutionDescription *string

	// The display name of the pipeline execution.
	PipelineExecutionDisplayName *string

	// The status of the pipeline status.
	PipelineExecutionStatus PipelineExecutionStatus

	// Specifies the names of the experiment and trial created by a pipeline.
	PipelineExperimentConfig *PipelineExperimentConfig

	// Contains a list of pipeline parameters. This list can be empty.
	PipelineParameters []Parameter

	// The selective execution configuration applied to the pipeline run.
	SelectiveExecutionConfig *SelectiveExecutionConfig

	noSmithyDocumentSerde
}

// An execution of a step in a pipeline.
type PipelineExecutionStep struct {

	// The current attempt of the execution step. For more information, see [Retry Policy for SageMaker Pipelines steps].
	//
	// [Retry Policy for SageMaker Pipelines steps]: https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-retry-policy.html
	AttemptCount *int32

	// If this pipeline execution step was cached, details on the cache hit.
	CacheHitResult *CacheHitResult

	// The time that the step stopped executing.
	EndTime *time.Time

	// The reason why the step failed execution. This is only returned if the step
	// failed its execution.
	FailureReason *string

	// Metadata to run the pipeline step.
	Metadata *PipelineExecutionStepMetadata

	// The ARN from an execution of the current pipeline from which results are reused
	// for this step.
	SelectiveExecutionResult *SelectiveExecutionResult

	// The time that the step started executing.
	StartTime *time.Time

	// The description of the step.
	StepDescription *string

	// The display name of the step.
	StepDisplayName *string

	// The name of the step that is executed.
	StepName *string

	// The status of the step execution.
	StepStatus StepStatus

	noSmithyDocumentSerde
}

// Metadata for a step execution.
type PipelineExecutionStepMetadata struct {

	// The Amazon Resource Name (ARN) of the AutoML job that was run by this step.
	AutoMLJob *AutoMLJobStepMetadata

	// The URL of the Amazon SQS queue used by this step execution, the pipeline
	// generated token, and a list of output parameters.
	Callback *CallbackStepMetadata

	// Container for the metadata for a Clarify check step. The configurations and
	// outcomes of the check step execution. This includes:
	//
	//   - The type of the check conducted,
	//
	//   - The Amazon S3 URIs of baseline constraints and statistics files to be used
	//   for the drift check.
	//
	//   - The Amazon S3 URIs of newly calculated baseline constraints and statistics.
	//
	//   - The model package group name provided.
	//
	//   - The Amazon S3 URI of the violation report if violations detected.
	//
	//   - The Amazon Resource Name (ARN) of check processing job initiated by the
	//   step execution.
	//
	//   - The boolean flags indicating if the drift check is skipped.
	//
	//   - If step property BaselineUsedForDriftCheck is set the same as
	//   CalculatedBaseline .
	ClarifyCheck *ClarifyCheckStepMetadata

	// The outcome of the condition evaluation that was run by this step execution.
	Condition *ConditionStepMetadata

	// The configurations and outcomes of an Amazon EMR step execution.
	EMR *EMRStepMetadata

	// The configurations and outcomes of a Fail step execution.
	Fail *FailStepMetadata

	// The Amazon Resource Name (ARN) of the Lambda function that was run by this step
	// execution and a list of output parameters.
	Lambda *LambdaStepMetadata

	// The Amazon Resource Name (ARN) of the model that was created by this step
	// execution.
	Model *ModelStepMetadata

	// The Amazon Resource Name (ARN) of the processing job that was run by this step
	// execution.
	ProcessingJob *ProcessingJobStepMetadata

	// The configurations and outcomes of the check step execution. This includes:
	//
	//   - The type of the check conducted.
	//
	//   - The Amazon S3 URIs of baseline constraints and statistics files to be used
	//   for the drift check.
	//
	//   - The Amazon S3 URIs of newly calculated baseline constraints and statistics.
	//
	//   - The model package group name provided.
	//
	//   - The Amazon S3 URI of the violation report if violations detected.
	//
	//   - The Amazon Resource Name (ARN) of check processing job initiated by the
	//   step execution.
	//
	//   - The Boolean flags indicating if the drift check is skipped.
	//
	//   - If step property BaselineUsedForDriftCheck is set the same as
	//   CalculatedBaseline .
	QualityCheck *QualityCheckStepMetadata

	// The Amazon Resource Name (ARN) of the model package that the model was
	// registered to by this step execution.
	RegisterModel *RegisterModelStepMetadata

	// The Amazon Resource Name (ARN) of the training job that was run by this step
	// execution.
	TrainingJob *TrainingJobStepMetadata

	// The Amazon Resource Name (ARN) of the transform job that was run by this step
	// execution.
	TransformJob *TransformJobStepMetadata

	// The Amazon Resource Name (ARN) of the tuning job that was run by this step
	// execution.
	TuningJob *TuningJobStepMetaData

	noSmithyDocumentSerde
}

// A pipeline execution summary.
type PipelineExecutionSummary struct {

	// The Amazon Resource Name (ARN) of the pipeline execution.
	PipelineExecutionArn *string

	// The description of the pipeline execution.
	PipelineExecutionDescription *string

	// The display name of the pipeline execution.
	PipelineExecutionDisplayName *string

	// A message generated by SageMaker Pipelines describing why the pipeline
	// execution failed.
	PipelineExecutionFailureReason *string

	// The status of the pipeline execution.
	PipelineExecutionStatus PipelineExecutionStatus

	// The start time of the pipeline execution.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// Specifies the names of the experiment and trial created by a pipeline.
type PipelineExperimentConfig struct {

	// The name of the experiment.
	ExperimentName *string

	// The name of the trial.
	TrialName *string

	noSmithyDocumentSerde
}

// A summary of a pipeline.
type PipelineSummary struct {

	// The creation time of the pipeline.
	CreationTime *time.Time

	// The last time that a pipeline execution began.
	LastExecutionTime *time.Time

	// The time that the pipeline was last modified.
	LastModifiedTime *time.Time

	//  The Amazon Resource Name (ARN) of the pipeline.
	PipelineArn *string

	// The description of the pipeline.
	PipelineDescription *string

	// The display name of the pipeline.
	PipelineDisplayName *string

	// The name of the pipeline.
	PipelineName *string

	// The Amazon Resource Name (ARN) that the pipeline used to execute.
	RoleArn *string

	noSmithyDocumentSerde
}

// A specification for a predefined metric.
type PredefinedMetricSpecification struct {

	// The metric type. You can only apply SageMaker metric types to SageMaker
	// endpoints.
	PredefinedMetricType *string

	noSmithyDocumentSerde
}

// Configuration for the cluster used to run a processing job.
type ProcessingClusterConfig struct {

	// The number of ML compute instances to use in the processing job. For
	// distributed processing jobs, specify a value greater than 1. The default value
	// is 1.
	//
	// This member is required.
	InstanceCount *int32

	// The ML compute instance type for the processing job.
	//
	// This member is required.
	InstanceType ProcessingInstanceType

	// The size of the ML storage volume in gigabytes that you want to provision. You
	// must specify sufficient ML storage for your scenario.
	//
	// Certain Nitro-based instances include local storage with a fixed total size,
	// dependent on the instance type. When using these instances for processing,
	// Amazon SageMaker mounts the local instance storage instead of Amazon EBS gp2
	// storage. You can't request a VolumeSizeInGB greater than the total size of the
	// local instance storage.
	//
	// For a list of instance types that support local instance storage, including the
	// total size per instance type, see [Instance Store Volumes].
	//
	// [Instance Store Volumes]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes
	//
	// This member is required.
	VolumeSizeInGB *int32

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt data on the storage volume attached to the
	// ML compute instance(s) that run the processing job.
	//
	// Certain Nitro-based instances include local storage, dependent on the instance
	// type. Local storage volumes are encrypted using a hardware module on the
	// instance. You can't request a VolumeKmsKeyId when using an instance type with
	// local storage.
	//
	// For a list of instance types that support local instance storage, see [Instance Store Volumes].
	//
	// For more information about local instance storage encryption, see [SSD Instance Store Volumes].
	//
	// [SSD Instance Store Volumes]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html
	// [Instance Store Volumes]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes
	VolumeKmsKeyId *string

	noSmithyDocumentSerde
}

// Configuration for processing job outputs in Amazon SageMaker Feature Store.
type ProcessingFeatureStoreOutput struct {

	// The name of the Amazon SageMaker FeatureGroup to use as the destination for
	// processing job output. Note that your processing script is responsible for
	// putting records into your Feature Store.
	//
	// This member is required.
	FeatureGroupName *string

	noSmithyDocumentSerde
}

// The inputs for a processing job. The processing input must specify exactly one
// of either S3Input or DatasetDefinition types.
type ProcessingInput struct {

	// The name for the processing job input.
	//
	// This member is required.
	InputName *string

	// When True , input operations such as data download are managed natively by the
	// processing job application. When False (default), input operations are managed
	// by Amazon SageMaker.
	AppManaged *bool

	// Configuration for a Dataset Definition input.
	DatasetDefinition *DatasetDefinition

	// Configuration for downloading input data from Amazon S3 into the processing
	// container.
	S3Input *ProcessingS3Input

	noSmithyDocumentSerde
}

// An Amazon SageMaker processing job that is used to analyze data and evaluate
// models. For more information, see [Process Data and Evaluate Models].
//
// [Process Data and Evaluate Models]: https://docs.aws.amazon.com/sagemaker/latest/dg/processing-job.html
type ProcessingJob struct {

	// Configuration to run a processing job in a specified container image.
	AppSpecification *AppSpecification

	// The Amazon Resource Name (ARN) of the AutoML job associated with this
	// processing job.
	AutoMLJobArn *string

	// The time the processing job was created.
	CreationTime *time.Time

	// Sets the environment variables in the Docker container.
	Environment map[string]string

	// A string, up to one KB in size, that contains metadata from the processing
	// container when the processing job exits.
	ExitMessage *string

	// Associates a SageMaker job as a trial component with an experiment and trial.
	// Specified when you call the following APIs:
	//
	// [CreateProcessingJob]
	//
	// [CreateTrainingJob]
	//
	// [CreateTransformJob]
	//
	// [CreateTransformJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTransformJob.html
	// [CreateTrainingJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html
	// [CreateProcessingJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html
	ExperimentConfig *ExperimentConfig

	// A string, up to one KB in size, that contains the reason a processing job
	// failed, if it failed.
	FailureReason *string

	// The time the processing job was last modified.
	LastModifiedTime *time.Time

	// The ARN of a monitoring schedule for an endpoint associated with this
	// processing job.
	MonitoringScheduleArn *string

	// Networking options for a job, such as network traffic encryption between
	// containers, whether to allow inbound and outbound network calls to and from
	// containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
	NetworkConfig *NetworkConfig

	// The time that the processing job ended.
	ProcessingEndTime *time.Time

	// List of input configurations for the processing job.
	ProcessingInputs []ProcessingInput

	// The ARN of the processing job.
	ProcessingJobArn *string

	// The name of the processing job.
	ProcessingJobName *string

	// The status of the processing job.
	ProcessingJobStatus ProcessingJobStatus

	// Configuration for uploading output from the processing container.
	ProcessingOutputConfig *ProcessingOutputConfig

	// Identifies the resources, ML compute instances, and ML storage volumes to
	// deploy for a processing job. In distributed training, you specify more than one
	// instance.
	ProcessingResources *ProcessingResources

	// The time that the processing job started.
	ProcessingStartTime *time.Time

	// The ARN of the role used to create the processing job.
	RoleArn *string

	// Configures conditions under which the processing job should be stopped, such as
	// how long the processing job has been running. After the condition is met, the
	// processing job is stopped.
	StoppingCondition *ProcessingStoppingCondition

	// An array of key-value pairs. For more information, see [Using Cost Allocation Tags] in the Amazon Web
	// Services Billing and Cost Management User Guide.
	//
	// [Using Cost Allocation Tags]: https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL
	Tags []Tag

	// The ARN of the training job associated with this processing job.
	TrainingJobArn *string

	noSmithyDocumentSerde
}

// Metadata for a processing job step.
type ProcessingJobStepMetadata struct {

	// The Amazon Resource Name (ARN) of the processing job.
	Arn *string

	noSmithyDocumentSerde
}

// Summary of information about a processing job.
type ProcessingJobSummary struct {

	// The time at which the processing job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the processing job..
	//
	// This member is required.
	ProcessingJobArn *string

	// The name of the processing job.
	//
	// This member is required.
	ProcessingJobName *string

	// The status of the processing job.
	//
	// This member is required.
	ProcessingJobStatus ProcessingJobStatus

	// An optional string, up to one KB in size, that contains metadata from the
	// processing container when the processing job exits.
	ExitMessage *string

	// A string, up to one KB in size, that contains the reason a processing job
	// failed, if it failed.
	FailureReason *string

	// A timestamp that indicates the last time the processing job was modified.
	LastModifiedTime *time.Time

	// The time at which the processing job completed.
	ProcessingEndTime *time.Time

	noSmithyDocumentSerde
}

// Describes the results of a processing job. The processing output must specify
// exactly one of either S3Output or FeatureStoreOutput types.
type ProcessingOutput struct {

	// The name for the processing job output.
	//
	// This member is required.
	OutputName *string

	// When True , output operations such as data upload are managed natively by the
	// processing job application. When False (default), output operations are managed
	// by Amazon SageMaker.
	AppManaged *bool

	// Configuration for processing job outputs in Amazon SageMaker Feature Store.
	// This processing output type is only supported when AppManaged is specified.
	FeatureStoreOutput *ProcessingFeatureStoreOutput

	// Configuration for processing job outputs in Amazon S3.
	S3Output *ProcessingS3Output

	noSmithyDocumentSerde
}

// Configuration for uploading output from the processing container.
type ProcessingOutputConfig struct {

	// An array of outputs configuring the data to upload from the processing
	// container.
	//
	// This member is required.
	Outputs []ProcessingOutput

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt the processing job output. KmsKeyId can
	// be an ID of a KMS key, ARN of a KMS key, alias of a KMS key, or alias of a KMS
	// key. The KmsKeyId is applied to all outputs.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Identifies the resources, ML compute instances, and ML storage volumes to
// deploy for a processing job. In distributed training, you specify more than one
// instance.
type ProcessingResources struct {

	// The configuration for the resources in a cluster used to run the processing job.
	//
	// This member is required.
	ClusterConfig *ProcessingClusterConfig

	noSmithyDocumentSerde
}

// Configuration for downloading input data from Amazon S3 into the processing
// container.
type ProcessingS3Input struct {

	// Whether you use an S3Prefix or a ManifestFile for the data type. If you choose
	// S3Prefix , S3Uri identifies a key name prefix. Amazon SageMaker uses all
	// objects with the specified key name prefix for the processing job. If you choose
	// ManifestFile , S3Uri identifies an object that is a manifest file containing a
	// list of object keys that you want Amazon SageMaker to use for the processing
	// job.
	//
	// This member is required.
	S3DataType ProcessingS3DataType

	// The URI of the Amazon S3 prefix Amazon SageMaker downloads data required to run
	// a processing job.
	//
	// This member is required.
	S3Uri *string

	// The local path in your container where you want Amazon SageMaker to write input
	// data to. LocalPath is an absolute path to the input data and must begin with
	// /opt/ml/processing/ . LocalPath is a required parameter when AppManaged is False
	// (default).
	LocalPath *string

	// Whether to GZIP-decompress the data in Amazon S3 as it is streamed into the
	// processing container. Gzip can only be used when Pipe mode is specified as the
	// S3InputMode . In Pipe mode, Amazon SageMaker streams input data from the source
	// directly to your container without using the EBS volume.
	S3CompressionType ProcessingS3CompressionType

	// Whether to distribute the data from Amazon S3 to all processing instances with
	// FullyReplicated , or whether the data from Amazon S3 is shared by Amazon S3 key,
	// downloading one shard of data to each processing instance.
	S3DataDistributionType ProcessingS3DataDistributionType

	// Whether to use File or Pipe input mode. In File mode, Amazon SageMaker copies
	// the data from the input source onto the local ML storage volume before starting
	// your processing container. This is the most commonly used input mode. In Pipe
	// mode, Amazon SageMaker streams input data from the source directly to your
	// processing container into named pipes without using the ML storage volume.
	S3InputMode ProcessingS3InputMode

	noSmithyDocumentSerde
}

// Configuration for uploading output data to Amazon S3 from the processing
// container.
type ProcessingS3Output struct {

	// The local path of a directory where you want Amazon SageMaker to upload its
	// contents to Amazon S3. LocalPath is an absolute path to a directory containing
	// output files. This directory will be created by the platform and exist when your
	// container's entrypoint is invoked.
	//
	// This member is required.
	LocalPath *string

	// Whether to upload the results of the processing job continuously or after the
	// job completes.
	//
	// This member is required.
	S3UploadMode ProcessingS3UploadMode

	// A URI that identifies the Amazon S3 bucket where you want Amazon SageMaker to
	// save the results of a processing job.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// Configures conditions under which the processing job should be stopped, such as
// how long the processing job has been running. After the condition is met, the
// processing job is stopped.
type ProcessingStoppingCondition struct {

	// Specifies the maximum runtime in seconds.
	//
	// This member is required.
	MaxRuntimeInSeconds *int32

	noSmithyDocumentSerde
}

//	Identifies a model that you want to host and the resources chosen to deploy
//
// for hosting it. If you are deploying multiple models, tell SageMaker how to
// distribute traffic among the models by specifying variant weights. For more
// information on production variants, check [Production variants].
//
// [Production variants]: https://docs.aws.amazon.com/sagemaker/latest/dg/model-ab-testing.html
type ProductionVariant struct {

	// The name of the production variant.
	//
	// This member is required.
	VariantName *string

	// The size of the Elastic Inference (EI) instance to use for the production
	// variant. EI instances provide on-demand GPU computing for inference. For more
	// information, see [Using Elastic Inference in Amazon SageMaker].
	//
	// [Using Elastic Inference in Amazon SageMaker]: https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html
	AcceleratorType ProductionVariantAcceleratorType

	// The timeout value, in seconds, for your inference container to pass health
	// check by SageMaker Hosting. For more information about health check, see [How Your Container Should Respond to Health Check (Ping) Requests].
	//
	// [How Your Container Should Respond to Health Check (Ping) Requests]: https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests
	ContainerStartupHealthCheckTimeoutInSeconds *int32

	// Specifies configuration for a core dump from the model container when the
	// process crashes.
	CoreDumpConfig *ProductionVariantCoreDumpConfig

	//  You can use this parameter to turn on native Amazon Web Services Systems
	// Manager (SSM) access for a production variant behind an endpoint. By default,
	// SSM access is disabled for all production variants behind an endpoint. You can
	// turn on or turn off SSM access for a production variant behind an existing
	// endpoint by creating a new endpoint configuration and calling UpdateEndpoint .
	EnableSSMAccess *bool

	// Number of instances to launch initially.
	InitialInstanceCount *int32

	// Determines initial traffic distribution among all of the models that you
	// specify in the endpoint configuration. The traffic to a production variant is
	// determined by the ratio of the VariantWeight to the sum of all VariantWeight
	// values across all ProductionVariants. If unspecified, it defaults to 1.0.
	InitialVariantWeight *float32

	// The ML compute instance type.
	InstanceType ProductionVariantInstanceType

	// Settings that control the range in the number of instances that the endpoint
	// provisions as it scales up or down to accommodate traffic.
	ManagedInstanceScaling *ProductionVariantManagedInstanceScaling

	// The timeout value, in seconds, to download and extract the model that you want
	// to host from Amazon S3 to the individual inference instance associated with this
	// production variant.
	ModelDataDownloadTimeoutInSeconds *int32

	// The name of the model that you want to host. This is the name that you
	// specified when creating the model.
	ModelName *string

	// Settings that control how the endpoint routes incoming traffic to the instances
	// that the endpoint hosts.
	RoutingConfig *ProductionVariantRoutingConfig

	// The serverless configuration for an endpoint. Specifies a serverless endpoint
	// configuration instead of an instance-based endpoint configuration.
	ServerlessConfig *ProductionVariantServerlessConfig

	// The size, in GB, of the ML storage volume attached to individual inference
	// instance associated with the production variant. Currently only Amazon EBS gp2
	// storage volumes are supported.
	VolumeSizeInGB *int32

	noSmithyDocumentSerde
}

// Specifies configuration for a core dump from the model container when the
// process crashes.
type ProductionVariantCoreDumpConfig struct {

	// The Amazon S3 bucket to send the core dump to.
	//
	// This member is required.
	DestinationS3Uri *string

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that SageMaker uses to encrypt the core dump data at rest using Amazon S3
	// server-side encryption. The KmsKeyId can be any of the following formats:
	//
	//   - // KMS Key ID
	//
	// "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//   - // Amazon Resource Name (ARN) of a KMS Key
	//
	// "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//   - // KMS Key Alias
	//
	// "alias/ExampleAlias"
	//
	//   - // Amazon Resource Name (ARN) of a KMS Key Alias
	//
	// "arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"
	//
	// If you use a KMS key ID or an alias of your KMS key, the SageMaker execution
	// role must include permissions to call kms:Encrypt . If you don't provide a KMS
	// key ID, SageMaker uses the default KMS key for Amazon S3 for your role's
	// account. SageMaker uses server-side encryption with KMS-managed keys for
	// OutputDataConfig . If you use a bucket policy with an s3:PutObject permission
	// that only allows objects with server-side encryption, set the condition key of
	// s3:x-amz-server-side-encryption to "aws:kms" . For more information, see [KMS-Managed Encryption Keys] in
	// the Amazon Simple Storage Service Developer Guide.
	//
	// The KMS key policy must grant permission to the IAM role that you specify in
	// your CreateEndpoint and UpdateEndpoint requests. For more information, see [Using Key Policies in Amazon Web Services KMS] in
	// the Amazon Web Services Key Management Service Developer Guide.
	//
	// [KMS-Managed Encryption Keys]: https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html
	// [Using Key Policies in Amazon Web Services KMS]: https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Settings that control the range in the number of instances that the endpoint
// provisions as it scales up or down to accommodate traffic.
type ProductionVariantManagedInstanceScaling struct {

	// The maximum number of instances that the endpoint can provision when it scales
	// up to accommodate an increase in traffic.
	MaxInstanceCount *int32

	// The minimum number of instances that the endpoint must retain when it scales
	// down to accommodate a decrease in traffic.
	MinInstanceCount *int32

	// Indicates whether managed instance scaling is enabled.
	Status ManagedInstanceScalingStatus

	noSmithyDocumentSerde
}

// Settings that control how the endpoint routes incoming traffic to the instances
// that the endpoint hosts.
type ProductionVariantRoutingConfig struct {

	// Sets how the endpoint routes incoming traffic:
	//
	//   - LEAST_OUTSTANDING_REQUESTS : The endpoint routes requests to the specific
	//   instances that have more capacity to process them.
	//
	//   - RANDOM : The endpoint routes each request to a randomly chosen instance.
	//
	// This member is required.
	RoutingStrategy RoutingStrategy

	noSmithyDocumentSerde
}

// Specifies the serverless configuration for an endpoint variant.
type ProductionVariantServerlessConfig struct {

	// The maximum number of concurrent invocations your serverless endpoint can
	// process.
	//
	// This member is required.
	MaxConcurrency *int32

	// The memory size of your serverless endpoint. Valid values are in 1 GB
	// increments: 1024 MB, 2048 MB, 3072 MB, 4096 MB, 5120 MB, or 6144 MB.
	//
	// This member is required.
	MemorySizeInMB *int32

	// The amount of provisioned concurrency to allocate for the serverless endpoint.
	// Should be less than or equal to MaxConcurrency .
	//
	// This field is not supported for serverless endpoint recommendations for
	// Inference Recommender jobs. For more information about creating an Inference
	// Recommender job, see [CreateInferenceRecommendationsJobs].
	//
	// [CreateInferenceRecommendationsJobs]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceRecommendationsJob.html
	ProvisionedConcurrency *int32

	noSmithyDocumentSerde
}

// Specifies the serverless update concurrency configuration for an endpoint
// variant.
type ProductionVariantServerlessUpdateConfig struct {

	// The updated maximum number of concurrent invocations your serverless endpoint
	// can process.
	MaxConcurrency *int32

	// The updated amount of provisioned concurrency to allocate for the serverless
	// endpoint. Should be less than or equal to MaxConcurrency .
	ProvisionedConcurrency *int32

	noSmithyDocumentSerde
}

// Describes the status of the production variant.
type ProductionVariantStatus struct {

	// The endpoint variant status which describes the current deployment stage status
	// or operational status.
	//
	//   - Creating : Creating inference resources for the production variant.
	//
	//   - Deleting : Terminating inference resources for the production variant.
	//
	//   - Updating : Updating capacity for the production variant.
	//
	//   - ActivatingTraffic : Turning on traffic for the production variant.
	//
	//   - Baking : Waiting period to monitor the CloudWatch alarms in the automatic
	//   rollback configuration.
	//
	// This member is required.
	Status VariantStatus

	// The start time of the current status change.
	StartTime *time.Time

	// A message that describes the status of the production variant.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Describes weight and capacities for a production variant associated with an
// endpoint. If you sent a request to the UpdateEndpointWeightsAndCapacities API
// and the endpoint status is Updating , you get different desired and current
// values.
type ProductionVariantSummary struct {

	// The name of the variant.
	//
	// This member is required.
	VariantName *string

	// The number of instances associated with the variant.
	CurrentInstanceCount *int32

	// The serverless configuration for the endpoint.
	CurrentServerlessConfig *ProductionVariantServerlessConfig

	// The weight associated with the variant.
	CurrentWeight *float32

	// An array of DeployedImage objects that specify the Amazon EC2 Container
	// Registry paths of the inference images deployed on instances of this
	// ProductionVariant .
	DeployedImages []DeployedImage

	// The number of instances requested in the UpdateEndpointWeightsAndCapacities
	// request.
	DesiredInstanceCount *int32

	// The serverless configuration requested for the endpoint update.
	DesiredServerlessConfig *ProductionVariantServerlessConfig

	// The requested weight, as specified in the UpdateEndpointWeightsAndCapacities
	// request.
	DesiredWeight *float32

	// Settings that control the range in the number of instances that the endpoint
	// provisions as it scales up or down to accommodate traffic.
	ManagedInstanceScaling *ProductionVariantManagedInstanceScaling

	// Settings that control how the endpoint routes incoming traffic to the instances
	// that the endpoint hosts.
	RoutingConfig *ProductionVariantRoutingConfig

	// The endpoint variant status which describes the current deployment stage status
	// or operational status.
	VariantStatus []ProductionVariantStatus

	noSmithyDocumentSerde
}

// Configuration information for Amazon SageMaker Debugger system monitoring,
// framework profiling, and storage paths.
type ProfilerConfig struct {

	// Configuration to turn off Amazon SageMaker Debugger's system monitoring and
	// profiling functionality. To turn it off, set to True .
	DisableProfiler *bool

	// A time interval for capturing system metrics in milliseconds. Available values
	// are 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000 (1 minute)
	// milliseconds. The default value is 500 milliseconds.
	ProfilingIntervalInMilliseconds *int64

	// Configuration information for capturing framework metrics. Available key
	// strings for different profiling options are DetailedProfilingConfig ,
	// PythonProfilingConfig , and DataLoaderProfilingConfig . The following codes are
	// configuration structures for the ProfilingParameters parameter. To learn more
	// about how to configure the ProfilingParameters parameter, see [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job].
	//
	// [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job]: https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html
	ProfilingParameters map[string]string

	// Path to Amazon S3 storage location for system and framework metrics.
	S3OutputPath *string

	noSmithyDocumentSerde
}

// Configuration information for updating the Amazon SageMaker Debugger profile
// parameters, system and framework metrics configurations, and storage paths.
type ProfilerConfigForUpdate struct {

	// To turn off Amazon SageMaker Debugger monitoring and profiling while a training
	// job is in progress, set to True .
	DisableProfiler *bool

	// A time interval for capturing system metrics in milliseconds. Available values
	// are 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000 (1 minute)
	// milliseconds. The default value is 500 milliseconds.
	ProfilingIntervalInMilliseconds *int64

	// Configuration information for capturing framework metrics. Available key
	// strings for different profiling options are DetailedProfilingConfig ,
	// PythonProfilingConfig , and DataLoaderProfilingConfig . The following codes are
	// configuration structures for the ProfilingParameters parameter. To learn more
	// about how to configure the ProfilingParameters parameter, see [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job].
	//
	// [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job]: https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html
	ProfilingParameters map[string]string

	// Path to Amazon S3 storage location for system and framework metrics.
	S3OutputPath *string

	noSmithyDocumentSerde
}

// Configuration information for profiling rules.
type ProfilerRuleConfiguration struct {

	// The name of the rule configuration. It must be unique relative to other rule
	// configuration names.
	//
	// This member is required.
	RuleConfigurationName *string

	// The Amazon Elastic Container Registry Image for the managed rule evaluation.
	//
	// This member is required.
	RuleEvaluatorImage *string

	// The instance type to deploy a custom rule for profiling a training job.
	InstanceType ProcessingInstanceType

	// Path to local storage location for output of rules. Defaults to
	// /opt/ml/processing/output/rule/ .
	LocalPath *string

	// Runtime configuration for rule container.
	RuleParameters map[string]string

	// Path to Amazon S3 storage location for rules.
	S3OutputPath *string

	// The size, in GB, of the ML storage volume attached to the processing instance.
	VolumeSizeInGB *int32

	noSmithyDocumentSerde
}

// Information about the status of the rule evaluation.
type ProfilerRuleEvaluationStatus struct {

	// Timestamp when the rule evaluation status was last modified.
	LastModifiedTime *time.Time

	// The name of the rule configuration.
	RuleConfigurationName *string

	// The Amazon Resource Name (ARN) of the rule evaluation job.
	RuleEvaluationJobArn *string

	// Status of the rule evaluation.
	RuleEvaluationStatus RuleEvaluationStatus

	// Details from the rule evaluation.
	StatusDetails *string

	noSmithyDocumentSerde
}

// The properties of a project as returned by the Search API.
type Project struct {

	// Who created the project.
	CreatedBy *UserContext

	// A timestamp specifying when the project was created.
	CreationTime *time.Time

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	LastModifiedBy *UserContext

	// A timestamp container for when the project was last modified.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the project.
	ProjectArn *string

	// The description of the project.
	ProjectDescription *string

	// The ID of the project.
	ProjectId *string

	// The name of the project.
	ProjectName *string

	// The status of the project.
	ProjectStatus ProjectStatus

	// Details of a provisioned service catalog product. For information about service
	// catalog, see [What is Amazon Web Services Service Catalog].
	//
	// [What is Amazon Web Services Service Catalog]: https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html
	ServiceCatalogProvisionedProductDetails *ServiceCatalogProvisionedProductDetails

	// Details that you specify to provision a service catalog product. For
	// information about service catalog, see [What is Amazon Web Services Service Catalog].
	//
	// [What is Amazon Web Services Service Catalog]: https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html
	ServiceCatalogProvisioningDetails *ServiceCatalogProvisioningDetails

	// An array of key-value pairs. You can use tags to categorize your Amazon Web
	// Services resources in different ways, for example, by purpose, owner, or
	// environment. For more information, see [Tagging Amazon Web Services Resources].
	//
	// [Tagging Amazon Web Services Resources]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
	Tags []Tag

	noSmithyDocumentSerde
}

// Information about a project.
type ProjectSummary struct {

	// The time that the project was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the project.
	//
	// This member is required.
	ProjectArn *string

	// The ID of the project.
	//
	// This member is required.
	ProjectId *string

	// The name of the project.
	//
	// This member is required.
	ProjectName *string

	// The status of the project.
	//
	// This member is required.
	ProjectStatus ProjectStatus

	// The description of the project.
	ProjectDescription *string

	noSmithyDocumentSerde
}

// Part of the SuggestionQuery type. Specifies a hint for retrieving property
// names that begin with the specified text.
type PropertyNameQuery struct {

	// Text that begins a property's name.
	//
	// This member is required.
	PropertyNameHint *string

	noSmithyDocumentSerde
}

// A property name returned from a GetSearchSuggestions call that specifies a
// value in the PropertyNameQuery field.
type PropertyNameSuggestion struct {

	// A suggested property name based on what you entered in the search textbox in
	// the SageMaker console.
	PropertyName *string

	noSmithyDocumentSerde
}

// A key value pair used when you provision a project as a service catalog
// product. For information, see [What is Amazon Web Services Service Catalog].
//
// [What is Amazon Web Services Service Catalog]: https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html
type ProvisioningParameter struct {

	// The key that identifies a provisioning parameter.
	Key *string

	// The value of the provisioning parameter.
	Value *string

	noSmithyDocumentSerde
}

// Defines the amount of money paid to an Amazon Mechanical Turk worker for each
// task performed.
//
// Use one of the following prices for bounding box tasks. Prices are in US
// dollars and should be based on the complexity of the task; the longer it takes
// in your initial testing, the more you should offer.
//
//   - 0.036
//
//   - 0.048
//
//   - 0.060
//
//   - 0.072
//
//   - 0.120
//
//   - 0.240
//
//   - 0.360
//
//   - 0.480
//
//   - 0.600
//
//   - 0.720
//
//   - 0.840
//
//   - 0.960
//
//   - 1.080
//
//   - 1.200
//
// Use one of the following prices for image classification, text classification,
// and custom tasks. Prices are in US dollars.
//
//   - 0.012
//
//   - 0.024
//
//   - 0.036
//
//   - 0.048
//
//   - 0.060
//
//   - 0.072
//
//   - 0.120
//
//   - 0.240
//
//   - 0.360
//
//   - 0.480
//
//   - 0.600
//
//   - 0.720
//
//   - 0.840
//
//   - 0.960
//
//   - 1.080
//
//   - 1.200
//
// Use one of the following prices for semantic segmentation tasks. Prices are in
// US dollars.
//
//   - 0.840
//
//   - 0.960
//
//   - 1.080
//
//   - 1.200
//
// Use one of the following prices for Textract AnalyzeDocument Important Form Key
// Amazon Augmented AI review tasks. Prices are in US dollars.
//
//   - 2.400
//
//   - 2.280
//
//   - 2.160
//
//   - 2.040
//
//   - 1.920
//
//   - 1.800
//
//   - 1.680
//
//   - 1.560
//
//   - 1.440
//
//   - 1.320
//
//   - 1.200
//
//   - 1.080
//
//   - 0.960
//
//   - 0.840
//
//   - 0.720
//
//   - 0.600
//
//   - 0.480
//
//   - 0.360
//
//   - 0.240
//
//   - 0.120
//
//   - 0.072
//
//   - 0.060
//
//   - 0.048
//
//   - 0.036
//
//   - 0.024
//
//   - 0.012
//
// Use one of the following prices for Rekognition DetectModerationLabels Amazon
// Augmented AI review tasks. Prices are in US dollars.
//
//   - 1.200
//
//   - 1.080
//
//   - 0.960
//
//   - 0.840
//
//   - 0.720
//
//   - 0.600
//
//   - 0.480
//
//   - 0.360
//
//   - 0.240
//
//   - 0.120
//
//   - 0.072
//
//   - 0.060
//
//   - 0.048
//
//   - 0.036
//
//   - 0.024
//
//   - 0.012
//
// Use one of the following prices for Amazon Augmented AI custom human review
// tasks. Prices are in US dollars.
//
//   - 1.200
//
//   - 1.080
//
//   - 0.960
//
//   - 0.840
//
//   - 0.720
//
//   - 0.600
//
//   - 0.480
//
//   - 0.360
//
//   - 0.240
//
//   - 0.120
//
//   - 0.072
//
//   - 0.060
//
//   - 0.048
//
//   - 0.036
//
//   - 0.024
//
//   - 0.012
type PublicWorkforceTaskPrice struct {

	// Defines the amount of money paid to an Amazon Mechanical Turk worker in United
	// States dollars.
	AmountInUsd *USD

	noSmithyDocumentSerde
}

// Container for the metadata for a Quality check step. For more information, see
// the topic on [QualityCheck step]in the Amazon SageMaker Developer Guide.
//
// [QualityCheck step]: https://docs.aws.amazon.com/sagemaker/latest/dg/build-and-manage-steps.html#step-type-quality-check
type QualityCheckStepMetadata struct {

	// The Amazon S3 URI of the baseline constraints file used for the drift check.
	BaselineUsedForDriftCheckConstraints *string

	// The Amazon S3 URI of the baseline statistics file used for the drift check.
	BaselineUsedForDriftCheckStatistics *string

	// The Amazon S3 URI of the newly calculated baseline constraints file.
	CalculatedBaselineConstraints *string

	// The Amazon S3 URI of the newly calculated baseline statistics file.
	CalculatedBaselineStatistics *string

	// The Amazon Resource Name (ARN) of the Quality check processing job that was run
	// by this step execution.
	CheckJobArn *string

	// The type of the Quality check step.
	CheckType *string

	// The model package group name.
	ModelPackageGroupName *string

	// This flag indicates if a newly calculated baseline can be accessed through step
	// properties BaselineUsedForDriftCheckConstraints and
	// BaselineUsedForDriftCheckStatistics . If it is set to False , the previous
	// baseline of the configured check type must also be available. These can be
	// accessed through the BaselineUsedForDriftCheckConstraints and
	// BaselineUsedForDriftCheckStatistics properties.
	RegisterNewBaseline *bool

	// This flag indicates if the drift check against the previous baseline will be
	// skipped or not. If it is set to False , the previous baseline of the configured
	// check type must be available.
	SkipCheck *bool

	// The Amazon S3 URI of violation report if violations are detected.
	ViolationReport *string

	noSmithyDocumentSerde
}

// A set of filters to narrow the set of lineage entities connected to the StartArn
// (s) returned by the QueryLineage API action.
type QueryFilters struct {

	// Filter the lineage entities connected to the StartArn (s) after the create date.
	CreatedAfter *time.Time

	// Filter the lineage entities connected to the StartArn (s) by created date.
	CreatedBefore *time.Time

	// Filter the lineage entities connected to the StartArn (s) by the type of the
	// lineage entity.
	LineageTypes []LineageType

	// Filter the lineage entities connected to the StartArn (s) after the last
	// modified date.
	ModifiedAfter *time.Time

	// Filter the lineage entities connected to the StartArn (s) before the last
	// modified date.
	ModifiedBefore *time.Time

	// Filter the lineage entities connected to the StartArn (s) by a set if property
	// key value pairs. If multiple pairs are provided, an entity is included in the
	// results if it matches any of the provided pairs.
	Properties map[string]string

	// Filter the lineage entities connected to the StartArn by type. For example:
	// DataSet , Model , Endpoint , or ModelDeployment .
	Types []string

	noSmithyDocumentSerde
}

// The infrastructure configuration for deploying the model to a real-time
// inference endpoint.
type RealTimeInferenceConfig struct {

	// The number of instances of the type specified by InstanceType .
	//
	// This member is required.
	InstanceCount *int32

	// The instance type the model is deployed to.
	//
	// This member is required.
	InstanceType InstanceType

	noSmithyDocumentSerde
}

// The recommended configuration to use for Real-Time Inference.
type RealTimeInferenceRecommendation struct {

	// The recommended instance type for Real-Time Inference.
	//
	// This member is required.
	InstanceType ProductionVariantInstanceType

	// The recommendation ID which uniquely identifies each recommendation.
	//
	// This member is required.
	RecommendationId *string

	// The recommended environment variables to set in the model container for
	// Real-Time Inference.
	Environment map[string]string

	noSmithyDocumentSerde
}

// Provides information about the output configuration for the compiled model.
type RecommendationJobCompiledOutputConfig struct {

	// Identifies the Amazon S3 bucket where you want SageMaker to store the compiled
	// model artifacts.
	S3OutputUri *string

	noSmithyDocumentSerde
}

// Specifies mandatory fields for running an Inference Recommender job directly in
// the [CreateInferenceRecommendationsJob]API. The fields specified in ContainerConfig override the corresponding
// fields in the model package. Use ContainerConfig if you want to specify these
// fields for the recommendation job but don't want to edit them in your model
// package.
//
// [CreateInferenceRecommendationsJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateInferenceRecommendationsJob.html
type RecommendationJobContainerConfig struct {

	// Specifies the name and shape of the expected data inputs for your trained model
	// with a JSON dictionary form. This field is used for optimizing your model using
	// SageMaker Neo. For more information, see [DataInputConfig].
	//
	// [DataInputConfig]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_InputConfig.html#sagemaker-Type-InputConfig-DataInputConfig
	DataInputConfig *string

	// The machine learning domain of the model and its components.
	//
	// Valid Values: COMPUTER_VISION | NATURAL_LANGUAGE_PROCESSING | MACHINE_LEARNING
	Domain *string

	// The machine learning framework of the container image.
	//
	// Valid Values: TENSORFLOW | PYTORCH | XGBOOST | SAGEMAKER-SCIKIT-LEARN
	Framework *string

	// The framework version of the container image.
	FrameworkVersion *string

	// The name of a pre-trained machine learning model benchmarked by Amazon
	// SageMaker Inference Recommender that matches your model.
	//
	// Valid Values: efficientnetb7 | unet | xgboost | faster-rcnn-resnet101 |
	// nasnetlarge | vgg16 | inception-v3 | mask-rcnn | sagemaker-scikit-learn |
	// densenet201-gluon | resnet18v2-gluon | xception | densenet201 | yolov4 |
	// resnet152 | bert-base-cased | xceptionV1-keras | resnet50 | retinanet
	NearestModelName *string

	// Specifies the SamplePayloadUrl and all other sample payload-related fields.
	PayloadConfig *RecommendationJobPayloadConfig

	// The endpoint type to receive recommendations for. By default this is null, and
	// the results of the inference recommendation job return a combined list of both
	// real-time and serverless benchmarks. By specifying a value for this field, you
	// can receive a longer list of benchmarks for the desired endpoint type.
	SupportedEndpointType RecommendationJobSupportedEndpointType

	// A list of the instance types that are used to generate inferences in real-time.
	SupportedInstanceTypes []string

	// The supported MIME types for the output data.
	SupportedResponseMIMETypes []string

	// The machine learning task that the model accomplishes.
	//
	// Valid Values: IMAGE_CLASSIFICATION | OBJECT_DETECTION | TEXT_GENERATION |
	// IMAGE_SEGMENTATION | FILL_MASK | CLASSIFICATION | REGRESSION | OTHER
	Task *string

	noSmithyDocumentSerde
}

// The details for a specific benchmark from an Inference Recommender job.
type RecommendationJobInferenceBenchmark struct {

	// Defines the model configuration. Includes the specification name and
	// environment parameters.
	//
	// This member is required.
	ModelConfiguration *ModelConfiguration

	// The endpoint configuration made by Inference Recommender during a
	// recommendation job.
	EndpointConfiguration *EndpointOutputConfiguration

	// The metrics for an existing endpoint compared in an Inference Recommender job.
	EndpointMetrics *InferenceMetrics

	// The reason why a benchmark failed.
	FailureReason *string

	// A timestamp that shows when the benchmark completed.
	InvocationEndTime *time.Time

	// A timestamp that shows when the benchmark started.
	InvocationStartTime *time.Time

	// The metrics of recommendations.
	Metrics *RecommendationMetrics

	noSmithyDocumentSerde
}

// The input configuration of the recommendation job.
type RecommendationJobInputConfig struct {

	// Specifies mandatory fields for running an Inference Recommender job. The fields
	// specified in ContainerConfig override the corresponding fields in the model
	// package.
	ContainerConfig *RecommendationJobContainerConfig

	// Specifies the endpoint configuration to use for a job.
	EndpointConfigurations []EndpointInputConfiguration

	// Existing customer endpoints on which to run an Inference Recommender job.
	Endpoints []EndpointInfo

	// Specifies the maximum duration of the job, in seconds. The maximum value is
	// 18,000 seconds.
	JobDurationInSeconds *int32

	// The name of the created model.
	ModelName *string

	// The Amazon Resource Name (ARN) of a versioned model package.
	ModelPackageVersionArn *string

	// Defines the resource limit of the job.
	ResourceLimit *RecommendationJobResourceLimit

	// Specifies the traffic pattern of the job.
	TrafficPattern *TrafficPattern

	// The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service
	// (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt data on the
	// storage volume attached to the ML compute instance that hosts the endpoint. This
	// key will be passed to SageMaker Hosting for endpoint creation.
	//
	// The SageMaker execution role must have kms:CreateGrant permission in order to
	// encrypt data on the storage volume of the endpoints created for inference
	// recommendation. The inference recommendation job will fail asynchronously during
	// endpoint configuration creation if the role passed does not have kms:CreateGrant
	// permission.
	//
	// The KmsKeyId can be any of the following formats:
	//
	//   - // KMS Key ID
	//
	// "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//   - // Amazon Resource Name (ARN) of a KMS Key
	//
	// "arn:aws:kms:::key/"
	//
	//   - // KMS Key Alias
	//
	// "alias/ExampleAlias"
	//
	//   - // Amazon Resource Name (ARN) of a KMS Key Alias
	//
	// "arn:aws:kms:::alias/"
	//
	// For more information about key identifiers, see [Key identifiers (KeyID)] in the Amazon Web Services Key
	// Management Service (Amazon Web Services KMS) documentation.
	//
	// [Key identifiers (KeyID)]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id
	VolumeKmsKeyId *string

	// Inference Recommender provisions SageMaker endpoints with access to VPC in the
	// inference recommendation job.
	VpcConfig *RecommendationJobVpcConfig

	noSmithyDocumentSerde
}

// Provides information about the output configuration for the compiled model.
type RecommendationJobOutputConfig struct {

	// Provides information about the output configuration for the compiled model.
	CompiledOutputConfig *RecommendationJobCompiledOutputConfig

	// The Amazon Resource Name (ARN) of a Amazon Web Services Key Management Service
	// (Amazon Web Services KMS) key that Amazon SageMaker uses to encrypt your output
	// artifacts with Amazon S3 server-side encryption. The SageMaker execution role
	// must have kms:GenerateDataKey permission.
	//
	// The KmsKeyId can be any of the following formats:
	//
	//   - // KMS Key ID
	//
	// "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//   - // Amazon Resource Name (ARN) of a KMS Key
	//
	// "arn:aws:kms:::key/"
	//
	//   - // KMS Key Alias
	//
	// "alias/ExampleAlias"
	//
	//   - // Amazon Resource Name (ARN) of a KMS Key Alias
	//
	// "arn:aws:kms:::alias/"
	//
	// For more information about key identifiers, see [Key identifiers (KeyID)] in the Amazon Web Services Key
	// Management Service (Amazon Web Services KMS) documentation.
	//
	// [Key identifiers (KeyID)]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-id
	KmsKeyId *string

	noSmithyDocumentSerde
}

// The configuration for the payload for a recommendation job.
type RecommendationJobPayloadConfig struct {

	// The Amazon Simple Storage Service (Amazon S3) path where the sample payload is
	// stored. This path must point to a single gzip compressed tar archive (.tar.gz
	// suffix).
	SamplePayloadUrl *string

	// The supported MIME types for the input data.
	SupportedContentTypes []string

	noSmithyDocumentSerde
}

// Specifies the maximum number of jobs that can run in parallel and the maximum
// number of jobs that can run.
type RecommendationJobResourceLimit struct {

	// Defines the maximum number of load tests.
	MaxNumberOfTests *int32

	// Defines the maximum number of parallel load tests.
	MaxParallelOfTests *int32

	noSmithyDocumentSerde
}

// Specifies conditions for stopping a job. When a job reaches a stopping
// condition limit, SageMaker ends the job.
type RecommendationJobStoppingConditions struct {

	// Stops a load test when the number of invocations (TPS) peaks and flattens,
	// which means that the instance has reached capacity. The default value is Stop .
	// If you want the load test to continue after invocations have flattened, set the
	// value to Continue .
	FlatInvocations FlatInvocations

	// The maximum number of requests per minute expected for the endpoint.
	MaxInvocations *int32

	// The interval of time taken by a model to respond as viewed from SageMaker. The
	// interval includes the local communication time taken to send the request and to
	// fetch the response from the container of a model and the time taken to complete
	// the inference in the container.
	ModelLatencyThresholds []ModelLatencyThreshold

	noSmithyDocumentSerde
}

// Inference Recommender provisions SageMaker endpoints with access to VPC in the
// inference recommendation job.
type RecommendationJobVpcConfig struct {

	// The VPC security group IDs. IDs have the form of sg-xxxxxxxx . Specify the
	// security groups for the VPC that is specified in the Subnets field.
	//
	// This member is required.
	SecurityGroupIds []string

	// The ID of the subnets in the VPC to which you want to connect your model.
	//
	// This member is required.
	Subnets []string

	noSmithyDocumentSerde
}

// The metrics of recommendations.
type RecommendationMetrics struct {

	// Defines the cost per hour for the instance.
	//
	// This member is required.
	CostPerHour *float32

	// Defines the cost per inference for the instance .
	//
	// This member is required.
	CostPerInference *float32

	// The expected maximum number of requests per minute for the instance.
	//
	// This member is required.
	MaxInvocations *int32

	// The expected model latency at maximum invocation per minute for the instance.
	//
	// This member is required.
	ModelLatency *int32

	// The expected CPU utilization at maximum invocations per minute for the instance.
	//
	// NaN indicates that the value is not available.
	CpuUtilization *float32

	// The expected memory utilization at maximum invocations per minute for the
	// instance.
	//
	// NaN indicates that the value is not available.
	MemoryUtilization *float32

	// The time it takes to launch new compute resources for a serverless endpoint.
	// The time can vary depending on the model size, how long it takes to download the
	// model, and the start-up time of the container.
	//
	// NaN indicates that the value is not available.
	ModelSetupTime *int32

	noSmithyDocumentSerde
}

// Configuration for Redshift Dataset Definition input.
type RedshiftDatasetDefinition struct {

	// The Redshift cluster Identifier.
	//
	// This member is required.
	ClusterId *string

	// The IAM role attached to your Redshift cluster that Amazon SageMaker uses to
	// generate datasets.
	//
	// This member is required.
	ClusterRoleArn *string

	// The name of the Redshift database used in Redshift query execution.
	//
	// This member is required.
	Database *string

	// The database user name used in Redshift query execution.
	//
	// This member is required.
	DbUser *string

	// The data storage format for Redshift query results.
	//
	// This member is required.
	OutputFormat RedshiftResultFormat

	// The location in Amazon S3 where the Redshift query results are stored.
	//
	// This member is required.
	OutputS3Uri *string

	// The SQL query statements to be executed.
	//
	// This member is required.
	QueryString *string

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt data from a Redshift execution.
	KmsKeyId *string

	// The compression used for Redshift query results.
	OutputCompression RedshiftResultCompressionType

	noSmithyDocumentSerde
}

// Metadata for a register model job step.
type RegisterModelStepMetadata struct {

	// The Amazon Resource Name (ARN) of the model package.
	Arn *string

	noSmithyDocumentSerde
}

// Configuration for remote debugging for the [CreateTrainingJob] API. To learn more about the remote
// debugging functionality of SageMaker, see [Access a training container through Amazon Web Services Systems Manager (SSM) for remote debugging].
//
// [Access a training container through Amazon Web Services Systems Manager (SSM) for remote debugging]: https://docs.aws.amazon.com/sagemaker/latest/dg/train-remote-debugging.html
// [CreateTrainingJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html
type RemoteDebugConfig struct {

	// If set to True, enables remote debugging.
	EnableRemoteDebug *bool

	noSmithyDocumentSerde
}

// Configuration for remote debugging for the [UpdateTrainingJob] API. To learn more about the remote
// debugging functionality of SageMaker, see [Access a training container through Amazon Web Services Systems Manager (SSM) for remote debugging].
//
// [UpdateTrainingJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateTrainingJob.html
// [Access a training container through Amazon Web Services Systems Manager (SSM) for remote debugging]: https://docs.aws.amazon.com/sagemaker/latest/dg/train-remote-debugging.html
type RemoteDebugConfigForUpdate struct {

	// If set to True, enables remote debugging.
	EnableRemoteDebug *bool

	noSmithyDocumentSerde
}

// Contains input values for a task.
type RenderableTask struct {

	// A JSON object that contains values for the variables defined in the template.
	// It is made available to the template under the substitution variable task.input
	// . For example, if you define a variable task.input.text in your template, you
	// can supply the variable in the JSON object as "text": "sample text" .
	//
	// This member is required.
	Input *string

	noSmithyDocumentSerde
}

// A description of an error that occurred while rendering the template.
type RenderingError struct {

	// A unique identifier for a specific class of errors.
	//
	// This member is required.
	Code *string

	// A human-readable message describing the error.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// Specifies an authentication configuration for the private docker registry where
// your model image is hosted. Specify a value for this property only if you
// specified Vpc as the value for the RepositoryAccessMode field of the ImageConfig
// object that you passed to a call to CreateModel and the private Docker registry
// where the model image is hosted requires authentication.
type RepositoryAuthConfig struct {

	// The Amazon Resource Name (ARN) of an Amazon Web Services Lambda function that
	// provides credentials to authenticate to the private Docker registry where your
	// model image is hosted. For information about how to create an Amazon Web
	// Services Lambda function, see [Create a Lambda function with the console]in the Amazon Web Services Lambda Developer Guide.
	//
	// [Create a Lambda function with the console]: https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html
	//
	// This member is required.
	RepositoryCredentialsProviderArn *string

	noSmithyDocumentSerde
}

// The resolved attributes.
type ResolvedAttributes struct {

	// Specifies a metric to minimize or maximize as the objective of an AutoML job.
	AutoMLJobObjective *AutoMLJobObjective

	// How long a job is allowed to run, or how many candidates a job is allowed to
	// generate.
	CompletionCriteria *AutoMLJobCompletionCriteria

	// The problem type.
	ProblemType ProblemType

	noSmithyDocumentSerde
}

//	A resource catalog containing all of the resources of a specific resource type
//
// within a resource owner account. For an example on sharing the Amazon SageMaker
// Feature Store DefaultFeatureGroupCatalog , see [Share Amazon SageMaker Catalog resource type] in the Amazon SageMaker
// Developer Guide.
//
// [Share Amazon SageMaker Catalog resource type]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/feature-store-cross-account-discoverability-share-sagemaker-catalog.html
type ResourceCatalog struct {

	//  The time the ResourceCatalog was created.
	//
	// This member is required.
	CreationTime *time.Time

	//  A free form description of the ResourceCatalog .
	//
	// This member is required.
	Description *string

	//  The Amazon Resource Name (ARN) of the ResourceCatalog .
	//
	// This member is required.
	ResourceCatalogArn *string

	//  The name of the ResourceCatalog .
	//
	// This member is required.
	ResourceCatalogName *string

	noSmithyDocumentSerde
}

// Describes the resources, including machine learning (ML) compute instances and
// ML storage volumes, to use for model training.
type ResourceConfig struct {

	// The size of the ML storage volume that you want to provision.
	//
	// ML storage volumes store model artifacts and incremental states. Training
	// algorithms might also use the ML storage volume for scratch space. If you want
	// to store the training data in the ML storage volume, choose File as the
	// TrainingInputMode in the algorithm specification.
	//
	// When using an ML instance with [NVMe SSD volumes], SageMaker doesn't provision Amazon EBS General
	// Purpose SSD (gp2) storage. Available storage is fixed to the NVMe-type
	// instance's storage capacity. SageMaker configures storage paths for training
	// datasets, checkpoints, model artifacts, and outputs to use the entire capacity
	// of the instance storage. For example, ML instance families with the NVMe-type
	// instance storage include ml.p4d , ml.g4dn , and ml.g5 .
	//
	// When using an ML instance with the EBS-only storage option and without instance
	// storage, you must define the size of EBS volume through VolumeSizeInGB in the
	// ResourceConfig API. For example, ML instance families that use EBS volumes
	// include ml.c5 and ml.p2 .
	//
	// To look up instance types and their instance storage types and volumes, see [Amazon EC2 Instance Types].
	//
	// To find the default local paths defined by the SageMaker training platform, see [Amazon SageMaker Training Storage Folders for Training Datasets, Checkpoints, Model Artifacts, and Outputs]
	// .
	//
	// [NVMe SSD volumes]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html#nvme-ssd-volumes
	// [Amazon EC2 Instance Types]: http://aws.amazon.com/ec2/instance-types/
	// [Amazon SageMaker Training Storage Folders for Training Datasets, Checkpoints, Model Artifacts, and Outputs]: https://docs.aws.amazon.com/sagemaker/latest/dg/model-train-storage.html
	//
	// This member is required.
	VolumeSizeInGB *int32

	// The number of ML compute instances to use. For distributed training, provide a
	// value greater than 1.
	InstanceCount *int32

	// The configuration of a heterogeneous cluster in JSON format.
	InstanceGroups []InstanceGroup

	// The ML compute instance type.
	//
	// SageMaker Training on Amazon Elastic Compute Cloud (EC2) P4de instances is in
	// preview release starting December 9th, 2022.
	//
	// [Amazon EC2 P4de instances](currently in preview) are powered by 8 NVIDIA A100 GPUs with 80GB
	// high-performance HBM2e GPU memory, which accelerate the speed of training ML
	// models that need to be trained on large datasets of high-resolution data. In
	// this preview release, Amazon SageMaker supports ML training jobs on P4de
	// instances ( ml.p4de.24xlarge ) to reduce model training time. The
	// ml.p4de.24xlarge instances are available in the following Amazon Web Services
	// Regions.
	//
	//   - US East (N. Virginia) (us-east-1)
	//
	//   - US West (Oregon) (us-west-2)
	//
	// To request quota limit increase and start using P4de instances, contact the
	// SageMaker Training service team through your account team.
	//
	// [Amazon EC2 P4de instances]: http://aws.amazon.com/ec2/instance-types/p4/
	InstanceType TrainingInstanceType

	// The duration of time in seconds to retain configured resources in a warm pool
	// for subsequent training jobs.
	KeepAlivePeriodInSeconds *int32

	// The Amazon Web Services KMS key that SageMaker uses to encrypt data on the
	// storage volume attached to the ML compute instance(s) that run the training job.
	//
	// Certain Nitro-based instances include local storage, dependent on the instance
	// type. Local storage volumes are encrypted using a hardware module on the
	// instance. You can't request a VolumeKmsKeyId when using an instance type with
	// local storage.
	//
	// For a list of instance types that support local instance storage, see [Instance Store Volumes].
	//
	// For more information about local instance storage encryption, see [SSD Instance Store Volumes].
	//
	// The VolumeKmsKeyId can be in any of the following formats:
	//
	//   - // KMS Key ID
	//
	// "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//   - // Amazon Resource Name (ARN) of a KMS Key
	//
	// "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	// [SSD Instance Store Volumes]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html
	// [Instance Store Volumes]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes
	VolumeKmsKeyId *string

	noSmithyDocumentSerde
}

// The ResourceConfig to update KeepAlivePeriodInSeconds . Other fields in the
// ResourceConfig cannot be updated.
type ResourceConfigForUpdate struct {

	// The KeepAlivePeriodInSeconds value specified in the ResourceConfig to update.
	//
	// This member is required.
	KeepAlivePeriodInSeconds *int32

	noSmithyDocumentSerde
}

// Specifies the maximum number of training jobs and parallel training jobs that a
// hyperparameter tuning job can launch.
type ResourceLimits struct {

	// The maximum number of concurrent training jobs that a hyperparameter tuning job
	// can launch.
	//
	// This member is required.
	MaxParallelTrainingJobs *int32

	// The maximum number of training jobs that a hyperparameter tuning job can launch.
	MaxNumberOfTrainingJobs *int32

	// The maximum time in seconds that a hyperparameter tuning job can run.
	MaxRuntimeInSeconds *int32

	noSmithyDocumentSerde
}

// Specifies the ARN's of a SageMaker image and SageMaker image version, and the
// instance type that the version runs on.
type ResourceSpec struct {

	// The instance type that the image version runs on.
	//
	// JupyterServer apps only support the system value.
	//
	// For KernelGateway apps, the system value is translated to ml.t3.medium .
	// KernelGateway apps also support all other values for available instance types.
	InstanceType AppInstanceType

	//  The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the
	// Resource.
	LifecycleConfigArn *string

	// The ARN of the SageMaker image that the image version belongs to.
	SageMakerImageArn *string

	// The SageMakerImageVersionAlias of the image to launch with. This value is in
	// SemVer 2.0.0 versioning format.
	SageMakerImageVersionAlias *string

	// The ARN of the image version created on the instance.
	SageMakerImageVersionArn *string

	noSmithyDocumentSerde
}

// The retention policy for data stored on an Amazon Elastic File System volume.
type RetentionPolicy struct {

	// The default is Retain , which specifies to keep the data stored on the Amazon
	// EFS volume.
	//
	// Specify Delete to delete the data stored on the Amazon EFS volume.
	HomeEfsFileSystem RetentionType

	noSmithyDocumentSerde
}

// The retry strategy to use when a training job fails due to an
// InternalServerError . RetryStrategy is specified as part of the
// CreateTrainingJob and CreateHyperParameterTuningJob requests. You can add the
// StoppingCondition parameter to the request to limit the training time for the
// complete job.
type RetryStrategy struct {

	// The number of times to retry the job. When the job is retried, it's
	// SecondaryStatus is changed to STARTING .
	//
	// This member is required.
	MaximumRetryAttempts *int32

	noSmithyDocumentSerde
}

// Specifies a rolling deployment strategy for updating a SageMaker endpoint.
type RollingUpdatePolicy struct {

	// Batch size for each rolling step to provision capacity and turn on traffic on
	// the new endpoint fleet, and terminate capacity on the old endpoint fleet. Value
	// must be between 5% to 50% of the variant's total instance count.
	//
	// This member is required.
	MaximumBatchSize *CapacitySize

	// The length of the baking period, during which SageMaker monitors alarms for
	// each batch on the new fleet.
	//
	// This member is required.
	WaitIntervalInSeconds *int32

	// The time limit for the total deployment. Exceeding this limit causes a timeout.
	MaximumExecutionTimeoutInSeconds *int32

	// Batch size for rollback to the old endpoint fleet. Each rolling step to
	// provision capacity and turn on traffic on the old endpoint fleet, and terminate
	// capacity on the new endpoint fleet. If this field is absent, the default value
	// will be set to 100% of total capacity which means to bring up the whole capacity
	// of the old fleet at once during rollback.
	RollbackMaximumBatchSize *CapacitySize

	noSmithyDocumentSerde
}

// A collection of settings that apply to an RSessionGateway app.
type RSessionAppSettings struct {

	// A list of custom SageMaker images that are configured to run as a RSession app.
	CustomImages []CustomImage

	// Specifies the ARN's of a SageMaker image and SageMaker image version, and the
	// instance type that the version runs on.
	DefaultResourceSpec *ResourceSpec

	noSmithyDocumentSerde
}

// A collection of settings that configure user interaction with the
// RStudioServerPro app.
type RStudioServerProAppSettings struct {

	// Indicates whether the current user has access to the RStudioServerPro app.
	AccessStatus RStudioServerProAccessStatus

	// The level of permissions that the user has within the RStudioServerPro app.
	// This value defaults to `User`. The `Admin` value allows the user access to the
	// RStudio Administrative Dashboard.
	UserGroup RStudioServerProUserGroup

	noSmithyDocumentSerde
}

// A collection of settings that configure the RStudioServerPro Domain-level app.
type RStudioServerProDomainSettings struct {

	// The ARN of the execution role for the RStudioServerPro Domain-level app.
	//
	// This member is required.
	DomainExecutionRoleArn *string

	// Specifies the ARN's of a SageMaker image and SageMaker image version, and the
	// instance type that the version runs on.
	DefaultResourceSpec *ResourceSpec

	// A URL pointing to an RStudio Connect server.
	RStudioConnectUrl *string

	// A URL pointing to an RStudio Package Manager server.
	RStudioPackageManagerUrl *string

	noSmithyDocumentSerde
}

// A collection of settings that update the current configuration for the
// RStudioServerPro Domain-level app.
type RStudioServerProDomainSettingsForUpdate struct {

	// The execution role for the RStudioServerPro Domain-level app.
	//
	// This member is required.
	DomainExecutionRoleArn *string

	// Specifies the ARN's of a SageMaker image and SageMaker image version, and the
	// instance type that the version runs on.
	DefaultResourceSpec *ResourceSpec

	// A URL pointing to an RStudio Connect server.
	RStudioConnectUrl *string

	// A URL pointing to an RStudio Package Manager server.
	RStudioPackageManagerUrl *string

	noSmithyDocumentSerde
}

// Describes the S3 data source.
//
// Your input bucket must be in the same Amazon Web Services region as your
// training job.
type S3DataSource struct {

	// If you choose S3Prefix , S3Uri identifies a key name prefix. SageMaker uses all
	// objects that match the specified key name prefix for model training.
	//
	// If you choose ManifestFile , S3Uri identifies an object that is a manifest file
	// containing a list of object keys that you want SageMaker to use for model
	// training.
	//
	// If you choose AugmentedManifestFile , S3Uri identifies an object that is an
	// augmented manifest file in JSON lines format. This file contains the data you
	// want to use for model training. AugmentedManifestFile can only be used if the
	// Channel's input mode is Pipe .
	//
	// This member is required.
	S3DataType S3DataType

	// Depending on the value specified for the S3DataType , identifies either a key
	// name prefix or a manifest. For example:
	//
	//   - A key name prefix might look like this: s3://bucketname/exampleprefix/
	//
	//   - A manifest might look like this: s3://bucketname/example.manifest
	//
	// A manifest is an S3 object which is a JSON file consisting of an array of
	//   elements. The first element is a prefix which is followed by one or more
	//   suffixes. SageMaker appends the suffix elements to the prefix to get a full set
	//   of S3Uri . Note that the prefix must be a valid non-empty S3Uri that precludes
	//   users from specifying a manifest whose individual S3Uri is sourced from
	//   different S3 buckets.
	//
	// The following code example shows a valid manifest format:
	//
	// [ {"prefix": "s3://customer_bucket/some/prefix/"},
	//
	// "relative/path/to/custdata-1",
	//
	// "relative/path/custdata-2",
	//
	// ...
	//
	// "relative/path/custdata-N"
	//
	// ]
	//
	// This JSON is equivalent to the following S3Uri list:
	//
	// s3://customer_bucket/some/prefix/relative/path/to/custdata-1
	//
	// s3://customer_bucket/some/prefix/relative/path/custdata-2
	//
	// ...
	//
	// s3://customer_bucket/some/prefix/relative/path/custdata-N
	//
	// The complete set of S3Uri in this manifest is the input data for the channel for
	//   this data source. The object that each S3Uri points to must be readable by the
	//   IAM role that SageMaker uses to perform tasks on your behalf.
	//
	// Your input bucket must be located in same Amazon Web Services region as your
	// training job.
	//
	// This member is required.
	S3Uri *string

	// A list of one or more attribute names to use that are found in a specified
	// augmented manifest file.
	AttributeNames []string

	// A list of names of instance groups that get data from the S3 data source.
	InstanceGroupNames []string

	// If you want SageMaker to replicate the entire dataset on each ML compute
	// instance that is launched for model training, specify FullyReplicated .
	//
	// If you want SageMaker to replicate a subset of data on each ML compute instance
	// that is launched for model training, specify ShardedByS3Key . If there are n ML
	// compute instances launched for a training job, each instance gets approximately
	// 1/n of the number of S3 objects. In this case, model training on each machine
	// uses only the subset of training data.
	//
	// Don't choose more ML compute instances for training than available S3 objects.
	// If you do, some nodes won't get any data and you will pay for nodes that aren't
	// getting any training data. This applies in both File and Pipe modes. Keep this
	// in mind when developing algorithms.
	//
	// In distributed training, where you use multiple ML compute EC2 instances, you
	// might choose ShardedByS3Key . If the algorithm requires copying training data to
	// the ML storage volume (when TrainingInputMode is set to File ), this copies 1/n
	// of the number of objects.
	S3DataDistributionType S3DataDistribution

	noSmithyDocumentSerde
}

// Specifies the S3 location of ML model data to deploy.
type S3ModelDataSource struct {

	// Specifies how the ML model data is prepared.
	//
	// If you choose Gzip and choose S3Object as the value of S3DataType , S3Uri
	// identifies an object that is a gzip-compressed TAR archive. SageMaker will
	// attempt to decompress and untar the object during model deployment.
	//
	// If you choose None and chooose S3Object as the value of S3DataType , S3Uri
	// identifies an object that represents an uncompressed ML model to deploy.
	//
	// If you choose None and choose S3Prefix as the value of S3DataType , S3Uri
	// identifies a key name prefix, under which all objects represents the
	// uncompressed ML model to deploy.
	//
	// If you choose None, then SageMaker will follow rules below when creating model
	// data files under /opt/ml/model directory for use by your inference code:
	//
	//   - If you choose S3Object as the value of S3DataType , then SageMaker will
	//   split the key of the S3 object referenced by S3Uri by slash (/), and use the
	//   last part as the filename of the file holding the content of the S3 object.
	//
	//   - If you choose S3Prefix as the value of S3DataType , then for each S3 object
	//   under the key name pefix referenced by S3Uri , SageMaker will trim its key by
	//   the prefix, and use the remainder as the path (relative to /opt/ml/model ) of
	//   the file holding the content of the S3 object. SageMaker will split the
	//   remainder by slash (/), using intermediate parts as directory names and the last
	//   part as filename of the file holding the content of the S3 object.
	//
	//   - Do not use any of the following as file names or directory names:
	//
	//   - An empty or blank string
	//
	//   - A string which contains null bytes
	//
	//   - A string longer than 255 bytes
	//
	//   - A single dot ( . )
	//
	//   - A double dot ( .. )
	//
	//   - Ambiguous file names will result in model deployment failure. For example,
	//   if your uncompressed ML model consists of two S3 objects
	//   s3://mybucket/model/weights and s3://mybucket/model/weights/part1 and you
	//   specify s3://mybucket/model/ as the value of S3Uri and S3Prefix as the value
	//   of S3DataType , then it will result in name clash between
	//   /opt/ml/model/weights (a regular file) and /opt/ml/model/weights/ (a
	//   directory).
	//
	//   - Do not organize the model artifacts in [S3 console using folders]. When you create a folder in S3
	//   console, S3 creates a 0-byte object with a key set to the folder name you
	//   provide. They key of the 0-byte object ends with a slash (/) which violates
	//   SageMaker restrictions on model artifact file names, leading to model deployment
	//   failure.
	//
	// [S3 console using folders]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-folders.html
	//
	// This member is required.
	CompressionType ModelCompressionType

	// Specifies the type of ML model data to deploy.
	//
	// If you choose S3Prefix , S3Uri identifies a key name prefix. SageMaker uses all
	// objects that match the specified key name prefix as part of the ML model data to
	// deploy. A valid key name prefix identified by S3Uri always ends with a forward
	// slash (/).
	//
	// If you choose S3Object , S3Uri identifies an object that is the ML model data
	// to deploy.
	//
	// This member is required.
	S3DataType S3ModelDataType

	// Specifies the S3 path of ML model data to deploy.
	//
	// This member is required.
	S3Uri *string

	// Specifies the access configuration file for the ML model. You can explicitly
	// accept the model end-user license agreement (EULA) within the ModelAccessConfig
	// . You are responsible for reviewing and complying with any applicable license
	// terms and making sure they are acceptable for your use case before downloading
	// or using a model.
	ModelAccessConfig *ModelAccessConfig

	noSmithyDocumentSerde
}

// This object defines the access restrictions to Amazon S3 resources that are
// included in custom worker task templates using the Liquid filter,
// grant_read_access .
//
// To learn more about how custom templates are created, see [Create custom worker task templates].
//
// [Create custom worker task templates]: https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-custom-templates.html
type S3Presign struct {

	// Use this parameter to specify the allowed request source. Possible sources are
	// either SourceIp or VpcSourceIp .
	IamPolicyConstraints *IamPolicyConstraints

	noSmithyDocumentSerde
}

// The Amazon Simple Storage (Amazon S3) location and security configuration for
// OfflineStore .
type S3StorageConfig struct {

	// The S3 URI, or location in Amazon S3, of OfflineStore .
	//
	// S3 URIs have a format similar to the following: s3://example-bucket/prefix/ .
	//
	// This member is required.
	S3Uri *string

	// The Amazon Web Services Key Management Service (KMS) key ARN of the key used to
	// encrypt any objects written into the OfflineStore S3 location.
	//
	// The IAM roleARN that is passed as a parameter to CreateFeatureGroup must have
	// below permissions to the KmsKeyId :
	//
	//   - "kms:GenerateDataKey"
	KmsKeyId *string

	// The S3 path where offline records are written.
	ResolvedOutputS3Uri *string

	noSmithyDocumentSerde
}

// An object containing a recommended scaling policy.
//
// The following types satisfy this interface:
//
//	ScalingPolicyMemberTargetTracking
type ScalingPolicy interface {
	isScalingPolicy()
}

// A target tracking scaling policy. Includes support for predefined or customized
// metrics.
type ScalingPolicyMemberTargetTracking struct {
	Value TargetTrackingScalingPolicyConfiguration

	noSmithyDocumentSerde
}

func (*ScalingPolicyMemberTargetTracking) isScalingPolicy() {}

// The metric for a scaling policy.
type ScalingPolicyMetric struct {

	// The number of invocations sent to a model, normalized by InstanceCount in each
	// ProductionVariant. 1/numberOfInstances is sent as the value on each request,
	// where numberOfInstances is the number of active instances for the
	// ProductionVariant behind the endpoint at the time of the request.
	InvocationsPerInstance *int32

	// The interval of time taken by a model to respond as viewed from SageMaker. This
	// interval includes the local communication times taken to send the request and to
	// fetch the response from the container of a model and the time taken to complete
	// the inference in the container.
	ModelLatency *int32

	noSmithyDocumentSerde
}

// An object where you specify the anticipated traffic pattern for an endpoint.
type ScalingPolicyObjective struct {

	// The maximum number of expected requests to your endpoint per minute.
	MaxInvocationsPerMinute *int32

	// The minimum number of expected requests to your endpoint per minute.
	MinInvocationsPerMinute *int32

	noSmithyDocumentSerde
}

// Configuration details about the monitoring schedule.
type ScheduleConfig struct {

	// A cron expression that describes details about the monitoring schedule.
	//
	// The supported cron expressions are:
	//
	//   - If you want to set the job to start every hour, use the following:
	//
	// Hourly: cron(0 * ? * * *)
	//
	//   - If you want to start the job daily:
	//
	// cron(0 [00-23] ? * * *)
	//
	//   - If you want to run the job one time, immediately, use the following keyword:
	//
	// NOW
	//
	// For example, the following are valid cron expressions:
	//
	//   - Daily at noon UTC: cron(0 12 ? * * *)
	//
	//   - Daily at midnight UTC: cron(0 0 ? * * *)
	//
	// To support running every 6, 12 hours, the following are also supported:
	//
	//     cron(0 [00-23]/[01-24] ? * * *)
	//
	// For example, the following are valid cron expressions:
	//
	//   - Every 12 hours, starting at 5pm UTC: cron(0 17/12 ? * * *)
	//
	//   - Every two hours starting at midnight: cron(0 0/2 ? * * *)
	//
	//   - Even though the cron expression is set to start at 5PM UTC, note that there
	//   could be a delay of 0-20 minutes from the actual requested time to run the
	//   execution.
	//
	//   - We recommend that if you would like a daily schedule, you do not provide
	//   this parameter. Amazon SageMaker will pick a time for running every day.
	//
	// You can also specify the keyword NOW to run the monitoring job immediately, one
	// time, without recurring.
	//
	// This member is required.
	ScheduleExpression *string

	// Sets the end time for a monitoring job window. Express this time as an offset
	// to the times that you schedule your monitoring jobs to run. You schedule
	// monitoring jobs with the ScheduleExpression parameter. Specify this offset in
	// ISO 8601 duration format. For example, if you want to end the window one hour
	// before the start of each monitoring job, you would specify: "-PT1H" .
	//
	// The end time that you specify must not follow the start time that you specify
	// by more than 24 hours. You specify the start time with the DataAnalysisStartTime
	// parameter.
	//
	// If you set ScheduleExpression to NOW , this parameter is required.
	DataAnalysisEndTime *string

	// Sets the start time for a monitoring job window. Express this time as an offset
	// to the times that you schedule your monitoring jobs to run. You schedule
	// monitoring jobs with the ScheduleExpression parameter. Specify this offset in
	// ISO 8601 duration format. For example, if you want to monitor the five hours of
	// data in your dataset that precede the start of each monitoring job, you would
	// specify: "-PT5H" .
	//
	// The start time that you specify must not precede the end time that you specify
	// by more than 24 hours. You specify the end time with the DataAnalysisEndTime
	// parameter.
	//
	// If you set ScheduleExpression to NOW , this parameter is required.
	DataAnalysisStartTime *string

	noSmithyDocumentSerde
}

// A multi-expression that searches for the specified resource or resources in a
// search. All resource objects that satisfy the expression's condition are
// included in the search results. You must specify at least one subexpression,
// filter, or nested filter. A SearchExpression can contain up to twenty elements.
//
// A SearchExpression contains the following components:
//
//   - A list of Filter objects. Each filter defines a simple Boolean expression
//     comprised of a resource property name, Boolean operator, and value.
//
//   - A list of NestedFilter objects. Each nested filter defines a list of Boolean
//     expressions using a list of resource properties. A nested filter is satisfied if
//     a single object in the list satisfies all Boolean expressions.
//
//   - A list of SearchExpression objects. A search expression object can be nested
//     in a list of search expression objects.
//
//   - A Boolean operator: And or Or .
type SearchExpression struct {

	// A list of filter objects.
	Filters []Filter

	// A list of nested filter objects.
	NestedFilters []NestedFilters

	// A Boolean operator used to evaluate the search expression. If you want every
	// conditional statement in all lists to be satisfied for the entire search
	// expression to be true, specify And . If only a single conditional statement
	// needs to be true for the entire search expression to be true, specify Or . The
	// default value is And .
	Operator BooleanOperator

	// A list of search expression objects.
	SubExpressions []SearchExpression

	noSmithyDocumentSerde
}

// A single resource returned as part of the [Search] API response.
//
// [Search]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html
type SearchRecord struct {

	// A hosted endpoint for real-time inference.
	Endpoint *Endpoint

	// The properties of an experiment.
	Experiment *Experiment

	// Amazon SageMaker Feature Store stores features in a collection called Feature
	// Group. A Feature Group can be visualized as a table which has rows, with a
	// unique identifier for each row where each column in the table is a feature. In
	// principle, a Feature Group is composed of features and values per features.
	FeatureGroup *FeatureGroup

	// The feature metadata used to search through the features.
	FeatureMetadata *FeatureMetadata

	// The properties of a hyperparameter tuning job.
	HyperParameterTuningJob *HyperParameterTuningJobSearchEntity

	// A model displayed in the Amazon SageMaker Model Dashboard.
	Model *ModelDashboardModel

	// An Amazon SageMaker Model Card that documents details about a machine learning
	// model.
	ModelCard *ModelCard

	// A versioned model that can be deployed for SageMaker inference.
	ModelPackage *ModelPackage

	// A group of versioned models in the model registry.
	ModelPackageGroup *ModelPackageGroup

	// A SageMaker Model Building Pipeline instance.
	Pipeline *Pipeline

	// An execution of a pipeline.
	PipelineExecution *PipelineExecution

	// The properties of a project.
	Project *Project

	// The properties of a training job.
	TrainingJob *TrainingJob

	// The properties of a trial.
	Trial *Trial

	// The properties of a trial component.
	TrialComponent *TrialComponent

	noSmithyDocumentSerde
}

// An array element of SecondaryStatusTransitions for [DescribeTrainingJob]. It provides additional
// details about a status that the training job has transitioned through. A
// training job can be in one of several states, for example, starting,
// downloading, training, or uploading. Within each state, there are a number of
// intermediate states. For example, within the starting state, SageMaker could be
// starting the training job or launching the ML instances. These transitional
// states are referred to as the job's secondary status.
//
// [DescribeTrainingJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrainingJob.html
type SecondaryStatusTransition struct {

	// A timestamp that shows when the training job transitioned to the current
	// secondary status state.
	//
	// This member is required.
	StartTime *time.Time

	// Contains a secondary status information from a training job.
	//
	// Status might be one of the following secondary statuses:
	//
	// InProgress
	//   - Starting - Starting the training job.
	//
	//   - Downloading - An optional stage for algorithms that support File training
	//   input mode. It indicates that data is being downloaded to the ML storage
	//   volumes.
	//
	//   - Training - Training is in progress.
	//
	//   - Uploading - Training is complete and the model artifacts are being uploaded
	//   to the S3 location.
	//
	// Completed
	//   - Completed - The training job has completed.
	//
	// Failed
	//   - Failed - The training job has failed. The reason for the failure is returned
	//   in the FailureReason field of DescribeTrainingJobResponse .
	//
	// Stopped
	//   - MaxRuntimeExceeded - The job stopped because it exceeded the maximum allowed
	//   runtime.
	//
	//   - Stopped - The training job has stopped.
	//
	// Stopping
	//   - Stopping - Stopping the training job.
	//
	// We no longer support the following secondary statuses:
	//
	//   - LaunchingMLInstances
	//
	//   - PreparingTrainingStack
	//
	//   - DownloadingTrainingImage
	//
	// This member is required.
	Status SecondaryStatus

	// A timestamp that shows when the training job transitioned out of this secondary
	// status state into another secondary status state or when the training job has
	// ended.
	EndTime *time.Time

	// A detailed description of the progress within a secondary status.
	//
	// SageMaker provides secondary statuses and status messages that apply to each of
	// them:
	//
	// Starting
	//   - Starting the training job.
	//
	//   - Launching requested ML instances.
	//
	//   - Insufficient capacity error from EC2 while launching instances, retrying!
	//
	//   - Launched instance was unhealthy, replacing it!
	//
	//   - Preparing the instances for training.
	//
	// Training
	//   - Training image download completed. Training in progress.
	//
	// Status messages are subject to change. Therefore, we recommend not including
	// them in code that programmatically initiates actions. For examples, don't use
	// status messages in if statements.
	//
	// To have an overview of your training job's progress, view TrainingJobStatus and
	// SecondaryStatus in [DescribeTrainingJob], and StatusMessage together. For example, at the start of a
	// training job, you might see the following:
	//
	//   - TrainingJobStatus - InProgress
	//
	//   - SecondaryStatus - Training
	//
	//   - StatusMessage - Downloading the training image
	//
	// [DescribeTrainingJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrainingJob.html
	StatusMessage *string

	noSmithyDocumentSerde
}

// A step selected to run in selective execution mode.
type SelectedStep struct {

	// The name of the pipeline step.
	//
	// This member is required.
	StepName *string

	noSmithyDocumentSerde
}

// The selective execution configuration applied to the pipeline run.
type SelectiveExecutionConfig struct {

	// A list of pipeline steps to run. All step(s) in all path(s) between two
	// selected steps should be included.
	//
	// This member is required.
	SelectedSteps []SelectedStep

	// The ARN from a reference execution of the current pipeline. Used to copy input
	// collaterals needed for the selected steps to run. The execution status of the
	// pipeline can be either Failed or Success .
	//
	// This field is required if the steps you specify for SelectedSteps depend on
	// output collaterals from any non-specified pipeline steps. For more information,
	// see [Selective Execution for Pipeline Steps].
	//
	// [Selective Execution for Pipeline Steps]: https://docs.aws.amazon.com/sagemaker/latest/dg/pipelines-selective-ex.html
	SourcePipelineExecutionArn *string

	noSmithyDocumentSerde
}

// The ARN from an execution of the current pipeline.
type SelectiveExecutionResult struct {

	// The ARN from an execution of the current pipeline.
	SourcePipelineExecutionArn *string

	noSmithyDocumentSerde
}

// Details of a provisioned service catalog product. For information about service
// catalog, see [What is Amazon Web Services Service Catalog].
//
// [What is Amazon Web Services Service Catalog]: https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html
type ServiceCatalogProvisionedProductDetails struct {

	// The ID of the provisioned product.
	ProvisionedProductId *string

	// The current status of the product.
	//
	//   - AVAILABLE - Stable state, ready to perform any operation. The most recent
	//   operation succeeded and completed.
	//
	//   - UNDER_CHANGE - Transitive state. Operations performed might not have valid
	//   results. Wait for an AVAILABLE status before performing operations.
	//
	//   - TAINTED - Stable state, ready to perform any operation. The stack has
	//   completed the requested operation but is not exactly what was requested. For
	//   example, a request to update to a new version failed and the stack rolled back
	//   to the current version.
	//
	//   - ERROR - An unexpected error occurred. The provisioned product exists but the
	//   stack is not running. For example, CloudFormation received a parameter value
	//   that was not valid and could not launch the stack.
	//
	//   - PLAN_IN_PROGRESS - Transitive state. The plan operations were performed to
	//   provision a new product, but resources have not yet been created. After
	//   reviewing the list of resources to be created, execute the plan. Wait for an
	//   AVAILABLE status before performing operations.
	ProvisionedProductStatusMessage *string

	noSmithyDocumentSerde
}

// Details that you specify to provision a service catalog product. For
// information about service catalog, see [What is Amazon Web Services Service Catalog].
//
// [What is Amazon Web Services Service Catalog]: https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html
type ServiceCatalogProvisioningDetails struct {

	// The ID of the product to provision.
	//
	// This member is required.
	ProductId *string

	// The path identifier of the product. This value is optional if the product has a
	// default path, and required if the product has more than one path.
	PathId *string

	// The ID of the provisioning artifact.
	ProvisioningArtifactId *string

	// A list of key value pairs that you specify when you provision a product.
	ProvisioningParameters []ProvisioningParameter

	noSmithyDocumentSerde
}

// Details that you specify to provision a service catalog product. For
// information about service catalog, see [What is Amazon Web Services Service Catalog].
//
// [What is Amazon Web Services Service Catalog]: https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html
type ServiceCatalogProvisioningUpdateDetails struct {

	// The ID of the provisioning artifact.
	ProvisioningArtifactId *string

	// A list of key value pairs that you specify when you provision a product.
	ProvisioningParameters []ProvisioningParameter

	noSmithyDocumentSerde
}

// Contains information about attribute-based access control (ABAC) for a training
// job. The session chaining configuration uses Amazon Security Token Service (STS)
// for your training job to request temporary, limited-privilege credentials to
// tenants. For more information, see [Attribute-based access control (ABAC) for multi-tenancy training].
//
// [Attribute-based access control (ABAC) for multi-tenancy training]: https://docs.aws.amazon.com/sagemaker/latest/dg/model-access-training-data.html#model-access-training-data-abac
type SessionChainingConfig struct {

	// Set to True to allow SageMaker to extract session tags from a training job
	// creation role and reuse these tags when assuming the training job execution
	// role.
	EnableSessionTagChaining *bool

	noSmithyDocumentSerde
}

//	The configuration of ShadowMode inference experiment type, which specifies a
//
// production variant to take all the inference requests, and a shadow variant to
// which Amazon SageMaker replicates a percentage of the inference requests. For
// the shadow variant it also specifies the percentage of requests that Amazon
// SageMaker replicates.
type ShadowModeConfig struct {

	// List of shadow variant configurations.
	//
	// This member is required.
	ShadowModelVariants []ShadowModelVariantConfig

	//  The name of the production variant, which takes all the inference requests.
	//
	// This member is required.
	SourceModelVariantName *string

	noSmithyDocumentSerde
}

// The name and sampling percentage of a shadow variant.
type ShadowModelVariantConfig struct {

	//  The percentage of inference requests that Amazon SageMaker replicates from the
	// production variant to the shadow variant.
	//
	// This member is required.
	SamplingPercentage *int32

	// The name of the shadow variant.
	//
	// This member is required.
	ShadowModelVariantName *string

	noSmithyDocumentSerde
}

// Specifies options for sharing Amazon SageMaker Studio notebooks. These settings
// are specified as part of DefaultUserSettings when the CreateDomain API is
// called, and as part of UserSettings when the CreateUserProfile API is called.
// When SharingSettings is not specified, notebook sharing isn't allowed.
type SharingSettings struct {

	// Whether to include the notebook cell output when sharing the notebook. The
	// default is Disabled .
	NotebookOutputOption NotebookOutputOption

	// When NotebookOutputOption is Allowed , the Amazon Web Services Key Management
	// Service (KMS) encryption key ID used to encrypt the notebook cell output in the
	// Amazon S3 bucket.
	S3KmsKeyId *string

	// When NotebookOutputOption is Allowed , the Amazon S3 bucket used to store the
	// shared notebook snapshots.
	S3OutputPath *string

	noSmithyDocumentSerde
}

// A configuration for a shuffle option for input data in a channel. If you use
// S3Prefix for S3DataType , the results of the S3 key prefix matches are shuffled.
// If you use ManifestFile , the order of the S3 object references in the
// ManifestFile is shuffled. If you use AugmentedManifestFile , the order of the
// JSON lines in the AugmentedManifestFile is shuffled. The shuffling order is
// determined using the Seed value.
//
// For Pipe input mode, when ShuffleConfig is specified shuffling is done at the
// start of every epoch. With large datasets, this ensures that the order of the
// training data is different for each epoch, and it helps reduce bias and possible
// overfitting. In a multi-node training job when ShuffleConfig is combined with
// S3DataDistributionType of ShardedByS3Key , the data is shuffled across nodes so
// that the content sent to a particular node on the first epoch might be sent to a
// different node on the second epoch.
type ShuffleConfig struct {

	// Determines the shuffling order in ShuffleConfig value.
	//
	// This member is required.
	Seed *int64

	noSmithyDocumentSerde
}

// Specifies an algorithm that was used to create the model package. The algorithm
// must be either an algorithm resource in your SageMaker account or an algorithm
// in Amazon Web Services Marketplace that you are subscribed to.
type SourceAlgorithm struct {

	// The name of an algorithm that was used to create the model package. The
	// algorithm must be either an algorithm resource in your SageMaker account or an
	// algorithm in Amazon Web Services Marketplace that you are subscribed to.
	//
	// This member is required.
	AlgorithmName *string

	// Specifies the location of ML model data to deploy during endpoint creation.
	ModelDataSource *ModelDataSource

	// The Amazon S3 path where the model artifacts, which result from model training,
	// are stored. This path must point to a single gzip compressed tar archive (
	// .tar.gz suffix).
	//
	// The model artifacts must be in an S3 bucket that is in the same Amazon Web
	// Services region as the algorithm.
	ModelDataUrl *string

	noSmithyDocumentSerde
}

// A list of algorithms that were used to create a model package.
type SourceAlgorithmSpecification struct {

	// A list of the algorithms that were used to create a model package.
	//
	// This member is required.
	SourceAlgorithms []SourceAlgorithm

	noSmithyDocumentSerde
}

// A list of IP address ranges ([CIDRs] ). Used to create an allow list of IP addresses
// for a private workforce. Workers will only be able to login to their worker
// portal from an IP address within this range. By default, a workforce isn't
// restricted to specific IP addresses.
//
// [CIDRs]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
type SourceIpConfig struct {

	// A list of one to ten [Classless Inter-Domain Routing] (CIDR) values.
	//
	// Maximum: Ten CIDR values
	//
	// The following Length Constraints apply to individual CIDR values in the CIDR
	// value list.
	//
	// [Classless Inter-Domain Routing]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
	//
	// This member is required.
	Cidrs []string

	noSmithyDocumentSerde
}

// The application settings for a Code Editor space.
type SpaceCodeEditorAppSettings struct {

	// Specifies the ARN's of a SageMaker image and SageMaker image version, and the
	// instance type that the version runs on.
	DefaultResourceSpec *ResourceSpec

	noSmithyDocumentSerde
}

// The space's details.
type SpaceDetails struct {

	// The creation time.
	CreationTime *time.Time

	// The ID of the associated domain.
	DomainId *string

	// The last modified time.
	LastModifiedTime *time.Time

	// Specifies summary information about the ownership settings.
	OwnershipSettingsSummary *OwnershipSettingsSummary

	// The name of the space that appears in the Studio UI.
	SpaceDisplayName *string

	// The name of the space.
	SpaceName *string

	// Specifies summary information about the space settings.
	SpaceSettingsSummary *SpaceSettingsSummary

	// Specifies summary information about the space sharing settings.
	SpaceSharingSettingsSummary *SpaceSharingSettingsSummary

	// The status.
	Status SpaceStatus

	noSmithyDocumentSerde
}

// The settings for the JupyterLab application within a space.
type SpaceJupyterLabAppSettings struct {

	// A list of Git repositories that SageMaker automatically displays to users for
	// cloning in the JupyterLab application.
	CodeRepositories []CodeRepository

	// Specifies the ARN's of a SageMaker image and SageMaker image version, and the
	// instance type that the version runs on.
	DefaultResourceSpec *ResourceSpec

	noSmithyDocumentSerde
}

// A collection of space settings.
type SpaceSettings struct {

	// The type of app created within the space.
	AppType AppType

	// The Code Editor application settings.
	CodeEditorAppSettings *SpaceCodeEditorAppSettings

	// A file system, created by you, that you assign to a space for an Amazon
	// SageMaker Domain. Permitted users can access this file system in Amazon
	// SageMaker Studio.
	CustomFileSystems []CustomFileSystem

	// The settings for the JupyterLab application.
	JupyterLabAppSettings *SpaceJupyterLabAppSettings

	// The JupyterServer app settings.
	JupyterServerAppSettings *JupyterServerAppSettings

	// The KernelGateway app settings.
	KernelGatewayAppSettings *KernelGatewayAppSettings

	// The storage settings for a space.
	SpaceStorageSettings *SpaceStorageSettings

	noSmithyDocumentSerde
}

// Specifies summary information about the space settings.
type SpaceSettingsSummary struct {

	// The type of app created within the space.
	AppType AppType

	// The storage settings for a space.
	SpaceStorageSettings *SpaceStorageSettings

	noSmithyDocumentSerde
}

// A collection of space sharing settings.
type SpaceSharingSettings struct {

	// Specifies the sharing type of the space.
	//
	// This member is required.
	SharingType SharingType

	noSmithyDocumentSerde
}

// Specifies summary information about the space sharing settings.
type SpaceSharingSettingsSummary struct {

	// Specifies the sharing type of the space.
	SharingType SharingType

	noSmithyDocumentSerde
}

// The storage settings for a space.
type SpaceStorageSettings struct {

	// A collection of EBS storage settings for a space.
	EbsStorageSettings *EbsStorageSettings

	noSmithyDocumentSerde
}

// Defines the stairs traffic pattern for an Inference Recommender load test. This
// pattern type consists of multiple steps where the number of users increases at
// each step.
//
// Specify either the stairs or phases traffic pattern.
type Stairs struct {

	// Defines how long each traffic step should be.
	DurationInSeconds *int32

	// Specifies how many steps to perform during traffic.
	NumberOfSteps *int32

	// Specifies how many new users to spawn in each step.
	UsersPerStep *int32

	noSmithyDocumentSerde
}

// Specifies a limit to how long a model training job or model compilation job can
// run. It also specifies how long a managed spot training job has to complete.
// When the job reaches the time limit, SageMaker ends the training or compilation
// job. Use this API to cap model training costs.
//
// To stop a training job, SageMaker sends the algorithm the SIGTERM signal, which
// delays job termination for 120 seconds. Algorithms can use this 120-second
// window to save the model artifacts, so the results of training are not lost.
//
// The training algorithms provided by SageMaker automatically save the
// intermediate results of a model training job when possible. This attempt to save
// artifacts is only a best effort case as model might not be in a state from which
// it can be saved. For example, if training has just started, the model might not
// be ready to save. When saved, this intermediate data is a valid model artifact.
// You can use it to create a model with CreateModel .
//
// The Neural Topic Model (NTM) currently does not support saving intermediate
// model artifacts. When training NTMs, make sure that the maximum runtime is
// sufficient for the training job to complete.
type StoppingCondition struct {

	// The maximum length of time, in seconds, that a training or compilation job can
	// be pending before it is stopped.
	MaxPendingTimeInSeconds *int32

	// The maximum length of time, in seconds, that a training or compilation job can
	// run before it is stopped.
	//
	// For compilation jobs, if the job does not complete during this time, a TimeOut
	// error is generated. We recommend starting with 900 seconds and increasing as
	// necessary based on your model.
	//
	// For all other jobs, if the job does not complete during this time, SageMaker
	// ends the job. When RetryStrategy is specified in the job request,
	// MaxRuntimeInSeconds specifies the maximum time for all of the attempts in total,
	// not each individual attempt. The default value is 1 day. The maximum value is 28
	// days.
	//
	// The maximum time that a TrainingJob can run in total, including any time spent
	// publishing metrics or archiving and uploading models after it has been stopped,
	// is 30 days.
	MaxRuntimeInSeconds *int32

	// The maximum length of time, in seconds, that a managed Spot training job has to
	// complete. It is the amount of time spent waiting for Spot capacity plus the
	// amount of time the job can run. It must be equal to or greater than
	// MaxRuntimeInSeconds . If the job does not complete during this time, SageMaker
	// ends the job.
	//
	// When RetryStrategy is specified in the job request, MaxWaitTimeInSeconds
	// specifies the maximum time for all of the attempts in total, not each individual
	// attempt.
	MaxWaitTimeInSeconds *int32

	noSmithyDocumentSerde
}

// Details of the Amazon SageMaker Studio Lifecycle Configuration.
type StudioLifecycleConfigDetails struct {

	// The creation time of the Amazon SageMaker Studio Lifecycle Configuration.
	CreationTime *time.Time

	// This value is equivalent to CreationTime because Amazon SageMaker Studio
	// Lifecycle Configurations are immutable.
	LastModifiedTime *time.Time

	// The App type to which the Lifecycle Configuration is attached.
	StudioLifecycleConfigAppType StudioLifecycleConfigAppType

	//  The Amazon Resource Name (ARN) of the Lifecycle Configuration.
	StudioLifecycleConfigArn *string

	// The name of the Amazon SageMaker Studio Lifecycle Configuration.
	StudioLifecycleConfigName *string

	noSmithyDocumentSerde
}

// Describes a work team of a vendor that does the a labelling job.
type SubscribedWorkteam struct {

	// The Amazon Resource Name (ARN) of the vendor that you have subscribed.
	//
	// This member is required.
	WorkteamArn *string

	// Marketplace product listing ID.
	ListingId *string

	// The description of the vendor from the Amazon Marketplace.
	MarketplaceDescription *string

	// The title of the service provided by the vendor in the Amazon Marketplace.
	MarketplaceTitle *string

	// The name of the vendor in the Amazon Marketplace.
	SellerName *string

	noSmithyDocumentSerde
}

// Specified in the [GetSearchSuggestions] request. Limits the property names that are included in the
// response.
//
// [GetSearchSuggestions]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_GetSearchSuggestions.html
type SuggestionQuery struct {

	// Defines a property name hint. Only property names that begin with the specified
	// hint are included in the response.
	PropertyNameQuery *PropertyNameQuery

	noSmithyDocumentSerde
}

// The collection of settings used by an AutoML job V2 for the tabular problem
// type.
type TabularJobConfig struct {

	// The name of the target variable in supervised learning, usually represented by
	// 'y'.
	//
	// This member is required.
	TargetAttributeName *string

	// The configuration information of how model candidates are generated.
	CandidateGenerationConfig *CandidateGenerationConfig

	// How long a job is allowed to run, or how many candidates a job is allowed to
	// generate.
	CompletionCriteria *AutoMLJobCompletionCriteria

	// A URL to the Amazon S3 data source containing selected features from the input
	// data source to run an Autopilot job V2. You can input FeatureAttributeNames
	// (optional) in JSON format as shown below:
	//
	// { "FeatureAttributeNames":["col1", "col2", ...] } .
	//
	// You can also specify the data type of the feature (optional) in the format
	// shown below:
	//
	//     { "FeatureDataTypes":{"col1":"numeric", "col2":"categorical" ... } }
	//
	// These column keys may not include the target column.
	//
	// In ensembling mode, Autopilot only supports the following data types: numeric ,
	// categorical , text , and datetime . In HPO mode, Autopilot can support numeric ,
	// categorical , text , datetime , and sequence .
	//
	// If only FeatureDataTypes is provided, the column keys ( col1 , col2 ,..) should
	// be a subset of the column names in the input data.
	//
	// If both FeatureDataTypes and FeatureAttributeNames are provided, then the
	// column keys should be a subset of the column names provided in
	// FeatureAttributeNames .
	//
	// The key name FeatureAttributeNames is fixed. The values listed in ["col1",
	// "col2", ...] are case sensitive and should be a list of strings containing
	// unique values that are a subset of the column names in the input data. The list
	// of columns provided must not include the target column.
	FeatureSpecificationS3Uri *string

	// Generates possible candidates without training the models. A model candidate is
	// a combination of data preprocessors, algorithms, and algorithm parameter
	// settings.
	GenerateCandidateDefinitionsOnly *bool

	// The method that Autopilot uses to train the data. You can either specify the
	// mode manually or let Autopilot choose for you based on the dataset size by
	// selecting AUTO . In AUTO mode, Autopilot chooses ENSEMBLING for datasets
	// smaller than 100 MB, and HYPERPARAMETER_TUNING for larger ones.
	//
	// The ENSEMBLING mode uses a multi-stack ensemble model to predict classification
	// and regression tasks directly from your dataset. This machine learning mode
	// combines several base models to produce an optimal predictive model. It then
	// uses a stacking ensemble method to combine predictions from contributing
	// members. A multi-stack ensemble model can provide better performance over a
	// single model by combining the predictive capabilities of multiple models. See [Autopilot algorithm support]
	// for a list of algorithms supported by ENSEMBLING mode.
	//
	// The HYPERPARAMETER_TUNING (HPO) mode uses the best hyperparameters to train the
	// best version of a model. HPO automatically selects an algorithm for the type of
	// problem you want to solve. Then HPO finds the best hyperparameters according to
	// your objective metric. See [Autopilot algorithm support]for a list of algorithms supported by
	// HYPERPARAMETER_TUNING mode.
	//
	// [Autopilot algorithm support]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-model-support-validation.html#autopilot-algorithm-support
	Mode AutoMLMode

	// The type of supervised learning problem available for the model candidates of
	// the AutoML job V2. For more information, see [SageMaker Autopilot problem types].
	//
	// You must either specify the type of supervised learning problem in ProblemType
	// and provide the [AutoMLJobObjective]metric, or none at all.
	//
	// [SageMaker Autopilot problem types]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types
	// [AutoMLJobObjective]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html#sagemaker-CreateAutoMLJobV2-request-AutoMLJobObjective
	ProblemType ProblemType

	// If specified, this column name indicates which column of the dataset should be
	// treated as sample weights for use by the objective metric during the training,
	// evaluation, and the selection of the best model. This column is not considered
	// as a predictive feature. For more information on Autopilot metrics, see [Metrics and validation].
	//
	// Sample weights should be numeric, non-negative, with larger values indicating
	// which rows are more important than others. Data points that have invalid or no
	// weight value are excluded.
	//
	// Support for sample weights is available in [Ensembling] mode only.
	//
	// [Ensembling]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLAlgorithmConfig.html
	// [Metrics and validation]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-metrics-validation.html
	SampleWeightAttributeName *string

	noSmithyDocumentSerde
}

// The resolved attributes specific to the tabular problem type.
type TabularResolvedAttributes struct {

	// The type of supervised learning problem available for the model candidates of
	// the AutoML job V2 (Binary Classification, Multiclass Classification,
	// Regression). For more information, see [SageMaker Autopilot problem types].
	//
	// [SageMaker Autopilot problem types]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-datasets-problem-types.html#autopilot-problem-types
	ProblemType ProblemType

	noSmithyDocumentSerde
}

// A tag object that consists of a key and an optional value, used to manage
// metadata for SageMaker Amazon Web Services resources.
//
// You can add tags to notebook instances, training jobs, hyperparameter tuning
// jobs, batch transform jobs, models, labeling jobs, work teams, endpoint
// configurations, and endpoints. For more information on adding tags to SageMaker
// resources, see [AddTags].
//
// For more information on adding metadata to your Amazon Web Services resources
// with tagging, see [Tagging Amazon Web Services resources]. For advice on best practices for managing Amazon Web
// Services resources with tagging, see [Tagging Best Practices: Implement an Effective Amazon Web Services Resource Tagging Strategy].
//
// [Tagging Best Practices: Implement an Effective Amazon Web Services Resource Tagging Strategy]: https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf
// [AddTags]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AddTags.html
// [Tagging Amazon Web Services resources]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
type Tag struct {

	// The tag key. Tag keys must be unique per resource.
	//
	// This member is required.
	Key *string

	// The tag value.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Contains information about a target platform that you want your model to run
// on, such as OS, architecture, and accelerators. It is an alternative of
// TargetDevice .
type TargetPlatform struct {

	// Specifies a target platform architecture.
	//
	//   - X86_64 : 64-bit version of the x86 instruction set.
	//
	//   - X86 : 32-bit version of the x86 instruction set.
	//
	//   - ARM64 : ARMv8 64-bit CPU.
	//
	//   - ARM_EABIHF : ARMv7 32-bit, Hard Float.
	//
	//   - ARM_EABI : ARMv7 32-bit, Soft Float. Used by Android 32-bit ARM platform.
	//
	// This member is required.
	Arch TargetPlatformArch

	// Specifies a target platform OS.
	//
	//   - LINUX : Linux-based operating systems.
	//
	//   - ANDROID : Android operating systems. Android API level can be specified
	//   using the ANDROID_PLATFORM compiler option. For example, "CompilerOptions":
	//   {'ANDROID_PLATFORM': 28}
	//
	// This member is required.
	Os TargetPlatformOs

	// Specifies a target platform accelerator (optional).
	//
	//   - NVIDIA : Nvidia graphics processing unit. It also requires gpu-code ,
	//   trt-ver , cuda-ver compiler options
	//
	//   - MALI : ARM Mali graphics processor
	//
	//   - INTEL_GRAPHICS : Integrated Intel graphics
	Accelerator TargetPlatformAccelerator

	noSmithyDocumentSerde
}

// A target tracking scaling policy. Includes support for predefined or customized
// metrics.
//
// When using the [PutScalingPolicy] API, this parameter is required when you are creating a policy
// with the policy type TargetTrackingScaling .
//
// [PutScalingPolicy]: https://docs.aws.amazon.com/autoscaling/application/APIReference/API_PutScalingPolicy.html
type TargetTrackingScalingPolicyConfiguration struct {

	// An object containing information about a metric.
	MetricSpecification MetricSpecification

	// The recommended target value to specify for the metric when creating a scaling
	// policy.
	TargetValue *float64

	noSmithyDocumentSerde
}

// The TensorBoard app settings.
type TensorBoardAppSettings struct {

	// The default instance type and the Amazon Resource Name (ARN) of the SageMaker
	// image created on the instance.
	DefaultResourceSpec *ResourceSpec

	noSmithyDocumentSerde
}

// Configuration of storage locations for the Amazon SageMaker Debugger
// TensorBoard output data.
type TensorBoardOutputConfig struct {

	// Path to Amazon S3 storage location for TensorBoard output.
	//
	// This member is required.
	S3OutputPath *string

	// Path to local storage location for tensorBoard output. Defaults to
	// /opt/ml/output/tensorboard .
	LocalPath *string

	noSmithyDocumentSerde
}

// The collection of settings used by an AutoML job V2 for the text classification
// problem type.
type TextClassificationJobConfig struct {

	// The name of the column used to provide the sentences to be classified. It
	// should not be the same as the target column.
	//
	// This member is required.
	ContentColumn *string

	// The name of the column used to provide the class labels. It should not be same
	// as the content column.
	//
	// This member is required.
	TargetLabelColumn *string

	// How long a job is allowed to run, or how many candidates a job is allowed to
	// generate.
	CompletionCriteria *AutoMLJobCompletionCriteria

	noSmithyDocumentSerde
}

// The collection of settings used by an AutoML job V2 for the text generation
// problem type.
//
// The text generation models that support fine-tuning in Autopilot are currently
// accessible exclusively in regions supported by Canvas. Refer to the
// documentation of Canvas for the [full list of its supported Regions].
//
// [full list of its supported Regions]: https://docs.aws.amazon.com/sagemaker/latest/dg/canvas.html
type TextGenerationJobConfig struct {

	// The name of the base model to fine-tune. Autopilot supports fine-tuning a
	// variety of large language models. For information on the list of supported
	// models, see [Text generation models supporting fine-tuning in Autopilot]. If no BaseModelName is provided, the default model used is
	// Falcon7BInstruct.
	//
	// [Text generation models supporting fine-tuning in Autopilot]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-llms-finetuning-models.html#autopilot-llms-finetuning-supported-llms
	BaseModelName *string

	// How long a fine-tuning job is allowed to run. For TextGenerationJobConfig
	// problem types, the MaxRuntimePerTrainingJobInSeconds attribute of
	// AutoMLJobCompletionCriteria defaults to 72h (259200s).
	CompletionCriteria *AutoMLJobCompletionCriteria

	// The access configuration file to control access to the ML model. You can
	// explicitly accept the model end-user license agreement (EULA) within the
	// ModelAccessConfig .
	//
	//   - If you are a Jumpstart user, see the [End-user license agreements]section for more details on accepting
	//   the EULA.
	//
	//   - If you are an AutoML user, see the Optional Parameters section of Create an
	//   AutoML job to fine-tune text generation models using the API for details on [How to set the EULA acceptance when fine-tuning a model using the AutoML API].
	//
	// [End-user license agreements]: https://docs.aws.amazon.com/sagemaker/latest/dg/jumpstart-foundation-models-choose.html#jumpstart-foundation-models-choose-eula
	// [How to set the EULA acceptance when fine-tuning a model using the AutoML API]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-create-experiment-finetune-llms.html#autopilot-llms-finetuning-api-optional-params
	ModelAccessConfig *ModelAccessConfig

	// The hyperparameters used to configure and optimize the learning process of the
	// base model. You can set any combination of the following hyperparameters for all
	// base models. For more information on each supported hyperparameter, see [Optimize the learning process of your text generation models with hyperparameters].
	//
	//   - "epochCount" : The number of times the model goes through the entire
	//   training dataset. Its value should be a string containing an integer value
	//   within the range of "1" to "10".
	//
	//   - "batchSize" : The number of data samples used in each iteration of training.
	//   Its value should be a string containing an integer value within the range of "1"
	//   to "64".
	//
	//   - "learningRate" : The step size at which a model's parameters are updated
	//   during training. Its value should be a string containing a floating-point value
	//   within the range of "0" to "1".
	//
	//   - "learningRateWarmupSteps" : The number of training steps during which the
	//   learning rate gradually increases before reaching its target or maximum value.
	//   Its value should be a string containing an integer value within the range of "0"
	//   to "250".
	//
	// Here is an example where all four hyperparameters are configured.
	//
	//     { "epochCount":"5", "learningRate":"0.5", "batchSize": "32",
	//     "learningRateWarmupSteps": "10" }
	//
	// [Optimize the learning process of your text generation models with hyperparameters]: https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-llms-finetuning-set-hyperparameters.html
	TextGenerationHyperParameters map[string]string

	noSmithyDocumentSerde
}

// The resolved attributes specific to the text generation problem type.
type TextGenerationResolvedAttributes struct {

	// The name of the base model to fine-tune.
	BaseModelName *string

	noSmithyDocumentSerde
}

// Used to set feature group throughput configuration. There are two modes:
// ON_DEMAND and PROVISIONED . With on-demand mode, you are charged for data reads
// and writes that your application performs on your feature group. You do not need
// to specify read and write throughput because Feature Store accommodates your
// workloads as they ramp up and down. You can switch a feature group to on-demand
// only once in a 24 hour period. With provisioned throughput mode, you specify the
// read and write capacity per second that you expect your application to require,
// and you are billed based on those limits. Exceeding provisioned throughput will
// result in your requests being throttled.
//
// Note: PROVISIONED throughput mode is supported only for feature groups that are
// offline-only, or use the [Standard]Standard tier online store.
//
// [Standard]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType
type ThroughputConfig struct {

	// The mode used for your feature group throughput: ON_DEMAND or PROVISIONED .
	//
	// This member is required.
	ThroughputMode ThroughputMode

	//  For provisioned feature groups with online store enabled, this indicates the
	// read throughput you are billed for and can consume without throttling.
	//
	// This field is not applicable for on-demand feature groups.
	ProvisionedReadCapacityUnits *int32

	//  For provisioned feature groups, this indicates the write throughput you are
	// billed for and can consume without throttling.
	//
	// This field is not applicable for on-demand feature groups.
	ProvisionedWriteCapacityUnits *int32

	noSmithyDocumentSerde
}

// Active throughput configuration of the feature group. There are two modes:
// ON_DEMAND and PROVISIONED . With on-demand mode, you are charged for data reads
// and writes that your application performs on your feature group. You do not need
// to specify read and write throughput because Feature Store accommodates your
// workloads as they ramp up and down. You can switch a feature group to on-demand
// only once in a 24 hour period. With provisioned throughput mode, you specify the
// read and write capacity per second that you expect your application to require,
// and you are billed based on those limits. Exceeding provisioned throughput will
// result in your requests being throttled.
//
// Note: PROVISIONED throughput mode is supported only for feature groups that are
// offline-only, or use the [Standard]Standard tier online store.
//
// [Standard]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType
type ThroughputConfigDescription struct {

	// The mode used for your feature group throughput: ON_DEMAND or PROVISIONED .
	//
	// This member is required.
	ThroughputMode ThroughputMode

	//  For provisioned feature groups with online store enabled, this indicates the
	// read throughput you are billed for and can consume without throttling.
	//
	// This field is not applicable for on-demand feature groups.
	ProvisionedReadCapacityUnits *int32

	//  For provisioned feature groups, this indicates the write throughput you are
	// billed for and can consume without throttling.
	//
	// This field is not applicable for on-demand feature groups.
	ProvisionedWriteCapacityUnits *int32

	noSmithyDocumentSerde
}

// The new throughput configuration for the feature group. You can switch between
// on-demand and provisioned modes or update the read / write capacity of
// provisioned feature groups. You can switch a feature group to on-demand only
// once in a 24 hour period.
type ThroughputConfigUpdate struct {

	// For provisioned feature groups with online store enabled, this indicates the
	// read throughput you are billed for and can consume without throttling.
	ProvisionedReadCapacityUnits *int32

	// For provisioned feature groups, this indicates the write throughput you are
	// billed for and can consume without throttling.
	ProvisionedWriteCapacityUnits *int32

	// Target throughput mode of the feature group. Throughput update is an
	// asynchronous operation, and the outcome should be monitored by polling
	// LastUpdateStatus field in DescribeFeatureGroup response. You cannot update a
	// feature group's throughput while another update is in progress.
	ThroughputMode ThroughputMode

	noSmithyDocumentSerde
}

// The collection of components that defines the time-series.
type TimeSeriesConfig struct {

	// The name of the column that represents the set of item identifiers for which
	// you want to predict the target value.
	//
	// This member is required.
	ItemIdentifierAttributeName *string

	// The name of the column representing the target variable that you want to
	// predict for each item in your dataset. The data type of the target variable must
	// be numerical.
	//
	// This member is required.
	TargetAttributeName *string

	// The name of the column indicating a point in time at which the target value of
	// a given item is recorded.
	//
	// This member is required.
	TimestampAttributeName *string

	// A set of columns names that can be grouped with the item identifier column to
	// create a composite key for which a target value is predicted.
	GroupingAttributeNames []string

	noSmithyDocumentSerde
}

// The collection of settings used by an AutoML job V2 for the time-series
// forecasting problem type.
type TimeSeriesForecastingJobConfig struct {

	// The frequency of predictions in a forecast.
	//
	// Valid intervals are an integer followed by Y (Year), M (Month), W (Week), D
	// (Day), H (Hour), and min (Minute). For example, 1D indicates every day and 15min
	// indicates every 15 minutes. The value of a frequency must not overlap with the
	// next larger frequency. For example, you must use a frequency of 1H instead of
	// 60min .
	//
	// The valid values for each frequency are the following:
	//
	//   - Minute - 1-59
	//
	//   - Hour - 1-23
	//
	//   - Day - 1-6
	//
	//   - Week - 1-4
	//
	//   - Month - 1-11
	//
	//   - Year - 1
	//
	// This member is required.
	ForecastFrequency *string

	// The number of time-steps that the model predicts. The forecast horizon is also
	// called the prediction length. The maximum forecast horizon is the lesser of 500
	// time-steps or 1/4 of the time-steps in the dataset.
	//
	// This member is required.
	ForecastHorizon *int32

	// The collection of components that defines the time-series.
	//
	// This member is required.
	TimeSeriesConfig *TimeSeriesConfig

	// How long a job is allowed to run, or how many candidates a job is allowed to
	// generate.
	CompletionCriteria *AutoMLJobCompletionCriteria

	// A URL to the Amazon S3 data source containing additional selected features that
	// complement the target, itemID, timestamp, and grouped columns set in
	// TimeSeriesConfig . When not provided, the AutoML job V2 includes all the columns
	// from the original dataset that are not already declared in TimeSeriesConfig . If
	// provided, the AutoML job V2 only considers these additional columns as a
	// complement to the ones declared in TimeSeriesConfig .
	//
	// You can input FeatureAttributeNames (optional) in JSON format as shown below:
	//
	// { "FeatureAttributeNames":["col1", "col2", ...] } .
	//
	// You can also specify the data type of the feature (optional) in the format
	// shown below:
	//
	//     { "FeatureDataTypes":{"col1":"numeric", "col2":"categorical" ... } }
	//
	// Autopilot supports the following data types: numeric , categorical , text , and
	// datetime .
	//
	// These column keys must not include any column set in TimeSeriesConfig .
	FeatureSpecificationS3Uri *string

	// The quantiles used to train the model for forecasts at a specified quantile.
	// You can specify quantiles from 0.01 (p1) to 0.99 (p99), by increments of 0.01
	// or higher. Up to five forecast quantiles can be specified. When
	// ForecastQuantiles is not provided, the AutoML job uses the quantiles p10, p50,
	// and p90 as default.
	ForecastQuantiles []string

	// The collection of holiday featurization attributes used to incorporate national
	// holiday information into your forecasting model.
	HolidayConfig []HolidayConfigAttributes

	// The transformations modifying specific attributes of the time-series, such as
	// filling strategies for missing values.
	Transformations *TimeSeriesTransformations

	noSmithyDocumentSerde
}

// Time series forecast settings for the SageMaker Canvas application.
type TimeSeriesForecastingSettings struct {

	// The IAM role that Canvas passes to Amazon Forecast for time series forecasting.
	// By default, Canvas uses the execution role specified in the UserProfile that
	// launches the Canvas application. If an execution role is not specified in the
	// UserProfile , Canvas uses the execution role specified in the Domain that owns
	// the UserProfile . To allow time series forecasting, this IAM role should have
	// the [AmazonSageMakerCanvasForecastAccess]policy attached and forecast.amazonaws.com added in the trust relationship
	// as a service principal.
	//
	// [AmazonSageMakerCanvasForecastAccess]: https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-canvas.html#security-iam-awsmanpol-AmazonSageMakerCanvasForecastAccess
	AmazonForecastRoleArn *string

	// Describes whether time series forecasting is enabled or disabled in the Canvas
	// application.
	Status FeatureStatus

	noSmithyDocumentSerde
}

// Transformations allowed on the dataset. Supported transformations are Filling
// and Aggregation . Filling specifies how to add values to missing values in the
// dataset. Aggregation defines how to aggregate data that does not align with
// forecast frequency.
type TimeSeriesTransformations struct {

	// A key value pair defining the aggregation method for a column, where the key is
	// the column name and the value is the aggregation method.
	//
	// The supported aggregation methods are sum (default), avg , first , min , max .
	//
	// Aggregation is only supported for the target column.
	Aggregation map[string]AggregationTransformationValue

	// A key value pair defining the filling method for a column, where the key is the
	// column name and the value is an object which defines the filling logic. You can
	// specify multiple filling methods for a single column.
	//
	// The supported filling methods and their corresponding options are:
	//
	//   - frontfill : none (Supported only for target column)
	//
	//   - middlefill : zero , value , median , mean , min , max
	//
	//   - backfill : zero , value , median , mean , min , max
	//
	//   - futurefill : zero , value , median , mean , min , max
	//
	// To set a filling method to a specific value, set the fill parameter to the
	// chosen filling method value (for example "backfill" : "value" ), and define the
	// filling value in an additional parameter prefixed with "_value". For example, to
	// set backfill to a value of 2 , you must include two parameters: "backfill":
	// "value" and "backfill_value":"2" .
	Filling map[string]map[string]string

	noSmithyDocumentSerde
}

// Defines the traffic pattern of the load test.
type TrafficPattern struct {

	// Defines the phases traffic specification.
	Phases []Phase

	// Defines the stairs traffic pattern.
	Stairs *Stairs

	// Defines the traffic patterns. Choose either PHASES or STAIRS .
	TrafficType TrafficType

	noSmithyDocumentSerde
}

// Defines the traffic routing strategy during an endpoint deployment to shift
// traffic from the old fleet to the new fleet.
type TrafficRoutingConfig struct {

	// Traffic routing strategy type.
	//
	//   - ALL_AT_ONCE : Endpoint traffic shifts to the new fleet in a single step.
	//
	//   - CANARY : Endpoint traffic shifts to the new fleet in two steps. The first
	//   step is the canary, which is a small portion of the traffic. The second step is
	//   the remainder of the traffic.
	//
	//   - LINEAR : Endpoint traffic shifts to the new fleet in n steps of a
	//   configurable size.
	//
	// This member is required.
	Type TrafficRoutingConfigType

	// The waiting time (in seconds) between incremental steps to turn on traffic on
	// the new endpoint fleet.
	//
	// This member is required.
	WaitIntervalInSeconds *int32

	// Batch size for the first step to turn on traffic on the new endpoint fleet.
	// Value must be less than or equal to 50% of the variant's total instance count.
	CanarySize *CapacitySize

	// Batch size for each step to turn on traffic on the new endpoint fleet. Value
	// must be 10-50% of the variant's total instance count.
	LinearStepSize *CapacitySize

	noSmithyDocumentSerde
}

// The configuration to use an image from a private Docker registry for a training
// job.
type TrainingImageConfig struct {

	// The method that your training job will use to gain access to the images in your
	// private Docker registry. For access to an image in a private Docker registry,
	// set to Vpc .
	//
	// This member is required.
	TrainingRepositoryAccessMode TrainingRepositoryAccessMode

	// An object containing authentication information for a private Docker registry
	// containing your training images.
	TrainingRepositoryAuthConfig *TrainingRepositoryAuthConfig

	noSmithyDocumentSerde
}

// Contains information about a training job.
type TrainingJob struct {

	// Information about the algorithm used for training, and algorithm metadata.
	AlgorithmSpecification *AlgorithmSpecification

	// The Amazon Resource Name (ARN) of the job.
	AutoMLJobArn *string

	// The billable time in seconds.
	BillableTimeInSeconds *int32

	// Contains information about the output location for managed spot training
	// checkpoint data.
	CheckpointConfig *CheckpointConfig

	// A timestamp that indicates when the training job was created.
	CreationTime *time.Time

	// Configuration information for the Amazon SageMaker Debugger hook parameters,
	// metric and tensor collections, and storage paths. To learn more about how to
	// configure the DebugHookConfig parameter, see [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job].
	//
	// [Use the SageMaker and Debugger Configuration API Operations to Create, Update, and Debug Your Training Job]: https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html
	DebugHookConfig *DebugHookConfig

	// Information about the debug rule configuration.
	DebugRuleConfigurations []DebugRuleConfiguration

	// Information about the evaluation status of the rules for the training job.
	DebugRuleEvaluationStatuses []DebugRuleEvaluationStatus

	// To encrypt all communications between ML compute instances in distributed
	// training, choose True . Encryption provides greater security for distributed
	// training, but training might take longer. How long it takes depends on the
	// amount of communication between compute instances, especially if you use a deep
	// learning algorithm in distributed training.
	EnableInterContainerTrafficEncryption *bool

	// When true, enables managed spot training using Amazon EC2 Spot instances to run
	// training jobs instead of on-demand instances. For more information, see [Managed Spot Training].
	//
	// [Managed Spot Training]: https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html
	EnableManagedSpotTraining *bool

	// If the TrainingJob was created with network isolation, the value is set to true
	// . If network isolation is enabled, nodes can't communicate beyond the VPC they
	// run in.
	EnableNetworkIsolation *bool

	// The environment variables to set in the Docker container.
	Environment map[string]string

	// Associates a SageMaker job as a trial component with an experiment and trial.
	// Specified when you call the following APIs:
	//
	// [CreateProcessingJob]
	//
	// [CreateTrainingJob]
	//
	// [CreateTransformJob]
	//
	// [CreateTransformJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTransformJob.html
	// [CreateTrainingJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html
	// [CreateProcessingJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html
	ExperimentConfig *ExperimentConfig

	// If the training job failed, the reason it failed.
	FailureReason *string

	// A list of final metric values that are set when the training job completes.
	// Used only if the training job was configured to use metrics.
	FinalMetricDataList []MetricData

	// Algorithm-specific parameters.
	HyperParameters map[string]string

	// An array of Channel objects that describes each data input channel.
	//
	// Your input must be in the same Amazon Web Services region as your training job.
	InputDataConfig []Channel

	// The Amazon Resource Name (ARN) of the labeling job.
	LabelingJobArn *string

	// A timestamp that indicates when the status of the training job was last
	// modified.
	LastModifiedTime *time.Time

	// Information about the Amazon S3 location that is configured for storing model
	// artifacts.
	ModelArtifacts *ModelArtifacts

	// The S3 path where model artifacts that you configured when creating the job are
	// stored. SageMaker creates subfolders for model artifacts.
	OutputDataConfig *OutputDataConfig

	// Configuration information for Amazon SageMaker Debugger system monitoring,
	// framework profiling, and storage paths.
	ProfilerConfig *ProfilerConfig

	// Resources, including ML compute instances and ML storage volumes, that are
	// configured for model training.
	ResourceConfig *ResourceConfig

	// The number of times to retry the job when the job fails due to an
	// InternalServerError .
	RetryStrategy *RetryStrategy

	// The Amazon Web Services Identity and Access Management (IAM) role configured
	// for the training job.
	RoleArn *string

	//  Provides detailed information about the state of the training job. For
	// detailed information about the secondary status of the training job, see
	// StatusMessage under [SecondaryStatusTransition].
	//
	// SageMaker provides primary statuses and secondary statuses that apply to each
	// of them:
	//
	// InProgress
	//   - Starting - Starting the training job.
	//
	//   - Downloading - An optional stage for algorithms that support File training
	//   input mode. It indicates that data is being downloaded to the ML storage
	//   volumes.
	//
	//   - Training - Training is in progress.
	//
	//   - Uploading - Training is complete and the model artifacts are being uploaded
	//   to the S3 location.
	//
	// Completed
	//   - Completed - The training job has completed.
	//
	// Failed
	//   - Failed - The training job has failed. The reason for the failure is returned
	//   in the FailureReason field of DescribeTrainingJobResponse .
	//
	// Stopped
	//   - MaxRuntimeExceeded - The job stopped because it exceeded the maximum allowed
	//   runtime.
	//
	//   - Stopped - The training job has stopped.
	//
	// Stopping
	//   - Stopping - Stopping the training job.
	//
	// Valid values for SecondaryStatus are subject to change.
	//
	// We no longer support the following secondary statuses:
	//
	//   - LaunchingMLInstances
	//
	//   - PreparingTrainingStack
	//
	//   - DownloadingTrainingImage
	//
	// [SecondaryStatusTransition]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SecondaryStatusTransition.html
	SecondaryStatus SecondaryStatus

	// A history of all of the secondary statuses that the training job has
	// transitioned through.
	SecondaryStatusTransitions []SecondaryStatusTransition

	// Specifies a limit to how long a model training job can run. It also specifies
	// how long a managed Spot training job has to complete. When the job reaches the
	// time limit, SageMaker ends the training job. Use this API to cap model training
	// costs.
	//
	// To stop a job, SageMaker sends the algorithm the SIGTERM signal, which delays
	// job termination for 120 seconds. Algorithms can use this 120-second window to
	// save the model artifacts, so the results of training are not lost.
	StoppingCondition *StoppingCondition

	// An array of key-value pairs. You can use tags to categorize your Amazon Web
	// Services resources in different ways, for example, by purpose, owner, or
	// environment. For more information, see [Tagging Amazon Web Services Resources].
	//
	// [Tagging Amazon Web Services Resources]: https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html
	Tags []Tag

	// Configuration of storage locations for the Amazon SageMaker Debugger
	// TensorBoard output data.
	TensorBoardOutputConfig *TensorBoardOutputConfig

	// Indicates the time when the training job ends on training instances. You are
	// billed for the time interval between the value of TrainingStartTime and this
	// time. For successful jobs and stopped jobs, this is the time after model
	// artifacts are uploaded. For failed jobs, this is the time when SageMaker detects
	// a job failure.
	TrainingEndTime *time.Time

	// The Amazon Resource Name (ARN) of the training job.
	TrainingJobArn *string

	// The name of the training job.
	TrainingJobName *string

	// The status of the training job.
	//
	// Training job statuses are:
	//
	//   - InProgress - The training is in progress.
	//
	//   - Completed - The training job has completed.
	//
	//   - Failed - The training job has failed. To see the reason for the failure, see
	//   the FailureReason field in the response to a DescribeTrainingJobResponse call.
	//
	//   - Stopping - The training job is stopping.
	//
	//   - Stopped - The training job has stopped.
	//
	// For more detailed information, see SecondaryStatus .
	TrainingJobStatus TrainingJobStatus

	// Indicates the time when the training job starts on training instances. You are
	// billed for the time interval between this time and the value of TrainingEndTime
	// . The start time in CloudWatch Logs might be later than this time. The
	// difference is due to the time it takes to download the training data and to the
	// size of the training container.
	TrainingStartTime *time.Time

	// The training time in seconds.
	TrainingTimeInSeconds *int32

	// The Amazon Resource Name (ARN) of the associated hyperparameter tuning job if
	// the training job was launched by a hyperparameter tuning job.
	TuningJobArn *string

	// A [VpcConfig] object that specifies the VPC that this training job has access to. For more
	// information, see [Protect Training Jobs by Using an Amazon Virtual Private Cloud].
	//
	// [VpcConfig]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html
	// [Protect Training Jobs by Using an Amazon Virtual Private Cloud]: https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Defines the input needed to run a training job using the algorithm.
type TrainingJobDefinition struct {

	// An array of Channel objects, each of which specifies an input source.
	//
	// This member is required.
	InputDataConfig []Channel

	// the path to the S3 bucket where you want to store model artifacts. SageMaker
	// creates subfolders for the artifacts.
	//
	// This member is required.
	OutputDataConfig *OutputDataConfig

	// The resources, including the ML compute instances and ML storage volumes, to
	// use for model training.
	//
	// This member is required.
	ResourceConfig *ResourceConfig

	// Specifies a limit to how long a model training job can run. It also specifies
	// how long a managed Spot training job has to complete. When the job reaches the
	// time limit, SageMaker ends the training job. Use this API to cap model training
	// costs.
	//
	// To stop a job, SageMaker sends the algorithm the SIGTERM signal, which delays
	// job termination for 120 seconds. Algorithms can use this 120-second window to
	// save the model artifacts.
	//
	// This member is required.
	StoppingCondition *StoppingCondition

	// The training input mode that the algorithm supports. For more information about
	// input modes, see [Algorithms].
	//
	// Pipe mode
	//
	// If an algorithm supports Pipe mode, Amazon SageMaker streams data directly from
	// Amazon S3 to the container.
	//
	// File mode
	//
	// If an algorithm supports File mode, SageMaker downloads the training data from
	// S3 to the provisioned ML storage volume, and mounts the directory to the Docker
	// volume for the training container.
	//
	// You must provision the ML storage volume with sufficient capacity to
	// accommodate the data downloaded from S3. In addition to the training data, the
	// ML storage volume also stores the output model. The algorithm container uses the
	// ML storage volume to also store intermediate information, if any.
	//
	// For distributed algorithms, training data is distributed uniformly. Your
	// training duration is predictable if the input data objects sizes are
	// approximately the same. SageMaker does not split the files any further for model
	// training. If the object sizes are skewed, training won't be optimal as the data
	// distribution is also skewed when one host in a training cluster is overloaded,
	// thus becoming a bottleneck in training.
	//
	// FastFile mode
	//
	// If an algorithm supports FastFile mode, SageMaker streams data directly from S3
	// to the container with no code changes, and provides file system access to the
	// data. Users can author their training script to interact with these files as if
	// they were stored on disk.
	//
	// FastFile mode works best when the data is read sequentially. Augmented manifest
	// files aren't supported. The startup time is lower when there are fewer files in
	// the S3 bucket provided.
	//
	// [Algorithms]: https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html
	//
	// This member is required.
	TrainingInputMode TrainingInputMode

	// The hyperparameters used for the training job.
	HyperParameters map[string]string

	noSmithyDocumentSerde
}

// The numbers of training jobs launched by a hyperparameter tuning job,
// categorized by status.
type TrainingJobStatusCounters struct {

	// The number of completed training jobs launched by the hyperparameter tuning job.
	Completed *int32

	// The number of in-progress training jobs launched by a hyperparameter tuning job.
	InProgress *int32

	// The number of training jobs that failed and can't be retried. A failed training
	// job can't be retried if it failed because a client error occurred.
	NonRetryableError *int32

	// The number of training jobs that failed, but can be retried. A failed training
	// job can be retried only if it failed because an internal service error occurred.
	RetryableError *int32

	// The number of training jobs launched by a hyperparameter tuning job that were
	// manually stopped.
	Stopped *int32

	noSmithyDocumentSerde
}

// Metadata for a training job step.
type TrainingJobStepMetadata struct {

	// The Amazon Resource Name (ARN) of the training job that was run by this step
	// execution.
	Arn *string

	noSmithyDocumentSerde
}

// Provides summary information about a training job.
type TrainingJobSummary struct {

	// A timestamp that shows when the training job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the training job.
	//
	// This member is required.
	TrainingJobArn *string

	// The name of the training job that you want a summary for.
	//
	// This member is required.
	TrainingJobName *string

	// The status of the training job.
	//
	// This member is required.
	TrainingJobStatus TrainingJobStatus

	//  Timestamp when the training job was last modified.
	LastModifiedTime *time.Time

	// A timestamp that shows when the training job ended. This field is set only if
	// the training job has one of the terminal statuses ( Completed , Failed , or
	// Stopped ).
	TrainingEndTime *time.Time

	// The status of the warm pool associated with the training job.
	WarmPoolStatus *WarmPoolStatus

	noSmithyDocumentSerde
}

// An object containing authentication information for a private Docker registry.
type TrainingRepositoryAuthConfig struct {

	// The Amazon Resource Name (ARN) of an Amazon Web Services Lambda function used
	// to give SageMaker access credentials to your private Docker registry.
	//
	// This member is required.
	TrainingRepositoryCredentialsProviderArn *string

	noSmithyDocumentSerde
}

// Defines how the algorithm is used for a training job.
type TrainingSpecification struct {

	// A list of the instance types that this algorithm can use for training.
	//
	// This member is required.
	SupportedTrainingInstanceTypes []TrainingInstanceType

	// A list of ChannelSpecification objects, which specify the input sources to be
	// used by the algorithm.
	//
	// This member is required.
	TrainingChannels []ChannelSpecification

	// The Amazon ECR registry path of the Docker image that contains the training
	// algorithm.
	//
	// This member is required.
	TrainingImage *string

	// The additional data source used during the training job.
	AdditionalS3DataSource *AdditionalS3DataSource

	// A list of MetricDefinition objects, which are used for parsing metrics
	// generated by the algorithm.
	MetricDefinitions []MetricDefinition

	// A list of the HyperParameterSpecification objects, that define the supported
	// hyperparameters. This is required if the algorithm supports automatic model
	// tuning.>
	SupportedHyperParameters []HyperParameterSpecification

	// A list of the metrics that the algorithm emits that can be used as the
	// objective metric in a hyperparameter tuning job.
	SupportedTuningJobObjectiveMetrics []HyperParameterTuningJobObjective

	// Indicates whether the algorithm supports distributed training. If set to false,
	// buyers can't request more than one instance during training.
	SupportsDistributedTraining *bool

	// An MD5 hash of the training algorithm that identifies the Docker image used for
	// training.
	TrainingImageDigest *string

	noSmithyDocumentSerde
}

// Describes the location of the channel data.
type TransformDataSource struct {

	// The S3 location of the data source that is associated with a channel.
	//
	// This member is required.
	S3DataSource *TransformS3DataSource

	noSmithyDocumentSerde
}

// Describes the input source of a transform job and the way the transform job
// consumes it.
type TransformInput struct {

	// Describes the location of the channel data, which is, the S3 location of the
	// input data that the model can consume.
	//
	// This member is required.
	DataSource *TransformDataSource

	// If your transform data is compressed, specify the compression type. Amazon
	// SageMaker automatically decompresses the data for the transform job accordingly.
	// The default value is None .
	CompressionType CompressionType

	// The multipurpose internet mail extension (MIME) type of the data. Amazon
	// SageMaker uses the MIME type with each http call to transfer data to the
	// transform job.
	ContentType *string

	// The method to use to split the transform job's data files into smaller batches.
	// Splitting is necessary when the total size of each object is too large to fit in
	// a single request. You can also use data splitting to improve performance by
	// processing multiple concurrent mini-batches. The default value for SplitType is
	// None , which indicates that input data files are not split, and request payloads
	// contain the entire contents of an input object. Set the value of this parameter
	// to Line to split records on a newline character boundary. SplitType also
	// supports a number of record-oriented binary data formats. Currently, the
	// supported record formats are:
	//
	//   - RecordIO
	//
	//   - TFRecord
	//
	// When splitting is enabled, the size of a mini-batch depends on the values of
	// the BatchStrategy and MaxPayloadInMB parameters. When the value of BatchStrategy
	// is MultiRecord , Amazon SageMaker sends the maximum number of records in each
	// request, up to the MaxPayloadInMB limit. If the value of BatchStrategy is
	// SingleRecord , Amazon SageMaker sends individual records in each request.
	//
	// Some data formats represent a record as a binary payload wrapped with extra
	// padding bytes. When splitting is applied to a binary data format, padding is
	// removed if the value of BatchStrategy is set to SingleRecord . Padding is not
	// removed if the value of BatchStrategy is set to MultiRecord .
	//
	// For more information about RecordIO , see [Create a Dataset Using RecordIO] in the MXNet documentation. For more
	// information about TFRecord , see [Consuming TFRecord data] in the TensorFlow documentation.
	//
	// [Create a Dataset Using RecordIO]: https://mxnet.apache.org/api/faq/recordio
	// [Consuming TFRecord data]: https://www.tensorflow.org/guide/data#consuming_tfrecord_data
	SplitType SplitType

	noSmithyDocumentSerde
}

// A batch transform job. For information about SageMaker batch transform, see [Use Batch Transform].
//
// [Use Batch Transform]: https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html
type TransformJob struct {

	// The Amazon Resource Name (ARN) of the AutoML job that created the transform job.
	AutoMLJobArn *string

	// Specifies the number of records to include in a mini-batch for an HTTP
	// inference request. A record is a single unit of input data that inference can be
	// made on. For example, a single line in a CSV file is a record.
	BatchStrategy BatchStrategy

	// A timestamp that shows when the transform Job was created.
	CreationTime *time.Time

	// Configuration to control how SageMaker captures inference data for batch
	// transform jobs.
	DataCaptureConfig *BatchDataCaptureConfig

	// The data structure used to specify the data to be used for inference in a batch
	// transform job and to associate the data that is relevant to the prediction
	// results in the output. The input filter provided allows you to exclude input
	// data that is not needed for inference in a batch transform job. The output
	// filter provided allows you to include input data relevant to interpreting the
	// predictions in the output from the job. For more information, see [Associate Prediction Results with their Corresponding Input Records].
	//
	// [Associate Prediction Results with their Corresponding Input Records]: https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html
	DataProcessing *DataProcessing

	// The environment variables to set in the Docker container. We support up to 16
	// key and values entries in the map.
	Environment map[string]string

	// Associates a SageMaker job as a trial component with an experiment and trial.
	// Specified when you call the following APIs:
	//
	// [CreateProcessingJob]
	//
	// [CreateTrainingJob]
	//
	// [CreateTransformJob]
	//
	// [CreateTransformJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTransformJob.html
	// [CreateTrainingJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html
	// [CreateProcessingJob]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateProcessingJob.html
	ExperimentConfig *ExperimentConfig

	// If the transform job failed, the reason it failed.
	FailureReason *string

	// The Amazon Resource Name (ARN) of the labeling job that created the transform
	// job.
	LabelingJobArn *string

	// The maximum number of parallel requests that can be sent to each instance in a
	// transform job. If MaxConcurrentTransforms is set to 0 or left unset, SageMaker
	// checks the optional execution-parameters to determine the settings for your
	// chosen algorithm. If the execution-parameters endpoint is not enabled, the
	// default value is 1. For built-in algorithms, you don't need to set a value for
	// MaxConcurrentTransforms .
	MaxConcurrentTransforms *int32

	// The maximum allowed size of the payload, in MB. A payload is the data portion
	// of a record (without metadata). The value in MaxPayloadInMB must be greater
	// than, or equal to, the size of a single record. To estimate the size of a record
	// in MB, divide the size of your dataset by the number of records. To ensure that
	// the records fit within the maximum payload size, we recommend using a slightly
	// larger value. The default value is 6 MB. For cases where the payload might be
	// arbitrarily large and is transmitted using HTTP chunked encoding, set the value
	// to 0. This feature works only in supported algorithms. Currently, SageMaker
	// built-in algorithms do not support HTTP chunked encoding.
	MaxPayloadInMB *int32

	// Configures the timeout and maximum number of retries for processing a transform
	// job invocation.
	ModelClientConfig *ModelClientConfig

	// The name of the model associated with the transform job.
	ModelName *string

	// A list of tags associated with the transform job.
	Tags []Tag

	// Indicates when the transform job has been completed, or has stopped or failed.
	// You are billed for the time interval between this time and the value of
	// TransformStartTime .
	TransformEndTime *time.Time

	// Describes the input source of a transform job and the way the transform job
	// consumes it.
	TransformInput *TransformInput

	// The Amazon Resource Name (ARN) of the transform job.
	TransformJobArn *string

	// The name of the transform job.
	TransformJobName *string

	// The status of the transform job.
	//
	// Transform job statuses are:
	//
	//   - InProgress - The job is in progress.
	//
	//   - Completed - The job has completed.
	//
	//   - Failed - The transform job has failed. To see the reason for the failure,
	//   see the FailureReason field in the response to a DescribeTransformJob call.
	//
	//   - Stopping - The transform job is stopping.
	//
	//   - Stopped - The transform job has stopped.
	TransformJobStatus TransformJobStatus

	// Describes the results of a transform job.
	TransformOutput *TransformOutput

	// Describes the resources, including ML instance types and ML instance count, to
	// use for transform job.
	TransformResources *TransformResources

	// Indicates when the transform job starts on ML instances. You are billed for the
	// time interval between this time and the value of TransformEndTime .
	TransformStartTime *time.Time

	noSmithyDocumentSerde
}

// Defines the input needed to run a transform job using the inference
// specification specified in the algorithm.
type TransformJobDefinition struct {

	// A description of the input source and the way the transform job consumes it.
	//
	// This member is required.
	TransformInput *TransformInput

	// Identifies the Amazon S3 location where you want Amazon SageMaker to save the
	// results from the transform job.
	//
	// This member is required.
	TransformOutput *TransformOutput

	// Identifies the ML compute instances for the transform job.
	//
	// This member is required.
	TransformResources *TransformResources

	// A string that determines the number of records included in a single mini-batch.
	//
	// SingleRecord means only one record is used per mini-batch. MultiRecord means a
	// mini-batch is set to contain as many records that can fit within the
	// MaxPayloadInMB limit.
	BatchStrategy BatchStrategy

	// The environment variables to set in the Docker container. We support up to 16
	// key and values entries in the map.
	Environment map[string]string

	// The maximum number of parallel requests that can be sent to each instance in a
	// transform job. The default value is 1.
	MaxConcurrentTransforms *int32

	// The maximum payload size allowed, in MB. A payload is the data portion of a
	// record (without metadata).
	MaxPayloadInMB *int32

	noSmithyDocumentSerde
}

// Metadata for a transform job step.
type TransformJobStepMetadata struct {

	// The Amazon Resource Name (ARN) of the transform job that was run by this step
	// execution.
	Arn *string

	noSmithyDocumentSerde
}

// Provides a summary of a transform job. Multiple TransformJobSummary objects are
// returned as a list after in response to a [ListTransformJobs]call.
//
// [ListTransformJobs]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTransformJobs.html
type TransformJobSummary struct {

	// A timestamp that shows when the transform Job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the transform job.
	//
	// This member is required.
	TransformJobArn *string

	// The name of the transform job.
	//
	// This member is required.
	TransformJobName *string

	// The status of the transform job.
	//
	// This member is required.
	TransformJobStatus TransformJobStatus

	// If the transform job failed, the reason it failed.
	FailureReason *string

	// Indicates when the transform job was last modified.
	LastModifiedTime *time.Time

	// Indicates when the transform job ends on compute instances. For successful jobs
	// and stopped jobs, this is the exact time recorded after the results are
	// uploaded. For failed jobs, this is when Amazon SageMaker detected that the job
	// failed.
	TransformEndTime *time.Time

	noSmithyDocumentSerde
}

// Describes the results of a transform job.
type TransformOutput struct {

	// The Amazon S3 path where you want Amazon SageMaker to store the results of the
	// transform job. For example, s3://bucket-name/key-name-prefix .
	//
	// For every S3 object used as input for the transform job, batch transform stores
	// the transformed data with an . out suffix in a corresponding subfolder in the
	// location in the output prefix. For example, for the input data stored at
	// s3://bucket-name/input-name-prefix/dataset01/data.csv , batch transform stores
	// the transformed data at
	// s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out . Batch
	// transform doesn't upload partially processed objects. For an input S3 object
	// that contains multiple records, it creates an . out file only if the transform
	// job succeeds on the entire file. When the input contains multiple S3 objects,
	// the batch transform job processes the listed S3 objects and uploads only the
	// output for successfully processed objects. If any object fails in the transform
	// job batch transform marks the job as failed to prompt investigation.
	//
	// This member is required.
	S3OutputPath *string

	// The MIME type used to specify the output data. Amazon SageMaker uses the MIME
	// type with each http call to transfer data from the transform job.
	Accept *string

	// Defines how to assemble the results of the transform job as a single S3 object.
	// Choose a format that is most convenient to you. To concatenate the results in
	// binary format, specify None . To add a newline character at the end of every
	// transformed record, specify Line .
	AssembleWith AssemblyType

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt the model artifacts at rest using Amazon
	// S3 server-side encryption. The KmsKeyId can be any of the following formats:
	//
	//   - Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   - Key ARN:
	//   arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   - Alias name: alias/ExampleAlias
	//
	//   - Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias
	//
	// If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key
	// for Amazon S3 for your role's account. For more information, see [KMS-Managed Encryption Keys]in the Amazon
	// Simple Storage Service Developer Guide.
	//
	// The KMS key policy must grant permission to the IAM role that you specify in
	// your [CreateModel]request. For more information, see [Using Key Policies in Amazon Web Services KMS] in the Amazon Web Services Key
	// Management Service Developer Guide.
	//
	// [CreateModel]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html
	// [KMS-Managed Encryption Keys]: https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html
	// [Using Key Policies in Amazon Web Services KMS]: https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Describes the resources, including ML instance types and ML instance count, to
// use for transform job.
type TransformResources struct {

	// The number of ML compute instances to use in the transform job. The default
	// value is 1 , and the maximum is 100 . For distributed transform jobs, specify a
	// value greater than 1 .
	//
	// This member is required.
	InstanceCount *int32

	// The ML compute instance type for the transform job. If you are using built-in
	// algorithms to transform moderately sized datasets, we recommend using
	// ml.m4.xlarge or ml.m5.large instance types.
	//
	// This member is required.
	InstanceType TransformInstanceType

	// The Amazon Web Services Key Management Service (Amazon Web Services KMS) key
	// that Amazon SageMaker uses to encrypt model data on the storage volume attached
	// to the ML compute instance(s) that run the batch transform job.
	//
	// Certain Nitro-based instances include local storage, dependent on the instance
	// type. Local storage volumes are encrypted using a hardware module on the
	// instance. You can't request a VolumeKmsKeyId when using an instance type with
	// local storage.
	//
	// For a list of instance types that support local instance storage, see [Instance Store Volumes].
	//
	// For more information about local instance storage encryption, see [SSD Instance Store Volumes].
	//
	// The VolumeKmsKeyId can be any of the following formats:
	//
	//   - Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   - Key ARN:
	//   arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   - Alias name: alias/ExampleAlias
	//
	//   - Alias name ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias
	//
	// [SSD Instance Store Volumes]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html
	// [Instance Store Volumes]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes
	VolumeKmsKeyId *string

	noSmithyDocumentSerde
}

// Describes the S3 data source.
type TransformS3DataSource struct {

	// If you choose S3Prefix , S3Uri identifies a key name prefix. Amazon SageMaker
	// uses all objects with the specified key name prefix for batch transform.
	//
	// If you choose ManifestFile , S3Uri identifies an object that is a manifest file
	// containing a list of object keys that you want Amazon SageMaker to use for batch
	// transform.
	//
	// The following values are compatible: ManifestFile , S3Prefix
	//
	// The following value is not compatible: AugmentedManifestFile
	//
	// This member is required.
	S3DataType S3DataType

	// Depending on the value specified for the S3DataType , identifies either a key
	// name prefix or a manifest. For example:
	//
	//   - A key name prefix might look like this: s3://bucketname/exampleprefix/ .
	//
	//   - A manifest might look like this: s3://bucketname/example.manifest
	//
	// The manifest is an S3 object which is a JSON file with the following format:
	//
	// [ {"prefix": "s3://customer_bucket/some/prefix/"},
	//
	// "relative/path/to/custdata-1",
	//
	// "relative/path/custdata-2",
	//
	// ...
	//
	// "relative/path/custdata-N"
	//
	// ]
	//
	// The preceding JSON matches the following S3Uris :
	//
	// s3://customer_bucket/some/prefix/relative/path/to/custdata-1
	//
	// s3://customer_bucket/some/prefix/relative/path/custdata-2
	//
	// ...
	//
	// s3://customer_bucket/some/prefix/relative/path/custdata-N
	//
	// The complete set of S3Uris in this manifest constitutes the input data for the
	//   channel for this datasource. The object that each S3Uris points to must be
	//   readable by the IAM role that Amazon SageMaker uses to perform tasks on your
	//   behalf.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// The properties of a trial as returned by the [Search] API.
//
// [Search]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html
type Trial struct {

	// Who created the trial.
	CreatedBy *UserContext

	// When the trial was created.
	CreationTime *time.Time

	// The name of the trial as displayed. If DisplayName isn't specified, TrialName
	// is displayed.
	DisplayName *string

	// The name of the experiment the trial is part of.
	ExperimentName *string

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	LastModifiedBy *UserContext

	// Who last modified the trial.
	LastModifiedTime *time.Time

	// Metadata properties of the tracking entity, trial, or trial component.
	MetadataProperties *MetadataProperties

	// The source of the trial.
	Source *TrialSource

	// The list of tags that are associated with the trial. You can use [Search] API to search
	// on the tags.
	//
	// [Search]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html
	Tags []Tag

	// The Amazon Resource Name (ARN) of the trial.
	TrialArn *string

	// A list of the components associated with the trial. For each component, a
	// summary of the component's properties is included.
	TrialComponentSummaries []TrialComponentSimpleSummary

	// The name of the trial.
	TrialName *string

	noSmithyDocumentSerde
}

// The properties of a trial component as returned by the [Search] API.
//
// [Search]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html
type TrialComponent struct {

	// Who created the trial component.
	CreatedBy *UserContext

	// When the component was created.
	CreationTime *time.Time

	// The name of the component as displayed. If DisplayName isn't specified,
	// TrialComponentName is displayed.
	DisplayName *string

	// When the component ended.
	EndTime *time.Time

	// The input artifacts of the component.
	InputArtifacts map[string]TrialComponentArtifact

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	LastModifiedBy *UserContext

	// When the component was last modified.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the lineage group resource.
	LineageGroupArn *string

	// Metadata properties of the tracking entity, trial, or trial component.
	MetadataProperties *MetadataProperties

	// The metrics for the component.
	Metrics []TrialComponentMetricSummary

	// The output artifacts of the component.
	OutputArtifacts map[string]TrialComponentArtifact

	// The hyperparameters of the component.
	Parameters map[string]TrialComponentParameterValue

	// An array of the parents of the component. A parent is a trial the component is
	// associated with and the experiment the trial is part of. A component might not
	// have any parents.
	Parents []Parent

	// The name of the experiment run.
	RunName *string

	// The Amazon Resource Name (ARN) and job type of the source of the component.
	Source *TrialComponentSource

	// Details of the source of the component.
	SourceDetail *TrialComponentSourceDetail

	// When the component started.
	StartTime *time.Time

	// The status of the trial component.
	Status *TrialComponentStatus

	// The list of tags that are associated with the component. You can use [Search] API to
	// search on the tags.
	//
	// [Search]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html
	Tags []Tag

	// The Amazon Resource Name (ARN) of the trial component.
	TrialComponentArn *string

	// The name of the trial component.
	TrialComponentName *string

	noSmithyDocumentSerde
}

// Represents an input or output artifact of a trial component. You specify
// TrialComponentArtifact as part of the InputArtifacts and OutputArtifacts
// parameters in the [CreateTrialComponent]request.
//
// Examples of input artifacts are datasets, algorithms, hyperparameters, source
// code, and instance types. Examples of output artifacts are metrics, snapshots,
// logs, and images.
//
// [CreateTrialComponent]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrialComponent.html
type TrialComponentArtifact struct {

	// The location of the artifact.
	//
	// This member is required.
	Value *string

	// The media type of the artifact, which indicates the type of data in the
	// artifact file. The media type consists of a type and a subtype concatenated with
	// a slash (/) character, for example, text/csv, image/jpeg, and s3/uri. The type
	// specifies the category of the media. The subtype specifies the kind of data.
	MediaType *string

	noSmithyDocumentSerde
}

// A summary of the metrics of a trial component.
type TrialComponentMetricSummary struct {

	// The average value of the metric.
	Avg *float64

	// The number of samples used to generate the metric.
	Count *int32

	// The most recent value of the metric.
	Last *float64

	// The maximum value of the metric.
	Max *float64

	// The name of the metric.
	MetricName *string

	// The minimum value of the metric.
	Min *float64

	// The Amazon Resource Name (ARN) of the source.
	SourceArn *string

	// The standard deviation of the metric.
	StdDev *float64

	// When the metric was last updated.
	TimeStamp *time.Time

	noSmithyDocumentSerde
}

// The value of a hyperparameter. Only one of NumberValue or StringValue can be
// specified.
//
// This object is specified in the [CreateTrialComponent] request.
//
// The following types satisfy this interface:
//
//	TrialComponentParameterValueMemberNumberValue
//	TrialComponentParameterValueMemberStringValue
//
// [CreateTrialComponent]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrialComponent.html
type TrialComponentParameterValue interface {
	isTrialComponentParameterValue()
}

// The numeric value of a numeric hyperparameter. If you specify a value for this
// parameter, you can't specify the StringValue parameter.
type TrialComponentParameterValueMemberNumberValue struct {
	Value float64

	noSmithyDocumentSerde
}

func (*TrialComponentParameterValueMemberNumberValue) isTrialComponentParameterValue() {}

// The string value of a categorical hyperparameter. If you specify a value for
// this parameter, you can't specify the NumberValue parameter.
type TrialComponentParameterValueMemberStringValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*TrialComponentParameterValueMemberStringValue) isTrialComponentParameterValue() {}

// A short summary of a trial component.
type TrialComponentSimpleSummary struct {

	// Information about the user who created or modified an experiment, trial, trial
	// component, lineage group, project, or model card.
	CreatedBy *UserContext

	// When the component was created.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the trial component.
	TrialComponentArn *string

	// The name of the trial component.
	TrialComponentName *string

	// The Amazon Resource Name (ARN) and job type of the source of a trial component.
	TrialComponentSource *TrialComponentSource

	noSmithyDocumentSerde
}

// The Amazon Resource Name (ARN) and job type of the source of a trial component.
type TrialComponentSource struct {

	// The source Amazon Resource Name (ARN).
	//
	// This member is required.
	SourceArn *string

	// The source job type.
	SourceType *string

	noSmithyDocumentSerde
}

// Detailed information about the source of a trial component. Either ProcessingJob
// or TrainingJob is returned.
type TrialComponentSourceDetail struct {

	// Information about a processing job that's the source of a trial component.
	ProcessingJob *ProcessingJob

	// The Amazon Resource Name (ARN) of the source.
	SourceArn *string

	// Information about a training job that's the source of a trial component.
	TrainingJob *TrainingJob

	// Information about a transform job that's the source of a trial component.
	TransformJob *TransformJob

	noSmithyDocumentSerde
}

// The status of the trial component.
type TrialComponentStatus struct {

	// If the component failed, a message describing why.
	Message *string

	// The status of the trial component.
	PrimaryStatus TrialComponentPrimaryStatus

	noSmithyDocumentSerde
}

// A summary of the properties of a trial component. To get all the properties,
// call the [DescribeTrialComponent]API and provide the TrialComponentName .
//
// [DescribeTrialComponent]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrialComponent.html
type TrialComponentSummary struct {

	// Who created the trial component.
	CreatedBy *UserContext

	// When the component was created.
	CreationTime *time.Time

	// The name of the component as displayed. If DisplayName isn't specified,
	// TrialComponentName is displayed.
	DisplayName *string

	// When the component ended.
	EndTime *time.Time

	// Who last modified the component.
	LastModifiedBy *UserContext

	// When the component was last modified.
	LastModifiedTime *time.Time

	// When the component started.
	StartTime *time.Time

	// The status of the component. States include:
	//
	//   - InProgress
	//
	//   - Completed
	//
	//   - Failed
	Status *TrialComponentStatus

	// The Amazon Resource Name (ARN) of the trial component.
	TrialComponentArn *string

	// The name of the trial component.
	TrialComponentName *string

	// The Amazon Resource Name (ARN) and job type of the source of a trial component.
	TrialComponentSource *TrialComponentSource

	noSmithyDocumentSerde
}

// The source of the trial.
type TrialSource struct {

	// The Amazon Resource Name (ARN) of the source.
	//
	// This member is required.
	SourceArn *string

	// The source job type.
	SourceType *string

	noSmithyDocumentSerde
}

// A summary of the properties of a trial. To get the complete set of properties,
// call the [DescribeTrial]API and provide the TrialName .
//
// [DescribeTrial]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrial.html
type TrialSummary struct {

	// When the trial was created.
	CreationTime *time.Time

	// The name of the trial as displayed. If DisplayName isn't specified, TrialName
	// is displayed.
	DisplayName *string

	// When the trial was last modified.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the trial.
	TrialArn *string

	// The name of the trial.
	TrialName *string

	// The source of the trial.
	TrialSource *TrialSource

	noSmithyDocumentSerde
}

// Time to live duration, where the record is hard deleted after the expiration
// time is reached; ExpiresAt = EventTime + TtlDuration . For information on
// HardDelete, see the [DeleteRecord]API in the Amazon SageMaker API Reference guide.
//
// [DeleteRecord]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html
type TtlDuration struct {

	// TtlDuration time unit.
	Unit TtlDurationUnit

	// TtlDuration time value.
	Value *int32

	noSmithyDocumentSerde
}

// The job completion criteria.
type TuningJobCompletionCriteria struct {

	// A flag to stop your hyperparameter tuning job if model performance fails to
	// improve as evaluated against an objective function.
	BestObjectiveNotImproving *BestObjectiveNotImproving

	// A flag to top your hyperparameter tuning job if automatic model tuning (AMT)
	// has detected that your model has converged as evaluated against your objective
	// function.
	ConvergenceDetected *ConvergenceDetected

	// The value of the objective metric.
	TargetObjectiveMetricValue *float32

	noSmithyDocumentSerde
}

// Metadata for a tuning step.
type TuningJobStepMetaData struct {

	// The Amazon Resource Name (ARN) of the tuning job that was run by this step
	// execution.
	Arn *string

	noSmithyDocumentSerde
}

// Provided configuration information for the worker UI for a labeling job.
// Provide either HumanTaskUiArn or UiTemplateS3Uri .
//
// For named entity recognition, 3D point cloud and video frame labeling jobs, use
// HumanTaskUiArn .
//
// For all other Ground Truth built-in task types and custom task types, use
// UiTemplateS3Uri to specify the location of a worker task template in Amazon S3.
type UiConfig struct {

	// The ARN of the worker task template used to render the worker UI and tools for
	// labeling job tasks.
	//
	// Use this parameter when you are creating a labeling job for named entity
	// recognition, 3D point cloud and video frame labeling jobs. Use your labeling job
	// task type to select one of the following ARNs and use it with this parameter
	// when you create a labeling job. Replace aws-region with the Amazon Web Services
	// Region you are creating your labeling job in. For example, replace aws-region
	// with us-west-1 if you create a labeling job in US West (N. California).
	//
	// Named Entity Recognition
	//
	// Use the following HumanTaskUiArn for named entity recognition labeling jobs:
	//
	//     arn:aws:sagemaker:aws-region:394669845002:human-task-ui/NamedEntityRecognition
	//
	// 3D Point Cloud HumanTaskUiArns
	//
	// Use this HumanTaskUiArn for 3D point cloud object detection and 3D point cloud
	// object detection adjustment labeling jobs.
	//
	//   -
	//   arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectDetection
	//
	// Use this HumanTaskUiArn for 3D point cloud object tracking and 3D point cloud
	// object tracking adjustment labeling jobs.
	//
	//   -
	//   arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudObjectTracking
	//
	// Use this HumanTaskUiArn for 3D point cloud semantic segmentation and 3D point
	// cloud semantic segmentation adjustment labeling jobs.
	//
	//   -
	//   arn:aws:sagemaker:aws-region:394669845002:human-task-ui/PointCloudSemanticSegmentation
	//
	// Video Frame HumanTaskUiArns
	//
	// Use this HumanTaskUiArn for video frame object detection and video frame object
	// detection adjustment labeling jobs.
	//
	//   - arn:aws:sagemaker:region:394669845002:human-task-ui/VideoObjectDetection
	//
	// Use this HumanTaskUiArn for video frame object tracking and video frame object
	// tracking adjustment labeling jobs.
	//
	//   - arn:aws:sagemaker:aws-region:394669845002:human-task-ui/VideoObjectTracking
	HumanTaskUiArn *string

	// The Amazon S3 bucket location of the UI template, or worker task template. This
	// is the template used to render the worker UI and tools for labeling job tasks.
	// For more information about the contents of a UI template, see [Creating Your Custom Labeling Task Template].
	//
	// [Creating Your Custom Labeling Task Template]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step2.html
	UiTemplateS3Uri *string

	noSmithyDocumentSerde
}

// The Liquid template for the worker user interface.
type UiTemplate struct {

	// The content of the Liquid template for the worker user interface.
	//
	// This member is required.
	Content *string

	noSmithyDocumentSerde
}

// Container for user interface template information.
type UiTemplateInfo struct {

	// The SHA-256 digest of the contents of the template.
	ContentSha256 *string

	// The URL for the user interface template.
	Url *string

	noSmithyDocumentSerde
}

// Represents an amount of money in United States dollars.
type USD struct {

	// The fractional portion, in cents, of the amount.
	Cents *int32

	// The whole number of dollars in the amount.
	Dollars *int32

	// Fractions of a cent, in tenths.
	TenthFractionsOfACent *int32

	noSmithyDocumentSerde
}

// Information about the user who created or modified an experiment, trial, trial
// component, lineage group, project, or model card.
type UserContext struct {

	// The domain associated with the user.
	DomainId *string

	// The IAM Identity details associated with the user. These details are associated
	// with model package groups, model packages, and project entities only.
	IamIdentity *IamIdentity

	// The Amazon Resource Name (ARN) of the user's profile.
	UserProfileArn *string

	// The name of the user's profile.
	UserProfileName *string

	noSmithyDocumentSerde
}

// The user profile details.
type UserProfileDetails struct {

	// The creation time.
	CreationTime *time.Time

	// The domain ID.
	DomainId *string

	// The last modified time.
	LastModifiedTime *time.Time

	// The status.
	Status UserProfileStatus

	// The user profile name.
	UserProfileName *string

	noSmithyDocumentSerde
}

// A collection of settings that apply to users in a domain. These settings are
// specified when the CreateUserProfile API is called, and as DefaultUserSettings
// when the CreateDomain API is called.
//
// SecurityGroups is aggregated when specified in both calls. For all other
// settings in UserSettings , the values specified in CreateUserProfile take
// precedence over those specified in CreateDomain .
type UserSettings struct {

	// The Canvas app settings.
	CanvasAppSettings *CanvasAppSettings

	// The Code Editor application settings.
	CodeEditorAppSettings *CodeEditorAppSettings

	// The settings for assigning a custom file system to a user profile. Permitted
	// users can access this file system in Amazon SageMaker Studio.
	CustomFileSystemConfigs []CustomFileSystemConfig

	// Details about the POSIX identity that is used for file system operations.
	CustomPosixUserConfig *CustomPosixUserConfig

	// The default experience that the user is directed to when accessing the domain.
	// The supported values are:
	//
	//   - studio:: : Indicates that Studio is the default experience. This value can
	//   only be passed if StudioWebPortal is set to ENABLED .
	//
	//   - app:JupyterServer: : Indicates that Studio Classic is the default experience.
	DefaultLandingUri *string

	// The execution role for the user.
	ExecutionRole *string

	// The settings for the JupyterLab application.
	JupyterLabAppSettings *JupyterLabAppSettings

	// The Jupyter server's app settings.
	JupyterServerAppSettings *JupyterServerAppSettings

	// The kernel gateway app settings.
	KernelGatewayAppSettings *KernelGatewayAppSettings

	// A collection of settings that configure the RSessionGateway app.
	RSessionAppSettings *RSessionAppSettings

	// A collection of settings that configure user interaction with the
	// RStudioServerPro app.
	RStudioServerProAppSettings *RStudioServerProAppSettings

	// The security groups for the Amazon Virtual Private Cloud (VPC) that the domain
	// uses for communication.
	//
	// Optional when the CreateDomain.AppNetworkAccessType parameter is set to
	// PublicInternetOnly .
	//
	// Required when the CreateDomain.AppNetworkAccessType parameter is set to VpcOnly
	// , unless specified as part of the DefaultUserSettings for the domain.
	//
	// Amazon SageMaker adds a security group to allow NFS traffic from Amazon
	// SageMaker Studio. Therefore, the number of security groups that you can specify
	// is one less than the maximum number shown.
	SecurityGroups []string

	// Specifies options for sharing Amazon SageMaker Studio notebooks.
	SharingSettings *SharingSettings

	// The storage settings for a space.
	SpaceStorageSettings *DefaultSpaceStorageSettings

	// Whether the user can access Studio. If this value is set to DISABLED , the user
	// cannot access Studio, even if that is the default experience for the domain.
	StudioWebPortal StudioWebPortal

	// The TensorBoard app settings.
	TensorBoardAppSettings *TensorBoardAppSettings

	noSmithyDocumentSerde
}

// Specifies a production variant property type for an Endpoint.
//
// If you are updating an endpoint with the RetainAllVariantProperties option of [UpdateEndpointInput]
// set to true , the VariantProperty objects listed in the
// ExcludeRetainedVariantProperties parameter of [UpdateEndpointInput] override the existing variant
// properties of the endpoint.
//
// [UpdateEndpointInput]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateEndpoint.html
type VariantProperty struct {

	// The type of variant property. The supported values are:
	//
	//   - DesiredInstanceCount : Overrides the existing variant instance counts using
	//   the InitialInstanceCount values in the ProductionVariants of [CreateEndpointConfig].
	//
	//   - DesiredWeight : Overrides the existing variant weights using the
	//   InitialVariantWeight values in the ProductionVariants of [CreateEndpointConfig].
	//
	//   - DataCaptureConfig : (Not currently supported.)
	//
	// [CreateEndpointConfig]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html
	//
	// This member is required.
	VariantPropertyType VariantPropertyType

	noSmithyDocumentSerde
}

// Configuration for your vector collection type.
type VectorConfig struct {

	// The number of elements in your vector.
	//
	// This member is required.
	Dimension *int32

	noSmithyDocumentSerde
}

// A lineage entity connected to the starting entity(ies).
type Vertex struct {

	// The Amazon Resource Name (ARN) of the lineage entity resource.
	Arn *string

	// The type of resource of the lineage entity.
	LineageType LineageType

	// The type of the lineage entity resource. For example: DataSet , Model , Endpoint
	// , etc...
	Type *string

	noSmithyDocumentSerde
}

// The list of key-value pairs used to filter your search results. If a search
// result contains a key from your list, it is included in the final search
// response if the value associated with the key in the result matches the value
// you specified. If the value doesn't match, the result is excluded from the
// search response. Any resources that don't have a key from the list that you've
// provided will also be included in the search response.
type VisibilityConditions struct {

	// The key that specifies the tag that you're using to filter the search results.
	// It must be in the following format: Tags. .
	Key *string

	// The value for the tag that you're using to filter the search results.
	Value *string

	noSmithyDocumentSerde
}

// Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs,
// hosted models, and compute resources have access to. You can control access to
// and from your resources by configuring a VPC. For more information, see [Give SageMaker Access to Resources in your Amazon VPC].
//
// [Give SageMaker Access to Resources in your Amazon VPC]: https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html
type VpcConfig struct {

	// The VPC security group IDs, in the form sg-xxxxxxxx . Specify the security
	// groups for the VPC that is specified in the Subnets field.
	//
	// This member is required.
	SecurityGroupIds []string

	// The ID of the subnets in the VPC to which you want to connect your training job
	// or model. For information about the availability of specific instance types, see
	// [Supported Instance Types and Availability Zones].
	//
	// [Supported Instance Types and Availability Zones]: https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html
	//
	// This member is required.
	Subnets []string

	noSmithyDocumentSerde
}

// Status and billing information about the warm pool.
type WarmPoolStatus struct {

	// The status of the warm pool.
	//
	//   - InUse : The warm pool is in use for the training job.
	//
	//   - Available : The warm pool is available to reuse for a matching training job.
	//
	//   - Reused : The warm pool moved to a matching training job for reuse.
	//
	//   - Terminated : The warm pool is no longer available. Warm pools are
	//   unavailable if they are terminated by a user, terminated for a patch update, or
	//   terminated for exceeding the specified KeepAlivePeriodInSeconds .
	//
	// This member is required.
	Status WarmPoolResourceStatus

	// The billable time in seconds used by the warm pool. Billable time refers to the
	// absolute wall-clock time.
	//
	// Multiply ResourceRetainedBillableTimeInSeconds by the number of instances (
	// InstanceCount ) in your training cluster to get the total compute time SageMaker
	// bills you if you run warm pool training. The formula is as follows:
	// ResourceRetainedBillableTimeInSeconds * InstanceCount .
	ResourceRetainedBillableTimeInSeconds *int32

	// The name of the matching training job that reused the warm pool.
	ReusedByJob *string

	noSmithyDocumentSerde
}

// Use this optional parameter to constrain access to an Amazon S3 resource based
// on the IP address using supported IAM global condition keys. The Amazon S3
// resource is accessed in the worker portal using a Amazon S3 presigned URL.
type WorkerAccessConfiguration struct {

	// Defines any Amazon S3 resource constraints.
	S3Presign *S3Presign

	noSmithyDocumentSerde
}

// A single private workforce, which is automatically created when you create your
// first private work team. You can create one private work force in each Amazon
// Web Services Region. By default, any workforce-related API operation used in a
// specific region will apply to the workforce created in that region. To learn how
// to create a private workforce, see [Create a Private Workforce].
//
// [Create a Private Workforce]: https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html
type Workforce struct {

	// The Amazon Resource Name (ARN) of the private workforce.
	//
	// This member is required.
	WorkforceArn *string

	// The name of the private workforce.
	//
	// This member is required.
	WorkforceName *string

	// The configuration of an Amazon Cognito workforce. A single Cognito workforce is
	// created using and corresponds to a single [Amazon Cognito user pool].
	//
	// [Amazon Cognito user pool]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html
	CognitoConfig *CognitoConfig

	// The date that the workforce is created.
	CreateDate *time.Time

	// The reason your workforce failed.
	FailureReason *string

	// The most recent date that [UpdateWorkforce] was used to successfully add one or more IP address
	// ranges ([CIDRs] ) to a private workforce's allow list.
	//
	// [UpdateWorkforce]: https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateWorkforce.html
	// [CIDRs]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
	LastUpdatedDate *time.Time

	// The configuration of an OIDC Identity Provider (IdP) private workforce.
	OidcConfig *OidcConfigForResponse

	// A list of one to ten IP address ranges ([CIDRs] ) to be added to the workforce allow
	// list. By default, a workforce isn't restricted to specific IP addresses.
	//
	// [CIDRs]: https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
	SourceIpConfig *SourceIpConfig

	// The status of your workforce.
	Status WorkforceStatus

	// The subdomain for your OIDC Identity Provider.
	SubDomain *string

	// The configuration of a VPC workforce.
	WorkforceVpcConfig *WorkforceVpcConfigResponse

	noSmithyDocumentSerde
}

// The VPC object you use to create or update a workforce.
type WorkforceVpcConfigRequest struct {

	// The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must
	// be for the same VPC as specified in the subnet.
	SecurityGroupIds []string

	// The ID of the subnets in the VPC that you want to connect.
	Subnets []string

	// The ID of the VPC that the workforce uses for communication.
	VpcId *string

	noSmithyDocumentSerde
}

// A VpcConfig object that specifies the VPC that you want your workforce to
// connect to.
type WorkforceVpcConfigResponse struct {

	// The VPC security group IDs, in the form sg-xxxxxxxx. The security groups must
	// be for the same VPC as specified in the subnet.
	//
	// This member is required.
	SecurityGroupIds []string

	// The ID of the subnets in the VPC that you want to connect.
	//
	// This member is required.
	Subnets []string

	// The ID of the VPC that the workforce uses for communication.
	//
	// This member is required.
	VpcId *string

	// The IDs for the VPC service endpoints of your VPC workforce when it is created
	// and updated.
	VpcEndpointId *string

	noSmithyDocumentSerde
}

// The workspace settings for the SageMaker Canvas application.
type WorkspaceSettings struct {

	// The Amazon S3 bucket used to store artifacts generated by Canvas. Updating the
	// Amazon S3 location impacts existing configuration settings, and Canvas users no
	// longer have access to their artifacts. Canvas users must log out and log back in
	// to apply the new location.
	S3ArtifactPath *string

	// The Amazon Web Services Key Management Service (KMS) encryption key ID that is
	// used to encrypt artifacts generated by Canvas in the Amazon S3 bucket.
	S3KmsKeyId *string

	noSmithyDocumentSerde
}

// Provides details about a labeling work team.
type Workteam struct {

	// A description of the work team.
	//
	// This member is required.
	Description *string

	// A list of MemberDefinition objects that contains objects that identify the
	// workers that make up the work team.
	//
	// Workforces can be created using Amazon Cognito or your own OIDC Identity
	// Provider (IdP). For private workforces created using Amazon Cognito use
	// CognitoMemberDefinition . For workforces created using your own OIDC identity
	// provider (IdP) use OidcMemberDefinition .
	//
	// This member is required.
	MemberDefinitions []MemberDefinition

	// The Amazon Resource Name (ARN) that identifies the work team.
	//
	// This member is required.
	WorkteamArn *string

	// The name of the work team.
	//
	// This member is required.
	WorkteamName *string

	// The date and time that the work team was created (timestamp).
	CreateDate *time.Time

	// The date and time that the work team was last updated (timestamp).
	LastUpdatedDate *time.Time

	// Configures SNS notifications of available or expiring work items for work teams.
	NotificationConfiguration *NotificationConfiguration

	// The Amazon Marketplace identifier for a vendor's work team.
	ProductListingIds []string

	// The URI of the labeling job's user interface. Workers open this URI to start
	// labeling your data objects.
	SubDomain *string

	// Describes any access constraints that have been defined for Amazon S3 resources.
	WorkerAccessConfiguration *WorkerAccessConfiguration

	// The Amazon Resource Name (ARN) of the workforce.
	WorkforceArn *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAutoMLProblemTypeConfig()             {}
func (*UnknownUnionMember) isAutoMLProblemTypeResolvedAttributes() {}
func (*UnknownUnionMember) isCollectionConfig()                    {}
func (*UnknownUnionMember) isCustomFileSystem()                    {}
func (*UnknownUnionMember) isCustomFileSystemConfig()              {}
func (*UnknownUnionMember) isMetricSpecification()                 {}
func (*UnknownUnionMember) isScalingPolicy()                       {}
func (*UnknownUnionMember) isTrialComponentParameterValue()        {}
