// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudtrail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudtrail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a trail that specifies the settings for delivery of log data to an
// Amazon S3 bucket.
func (c *Client) CreateTrail(ctx context.Context, params *CreateTrailInput, optFns ...func(*Options)) (*CreateTrailOutput, error) {
	if params == nil {
		params = &CreateTrailInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateTrail", params, optFns, c.addOperationCreateTrailMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateTrailOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Specifies the settings for each trail.
type CreateTrailInput struct {

	// Specifies the name of the trail. The name must meet the following requirements:
	//
	//   - Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
	//   underscores (_), or dashes (-)
	//
	//   - Start with a letter or number, and end with a letter or number
	//
	//   - Be between 3 and 128 characters
	//
	//   - Have no adjacent periods, underscores or dashes. Names like my-_namespace
	//   and my--namespace are not valid.
	//
	//   - Not be in IP address format (for example, 192.168.5.4)
	//
	// This member is required.
	Name *string

	// Specifies the name of the Amazon S3 bucket designated for publishing log files.
	// See [Amazon S3 Bucket Naming Requirements].
	//
	// [Amazon S3 Bucket Naming Requirements]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html
	//
	// This member is required.
	S3BucketName *string

	// Specifies a log group name using an Amazon Resource Name (ARN), a unique
	// identifier that represents the log group to which CloudTrail logs will be
	// delivered. You must use a log group that exists in your account.
	//
	// Not required unless you specify CloudWatchLogsRoleArn .
	CloudWatchLogsLogGroupArn *string

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to a
	// user's log group. You must use a role that exists in your account.
	CloudWatchLogsRoleArn *string

	// Specifies whether log file integrity validation is enabled. The default is
	// false.
	//
	// When you disable log file integrity validation, the chain of digest files is
	// broken after one hour. CloudTrail does not create digest files for log files
	// that were delivered during a period in which log file integrity validation was
	// disabled. For example, if you enable log file integrity validation at noon on
	// January 1, disable it at noon on January 2, and re-enable it at noon on January
	// 10, digest files will not be created for the log files delivered from noon on
	// January 2 to noon on January 10. The same applies whenever you stop CloudTrail
	// logging or delete a trail.
	EnableLogFileValidation *bool

	// Specifies whether the trail is publishing events from global services such as
	// IAM to the log files.
	IncludeGlobalServiceEvents *bool

	// Specifies whether the trail is created in the current Region or in all Regions.
	// The default is false, which creates a trail only in the Region where you are
	// signed in. As a best practice, consider creating trails that log events in all
	// Regions.
	IsMultiRegionTrail *bool

	// Specifies whether the trail is created for all accounts in an organization in
	// Organizations, or only for the current Amazon Web Services account. The default
	// is false, and cannot be true unless the call is made on behalf of an Amazon Web
	// Services account that is the management account or delegated administrator
	// account for an organization in Organizations.
	IsOrganizationTrail *bool

	// Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail.
	// The value can be an alias name prefixed by alias/ , a fully specified ARN to an
	// alias, a fully specified ARN to a key, or a globally unique identifier.
	//
	// CloudTrail also supports KMS multi-Region keys. For more information about
	// multi-Region keys, see [Using multi-Region keys]in the Key Management Service Developer Guide.
	//
	// Examples:
	//
	//   - alias/MyAliasName
	//
	//   - arn:aws:kms:us-east-2:123456789012:alias/MyAliasName
	//
	//   - arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//   - 12345678-1234-1234-1234-123456789012
	//
	// [Using multi-Region keys]: https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html
	KmsKeyId *string

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket you
	// have designated for log file delivery. For more information, see [Finding Your CloudTrail Log Files]. The maximum
	// length is 200 characters.
	//
	// [Finding Your CloudTrail Log Files]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html
	S3KeyPrefix *string

	// Specifies the name of the Amazon SNS topic defined for notification of log file
	// delivery. The maximum length is 256 characters.
	SnsTopicName *string

	// A list of tags.
	TagsList []types.Tag

	noSmithyDocumentSerde
}

// Returns the objects or data listed below if successful. Otherwise, returns an
// error.
type CreateTrailOutput struct {

	// Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail
	// logs will be delivered.
	CloudWatchLogsLogGroupArn *string

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to a
	// user's log group.
	CloudWatchLogsRoleArn *string

	// Specifies whether the trail is publishing events from global services such as
	// IAM to the log files.
	IncludeGlobalServiceEvents *bool

	// Specifies whether the trail exists in one Region or in all Regions.
	IsMultiRegionTrail *bool

	// Specifies whether the trail is an organization trail.
	IsOrganizationTrail *bool

	// Specifies the KMS key ID that encrypts the events delivered by CloudTrail. The
	// value is a fully specified ARN to a KMS key in the following format.
	//
	//     arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012
	KmsKeyId *string

	// Specifies whether log file integrity validation is enabled.
	LogFileValidationEnabled *bool

	// Specifies the name of the trail.
	Name *string

	// Specifies the name of the Amazon S3 bucket designated for publishing log files.
	S3BucketName *string

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket you
	// have designated for log file delivery. For more information, see [Finding Your CloudTrail Log Files].
	//
	// [Finding Your CloudTrail Log Files]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html
	S3KeyPrefix *string

	// Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send
	// notifications when log files are delivered. The format of a topic ARN is:
	//
	//     arn:aws:sns:us-east-2:123456789012:MyTopic
	SnsTopicARN *string

	// This field is no longer in use. Use SnsTopicARN .
	//
	// Deprecated: This member has been deprecated.
	SnsTopicName *string

	// Specifies the ARN of the trail that was created. The format of a trail ARN is:
	//
	//     arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
	TrailARN *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateTrailMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateTrail{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateTrail{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateTrail"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateTrailValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateTrail(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateTrail(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateTrail",
	}
}
