// Code generated by smithy-go-codegen DO NOT EDIT.

package appsync

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/appsync/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpAssociateApi struct {
}

func (*awsRestjson1_serializeOpAssociateApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/domainnames/{domainName}/apiassociation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateApiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateApiInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateApiInput(v *AssociateApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member domainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("domainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateApiInput(v *AssociateApiInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApiId != nil {
		ok := object.Key("apiId")
		ok.String(*v.ApiId)
	}

	return nil
}

type awsRestjson1_serializeOpAssociateMergedGraphqlApi struct {
}

func (*awsRestjson1_serializeOpAssociateMergedGraphqlApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateMergedGraphqlApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateMergedGraphqlApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/sourceApis/{sourceApiIdentifier}/mergedApiAssociations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateMergedGraphqlApiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateMergedGraphqlApiInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateMergedGraphqlApiInput(v *AssociateMergedGraphqlApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SourceApiIdentifier == nil || len(*v.SourceApiIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sourceApiIdentifier must not be empty")}
	}
	if v.SourceApiIdentifier != nil {
		if err := encoder.SetURI("sourceApiIdentifier").String(*v.SourceApiIdentifier); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateMergedGraphqlApiInput(v *AssociateMergedGraphqlApiInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.MergedApiIdentifier != nil {
		ok := object.Key("mergedApiIdentifier")
		ok.String(*v.MergedApiIdentifier)
	}

	if v.SourceApiAssociationConfig != nil {
		ok := object.Key("sourceApiAssociationConfig")
		if err := awsRestjson1_serializeDocumentSourceApiAssociationConfig(v.SourceApiAssociationConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpAssociateSourceGraphqlApi struct {
}

func (*awsRestjson1_serializeOpAssociateSourceGraphqlApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateSourceGraphqlApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateSourceGraphqlApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/mergedApis/{mergedApiIdentifier}/sourceApiAssociations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAssociateSourceGraphqlApiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateSourceGraphqlApiInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateSourceGraphqlApiInput(v *AssociateSourceGraphqlApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MergedApiIdentifier == nil || len(*v.MergedApiIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member mergedApiIdentifier must not be empty")}
	}
	if v.MergedApiIdentifier != nil {
		if err := encoder.SetURI("mergedApiIdentifier").String(*v.MergedApiIdentifier); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateSourceGraphqlApiInput(v *AssociateSourceGraphqlApiInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.SourceApiAssociationConfig != nil {
		ok := object.Key("sourceApiAssociationConfig")
		if err := awsRestjson1_serializeDocumentSourceApiAssociationConfig(v.SourceApiAssociationConfig, ok); err != nil {
			return err
		}
	}

	if v.SourceApiIdentifier != nil {
		ok := object.Key("sourceApiIdentifier")
		ok.String(*v.SourceApiIdentifier)
	}

	return nil
}

type awsRestjson1_serializeOpCreateApiCache struct {
}

func (*awsRestjson1_serializeOpCreateApiCache) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateApiCache) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateApiCacheInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/ApiCaches")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateApiCacheInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateApiCacheInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateApiCacheInput(v *CreateApiCacheInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateApiCacheInput(v *CreateApiCacheInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ApiCachingBehavior) > 0 {
		ok := object.Key("apiCachingBehavior")
		ok.String(string(v.ApiCachingBehavior))
	}

	if v.AtRestEncryptionEnabled {
		ok := object.Key("atRestEncryptionEnabled")
		ok.Boolean(v.AtRestEncryptionEnabled)
	}

	if len(v.HealthMetricsConfig) > 0 {
		ok := object.Key("healthMetricsConfig")
		ok.String(string(v.HealthMetricsConfig))
	}

	if v.TransitEncryptionEnabled {
		ok := object.Key("transitEncryptionEnabled")
		ok.Boolean(v.TransitEncryptionEnabled)
	}

	{
		ok := object.Key("ttl")
		ok.Long(v.Ttl)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpCreateApiKey struct {
}

func (*awsRestjson1_serializeOpCreateApiKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateApiKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateApiKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/apikeys")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateApiKeyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateApiKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateApiKeyInput(v *CreateApiKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateApiKeyInput(v *CreateApiKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Expires != 0 {
		ok := object.Key("expires")
		ok.Long(v.Expires)
	}

	return nil
}

type awsRestjson1_serializeOpCreateDataSource struct {
}

func (*awsRestjson1_serializeOpCreateDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/datasources")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDataSourceInput(v *CreateDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDataSourceInput(v *CreateDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DynamodbConfig != nil {
		ok := object.Key("dynamodbConfig")
		if err := awsRestjson1_serializeDocumentDynamodbDataSourceConfig(v.DynamodbConfig, ok); err != nil {
			return err
		}
	}

	if v.ElasticsearchConfig != nil {
		ok := object.Key("elasticsearchConfig")
		if err := awsRestjson1_serializeDocumentElasticsearchDataSourceConfig(v.ElasticsearchConfig, ok); err != nil {
			return err
		}
	}

	if v.EventBridgeConfig != nil {
		ok := object.Key("eventBridgeConfig")
		if err := awsRestjson1_serializeDocumentEventBridgeDataSourceConfig(v.EventBridgeConfig, ok); err != nil {
			return err
		}
	}

	if v.HttpConfig != nil {
		ok := object.Key("httpConfig")
		if err := awsRestjson1_serializeDocumentHttpDataSourceConfig(v.HttpConfig, ok); err != nil {
			return err
		}
	}

	if v.LambdaConfig != nil {
		ok := object.Key("lambdaConfig")
		if err := awsRestjson1_serializeDocumentLambdaDataSourceConfig(v.LambdaConfig, ok); err != nil {
			return err
		}
	}

	if len(v.MetricsConfig) > 0 {
		ok := object.Key("metricsConfig")
		ok.String(string(v.MetricsConfig))
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.OpenSearchServiceConfig != nil {
		ok := object.Key("openSearchServiceConfig")
		if err := awsRestjson1_serializeDocumentOpenSearchServiceDataSourceConfig(v.OpenSearchServiceConfig, ok); err != nil {
			return err
		}
	}

	if v.RelationalDatabaseConfig != nil {
		ok := object.Key("relationalDatabaseConfig")
		if err := awsRestjson1_serializeDocumentRelationalDatabaseDataSourceConfig(v.RelationalDatabaseConfig, ok); err != nil {
			return err
		}
	}

	if v.ServiceRoleArn != nil {
		ok := object.Key("serviceRoleArn")
		ok.String(*v.ServiceRoleArn)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpCreateDomainName struct {
}

func (*awsRestjson1_serializeOpCreateDomainName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDomainName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDomainNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/domainnames")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDomainNameInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDomainNameInput(v *CreateDomainNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDomainNameInput(v *CreateDomainNameInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateArn != nil {
		ok := object.Key("certificateArn")
		ok.String(*v.CertificateArn)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DomainName != nil {
		ok := object.Key("domainName")
		ok.String(*v.DomainName)
	}

	return nil
}

type awsRestjson1_serializeOpCreateFunction struct {
}

func (*awsRestjson1_serializeOpCreateFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/functions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateFunctionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateFunctionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateFunctionInput(v *CreateFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateFunctionInput(v *CreateFunctionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Code != nil {
		ok := object.Key("code")
		ok.String(*v.Code)
	}

	if v.DataSourceName != nil {
		ok := object.Key("dataSourceName")
		ok.String(*v.DataSourceName)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.FunctionVersion != nil {
		ok := object.Key("functionVersion")
		ok.String(*v.FunctionVersion)
	}

	if v.MaxBatchSize != 0 {
		ok := object.Key("maxBatchSize")
		ok.Integer(v.MaxBatchSize)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RequestMappingTemplate != nil {
		ok := object.Key("requestMappingTemplate")
		ok.String(*v.RequestMappingTemplate)
	}

	if v.ResponseMappingTemplate != nil {
		ok := object.Key("responseMappingTemplate")
		ok.String(*v.ResponseMappingTemplate)
	}

	if v.Runtime != nil {
		ok := object.Key("runtime")
		if err := awsRestjson1_serializeDocumentAppSyncRuntime(v.Runtime, ok); err != nil {
			return err
		}
	}

	if v.SyncConfig != nil {
		ok := object.Key("syncConfig")
		if err := awsRestjson1_serializeDocumentSyncConfig(v.SyncConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateGraphqlApi struct {
}

func (*awsRestjson1_serializeOpCreateGraphqlApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateGraphqlApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateGraphqlApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateGraphqlApiInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateGraphqlApiInput(v *CreateGraphqlApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateGraphqlApiInput(v *CreateGraphqlApiInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalAuthenticationProviders != nil {
		ok := object.Key("additionalAuthenticationProviders")
		if err := awsRestjson1_serializeDocumentAdditionalAuthenticationProviders(v.AdditionalAuthenticationProviders, ok); err != nil {
			return err
		}
	}

	if len(v.ApiType) > 0 {
		ok := object.Key("apiType")
		ok.String(string(v.ApiType))
	}

	if len(v.AuthenticationType) > 0 {
		ok := object.Key("authenticationType")
		ok.String(string(v.AuthenticationType))
	}

	if v.EnhancedMetricsConfig != nil {
		ok := object.Key("enhancedMetricsConfig")
		if err := awsRestjson1_serializeDocumentEnhancedMetricsConfig(v.EnhancedMetricsConfig, ok); err != nil {
			return err
		}
	}

	if len(v.IntrospectionConfig) > 0 {
		ok := object.Key("introspectionConfig")
		ok.String(string(v.IntrospectionConfig))
	}

	if v.LambdaAuthorizerConfig != nil {
		ok := object.Key("lambdaAuthorizerConfig")
		if err := awsRestjson1_serializeDocumentLambdaAuthorizerConfig(v.LambdaAuthorizerConfig, ok); err != nil {
			return err
		}
	}

	if v.LogConfig != nil {
		ok := object.Key("logConfig")
		if err := awsRestjson1_serializeDocumentLogConfig(v.LogConfig, ok); err != nil {
			return err
		}
	}

	if v.MergedApiExecutionRoleArn != nil {
		ok := object.Key("mergedApiExecutionRoleArn")
		ok.String(*v.MergedApiExecutionRoleArn)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.OpenIDConnectConfig != nil {
		ok := object.Key("openIDConnectConfig")
		if err := awsRestjson1_serializeDocumentOpenIDConnectConfig(v.OpenIDConnectConfig, ok); err != nil {
			return err
		}
	}

	if v.OwnerContact != nil {
		ok := object.Key("ownerContact")
		ok.String(*v.OwnerContact)
	}

	if v.QueryDepthLimit != 0 {
		ok := object.Key("queryDepthLimit")
		ok.Integer(v.QueryDepthLimit)
	}

	if v.ResolverCountLimit != 0 {
		ok := object.Key("resolverCountLimit")
		ok.Integer(v.ResolverCountLimit)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.UserPoolConfig != nil {
		ok := object.Key("userPoolConfig")
		if err := awsRestjson1_serializeDocumentUserPoolConfig(v.UserPoolConfig, ok); err != nil {
			return err
		}
	}

	if len(v.Visibility) > 0 {
		ok := object.Key("visibility")
		ok.String(string(v.Visibility))
	}

	if v.XrayEnabled {
		ok := object.Key("xrayEnabled")
		ok.Boolean(v.XrayEnabled)
	}

	return nil
}

type awsRestjson1_serializeOpCreateResolver struct {
}

func (*awsRestjson1_serializeOpCreateResolver) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateResolver) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateResolverInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/types/{typeName}/resolvers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateResolverInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateResolverInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateResolverInput(v *CreateResolverInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.TypeName == nil || len(*v.TypeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member typeName must not be empty")}
	}
	if v.TypeName != nil {
		if err := encoder.SetURI("typeName").String(*v.TypeName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateResolverInput(v *CreateResolverInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CachingConfig != nil {
		ok := object.Key("cachingConfig")
		if err := awsRestjson1_serializeDocumentCachingConfig(v.CachingConfig, ok); err != nil {
			return err
		}
	}

	if v.Code != nil {
		ok := object.Key("code")
		ok.String(*v.Code)
	}

	if v.DataSourceName != nil {
		ok := object.Key("dataSourceName")
		ok.String(*v.DataSourceName)
	}

	if v.FieldName != nil {
		ok := object.Key("fieldName")
		ok.String(*v.FieldName)
	}

	if len(v.Kind) > 0 {
		ok := object.Key("kind")
		ok.String(string(v.Kind))
	}

	if v.MaxBatchSize != 0 {
		ok := object.Key("maxBatchSize")
		ok.Integer(v.MaxBatchSize)
	}

	if len(v.MetricsConfig) > 0 {
		ok := object.Key("metricsConfig")
		ok.String(string(v.MetricsConfig))
	}

	if v.PipelineConfig != nil {
		ok := object.Key("pipelineConfig")
		if err := awsRestjson1_serializeDocumentPipelineConfig(v.PipelineConfig, ok); err != nil {
			return err
		}
	}

	if v.RequestMappingTemplate != nil {
		ok := object.Key("requestMappingTemplate")
		ok.String(*v.RequestMappingTemplate)
	}

	if v.ResponseMappingTemplate != nil {
		ok := object.Key("responseMappingTemplate")
		ok.String(*v.ResponseMappingTemplate)
	}

	if v.Runtime != nil {
		ok := object.Key("runtime")
		if err := awsRestjson1_serializeDocumentAppSyncRuntime(v.Runtime, ok); err != nil {
			return err
		}
	}

	if v.SyncConfig != nil {
		ok := object.Key("syncConfig")
		if err := awsRestjson1_serializeDocumentSyncConfig(v.SyncConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateType struct {
}

func (*awsRestjson1_serializeOpCreateType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/types")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTypeInput(v *CreateTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateTypeInput(v *CreateTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definition != nil {
		ok := object.Key("definition")
		ok.String(*v.Definition)
	}

	if len(v.Format) > 0 {
		ok := object.Key("format")
		ok.String(string(v.Format))
	}

	return nil
}

type awsRestjson1_serializeOpDeleteApiCache struct {
}

func (*awsRestjson1_serializeOpDeleteApiCache) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteApiCache) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApiCacheInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/ApiCaches")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteApiCacheInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteApiCacheInput(v *DeleteApiCacheInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteApiKey struct {
}

func (*awsRestjson1_serializeOpDeleteApiKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteApiKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApiKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/apikeys/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteApiKeyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteApiKeyInput(v *DeleteApiKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDataSource struct {
}

func (*awsRestjson1_serializeOpDeleteDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/datasources/{name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDataSourceInput(v *DeleteDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDomainName struct {
}

func (*awsRestjson1_serializeOpDeleteDomainName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDomainName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDomainNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/domainnames/{domainName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDomainNameInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDomainNameInput(v *DeleteDomainNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member domainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("domainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteFunction struct {
}

func (*awsRestjson1_serializeOpDeleteFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/functions/{functionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteFunctionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteFunctionInput(v *DeleteFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.FunctionId == nil || len(*v.FunctionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member functionId must not be empty")}
	}
	if v.FunctionId != nil {
		if err := encoder.SetURI("functionId").String(*v.FunctionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteGraphqlApi struct {
}

func (*awsRestjson1_serializeOpDeleteGraphqlApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteGraphqlApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGraphqlApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteGraphqlApiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteGraphqlApiInput(v *DeleteGraphqlApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteResolver struct {
}

func (*awsRestjson1_serializeOpDeleteResolver) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteResolver) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteResolverInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/types/{typeName}/resolvers/{fieldName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteResolverInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteResolverInput(v *DeleteResolverInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.FieldName == nil || len(*v.FieldName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fieldName must not be empty")}
	}
	if v.FieldName != nil {
		if err := encoder.SetURI("fieldName").String(*v.FieldName); err != nil {
			return err
		}
	}

	if v.TypeName == nil || len(*v.TypeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member typeName must not be empty")}
	}
	if v.TypeName != nil {
		if err := encoder.SetURI("typeName").String(*v.TypeName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteType struct {
}

func (*awsRestjson1_serializeOpDeleteType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/types/{typeName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTypeInput(v *DeleteTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.TypeName == nil || len(*v.TypeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member typeName must not be empty")}
	}
	if v.TypeName != nil {
		if err := encoder.SetURI("typeName").String(*v.TypeName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateApi struct {
}

func (*awsRestjson1_serializeOpDisassociateApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/domainnames/{domainName}/apiassociation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateApiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateApiInput(v *DisassociateApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member domainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("domainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateMergedGraphqlApi struct {
}

func (*awsRestjson1_serializeOpDisassociateMergedGraphqlApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateMergedGraphqlApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateMergedGraphqlApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/sourceApis/{sourceApiIdentifier}/mergedApiAssociations/{associationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateMergedGraphqlApiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateMergedGraphqlApiInput(v *DisassociateMergedGraphqlApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssociationId == nil || len(*v.AssociationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member associationId must not be empty")}
	}
	if v.AssociationId != nil {
		if err := encoder.SetURI("associationId").String(*v.AssociationId); err != nil {
			return err
		}
	}

	if v.SourceApiIdentifier == nil || len(*v.SourceApiIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sourceApiIdentifier must not be empty")}
	}
	if v.SourceApiIdentifier != nil {
		if err := encoder.SetURI("sourceApiIdentifier").String(*v.SourceApiIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateSourceGraphqlApi struct {
}

func (*awsRestjson1_serializeOpDisassociateSourceGraphqlApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateSourceGraphqlApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateSourceGraphqlApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/mergedApis/{mergedApiIdentifier}/sourceApiAssociations/{associationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateSourceGraphqlApiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateSourceGraphqlApiInput(v *DisassociateSourceGraphqlApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssociationId == nil || len(*v.AssociationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member associationId must not be empty")}
	}
	if v.AssociationId != nil {
		if err := encoder.SetURI("associationId").String(*v.AssociationId); err != nil {
			return err
		}
	}

	if v.MergedApiIdentifier == nil || len(*v.MergedApiIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member mergedApiIdentifier must not be empty")}
	}
	if v.MergedApiIdentifier != nil {
		if err := encoder.SetURI("mergedApiIdentifier").String(*v.MergedApiIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpEvaluateCode struct {
}

func (*awsRestjson1_serializeOpEvaluateCode) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpEvaluateCode) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EvaluateCodeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/dataplane-evaluatecode")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentEvaluateCodeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsEvaluateCodeInput(v *EvaluateCodeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentEvaluateCodeInput(v *EvaluateCodeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Code != nil {
		ok := object.Key("code")
		ok.String(*v.Code)
	}

	if v.Context != nil {
		ok := object.Key("context")
		ok.String(*v.Context)
	}

	if v.Function != nil {
		ok := object.Key("function")
		ok.String(*v.Function)
	}

	if v.Runtime != nil {
		ok := object.Key("runtime")
		if err := awsRestjson1_serializeDocumentAppSyncRuntime(v.Runtime, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpEvaluateMappingTemplate struct {
}

func (*awsRestjson1_serializeOpEvaluateMappingTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpEvaluateMappingTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EvaluateMappingTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/dataplane-evaluatetemplate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentEvaluateMappingTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsEvaluateMappingTemplateInput(v *EvaluateMappingTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentEvaluateMappingTemplateInput(v *EvaluateMappingTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Context != nil {
		ok := object.Key("context")
		ok.String(*v.Context)
	}

	if v.Template != nil {
		ok := object.Key("template")
		ok.String(*v.Template)
	}

	return nil
}

type awsRestjson1_serializeOpFlushApiCache struct {
}

func (*awsRestjson1_serializeOpFlushApiCache) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpFlushApiCache) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*FlushApiCacheInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/FlushCache")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsFlushApiCacheInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsFlushApiCacheInput(v *FlushApiCacheInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetApiAssociation struct {
}

func (*awsRestjson1_serializeOpGetApiAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApiAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApiAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/domainnames/{domainName}/apiassociation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApiAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApiAssociationInput(v *GetApiAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member domainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("domainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetApiCache struct {
}

func (*awsRestjson1_serializeOpGetApiCache) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApiCache) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApiCacheInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/ApiCaches")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApiCacheInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApiCacheInput(v *GetApiCacheInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDataSource struct {
}

func (*awsRestjson1_serializeOpGetDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/datasources/{name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDataSourceInput(v *GetDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDataSourceIntrospection struct {
}

func (*awsRestjson1_serializeOpGetDataSourceIntrospection) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDataSourceIntrospection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDataSourceIntrospectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/datasources/introspections/{introspectionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDataSourceIntrospectionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDataSourceIntrospectionInput(v *GetDataSourceIntrospectionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IncludeModelsSDL {
		encoder.SetQuery("includeModelsSDL").Boolean(v.IncludeModelsSDL)
	}

	if v.IntrospectionId == nil || len(*v.IntrospectionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member introspectionId must not be empty")}
	}
	if v.IntrospectionId != nil {
		if err := encoder.SetURI("introspectionId").String(*v.IntrospectionId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetDomainName struct {
}

func (*awsRestjson1_serializeOpGetDomainName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDomainName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDomainNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/domainnames/{domainName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDomainNameInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDomainNameInput(v *GetDomainNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member domainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("domainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetFunction struct {
}

func (*awsRestjson1_serializeOpGetFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/functions/{functionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetFunctionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetFunctionInput(v *GetFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.FunctionId == nil || len(*v.FunctionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member functionId must not be empty")}
	}
	if v.FunctionId != nil {
		if err := encoder.SetURI("functionId").String(*v.FunctionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetGraphqlApi struct {
}

func (*awsRestjson1_serializeOpGetGraphqlApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetGraphqlApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetGraphqlApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetGraphqlApiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetGraphqlApiInput(v *GetGraphqlApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetGraphqlApiEnvironmentVariables struct {
}

func (*awsRestjson1_serializeOpGetGraphqlApiEnvironmentVariables) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetGraphqlApiEnvironmentVariables) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetGraphqlApiEnvironmentVariablesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/environmentVariables")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetGraphqlApiEnvironmentVariablesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetGraphqlApiEnvironmentVariablesInput(v *GetGraphqlApiEnvironmentVariablesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetIntrospectionSchema struct {
}

func (*awsRestjson1_serializeOpGetIntrospectionSchema) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetIntrospectionSchema) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIntrospectionSchemaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/schema")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetIntrospectionSchemaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetIntrospectionSchemaInput(v *GetIntrospectionSchemaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if len(v.Format) > 0 {
		encoder.SetQuery("format").String(string(v.Format))
	}

	if v.IncludeDirectives != nil {
		encoder.SetQuery("includeDirectives").Boolean(*v.IncludeDirectives)
	}

	return nil
}

type awsRestjson1_serializeOpGetResolver struct {
}

func (*awsRestjson1_serializeOpGetResolver) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetResolver) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetResolverInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/types/{typeName}/resolvers/{fieldName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetResolverInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetResolverInput(v *GetResolverInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.FieldName == nil || len(*v.FieldName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fieldName must not be empty")}
	}
	if v.FieldName != nil {
		if err := encoder.SetURI("fieldName").String(*v.FieldName); err != nil {
			return err
		}
	}

	if v.TypeName == nil || len(*v.TypeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member typeName must not be empty")}
	}
	if v.TypeName != nil {
		if err := encoder.SetURI("typeName").String(*v.TypeName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetSchemaCreationStatus struct {
}

func (*awsRestjson1_serializeOpGetSchemaCreationStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSchemaCreationStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSchemaCreationStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/schemacreation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSchemaCreationStatusInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSchemaCreationStatusInput(v *GetSchemaCreationStatusInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetSourceApiAssociation struct {
}

func (*awsRestjson1_serializeOpGetSourceApiAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetSourceApiAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSourceApiAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/mergedApis/{mergedApiIdentifier}/sourceApiAssociations/{associationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSourceApiAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSourceApiAssociationInput(v *GetSourceApiAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssociationId == nil || len(*v.AssociationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member associationId must not be empty")}
	}
	if v.AssociationId != nil {
		if err := encoder.SetURI("associationId").String(*v.AssociationId); err != nil {
			return err
		}
	}

	if v.MergedApiIdentifier == nil || len(*v.MergedApiIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member mergedApiIdentifier must not be empty")}
	}
	if v.MergedApiIdentifier != nil {
		if err := encoder.SetURI("mergedApiIdentifier").String(*v.MergedApiIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetType struct {
}

func (*awsRestjson1_serializeOpGetType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/types/{typeName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTypeInput(v *GetTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if len(v.Format) > 0 {
		encoder.SetQuery("format").String(string(v.Format))
	}

	if v.TypeName == nil || len(*v.TypeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member typeName must not be empty")}
	}
	if v.TypeName != nil {
		if err := encoder.SetURI("typeName").String(*v.TypeName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListApiKeys struct {
}

func (*awsRestjson1_serializeOpListApiKeys) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListApiKeys) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListApiKeysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/apikeys")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListApiKeysInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListApiKeysInput(v *ListApiKeysInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDataSources struct {
}

func (*awsRestjson1_serializeOpListDataSources) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDataSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDataSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/datasources")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDataSourcesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDataSourcesInput(v *ListDataSourcesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDomainNames struct {
}

func (*awsRestjson1_serializeOpListDomainNames) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDomainNames) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDomainNamesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/domainnames")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDomainNamesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDomainNamesInput(v *ListDomainNamesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListFunctions struct {
}

func (*awsRestjson1_serializeOpListFunctions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListFunctions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFunctionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/functions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListFunctionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListFunctionsInput(v *ListFunctionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListGraphqlApis struct {
}

func (*awsRestjson1_serializeOpListGraphqlApis) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGraphqlApis) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGraphqlApisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListGraphqlApisInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGraphqlApisInput(v *ListGraphqlApisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ApiType) > 0 {
		encoder.SetQuery("apiType").String(string(v.ApiType))
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.Owner) > 0 {
		encoder.SetQuery("owner").String(string(v.Owner))
	}

	return nil
}

type awsRestjson1_serializeOpListResolvers struct {
}

func (*awsRestjson1_serializeOpListResolvers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListResolvers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListResolversInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/types/{typeName}/resolvers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListResolversInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListResolversInput(v *ListResolversInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.TypeName == nil || len(*v.TypeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member typeName must not be empty")}
	}
	if v.TypeName != nil {
		if err := encoder.SetURI("typeName").String(*v.TypeName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListResolversByFunction struct {
}

func (*awsRestjson1_serializeOpListResolversByFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListResolversByFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListResolversByFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/functions/{functionId}/resolvers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListResolversByFunctionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListResolversByFunctionInput(v *ListResolversByFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.FunctionId == nil || len(*v.FunctionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member functionId must not be empty")}
	}
	if v.FunctionId != nil {
		if err := encoder.SetURI("functionId").String(*v.FunctionId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListSourceApiAssociations struct {
}

func (*awsRestjson1_serializeOpListSourceApiAssociations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSourceApiAssociations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSourceApiAssociationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/sourceApiAssociations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSourceApiAssociationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSourceApiAssociationsInput(v *ListSourceApiAssociationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTypes struct {
}

func (*awsRestjson1_serializeOpListTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/types")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTypesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTypesInput(v *ListTypesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if len(v.Format) > 0 {
		encoder.SetQuery("format").String(string(v.Format))
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTypesByAssociation struct {
}

func (*awsRestjson1_serializeOpListTypesByAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTypesByAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTypesByAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/mergedApis/{mergedApiIdentifier}/sourceApiAssociations/{associationId}/types")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTypesByAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTypesByAssociationInput(v *ListTypesByAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssociationId == nil || len(*v.AssociationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member associationId must not be empty")}
	}
	if v.AssociationId != nil {
		if err := encoder.SetURI("associationId").String(*v.AssociationId); err != nil {
			return err
		}
	}

	if len(v.Format) > 0 {
		encoder.SetQuery("format").String(string(v.Format))
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.MergedApiIdentifier == nil || len(*v.MergedApiIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member mergedApiIdentifier must not be empty")}
	}
	if v.MergedApiIdentifier != nil {
		if err := encoder.SetURI("mergedApiIdentifier").String(*v.MergedApiIdentifier); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpPutGraphqlApiEnvironmentVariables struct {
}

func (*awsRestjson1_serializeOpPutGraphqlApiEnvironmentVariables) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutGraphqlApiEnvironmentVariables) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutGraphqlApiEnvironmentVariablesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/environmentVariables")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutGraphqlApiEnvironmentVariablesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutGraphqlApiEnvironmentVariablesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutGraphqlApiEnvironmentVariablesInput(v *PutGraphqlApiEnvironmentVariablesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutGraphqlApiEnvironmentVariablesInput(v *PutGraphqlApiEnvironmentVariablesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnvironmentVariables != nil {
		ok := object.Key("environmentVariables")
		if err := awsRestjson1_serializeDocumentEnvironmentVariableMap(v.EnvironmentVariables, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartDataSourceIntrospection struct {
}

func (*awsRestjson1_serializeOpStartDataSourceIntrospection) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartDataSourceIntrospection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartDataSourceIntrospectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/datasources/introspections")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartDataSourceIntrospectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartDataSourceIntrospectionInput(v *StartDataSourceIntrospectionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartDataSourceIntrospectionInput(v *StartDataSourceIntrospectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RdsDataApiConfig != nil {
		ok := object.Key("rdsDataApiConfig")
		if err := awsRestjson1_serializeDocumentRdsDataApiConfig(v.RdsDataApiConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartSchemaCreation struct {
}

func (*awsRestjson1_serializeOpStartSchemaCreation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartSchemaCreation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartSchemaCreationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/schemacreation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartSchemaCreationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartSchemaCreationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartSchemaCreationInput(v *StartSchemaCreationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartSchemaCreationInput(v *StartSchemaCreationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definition != nil {
		ok := object.Key("definition")
		ok.Base64EncodeBytes(v.Definition)
	}

	return nil
}

type awsRestjson1_serializeOpStartSchemaMerge struct {
}

func (*awsRestjson1_serializeOpStartSchemaMerge) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartSchemaMerge) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartSchemaMergeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/mergedApis/{mergedApiIdentifier}/sourceApiAssociations/{associationId}/merge")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartSchemaMergeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartSchemaMergeInput(v *StartSchemaMergeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssociationId == nil || len(*v.AssociationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member associationId must not be empty")}
	}
	if v.AssociationId != nil {
		if err := encoder.SetURI("associationId").String(*v.AssociationId); err != nil {
			return err
		}
	}

	if v.MergedApiIdentifier == nil || len(*v.MergedApiIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member mergedApiIdentifier must not be empty")}
	}
	if v.MergedApiIdentifier != nil {
		if err := encoder.SetURI("mergedApiIdentifier").String(*v.MergedApiIdentifier); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateApiCache struct {
}

func (*awsRestjson1_serializeOpUpdateApiCache) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateApiCache) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateApiCacheInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/ApiCaches/update")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateApiCacheInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateApiCacheInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateApiCacheInput(v *UpdateApiCacheInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateApiCacheInput(v *UpdateApiCacheInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ApiCachingBehavior) > 0 {
		ok := object.Key("apiCachingBehavior")
		ok.String(string(v.ApiCachingBehavior))
	}

	if len(v.HealthMetricsConfig) > 0 {
		ok := object.Key("healthMetricsConfig")
		ok.String(string(v.HealthMetricsConfig))
	}

	{
		ok := object.Key("ttl")
		ok.Long(v.Ttl)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateApiKey struct {
}

func (*awsRestjson1_serializeOpUpdateApiKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateApiKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateApiKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/apikeys/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateApiKeyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateApiKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateApiKeyInput(v *UpdateApiKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateApiKeyInput(v *UpdateApiKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Expires != 0 {
		ok := object.Key("expires")
		ok.Long(v.Expires)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDataSource struct {
}

func (*awsRestjson1_serializeOpUpdateDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/datasources/{name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDataSourceInput(v *UpdateDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDataSourceInput(v *UpdateDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DynamodbConfig != nil {
		ok := object.Key("dynamodbConfig")
		if err := awsRestjson1_serializeDocumentDynamodbDataSourceConfig(v.DynamodbConfig, ok); err != nil {
			return err
		}
	}

	if v.ElasticsearchConfig != nil {
		ok := object.Key("elasticsearchConfig")
		if err := awsRestjson1_serializeDocumentElasticsearchDataSourceConfig(v.ElasticsearchConfig, ok); err != nil {
			return err
		}
	}

	if v.EventBridgeConfig != nil {
		ok := object.Key("eventBridgeConfig")
		if err := awsRestjson1_serializeDocumentEventBridgeDataSourceConfig(v.EventBridgeConfig, ok); err != nil {
			return err
		}
	}

	if v.HttpConfig != nil {
		ok := object.Key("httpConfig")
		if err := awsRestjson1_serializeDocumentHttpDataSourceConfig(v.HttpConfig, ok); err != nil {
			return err
		}
	}

	if v.LambdaConfig != nil {
		ok := object.Key("lambdaConfig")
		if err := awsRestjson1_serializeDocumentLambdaDataSourceConfig(v.LambdaConfig, ok); err != nil {
			return err
		}
	}

	if len(v.MetricsConfig) > 0 {
		ok := object.Key("metricsConfig")
		ok.String(string(v.MetricsConfig))
	}

	if v.OpenSearchServiceConfig != nil {
		ok := object.Key("openSearchServiceConfig")
		if err := awsRestjson1_serializeDocumentOpenSearchServiceDataSourceConfig(v.OpenSearchServiceConfig, ok); err != nil {
			return err
		}
	}

	if v.RelationalDatabaseConfig != nil {
		ok := object.Key("relationalDatabaseConfig")
		if err := awsRestjson1_serializeDocumentRelationalDatabaseDataSourceConfig(v.RelationalDatabaseConfig, ok); err != nil {
			return err
		}
	}

	if v.ServiceRoleArn != nil {
		ok := object.Key("serviceRoleArn")
		ok.String(*v.ServiceRoleArn)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDomainName struct {
}

func (*awsRestjson1_serializeOpUpdateDomainName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDomainName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDomainNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/domainnames/{domainName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDomainNameInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDomainNameInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDomainNameInput(v *UpdateDomainNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member domainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("domainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDomainNameInput(v *UpdateDomainNameInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateFunction struct {
}

func (*awsRestjson1_serializeOpUpdateFunction) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateFunction) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFunctionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/functions/{functionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateFunctionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateFunctionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateFunctionInput(v *UpdateFunctionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.FunctionId == nil || len(*v.FunctionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member functionId must not be empty")}
	}
	if v.FunctionId != nil {
		if err := encoder.SetURI("functionId").String(*v.FunctionId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateFunctionInput(v *UpdateFunctionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Code != nil {
		ok := object.Key("code")
		ok.String(*v.Code)
	}

	if v.DataSourceName != nil {
		ok := object.Key("dataSourceName")
		ok.String(*v.DataSourceName)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.FunctionVersion != nil {
		ok := object.Key("functionVersion")
		ok.String(*v.FunctionVersion)
	}

	if v.MaxBatchSize != 0 {
		ok := object.Key("maxBatchSize")
		ok.Integer(v.MaxBatchSize)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.RequestMappingTemplate != nil {
		ok := object.Key("requestMappingTemplate")
		ok.String(*v.RequestMappingTemplate)
	}

	if v.ResponseMappingTemplate != nil {
		ok := object.Key("responseMappingTemplate")
		ok.String(*v.ResponseMappingTemplate)
	}

	if v.Runtime != nil {
		ok := object.Key("runtime")
		if err := awsRestjson1_serializeDocumentAppSyncRuntime(v.Runtime, ok); err != nil {
			return err
		}
	}

	if v.SyncConfig != nil {
		ok := object.Key("syncConfig")
		if err := awsRestjson1_serializeDocumentSyncConfig(v.SyncConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateGraphqlApi struct {
}

func (*awsRestjson1_serializeOpUpdateGraphqlApi) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateGraphqlApi) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateGraphqlApiInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateGraphqlApiInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateGraphqlApiInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateGraphqlApiInput(v *UpdateGraphqlApiInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateGraphqlApiInput(v *UpdateGraphqlApiInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalAuthenticationProviders != nil {
		ok := object.Key("additionalAuthenticationProviders")
		if err := awsRestjson1_serializeDocumentAdditionalAuthenticationProviders(v.AdditionalAuthenticationProviders, ok); err != nil {
			return err
		}
	}

	if len(v.AuthenticationType) > 0 {
		ok := object.Key("authenticationType")
		ok.String(string(v.AuthenticationType))
	}

	if v.EnhancedMetricsConfig != nil {
		ok := object.Key("enhancedMetricsConfig")
		if err := awsRestjson1_serializeDocumentEnhancedMetricsConfig(v.EnhancedMetricsConfig, ok); err != nil {
			return err
		}
	}

	if len(v.IntrospectionConfig) > 0 {
		ok := object.Key("introspectionConfig")
		ok.String(string(v.IntrospectionConfig))
	}

	if v.LambdaAuthorizerConfig != nil {
		ok := object.Key("lambdaAuthorizerConfig")
		if err := awsRestjson1_serializeDocumentLambdaAuthorizerConfig(v.LambdaAuthorizerConfig, ok); err != nil {
			return err
		}
	}

	if v.LogConfig != nil {
		ok := object.Key("logConfig")
		if err := awsRestjson1_serializeDocumentLogConfig(v.LogConfig, ok); err != nil {
			return err
		}
	}

	if v.MergedApiExecutionRoleArn != nil {
		ok := object.Key("mergedApiExecutionRoleArn")
		ok.String(*v.MergedApiExecutionRoleArn)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.OpenIDConnectConfig != nil {
		ok := object.Key("openIDConnectConfig")
		if err := awsRestjson1_serializeDocumentOpenIDConnectConfig(v.OpenIDConnectConfig, ok); err != nil {
			return err
		}
	}

	if v.OwnerContact != nil {
		ok := object.Key("ownerContact")
		ok.String(*v.OwnerContact)
	}

	if v.QueryDepthLimit != 0 {
		ok := object.Key("queryDepthLimit")
		ok.Integer(v.QueryDepthLimit)
	}

	if v.ResolverCountLimit != 0 {
		ok := object.Key("resolverCountLimit")
		ok.Integer(v.ResolverCountLimit)
	}

	if v.UserPoolConfig != nil {
		ok := object.Key("userPoolConfig")
		if err := awsRestjson1_serializeDocumentUserPoolConfig(v.UserPoolConfig, ok); err != nil {
			return err
		}
	}

	if v.XrayEnabled {
		ok := object.Key("xrayEnabled")
		ok.Boolean(v.XrayEnabled)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateResolver struct {
}

func (*awsRestjson1_serializeOpUpdateResolver) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateResolver) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateResolverInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/types/{typeName}/resolvers/{fieldName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateResolverInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateResolverInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateResolverInput(v *UpdateResolverInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.FieldName == nil || len(*v.FieldName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member fieldName must not be empty")}
	}
	if v.FieldName != nil {
		if err := encoder.SetURI("fieldName").String(*v.FieldName); err != nil {
			return err
		}
	}

	if v.TypeName == nil || len(*v.TypeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member typeName must not be empty")}
	}
	if v.TypeName != nil {
		if err := encoder.SetURI("typeName").String(*v.TypeName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateResolverInput(v *UpdateResolverInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CachingConfig != nil {
		ok := object.Key("cachingConfig")
		if err := awsRestjson1_serializeDocumentCachingConfig(v.CachingConfig, ok); err != nil {
			return err
		}
	}

	if v.Code != nil {
		ok := object.Key("code")
		ok.String(*v.Code)
	}

	if v.DataSourceName != nil {
		ok := object.Key("dataSourceName")
		ok.String(*v.DataSourceName)
	}

	if len(v.Kind) > 0 {
		ok := object.Key("kind")
		ok.String(string(v.Kind))
	}

	if v.MaxBatchSize != 0 {
		ok := object.Key("maxBatchSize")
		ok.Integer(v.MaxBatchSize)
	}

	if len(v.MetricsConfig) > 0 {
		ok := object.Key("metricsConfig")
		ok.String(string(v.MetricsConfig))
	}

	if v.PipelineConfig != nil {
		ok := object.Key("pipelineConfig")
		if err := awsRestjson1_serializeDocumentPipelineConfig(v.PipelineConfig, ok); err != nil {
			return err
		}
	}

	if v.RequestMappingTemplate != nil {
		ok := object.Key("requestMappingTemplate")
		ok.String(*v.RequestMappingTemplate)
	}

	if v.ResponseMappingTemplate != nil {
		ok := object.Key("responseMappingTemplate")
		ok.String(*v.ResponseMappingTemplate)
	}

	if v.Runtime != nil {
		ok := object.Key("runtime")
		if err := awsRestjson1_serializeDocumentAppSyncRuntime(v.Runtime, ok); err != nil {
			return err
		}
	}

	if v.SyncConfig != nil {
		ok := object.Key("syncConfig")
		if err := awsRestjson1_serializeDocumentSyncConfig(v.SyncConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateSourceApiAssociation struct {
}

func (*awsRestjson1_serializeOpUpdateSourceApiAssociation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateSourceApiAssociation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSourceApiAssociationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/mergedApis/{mergedApiIdentifier}/sourceApiAssociations/{associationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateSourceApiAssociationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateSourceApiAssociationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateSourceApiAssociationInput(v *UpdateSourceApiAssociationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AssociationId == nil || len(*v.AssociationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member associationId must not be empty")}
	}
	if v.AssociationId != nil {
		if err := encoder.SetURI("associationId").String(*v.AssociationId); err != nil {
			return err
		}
	}

	if v.MergedApiIdentifier == nil || len(*v.MergedApiIdentifier) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member mergedApiIdentifier must not be empty")}
	}
	if v.MergedApiIdentifier != nil {
		if err := encoder.SetURI("mergedApiIdentifier").String(*v.MergedApiIdentifier); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateSourceApiAssociationInput(v *UpdateSourceApiAssociationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.SourceApiAssociationConfig != nil {
		ok := object.Key("sourceApiAssociationConfig")
		if err := awsRestjson1_serializeDocumentSourceApiAssociationConfig(v.SourceApiAssociationConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateType struct {
}

func (*awsRestjson1_serializeOpUpdateType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/apis/{apiId}/types/{typeName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTypeInput(v *UpdateTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApiId == nil || len(*v.ApiId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member apiId must not be empty")}
	}
	if v.ApiId != nil {
		if err := encoder.SetURI("apiId").String(*v.ApiId); err != nil {
			return err
		}
	}

	if v.TypeName == nil || len(*v.TypeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member typeName must not be empty")}
	}
	if v.TypeName != nil {
		if err := encoder.SetURI("typeName").String(*v.TypeName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTypeInput(v *UpdateTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definition != nil {
		ok := object.Key("definition")
		ok.String(*v.Definition)
	}

	if len(v.Format) > 0 {
		ok := object.Key("format")
		ok.String(string(v.Format))
	}

	return nil
}

func awsRestjson1_serializeDocumentAdditionalAuthenticationProvider(v *types.AdditionalAuthenticationProvider, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AuthenticationType) > 0 {
		ok := object.Key("authenticationType")
		ok.String(string(v.AuthenticationType))
	}

	if v.LambdaAuthorizerConfig != nil {
		ok := object.Key("lambdaAuthorizerConfig")
		if err := awsRestjson1_serializeDocumentLambdaAuthorizerConfig(v.LambdaAuthorizerConfig, ok); err != nil {
			return err
		}
	}

	if v.OpenIDConnectConfig != nil {
		ok := object.Key("openIDConnectConfig")
		if err := awsRestjson1_serializeDocumentOpenIDConnectConfig(v.OpenIDConnectConfig, ok); err != nil {
			return err
		}
	}

	if v.UserPoolConfig != nil {
		ok := object.Key("userPoolConfig")
		if err := awsRestjson1_serializeDocumentCognitoUserPoolConfig(v.UserPoolConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAdditionalAuthenticationProviders(v []types.AdditionalAuthenticationProvider, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAdditionalAuthenticationProvider(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAppSyncRuntime(v *types.AppSyncRuntime, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if v.RuntimeVersion != nil {
		ok := object.Key("runtimeVersion")
		ok.String(*v.RuntimeVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentAuthorizationConfig(v *types.AuthorizationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AuthorizationType) > 0 {
		ok := object.Key("authorizationType")
		ok.String(string(v.AuthorizationType))
	}

	if v.AwsIamConfig != nil {
		ok := object.Key("awsIamConfig")
		if err := awsRestjson1_serializeDocumentAwsIamConfig(v.AwsIamConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAwsIamConfig(v *types.AwsIamConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SigningRegion != nil {
		ok := object.Key("signingRegion")
		ok.String(*v.SigningRegion)
	}

	if v.SigningServiceName != nil {
		ok := object.Key("signingServiceName")
		ok.String(*v.SigningServiceName)
	}

	return nil
}

func awsRestjson1_serializeDocumentCachingConfig(v *types.CachingConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CachingKeys != nil {
		ok := object.Key("cachingKeys")
		if err := awsRestjson1_serializeDocumentCachingKeys(v.CachingKeys, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("ttl")
		ok.Long(v.Ttl)
	}

	return nil
}

func awsRestjson1_serializeDocumentCachingKeys(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentCognitoUserPoolConfig(v *types.CognitoUserPoolConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppIdClientRegex != nil {
		ok := object.Key("appIdClientRegex")
		ok.String(*v.AppIdClientRegex)
	}

	if v.AwsRegion != nil {
		ok := object.Key("awsRegion")
		ok.String(*v.AwsRegion)
	}

	if v.UserPoolId != nil {
		ok := object.Key("userPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}

func awsRestjson1_serializeDocumentDeltaSyncConfig(v *types.DeltaSyncConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BaseTableTTL != 0 {
		ok := object.Key("baseTableTTL")
		ok.Long(v.BaseTableTTL)
	}

	if v.DeltaSyncTableName != nil {
		ok := object.Key("deltaSyncTableName")
		ok.String(*v.DeltaSyncTableName)
	}

	if v.DeltaSyncTableTTL != 0 {
		ok := object.Key("deltaSyncTableTTL")
		ok.Long(v.DeltaSyncTableTTL)
	}

	return nil
}

func awsRestjson1_serializeDocumentDynamodbDataSourceConfig(v *types.DynamodbDataSourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsRegion != nil {
		ok := object.Key("awsRegion")
		ok.String(*v.AwsRegion)
	}

	if v.DeltaSyncConfig != nil {
		ok := object.Key("deltaSyncConfig")
		if err := awsRestjson1_serializeDocumentDeltaSyncConfig(v.DeltaSyncConfig, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("tableName")
		ok.String(*v.TableName)
	}

	if v.UseCallerCredentials {
		ok := object.Key("useCallerCredentials")
		ok.Boolean(v.UseCallerCredentials)
	}

	if v.Versioned {
		ok := object.Key("versioned")
		ok.Boolean(v.Versioned)
	}

	return nil
}

func awsRestjson1_serializeDocumentElasticsearchDataSourceConfig(v *types.ElasticsearchDataSourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsRegion != nil {
		ok := object.Key("awsRegion")
		ok.String(*v.AwsRegion)
	}

	if v.Endpoint != nil {
		ok := object.Key("endpoint")
		ok.String(*v.Endpoint)
	}

	return nil
}

func awsRestjson1_serializeDocumentEnhancedMetricsConfig(v *types.EnhancedMetricsConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DataSourceLevelMetricsBehavior) > 0 {
		ok := object.Key("dataSourceLevelMetricsBehavior")
		ok.String(string(v.DataSourceLevelMetricsBehavior))
	}

	if len(v.OperationLevelMetricsConfig) > 0 {
		ok := object.Key("operationLevelMetricsConfig")
		ok.String(string(v.OperationLevelMetricsConfig))
	}

	if len(v.ResolverLevelMetricsBehavior) > 0 {
		ok := object.Key("resolverLevelMetricsBehavior")
		ok.String(string(v.ResolverLevelMetricsBehavior))
	}

	return nil
}

func awsRestjson1_serializeDocumentEnvironmentVariableMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentEventBridgeDataSourceConfig(v *types.EventBridgeDataSourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventBusArn != nil {
		ok := object.Key("eventBusArn")
		ok.String(*v.EventBusArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentFunctionsIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentHttpDataSourceConfig(v *types.HttpDataSourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizationConfig != nil {
		ok := object.Key("authorizationConfig")
		if err := awsRestjson1_serializeDocumentAuthorizationConfig(v.AuthorizationConfig, ok); err != nil {
			return err
		}
	}

	if v.Endpoint != nil {
		ok := object.Key("endpoint")
		ok.String(*v.Endpoint)
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaAuthorizerConfig(v *types.LambdaAuthorizerConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthorizerResultTtlInSeconds != 0 {
		ok := object.Key("authorizerResultTtlInSeconds")
		ok.Integer(v.AuthorizerResultTtlInSeconds)
	}

	if v.AuthorizerUri != nil {
		ok := object.Key("authorizerUri")
		ok.String(*v.AuthorizerUri)
	}

	if v.IdentityValidationExpression != nil {
		ok := object.Key("identityValidationExpression")
		ok.String(*v.IdentityValidationExpression)
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaConflictHandlerConfig(v *types.LambdaConflictHandlerConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LambdaConflictHandlerArn != nil {
		ok := object.Key("lambdaConflictHandlerArn")
		ok.String(*v.LambdaConflictHandlerArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaDataSourceConfig(v *types.LambdaDataSourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LambdaFunctionArn != nil {
		ok := object.Key("lambdaFunctionArn")
		ok.String(*v.LambdaFunctionArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentLogConfig(v *types.LogConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchLogsRoleArn != nil {
		ok := object.Key("cloudWatchLogsRoleArn")
		ok.String(*v.CloudWatchLogsRoleArn)
	}

	if v.ExcludeVerboseContent {
		ok := object.Key("excludeVerboseContent")
		ok.Boolean(v.ExcludeVerboseContent)
	}

	if len(v.FieldLogLevel) > 0 {
		ok := object.Key("fieldLogLevel")
		ok.String(string(v.FieldLogLevel))
	}

	return nil
}

func awsRestjson1_serializeDocumentOpenIDConnectConfig(v *types.OpenIDConnectConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthTTL != 0 {
		ok := object.Key("authTTL")
		ok.Long(v.AuthTTL)
	}

	if v.ClientId != nil {
		ok := object.Key("clientId")
		ok.String(*v.ClientId)
	}

	if v.IatTTL != 0 {
		ok := object.Key("iatTTL")
		ok.Long(v.IatTTL)
	}

	if v.Issuer != nil {
		ok := object.Key("issuer")
		ok.String(*v.Issuer)
	}

	return nil
}

func awsRestjson1_serializeDocumentOpenSearchServiceDataSourceConfig(v *types.OpenSearchServiceDataSourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsRegion != nil {
		ok := object.Key("awsRegion")
		ok.String(*v.AwsRegion)
	}

	if v.Endpoint != nil {
		ok := object.Key("endpoint")
		ok.String(*v.Endpoint)
	}

	return nil
}

func awsRestjson1_serializeDocumentPipelineConfig(v *types.PipelineConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Functions != nil {
		ok := object.Key("functions")
		if err := awsRestjson1_serializeDocumentFunctionsIds(v.Functions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRdsDataApiConfig(v *types.RdsDataApiConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatabaseName != nil {
		ok := object.Key("databaseName")
		ok.String(*v.DatabaseName)
	}

	if v.ResourceArn != nil {
		ok := object.Key("resourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.SecretArn != nil {
		ok := object.Key("secretArn")
		ok.String(*v.SecretArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentRdsHttpEndpointConfig(v *types.RdsHttpEndpointConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AwsRegion != nil {
		ok := object.Key("awsRegion")
		ok.String(*v.AwsRegion)
	}

	if v.AwsSecretStoreArn != nil {
		ok := object.Key("awsSecretStoreArn")
		ok.String(*v.AwsSecretStoreArn)
	}

	if v.DatabaseName != nil {
		ok := object.Key("databaseName")
		ok.String(*v.DatabaseName)
	}

	if v.DbClusterIdentifier != nil {
		ok := object.Key("dbClusterIdentifier")
		ok.String(*v.DbClusterIdentifier)
	}

	if v.Schema != nil {
		ok := object.Key("schema")
		ok.String(*v.Schema)
	}

	return nil
}

func awsRestjson1_serializeDocumentRelationalDatabaseDataSourceConfig(v *types.RelationalDatabaseDataSourceConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RdsHttpEndpointConfig != nil {
		ok := object.Key("rdsHttpEndpointConfig")
		if err := awsRestjson1_serializeDocumentRdsHttpEndpointConfig(v.RdsHttpEndpointConfig, ok); err != nil {
			return err
		}
	}

	if len(v.RelationalDatabaseSourceType) > 0 {
		ok := object.Key("relationalDatabaseSourceType")
		ok.String(string(v.RelationalDatabaseSourceType))
	}

	return nil
}

func awsRestjson1_serializeDocumentSourceApiAssociationConfig(v *types.SourceApiAssociationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MergeType) > 0 {
		ok := object.Key("mergeType")
		ok.String(string(v.MergeType))
	}

	return nil
}

func awsRestjson1_serializeDocumentSyncConfig(v *types.SyncConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ConflictDetection) > 0 {
		ok := object.Key("conflictDetection")
		ok.String(string(v.ConflictDetection))
	}

	if len(v.ConflictHandler) > 0 {
		ok := object.Key("conflictHandler")
		ok.String(string(v.ConflictHandler))
	}

	if v.LambdaConflictHandlerConfig != nil {
		ok := object.Key("lambdaConflictHandlerConfig")
		if err := awsRestjson1_serializeDocumentLambdaConflictHandlerConfig(v.LambdaConflictHandlerConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentUserPoolConfig(v *types.UserPoolConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppIdClientRegex != nil {
		ok := object.Key("appIdClientRegex")
		ok.String(*v.AppIdClientRegex)
	}

	if v.AwsRegion != nil {
		ok := object.Key("awsRegion")
		ok.String(*v.AwsRegion)
	}

	if len(v.DefaultAction) > 0 {
		ok := object.Key("defaultAction")
		ok.String(string(v.DefaultAction))
	}

	if v.UserPoolId != nil {
		ok := object.Key("userPoolId")
		ok.String(*v.UserPoolId)
	}

	return nil
}
