//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armresourcemover

import "time"

// AffectedMoveResource - The RP custom operation error info.
type AffectedMoveResource struct {
	// READ-ONLY; The affected move resource id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The affected move resources.
	MoveResources []*AffectedMoveResource `json:"moveResources,omitempty" azure:"ro"`

	// READ-ONLY; The affected move resource source id.
	SourceID *string `json:"sourceId,omitempty" azure:"ro"`
}

// AutomaticResolutionProperties - Defines the properties for automatic resolution.
type AutomaticResolutionProperties struct {
	// Gets the MoveResource ARM ID of the dependent resource if the resolution type is Automatic.
	MoveResourceID *string `json:"moveResourceId,omitempty"`
}

// AvailabilitySetResourceSettings - Gets or sets the availability set resource settings.
type AvailabilitySetResourceSettings struct {
	// REQUIRED; The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
	ResourceType *string `json:"resourceType,omitempty"`

	// REQUIRED; Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`

	// Gets or sets the target fault domain.
	FaultDomain *int32 `json:"faultDomain,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// Gets or sets the target update domain.
	UpdateDomain *int32 `json:"updateDomain,omitempty"`
}

// GetResourceSettings implements the ResourceSettingsClassification interface for type AvailabilitySetResourceSettings.
func (a *AvailabilitySetResourceSettings) GetResourceSettings() *ResourceSettings {
	return &ResourceSettings{
		ResourceType:       a.ResourceType,
		TargetResourceName: a.TargetResourceName,
	}
}

// AzureResourceReference - Defines reference to an Azure resource.
type AzureResourceReference struct {
	// REQUIRED; Gets the ARM resource ID of the tracked resource being referenced.
	SourceArmResourceID *string `json:"sourceArmResourceId,omitempty"`
}

// BulkRemoveRequest - Defines the request body for bulk remove of move resources operation.
type BulkRemoveRequest struct {
	// Defines the move resource input type.
	MoveResourceInputType *MoveResourceInputType `json:"moveResourceInputType,omitempty"`

	// Gets or sets the list of resource Id's, by default it accepts move resource id's unless the input type is switched via
	// moveResourceInputType property.
	MoveResources []*string `json:"moveResources,omitempty"`

	// Gets or sets a value indicating whether the operation needs to only run pre-requisite.
	ValidateOnly *bool `json:"validateOnly,omitempty"`
}

// CloudError - An error response from the service.
type CloudError struct {
	// Cloud error body.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody - An error response from the service.
type CloudErrorBody struct {
	// An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`

	// A list of additional details about the error.
	Details []*CloudErrorBody `json:"details,omitempty"`

	// A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`

	// The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
}

// CommitRequest - Defines the request body for commit operation.
type CommitRequest struct {
	// REQUIRED; Gets or sets the list of resource Id's, by default it accepts move resource id's unless the input type is switched
	// via moveResourceInputType property.
	MoveResources []*string `json:"moveResources,omitempty"`

	// Defines the move resource input type.
	MoveResourceInputType *MoveResourceInputType `json:"moveResourceInputType,omitempty"`

	// Gets or sets a value indicating whether the operation needs to only run pre-requisite.
	ValidateOnly *bool `json:"validateOnly,omitempty"`
}

// DiscardRequest - Defines the request body for discard operation.
type DiscardRequest struct {
	// REQUIRED; Gets or sets the list of resource Id's, by default it accepts move resource id's unless the input type is switched
	// via moveResourceInputType property.
	MoveResources []*string `json:"moveResources,omitempty"`

	// Defines the move resource input type.
	MoveResourceInputType *MoveResourceInputType `json:"moveResourceInputType,omitempty"`

	// Gets or sets a value indicating whether the operation needs to only run pre-requisite.
	ValidateOnly *bool `json:"validateOnly,omitempty"`
}

// DiskEncryptionSetResourceSettings - Defines the disk encryption set resource settings.
type DiskEncryptionSetResourceSettings struct {
	// REQUIRED; The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
	ResourceType *string `json:"resourceType,omitempty"`

	// REQUIRED; Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
}

// GetResourceSettings implements the ResourceSettingsClassification interface for type DiskEncryptionSetResourceSettings.
func (d *DiskEncryptionSetResourceSettings) GetResourceSettings() *ResourceSettings {
	return &ResourceSettings{
		ResourceType:       d.ResourceType,
		TargetResourceName: d.TargetResourceName,
	}
}

// Display - Contains the localized display information for this particular operation / action. These value will be used by
// several clients for (1) custom role definitions for RBAC; (2) complex query filters for
// the event service; and (3) audit history / records for management operations.
type Display struct {
	// Gets or sets the description. The localized friendly description for the operation, as it should be shown to the user.
	// It should be thorough, yet concise – it will be used in tool tips and detailed
	// views. Prescriptive guidance for namespace: Read any 'display.provider' resource Create or Update any 'display.provider'
	// resource Delete any 'display.provider' resource Perform any other action on any
	// 'display.provider' resource Prescriptive guidance for namespace: Read any 'display.resource' Create or Update any 'display.resource'
	// Delete any 'display.resource' 'ActionName' any 'display.resources'.
	Description *string `json:"description,omitempty"`

	// Gets or sets the operation. The localized friendly name for the operation, as it should be shown to the user. It should
	// be concise (to fit in drop downs) but clear (i.e. self-documenting). It should
	// use Title Casing. Prescriptive guidance: Read Create or Update Delete 'ActionName'.
	Operation *string `json:"operation,omitempty"`

	// Gets or sets the provider. The localized friendly form of the resource provider name – it is expected to also include the
	// publisher/company responsible. It should use Title Casing and begin with
	// "Microsoft" for 1st party services. e.g. "Microsoft Monitoring Insights" or "Microsoft Compute.".
	Provider *string `json:"provider,omitempty"`

	// Gets or sets the resource. The localized friendly form of the resource related to this action/operation – it should match
	// the public documentation for the resource provider. It should use Title
	// Casing. This value should be unique for a particular URL type (e.g. nested types should notreuse their parent’s display.resource
	// field) e.g. "Virtual Machines" or "Scheduler Job Collections", or
	// "Virtual Machine VM Sizes" or "Scheduler Jobs".
	Resource *string `json:"resource,omitempty"`
}

// Identity - Defines the MSI properties of the Move Collection.
type Identity struct {
	// Gets or sets the principal id.
	PrincipalID *string `json:"principalId,omitempty"`

	// Gets or sets the tenant id.
	TenantID *string `json:"tenantId,omitempty"`

	// The type of identity used for the resource mover service.
	Type *ResourceIdentityType `json:"type,omitempty"`
}

// JobStatus - Defines the job status.
type JobStatus struct {
	// READ-ONLY; Defines the job name.
	JobName *JobName `json:"jobName,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the monitoring job percentage.
	JobProgress *string `json:"jobProgress,omitempty" azure:"ro"`
}

// KeyVaultResourceSettings - Defines the key vault resource settings.
type KeyVaultResourceSettings struct {
	// REQUIRED; The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
	ResourceType *string `json:"resourceType,omitempty"`

	// REQUIRED; Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
}

// GetResourceSettings implements the ResourceSettingsClassification interface for type KeyVaultResourceSettings.
func (k *KeyVaultResourceSettings) GetResourceSettings() *ResourceSettings {
	return &ResourceSettings{
		ResourceType:       k.ResourceType,
		TargetResourceName: k.TargetResourceName,
	}
}

// LBBackendAddressPoolResourceSettings - Defines load balancer backend address pool properties.
type LBBackendAddressPoolResourceSettings struct {
	// Gets or sets the backend address pool name.
	Name *string `json:"name,omitempty"`
}

// LBFrontendIPConfigurationResourceSettings - Defines load balancer frontend IP configuration properties.
type LBFrontendIPConfigurationResourceSettings struct {
	// Gets or sets the frontend IP configuration name.
	Name *string `json:"name,omitempty"`

	// Gets or sets the IP address of the Load Balancer.This is only specified if a specific private IP address shall be allocated
	// from the subnet specified in subnetRef.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`

	// Gets or sets PrivateIP allocation method (Static/Dynamic).
	PrivateIPAllocationMethod *string `json:"privateIpAllocationMethod,omitempty"`

	// Defines reference to subnet.
	Subnet *SubnetReference `json:"subnet,omitempty"`

	// Gets or sets the csv list of zones.
	Zones *string `json:"zones,omitempty"`
}

// LoadBalancerBackendAddressPoolReference - Defines reference to load balancer backend address pools.
type LoadBalancerBackendAddressPoolReference struct {
	// REQUIRED; Gets the ARM resource ID of the tracked resource being referenced.
	SourceArmResourceID *string `json:"sourceArmResourceId,omitempty"`

	// Gets the name of the proxy resource on the target side.
	Name *string `json:"name,omitempty"`
}

// LoadBalancerNatRuleReference - Defines reference to load balancer NAT rules.
type LoadBalancerNatRuleReference struct {
	// REQUIRED; Gets the ARM resource ID of the tracked resource being referenced.
	SourceArmResourceID *string `json:"sourceArmResourceId,omitempty"`

	// Gets the name of the proxy resource on the target side.
	Name *string `json:"name,omitempty"`
}

// LoadBalancerResourceSettings - Defines the load balancer resource settings.
type LoadBalancerResourceSettings struct {
	// REQUIRED; The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
	ResourceType *string `json:"resourceType,omitempty"`

	// REQUIRED; Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`

	// Gets or sets the backend address pools of the load balancer.
	BackendAddressPools []*LBBackendAddressPoolResourceSettings `json:"backendAddressPools,omitempty"`

	// Gets or sets the frontend IP configurations of the load balancer.
	FrontendIPConfigurations []*LBFrontendIPConfigurationResourceSettings `json:"frontendIPConfigurations,omitempty"`

	// Gets or sets load balancer sku (Basic/Standard).
	SKU *string `json:"sku,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// Gets or sets the csv list of zones common for all frontend IP configurations. Note this is given precedence only if frontend
	// IP configurations settings are not present.
	Zones *string `json:"zones,omitempty"`
}

// GetResourceSettings implements the ResourceSettingsClassification interface for type LoadBalancerResourceSettings.
func (l *LoadBalancerResourceSettings) GetResourceSettings() *ResourceSettings {
	return &ResourceSettings{
		ResourceType:       l.ResourceType,
		TargetResourceName: l.TargetResourceName,
	}
}

// ManualResolutionProperties - Defines the properties for manual resolution.
type ManualResolutionProperties struct {
	// Gets or sets the target resource ARM ID of the dependent resource if the resource type is Manual.
	TargetID *string `json:"targetId,omitempty"`
}

// MoveCollection - Define the move collection.
type MoveCollection struct {
	// Defines the MSI properties of the Move Collection.
	Identity *Identity `json:"identity,omitempty"`

	// The geo-location where the resource lives.
	Location *string `json:"location,omitempty"`

	// Defines the move collection properties.
	Properties *MoveCollectionProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The etag of the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MoveCollectionProperties - Defines the move collection properties.
type MoveCollectionProperties struct {
	// REQUIRED; Gets or sets the source region.
	SourceRegion *string `json:"sourceRegion,omitempty"`

	// REQUIRED; Gets or sets the target region.
	TargetRegion *string `json:"targetRegion,omitempty"`

	// READ-ONLY; Defines the move collection errors.
	Errors *MoveCollectionPropertiesErrors `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Defines the provisioning states.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// MoveCollectionPropertiesErrors - Defines the move collection errors.
type MoveCollectionPropertiesErrors struct {
	// The move resource error body.
	Properties *MoveResourceErrorBody `json:"properties,omitempty"`
}

// MoveCollectionResultList - Defines the collection of move collections.
type MoveCollectionResultList struct {
	// Gets the value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets the list of move collections.
	Value []*MoveCollection `json:"value,omitempty"`
}

// MoveCollectionsClientBeginBulkRemoveOptions contains the optional parameters for the MoveCollectionsClient.BeginBulkRemove
// method.
type MoveCollectionsClientBeginBulkRemoveOptions struct {
	Body *BulkRemoveRequest
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MoveCollectionsClientBeginCommitOptions contains the optional parameters for the MoveCollectionsClient.BeginCommit method.
type MoveCollectionsClientBeginCommitOptions struct {
	Body *CommitRequest
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MoveCollectionsClientBeginDeleteOptions contains the optional parameters for the MoveCollectionsClient.BeginDelete method.
type MoveCollectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MoveCollectionsClientBeginDiscardOptions contains the optional parameters for the MoveCollectionsClient.BeginDiscard method.
type MoveCollectionsClientBeginDiscardOptions struct {
	Body *DiscardRequest
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MoveCollectionsClientBeginInitiateMoveOptions contains the optional parameters for the MoveCollectionsClient.BeginInitiateMove
// method.
type MoveCollectionsClientBeginInitiateMoveOptions struct {
	Body *ResourceMoveRequest
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MoveCollectionsClientBeginPrepareOptions contains the optional parameters for the MoveCollectionsClient.BeginPrepare method.
type MoveCollectionsClientBeginPrepareOptions struct {
	Body *PrepareRequest
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MoveCollectionsClientBeginResolveDependenciesOptions contains the optional parameters for the MoveCollectionsClient.BeginResolveDependencies
// method.
type MoveCollectionsClientBeginResolveDependenciesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MoveCollectionsClientCreateOptions contains the optional parameters for the MoveCollectionsClient.Create method.
type MoveCollectionsClientCreateOptions struct {
	Body *MoveCollection
}

// MoveCollectionsClientGetOptions contains the optional parameters for the MoveCollectionsClient.Get method.
type MoveCollectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// MoveCollectionsClientListMoveCollectionsByResourceGroupOptions contains the optional parameters for the MoveCollectionsClient.ListMoveCollectionsByResourceGroup
// method.
type MoveCollectionsClientListMoveCollectionsByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// MoveCollectionsClientListMoveCollectionsBySubscriptionOptions contains the optional parameters for the MoveCollectionsClient.ListMoveCollectionsBySubscription
// method.
type MoveCollectionsClientListMoveCollectionsBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// MoveCollectionsClientListRequiredForOptions contains the optional parameters for the MoveCollectionsClient.ListRequiredFor
// method.
type MoveCollectionsClientListRequiredForOptions struct {
	// placeholder for future optional parameters
}

// MoveCollectionsClientUpdateOptions contains the optional parameters for the MoveCollectionsClient.Update method.
type MoveCollectionsClientUpdateOptions struct {
	Body *UpdateMoveCollectionRequest
}

// MoveErrorInfo - The move custom error info.
type MoveErrorInfo struct {
	// READ-ONLY; The affected move resources.
	MoveResources []*AffectedMoveResource `json:"moveResources,omitempty" azure:"ro"`
}

// MoveResource - Defines the move resource.
type MoveResource struct {
	// Defines the move resource properties.
	Properties *MoveResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MoveResourceCollection - Defines the collection of move resources.
type MoveResourceCollection struct {
	// Gets the value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets the list of summary items and the field on which summary is done.
	SummaryCollection *SummaryCollection `json:"summaryCollection,omitempty"`

	// Gets the list of move resources.
	Value []*MoveResource `json:"value,omitempty"`

	// READ-ONLY; Gets the total count.
	TotalCount *int64 `json:"totalCount,omitempty" azure:"ro"`
}

// MoveResourceDependency - Defines the dependency of the move resource.
type MoveResourceDependency struct {
	// Defines the properties for automatic resolution.
	AutomaticResolution *AutomaticResolutionProperties `json:"automaticResolution,omitempty"`

	// Defines the dependency type.
	DependencyType *DependencyType `json:"dependencyType,omitempty"`

	// Gets the source ARM ID of the dependent resource.
	ID *string `json:"id,omitempty"`

	// Gets or sets a value indicating whether the dependency is optional.
	IsOptional *string `json:"isOptional,omitempty"`

	// Defines the properties for manual resolution.
	ManualResolution *ManualResolutionProperties `json:"manualResolution,omitempty"`

	// Gets the dependency resolution status.
	ResolutionStatus *string `json:"resolutionStatus,omitempty"`

	// Defines the resolution type.
	ResolutionType *ResolutionType `json:"resolutionType,omitempty"`
}

// MoveResourceDependencyOverride - Defines the dependency override of the move resource.
type MoveResourceDependencyOverride struct {
	// Gets or sets the ARM ID of the dependent resource.
	ID *string `json:"id,omitempty"`

	// Gets or sets the resource ARM id of either the MoveResource or the resource ARM ID of the dependent resource.
	TargetID *string `json:"targetId,omitempty"`
}

// MoveResourceError - An error response from the azure resource mover service.
type MoveResourceError struct {
	// The move resource error body.
	Properties *MoveResourceErrorBody `json:"properties,omitempty"`
}

// MoveResourceErrorBody - An error response from the Azure Migrate service.
type MoveResourceErrorBody struct {
	// READ-ONLY; An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; A list of additional details about the error.
	Details []*MoveResourceErrorBody `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// MoveResourceFilter - Move resource filter.
type MoveResourceFilter struct {
	Properties *MoveResourceFilterProperties `json:"properties,omitempty"`
}

type MoveResourceFilterProperties struct {
	// The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MoveResourceProperties - Defines the move resource properties.
type MoveResourceProperties struct {
	// REQUIRED; Gets or sets the Source ARM Id of the resource.
	SourceID *string `json:"sourceId,omitempty"`

	// Gets or sets the move resource dependencies overrides.
	DependsOnOverrides []*MoveResourceDependencyOverride `json:"dependsOnOverrides,omitempty"`

	// Gets or sets the existing target ARM Id of the resource.
	ExistingTargetID *string `json:"existingTargetId,omitempty"`

	// Gets or sets the resource settings.
	ResourceSettings ResourceSettingsClassification `json:"resourceSettings,omitempty"`

	// READ-ONLY; Gets or sets the move resource dependencies.
	DependsOn []*MoveResourceDependency `json:"dependsOn,omitempty" azure:"ro"`

	// READ-ONLY; Defines the move resource errors.
	Errors *MoveResourcePropertiesErrors `json:"errors,omitempty" azure:"ro"`

	// READ-ONLY; Gets a value indicating whether the resolve action is required over the move collection.
	IsResolveRequired *bool `json:"isResolveRequired,omitempty" azure:"ro"`

	// READ-ONLY; Defines the move resource status.
	MoveStatus *MoveResourcePropertiesMoveStatus `json:"moveStatus,omitempty" azure:"ro"`

	// READ-ONLY; Defines the provisioning states.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the source resource settings.
	SourceResourceSettings ResourceSettingsClassification `json:"sourceResourceSettings,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the Target ARM Id of the resource.
	TargetID *string `json:"targetId,omitempty" azure:"ro"`
}

// MoveResourcePropertiesErrors - Defines the move resource errors.
type MoveResourcePropertiesErrors struct {
	// The move resource error body.
	Properties *MoveResourceErrorBody `json:"properties,omitempty"`
}

// MoveResourcePropertiesMoveStatus - Defines the move resource status.
type MoveResourcePropertiesMoveStatus struct {
	// An error response from the azure resource mover service.
	Errors *MoveResourceError `json:"errors,omitempty"`

	// Defines the job status.
	JobStatus *JobStatus `json:"jobStatus,omitempty"`

	// READ-ONLY; Defines the MoveResource states.
	MoveState *MoveState `json:"moveState,omitempty" azure:"ro"`
}

// MoveResourceStatus - Defines the move resource status.
type MoveResourceStatus struct {
	// An error response from the azure resource mover service.
	Errors *MoveResourceError `json:"errors,omitempty"`

	// Defines the job status.
	JobStatus *JobStatus `json:"jobStatus,omitempty"`

	// READ-ONLY; Defines the MoveResource states.
	MoveState *MoveState `json:"moveState,omitempty" azure:"ro"`
}

// MoveResourcesClientBeginCreateOptions contains the optional parameters for the MoveResourcesClient.BeginCreate method.
type MoveResourcesClientBeginCreateOptions struct {
	Body *MoveResource
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MoveResourcesClientBeginDeleteOptions contains the optional parameters for the MoveResourcesClient.BeginDelete method.
type MoveResourcesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// MoveResourcesClientGetOptions contains the optional parameters for the MoveResourcesClient.Get method.
type MoveResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// MoveResourcesClientListOptions contains the optional parameters for the MoveResourcesClient.List method.
type MoveResourcesClientListOptions struct {
	// The filter to apply on the operation. For example, you can use $filter=Properties/ProvisioningState eq 'Succeeded'.
	Filter *string
}

// NetworkInterfaceResourceSettings - Defines the network interface resource settings.
type NetworkInterfaceResourceSettings struct {
	// REQUIRED; The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
	ResourceType *string `json:"resourceType,omitempty"`

	// REQUIRED; Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`

	// Gets or sets a value indicating whether accelerated networking is enabled.
	EnableAcceleratedNetworking *bool `json:"enableAcceleratedNetworking,omitempty"`

	// Gets or sets the IP configurations of the NIC.
	IPConfigurations []*NicIPConfigurationResourceSettings `json:"ipConfigurations,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// GetResourceSettings implements the ResourceSettingsClassification interface for type NetworkInterfaceResourceSettings.
func (n *NetworkInterfaceResourceSettings) GetResourceSettings() *ResourceSettings {
	return &ResourceSettings{
		ResourceType:       n.ResourceType,
		TargetResourceName: n.TargetResourceName,
	}
}

// NetworkSecurityGroupResourceSettings - Defines the NSG resource settings.
type NetworkSecurityGroupResourceSettings struct {
	// REQUIRED; The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
	ResourceType *string `json:"resourceType,omitempty"`

	// REQUIRED; Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`

	// Gets or sets Security rules of network security group.
	SecurityRules []*NsgSecurityRule `json:"securityRules,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// GetResourceSettings implements the ResourceSettingsClassification interface for type NetworkSecurityGroupResourceSettings.
func (n *NetworkSecurityGroupResourceSettings) GetResourceSettings() *ResourceSettings {
	return &ResourceSettings{
		ResourceType:       n.ResourceType,
		TargetResourceName: n.TargetResourceName,
	}
}

// NicIPConfigurationResourceSettings - Defines NIC IP configuration properties.
type NicIPConfigurationResourceSettings struct {
	// Gets or sets the references of the load balancer backend address pools.
	LoadBalancerBackendAddressPools []*LoadBalancerBackendAddressPoolReference `json:"loadBalancerBackendAddressPools,omitempty"`

	// Gets or sets the references of the load balancer NAT rules.
	LoadBalancerNatRules []*LoadBalancerNatRuleReference `json:"loadBalancerNatRules,omitempty"`

	// Gets or sets the IP configuration name.
	Name *string `json:"name,omitempty"`

	// Gets or sets a value indicating whether this IP configuration is the primary.
	Primary *bool `json:"primary,omitempty"`

	// Gets or sets the private IP address of the network interface IP Configuration.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`

	// Gets or sets the private IP address allocation method.
	PrivateIPAllocationMethod *string `json:"privateIpAllocationMethod,omitempty"`

	// Defines reference to a public IP.
	PublicIP *PublicIPReference `json:"publicIp,omitempty"`

	// Defines reference to subnet.
	Subnet *SubnetReference `json:"subnet,omitempty"`
}

// NsgReference - Defines reference to NSG.
type NsgReference struct {
	// REQUIRED; Gets the ARM resource ID of the tracked resource being referenced.
	SourceArmResourceID *string `json:"sourceArmResourceId,omitempty"`
}

// NsgSecurityRule - Security Rule data model for Network Security Groups.
type NsgSecurityRule struct {
	// Gets or sets whether network traffic is allowed or denied. Possible values are “Allow” and “Deny”.
	Access *string `json:"access,omitempty"`

	// Gets or sets a description for this rule. Restricted to 140 chars.
	Description *string `json:"description,omitempty"`

	// Gets or sets destination address prefix. CIDR or source IP range. A “*” can also be used to match all source IPs. Default
	// tags such as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be
	// used.
	DestinationAddressPrefix *string `json:"destinationAddressPrefix,omitempty"`

	// Gets or sets Destination Port or Range. Integer or range between 0 and 65535. A “*” can also be used to match all ports.
	DestinationPortRange *string `json:"destinationPortRange,omitempty"`

	// Gets or sets the direction of the rule.InBound or Outbound. The direction specifies if rule will be evaluated on incoming
	// or outgoing traffic.
	Direction *string `json:"direction,omitempty"`

	// Gets or sets the Security rule name.
	Name *string `json:"name,omitempty"`

	// Gets or sets the priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each
	// rule in the collection. The lower the priority number, the higher the priority
	// of the rule.
	Priority *int32 `json:"priority,omitempty"`

	// Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*).
	Protocol *string `json:"protocol,omitempty"`

	// Gets or sets source address prefix. CIDR or source IP range. A “*” can also be used to match all source IPs. Default tags
	// such as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be used.
	// If this is an ingress rule, specifies where network traffic originates from.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`

	// Gets or sets Source Port or Range. Integer or range between 0 and
	// 65535. A “*” can also be used to match all ports.
	SourcePortRange *string `json:"sourcePortRange,omitempty"`
}

// OperationErrorAdditionalInfo - The operation error info.
type OperationErrorAdditionalInfo struct {
	// READ-ONLY; The operation error info.
	Info *MoveErrorInfo `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The error type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// OperationStatus - Operation status REST resource.
type OperationStatus struct {
	// READ-ONLY; End time.
	EndTime *string `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; Error stating all error details for the operation.
	Error *OperationStatusError `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Operation name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Custom data.
	Properties interface{} `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; Start time.
	StartTime *string `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Status of the operation. ARM expects the terminal status to be one of Succeeded/ Failed/ Canceled. All other
	// values imply that the operation is still running.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// OperationStatusError - Class for operation status errors.
type OperationStatusError struct {
	// READ-ONLY; The additional info.
	AdditionalInfo []*OperationErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*OperationStatusError `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// OperationsDiscovery - Operations discovery class.
type OperationsDiscovery struct {
	// Contains the localized display information for this particular operation / action. These value will be used by several
	// clients for (1) custom role definitions for RBAC; (2) complex query filters for
	// the event service; and (3) audit history / records for management operations.
	Display *Display `json:"display,omitempty"`

	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Gets or sets Name of the API. The name of the operation being performed on this particular object. It should match the
	// action name that appears in RBAC / the event service. Examples of operations
	// include:
	// * Microsoft.Compute/virtualMachine/capture/action
	// * Microsoft.Compute/virtualMachine/restart/action
	// * Microsoft.Compute/virtualMachine/write
	// * Microsoft.Compute/virtualMachine/read
	// * Microsoft.Compute/virtualMachine/delete Each action should include, in order: (1) Resource Provider Namespace (2) Type
	// hierarchy for which the action applies (e.g. server/databases for a SQL Azure
	// database) (3) Read, Write, Action or Delete indicating which type applies. If it is a PUT/PATCH on a collection or named
	// value, Write should be used. If it is a GET, Read should be used. If it is a
	// DELETE, Delete should be used. If it is a POST, Action should be used. As a note: all resource providers would need to
	// include the "{Resource Provider Namespace}/register/action" operation in their
	// response. This API is used to register for their service, and should include details about the operation (e.g. a localized
	// name for the resource provider + any special considerations like PII
	// release).
	Name *string `json:"name,omitempty"`

	// Gets or sets Origin. The intended executor of the operation; governs the display of the operation in the RBAC UX and the
	// audit logs UX. Default value is "user,system".
	Origin *string `json:"origin,omitempty"`

	// ClientDiscovery properties.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationsDiscoveryClientGetOptions contains the optional parameters for the OperationsDiscoveryClient.Get method.
type OperationsDiscoveryClientGetOptions struct {
	// placeholder for future optional parameters
}

// OperationsDiscoveryCollection - Collection of ClientDiscovery details.
type OperationsDiscoveryCollection struct {
	// Gets or sets the value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets the ClientDiscovery details.
	Value []*OperationsDiscovery `json:"value,omitempty"`
}

// PrepareRequest - Defines the request body for initiate prepare operation.
type PrepareRequest struct {
	// REQUIRED; Gets or sets the list of resource Id's, by default it accepts move resource id's unless the input type is switched
	// via moveResourceInputType property.
	MoveResources []*string `json:"moveResources,omitempty"`

	// Defines the move resource input type.
	MoveResourceInputType *MoveResourceInputType `json:"moveResourceInputType,omitempty"`

	// Gets or sets a value indicating whether the operation needs to only run pre-requisite.
	ValidateOnly *bool `json:"validateOnly,omitempty"`
}

// ProxyResourceReference - Defines reference to a proxy resource.
type ProxyResourceReference struct {
	// REQUIRED; Gets the ARM resource ID of the tracked resource being referenced.
	SourceArmResourceID *string `json:"sourceArmResourceId,omitempty"`

	// Gets the name of the proxy resource on the target side.
	Name *string `json:"name,omitempty"`
}

// PublicIPAddressResourceSettings - Defines the public IP address resource settings.
type PublicIPAddressResourceSettings struct {
	// REQUIRED; The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
	ResourceType *string `json:"resourceType,omitempty"`

	// REQUIRED; Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`

	// Gets or sets the domain name label.
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`

	// Gets or sets the fully qualified domain name.
	Fqdn *string `json:"fqdn,omitempty"`

	// Gets or sets public IP allocation method.
	PublicIPAllocationMethod *string `json:"publicIpAllocationMethod,omitempty"`

	// Gets or sets public IP sku.
	SKU *string `json:"sku,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// Gets or sets public IP zones.
	Zones *string `json:"zones,omitempty"`
}

// GetResourceSettings implements the ResourceSettingsClassification interface for type PublicIPAddressResourceSettings.
func (p *PublicIPAddressResourceSettings) GetResourceSettings() *ResourceSettings {
	return &ResourceSettings{
		ResourceType:       p.ResourceType,
		TargetResourceName: p.TargetResourceName,
	}
}

// PublicIPReference - Defines reference to a public IP.
type PublicIPReference struct {
	// REQUIRED; Gets the ARM resource ID of the tracked resource being referenced.
	SourceArmResourceID *string `json:"sourceArmResourceId,omitempty"`
}

// RequiredForResourcesCollection - Required for resources collection.
type RequiredForResourcesCollection struct {
	// Gets or sets the list of source Ids for which the input resource is required.
	SourceIDs []*string `json:"sourceIds,omitempty"`
}

// ResourceGroupResourceSettings - Defines the resource group resource settings.
type ResourceGroupResourceSettings struct {
	// REQUIRED; The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
	ResourceType *string `json:"resourceType,omitempty"`

	// REQUIRED; Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
}

// GetResourceSettings implements the ResourceSettingsClassification interface for type ResourceGroupResourceSettings.
func (r *ResourceGroupResourceSettings) GetResourceSettings() *ResourceSettings {
	return &ResourceSettings{
		ResourceType:       r.ResourceType,
		TargetResourceName: r.TargetResourceName,
	}
}

// ResourceMoveRequest - Defines the request body for resource move operation.
type ResourceMoveRequest struct {
	// REQUIRED; Gets or sets the list of resource Id's, by default it accepts move resource id's unless the input type is switched
	// via moveResourceInputType property.
	MoveResources []*string `json:"moveResources,omitempty"`

	// Defines the move resource input type.
	MoveResourceInputType *MoveResourceInputType `json:"moveResourceInputType,omitempty"`

	// Gets or sets a value indicating whether the operation needs to only run pre-requisite.
	ValidateOnly *bool `json:"validateOnly,omitempty"`
}

// ResourceSettingsClassification provides polymorphic access to related types.
// Call the interface's GetResourceSettings() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AvailabilitySetResourceSettings, *DiskEncryptionSetResourceSettings, *KeyVaultResourceSettings, *LoadBalancerResourceSettings,
// - *NetworkInterfaceResourceSettings, *NetworkSecurityGroupResourceSettings, *PublicIPAddressResourceSettings, *ResourceGroupResourceSettings,
// - *ResourceSettings, *SQLDatabaseResourceSettings, *SQLElasticPoolResourceSettings, *SQLServerResourceSettings, *VirtualMachineResourceSettings,
// - *VirtualNetworkResourceSettings
type ResourceSettingsClassification interface {
	// GetResourceSettings returns the ResourceSettings content of the underlying type.
	GetResourceSettings() *ResourceSettings
}

// ResourceSettings - Gets or sets the resource settings.
type ResourceSettings struct {
	// REQUIRED; The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
	ResourceType *string `json:"resourceType,omitempty"`

	// REQUIRED; Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
}

// GetResourceSettings implements the ResourceSettingsClassification interface for type ResourceSettings.
func (r *ResourceSettings) GetResourceSettings() *ResourceSettings { return r }

// SQLDatabaseResourceSettings - Defines the Sql Database resource settings.
type SQLDatabaseResourceSettings struct {
	// REQUIRED; The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
	ResourceType *string `json:"resourceType,omitempty"`

	// REQUIRED; Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// Defines the zone redundant resource setting.
	ZoneRedundant *ZoneRedundant `json:"zoneRedundant,omitempty"`
}

// GetResourceSettings implements the ResourceSettingsClassification interface for type SQLDatabaseResourceSettings.
func (s *SQLDatabaseResourceSettings) GetResourceSettings() *ResourceSettings {
	return &ResourceSettings{
		ResourceType:       s.ResourceType,
		TargetResourceName: s.TargetResourceName,
	}
}

// SQLElasticPoolResourceSettings - Defines the Sql ElasticPool resource settings.
type SQLElasticPoolResourceSettings struct {
	// REQUIRED; The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
	ResourceType *string `json:"resourceType,omitempty"`

	// REQUIRED; Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// Defines the zone redundant resource setting.
	ZoneRedundant *ZoneRedundant `json:"zoneRedundant,omitempty"`
}

// GetResourceSettings implements the ResourceSettingsClassification interface for type SQLElasticPoolResourceSettings.
func (s *SQLElasticPoolResourceSettings) GetResourceSettings() *ResourceSettings {
	return &ResourceSettings{
		ResourceType:       s.ResourceType,
		TargetResourceName: s.TargetResourceName,
	}
}

// SQLServerResourceSettings - Defines the SQL Server resource settings.
type SQLServerResourceSettings struct {
	// REQUIRED; The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
	ResourceType *string `json:"resourceType,omitempty"`

	// REQUIRED; Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
}

// GetResourceSettings implements the ResourceSettingsClassification interface for type SQLServerResourceSettings.
func (s *SQLServerResourceSettings) GetResourceSettings() *ResourceSettings {
	return &ResourceSettings{
		ResourceType:       s.ResourceType,
		TargetResourceName: s.TargetResourceName,
	}
}

// SubnetReference - Defines reference to subnet.
type SubnetReference struct {
	// REQUIRED; Gets the ARM resource ID of the tracked resource being referenced.
	SourceArmResourceID *string `json:"sourceArmResourceId,omitempty"`

	// Gets the name of the proxy resource on the target side.
	Name *string `json:"name,omitempty"`
}

// SubnetResourceSettings - Defines the virtual network subnets resource settings.
type SubnetResourceSettings struct {
	// Gets or sets address prefix for the subnet.
	AddressPrefix *string `json:"addressPrefix,omitempty"`

	// Gets or sets the Subnet name.
	Name *string `json:"name,omitempty"`

	// Defines reference to NSG.
	NetworkSecurityGroup *NsgReference `json:"networkSecurityGroup,omitempty"`
}

// Summary item.
type Summary struct {
	// Gets the count.
	Count *int32 `json:"count,omitempty"`

	// Gets the item.
	Item *string `json:"item,omitempty"`
}

// SummaryCollection - Summary Collection.
type SummaryCollection struct {
	// Gets or sets the field name on which summary is done.
	FieldName *string `json:"fieldName,omitempty"`

	// Gets or sets the list of summary items.
	Summary []*Summary `json:"summary,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// UnresolvedDependenciesClientGetOptions contains the optional parameters for the UnresolvedDependenciesClient.Get method.
type UnresolvedDependenciesClientGetOptions struct {
	// Defines the dependency level.
	DependencyLevel *DependencyLevel
	// The filter to apply on the operation. For example, $apply=filter(count eq 2).
	Filter *string
	// OData order by query option. For example, you can use $orderby=Count desc.
	Orderby *string
}

// UnresolvedDependenciesFilter - Unresolved dependencies contract.
type UnresolvedDependenciesFilter struct {
	Properties *UnresolvedDependenciesFilterProperties `json:"properties,omitempty"`
}

type UnresolvedDependenciesFilterProperties struct {
	// The count of the resource.
	Count *int32 `json:"count,omitempty"`
}

// UnresolvedDependency - Unresolved dependency.
type UnresolvedDependency struct {
	// Gets or sets the count.
	Count *int32 `json:"count,omitempty"`

	// Gets or sets the arm id of the dependency.
	ID *string `json:"id,omitempty"`
}

// UnresolvedDependencyCollection - Unresolved dependency collection.
type UnresolvedDependencyCollection struct {
	// Gets or sets the value of next link.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets or sets the list of unresolved dependencies.
	Value []*UnresolvedDependency `json:"value,omitempty"`

	// READ-ONLY; Gets or sets the list of summary items and the field on which summary is done.
	SummaryCollection *SummaryCollection `json:"summaryCollection,omitempty" azure:"ro"`

	// READ-ONLY; Gets the total count.
	TotalCount *int64 `json:"totalCount,omitempty" azure:"ro"`
}

// UpdateMoveCollectionRequest - Defines the request body for updating move collection.
type UpdateMoveCollectionRequest struct {
	// Defines the MSI properties of the Move Collection.
	Identity *Identity `json:"identity,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// VirtualMachineResourceSettings - Gets or sets the virtual machine resource settings.
type VirtualMachineResourceSettings struct {
	// REQUIRED; The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
	ResourceType *string `json:"resourceType,omitempty"`

	// REQUIRED; Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// Gets or sets the target availability set id for virtual machines not in an availability set at source.
	TargetAvailabilitySetID *string `json:"targetAvailabilitySetId,omitempty"`

	// Gets or sets the target availability zone.
	TargetAvailabilityZone *TargetAvailabilityZone `json:"targetAvailabilityZone,omitempty"`

	// Gets or sets the target virtual machine size.
	TargetVMSize *string `json:"targetVmSize,omitempty"`

	// Gets or sets user-managed identities
	UserManagedIdentities []*string `json:"userManagedIdentities,omitempty"`
}

// GetResourceSettings implements the ResourceSettingsClassification interface for type VirtualMachineResourceSettings.
func (v *VirtualMachineResourceSettings) GetResourceSettings() *ResourceSettings {
	return &ResourceSettings{
		ResourceType:       v.ResourceType,
		TargetResourceName: v.TargetResourceName,
	}
}

// VirtualNetworkResourceSettings - Defines the virtual network resource settings.
type VirtualNetworkResourceSettings struct {
	// REQUIRED; The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
	ResourceType *string `json:"resourceType,omitempty"`

	// REQUIRED; Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`

	// Gets or sets the address prefixes for the virtual network.
	AddressSpace []*string `json:"addressSpace,omitempty"`

	// Gets or sets DHCPOptions that contains an array of DNS servers available to VMs deployed in the virtual network.
	DNSServers []*string `json:"dnsServers,omitempty"`

	// Gets or sets a value indicating whether gets or sets whether the DDOS protection should be switched on.
	EnableDdosProtection *bool `json:"enableDdosProtection,omitempty"`

	// Gets or sets List of subnets in a VirtualNetwork.
	Subnets []*SubnetResourceSettings `json:"subnets,omitempty"`

	// Gets or sets the Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// GetResourceSettings implements the ResourceSettingsClassification interface for type VirtualNetworkResourceSettings.
func (v *VirtualNetworkResourceSettings) GetResourceSettings() *ResourceSettings {
	return &ResourceSettings{
		ResourceType:       v.ResourceType,
		TargetResourceName: v.TargetResourceName,
	}
}
