//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbilling

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SubscriptionsClient contains the methods for the BillingSubscriptions group.
// Don't use this type directly, use NewSubscriptionsClient() instead.
type SubscriptionsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewSubscriptionsClient creates a new instance of SubscriptionsClient with the specified values.
// subscriptionID - The ID that uniquely identifies an Azure subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewSubscriptionsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SubscriptionsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &SubscriptionsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Get - Gets a subscription by its ID. The operation is supported for billing accounts with agreement type Microsoft Customer
// Agreement and Microsoft Partner Agreement.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
// billingAccountName - The ID that uniquely identifies a billing account.
// options - SubscriptionsClientGetOptions contains the optional parameters for the SubscriptionsClient.Get method.
func (client *SubscriptionsClient) Get(ctx context.Context, billingAccountName string, options *SubscriptionsClientGetOptions) (SubscriptionsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, billingAccountName, options)
	if err != nil {
		return SubscriptionsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SubscriptionsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SubscriptionsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *SubscriptionsClient) getCreateRequest(ctx context.Context, billingAccountName string, options *SubscriptionsClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingSubscriptions/{subscriptionId}"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SubscriptionsClient) getHandleResponse(resp *http.Response) (SubscriptionsClientGetResponse, error) {
	result := SubscriptionsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Subscription); err != nil {
		return SubscriptionsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByBillingAccountPager - Lists the subscriptions for a billing account. The operation is supported for billing accounts
// with agreement type Microsoft Customer Agreement or Microsoft Partner Agreement.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
// billingAccountName - The ID that uniquely identifies a billing account.
// options - SubscriptionsClientListByBillingAccountOptions contains the optional parameters for the SubscriptionsClient.ListByBillingAccount
// method.
func (client *SubscriptionsClient) NewListByBillingAccountPager(billingAccountName string, options *SubscriptionsClientListByBillingAccountOptions) *runtime.Pager[SubscriptionsClientListByBillingAccountResponse] {
	return runtime.NewPager(runtime.PagingHandler[SubscriptionsClientListByBillingAccountResponse]{
		More: func(page SubscriptionsClientListByBillingAccountResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SubscriptionsClientListByBillingAccountResponse) (SubscriptionsClientListByBillingAccountResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByBillingAccountCreateRequest(ctx, billingAccountName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return SubscriptionsClientListByBillingAccountResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return SubscriptionsClientListByBillingAccountResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return SubscriptionsClientListByBillingAccountResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByBillingAccountHandleResponse(resp)
		},
	})
}

// listByBillingAccountCreateRequest creates the ListByBillingAccount request.
func (client *SubscriptionsClient) listByBillingAccountCreateRequest(ctx context.Context, billingAccountName string, options *SubscriptionsClientListByBillingAccountOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingSubscriptions"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByBillingAccountHandleResponse handles the ListByBillingAccount response.
func (client *SubscriptionsClient) listByBillingAccountHandleResponse(resp *http.Response) (SubscriptionsClientListByBillingAccountResponse, error) {
	result := SubscriptionsClientListByBillingAccountResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SubscriptionsListResult); err != nil {
		return SubscriptionsClientListByBillingAccountResponse{}, err
	}
	return result, nil
}

// NewListByBillingProfilePager - Lists the subscriptions that are billed to a billing profile. The operation is supported
// for billing accounts with agreement type Microsoft Customer Agreement or Microsoft Partner Agreement.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
// billingAccountName - The ID that uniquely identifies a billing account.
// billingProfileName - The ID that uniquely identifies a billing profile.
// options - SubscriptionsClientListByBillingProfileOptions contains the optional parameters for the SubscriptionsClient.ListByBillingProfile
// method.
func (client *SubscriptionsClient) NewListByBillingProfilePager(billingAccountName string, billingProfileName string, options *SubscriptionsClientListByBillingProfileOptions) *runtime.Pager[SubscriptionsClientListByBillingProfileResponse] {
	return runtime.NewPager(runtime.PagingHandler[SubscriptionsClientListByBillingProfileResponse]{
		More: func(page SubscriptionsClientListByBillingProfileResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SubscriptionsClientListByBillingProfileResponse) (SubscriptionsClientListByBillingProfileResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByBillingProfileCreateRequest(ctx, billingAccountName, billingProfileName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return SubscriptionsClientListByBillingProfileResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return SubscriptionsClientListByBillingProfileResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return SubscriptionsClientListByBillingProfileResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByBillingProfileHandleResponse(resp)
		},
	})
}

// listByBillingProfileCreateRequest creates the ListByBillingProfile request.
func (client *SubscriptionsClient) listByBillingProfileCreateRequest(ctx context.Context, billingAccountName string, billingProfileName string, options *SubscriptionsClientListByBillingProfileOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/billingSubscriptions"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if billingProfileName == "" {
		return nil, errors.New("parameter billingProfileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingProfileName}", url.PathEscape(billingProfileName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByBillingProfileHandleResponse handles the ListByBillingProfile response.
func (client *SubscriptionsClient) listByBillingProfileHandleResponse(resp *http.Response) (SubscriptionsClientListByBillingProfileResponse, error) {
	result := SubscriptionsClientListByBillingProfileResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SubscriptionsListResult); err != nil {
		return SubscriptionsClientListByBillingProfileResponse{}, err
	}
	return result, nil
}

// NewListByCustomerPager - Lists the subscriptions for a customer. The operation is supported only for billing accounts with
// agreement type Microsoft Partner Agreement.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
// billingAccountName - The ID that uniquely identifies a billing account.
// customerName - The ID that uniquely identifies a customer.
// options - SubscriptionsClientListByCustomerOptions contains the optional parameters for the SubscriptionsClient.ListByCustomer
// method.
func (client *SubscriptionsClient) NewListByCustomerPager(billingAccountName string, customerName string, options *SubscriptionsClientListByCustomerOptions) *runtime.Pager[SubscriptionsClientListByCustomerResponse] {
	return runtime.NewPager(runtime.PagingHandler[SubscriptionsClientListByCustomerResponse]{
		More: func(page SubscriptionsClientListByCustomerResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SubscriptionsClientListByCustomerResponse) (SubscriptionsClientListByCustomerResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByCustomerCreateRequest(ctx, billingAccountName, customerName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return SubscriptionsClientListByCustomerResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return SubscriptionsClientListByCustomerResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return SubscriptionsClientListByCustomerResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByCustomerHandleResponse(resp)
		},
	})
}

// listByCustomerCreateRequest creates the ListByCustomer request.
func (client *SubscriptionsClient) listByCustomerCreateRequest(ctx context.Context, billingAccountName string, customerName string, options *SubscriptionsClientListByCustomerOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/customers/{customerName}/billingSubscriptions"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if customerName == "" {
		return nil, errors.New("parameter customerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{customerName}", url.PathEscape(customerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByCustomerHandleResponse handles the ListByCustomer response.
func (client *SubscriptionsClient) listByCustomerHandleResponse(resp *http.Response) (SubscriptionsClientListByCustomerResponse, error) {
	result := SubscriptionsClientListByCustomerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SubscriptionsListResult); err != nil {
		return SubscriptionsClientListByCustomerResponse{}, err
	}
	return result, nil
}

// NewListByInvoiceSectionPager - Lists the subscriptions that are billed to an invoice section. The operation is supported
// only for billing accounts with agreement type Microsoft Customer Agreement.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
// billingAccountName - The ID that uniquely identifies a billing account.
// billingProfileName - The ID that uniquely identifies a billing profile.
// invoiceSectionName - The ID that uniquely identifies an invoice section.
// options - SubscriptionsClientListByInvoiceSectionOptions contains the optional parameters for the SubscriptionsClient.ListByInvoiceSection
// method.
func (client *SubscriptionsClient) NewListByInvoiceSectionPager(billingAccountName string, billingProfileName string, invoiceSectionName string, options *SubscriptionsClientListByInvoiceSectionOptions) *runtime.Pager[SubscriptionsClientListByInvoiceSectionResponse] {
	return runtime.NewPager(runtime.PagingHandler[SubscriptionsClientListByInvoiceSectionResponse]{
		More: func(page SubscriptionsClientListByInvoiceSectionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SubscriptionsClientListByInvoiceSectionResponse) (SubscriptionsClientListByInvoiceSectionResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByInvoiceSectionCreateRequest(ctx, billingAccountName, billingProfileName, invoiceSectionName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return SubscriptionsClientListByInvoiceSectionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return SubscriptionsClientListByInvoiceSectionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return SubscriptionsClientListByInvoiceSectionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByInvoiceSectionHandleResponse(resp)
		},
	})
}

// listByInvoiceSectionCreateRequest creates the ListByInvoiceSection request.
func (client *SubscriptionsClient) listByInvoiceSectionCreateRequest(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, options *SubscriptionsClientListByInvoiceSectionOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/billingSubscriptions"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if billingProfileName == "" {
		return nil, errors.New("parameter billingProfileName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingProfileName}", url.PathEscape(billingProfileName))
	if invoiceSectionName == "" {
		return nil, errors.New("parameter invoiceSectionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{invoiceSectionName}", url.PathEscape(invoiceSectionName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByInvoiceSectionHandleResponse handles the ListByInvoiceSection response.
func (client *SubscriptionsClient) listByInvoiceSectionHandleResponse(resp *http.Response) (SubscriptionsClientListByInvoiceSectionResponse, error) {
	result := SubscriptionsClientListByInvoiceSectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SubscriptionsListResult); err != nil {
		return SubscriptionsClientListByInvoiceSectionResponse{}, err
	}
	return result, nil
}

// BeginMove - Moves a subscription's charges to a new invoice section. The new invoice section must belong to the same billing
// profile as the existing invoice section. This operation is supported for billing
// accounts with agreement type Microsoft Customer Agreement.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
// billingAccountName - The ID that uniquely identifies a billing account.
// parameters - Request parameters that are provided to the move subscription operation.
// options - SubscriptionsClientBeginMoveOptions contains the optional parameters for the SubscriptionsClient.BeginMove method.
func (client *SubscriptionsClient) BeginMove(ctx context.Context, billingAccountName string, parameters TransferBillingSubscriptionRequestProperties, options *SubscriptionsClientBeginMoveOptions) (*runtime.Poller[SubscriptionsClientMoveResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.move(ctx, billingAccountName, parameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[SubscriptionsClientMoveResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[SubscriptionsClientMoveResponse](options.ResumeToken, client.pl, nil)
	}
}

// Move - Moves a subscription's charges to a new invoice section. The new invoice section must belong to the same billing
// profile as the existing invoice section. This operation is supported for billing
// accounts with agreement type Microsoft Customer Agreement.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
func (client *SubscriptionsClient) move(ctx context.Context, billingAccountName string, parameters TransferBillingSubscriptionRequestProperties, options *SubscriptionsClientBeginMoveOptions) (*http.Response, error) {
	req, err := client.moveCreateRequest(ctx, billingAccountName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// moveCreateRequest creates the Move request.
func (client *SubscriptionsClient) moveCreateRequest(ctx context.Context, billingAccountName string, parameters TransferBillingSubscriptionRequestProperties, options *SubscriptionsClientBeginMoveOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingSubscriptions/{subscriptionId}/move"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// Update - Updates the properties of a billing subscription. Currently, cost center can be updated. The operation is supported
// only for billing accounts with agreement type Microsoft Customer Agreement.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
// billingAccountName - The ID that uniquely identifies a billing account.
// parameters - Request parameters that are provided to the update billing subscription operation.
// options - SubscriptionsClientUpdateOptions contains the optional parameters for the SubscriptionsClient.Update method.
func (client *SubscriptionsClient) Update(ctx context.Context, billingAccountName string, parameters Subscription, options *SubscriptionsClientUpdateOptions) (SubscriptionsClientUpdateResponse, error) {
	req, err := client.updateCreateRequest(ctx, billingAccountName, parameters, options)
	if err != nil {
		return SubscriptionsClientUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SubscriptionsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SubscriptionsClientUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateHandleResponse(resp)
}

// updateCreateRequest creates the Update request.
func (client *SubscriptionsClient) updateCreateRequest(ctx context.Context, billingAccountName string, parameters Subscription, options *SubscriptionsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingSubscriptions/{subscriptionId}"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// updateHandleResponse handles the Update response.
func (client *SubscriptionsClient) updateHandleResponse(resp *http.Response) (SubscriptionsClientUpdateResponse, error) {
	result := SubscriptionsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Subscription); err != nil {
		return SubscriptionsClientUpdateResponse{}, err
	}
	return result, nil
}

// ValidateMove - Validates if a subscription's charges can be moved to a new invoice section. This operation is supported
// for billing accounts with agreement type Microsoft Customer Agreement.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
// billingAccountName - The ID that uniquely identifies a billing account.
// parameters - Request parameters that are provided to the validate move eligibility operation.
// options - SubscriptionsClientValidateMoveOptions contains the optional parameters for the SubscriptionsClient.ValidateMove
// method.
func (client *SubscriptionsClient) ValidateMove(ctx context.Context, billingAccountName string, parameters TransferBillingSubscriptionRequestProperties, options *SubscriptionsClientValidateMoveOptions) (SubscriptionsClientValidateMoveResponse, error) {
	req, err := client.validateMoveCreateRequest(ctx, billingAccountName, parameters, options)
	if err != nil {
		return SubscriptionsClientValidateMoveResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SubscriptionsClientValidateMoveResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SubscriptionsClientValidateMoveResponse{}, runtime.NewResponseError(resp)
	}
	return client.validateMoveHandleResponse(resp)
}

// validateMoveCreateRequest creates the ValidateMove request.
func (client *SubscriptionsClient) validateMoveCreateRequest(ctx context.Context, billingAccountName string, parameters TransferBillingSubscriptionRequestProperties, options *SubscriptionsClientValidateMoveOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingSubscriptions/{subscriptionId}/validateMoveEligibility"
	if billingAccountName == "" {
		return nil, errors.New("parameter billingAccountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{billingAccountName}", url.PathEscape(billingAccountName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// validateMoveHandleResponse handles the ValidateMove response.
func (client *SubscriptionsClient) validateMoveHandleResponse(resp *http.Response) (SubscriptionsClientValidateMoveResponse, error) {
	result := SubscriptionsClientValidateMoveResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ValidateSubscriptionTransferEligibilityResult); err != nil {
		return SubscriptionsClientValidateMoveResponse{}, err
	}
	return result, nil
}
