//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package azcertificates

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// Client contains the methods for the Client group.
// Don't use this type directly, use NewClient() instead.
type Client struct {
	endpoint string
	pl       runtime.Pipeline
}

// BackupCertificate - Requests that a backup of the specified certificate be downloaded to the client. All versions of the
// certificate will be downloaded. This operation requires the certificates/backup permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// certificateName - The name of the certificate.
// options - BackupCertificateOptions contains the optional parameters for the Client.BackupCertificate method.
func (client *Client) BackupCertificate(ctx context.Context, certificateName string, options *BackupCertificateOptions) (BackupCertificateResponse, error) {
	req, err := client.backupCertificateCreateRequest(ctx, certificateName, options)
	if err != nil {
		return BackupCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return BackupCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return BackupCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return client.backupCertificateHandleResponse(resp)
}

// backupCertificateCreateRequest creates the BackupCertificate request.
func (client *Client) backupCertificateCreateRequest(ctx context.Context, certificateName string, options *BackupCertificateOptions) (*policy.Request, error) {
	urlPath := "/certificates/{certificate-name}/backup"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(certificateName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// backupCertificateHandleResponse handles the BackupCertificate response.
func (client *Client) backupCertificateHandleResponse(resp *http.Response) (BackupCertificateResponse, error) {
	result := BackupCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupCertificateResult); err != nil {
		return BackupCertificateResponse{}, err
	}
	return result, nil
}

// CreateCertificate - If this is the first version, the certificate resource is created. This operation requires the certificates/create
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// certificateName - The name of the certificate.
// parameters - The parameters to create a certificate.
// options - CreateCertificateOptions contains the optional parameters for the Client.CreateCertificate method.
func (client *Client) CreateCertificate(ctx context.Context, certificateName string, parameters CreateCertificateParameters, options *CreateCertificateOptions) (CreateCertificateResponse, error) {
	req, err := client.createCertificateCreateRequest(ctx, certificateName, parameters, options)
	if err != nil {
		return CreateCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return CreateCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return CreateCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createCertificateHandleResponse(resp)
}

// createCertificateCreateRequest creates the CreateCertificate request.
func (client *Client) createCertificateCreateRequest(ctx context.Context, certificateName string, parameters CreateCertificateParameters, options *CreateCertificateOptions) (*policy.Request, error) {
	urlPath := "/certificates/{certificate-name}/create"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(certificateName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createCertificateHandleResponse handles the CreateCertificate response.
func (client *Client) createCertificateHandleResponse(resp *http.Response) (CreateCertificateResponse, error) {
	result := CreateCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateOperation); err != nil {
		return CreateCertificateResponse{}, err
	}
	return result, nil
}

// DeleteCertificate - Deletes all versions of a certificate object along with its associated policy. Delete certificate cannot
// be used to remove individual versions of a certificate object. This operation requires the
// certificates/delete permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// certificateName - The name of the certificate.
// options - DeleteCertificateOptions contains the optional parameters for the Client.DeleteCertificate method.
func (client *Client) DeleteCertificate(ctx context.Context, certificateName string, options *DeleteCertificateOptions) (DeleteCertificateResponse, error) {
	req, err := client.deleteCertificateCreateRequest(ctx, certificateName, options)
	if err != nil {
		return DeleteCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DeleteCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DeleteCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteCertificateHandleResponse(resp)
}

// deleteCertificateCreateRequest creates the DeleteCertificate request.
func (client *Client) deleteCertificateCreateRequest(ctx context.Context, certificateName string, options *DeleteCertificateOptions) (*policy.Request, error) {
	urlPath := "/certificates/{certificate-name}"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(certificateName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteCertificateHandleResponse handles the DeleteCertificate response.
func (client *Client) deleteCertificateHandleResponse(resp *http.Response) (DeleteCertificateResponse, error) {
	result := DeleteCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedCertificateBundle); err != nil {
		return DeleteCertificateResponse{}, err
	}
	return result, nil
}

// DeleteCertificateContacts - Deletes the certificate contacts for a specified key vault certificate. This operation requires
// the certificates/managecontacts permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// options - DeleteCertificateContactsOptions contains the optional parameters for the Client.DeleteCertificateContacts
// method.
func (client *Client) DeleteCertificateContacts(ctx context.Context, options *DeleteCertificateContactsOptions) (DeleteCertificateContactsResponse, error) {
	req, err := client.deleteCertificateContactsCreateRequest(ctx, options)
	if err != nil {
		return DeleteCertificateContactsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DeleteCertificateContactsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DeleteCertificateContactsResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteCertificateContactsHandleResponse(resp)
}

// deleteCertificateContactsCreateRequest creates the DeleteCertificateContacts request.
func (client *Client) deleteCertificateContactsCreateRequest(ctx context.Context, options *DeleteCertificateContactsOptions) (*policy.Request, error) {
	urlPath := "/certificates/contacts"
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteCertificateContactsHandleResponse handles the DeleteCertificateContacts response.
func (client *Client) deleteCertificateContactsHandleResponse(resp *http.Response) (DeleteCertificateContactsResponse, error) {
	result := DeleteCertificateContactsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Contacts); err != nil {
		return DeleteCertificateContactsResponse{}, err
	}
	return result, nil
}

// DeleteCertificateIssuer - The DeleteCertificateIssuer operation permanently removes the specified certificate issuer from
// the vault. This operation requires the certificates/manageissuers/deleteissuers permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// issuerName - The name of the issuer.
// options - DeleteCertificateIssuerOptions contains the optional parameters for the Client.DeleteCertificateIssuer
// method.
func (client *Client) DeleteCertificateIssuer(ctx context.Context, issuerName string, options *DeleteCertificateIssuerOptions) (DeleteCertificateIssuerResponse, error) {
	req, err := client.deleteCertificateIssuerCreateRequest(ctx, issuerName, options)
	if err != nil {
		return DeleteCertificateIssuerResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DeleteCertificateIssuerResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DeleteCertificateIssuerResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteCertificateIssuerHandleResponse(resp)
}

// deleteCertificateIssuerCreateRequest creates the DeleteCertificateIssuer request.
func (client *Client) deleteCertificateIssuerCreateRequest(ctx context.Context, issuerName string, options *DeleteCertificateIssuerOptions) (*policy.Request, error) {
	urlPath := "/certificates/issuers/{issuer-name}"
	if issuerName == "" {
		return nil, errors.New("parameter issuerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{issuer-name}", url.PathEscape(issuerName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteCertificateIssuerHandleResponse handles the DeleteCertificateIssuer response.
func (client *Client) deleteCertificateIssuerHandleResponse(resp *http.Response) (DeleteCertificateIssuerResponse, error) {
	result := DeleteCertificateIssuerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.IssuerBundle); err != nil {
		return DeleteCertificateIssuerResponse{}, err
	}
	return result, nil
}

// DeleteCertificateOperation - Deletes the creation operation for a specified certificate that is in the process of being
// created. The certificate is no longer created. This operation requires the certificates/update permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// certificateName - The name of the certificate.
// options - DeleteCertificateOperationOptions contains the optional parameters for the Client.DeleteCertificateOperation
// method.
func (client *Client) DeleteCertificateOperation(ctx context.Context, certificateName string, options *DeleteCertificateOperationOptions) (DeleteCertificateOperationResponse, error) {
	req, err := client.deleteCertificateOperationCreateRequest(ctx, certificateName, options)
	if err != nil {
		return DeleteCertificateOperationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return DeleteCertificateOperationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DeleteCertificateOperationResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteCertificateOperationHandleResponse(resp)
}

// deleteCertificateOperationCreateRequest creates the DeleteCertificateOperation request.
func (client *Client) deleteCertificateOperationCreateRequest(ctx context.Context, certificateName string, options *DeleteCertificateOperationOptions) (*policy.Request, error) {
	urlPath := "/certificates/{certificate-name}/pending"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(certificateName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteCertificateOperationHandleResponse handles the DeleteCertificateOperation response.
func (client *Client) deleteCertificateOperationHandleResponse(resp *http.Response) (DeleteCertificateOperationResponse, error) {
	result := DeleteCertificateOperationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateOperation); err != nil {
		return DeleteCertificateOperationResponse{}, err
	}
	return result, nil
}

// GetCertificate - Gets information about a specific certificate. This operation requires the certificates/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// certificateName - The name of the certificate in the given vault.
// certificateVersion - The version of the certificate. This URI fragment is optional. If not specified, the latest version
// of the certificate is returned.
// options - GetCertificateOptions contains the optional parameters for the Client.GetCertificate method.
func (client *Client) GetCertificate(ctx context.Context, certificateName string, certificateVersion string, options *GetCertificateOptions) (GetCertificateResponse, error) {
	req, err := client.getCertificateCreateRequest(ctx, certificateName, certificateVersion, options)
	if err != nil {
		return GetCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return GetCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return GetCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return client.getCertificateHandleResponse(resp)
}

// getCertificateCreateRequest creates the GetCertificate request.
func (client *Client) getCertificateCreateRequest(ctx context.Context, certificateName string, certificateVersion string, options *GetCertificateOptions) (*policy.Request, error) {
	urlPath := "/certificates/{certificate-name}/{certificate-version}"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(certificateName))
	urlPath = strings.ReplaceAll(urlPath, "{certificate-version}", url.PathEscape(certificateVersion))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getCertificateHandleResponse handles the GetCertificate response.
func (client *Client) getCertificateHandleResponse(resp *http.Response) (GetCertificateResponse, error) {
	result := GetCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateBundle); err != nil {
		return GetCertificateResponse{}, err
	}
	return result, nil
}

// GetCertificateContacts - The GetCertificateContacts operation returns the set of certificate contact resources in the specified
// key vault. This operation requires the certificates/managecontacts permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// options - GetCertificateContactsOptions contains the optional parameters for the Client.GetCertificateContacts method.
func (client *Client) GetCertificateContacts(ctx context.Context, options *GetCertificateContactsOptions) (GetCertificateContactsResponse, error) {
	req, err := client.getCertificateContactsCreateRequest(ctx, options)
	if err != nil {
		return GetCertificateContactsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return GetCertificateContactsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return GetCertificateContactsResponse{}, runtime.NewResponseError(resp)
	}
	return client.getCertificateContactsHandleResponse(resp)
}

// getCertificateContactsCreateRequest creates the GetCertificateContacts request.
func (client *Client) getCertificateContactsCreateRequest(ctx context.Context, options *GetCertificateContactsOptions) (*policy.Request, error) {
	urlPath := "/certificates/contacts"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getCertificateContactsHandleResponse handles the GetCertificateContacts response.
func (client *Client) getCertificateContactsHandleResponse(resp *http.Response) (GetCertificateContactsResponse, error) {
	result := GetCertificateContactsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Contacts); err != nil {
		return GetCertificateContactsResponse{}, err
	}
	return result, nil
}

// GetCertificateIssuer - The GetCertificateIssuer operation returns the specified certificate issuer resources in the specified
// key vault. This operation requires the certificates/manageissuers/getissuers permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// issuerName - The name of the issuer.
// options - GetCertificateIssuerOptions contains the optional parameters for the Client.GetCertificateIssuer method.
func (client *Client) GetCertificateIssuer(ctx context.Context, issuerName string, options *GetCertificateIssuerOptions) (GetCertificateIssuerResponse, error) {
	req, err := client.getCertificateIssuerCreateRequest(ctx, issuerName, options)
	if err != nil {
		return GetCertificateIssuerResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return GetCertificateIssuerResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return GetCertificateIssuerResponse{}, runtime.NewResponseError(resp)
	}
	return client.getCertificateIssuerHandleResponse(resp)
}

// getCertificateIssuerCreateRequest creates the GetCertificateIssuer request.
func (client *Client) getCertificateIssuerCreateRequest(ctx context.Context, issuerName string, options *GetCertificateIssuerOptions) (*policy.Request, error) {
	urlPath := "/certificates/issuers/{issuer-name}"
	if issuerName == "" {
		return nil, errors.New("parameter issuerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{issuer-name}", url.PathEscape(issuerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getCertificateIssuerHandleResponse handles the GetCertificateIssuer response.
func (client *Client) getCertificateIssuerHandleResponse(resp *http.Response) (GetCertificateIssuerResponse, error) {
	result := GetCertificateIssuerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.IssuerBundle); err != nil {
		return GetCertificateIssuerResponse{}, err
	}
	return result, nil
}

// GetCertificateOperation - Gets the creation operation associated with a specified certificate. This operation requires
// the certificates/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// certificateName - The name of the certificate.
// options - GetCertificateOperationOptions contains the optional parameters for the Client.GetCertificateOperation
// method.
func (client *Client) GetCertificateOperation(ctx context.Context, certificateName string, options *GetCertificateOperationOptions) (GetCertificateOperationResponse, error) {
	req, err := client.getCertificateOperationCreateRequest(ctx, certificateName, options)
	if err != nil {
		return GetCertificateOperationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return GetCertificateOperationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return GetCertificateOperationResponse{}, runtime.NewResponseError(resp)
	}
	return client.getCertificateOperationHandleResponse(resp)
}

// getCertificateOperationCreateRequest creates the GetCertificateOperation request.
func (client *Client) getCertificateOperationCreateRequest(ctx context.Context, certificateName string, options *GetCertificateOperationOptions) (*policy.Request, error) {
	urlPath := "/certificates/{certificate-name}/pending"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(certificateName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getCertificateOperationHandleResponse handles the GetCertificateOperation response.
func (client *Client) getCertificateOperationHandleResponse(resp *http.Response) (GetCertificateOperationResponse, error) {
	result := GetCertificateOperationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateOperation); err != nil {
		return GetCertificateOperationResponse{}, err
	}
	return result, nil
}

// GetCertificatePolicy - The GetCertificatePolicy operation returns the specified certificate policy resources in the specified
// key vault. This operation requires the certificates/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// certificateName - The name of the certificate in a given key vault.
// options - GetCertificatePolicyOptions contains the optional parameters for the Client.GetCertificatePolicy method.
func (client *Client) GetCertificatePolicy(ctx context.Context, certificateName string, options *GetCertificatePolicyOptions) (GetCertificatePolicyResponse, error) {
	req, err := client.getCertificatePolicyCreateRequest(ctx, certificateName, options)
	if err != nil {
		return GetCertificatePolicyResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return GetCertificatePolicyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return GetCertificatePolicyResponse{}, runtime.NewResponseError(resp)
	}
	return client.getCertificatePolicyHandleResponse(resp)
}

// getCertificatePolicyCreateRequest creates the GetCertificatePolicy request.
func (client *Client) getCertificatePolicyCreateRequest(ctx context.Context, certificateName string, options *GetCertificatePolicyOptions) (*policy.Request, error) {
	urlPath := "/certificates/{certificate-name}/policy"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(certificateName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getCertificatePolicyHandleResponse handles the GetCertificatePolicy response.
func (client *Client) getCertificatePolicyHandleResponse(resp *http.Response) (GetCertificatePolicyResponse, error) {
	result := GetCertificatePolicyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificatePolicy); err != nil {
		return GetCertificatePolicyResponse{}, err
	}
	return result, nil
}

// GetDeletedCertificate - The GetDeletedCertificate operation retrieves the deleted certificate information plus its attributes,
// such as retention interval, scheduled permanent deletion and the current deletion recovery level.
// This operation requires the certificates/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// certificateName - The name of the certificate
// options - GetDeletedCertificateOptions contains the optional parameters for the Client.GetDeletedCertificate method.
func (client *Client) GetDeletedCertificate(ctx context.Context, certificateName string, options *GetDeletedCertificateOptions) (GetDeletedCertificateResponse, error) {
	req, err := client.getDeletedCertificateCreateRequest(ctx, certificateName, options)
	if err != nil {
		return GetDeletedCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return GetDeletedCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return GetDeletedCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return client.getDeletedCertificateHandleResponse(resp)
}

// getDeletedCertificateCreateRequest creates the GetDeletedCertificate request.
func (client *Client) getDeletedCertificateCreateRequest(ctx context.Context, certificateName string, options *GetDeletedCertificateOptions) (*policy.Request, error) {
	urlPath := "/deletedcertificates/{certificate-name}"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(certificateName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDeletedCertificateHandleResponse handles the GetDeletedCertificate response.
func (client *Client) getDeletedCertificateHandleResponse(resp *http.Response) (GetDeletedCertificateResponse, error) {
	result := GetDeletedCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedCertificateBundle); err != nil {
		return GetDeletedCertificateResponse{}, err
	}
	return result, nil
}

// ImportCertificate - Imports an existing valid certificate, containing a private key, into Azure Key Vault. This operation
// requires the certificates/import permission. The certificate to be imported can be in either PFX
// or PEM format. If the certificate is in PEM format the PEM file must contain the key as well as x509 certificates. Key
// Vault will only accept a key in PKCS#8 format.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// certificateName - The name of the certificate.
// parameters - The parameters to import the certificate.
// options - ImportCertificateOptions contains the optional parameters for the Client.ImportCertificate method.
func (client *Client) ImportCertificate(ctx context.Context, certificateName string, parameters ImportCertificateParameters, options *ImportCertificateOptions) (ImportCertificateResponse, error) {
	req, err := client.importCertificateCreateRequest(ctx, certificateName, parameters, options)
	if err != nil {
		return ImportCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ImportCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ImportCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return client.importCertificateHandleResponse(resp)
}

// importCertificateCreateRequest creates the ImportCertificate request.
func (client *Client) importCertificateCreateRequest(ctx context.Context, certificateName string, parameters ImportCertificateParameters, options *ImportCertificateOptions) (*policy.Request, error) {
	urlPath := "/certificates/{certificate-name}/import"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(certificateName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// importCertificateHandleResponse handles the ImportCertificate response.
func (client *Client) importCertificateHandleResponse(resp *http.Response) (ImportCertificateResponse, error) {
	result := ImportCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateBundle); err != nil {
		return ImportCertificateResponse{}, err
	}
	return result, nil
}

// NewListCertificateIssuersPager - The GetCertificateIssuers operation returns the set of certificate issuer resources in
// the specified key vault. This operation requires the certificates/manageissuers/getissuers permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// options - ListCertificateIssuersOptions contains the optional parameters for the Client.ListCertificateIssuers method.
func (client *Client) NewListCertificateIssuersPager(options *ListCertificateIssuersOptions) *runtime.Pager[ListCertificateIssuersResponse] {
	return runtime.NewPager(runtime.PagingHandler[ListCertificateIssuersResponse]{
		More: func(page ListCertificateIssuersResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ListCertificateIssuersResponse) (ListCertificateIssuersResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCertificateIssuersCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ListCertificateIssuersResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ListCertificateIssuersResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ListCertificateIssuersResponse{}, runtime.NewResponseError(resp)
			}
			return client.listCertificateIssuersHandleResponse(resp)
		},
	})
}

// listCertificateIssuersCreateRequest creates the ListCertificateIssuers request.
func (client *Client) listCertificateIssuersCreateRequest(ctx context.Context, options *ListCertificateIssuersOptions) (*policy.Request, error) {
	urlPath := "/certificates/issuers"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.MaxResults != nil {
		reqQP.Set("maxresults", strconv.FormatInt(int64(*options.MaxResults), 10))
	}
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listCertificateIssuersHandleResponse handles the ListCertificateIssuers response.
func (client *Client) listCertificateIssuersHandleResponse(resp *http.Response) (ListCertificateIssuersResponse, error) {
	result := ListCertificateIssuersResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateIssuerListResult); err != nil {
		return ListCertificateIssuersResponse{}, err
	}
	return result, nil
}

// NewListCertificateVersionsPager - The GetCertificateVersions operation returns the versions of a certificate in the specified
// key vault. This operation requires the certificates/list permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// certificateName - The name of the certificate.
// options - ListCertificateVersionsOptions contains the optional parameters for the Client.ListCertificateVersions
// method.
func (client *Client) NewListCertificateVersionsPager(certificateName string, options *ListCertificateVersionsOptions) *runtime.Pager[ListCertificateVersionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ListCertificateVersionsResponse]{
		More: func(page ListCertificateVersionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ListCertificateVersionsResponse) (ListCertificateVersionsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCertificateVersionsCreateRequest(ctx, certificateName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ListCertificateVersionsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ListCertificateVersionsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ListCertificateVersionsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listCertificateVersionsHandleResponse(resp)
		},
	})
}

// listCertificateVersionsCreateRequest creates the ListCertificateVersions request.
func (client *Client) listCertificateVersionsCreateRequest(ctx context.Context, certificateName string, options *ListCertificateVersionsOptions) (*policy.Request, error) {
	urlPath := "/certificates/{certificate-name}/versions"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(certificateName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.MaxResults != nil {
		reqQP.Set("maxresults", strconv.FormatInt(int64(*options.MaxResults), 10))
	}
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listCertificateVersionsHandleResponse handles the ListCertificateVersions response.
func (client *Client) listCertificateVersionsHandleResponse(resp *http.Response) (ListCertificateVersionsResponse, error) {
	result := ListCertificateVersionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateListResult); err != nil {
		return ListCertificateVersionsResponse{}, err
	}
	return result, nil
}

// NewListCertificatesPager - The GetCertificates operation returns the set of certificates resources in the specified key
// vault. This operation requires the certificates/list permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// options - ListCertificatesOptions contains the optional parameters for the Client.ListCertificates method.
func (client *Client) NewListCertificatesPager(options *ListCertificatesOptions) *runtime.Pager[ListCertificatesResponse] {
	return runtime.NewPager(runtime.PagingHandler[ListCertificatesResponse]{
		More: func(page ListCertificatesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ListCertificatesResponse) (ListCertificatesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCertificatesCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ListCertificatesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ListCertificatesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ListCertificatesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listCertificatesHandleResponse(resp)
		},
	})
}

// listCertificatesCreateRequest creates the ListCertificates request.
func (client *Client) listCertificatesCreateRequest(ctx context.Context, options *ListCertificatesOptions) (*policy.Request, error) {
	urlPath := "/certificates"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.MaxResults != nil {
		reqQP.Set("maxresults", strconv.FormatInt(int64(*options.MaxResults), 10))
	}
	if options != nil && options.IncludePending != nil {
		reqQP.Set("includePending", strconv.FormatBool(*options.IncludePending))
	}
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listCertificatesHandleResponse handles the ListCertificates response.
func (client *Client) listCertificatesHandleResponse(resp *http.Response) (ListCertificatesResponse, error) {
	result := ListCertificatesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateListResult); err != nil {
		return ListCertificatesResponse{}, err
	}
	return result, nil
}

// NewListDeletedCertificatesPager - The GetDeletedCertificates operation retrieves the certificates in the current vault
// which are in a deleted state and ready for recovery or purging. This operation includes deletion-specific
// information. This operation requires the certificates/get/list permission. This operation can only be enabled on soft-delete
// enabled vaults.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// options - ListDeletedCertificatesOptions contains the optional parameters for the Client.ListDeletedCertificates
// method.
func (client *Client) NewListDeletedCertificatesPager(options *ListDeletedCertificatesOptions) *runtime.Pager[ListDeletedCertificatesResponse] {
	return runtime.NewPager(runtime.PagingHandler[ListDeletedCertificatesResponse]{
		More: func(page ListDeletedCertificatesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ListDeletedCertificatesResponse) (ListDeletedCertificatesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listDeletedCertificatesCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ListDeletedCertificatesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ListDeletedCertificatesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ListDeletedCertificatesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listDeletedCertificatesHandleResponse(resp)
		},
	})
}

// listDeletedCertificatesCreateRequest creates the ListDeletedCertificates request.
func (client *Client) listDeletedCertificatesCreateRequest(ctx context.Context, options *ListDeletedCertificatesOptions) (*policy.Request, error) {
	urlPath := "/deletedcertificates"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.MaxResults != nil {
		reqQP.Set("maxresults", strconv.FormatInt(int64(*options.MaxResults), 10))
	}
	if options != nil && options.IncludePending != nil {
		reqQP.Set("includePending", strconv.FormatBool(*options.IncludePending))
	}
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDeletedCertificatesHandleResponse handles the ListDeletedCertificates response.
func (client *Client) listDeletedCertificatesHandleResponse(resp *http.Response) (ListDeletedCertificatesResponse, error) {
	result := ListDeletedCertificatesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedCertificateListResult); err != nil {
		return ListDeletedCertificatesResponse{}, err
	}
	return result, nil
}

// MergeCertificate - The MergeCertificate operation performs the merging of a certificate or certificate chain with a key
// pair currently available in the service. This operation requires the certificates/create
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// certificateName - The name of the certificate.
// parameters - The parameters to merge certificate.
// options - MergeCertificateOptions contains the optional parameters for the Client.MergeCertificate method.
func (client *Client) MergeCertificate(ctx context.Context, certificateName string, parameters MergeCertificateParameters, options *MergeCertificateOptions) (MergeCertificateResponse, error) {
	req, err := client.mergeCertificateCreateRequest(ctx, certificateName, parameters, options)
	if err != nil {
		return MergeCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return MergeCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return MergeCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return client.mergeCertificateHandleResponse(resp)
}

// mergeCertificateCreateRequest creates the MergeCertificate request.
func (client *Client) mergeCertificateCreateRequest(ctx context.Context, certificateName string, parameters MergeCertificateParameters, options *MergeCertificateOptions) (*policy.Request, error) {
	urlPath := "/certificates/{certificate-name}/pending/merge"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(certificateName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// mergeCertificateHandleResponse handles the MergeCertificate response.
func (client *Client) mergeCertificateHandleResponse(resp *http.Response) (MergeCertificateResponse, error) {
	result := MergeCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateBundle); err != nil {
		return MergeCertificateResponse{}, err
	}
	return result, nil
}

// PurgeDeletedCertificate - The PurgeDeletedCertificate operation performs an irreversible deletion of the specified certificate,
// without possibility for recovery. The operation is not available if the recovery level does not
// specify 'Purgeable'. This operation requires the certificate/purge permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// certificateName - The name of the certificate
// options - PurgeDeletedCertificateOptions contains the optional parameters for the Client.PurgeDeletedCertificate
// method.
func (client *Client) PurgeDeletedCertificate(ctx context.Context, certificateName string, options *PurgeDeletedCertificateOptions) (PurgeDeletedCertificateResponse, error) {
	req, err := client.purgeDeletedCertificateCreateRequest(ctx, certificateName, options)
	if err != nil {
		return PurgeDeletedCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PurgeDeletedCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return PurgeDeletedCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return PurgeDeletedCertificateResponse{}, nil
}

// purgeDeletedCertificateCreateRequest creates the PurgeDeletedCertificate request.
func (client *Client) purgeDeletedCertificateCreateRequest(ctx context.Context, certificateName string, options *PurgeDeletedCertificateOptions) (*policy.Request, error) {
	urlPath := "/deletedcertificates/{certificate-name}"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(certificateName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// RecoverDeletedCertificate - The RecoverDeletedCertificate operation performs the reversal of the Delete operation. The
// operation is applicable in vaults enabled for soft-delete, and must be issued during the retention interval
// (available in the deleted certificate's attributes). This operation requires the certificates/recover permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// certificateName - The name of the deleted certificate
// options - RecoverDeletedCertificateOptions contains the optional parameters for the Client.RecoverDeletedCertificate
// method.
func (client *Client) RecoverDeletedCertificate(ctx context.Context, certificateName string, options *RecoverDeletedCertificateOptions) (RecoverDeletedCertificateResponse, error) {
	req, err := client.recoverDeletedCertificateCreateRequest(ctx, certificateName, options)
	if err != nil {
		return RecoverDeletedCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return RecoverDeletedCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return RecoverDeletedCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return client.recoverDeletedCertificateHandleResponse(resp)
}

// recoverDeletedCertificateCreateRequest creates the RecoverDeletedCertificate request.
func (client *Client) recoverDeletedCertificateCreateRequest(ctx context.Context, certificateName string, options *RecoverDeletedCertificateOptions) (*policy.Request, error) {
	urlPath := "/deletedcertificates/{certificate-name}/recover"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(certificateName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// recoverDeletedCertificateHandleResponse handles the RecoverDeletedCertificate response.
func (client *Client) recoverDeletedCertificateHandleResponse(resp *http.Response) (RecoverDeletedCertificateResponse, error) {
	result := RecoverDeletedCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateBundle); err != nil {
		return RecoverDeletedCertificateResponse{}, err
	}
	return result, nil
}

// RestoreCertificate - Restores a backed up certificate, and all its versions, to a vault. This operation requires the certificates/restore
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// parameters - The parameters to restore the certificate.
// options - RestoreCertificateOptions contains the optional parameters for the Client.RestoreCertificate method.
func (client *Client) RestoreCertificate(ctx context.Context, parameters RestoreCertificateParameters, options *RestoreCertificateOptions) (RestoreCertificateResponse, error) {
	req, err := client.restoreCertificateCreateRequest(ctx, parameters, options)
	if err != nil {
		return RestoreCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return RestoreCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return RestoreCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return client.restoreCertificateHandleResponse(resp)
}

// restoreCertificateCreateRequest creates the RestoreCertificate request.
func (client *Client) restoreCertificateCreateRequest(ctx context.Context, parameters RestoreCertificateParameters, options *RestoreCertificateOptions) (*policy.Request, error) {
	urlPath := "/certificates/restore"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// restoreCertificateHandleResponse handles the RestoreCertificate response.
func (client *Client) restoreCertificateHandleResponse(resp *http.Response) (RestoreCertificateResponse, error) {
	result := RestoreCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateBundle); err != nil {
		return RestoreCertificateResponse{}, err
	}
	return result, nil
}

// SetCertificateContacts - Sets the certificate contacts for the specified key vault. This operation requires the certificates/managecontacts
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// contacts - The contacts for the key vault certificate.
// options - SetCertificateContactsOptions contains the optional parameters for the Client.SetCertificateContacts method.
func (client *Client) SetCertificateContacts(ctx context.Context, contacts Contacts, options *SetCertificateContactsOptions) (SetCertificateContactsResponse, error) {
	req, err := client.setCertificateContactsCreateRequest(ctx, contacts, options)
	if err != nil {
		return SetCertificateContactsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SetCertificateContactsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SetCertificateContactsResponse{}, runtime.NewResponseError(resp)
	}
	return client.setCertificateContactsHandleResponse(resp)
}

// setCertificateContactsCreateRequest creates the SetCertificateContacts request.
func (client *Client) setCertificateContactsCreateRequest(ctx context.Context, contacts Contacts, options *SetCertificateContactsOptions) (*policy.Request, error) {
	urlPath := "/certificates/contacts"
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, contacts)
}

// setCertificateContactsHandleResponse handles the SetCertificateContacts response.
func (client *Client) setCertificateContactsHandleResponse(resp *http.Response) (SetCertificateContactsResponse, error) {
	result := SetCertificateContactsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Contacts); err != nil {
		return SetCertificateContactsResponse{}, err
	}
	return result, nil
}

// SetCertificateIssuer - The SetCertificateIssuer operation adds or updates the specified certificate issuer. This operation
// requires the certificates/setissuers permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// issuerName - The name of the issuer.
// parameter - Certificate issuer set parameter.
// options - SetCertificateIssuerOptions contains the optional parameters for the Client.SetCertificateIssuer method.
func (client *Client) SetCertificateIssuer(ctx context.Context, issuerName string, parameter SetCertificateIssuerParameters, options *SetCertificateIssuerOptions) (SetCertificateIssuerResponse, error) {
	req, err := client.setCertificateIssuerCreateRequest(ctx, issuerName, parameter, options)
	if err != nil {
		return SetCertificateIssuerResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SetCertificateIssuerResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SetCertificateIssuerResponse{}, runtime.NewResponseError(resp)
	}
	return client.setCertificateIssuerHandleResponse(resp)
}

// setCertificateIssuerCreateRequest creates the SetCertificateIssuer request.
func (client *Client) setCertificateIssuerCreateRequest(ctx context.Context, issuerName string, parameter SetCertificateIssuerParameters, options *SetCertificateIssuerOptions) (*policy.Request, error) {
	urlPath := "/certificates/issuers/{issuer-name}"
	if issuerName == "" {
		return nil, errors.New("parameter issuerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{issuer-name}", url.PathEscape(issuerName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameter)
}

// setCertificateIssuerHandleResponse handles the SetCertificateIssuer response.
func (client *Client) setCertificateIssuerHandleResponse(resp *http.Response) (SetCertificateIssuerResponse, error) {
	result := SetCertificateIssuerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.IssuerBundle); err != nil {
		return SetCertificateIssuerResponse{}, err
	}
	return result, nil
}

// UpdateCertificate - The UpdateCertificate operation applies the specified update on the given certificate; the only elements
// updated are the certificate's attributes. This operation requires the certificates/update
// permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// certificateName - The name of the certificate in the given key vault.
// certificateVersion - The version of the certificate.
// parameters - The parameters for certificate update.
// options - UpdateCertificateOptions contains the optional parameters for the Client.UpdateCertificate method.
func (client *Client) UpdateCertificate(ctx context.Context, certificateName string, certificateVersion string, parameters UpdateCertificateParameters, options *UpdateCertificateOptions) (UpdateCertificateResponse, error) {
	req, err := client.updateCertificateCreateRequest(ctx, certificateName, certificateVersion, parameters, options)
	if err != nil {
		return UpdateCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return UpdateCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return UpdateCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateCertificateHandleResponse(resp)
}

// updateCertificateCreateRequest creates the UpdateCertificate request.
func (client *Client) updateCertificateCreateRequest(ctx context.Context, certificateName string, certificateVersion string, parameters UpdateCertificateParameters, options *UpdateCertificateOptions) (*policy.Request, error) {
	urlPath := "/certificates/{certificate-name}/{certificate-version}"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(certificateName))
	urlPath = strings.ReplaceAll(urlPath, "{certificate-version}", url.PathEscape(certificateVersion))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// updateCertificateHandleResponse handles the UpdateCertificate response.
func (client *Client) updateCertificateHandleResponse(resp *http.Response) (UpdateCertificateResponse, error) {
	result := UpdateCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateBundle); err != nil {
		return UpdateCertificateResponse{}, err
	}
	return result, nil
}

// UpdateCertificateIssuer - The UpdateCertificateIssuer operation performs an update on the specified certificate issuer
// entity. This operation requires the certificates/setissuers permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// issuerName - The name of the issuer.
// parameter - Certificate issuer update parameter.
// options - UpdateCertificateIssuerOptions contains the optional parameters for the Client.UpdateCertificateIssuer
// method.
func (client *Client) UpdateCertificateIssuer(ctx context.Context, issuerName string, parameter UpdateCertificateIssuerParameters, options *UpdateCertificateIssuerOptions) (UpdateCertificateIssuerResponse, error) {
	req, err := client.updateCertificateIssuerCreateRequest(ctx, issuerName, parameter, options)
	if err != nil {
		return UpdateCertificateIssuerResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return UpdateCertificateIssuerResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return UpdateCertificateIssuerResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateCertificateIssuerHandleResponse(resp)
}

// updateCertificateIssuerCreateRequest creates the UpdateCertificateIssuer request.
func (client *Client) updateCertificateIssuerCreateRequest(ctx context.Context, issuerName string, parameter UpdateCertificateIssuerParameters, options *UpdateCertificateIssuerOptions) (*policy.Request, error) {
	urlPath := "/certificates/issuers/{issuer-name}"
	if issuerName == "" {
		return nil, errors.New("parameter issuerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{issuer-name}", url.PathEscape(issuerName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameter)
}

// updateCertificateIssuerHandleResponse handles the UpdateCertificateIssuer response.
func (client *Client) updateCertificateIssuerHandleResponse(resp *http.Response) (UpdateCertificateIssuerResponse, error) {
	result := UpdateCertificateIssuerResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.IssuerBundle); err != nil {
		return UpdateCertificateIssuerResponse{}, err
	}
	return result, nil
}

// UpdateCertificateOperation - Updates a certificate creation operation that is already in progress. This operation requires
// the certificates/update permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// certificateName - The name of the certificate.
// certificateOperation - The certificate operation response.
// options - UpdateCertificateOperationOptions contains the optional parameters for the Client.UpdateCertificateOperation
// method.
func (client *Client) UpdateCertificateOperation(ctx context.Context, certificateName string, certificateOperation UpdateCertificateOperationParameter, options *UpdateCertificateOperationOptions) (UpdateCertificateOperationResponse, error) {
	req, err := client.updateCertificateOperationCreateRequest(ctx, certificateName, certificateOperation, options)
	if err != nil {
		return UpdateCertificateOperationResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return UpdateCertificateOperationResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return UpdateCertificateOperationResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateCertificateOperationHandleResponse(resp)
}

// updateCertificateOperationCreateRequest creates the UpdateCertificateOperation request.
func (client *Client) updateCertificateOperationCreateRequest(ctx context.Context, certificateName string, certificateOperation UpdateCertificateOperationParameter, options *UpdateCertificateOperationOptions) (*policy.Request, error) {
	urlPath := "/certificates/{certificate-name}/pending"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(certificateName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, certificateOperation)
}

// updateCertificateOperationHandleResponse handles the UpdateCertificateOperation response.
func (client *Client) updateCertificateOperationHandleResponse(resp *http.Response) (UpdateCertificateOperationResponse, error) {
	result := UpdateCertificateOperationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificateOperation); err != nil {
		return UpdateCertificateOperationResponse{}, err
	}
	return result, nil
}

// UpdateCertificatePolicy - Set specified members in the certificate policy. Leave others as null. This operation requires
// the certificates/update permission.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 7.3
// certificateName - The name of the certificate in the given vault.
// certificatePolicy - The policy for the certificate.
// options - UpdateCertificatePolicyOptions contains the optional parameters for the Client.UpdateCertificatePolicy
// method.
func (client *Client) UpdateCertificatePolicy(ctx context.Context, certificateName string, certificatePolicy CertificatePolicy, options *UpdateCertificatePolicyOptions) (UpdateCertificatePolicyResponse, error) {
	req, err := client.updateCertificatePolicyCreateRequest(ctx, certificateName, certificatePolicy, options)
	if err != nil {
		return UpdateCertificatePolicyResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return UpdateCertificatePolicyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return UpdateCertificatePolicyResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateCertificatePolicyHandleResponse(resp)
}

// updateCertificatePolicyCreateRequest creates the UpdateCertificatePolicy request.
func (client *Client) updateCertificatePolicyCreateRequest(ctx context.Context, certificateName string, certificatePolicy CertificatePolicy, options *UpdateCertificatePolicyOptions) (*policy.Request, error) {
	urlPath := "/certificates/{certificate-name}/policy"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificate-name}", url.PathEscape(certificateName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.endpoint, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.3")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, certificatePolicy)
}

// updateCertificatePolicyHandleResponse handles the UpdateCertificatePolicy response.
func (client *Client) updateCertificatePolicyHandleResponse(resp *http.Response) (UpdateCertificatePolicyResponse, error) {
	result := UpdateCertificatePolicyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CertificatePolicy); err != nil {
		return UpdateCertificatePolicyResponse{}, err
	}
	return result, nil
}
