package main

import (
	"time"

	"github.com/gin-gonic/gin"
	"github.com/google/uuid"
	"github.com/heysion/deepin-system-update-tools/internal/config/cache"
	"github.com/heysion/deepin-system-update-tools/pkg/utils/ecode"
	response "github.com/heysion/deepin-system-update-tools/pkg/utils/http"
)

type Payload struct {
	Data map[string]interface{} `json:"data"`
}

func main() {
	r := gin.Default()

	r.POST("/fetch", func(c *gin.Context) {
		var payload Payload

		if err := c.ShouldBindJSON(&payload); err != nil {
			response.JSON(c, response.WithCode(ecode.BadRequest))
			return
		}

		// jsonData, err := json.Marshal(UpdateInfo{})
		// if err != nil {
		// 	response.JSON(c, response.WithCode(ecode.InternalServerError))
		// 	return
		// }
		UpdateInfo := &cache.UpdateInfo{
			RepoBackend: []cache.RepoInfo{
				{
					Type:       "deb",
					URL:        "https://pools.uniontech.com/desktop-professional",
					Suite:      "eagle/1050",
					Components: []string{"main", "non-free", "contrib"},
				},
				{
					Type:       "deb",
					URL:        "https://pools.uniontech.com/desktop-professional",
					Suite:      "eagle/1050",
					Components: []string{"main", "non-free", "contrib"},
				},
				{
					Type:       "deb",
					URL:        "https://pools.uniontech.com/desktop-professional",
					Suite:      "eagle/1050",
					Components: []string{"main", "non-free", "contrib"},
				},
			},
			PkgList: []cache.AppInfo{
				{
					Name:    "systemd",
					Version: "241.34-1+dde",
				},
				{
					Name:    "libsystemd0",
					Version: "241.34-1+dde",
				},
				{
					Name:    "libpam-systemd",
					Version: "241.34-1+dde",
				},
				{
					Name:    "libnss-systemd",
					Version: "241.34-1+dde",
				},
			},
			SysCoreList: []cache.AppInfo{
				{
					Name:    "systemd",
					Version: "241.50-1+deepin1",
					Need:    "strict",
				},
				{
					Name:    "startdde",
					Version: "5.10.8.3-1",
					Need:    "true",
				},
				{
					Name:    "libdtkgui5",
					Version: "5.6.8-1",
					Need:    "true",
				},
			},
			FreezeList: []cache.AppInfo{
				{
					Name:    "dpkg",
					Version: "1.19.7.15-1+dde",
					Need:    "true",
				},
			},
			OptionList: []cache.AppInfo{
				{
					Name:    "org.deepin.scanner",
					Version: "5.5.15-1",
					Need:    "false",
				},
			},
		}
		response.JSON(c, response.WithData(UpdateInfo))
	})

	r.POST("/update", func(c *gin.Context) {
		var payload Payload

		if err := c.ShouldBindJSON(&payload); err != nil {
			c.JSON(400, gin.H{"error": err.Error()})
			return
		}

		c.JSON(200, gin.H{
			"message": "Data updated successfully",
			"time":    time.Now().Format(time.RFC3339),
			"uuid":    uuid.New().String(),
			"data":    payload.Data,
		})
	})

	r.Run() // Listen and serve on 0.0.0.0:8080
}
