
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nickycopeland@hotmail.com> 1996,2012
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 * These need to be redone. Each white key should be placed first, then the
 * black keys layered on top. That way we can get better graphics with shading
 * on the white keys for each black key.
 */

#ifndef BRIGHTONKEYBOARD_H
#define BRIGHTONKEYBOARD_H

extern guimain global;

#define KEY_COUNT 61
#define KEY_COUNT_2OCTAVE 29
#define KEY_COUNT_2OCTAVE2 32
#define KEY_COUNT_3OCTAVE 44
#define KEY_COUNT_3_OCTAVE 37
#define KEY_COUNT_4OCTAVE 49
#define KEY_COUNT_PEDAL 24
#define VKEY_COUNT 48
#define KEY_COUNT_5OCTAVE KEY_COUNT
#define KEY_COUNT_6_OCTAVE 73

/*
 * This whole definition should be moved into a separate routine, and called
 * for a given keyboard size - 37 note (three oct), 61 note (5 oct) or a full
 * 88 keys. Should also consider 73 note for a Rhodes....
 */
#define KW (1000 / 36)
#define FKW (995 - 35 * KW)
#define KFBW ((KW * 3) / 2)
#define KFWD ((KW * 3) / 4)

#define KMW 20
#define KIW 28
#define KIH 666
#define KIL 334
#define KIS 0

brightonLocations keys[KEY_COUNT_5OCTAVE] = {
	{"", 2, 0 * KW, 0, KFWD, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 0 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp4.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp4.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 2 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * KW, 0, KFWD, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 6 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 7 * KW, 0, KFWD, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 7 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 9 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * KW, 0, KFWD, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 13 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 14 * KW, 0, KFWD, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 14 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 16 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * KW, 0, KFWD, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 20 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 21 * KW, 0, KFWD, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 21 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 23 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * KW, 0, KFWD, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 26 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 26 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 27 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 28 * KW, 0, KFWD, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 28 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 29 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 29 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 30 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 31 * KW, 0, KFWD, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 31 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 32 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 32 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 33 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 33 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp4.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 34 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 35 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteLUp.xpm", "bitmaps/newkeys/WhiteLDown.xpm", BRIGHTON_NOSHADOW},
};

brightonLocations keysprofile2[KEY_COUNT_5OCTAVE] = {
	{"", 2, 0 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 0 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 2 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 6 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 7 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 7 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 9 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 13 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 14 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 14 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 16 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 20 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 21 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 21 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 23 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 26 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 26 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 27 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 28 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 28 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 29 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 29 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 30 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 31 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 31 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 32 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 32 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 33 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 33 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 34 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 35 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHLUp.xpm", "bitmaps/newkeys/WhiteNHLDown.xpm", BRIGHTON_NOSHADOW},
}; /* Profiles2 */

brightonLocations keysprofile[KEY_COUNT_5OCTAVE] = {
	{"", 2, 0 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 0 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp4.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 2 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 6 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 7 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 7 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 9 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 13 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 14 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 14 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 16 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 20 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 21 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 21 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 23 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 26 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 26 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 27 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 28 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 28 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 29 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 29 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 30 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 31 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 31 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 32 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 32 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 33 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 33 * KW + KW/2, 0, KW, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp4.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 34 * KW, KIH, KW, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 35 * KW, 0, KW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHLUp.xpm", "bitmaps/newkeys/WhiteHLDown.xpm", BRIGHTON_NOSHADOW},
};

#define K6W 1000 / 43
#define F6KW 1000 - 43 * KW

#define K6FW (K6W * 3 / 4)

#define K6MW 13
#define K6IW 22
#define K6IH 666
#define K6IL 334
#define K6IS 20

brightonLocations keys6octave[KEY_COUNT_6_OCTAVE] = {
	{"", 2, 0 * K6W, 0, K6FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteDFUp.xpm", "bitmaps/newkeys/WhiteDFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 0 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 2 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * K6W, 0, K6FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteDFUp.xpm", "bitmaps/newkeys/WhiteDFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 6 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 7 * K6W, 0, K6FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteDFUp.xpm", "bitmaps/newkeys/WhiteDFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 7 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 9 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * K6W, 0, K6FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteDFUp.xpm", "bitmaps/newkeys/WhiteDFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 13 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 14 * K6W, 0, K6FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteDFUp.xpm", "bitmaps/newkeys/WhiteDFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 14 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 16 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * K6W, 0, K6FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteDFUp.xpm", "bitmaps/newkeys/WhiteDFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 20 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 21 * K6W, 0, K6FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteDFUp.xpm", "bitmaps/newkeys/WhiteDFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 21 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 23 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * K6W, 0, K6FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteDFUp.xpm", "bitmaps/newkeys/WhiteDFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 26 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 26 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 27 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 28 * K6W, 0, K6FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteDFUp.xpm", "bitmaps/newkeys/WhiteDFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 28 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 29 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 29 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 30 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 31 * K6W, 0, K6FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteDFUp.xpm", "bitmaps/newkeys/WhiteDFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 31 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 32 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 32 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 33 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 33 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 34 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 35 * K6W, 0, K6FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteDFUp.xpm", "bitmaps/newkeys/WhiteDFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 35 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 36 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 36 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 37 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 38 * K6W, 0, K6FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteDFUp.xpm", "bitmaps/newkeys/WhiteDFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 38 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 39 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 39 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 40 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 40 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 41 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 42 * K6W, 0, K6W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteLUp.xpm", "bitmaps/newkeys/WhiteLDown.xpm", BRIGHTON_NOSHADOW},
};

/*
 * These were done for the newer hammond keys but will be used elsewhere
 */
brightonLocations keys6hammond[KEY_COUNT_6_OCTAVE] = {
	{"", 2, 0 * K6W, 0, K6W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFRUp.xpm", "bitmaps/newkeys/WhiteFRDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 0 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackRUp.xpm", "bitmaps/newkeys/BlackRDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteRUp.xpm", "bitmaps/newkeys/WhiteRDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackRUp.xpm", "bitmaps/newkeys/BlackRDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 2 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteRUp.xpm", "bitmaps/newkeys/WhiteRDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * K6W, 0, K6W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFRUp.xpm", "bitmaps/newkeys/WhiteFRDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackRUp.xpm", "bitmaps/newkeys/BlackRDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteRUp.xpm", "bitmaps/newkeys/WhiteRDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackRUp.xpm", "bitmaps/newkeys/BlackRDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteRUp.xpm", "bitmaps/newkeys/WhiteRDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackRUp.xpm", "bitmaps/newkeys/BlackRDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 6 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteRUp.xpm", "bitmaps/newkeys/WhiteRDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 7 * K6W, 0, K6W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 7 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 9 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * K6W, 0, K6W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 13 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 14 * K6W, 0, K6W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 14 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 16 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * K6W, 0, K6W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 20 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 21 * K6W, 0, K6W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 21 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 23 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * K6W, 0, K6W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 26 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 26 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 27 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 28 * K6W, 0, K6W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 28 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp2.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 29 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 29 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 30 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 31 * K6W, 0, K6W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 31 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 32 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 32 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 33 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 33 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 34 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 35 * K6W, 0, K6W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 35 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp3.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 36 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 36 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp4.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 37 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 38 * K6W, 0, K6W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 38 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp4.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 39 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 39 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp4.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 40 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 40 * K6W + K6W/2, 0, K6W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp4.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 41 * K6W, KIH, K6W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 42 * K6W, 0, K6W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHLUp.xpm", "bitmaps/newkeys/WhiteHLDown.xpm", BRIGHTON_NOSHADOW},
};

#define K2W (1000 / 17)
#define K2FW (K2W * 3 / 4)

#define K2MW 18
#define K2IW 40
#define K2IH 600
#define K2IL 410
#define K2IS 33

brightonLocations keys2octave[KEY_COUNT_2OCTAVE] = {
	{"", 2, 0 * K2W, 0, K2FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 0 * K2W + K2W/2, 0, K2W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * K2W, KIH, K2W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * K2W + K2W/2, 0, K2W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 2 * K2W, KIH, K2W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * K2W, 0, K2FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * K2W + K2W/2, 0, K2W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * K2W, KIH, K2W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * K2W + K2W/2, 0, K2W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * K2W, KIH, K2W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * K2W + K2W/2, 0, K2W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 6 * K2W, KIH, K2W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 7 * K2W, 0, K2FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 7 * K2W + K2W/2, 0, K2W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * K2W, KIH, K2W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * K2W + K2W/2, 0, K2W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 9 * K2W, KIH, K2W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * K2W, 0, K2FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * K2W + K2W/2, 0, K2W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * K2W, KIH, K2W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * K2W + K2W/2, 0, K2W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * K2W, KIH, K2W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * K2W + K2W/2, 0, K2W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 13 * K2W, KIH, K2W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 14 * K2W, 0, K2FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 14 * K2W + K2W/2, 0, K2W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * K2W, KIH, K2W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * K2W + K2W/2, 0, K2W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 16 * K2W, KIH, K2W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
/*	{"", 2, 17 * K2W, 0, K2FW, 1000, 0, 1, 0, */
/*		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW}, */
};

#define K22W (1000 / 19)
#define K22FW (K22W * 3 / 4)

#define K22MW 18
#define K22IW 40
#define K22IH 600
#define K22IL 410
#define K22IS 33

brightonLocations keys2octave2[KEY_COUNT_2OCTAVE2] = {
	{"", 2, 0 * K22W, 0, K22FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 0 * K22W + K22W/2, 0, K22W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * K22W, KIH, K22W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * K22W + K22W/2, 0, K22W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 2 * K22W, KIH, K22W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 2 * K22W + K22W/2, 0, K22W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * K22W, KIH, K22W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * K22W, 0, K22FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * K22W + K22W/2, 0, K22W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * K22W, KIH, K22W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * K22W + K22W/2, 0, K22W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 6 * K22W, KIH, K22W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 7 * K22W, 0, K22FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 7 * K22W + K22W/2, 0, K22W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * K22W, KIH, K22W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * K22W + K22W/2, 0, K22W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 9 * K22W, KIH, K22W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 9 * K22W + K22W/2, 0, K22W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * K22W, KIH, K22W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * K22W, 0, K22FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * K22W + K22W/2, 0, K22W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * K22W, KIH, K22W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * K22W + K22W/2, 0, K22W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 13 * K22W, KIH, K22W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 14 * K22W, 0, K22FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 14 * K22W + K22W/2, 0, K22W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * K22W, KIH, K22W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * K22W + K22W/2, 0, K22W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 16 * K22W, KIH, K22W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 16 * K22W + K22W/2, 0, K22W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * K22W, KIH, K22W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 18 * K22W, 0, K22W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteLUp.xpm", "bitmaps/newkeys/WhiteLDown.xpm", BRIGHTON_NOSHADOW},
};

#define K3W (1000 / 26)
//#define K3FW (K3W * 3 / 4)
#define K3FW K3W

#define K3MW 18
#define K3IW 40
#define K3IH 650
#define K3IL 350
#define K3IS 33

brightonLocations keys3octave[KEY_COUNT_3OCTAVE] = {
	{"", 2, 0 * K3W, 0, K3FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 0 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 2 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * K3W, 0, K3FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 6 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 7 * K3W, 0, K3FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 7 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 9 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * K3W, 0, K3FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 13 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 14 * K3W, 0, K3FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 14 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 16 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * K3W, 0, K3FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 20 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 21 * K3W, 0, K3FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 21 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 23 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * K3W, 0, K3FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteFUp.xpm", "bitmaps/newkeys/WhiteFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * K3W + K3W/2, 0, K3W, KIH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * K3W, KIH, K3W, KIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteUp.xpm", "bitmaps/newkeys/WhiteDown.xpm", BRIGHTON_NOSHADOW},
};

brightonLocations keys3octave2[KEY_COUNT_3OCTAVE] = {
	{"", 2, 0 * K3W, 0, K3FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 0 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 2 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * K3W, 0, K3FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 6 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 7 * K3W, 0, K3FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 7 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 9 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * K3W, 0, K3FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 13 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 14 * K3W, 0, K3FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 14 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 16 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * K3W, 0, K3FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 20 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 21 * K3W, 0, K3FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 21 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 23 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * K3W, 0, K3FW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * K3W + K3W/2, 0, K3W, K3IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * K3W, K3IH, K3W, K3IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
};

#define K3PW (1000 / 22)
//#define K3PFW (K3PW * 3 / 4)
#define K3PFW K3PW

#define K3PMW 18
#define K3PIW 40
#define K3PIH 630
#define K3PIL 370
#define K3PIS 33

brightonLocations keys3_octave[KEY_COUNT_3_OCTAVE] = {
	{"", 2, 0 * K3PW, 0, K3PFW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 0 * K3PW + K3PW/2, 0, K3PW, K3PIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * K3PW, K3PIH, K3PW, K3PIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * K3PW + K3PW/2, 0, K3PW, K3PIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 2 * K3PW, K3PIH, K3PW, K3PIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * K3PW, 0, K3PFW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * K3PW + K3PW/2, 0, K3PW, K3PIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * K3PW, K3PIH, K3PW, K3PIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * K3PW + K3PW/2, 0, K3PW, K3PIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * K3PW, K3PIH, K3PW, K3PIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * K3PW + K3PW/2, 0, K3PW, K3PIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 6 * K3PW, K3PIH, K3PW, K3PIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 7 * K3PW, 0, K3PFW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 7 * K3PW + K3PW/2, 0, K3PW, K3PIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * K3PW, K3PIH, K3PW, K3PIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * K3PW + K3PW/2, 0, K3PW, K3PIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 9 * K3PW, K3PIH, K3PW, K3PIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * K3PW, 0, K3PFW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * K3PW + K3PW/2, 0, K3PW, K3PIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * K3PW, K3PIH, K3PW, K3PIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * K3PW + K3PW/2, 0, K3PW, K3PIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * K3PW, K3PIH, K3PW, K3PIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * K3PW + K3PW/2, 0, K3PW, K3PIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 13 * K3PW, K3PIH, K3PW, K3PIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 14 * K3PW, 0, K3PFW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 14 * K3PW + K3PW/2, 0, K3PW, K3PIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * K3PW, K3PIH, K3PW, K3PIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * K3PW + K3PW/2, 0, K3PW, K3PIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 16 * K3PW, K3PIH, K3PW, K3PIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * K3PW, 0, K3PFW, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * K3PW + K3PW/2, 0, K3PW, K3PIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * K3PW, K3PIH, K3PW, K3PIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * K3PW + K3PW/2, 0, K3PW, K3PIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * K3PW, K3PIH, K3PW, K3PIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * K3PW + K3PW/2, 0, K3PW, K3PIH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 20 * K3PW, K3PIH, K3PW, K3PIL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 21 * K3PW, 0, K3PFW - 2, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
};

#define KVW 1000 / 28

#define KVMW 18
#define KVIW 40
#define KVIH 600
#define KVIL 410
#define KVIS 33

brightonLocations vkeys[VKEY_COUNT] = {
	{"", 2, 0 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 0 * KVW, 0, KVIW + 7, KVIH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 2 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * KVW, 0, KVIW + 10, KVIH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 6 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 7 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 7 * KVW, 0, KVIW + 7, KVIH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 9 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * KVW, 0, KVIW + 10, KVIH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 13 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 14 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 14 * KVW, 0, KVIW + 7, KVIH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 16 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * KVW, 0, KVIW + 10, KVIH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 20 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 21 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 21 * KVW, 0, KVIW + 7, KVIH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 23 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * KVW, 0, KVIW + 10, KVIH, 0, 1, 0,
		"bitmaps/keys/brevup.xpm", "bitmaps/keys/brevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 26 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 26 * KVW + KVIS, 0, KVMW, KVIH, 0, 1, 0,
		"bitmaps/keys/brevmup.xpm", "bitmaps/keys/brevmdown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 27 * KVW, KVIH, KVW, KVIL, 0, 1, 0,
		"bitmaps/keys/wrevup.xpm", "bitmaps/keys/wrevdown.xpm", BRIGHTON_NOSHADOW},
};

#define K4W 1000 / 29
#define K4WB (K4W)
#define K4WC (K4W)

#define K4MW 18
#define K4IW 40
#define K4IH 600
#define K4IL 410
#define K4IS 33

#define K4C0 0
#define K4C1 (K4C0 + K4WB)
#define K4C2 (K4C1 + K4WB)
#define K4C3 (K4C2 + K4WB)
#define K4C4 (K4C3 + K4WB)
#define K4C5 (K4C4 + K4WB)
#define K4C6 (K4C5 + K4WB)
#define K4C7 (K4C6 + K4WB)
#define K4C8 (K4C7 + K4WB)
#define K4C9 (K4C8 + K4WB)
#define K4C10 (K4C9 + K4WB)
#define K4C11 (K4C10 + K4WB)
#define K4C12 (K4C11 + K4WB)
#define K4C13 (K4C12 + K4WB)
#define K4C14 (K4C13 + K4WB)
#define K4C15 (K4C14 + K4WB)
#define K4C16 (K4C15 + K4WB)
#define K4C17 (K4C16 + K4WB)
#define K4C18 (K4C17 + K4WB)
#define K4C19 (K4C18 + K4WB)
#define K4C20 (K4C19 + K4WB)
#define K4C21 (K4C20 + K4WB)
#define K4C22 (K4C21 + K4WB)
#define K4C23 (K4C22 + K4WB)
#define K4C24 (K4C23 + K4WB)
#define K4C25 (K4C24 + K4WB)
#define K4C26 (K4C25 + K4WB)
#define K4C27 (K4C26 + K4WB)
#define K4C28 (K4C27 + K4WB)

brightonLocations keys4octave2[KEY_COUNT_4OCTAVE] = {
	{"", 2, K4C0, 0, K4WC, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C0 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C1, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C1 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C2, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C3, 0, K4WC, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C3 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C4, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C4 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C5, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C5 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C6, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, K4C7, 0, K4WC, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C7 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C8, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C8 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C9, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C10, 0, K4WC, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C10 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C11, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C11 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C12, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C12 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C13, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, K4C14, 0, K4WC, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C14 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C15, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C15 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C16, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C17, 0, K4WC, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C17 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C18, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C18 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C19, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C19 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C20, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, K4C21, 0, K4WC, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C21 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C22, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C22 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C23, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C24, 0, K4WC, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHFUp.xpm", "bitmaps/newkeys/WhiteNHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C24 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C25, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C25 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C26, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C26 + K4W/2, 0, K4WC, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackNUp.xpm", "bitmaps/newkeys/BlackNDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, K4C27, K4IH, K4WC, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHUp.xpm", "bitmaps/newkeys/WhiteNHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, K4C28, 0, K4WC, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteNHLUp.xpm", "bitmaps/newkeys/WhiteNHLDown.xpm", BRIGHTON_NOSHADOW},
};

brightonLocations keys4octave[KEY_COUNT_4OCTAVE] = {
	{"", 2, 0 * K4W, 0, K4W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 0 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 1 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 2 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * K4W, 0, K4W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 6 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 7 * K4W, 0, K4W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 7 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 9 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * K4W, 0, K4W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 13 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 14 * K4W, 0, K4W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 14 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 15 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 16 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * K4W, 0, K4W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 20 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 21 * K4W, 0, K4W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 21 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 23 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * K4W, 0, K4W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHFUp.xpm", "bitmaps/newkeys/WhiteHFDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 26 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 26 * K4W + K4W/2, 0, K4W, K4IH, 0, 1, 0,
		"bitmaps/newkeys/BlackUp.xpm", "bitmaps/newkeys/BlackDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 27 * K4W, K4IH, K4W, K4IL, 0, 1, 0,
		"bitmaps/newkeys/WhiteHUp.xpm", "bitmaps/newkeys/WhiteHDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 28 * K4W, 0, K4W, 1000, 0, 1, 0,
		"bitmaps/newkeys/WhiteHLUp.xpm", "bitmaps/newkeys/WhiteHLDown.xpm", BRIGHTON_NOSHADOW},
};

#define KPS 1000 / 29 
#define KPW 1000 / 29 

#define KPH	930
#define KPMW 18
#define KPIW 40
#define KPIH 600
#define KPIL 410
#define KPIS 33

brightonLocations pedalBoard[KEY_COUNT_PEDAL] = {
	{"", 2, 1 * KPS, 0, KPW, KPH, 0, 1, 0,
		"bitmaps/newkeys/PedalWUp.xpm", "bitmaps/newkeys/PedalWDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 2 * KPS, 0, KPW, KPIH, 0, 1, 0,
		"bitmaps/newkeys/PedalBUp.xpm", "bitmaps/newkeys/PedalBDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 3 * KPS, 0, KPW, KPH, 0, 1, 0,
		"bitmaps/newkeys/PedalWUp.xpm", "bitmaps/newkeys/PedalWDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 4 * KPS, 0, KPW, KPIH, 0, 1, 0,
		"bitmaps/newkeys/PedalBUp.xpm", "bitmaps/newkeys/PedalBDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 5 * KPS, 0, KPW, KPH, 0, 1, 0,
		"bitmaps/newkeys/PedalWUp.xpm", "bitmaps/newkeys/PedalWDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 7 * KPS, 0, KPW, KPH, 0, 1, 0,
		"bitmaps/newkeys/PedalWUp.xpm", "bitmaps/newkeys/PedalWDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 8 * KPS, 0, KPW, KPIH, 0, 1, 0,
		"bitmaps/newkeys/PedalBUp.xpm", "bitmaps/newkeys/PedalBDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 9 * KPS, 0, KPW, KPH, 0, 1, 0,
		"bitmaps/newkeys/PedalWUp.xpm", "bitmaps/newkeys/PedalWDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 10 * KPS, 0, KPW, KPIH, 0, 1, 0,
		"bitmaps/newkeys/PedalBUp.xpm", "bitmaps/newkeys/PedalBDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 11 * KPS, 0, KPW, KPH, 0, 1, 0,
		"bitmaps/newkeys/PedalWUp.xpm", "bitmaps/newkeys/PedalWDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 12 * KPS, 0, KPW, KPIH, 0, 1, 0,
		"bitmaps/newkeys/PedalBUp.xpm", "bitmaps/newkeys/PedalBDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 13 * KPS, 0, KPW, KPH, 0, 1, 0,
		"bitmaps/newkeys/PedalWUp.xpm", "bitmaps/newkeys/PedalWDown.xpm", BRIGHTON_NOSHADOW},

	{"", 2, 15 * KPS, 0, KPW, KPH, 0, 1, 0,
		"bitmaps/newkeys/PedalWUp.xpm", "bitmaps/newkeys/PedalWDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 16 * KPS, 0, KPW, KPIH, 0, 1, 0,
		"bitmaps/newkeys/PedalBUp.xpm", "bitmaps/newkeys/PedalBDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 17 * KPS, 0, KPW, KPH, 0, 1, 0,
		"bitmaps/newkeys/PedalWUp.xpm", "bitmaps/newkeys/PedalWDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 18 * KPS, 0, KPW, KPIH, 0, 1, 0,
		"bitmaps/newkeys/PedalBUp.xpm", "bitmaps/newkeys/PedalBDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 19 * KPS, 0, KPW, KPH, 0, 1, 0,
		"bitmaps/newkeys/PedalWUp.xpm", "bitmaps/newkeys/PedalWDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 21 * KPS, 0, KPW, KPH, 0, 1, 0,
		"bitmaps/newkeys/PedalWUp.xpm", "bitmaps/newkeys/PedalWDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 22 * KPS, 0, KPW, KPIH, 0, 1, 0,
		"bitmaps/newkeys/PedalBUp.xpm", "bitmaps/newkeys/PedalBDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 23 * KPS, 0, KPW, KPH, 0, 1, 0,
		"bitmaps/newkeys/PedalWUp.xpm", "bitmaps/newkeys/PedalWDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 24 * KPS, 0, KPW, KPIH, 0, 1, 0,
		"bitmaps/newkeys/PedalBUp.xpm", "bitmaps/newkeys/PedalBDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 25 * KPS, 0, KPW, KPH, 0, 1, 0,
		"bitmaps/newkeys/PedalWUp.xpm", "bitmaps/newkeys/PedalWDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 26 * KPS, 0, KPW, KPIH, 0, 1, 0,
		"bitmaps/newkeys/PedalBUp.xpm", "bitmaps/newkeys/PedalBDown.xpm", BRIGHTON_NOSHADOW},
	{"", 2, 27 * KPS, 0, KPW, KPH, 0, 1, 0,
		"bitmaps/newkeys/PedalWUp.xpm", "bitmaps/newkeys/PedalWDown.xpm", BRIGHTON_NOSHADOW},
};

brightonLocations mods[2] = {
	{"", 1, 290, 170, 97, 620, 0, 1, 0, 0, 0, BRIGHTON_CENTER|BRIGHTON_NOSHADOW},
	{"", 1, 655, 170, 97, 620, 0, 1, 0, 0, 0, BRIGHTON_NOSHADOW},
};

extern int bristolMidiControl(int, int, int, int, int);

int
modCallback(brightonWindow *win, int panel, int index, float value)
{
	guiSynth *synth = findSynth(global.synths, win);

/*	printf("modCallback(%x, %i, %i, %f)\n", synth, panel, index, value); */

	if (global.libtest)
		return(0);

	/*
	 * If this is controller 0 it is the frequency control, otherwise a 
	 * generic controller 1.
	 */
	if (index == 0)
		bristolMidiSendMsg(global.controlfd, synth->midichannel,
			BRISTOL_EVENT_PITCH, 0, (int) (value * C_RANGE_MIN_1));
	else {
		if (synth->flags & NO_KEYTRACK)
			return(0);
		bristolMidiControl(global.controlfd, synth->midichannel,
			0, 1, ((int) (value * (C_RANGE_MIN_1 - 1))) >> 7);
	}

	return(0);
}

int
keyCallback(brightonWindow *win, int panel, int index, float value)
{
	guiSynth *synth = findSynth(global.synths, win);

	if (global.libtest)
		return(0);

	if (global.synths->flags & REQ_MIDI_DEBUG2)
		printf("keycallback(%p, %i, %i, %f): %i %i - %i\n",
			synth, panel, index, value, synth->transpose,
			global.controlfd, index + synth->transpose);

	/*
	 * Want to send a note event, on or off, for this index + transpose.
	 */
	if (value)
		bristolMidiSendMsg(global.controlfd, synth->midichannel,
			BRISTOL_EVENT_KEYON, 0, index + synth->transpose);
	else
		bristolMidiSendMsg(global.controlfd, synth->midichannel,
			BRISTOL_EVENT_KEYOFF, 0, index + synth->transpose);

	return(0);
}

#endif /* BRIGHTONKEYBOARD_H */

