#!/bin/bash
# The purpose of this file is to add entries from zm.conf to cmake's cache.

echo "*** This bash script imports configuration from zm.conf into cmake initial cache file"
echo "*** The file can be used with cmake like so: cmake -C zm_conf.cmake [extra cmake options] ."
echo "*** Usage: ./cmakecacheimport.sh [PATH TO ZM.CONF]"
echo ""

# Check for too many prameters
if [[ "$#" -gt "0" && "$#" -ne "1" ]]; then
       echo "Error: Too many parameters!"
       exit 50
fi

# Check if zm.conf was supplied as an argument and that it exists
if [ "$#" -eq "1" ]; then
	ZM_CONFIG="$1"
	if [ ! -f "$ZM_CONFIG" ]; then
		echo "The zoneminder configuration file $ZM_CONFIG does not exist!"
		exit 40
	fi
fi

# Load zm.conf
if [ -n "$ZM_CONFIG" ]; then
	echo "Using custom zm.conf $ZM_CONFIG"
	source "$ZM_CONFIG"
elif [ -f "/etc/zm.conf" ]; then
	echo "Using system zm.conf"
	source "/etc/zm.conf"
elif [ -f "zm.conf" ]; then
	echo "Using local zm.conf"
	source "zm.conf"
else
	echo "Failed locating zoneminder configuration file (zm.conf)\nPlease specify the full path to the zoneminder configuration file"
	exit 45
fi

# Create the file
touch "zm_conf.cmake"
if [ "$?" != "0" ]; then
	echo "Failed creating zm_conf.cmake in the current directory"
	exit 10
fi

# Print some information
#echo "Executables directory      : $ZM_PATH_BIN"
#echo "Libraries directory        : $ZM_PATH_LIB"
#echo "System config directory    : $ZM_PATH_CONF"
echo "Web directory              : $ZM_PATH_WEB"
echo "CGI directory              : $ZM_PATH_CGI"
echo "Web user                   : $ZM_WEB_USER"
echo "Web group                  : $ZM_WEB_GROUP"
echo "Database host              : $ZM_DB_HOST"
echo "Database name              : $ZM_DB_NAME"
echo "Database user              : $ZM_DB_USER"
echo "Database password          : Not shown"
echo "Database SSL CA Cert       : $ZM_DB_SSL_CA_CERT"
echo "Database SSL Client Key    : $ZM_DB_SSL_CLIENT_KEY"
echo "Database SSL Client Cert   : $ZM_DB_SSL_CLIENT_CERT"


CMPATH="CACHE PATH \"Imported by cmakecacheimport.sh\" FORCE"
CMSTRING="CACHE STRING \"Imported by cmakecacheimport.sh\" FORCE"
# Write
echo "# This file was generated by cmakecacheimport.sh">zm_conf.cmake
#echo "set(CMAKE_INSTALL_FULL_BINDIR \"$ZM_PATH_BIN\" $CMPATH)">>zm_conf.cmake
#echo "set(CMAKE_INSTALL_FULL_LIBDIR \"$ZM_PATH_LIB\" $CMPATH)">>zm_conf.cmake
#echo "set(CMAKE_INSTALL_FULL_SYSCONFDIR \"$ZM_PATH_CONF\" $CMPATH)">>zm_conf.cmake
echo "set(ZM_WEBDIR \"$ZM_PATH_WEB\" $CMPATH)">>zm_conf.cmake
echo "set(ZM_CGIDIR \"$ZM_PATH_CGI\" $CMPATH)">>zm_conf.cmake
echo "set(ZM_WEB_USER \"$ZM_WEB_USER\" $CMSTRING)">>zm_conf.cmake
echo "set(ZM_WEB_GROUP \"$ZM_WEB_GROUP\" $CMSTRING)">>zm_conf.cmake
echo "set(ZM_DB_HOST \"$ZM_DB_HOST\" $CMSTRING)">>zm_conf.cmake
echo "set(ZM_DB_NAME \"$ZM_DB_NAME\" $CMSTRING)">>zm_conf.cmake
echo "set(ZM_DB_USER \"$ZM_DB_USER\" $CMSTRING)">>zm_conf.cmake
echo "set(ZM_DB_PASS \"$ZM_DB_PASS\" $CMSTRING)">>zm_conf.cmake
echo "set(ZM_DB_SSL_CA_CERT \"$ZM_DB_SSL_CA_CERT\" $CMSTRING)">>zm_conf.cmake
echo "set(ZM_DB_SSL_CLIENT_KEY \"$ZM_DB_SSL_CLIENT_KEY\" $CMSTRING)">>zm_conf.cmake
echo "set(ZM_DB_SSL_CLIENT_CERT \"$ZM_DB_SSL_CLIENT_CERT\" $CMSTRING)">>zm_conf.cmake

echo ""
echo "Wrote zm_conf.cmake"
echo ""
echo "All done"
