// This file is a part of toml++ and is subject to the the terms of the MIT license.
// Copyright (c) Mark Gillard <mark.gillard@outlook.com.au>
// See https://github.com/marzer/tomlplusplus/blob/master/LICENSE for the full license text.
// SPDX-License-Identifier: MIT
//-----
// this file was generated by generate_conformance_tests.py - do not modify it directly

#include "tests.h"

namespace
{
	static constexpr auto spec_array_1 = "integers = [ 1, 2, 3 ]"sv;
	static constexpr auto spec_array_2 = "colors = [ \"red\", \"yellow\", \"green\" ]"sv;
	static constexpr auto spec_array_3 = "nested_array_of_int = [ [ 1, 2 ], [3, 4, 5] ]"sv;
	static constexpr auto spec_array_4 = "string_array = [ \"all\", 'strings', \"\"\"are the same\"\"\", '''type''']"sv;
	static constexpr auto spec_array_5 = "nested_mixed_array = [ [ 1, 2 ], [\"a\", \"b\", \"c\"] ]"sv;
	static constexpr auto spec_array_7 = "integers2 = [\r\n"
										 "  1, 2, 3\r\n"
										 "]"sv;
	static constexpr auto spec_array_8 = "integers3 = [\r\n"
										 "  1,\r\n"
										 "  2, # this is ok\r\n"
										 "]"sv;
	static constexpr auto spec_array_mixed_number_types = "numbers = [ 0.1, 0.2, 0.5, 1, 2, 5 ]"sv;
	static constexpr auto spec_array_more_mixed_types =
		"contributors = [\r\n"
		"  \"Foo Bar <foo@example.com>\",\r\n"
		"  { name = \"Baz Qux\", email = \"bazqux@example.com\", url = \"https://example.com/bazqux\" }\r\n"
		"]"sv;
	static constexpr auto spec_array_of_tables_1  = "[[products]]\r\n"
													"name = \"Hammer\"\r\n"
													"sku = 738594937\r\n"
													"\r\n"
													"[[products]]\r\n"
													"\r\n"
													"[[products]]\r\n"
													"name = \"Nail\"\r\n"
													"sku = 284758393\r\n"
													"color = \"gray\""sv;
	static constexpr auto spec_array_of_tables_2  = "[[fruit]]\r\n"
													"  name = \"apple\"\r\n"
													"\r\n"
													"  [fruit.physical]\r\n"
													"    color = \"red\"\r\n"
													"    shape = \"round\"\r\n"
													"\r\n"
													"  [[fruit.variety]]\r\n"
													"    name = \"red delicious\"\r\n"
													"\r\n"
													"  [[fruit.variety]]\r\n"
													"    name = \"granny smith\"\r\n"
													"\r\n"
													"[[fruit]]\r\n"
													"  name = \"banana\"\r\n"
													"\r\n"
													"  [[fruit.variety]]\r\n"
													"    name = \"plantain\""sv;
	static constexpr auto spec_array_of_tables_3  = "points = [ { x = 1, y = 2, z = 3 },\r\n"
													"           { x = 7, y = 8, z = 9 },\r\n"
													"           { x = 2, y = 4, z = 8 } ]"sv;
	static constexpr auto spec_boolean_1		  = "bool1 = true"sv;
	static constexpr auto spec_boolean_2		  = "bool1 = false"sv;
	static constexpr auto spec_case_sensitive	  = "# TOML is case sensitive.\r\n"
													"abc = 123\r\n"
													"ABC = 456"sv;
	static constexpr auto spec_comment_mid_array  = "# eol commetns can go anywhere\r\n"
													"abc = [ # this is valid\r\n"
													"  123,#as is this\r\n"
													"  456    #so is  this\r\n"
													"  ]# and this\r\n"
													"# here too"sv;
	static constexpr auto spec_comment_mid_string = "another = \"# This is not a comment\""sv;
	static constexpr auto spec_comment_tab =
		"# This is a full-line	comment with a tab in the middle\r\n"
		"key = \"value\" # This is a commen	with a tab in the middle at the end of a line"sv;
	static constexpr auto spec_comment				  = "# This is a full-line comment\r\n"
														"key = \"value\" # This is a comment at the end of a line"sv;
	static constexpr auto spec_date_local_1			  = "ld1 = 1979-05-27"sv;
	static constexpr auto spec_date_time_1			  = "odt1 = 1979-05-27T07:32:00Z"sv;
	static constexpr auto spec_date_time_2			  = "odt2 = 1979-05-27T00:32:00-07:00"sv;
	static constexpr auto spec_date_time_3			  = "odt3 = 1979-05-27T00:32:00.999999-07:00"sv;
	static constexpr auto spec_date_time_4			  = "odt4 = 1979-05-27 07:32:00Z"sv;
	static constexpr auto spec_date_time_5			  = "odt5 = 1979-05-27T07:32:00.123Z"sv;
	static constexpr auto spec_date_time_local_1	  = "ldt1 = 1979-05-27T07:32:00"sv;
	static constexpr auto spec_dotted_keys_1		  = "name = \"Orange\"\r\n"
														"physical.color = \"orange\"\r\n"
														"physical.shape = \"round\"\r\n"
														"site.\"google.com\" = true"sv;
	static constexpr auto spec_dotted_keys_2		  = "a  .  b = 23"sv;
	static constexpr auto spec_dotted_keys_3		  = "a  	.  b = 23"sv;
	static constexpr auto spec_empty_key_name_1		  = "\"\" = \"blank\"     # VALID but discouraged"sv;
	static constexpr auto spec_empty_key_name_2		  = "'' = \"blank\"     # VALID but discouraged"sv;
	static constexpr auto spec_extend_dotted_object_1 = "# This makes the key \"fruit\" into a table.\r\n"
														"fruit.apple.smooth = true\r\n"
														"\r\n"
														"# So then you can add to the table \"fruit\" like so:\r\n"
														"fruit.orange = 2"sv;
	static constexpr auto spec_extend_dotted_object_2 = "# VALID BUT DISCOURAGED\r\n"
														"\r\n"
														"apple.type = \"fruit\"\r\n"
														"orange.type = \"fruit\"\r\n"
														"\r\n"
														"apple.skin = \"thin\"\r\n"
														"orange.skin = \"thick\"\r\n"
														"\r\n"
														"apple.color = \"red\"\r\n"
														"orange.color = \"orange\""sv;
	static constexpr auto spec_extend_dotted_object_3 = "# RECOMMENDED\r\n"
														"\r\n"
														"apple.type = \"fruit\"\r\n"
														"apple.skin = \"thin\"\r\n"
														"apple.color = \"red\"\r\n"
														"\r\n"
														"orange.type = \"fruit\"\r\n"
														"orange.skin = \"thick\"\r\n"
														"orange.color = \"orange\""sv;
	static constexpr auto spec_float_1				  = "flt1 = +1.0"sv;
	static constexpr auto spec_float_10				  = "sf1 = inf  # positive infinity"sv;
	static constexpr auto spec_float_11				  = "sf2 = +inf # positive infinity"sv;
	static constexpr auto spec_float_12				  = "sf2 = -inf # negative infinity"sv;
	static constexpr auto spec_float_13			= "sf4 = nan  # actual sNaN/qNaN encoding is implementation specific"sv;
	static constexpr auto spec_float_14			= "sf5 = +nan # same as `nan`"sv;
	static constexpr auto spec_float_15			= "sf6 = -nan # valid, actual encoding is implementation specific"sv;
	static constexpr auto spec_float_2			= "flt2 = 3.1415"sv;
	static constexpr auto spec_float_3			= "flt3 = -0.01"sv;
	static constexpr auto spec_float_4			= "flt4 = 5e+22"sv;
	static constexpr auto spec_float_5			= "flt5 = 1e06"sv;
	static constexpr auto spec_float_6			= "flt6 = -2E-2"sv;
	static constexpr auto spec_float_7			= "flt7 = 6.626e-34"sv;
	static constexpr auto spec_float_8			= "flt8 = 224_617.445_991_228"sv;
	static constexpr auto spec_float_9			= "flt9 = -0e0"sv;
	static constexpr auto spec_int_1			= "int1 = +99"sv;
	static constexpr auto spec_int_2			= "int2 = 42"sv;
	static constexpr auto spec_int_3			= "int3 = 0"sv;
	static constexpr auto spec_int_3a			= "int3 = +0"sv;
	static constexpr auto spec_int_3b			= "int3 = -0"sv;
	static constexpr auto spec_int_4			= "int4 = -17"sv;
	static constexpr auto spec_int_5			= "int5 = 1_000"sv;
	static constexpr auto spec_int_6			= "int6 = 5_349_221"sv;
	static constexpr auto spec_int_7			= "int7 = 1_2_3_4_5     # VALID but discouraged"sv;
	static constexpr auto spec_int_bin1			= "bin1 = 0b11010110"sv;
	static constexpr auto spec_int_hex1			= "hex1 = 0xDEADBEEF"sv;
	static constexpr auto spec_int_hex2			= "hex2 = 0xdeadbeef"sv;
	static constexpr auto spec_int_hex3			= "hex3 = 0xdead_beef"sv;
	static constexpr auto spec_int_max			= "max=9_223_372_036_854_775_807"sv;
	static constexpr auto spec_int_min			= "min=-9_223_372_036_854_775_808"sv;
	static constexpr auto spec_int_oct1			= "oct1 = 0o01234567"sv;
	static constexpr auto spec_int_oct2			= "oct2 = 0o755 # useful for Unix file permissions"sv;
	static constexpr auto spec_key_value_pair_1 = "key = \"value\""sv;
	static constexpr auto spec_key_value_pair_2 = "bare_key = \"value\""sv;
	static constexpr auto spec_key_value_pair_3 = "bare-key = \"value\""sv;
	static constexpr auto spec_key_value_pair_4 = "1234 = \"value\""sv;
	static constexpr auto spec_key_value_pair_5 = "1234=\"value\""sv;
	static constexpr auto spec_key_value_pair_6 = "-=1"sv;
	static constexpr auto spec_key_value_pair_7 = "_=1"sv;
	static constexpr auto spec_key_value_pair_8 = "-_-_-_-_-=1"sv;
	static constexpr auto spec_key_value_pair_9 = "3.14159 = \"pi\""sv;
	static constexpr auto spec_newline_1		= R"(abc = 123
def = 456)"sv;
	static constexpr auto spec_newline_2		= "abc = 123\r\n"
												  "def = 456"sv;
	static constexpr auto spec_newline_3		= "abc = 123\r\n"
												  "def = 456\n"
												  "ghi = 789"sv;
	static constexpr auto spec_quoted_literal_keys_1	= "'quoted \"value\"' = \"value\""sv;
	static constexpr auto spec_readme_example			= "# This is a TOML document.\r\n"
														  "\r\n"
														  "title = \"TOML Example\"\r\n"
														  "\r\n"
														  "[owner]\r\n"
														  "name = \"Tom Preston-Werner\"\r\n"
														  "dob = 1979-05-27T07:32:00-08:00 # First class dates\r\n"
														  "\r\n"
														  "[database]\r\n"
														  "server = \"192.168.1.1\"\r\n"
														  "ports = [ 8001, 8001, 8002 ]\r\n"
														  "connection_max = 5000\r\n"
														  "enabled = true\r\n"
														  "\r\n"
														  "[servers]\r\n"
														  "\r\n"
														  "  # Indentation (tabs and/or spaces) is allowed but not required\r\n"
														  "  [servers.alpha]\r\n"
														  "  ip = \"10.0.0.1\"\r\n"
														  "  dc = \"eqdc10\"\r\n"
														  "\r\n"
														  "  [servers.beta]\r\n"
														  "  ip = \"10.0.0.2\"\r\n"
														  "  dc = \"eqdc10\"\r\n"
														  "\r\n"
														  "[clients]\r\n"
														  "data = [ [\"gamma\", \"delta\"], [1, 2] ]\r\n"
														  "\r\n"
														  "# Line breaks are OK when inside arrays\r\n"
														  "hosts = [\r\n"
														  "  \"alpha\",\r\n"
														  "  \"omega\"\r\n"
														  "]"sv;
	static constexpr auto spec_string_basic_multiline_1 = "str1 = \"\"\"\r\n"
														  "Roses are red\r\n"
														  "Violets are blue\"\"\""sv;
	static constexpr auto spec_string_basic_multiline_2 = "str = \"\"\"\r\n"
														  "The quick brown \\\r\n"
														  "\r\n"
														  "\r\n"
														  "  fox jumps over \\\r\n"
														  "    the lazy dog.\"\"\""sv;
	static constexpr auto spec_string_basic_multiline_3 = "str = \"\"\"\\\r\n"
														  "      The quick brown \\\r\n"
														  "      fox jumps over \\\r\n"
														  "      the lazy dog.\\\r\n"
														  "      \"\"\""sv;
	static constexpr auto spec_string_basic_multiline_4 = "a = \"\"\"abc\\   \r\n"
														  "def\"\"\""sv;
	static constexpr auto spec_string_basic_multiline_5 = "ml-escaped-nl = \"\"\"\r\n"
														  "  foo \\\r\n"
														  "  bar \\\\\r\n"
														  "  baz \\\\\\\r\n"
														  "  quux\"\"\""sv;
	static constexpr auto spec_string_basic_multiline_6 =
		"str4 = \"\"\"Here are two quotation marks: \"\". Simple enough.\"\"\""sv;
	static constexpr auto spec_string_basic_multiline_7 =
		"str5 = \"\"\"Here are three quotation marks: \"\"\\\".\"\"\""sv;
	static constexpr auto spec_string_basic_multiline_8 =
		"str6 = \"\"\"Here are fifteen quotation marks: \"\"\\\"\"\"\\\"\"\"\\\"\"\"\\\"\"\"\\\".\"\"\""sv;
	static constexpr auto spec_string_basic_multiline_9 =
		"str7 = \"\"\"\"This,\" she said, \"is just a pointless statement.\"\"\"\""sv;
	static constexpr auto spec_string_basic_tab_multiline = "str = \"\"\"This is a	tab\"\"\""sv;
	static constexpr auto spec_string_basic_tab			  = "str = \"This is a	tab\""sv;
	static constexpr auto spec_string_escape_1			  = "a = \"\\b\""sv;
	static constexpr auto spec_string_escape_2			  = "a = \"\\t\""sv;
	static constexpr auto spec_string_escape_3			  = "a = \"\\n\""sv;
	static constexpr auto spec_string_escape_4			  = "a = \"\\f\""sv;
	static constexpr auto spec_string_escape_5			  = "a = \"\\r\""sv;
	static constexpr auto spec_string_escape_6			  = "a = \"\\\"\""sv;
	static constexpr auto spec_string_escape_7			  = "a = \"\\\\\""sv;
	static constexpr auto spec_string_escape_8			  = "a = \"\\u0000\""sv;
	static constexpr auto spec_string_escape_9			  = "a = \"\\U00000000\""sv;
	static constexpr auto spec_string_literal_1			  = "winpath  = 'C:\\Users\\nodejs\\templates'"sv;
	static constexpr auto spec_string_literal_2			  = "winpath2 = '\\\\ServerX\\admin$\\system32\\'"sv;
	static constexpr auto spec_string_literal_3			  = "quoted   = 'Tom \"Dubs\" Preston-Werner'"sv;
	static constexpr auto spec_string_literal_4			  = "regex    = '<\\i\\c*\\s*>'"sv;
	static constexpr auto spec_string_literal_multiline_1 = "regex2 = '''I [dw]on't need \\d{2} apples'''"sv;
	static constexpr auto spec_string_literal_multiline_2 = "lines  = '''\r\n"
															"The first newline is\r\n"
															"trimmed in raw strings.\r\n"
															"   All other whitespace\r\n"
															"   is preserved.\r\n"
															"'''"sv;
	static constexpr auto spec_string_literal_multiline_3 =
		"quot15 = '''Here are fifteen quotation marks: \"\"\"\"\"\"\"\"\"\"\"\"\"\"\"'''"sv;
	static constexpr auto spec_string_literal_multiline_4 = "str = ''''That,' she said, 'is still pointless.''''"sv;
	static constexpr auto spec_table_1					  = "[table-1]\r\n"
															"key1 = \"some string\"\r\n"
															"key2 = 123\r\n"
															"\r\n"
															"[table-2]\r\n"
															"key1 = \"another string\"\r\n"
															"key2 = 456"sv;
	static constexpr auto spec_table_2					  = "[dog.\"tater.man\"]\r\n"
															"type.name = \"pug\""sv;
	static constexpr auto spec_table_3					  = "[a.b.c]"sv;
	static constexpr auto spec_table_4					  = "[ d.e.f ]          # same as [d.e.f]"sv;
	static constexpr auto spec_table_5					  = "[ g .  h  . i ]    # same as [g.h.i]"sv;
	static constexpr auto spec_table_7					  = "# [x] you\r\n"
															"# [x.y] don't\r\n"
															"# [x.y.z] need these\r\n"
															"[x.y.z.w] # for this to work\r\n"
															"[x] # defining a super-table afterwards is ok"sv;
	static constexpr auto spec_table_8					  = "[fruit]\r\n"
															"apple.color = \"red\"\r\n"
															"apple.taste.sweet = true\r\n"
															"\r\n"
															"[fruit.apple.texture]  # you can add sub-tables\r\n"
															"smooth = true"sv;
	static constexpr auto spec_table_inline_1			  = "name = { first = \"Tom\", last = \"Preston-Werner\" }"sv;
	static constexpr auto spec_table_inline_2			  = "point = { x = 1, y = 2 }"sv;
	static constexpr auto spec_table_inline_3			  = "animal = { type.name = \"pug\" } "sv;
	static constexpr auto spec_table					  = "[table]"sv;
	static constexpr auto spec_time_1					  = "lt1 = 07:32:00"sv;

#if UNICODE_LITERALS_OK

	static constexpr auto spec_quoted_basic_keys_1 = "\"ʎǝʞ\" = \"value\""sv;
	static constexpr auto spec_string_basic =
		"str = \"I'm a string. \\\"You can quote me\\\". Name\\tJos\\u00E9\\nLocation\\tSF.\""sv;
	static constexpr auto spec_table_6 = "[ j . \"ʞ\" . 'l' ]  # same as [j.\"ʞ\".'l']"sv;

#endif // UNICODE_LITERALS_OK
}

TEST_CASE("conformance - iarna/valid")
{
	SECTION("spec-array-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_array_1,
							   [](toml::table&& tbl) // spec-array-1
							   {
								   const auto expected = toml::table{
									   { R"(integers)"sv,
										 toml::array{
											 1,
											 2,
											 3,
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-array-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_array_2,
							   [](toml::table&& tbl) // spec-array-2
							   {
								   const auto expected = toml::table{
									   { R"(colors)"sv,
										 toml::array{
											 R"(red)"sv,
											 R"(yellow)"sv,
											 R"(green)"sv,
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-array-3")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_array_3,
							   [](toml::table&& tbl) // spec-array-3
							   {
								   const auto expected = toml::table{
									   { R"(nested_array_of_int)"sv,
										 toml::array{
											 toml::array{
												 1,
												 2,
											 },
											 toml::array{
												 3,
												 4,
												 5,
											 },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-array-4")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_array_4,
							   [](toml::table&& tbl) // spec-array-4
							   {
								   const auto expected = toml::table{
									   { R"(string_array)"sv,
										 toml::array{
											 R"(all)"sv,
											 R"(strings)"sv,
											 R"(are the same)"sv,
											 R"(type)"sv,
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-array-5")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_array_5,
							   [](toml::table&& tbl) // spec-array-5
							   {
								   const auto expected = toml::table{
									   { R"(nested_mixed_array)"sv,
										 toml::array{
											 toml::array{
												 1,
												 2,
											 },
											 toml::array{
												 R"(a)"sv,
												 R"(b)"sv,
												 R"(c)"sv,
											 },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-array-7")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_array_7,
							   [](toml::table&& tbl) // spec-array-7
							   {
								   const auto expected = toml::table{
									   { R"(integers2)"sv,
										 toml::array{
											 1,
											 2,
											 3,
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-array-8")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_array_8,
							   [](toml::table&& tbl) // spec-array-8
							   {
								   const auto expected = toml::table{
									   { R"(integers3)"sv,
										 toml::array{
											 1,
											 2,
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-array-mixed-number-types")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_array_mixed_number_types,
							   [](toml::table&& tbl) // spec-array-mixed-number-types
							   {
								   const auto expected = toml::table{
									   { R"(numbers)"sv,
										 toml::array{
											 0.1,
											 0.2,
											 0.5,
											 1,
											 2,
											 5,
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-array-more-mixed-types")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_array_more_mixed_types,
							   [](toml::table&& tbl) // spec-array-more-mixed-types
							   {
								   const auto expected = toml::table{
									   { R"(contributors)"sv,
										 toml::array{
											 R"(Foo Bar <foo@example.com>)"sv,
											 toml::table{
												 { R"(name)"sv, R"(Baz Qux)"sv },
												 { R"(email)"sv, R"(bazqux@example.com)"sv },
												 { R"(url)"sv, R"(https://example.com/bazqux)"sv },
											 },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-array-of-tables-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_array_of_tables_1,
							   [](toml::table&& tbl) // spec-array-of-tables-1
							   {
								   const auto expected = toml::table{
									   { R"(products)"sv,
										 toml::array{
											 toml::table{
												 { R"(name)"sv, R"(Hammer)"sv },
												 { R"(sku)"sv, 738594937 },
											 },
											 toml::table{},
											 toml::table{
												 { R"(name)"sv, R"(Nail)"sv },
												 { R"(sku)"sv, 284758393 },
												 { R"(color)"sv, R"(gray)"sv },
											 },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-array-of-tables-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_array_of_tables_2,
							   [](toml::table&& tbl) // spec-array-of-tables-2
							   {
								   const auto expected = toml::table{
									   { R"(fruit)"sv,
										 toml::array{
											 toml::table{
												 { R"(name)"sv, R"(apple)"sv },
												 { R"(physical)"sv,
												   toml::table{
													   { R"(color)"sv, R"(red)"sv },
													   { R"(shape)"sv, R"(round)"sv },
												   } },
												 { R"(variety)"sv,
												   toml::array{
													   toml::table{
														   { R"(name)"sv, R"(red delicious)"sv },
													   },
													   toml::table{
														   { R"(name)"sv, R"(granny smith)"sv },
													   },
												   } },
											 },
											 toml::table{
												 { R"(name)"sv, R"(banana)"sv },
												 { R"(variety)"sv,
												   toml::array{
													   toml::table{
														   { R"(name)"sv, R"(plantain)"sv },
													   },
												   } },
											 },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-array-of-tables-3")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_array_of_tables_3,
							   [](toml::table&& tbl) // spec-array-of-tables-3
							   {
								   const auto expected = toml::table{
									   { R"(points)"sv,
										 toml::array{
											 toml::table{
												 { R"(x)"sv, 1 },
												 { R"(y)"sv, 2 },
												 { R"(z)"sv, 3 },
											 },
											 toml::table{
												 { R"(x)"sv, 7 },
												 { R"(y)"sv, 8 },
												 { R"(z)"sv, 9 },
											 },
											 toml::table{
												 { R"(x)"sv, 2 },
												 { R"(y)"sv, 4 },
												 { R"(z)"sv, 8 },
											 },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-boolean-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_boolean_1,
							   [](toml::table&& tbl) // spec-boolean-1
							   {
								   const auto expected = toml::table{
									   { R"(bool1)"sv, true },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-boolean-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_boolean_2,
							   [](toml::table&& tbl) // spec-boolean-2
							   {
								   const auto expected = toml::table{
									   { R"(bool1)"sv, false },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-case-sensitive")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_case_sensitive,
							   [](toml::table&& tbl) // spec-case-sensitive
							   {
								   const auto expected = toml::table{
									   { R"(abc)"sv, 123 },
									   { R"(ABC)"sv, 456 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-comment-mid-array")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_comment_mid_array,
							   [](toml::table&& tbl) // spec-comment-mid-array
							   {
								   const auto expected = toml::table{
									   { R"(abc)"sv,
										 toml::array{
											 123,
											 456,
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-comment-mid-string")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_comment_mid_string,
							   [](toml::table&& tbl) // spec-comment-mid-string
							   {
								   const auto expected = toml::table{
									   { R"(another)"sv, R"(# This is not a comment)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-comment-tab")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_comment_tab,
							   [](toml::table&& tbl) // spec-comment-tab
							   {
								   const auto expected = toml::table{
									   { R"(key)"sv, R"(value)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-comment")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_comment,
							   [](toml::table&& tbl) // spec-comment
							   {
								   const auto expected = toml::table{
									   { R"(key)"sv, R"(value)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-date-local-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_date_local_1,
							   [](toml::table&& tbl) // spec-date-local-1
							   {
								   const auto expected = toml::table{
									   { R"(ld1)"sv, toml::date{ 1979, 5, 27 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-date-time-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_date_time_1,
							   [](toml::table&& tbl) // spec-date-time-1
							   {
								   const auto expected = toml::table{
									   { R"(odt1)"sv, toml::date_time{ { 1979, 5, 27 }, { 7, 32 }, { 0, 0 } } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-date-time-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_date_time_2,
							   [](toml::table&& tbl) // spec-date-time-2
							   {
								   const auto expected = toml::table{
									   { R"(odt2)"sv, toml::date_time{ { 1979, 5, 27 }, { 0, 32 }, { -7, 0 } } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-date-time-3")
	{
		parsing_should_succeed(
			FILE_LINE_ARGS,
			spec_date_time_3,
			[](toml::table&& tbl) // spec-date-time-3
			{
				const auto expected = toml::table{
					{ R"(odt3)"sv, toml::date_time{ { 1979, 5, 27 }, { 0, 32, 0, 999999000 }, { -7, 0 } } },
				};
				REQUIRE(tbl == expected);
			});
	}

	SECTION("spec-date-time-4")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_date_time_4,
							   [](toml::table&& tbl) // spec-date-time-4
							   {
								   const auto expected = toml::table{
									   { R"(odt4)"sv, toml::date_time{ { 1979, 5, 27 }, { 7, 32 }, { 0, 0 } } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-date-time-5")
	{
		parsing_should_succeed(
			FILE_LINE_ARGS,
			spec_date_time_5,
			[](toml::table&& tbl) // spec-date-time-5
			{
				const auto expected = toml::table{
					{ R"(odt5)"sv, toml::date_time{ { 1979, 5, 27 }, { 7, 32, 0, 123000000 }, { 0, 0 } } },
				};
				REQUIRE(tbl == expected);
			});
	}

	SECTION("spec-date-time-local-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_date_time_local_1,
							   [](toml::table&& tbl) // spec-date-time-local-1
							   {
								   const auto expected = toml::table{
									   { R"(ldt1)"sv, toml::date_time{ { 1979, 5, 27 }, { 7, 32 } } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-dotted-keys-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_dotted_keys_1,
							   [](toml::table&& tbl) // spec-dotted-keys-1
							   {
								   const auto expected = toml::table{
									   { R"(name)"sv, R"(Orange)"sv },
									   { R"(physical)"sv,
										 toml::table{
											 { R"(color)"sv, R"(orange)"sv },
											 { R"(shape)"sv, R"(round)"sv },
										 } },
									   { R"(site)"sv,
										 toml::table{
											 { R"(google.com)"sv, true },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-dotted-keys-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_dotted_keys_2,
							   [](toml::table&& tbl) // spec-dotted-keys-2
							   {
								   const auto expected = toml::table{
									   { R"(a)"sv,
										 toml::table{
											 { R"(b)"sv, 23 },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-dotted-keys-3")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_dotted_keys_3,
							   [](toml::table&& tbl) // spec-dotted-keys-3
							   {
								   const auto expected = toml::table{
									   { R"(a)"sv,
										 toml::table{
											 { R"(b)"sv, 23 },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-empty-key-name-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_empty_key_name_1,
							   [](toml::table&& tbl) // spec-empty-key-name-1
							   {
								   const auto expected = toml::table{
									   { ""sv, R"(blank)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-empty-key-name-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_empty_key_name_2,
							   [](toml::table&& tbl) // spec-empty-key-name-2
							   {
								   const auto expected = toml::table{
									   { ""sv, R"(blank)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-extend-dotted-object-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_extend_dotted_object_1,
							   [](toml::table&& tbl) // spec-extend-dotted-object-1
							   {
								   const auto expected = toml::table{
									   { R"(fruit)"sv,
										 toml::table{
											 { R"(apple)"sv,
											   toml::table{
												   { R"(smooth)"sv, true },
											   } },
											 { R"(orange)"sv, 2 },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-extend-dotted-object-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_extend_dotted_object_2,
							   [](toml::table&& tbl) // spec-extend-dotted-object-2
							   {
								   const auto expected = toml::table{
									   { R"(apple)"sv,
										 toml::table{
											 { R"(type)"sv, R"(fruit)"sv },
											 { R"(skin)"sv, R"(thin)"sv },
											 { R"(color)"sv, R"(red)"sv },
										 } },
									   { R"(orange)"sv,
										 toml::table{
											 { R"(type)"sv, R"(fruit)"sv },
											 { R"(skin)"sv, R"(thick)"sv },
											 { R"(color)"sv, R"(orange)"sv },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-extend-dotted-object-3")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_extend_dotted_object_3,
							   [](toml::table&& tbl) // spec-extend-dotted-object-3
							   {
								   const auto expected = toml::table{
									   { R"(apple)"sv,
										 toml::table{
											 { R"(type)"sv, R"(fruit)"sv },
											 { R"(skin)"sv, R"(thin)"sv },
											 { R"(color)"sv, R"(red)"sv },
										 } },
									   { R"(orange)"sv,
										 toml::table{
											 { R"(type)"sv, R"(fruit)"sv },
											 { R"(skin)"sv, R"(thick)"sv },
											 { R"(color)"sv, R"(orange)"sv },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-float-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_float_1,
							   [](toml::table&& tbl) // spec-float-1
							   {
								   const auto expected = toml::table{
									   { R"(flt1)"sv, 1.0 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-float-10")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_float_10,
							   [](toml::table&& tbl) // spec-float-10
							   {
								   const auto expected = toml::table{
									   { R"(sf1)"sv, std::numeric_limits<double>::infinity() },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-float-11")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_float_11,
							   [](toml::table&& tbl) // spec-float-11
							   {
								   const auto expected = toml::table{
									   { R"(sf2)"sv, std::numeric_limits<double>::infinity() },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-float-12")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_float_12,
							   [](toml::table&& tbl) // spec-float-12
							   {
								   const auto expected = toml::table{
									   { R"(sf2)"sv, -std::numeric_limits<double>::infinity() },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-float-13")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_float_13,
							   [](toml::table&& tbl) // spec-float-13
							   {
								   const auto expected = toml::table{
									   { R"(sf4)"sv, std::numeric_limits<double>::quiet_NaN() },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-float-14")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_float_14,
							   [](toml::table&& tbl) // spec-float-14
							   {
								   const auto expected = toml::table{
									   { R"(sf5)"sv, std::numeric_limits<double>::quiet_NaN() },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-float-15")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_float_15,
							   [](toml::table&& tbl) // spec-float-15
							   {
								   const auto expected = toml::table{
									   { R"(sf6)"sv, std::numeric_limits<double>::quiet_NaN() },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-float-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_float_2,
							   [](toml::table&& tbl) // spec-float-2
							   {
								   const auto expected = toml::table{
									   { R"(flt2)"sv, 3.1415 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-float-3")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_float_3,
							   [](toml::table&& tbl) // spec-float-3
							   {
								   const auto expected = toml::table{
									   { R"(flt3)"sv, -0.01 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-float-4")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_float_4,
							   [](toml::table&& tbl) // spec-float-4
							   {
								   const auto expected = toml::table{
									   { R"(flt4)"sv, 5e+22 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-float-5")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_float_5,
							   [](toml::table&& tbl) // spec-float-5
							   {
								   const auto expected = toml::table{
									   { R"(flt5)"sv, 1000000.0 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-float-6")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_float_6,
							   [](toml::table&& tbl) // spec-float-6
							   {
								   const auto expected = toml::table{
									   { R"(flt6)"sv, -0.02 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-float-7")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_float_7,
							   [](toml::table&& tbl) // spec-float-7
							   {
								   const auto expected = toml::table{
									   { R"(flt7)"sv, 6.626e-34 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-float-8")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_float_8,
							   [](toml::table&& tbl) // spec-float-8
							   {
								   const auto expected = toml::table{
									   { R"(flt8)"sv, 224617.445991228 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-float-9")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_float_9,
							   [](toml::table&& tbl) // spec-float-9
							   {
								   const auto expected = toml::table{
									   { R"(flt9)"sv, -0.0 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_1,
							   [](toml::table&& tbl) // spec-int-1
							   {
								   const auto expected = toml::table{
									   { R"(int1)"sv, 99 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_2,
							   [](toml::table&& tbl) // spec-int-2
							   {
								   const auto expected = toml::table{
									   { R"(int2)"sv, 42 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-3")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_3,
							   [](toml::table&& tbl) // spec-int-3
							   {
								   const auto expected = toml::table{
									   { R"(int3)"sv, 0 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-3a")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_3a,
							   [](toml::table&& tbl) // spec-int-3a
							   {
								   const auto expected = toml::table{
									   { R"(int3)"sv, 0 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-3b")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_3b,
							   [](toml::table&& tbl) // spec-int-3b
							   {
								   const auto expected = toml::table{
									   { R"(int3)"sv, 0 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-4")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_4,
							   [](toml::table&& tbl) // spec-int-4
							   {
								   const auto expected = toml::table{
									   { R"(int4)"sv, -17 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-5")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_5,
							   [](toml::table&& tbl) // spec-int-5
							   {
								   const auto expected = toml::table{
									   { R"(int5)"sv, 1000 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-6")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_6,
							   [](toml::table&& tbl) // spec-int-6
							   {
								   const auto expected = toml::table{
									   { R"(int6)"sv, 5349221 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-7")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_7,
							   [](toml::table&& tbl) // spec-int-7
							   {
								   const auto expected = toml::table{
									   { R"(int7)"sv, 12345 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-bin1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_bin1,
							   [](toml::table&& tbl) // spec-int-bin1
							   {
								   const auto expected = toml::table{
									   { R"(bin1)"sv, 214 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-hex1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_hex1,
							   [](toml::table&& tbl) // spec-int-hex1
							   {
								   const auto expected = toml::table{
									   { R"(hex1)"sv, 3735928559 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-hex2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_hex2,
							   [](toml::table&& tbl) // spec-int-hex2
							   {
								   const auto expected = toml::table{
									   { R"(hex2)"sv, 3735928559 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-hex3")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_hex3,
							   [](toml::table&& tbl) // spec-int-hex3
							   {
								   const auto expected = toml::table{
									   { R"(hex3)"sv, 3735928559 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-max")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_max,
							   [](toml::table&& tbl) // spec-int-max
							   {
								   const auto expected = toml::table{
									   { R"(max)"sv, std::numeric_limits<int64_t>::max() },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-min")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_min,
							   [](toml::table&& tbl) // spec-int-min
							   {
								   const auto expected = toml::table{
									   { R"(min)"sv, std::numeric_limits<int64_t>::min() },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-oct1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_oct1,
							   [](toml::table&& tbl) // spec-int-oct1
							   {
								   const auto expected = toml::table{
									   { R"(oct1)"sv, 342391 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-int-oct2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_int_oct2,
							   [](toml::table&& tbl) // spec-int-oct2
							   {
								   const auto expected = toml::table{
									   { R"(oct2)"sv, 493 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-key-value-pair-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_key_value_pair_1,
							   [](toml::table&& tbl) // spec-key-value-pair-1
							   {
								   const auto expected = toml::table{
									   { R"(key)"sv, R"(value)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-key-value-pair-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_key_value_pair_2,
							   [](toml::table&& tbl) // spec-key-value-pair-2
							   {
								   const auto expected = toml::table{
									   { R"(bare_key)"sv, R"(value)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-key-value-pair-3")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_key_value_pair_3,
							   [](toml::table&& tbl) // spec-key-value-pair-3
							   {
								   const auto expected = toml::table{
									   { R"(bare-key)"sv, R"(value)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-key-value-pair-4")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_key_value_pair_4,
							   [](toml::table&& tbl) // spec-key-value-pair-4
							   {
								   const auto expected = toml::table{
									   { R"(1234)"sv, R"(value)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-key-value-pair-5")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_key_value_pair_5,
							   [](toml::table&& tbl) // spec-key-value-pair-5
							   {
								   const auto expected = toml::table{
									   { R"(1234)"sv, R"(value)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-key-value-pair-6")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_key_value_pair_6,
							   [](toml::table&& tbl) // spec-key-value-pair-6
							   {
								   const auto expected = toml::table{
									   { R"(-)"sv, 1 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-key-value-pair-7")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_key_value_pair_7,
							   [](toml::table&& tbl) // spec-key-value-pair-7
							   {
								   const auto expected = toml::table{
									   { R"(_)"sv, 1 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-key-value-pair-8")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_key_value_pair_8,
							   [](toml::table&& tbl) // spec-key-value-pair-8
							   {
								   const auto expected = toml::table{
									   { R"(-_-_-_-_-)"sv, 1 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-key-value-pair-9")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_key_value_pair_9,
							   [](toml::table&& tbl) // spec-key-value-pair-9
							   {
								   const auto expected = toml::table{
									   { R"(3)"sv,
										 toml::table{
											 { R"(14159)"sv, R"(pi)"sv },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-newline-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_newline_1,
							   [](toml::table&& tbl) // spec-newline-1
							   {
								   const auto expected = toml::table{
									   { R"(abc)"sv, 123 },
									   { R"(def)"sv, 456 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-newline-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_newline_2,
							   [](toml::table&& tbl) // spec-newline-2
							   {
								   const auto expected = toml::table{
									   { R"(abc)"sv, 123 },
									   { R"(def)"sv, 456 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-newline-3")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_newline_3,
							   [](toml::table&& tbl) // spec-newline-3
							   {
								   const auto expected = toml::table{
									   { R"(abc)"sv, 123 },
									   { R"(def)"sv, 456 },
									   { R"(ghi)"sv, 789 },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-quoted-literal-keys-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_quoted_literal_keys_1,
							   [](toml::table&& tbl) // spec-quoted-literal-keys-1
							   {
								   const auto expected = toml::table{
									   { R"(quoted "value")"sv, R"(value)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-readme-example")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_readme_example,
							   [](toml::table&& tbl) // spec-readme-example
							   {
								   const auto expected = toml::table{
									   { R"(title)"sv, R"(TOML Example)"sv },
									   { R"(owner)"sv,
										 toml::table{
											 { R"(name)"sv, R"(Tom Preston-Werner)"sv },
											 { R"(dob)"sv, toml::date_time{ { 1979, 5, 27 }, { 7, 32 }, { -8, 0 } } },
										 } },
									   { R"(database)"sv,
										 toml::table{
											 { R"(server)"sv, R"(192.168.1.1)"sv },
											 { R"(ports)"sv,
											   toml::array{
												   8001,
												   8001,
												   8002,
											   } },
											 { R"(connection_max)"sv, 5000 },
											 { R"(enabled)"sv, true },
										 } },
									   { R"(servers)"sv,
										 toml::table{
											 { R"(alpha)"sv,
											   toml::table{
												   { R"(ip)"sv, R"(10.0.0.1)"sv },
												   { R"(dc)"sv, R"(eqdc10)"sv },
											   } },
											 { R"(beta)"sv,
											   toml::table{
												   { R"(ip)"sv, R"(10.0.0.2)"sv },
												   { R"(dc)"sv, R"(eqdc10)"sv },
											   } },
										 } },
									   { R"(clients)"sv,
										 toml::table{
											 { R"(data)"sv,
											   toml::array{
												   toml::array{
													   R"(gamma)"sv,
													   R"(delta)"sv,
												   },
												   toml::array{
													   1,
													   2,
												   },
											   } },
											 { R"(hosts)"sv,
											   toml::array{
												   R"(alpha)"sv,
												   R"(omega)"sv,
											   } },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-basic-multiline-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_basic_multiline_1,
							   [](toml::table&& tbl) // spec-string-basic-multiline-1
							   {
								   const auto expected = toml::table{
									   { R"(str1)"sv, R"(Roses are red
Violets are blue)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-basic-multiline-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_basic_multiline_2,
							   [](toml::table&& tbl) // spec-string-basic-multiline-2
							   {
								   const auto expected = toml::table{
									   { R"(str)"sv, R"(The quick brown fox jumps over the lazy dog.)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-basic-multiline-3")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_basic_multiline_3,
							   [](toml::table&& tbl) // spec-string-basic-multiline-3
							   {
								   const auto expected = toml::table{
									   { R"(str)"sv, R"(The quick brown fox jumps over the lazy dog.)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-basic-multiline-4")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_basic_multiline_4,
							   [](toml::table&& tbl) // spec-string-basic-multiline-4
							   {
								   const auto expected = toml::table{
									   { R"(a)"sv, R"(abcdef)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-basic-multiline-5")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_basic_multiline_5,
							   [](toml::table&& tbl) // spec-string-basic-multiline-5
							   {
								   const auto expected = toml::table{
									   { R"(ml-escaped-nl)"sv, R"(  foo bar \
  baz \quux)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-basic-multiline-6")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_basic_multiline_6,
							   [](toml::table&& tbl) // spec-string-basic-multiline-6
							   {
								   const auto expected = toml::table{
									   { R"(str4)"sv, R"(Here are two quotation marks: "". Simple enough.)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-basic-multiline-7")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_basic_multiline_7,
							   [](toml::table&& tbl) // spec-string-basic-multiline-7
							   {
								   const auto expected = toml::table{
									   { R"(str5)"sv, R"(Here are three quotation marks: """.)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-basic-multiline-8")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_basic_multiline_8,
							   [](toml::table&& tbl) // spec-string-basic-multiline-8
							   {
								   const auto expected = toml::table{
									   { R"(str6)"sv, R"(Here are fifteen quotation marks: """"""""""""""".)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-basic-multiline-9")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_basic_multiline_9,
							   [](toml::table&& tbl) // spec-string-basic-multiline-9
							   {
								   const auto expected = toml::table{
									   { R"(str7)"sv, R"("This," she said, "is just a pointless statement.")"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-basic-tab-multiline")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_basic_tab_multiline,
							   [](toml::table&& tbl) // spec-string-basic-tab-multiline
							   {
								   const auto expected = toml::table{
									   { R"(str)"sv, R"(This is a	tab)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-basic-tab")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_basic_tab,
							   [](toml::table&& tbl) // spec-string-basic-tab
							   {
								   const auto expected = toml::table{
									   { R"(str)"sv, R"(This is a	tab)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-escape-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_escape_1,
							   [](toml::table&& tbl) // spec-string-escape-1
							   {
								   const auto expected = toml::table{
									   { R"(a)"sv, "\x08"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-escape-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_escape_2,
							   [](toml::table&& tbl) // spec-string-escape-2
							   {
								   const auto expected = toml::table{
									   { R"(a)"sv, R"(	)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-escape-3")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_escape_3,
							   [](toml::table&& tbl) // spec-string-escape-3
							   {
								   const auto expected = toml::table{
									   { R"(a)"sv, R"(
)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-escape-4")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_escape_4,
							   [](toml::table&& tbl) // spec-string-escape-4
							   {
								   const auto expected = toml::table{
									   { R"(a)"sv, "\f"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-escape-5")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_escape_5,
							   [](toml::table&& tbl) // spec-string-escape-5
							   {
								   const auto expected = toml::table{
									   { R"(a)"sv, "\r"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-escape-6")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_escape_6,
							   [](toml::table&& tbl) // spec-string-escape-6
							   {
								   const auto expected = toml::table{
									   { R"(a)"sv, R"(")"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-escape-7")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_escape_7,
							   [](toml::table&& tbl) // spec-string-escape-7
							   {
								   const auto expected = toml::table{
									   { R"(a)"sv, R"(\)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-escape-8")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_escape_8,
							   [](toml::table&& tbl) // spec-string-escape-8
							   {
								   const auto expected = toml::table{
									   { R"(a)"sv, "\x00"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-escape-9")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_escape_9,
							   [](toml::table&& tbl) // spec-string-escape-9
							   {
								   const auto expected = toml::table{
									   { R"(a)"sv, "\x00"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-literal-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_literal_1,
							   [](toml::table&& tbl) // spec-string-literal-1
							   {
								   const auto expected = toml::table{
									   { R"(winpath)"sv, R"(C:\Users\nodejs\templates)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-literal-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_literal_2,
							   [](toml::table&& tbl) // spec-string-literal-2
							   {
								   const auto expected = toml::table{
									   { R"(winpath2)"sv, R"(\\ServerX\admin$\system32\)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-literal-3")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_literal_3,
							   [](toml::table&& tbl) // spec-string-literal-3
							   {
								   const auto expected = toml::table{
									   { R"(quoted)"sv, R"(Tom "Dubs" Preston-Werner)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-literal-4")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_literal_4,
							   [](toml::table&& tbl) // spec-string-literal-4
							   {
								   const auto expected = toml::table{
									   { R"(regex)"sv, R"(<\i\c*\s*>)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-literal-multiline-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_literal_multiline_1,
							   [](toml::table&& tbl) // spec-string-literal-multiline-1
							   {
								   const auto expected = toml::table{
									   { R"(regex2)"sv, R"(I [dw]on't need \d{2} apples)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-literal-multiline-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_literal_multiline_2,
							   [](toml::table&& tbl) // spec-string-literal-multiline-2
							   {
								   const auto expected = toml::table{
									   { R"(lines)"sv, R"(The first newline is
trimmed in raw strings.
   All other whitespace
   is preserved.
)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-literal-multiline-3")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_literal_multiline_3,
							   [](toml::table&& tbl) // spec-string-literal-multiline-3
							   {
								   const auto expected = toml::table{
									   { R"(quot15)"sv, R"(Here are fifteen quotation marks: """"""""""""""")"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-literal-multiline-4")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_literal_multiline_4,
							   [](toml::table&& tbl) // spec-string-literal-multiline-4
							   {
								   const auto expected = toml::table{
									   { R"(str)"sv, R"('That,' she said, 'is still pointless.')"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-table-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_table_1,
							   [](toml::table&& tbl) // spec-table-1
							   {
								   const auto expected = toml::table{
									   { R"(table-1)"sv,
										 toml::table{
											 { R"(key1)"sv, R"(some string)"sv },
											 { R"(key2)"sv, 123 },
										 } },
									   { R"(table-2)"sv,
										 toml::table{
											 { R"(key1)"sv, R"(another string)"sv },
											 { R"(key2)"sv, 456 },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-table-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_table_2,
							   [](toml::table&& tbl) // spec-table-2
							   {
								   const auto expected = toml::table{
									   { R"(dog)"sv,
										 toml::table{
											 { R"(tater.man)"sv,
											   toml::table{
												   { R"(type)"sv,
													 toml::table{
														 { R"(name)"sv, R"(pug)"sv },
													 } },
											   } },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-table-3")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_table_3,
							   [](toml::table&& tbl) // spec-table-3
							   {
								   const auto expected = toml::table{
									   { R"(a)"sv,
										 toml::table{
											 { R"(b)"sv,
											   toml::table{
												   { R"(c)"sv, toml::table{} },
											   } },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-table-4")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_table_4,
							   [](toml::table&& tbl) // spec-table-4
							   {
								   const auto expected = toml::table{
									   { R"(d)"sv,
										 toml::table{
											 { R"(e)"sv,
											   toml::table{
												   { R"(f)"sv, toml::table{} },
											   } },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-table-5")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_table_5,
							   [](toml::table&& tbl) // spec-table-5
							   {
								   const auto expected = toml::table{
									   { R"(g)"sv,
										 toml::table{
											 { R"(h)"sv,
											   toml::table{
												   { R"(i)"sv, toml::table{} },
											   } },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-table-7")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_table_7,
							   [](toml::table&& tbl) // spec-table-7
							   {
								   const auto expected = toml::table{
									   { R"(x)"sv,
										 toml::table{
											 { R"(y)"sv,
											   toml::table{
												   { R"(z)"sv,
													 toml::table{
														 { R"(w)"sv, toml::table{} },
													 } },
											   } },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-table-8")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_table_8,
							   [](toml::table&& tbl) // spec-table-8
							   {
								   const auto expected = toml::table{
									   { R"(fruit)"sv,
										 toml::table{
											 { R"(apple)"sv,
											   toml::table{
												   { R"(color)"sv, R"(red)"sv },
												   { R"(taste)"sv,
													 toml::table{
														 { R"(sweet)"sv, true },
													 } },
												   { R"(texture)"sv,
													 toml::table{
														 { R"(smooth)"sv, true },
													 } },
											   } },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-table-inline-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_table_inline_1,
							   [](toml::table&& tbl) // spec-table-inline-1
							   {
								   const auto expected = toml::table{
									   { R"(name)"sv,
										 toml::table{
											 { R"(first)"sv, R"(Tom)"sv },
											 { R"(last)"sv, R"(Preston-Werner)"sv },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-table-inline-2")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_table_inline_2,
							   [](toml::table&& tbl) // spec-table-inline-2
							   {
								   const auto expected = toml::table{
									   { R"(point)"sv,
										 toml::table{
											 { R"(x)"sv, 1 },
											 { R"(y)"sv, 2 },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-table-inline-3")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_table_inline_3,
							   [](toml::table&& tbl) // spec-table-inline-3
							   {
								   const auto expected = toml::table{
									   { R"(animal)"sv,
										 toml::table{
											 { R"(type)"sv,
											   toml::table{
												   { R"(name)"sv, R"(pug)"sv },
											   } },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-table")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_table,
							   [](toml::table&& tbl) // spec-table
							   {
								   const auto expected = toml::table{
									   { R"(table)"sv, toml::table{} },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-time-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_time_1,
							   [](toml::table&& tbl) // spec-time-1
							   {
								   const auto expected = toml::table{
									   { R"(lt1)"sv, toml::time{ 7, 32 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

#if UNICODE_LITERALS_OK

	SECTION("spec-quoted-basic-keys-1")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_quoted_basic_keys_1,
							   [](toml::table&& tbl) // spec-quoted-basic-keys-1
							   {
								   const auto expected = toml::table{
									   { R"(ʎǝʞ)"sv, R"(value)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-string-basic")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_string_basic,
							   [](toml::table&& tbl) // spec-string-basic
							   {
								   const auto expected = toml::table{
									   { R"(str)"sv, R"(I'm a string. "You can quote me". Name	José
Location	SF.)"sv },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

	SECTION("spec-table-6")
	{
		parsing_should_succeed(FILE_LINE_ARGS,
							   spec_table_6,
							   [](toml::table&& tbl) // spec-table-6
							   {
								   const auto expected = toml::table{
									   { R"(j)"sv,
										 toml::table{
											 { R"(ʞ)"sv,
											   toml::table{
												   { R"(l)"sv, toml::table{} },
											   } },
										 } },
								   };
								   REQUIRE(tbl == expected);
							   });
	}

#endif // UNICODE_LITERALS_OK
}
