/**************************************************************/
/* ********************************************************** */
/* *                                                        * */
/* *                     TABLEAUS                           * */
/* *                                                        * */
/* *  $Module:   TABLEAU                                    * */
/* *                                                        * */
/* *  Copyright (C) 1998, 1999, 2000, 2001                  * */
/* *  MPI fuer Informatik                                   * */
/* *                                                        * */
/* *  This program is free software; you can redistribute   * */
/* *  it and/or modify it under the terms of the FreeBSD    * */
/* *  Licence.                                              * */
/* *                                                        * */
/* *  This program is distributed in the hope that it will  * */
/* *  be useful, but WITHOUT ANY WARRANTY; without even     * */
/* *  the implied warranty of MERCHANTABILITY or FITNESS    * */
/* *  FOR A PARTICULAR PURPOSE.  See the LICENCE file       * */
/* *  for more details.                                     * */
/* *                                                        * */
/* *                                                        * */
/* $Revision: 1.5 $                                         * */
/* $State: Exp $                                            * */
/* $Date: 2011-05-25 10:03:04 $                             * */
/* $Author: weidenb $                                       * */
/* *                                                        * */
/* *             Contact:                                   * */
/* *             Christoph Weidenbach                       * */
/* *             MPI fuer Informatik                        * */
/* *             Stuhlsatzenhausweg 85                      * */
/* *             66123 Saarbruecken                         * */
/* *             Email: spass@mpi-inf.mpg.de                * */
/* *             Germany                                    * */
/* *                                                        * */
/* ********************************************************** */
/**************************************************************/


/* $RCSfile: tableau.h,v $ */

#ifndef _TABLEAU_
#define _TABLEAU_


#include "list.h"
#include "clause.h"

typedef struct TABLEAU_HELP {
  LIST   Clauses;               /* all clauses generated on the split level */
  CLAUSE SplitClause;           /* this levels split clause */

  CLAUSE LeftSplitClause;       /* first clause generated by split  */
  LIST   RightSplitClauses;     /* other clauses generated by split */

  struct TABLEAU_HELP* LeftBranch;  /* branch corresponding to first split clause  */
  struct TABLEAU_HELP* RightBranch; /* branch corresponding to other split clauses */

  int  Label;
} TABLEAU_NODE, *TABLEAU;


typedef struct {
  TABLEAU *Path;      /* An array of tableaux */
  int     Length;
  int     MaxLength;
  
} TABPATH_NODE, *TABPATH;

/* tableau output formats */
typedef enum { DAVINCI, XVCG } GRAPHFORMAT;


TABPATH tab_PathCreate(int, TABLEAU);
void    tab_PathDelete(TABPATH);
BOOL    tab_PathContainsClause(TABPATH, CLAUSE);
void    tab_AddClauseOnItsLevel(CLAUSE, TABPATH);
void    tab_AddSplitAtCursor(TABPATH, BOOL);
BOOL    tab_IsClosed(TABLEAU);
TABLEAU tab_PruneClosedBranches(TABLEAU, LIST*);
int     tab_Depth(TABLEAU);
void    tab_SetSplitLevels(TABLEAU T);
TABLEAU tab_RemoveIncompleteSplits(TABLEAU, LIST*);
TABLEAU tab_RemoveUnfinishedSplits(TABLEAU, LIST*);
void    tab_PathDelete(TABPATH);
void    tab_Delete(TABLEAU);
void    tab_ToClauseList(TABLEAU, LIST*);
void    tab_GetEarliestEmptyClauses(TABLEAU, LIST*);
void    tab_WriteTableau(TABLEAU, const char*, GRAPHFORMAT);
void    tab_CheckEmpties(TABLEAU);
void    tab_GetAllEmptyClauses(TABLEAU, LIST*);
void    tab_LabelNodes(TABLEAU);
void    tab_PrintTableau(TABLEAU);


/* inline functions for tableau paths */

 int  tab_PathLength(TABPATH TabPath);

 TABLEAU tab_PathNthNode(TABPATH TabPath, int n);

 TABPATH tab_PathPush(TABLEAU Tab, TABPATH TabPath);

 TABLEAU tab_EmptyTableau(void);

 TABPATH tab_PathPop(TABPATH TabPath);

 BOOL tab_PathEmpty(TABPATH P);

 TABLEAU tab_CreateNode(void);

 TABPATH tab_PathPrefix(int Level, TABPATH TabPath);

 TABLEAU tab_PathTop(TABPATH Path);

 BOOL tab_IsEmpty(TABLEAU Tab);

 TABLEAU tab_RightBranch(TABLEAU Tab);

 TABLEAU tab_LeftBranch(TABLEAU Tab);

 void tab_SetRightBranch(TABLEAU Tab, TABLEAU SubTab);

 void tab_SetLeftBranch(TABLEAU Tab, TABLEAU SubTab);

 BOOL tab_RightBranchIsEmpty(TABLEAU Tab);

 BOOL tab_LeftBranchIsEmpty(TABLEAU Tab);

 CLAUSE tab_SplitClause(TABLEAU Tab);

 void tab_SetSplitClause(TABLEAU Tab, CLAUSE C);

 BOOL tab_HasSplit(TABLEAU T);

 void tab_AddClause(CLAUSE C,TABLEAU T);

 LIST tab_Clauses(TABLEAU T);

 void tab_SetClauses(TABLEAU T, LIST Clauses);

 CLAUSE tab_LeftSplitClause(TABLEAU T);

 void tab_SetLeftSplitClause(TABLEAU T, CLAUSE C);

 LIST tab_RightSplitClauses(TABLEAU T);

 void tab_SetRightSplitClauses(TABLEAU T, LIST L);

 void tab_AddRightSplitClause(TABLEAU T, CLAUSE C);

 BOOL tab_IsLeaf(TABLEAU T);

#endif
