/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "engines/game.h"
#include "common/gui_options.h"
#include "common/language.h"

namespace Glk {
namespace Glulx {

const PlainGameDescriptor GLULXE_GAME_LIST[] = {
	{ "glulx", "Glulx Game" },

	// English games
	{ "aafn", "An Apple From Nowhere" },
	{ "aardvarkvshype", "AardVarK versus The Hype" },
	{ "abca", "A Beauty Cold and Austere" },
	{ "academicpursuits", "Academic Pursuits As Opposed To Regular Pursuits" },
	{ "acbs", "A Cock and Bull Story" },
	{ "acg", "Adventurer's Consumer Guide" },
	{ "acmj", "The Making of ACMJ Game" },
	{ "adventglulx", "Adventure" },
	{ "adventura", "Adventura" },
	{ "ailiphilia", "Ailiphilia - A *GASP* SAGA!" },
	{ "airport", "The Airport" },
	{ "alabaster", "Alabaster" },
	{ "aliasthemagpie", "Alias 'The Magpie'" },
	{ "alone", "Alone" },
	{ "alongdrink", "A Long Drink" },
	{ "anatidaephobia", "A N A T I D A E P H O B I A" },
	{ "anchorheaddemo", "Anchorhead: Special Edition Demo" },
	{ "anchorhead", "Anchorhead" },
	{ "andelmanyard", "Andelmans' Yard" },
	{ "andromeda1983", "Andromeda 1983" },
	{ "andromedaapocalypseext", "Andromeda Apocalypse (Extended Edition)" },
	{ "andromedaascending", "Andromeda Ascending" },
	{ "andromedaawakening", "Andromeda Awakening - The Final Cut"},
	{ "andromedadream", "Andromeda Dreaming" },
	{ "apumpkin", "A Pumpkin" },
	{ "archaeologicalfiction", "Archaeological Fiction" },
	{ "ariadneinaeaea", "Ariadne in Aeaea" },
	{ "aroilingoriginal", "A Roiling Original: Squeeal! A Sequel!" },
	{ "aropeofchalk", "A Rope of Chalk" },
	{ "artoffugue", "Art of Fugue" },
	{ "ascensionlimbs", "Ascension of Limbs" },
	{ "ascentgothictower", "The Ascent of the Gothic Tower" },
	{ "atc", "ATC, an interactive aviation" },
	{ "aurora", "Aurora" },
	{ "balancesglulx", "Balances" },
	{ "baretegi", "Baretegi" },
	{ "barroombrawl", "Barroom Brawl: Punch for your life" },
	{ "batman66", "Batman 66" },
	{ "beasttorrackmoor", "The Beast of Torrack Moor" },
	{ "beautyaustere", "A Beauty Cold and Austere" },
	{ "becauseyouremine", "Because You're Mine" },
	{ "beingthere", "Being There" },
	{ "blackknife", "Black Knife London" },
	{ "blindhouse", "The Blind House" },
	{ "bluelacuna", "Blue Lacuna" },
	{ "bonehead", "Bonehead, a Regrettable and Mostly True Tale" },
	{ "brainguzzlers", "Brain Guzzlers from Beyond!" },
	{ "briar", "Briar, a Grimmly Perverted Fairy Tale" },
	{ "btyt", "Bigger Than You Think" },
	{ "bullhockey", "Bullhockey!" },
	{ "bullhockey2", "Bullhockey 2 - The Return of the Leather Whip" },
	{ "bureaucrocyglulx", "Bureaucrocy, a boring tale about paperwork" },
	{ "buygold", "Buy Gold" },
	{ "calm", "Calm, a Game of Postapocalyptic Relaxation" },
	{ "candlewindless", "Candle flames in windless air" },
	{ "canyouescape", "Can You Escape" },
	{ "castronegroblues", "Castronegro Blues" },
	{ "caveglulx", "Cave" },
	{ "cheesedoffglulx", "Cheesed Off! A very cheesey adventure" },
	{ "childrenloblolly", "The Children of Loblolly Lodge" },
	{ "chipmonk", "Chipmonk" },
	{ "chlorophyll", "Chlorophyll" },
	{ "codetopia", "Codetopia - A Code Adventure" },
	{ "colderlight", "The Colder Light: A Winter's Tale" },
	{ "colorthetruth", "Color the Truth" },
	{ "comehouse", "And Then You Come to a House Not Unlike the Previous One" },
	{ "comp01tr", "Comp01ter Game: N0n C0mp0s Ment1s" },
	{ "confhist", "Conflicting Histories" },
	{ "cos", "City of Secrets" },
	{ "cosmoserveglulx", "CosmoServe: An Adventure for the BBS-Enslaved" },
	{ "counterfeitmonkey", "Counterfeit Monkey" },
	{ "countingcrabs", "Counting Crabs: How many crabs can you count?" },
	{ "crackcoldone", "Crack open a cold one with the Boiz" },
	{ "cragne", "Cragne Manor" },
	{ "crashdisaster", "Crash: An Interactive Disaster" },
	{ "damesdeadites", "Dames and Deadites" },
	{ "dansenocturne", "Danse Nocturne" },
	{ "darkcarnival", "Dark Carnival" },
	{ "darknessglulx", "Darkness" },
	{ "deadcities", "Dead Cities" },
	{ "deathoffthecuff", "Death Off the Cuff" },
	{ "delphinashouse", "Delphina's House" },
	{ "desolation", "Desolation" },
	{ "diaperquest", "Diaper Quest" },
	{ "discovertheworld", "Discover The World" },
	{ "doctorm", "The Life (and Deaths) of Doctor M" },
	{ "donotmeddle", "Do Not Meddle" },
	{ "douchebag", "Douchebag, an Existential Adventure" },
	{ "downtheserpent", "Down, the Serpent and the Sun: an Anatomy" },
	{ "dptmb2aa", "Don't Push The Mailbox 2 And Aisle" },
	{ "dracula1glulx", "Dracula: Part 1, The First Night" },
	{ "dracula2glulx", "Dracula: Part 2, The Arrival" },
	{ "dragondemons", "Dragon Demons: A World Traveling RPG" },
	{ "dragonglulx", "Dragon Adventure" },
	{ "dragonpass", "Dragon's Pass" },
	{ "drhorror", "Dr Horror's House of Terror" },
	{ "drolltolltroll", "Droll Toll Troll" },
	{ "dudewheresmyscapula", "Dude, Where's My Scapula" },
	{ "duelspannedages", "The Duel that Spanned the Ages" },
	{ "dungeonspuzzle", "Dungeon's Puzzle" },
	{ "dungeontext1", "Dungeon Text I - Escape From Darkness" },
	{ "dynamitepowers", "Dynamite Powers vs. the Ray of Night!" },
	{ "eatme", "Eat Me" },
	{ "elsegar1", "Elsegar I - Arrival" },
	{ "endlesssands", "Endless Sands" },
	{ "endling", "The Endling Archive" },
	{ "enterpriseincidents", "The Enterprise Incidents: A Middle School Fantasy" },
	{ "equivocalingredient", "The Equivocal Ingredient" },
	{ "exigentseasons", "The Exigent Seasons" },
	{ "fair", "Fair, an extra-curricular activity" },
	{ "fairest", "Fairest" },
	{ "familiar", "The Familiar" },
	{ "farmquest", "Farm Quest" },
	{ "fatfair", "Fat Fair" },
	{ "ferrousring", "Ferrous Ring" },
	{ "ferrymansgate", "Ferryman's Gate" },
	{ "finalproject", "Final Project" },
	{ "flattenedlondon", "Flattened London" },
	{ "flexiblesurvival", "Flexible Survival" },
	{ "followingastar", "The Bible Retold: Following A Star" },
	{ "foraplace", "For a Place by the Putrid Sea" },
	{ "further", "Further, a color-coded existential tangle" },
	{ "gaiawebch12", "Gaia-Web Chapter 12: The Silence of the Thunder" },
	{ "gatewayferrets", "Gateway of the Ferrets" },
	{ "genesisquest", "Genesis Quest, an interlude through stories" },
	{ "getout", "Get Out!" },
	{ "ghosteringtonnight", "Ghosterington Night" },
	{ "ghostglulx", "Ghost" },
	{ "ghostguessed", "What Heart Heard Of, Ghost Guessed" },
	{ "glkchess", "Glk Chess" },
	{ "glkebook", "GlkeBook" },
	{ "greenmountains", "The Green Mountains" },
	{ "groovebillygoat", "Groove Billygoat" },
	{ "grooverland", "Grooverland" },
	{ "hardpuzzle1", "Hard Puzzle" },
	{ "hardpuzzle2", "Hard Puzzle 2: The Cow" },
	{ "hardpuzzle3", "Hard Puzzle 3: Origins" },
	{ "haroldnight2003", "Harold Night 2003" },
	{ "hercules", "Hercules!" },
	{ "herecomestreble", "Here Comes Treble" },
	{ "hlmarooned", "Hinterlands: Marooned!" },
	{ "hobbitglulx", "The Hobbit - The True Story" },
	{ "hobbitredux", "The Hobbit - The True Story - Redux, Director's Cut" },
	{ "houseofmemories", "House of Memories" },
	{ "houseofmystery",  "The House of Mystery" },
	{ "hungerdaemon", "Hunger Daemon" },
	{ "illum", "Illuminismo Iniziato, an Interactive Illumination" },
	{ "illwind", "Ill Wind, Yet Another Interactive Enigma" },
	{ "immunesystem", "Immune System" },
	{ "improvorigins", "Improv-Origins" },
	{ "ingoodcompany", "In Good Company" },
	{ "jackglulx", "Jack" },
	{ "jadeite", "Jadeite for the Queen" },
	{ "jasonandmedea", "Jason and Medea" },
	{ "kerkerkruip", "Kerkerkruip" },
	{ "killerheadache", "A Killer Headache" },
	{ "kingshredspatches", "The King of Shreds and Patches" },
	{ "klaustrophobia", "Klaustrophobia" },
	{ "koa", "Kingdom of Amphibia" },
	{ "lasthouse", "Last House on the Block" },
	{ "lastresort", "Last Resort, a sweltering afternoon in the Deep South" },
	{ "limeergot", "Lime Ergot" },
	{ "limen", "Limen" },
	{ "lmstvgglulx", "LMS The Video Game" },
	{ "lockdown", "Lockdown: a story of insanity, denial and death" },
	{ "lockeddoor10", "Locked Door X: The Workprint" },
	{ "lockeddoor11", "Locked Door XI: The US Theatrical Cut" },
	{ "lockkey", "Lock and Key" },
	{ "lonelytroll", "The Lonely Troll" },
	{ "lostislandsofalabaz", "The Lost Islands of Alabaz" },
	{ "lovelyassistant", "Lovely Assistant Magical Girl" },
	{ "madametime", "The Origin of Madame Time" },
	{ "makechangeglulx", "Maybe make some change" },
	{ "makingme", "The Making of Me" },
	{ "mgaeb", "My Girlfriend's An Evil Bitch" },
	{ "mollybutterthieves", "Molly and the Butter Thieves" },
	{ "moments1", "Moments out of Time: Renegade" },
	{ "moments2", "Moments out of Time 2: Adventure Type" },
	{ "monksea", "Monk by the Sea" },
	{ "moonbaseindigo", "Moonbase Indigo" },
	{ "mugglestudies", "Muggle Studies" },
	{ "mystery", "Mystery!" },
	{ "narco", "Narcolepsy" },
	{ "necronskeep", "Necron's Keep" },
	{ "newcat", "New Cat" },
	{ "nightmare", "Nightmare" },
	{ "nowheresville", "Nowheresville" },
	{ "nssri", "No Sign Should Remain Inert" },
	{ "officegoose", "Office Goose" },
	{ "oldfogey", "Old Fogey" },
	{ "oldhhouse", "This Old Haunted House" },
	{ "oliviasorphanorium", "Olivia's Orphanorium" },
	{ "onefishtwofish", "One Fish Two Fish" },
	{ "oppositelyopal", "Oppositely Opal" },
	{ "ottumwaglulx", "PDFA Ottumwa" },
	{ "owlconsults", "The Owl Consults" },
	{ "phoenixfire", "Phoenix-Fire" },
	{ "photopiaglulx", "Photopia" },
	{ "piedaterreblunders", "Captain Piedaterre's Blunders" },
	{ "pinched", "Pinched" },
	{ "pizzadelivery", "Pizza Delivery" },
	{ "playinggames", "Playing Games" },
	{ "portfoliopiece", "Portfolio Piece" },
	{ "psychomanteum", "Psychomanteum" },
	{ "pythoglulx", "Pytho's Mask" },
	{ "raidersstones", "Raiders of the Holy Stones" },
	{ "rar", "Reference and Representation: An Approach to First-Order Semantics" },
	{ "returnstars", "Return to the Stars" },
	{ "reorsbushcaveglulx", "Reor's Bush-Cave" },
	{ "risorgglulx", "Risorgimento Represso" },
	{ "robinandorchid", "Robin & Orchid" },
	{ "rocketmanfromsea", "The Rocket Man from the Sea" },
	{ "roguelikegoose", "Roguelike Goose" },
	{ "rosewood", "The House at the End of Rosewood Street" },
	{ "rover", "Rover's Day Out" },
	{ "safe", "Safe" },
	{ "sagebrushcactus", "'Mid the sagebrush and the cactus" },
	{ "sagesanctumscramble", "Sage Sanctum Scramble" },
	{ "samfortunepi", "Sam Fortune - Private Investigator" },
	{ "scrollthief", "Scroll Thief, an Interactive Heist" },
	{ "seasonalapocalypse", "Seasonal Apocalypse Disorder" },
	{ "secretletter", "Jack Toresal and the Secret Letter" },
	{ "section1awakened", "Section 1 - Awakened" },
	{ "seedscafe", "Seeds Cafe" },
	{ "sensory", "Sensory Jam" },
	{ "sequitur", "Sequitur" },
	{ "shadowcathedral", "The Shadow in the Cathedral" },
	{ "shadowoperative", "Shadow Operative" },
	{ "shadowsdeep", "Of Their Shadows Deep" },
	{ "shapes", "Shapes: an Interactive Surrealism" },
	{ "sheephere", "Sheep Here" },
	{ "shufflingaround", "Shuffling Around" },
	{ "signalerror", "Signal Error: Tongue-in-cheek glitch correction" },
	{ "sittm", "Stick It To The Man" },
	{ "six", "Six" },
	{ "skiesabove", "Skies Above" },
	{ "skmmc", "Someone Keeps Moving My Chair" },
	{ "slouchingbedlamglulx", "Slouching Towards Bedlam" },
	{ "smittenkittens", "Smitten Kittens" },
	{ "songmockingbird", "The Song of the Mockingbird" },
	{ "spaceship", "Spaceship!" },
	{ "speedracer", "Speed Racer" },
	{ "spellbound", "Spellbound" },
	{ "spirI7wrak", "SpirI7wrak" },
	{ "standingshoulders", "Standing on the Shoulders of Giants" },
	{ "starlight", "Starlight" },
	{ "stiffymakane", "Stiffy Makane - Apocolocyntosis" },
	{ "sting", "Sting: An interactive memoir" },
	{ "stuffoflegend", "Stuff of Legend" },
	{ "subrosa", "Sub Rosa: The Seven Deceits of Confessor Destine" },
	{ "superluminalvagranttwin", "Superluminal Vagrant Twin" },
	{ "tcom", "The Colour of Magic" },
	{ "templeshorgil", "The Temple of Shorgil" },
	{ "terminatorchaser", "Terminator Chaser" },
	{ "terminatorrobotrescue", "Terminator, a Robot Rescue" },
	{ "theabbey", "The Abbey, a medieval murder mystery" },
	{ "theabsenceoflaw", "The Absence of Law" },
	{ "thebigfall", "The Big Fall" },
	{ "thebox", "The Box" },
	{ "thecrew", "The Crew – Journey to the Pale Planet" },
	{ "theeleusinianmiseries", "The Eleusinian Miseries" },
	{ "thefourthriddle", "The Fourth Riddle" },
	{ "thehours", "The Hours" },
	{ "thehouseoffear", "The House of Fear, or, Loplop Introduces the World" },
	{ "theinformal7abbreviated", "The Inform(al)7 Abbreviated Self Tutorial" },
	{ "theislandofdoctorwooby", "The Island of Doctor Wooby" },
	{ "thelaughinggnome", "The Laughing Gnome" },
	{ "thelibrary", "The Library" },
	{ "thelookout", "The Lookout" },
	{ "thelostkingdomofcodetopia", "The Lost Kingdom of Codetopia" },
	{ "thelostmountain", "The Lost Mountain" },
	{ "themagpietakesthetrain", "The Magpie Takes the Train" },
	{ "themaryjaneoftomorrow", "The Mary Jane of Tomorrow" },
	{ "themuseum", "The Museum" },
	{ "theoutcasts", "The Outcasts" },
	{ "thephoenixmove", "The Phoenix Move" },
	{ "therealmofaoria", "The Realm of A'oria" },
	{ "theredroom", "The Red Room" },
	{ "thesimpletale", "The Simple Tale" },
	{ "theskycrane", "The Sky Crane" },
	{ "thespectators", "The Spectators" },
	{ "thespywhoatelunch", "The Spy Who Ate Lunch" },
	{ "thestorm", "The Storm, a self-portrait" },
	{ "thethiefofwovenwoods", "The Thief of Woven Woods" },
	{ "thetimemachine2021", "The Time Machine" },
	{ "thetinyhouse", "The Tiny House" },
	{ "thetraintoabaddon", "The Train To Abaddon" },
	{ "thewaywardstory", "The Wayward Story" },
	{ "thiefpokemon", "Thief, a Pokemon Text Adventure" },
	{ "timecapsule", "A Time Capsule" },
	{ "timeless", "Timeless" },
	{ "todayisthesame", "Today is the Same as Any Other" },
	{ "tohellinahamper", "To Hell in a Hamper" },
	{ "tomtrundle", "The Incredibly Mild Misadventures of Tom Trundle" },
	{ "transparent", "Transparent, an interactive exploration" },
	{ "trialofthetnuop", "Trial of the Inuop" },
	{ "trollslayer", "Trollslayer" },
	{ "tryagain", "Try Again " },
	{ "turbochesthair", "Turbo Chest Hair Massacre" },
	{ "uglyoafs", "Ugly Oafs. Save Green Terra! Repel the Wrath Pulse!" },
	{ "uie", "Under, In Erebus" },
	{ "umwglulx", "UMW" },
	{ "uncleclemswill", "Uncle Clem's Will" },
	{ "underground", "Underground" },
	{ "undertheythunder", "Under They Thunder" },
	{ "unscientificfiction", "Unscientific Fiction" },
	{ "vainempires", "Vain Empires" },
	{ "valleyofsteel", "Valley of Steel" },
	{ "vampireltd", "Vampire Ltd" },
	{ "walking", "Walking" },
	{ "walkneighborhood", "A Walk Around the Neighborhood" },
	{ "wand", "The Wand" },
	{ "winterstormdraco", "Winter Storm Draco" },
	{ "wishertheurgist", "Wisher, Theurgist, Fatalist" },
	{ "wizardsniffer", "The Wizard Sniffer" },
	{ "wof", "Works of Fiction" },
	{ "wordoftheday", "Word of the Day" },
	{ "wordsofpower", "Words of Power" },
	{ "yourdeath4acts", "Your Death, in four acts" },
	{ "zeldata", "The Legend of Zelda: A Text Adventure" },
	{ "zorkglulx", "Zork: A Computerized Fantasy Simulation Game" },

	// Apollo 18+20 IF Tribute Album
	{ "apollo3glulx", "She's Actual Size" },
	{ "apollo10glulx", "Narrow Your Eyes" },
	{ "apollo12glulx", "Which Describes How You're Feeling" },
	{ "apollo15glulx", "Turn Around" },
	{ "apollo19glulx", "Fingertips - I Hear the Wind Blow" },
	{ "apollo33glulx", "Fingertips - Mysterious Whispers" },

	// Competition 2001
	{ "bestof3", "Best of three" },
	{ "carma", "Carma" },
	{ "smtuc", "Stiffy Makane: The Undiscovered Country" },

	// Competition 2002
	{ "eas2", "Earth and Sky: Episode 2 - Another Earth, Another Sky" },

	// Competition 2004
	{ "eas3", "Earth and Sky: Episode 3 - Luminous Horizon" },

	// Competition 2005
	{ "beyondglulx", "Beyond" },
	{ "cheiron", "Cheiron" },

	// Competition 2006
	{ "floatpoint", "Float Point" },

	// Competition 2007
	{ "chineseroom", "The Chinese Room" },
	{ "varkana", "Varkana" },

	// Competition 2008
	{ "amo", "A Martian Odyssey" },
	{ "chnlsurf", "Channel Surfing" },
	{ "crywolf", "Cry Wolf" },
	{ "everybodydies", "Everybody Dies, an Interactive Fantasy" },
	{ "recess", "Recess At Last" },

	// Competition 2009
	{ "brokenlegs", "Broken Legs" },
	{ "earlgrey", "Earl Grey" },
	{ "gis", "Grounded in Space" },
	{ "nightfall", "Nightfall" },
	{ "resonance", "Resonance" },

	// Competition 2010
	{ "aotearoa", "Aotearoa" },
	{ "divismortis", "Divis Mortis: an interactive survival game" },
	{ "gigantomania", "Gigantomania" },
	{ "grisjaune", "Gris et Jaune" },
	{ "oneeyeopen", "One Eye Open" },
	{ "oxygen", "Oxygen" },
	{ "inerebus", "Under, In Erebus" },

	// Competition 2011
	{ "awakemightydread", "Awake the Mighty Dread" },
	{ "beet", "Beet the Devil" },
	{ "deathofschlig", "Death of Schlig" },
	{ "faninterference", "Fan Interference" },
	{ "luster", "Luster" },
	{ "patanoir", "PataNoir" },
	{ "sentencing", "Sentencing Mr. Liddell" },
	{ "tacofiction", "Taco Fiction" },

	// Competition 2012
	{ "andromedaapoc", "Andromeda Apocalypse" },
	{ "imos", "In a Manor of Speaking" },
	{ "jdal", "J'dal" },
	{ "kicker", "Kicker" },

	// Competition 2013
	{ "awbp", "A Wind Blown from Paradise" },
	{ "captverdeterre", "Captain Verdeterre's Plunder" },
	{ "coloratura", "Coloratura" },
	{ "mazredugin", "Mazredugin" },
	{ "ooof", "Ollie Ollie Oxen Free" },
	{ "robinorchid", "Robin & Orchid" },
	{ "texbonaventure", "Tex Bonaventure and the Temple" },
	{ "cardewhouse", "The Cardew House" },


	// French games
	{ "ekphrasis", "Ekphrasis, les Aventures de Gilbert Fontenelle" },
	{ "lieuxcommunsglulx", "Lieux communs" },
	{ "sarvegneglulx", "Sarvegne, une visite qui conduit loin" },
	{ "scarabeekatana", "Le Scarabee et le Katana" },
	{ "templefeu", "Le Temple de Feu" },

	// German games
	{ "dergarten", "Der onirische Garten" },
	{ "deronirischegarten", "Der Garten: Der Aufenthalt in einem traumhaften Garten" },
	{ "jaeger", "Jäger der heiligen Steine - Ein Abenteuer in Raum und Zeit" },
	{ "kleinehalbling", "Der kleine Halbling" },
	{ "matthiasclaudius", "Der unsägliche und vermeidbare Tod des Matthias Claudius" },
	{ "morgenwirdklausur", "Morgen wird Klausur geschrieben" },
	{ "patanoirde", "PataNoir - Ein unvergleichlicher Kriminalfall" },
	{ "spaterbesuch", "Ein später Besuch" },

	// Italian games
	{ "pietradellaluna", "La Pietra della Luna" },
	{ "mancasolo", "Manca solo un verso a quella poesia" },
	{ "schizo", "Schizo - Escape to the Void" },
	{ "slendermanbase", "Slenderman - l'incubo (base)" },
	{ "slenderman", "Slenderman - l'incubo" },
	{ "snuff", "Snuff Movie" },
	{ "villamorganaglulx", "Villa Morgana" },

	// Spanish games
	{ "alienlaaventura", "ALIEN: La Aventura" },
	{ "conrumbo", "Con Rumbo" },
	{ "elultimohogarglulx", "Misterio en el Ultimo Hogar" },
	{ "hhorcusglulx", "Homo Homini Orcus" },
	{ "kerulenglulx", "Ke rulen los petas" },
	{ "lanochedelensayo", "La Noche del Ensayo" },
	{ "legado", "El Legado" },
	{ "regente", "El Anillo Regente" },
	{ "rur", "Las Aventuras de Rudolphine Rur" },

	// Swedish games
	{ "drakmagiglulx", "Drakmagi (Dragon Magic)" },
	{ "vanyarglulx", "Vanyar" },

	// Russian games
	{ "devoursglulx", "All Things Devours" },

	{ nullptr, nullptr }
};

const GlkDetectionEntry GLULXE_GAMES[] = {
	// English games
	DT_ENTRY0("aafn", "98c22f842ffadfb08a8e2a93d32c7495", 163328),
	DT_ENTRY1("aafn", "Corrupt", "07d590dc62f0be38f6f879763b6eb12c", 163072),
	DT_ENTRY1("aardvarkvshype", "r1/211104", "a5d8109ab52c23b571a069f840b87288", 1289116),
	DT_ENTRY1("abca", "r4/190516", "9176001159f15db15a3f674ddd5642f8", 2129538),
	DT_ENTRY0("academicpursuits", "37f8d2484cf254f7836fd938b37584b6", 931046),
	DT_ENTRY1("acbs", "170705", "6b108c327301ccba5de41f3b98772b33", 1334066),
	DT_ENTRY1("acg", "070501", "1a3eb782d28dd8ae8da40f21adb174f0", 817408),
	DT_ENTRY1("acmj", "r1/220607", "581a2d9a0df17a2852cf28a14bd78a46", 602220),
	DT_ENTRY1("adventglulx", "961209", "cf232df2a3364a6f0821a8ef631c81a1", 167424),
	DT_ENTRY1("adventglulx", "961209", "e1939485dc2d4aab637144fc842b479d", 195406),
	DT_ENTRY1("adventura", "171031", "4ca16a77854814124e1ab8df7270ed20", 659912),
	DT_ENTRY1("ailiphilia", "r4/220228", "d52dd34d4e48692afd7ead53ee30a026", 1317440),
	DT_ENTRY1("airport", "080204", "d3db494abc309a42b4dccfa53243a783", 234728),
	DT_ENTRY1("alabaster", "090609", "7f664b6eef28485a2f85a1831b041246", 3132122),
	DT_ENTRY1("aliasthemagpie", "190206", "a4281a03b797582ea53aa203b1eb7236", 1875956),
	DT_ENTRY1("alone", "200927", "8ceba612963681d5c8a61cead9c8f1f0", 1078102),
	DT_ENTRY1("alongdrink", "150214", "8120604cd0cb566897fdb0f2786f4b43", 2164954),
	DT_ENTRY1("anatidaephobia", "170121", "a651c03db50e624fc8da5679ac731b53", 786902),
	DT_ENTRY1("anchorheaddemo", "070202", "f2e60c4c3aad4c6a2b18d4d20040ed76", 635974),
	DT_ENTRY0("anchorhead", "8913be5c1feeca879111c356daf87291", 18634158),
	DT_ENTRY1("andelmanyard", "r1/221124", "b965b85c050000f2c32c7822e1aa3d84", 1110132),
	DT_ENTRY0("andromeda1983", "dcb44d52f383a4ae813145630202d49c", 9580734),
	DT_ENTRY0("andromedaapocalypseext", "c740f7c85f5d673e0fb6b216e0433332", 7464444),
	DT_ENTRY0("andromedaascending", "5947436a0109a634506691ee744d6e3e", 1752292),
	DT_ENTRY1("andromedaawakening", "120121", "64b2e5268c154130dc0d46b40c4e3e94", 884850),
	DT_ENTRY1("andromedadream", "r2/120716", "781b9397fdbad55e3ff5b02ce528cfbe", 2005254),
	DT_ENTRY1("apumpkin", "r6/221103", "121643ae56df322d6c7f1d7ca53cdecb", 673554),
	DT_ENTRY1("archaeologicalfiction", "r2/210618", "7ad460c904ac49f6d0857ea0d10d3f30", 762222472),
	DT_ENTRY1("ariadneinaeaea", "161129", "f796d793ea7b26e21abf6478ecb841a8", 1219646),
	DT_ENTRY1("aroilingoriginal", "150327", "48719b01e0b805df27fcf1e021c6780f", 3731214),
	DT_ENTRY1("aropeofchalk", "r1/200926", "26dfd5161d72ec2a9e88b93c74e79e36", 1653800),
	DT_ENTRY1("aropeofchalk", "r3/221202", "a90192092cb1616b22b6af769811c851", 1707862),
	DT_ENTRY1("artoffugue", "100911 No Music", "b570048a98acb680b8305043f1f1c866", 1596664),
	DT_ENTRY1("artoffugue", "100911", "2be7f91abade14d81b85843d82d52e86", 21605450),
	DT_ENTRY1("ascensionlimbs", "200927", "30aa45bec407ff833a56e552b451ff95", 1160460),
	DT_ENTRY1("ascensionlimbs", "r3/210110", "19a8d2f1cbd6ef612118941314ede73d", 1355276),
	DT_ENTRY1("ascentgothictower", "140831", "5fa0426759ecc243abd54f3c1c4f6d12", 2408444),
	DT_ENTRY0("atc", "312ef9bf8d06145948994ad596c57ce3", 65536),
	DT_ENTRY1("aurora", "110219", "5561b20f74d67b0e71c2b73c2ca85943", 2198110),
	DT_ENTRY1("balancesglulx", "961216", "84e0bc6295bc979754d0aa40982d1a12", 383542),
	DT_ENTRY1("baretegi", "160131", "8f1ea267fca902d07c41cb5fae8a6efb", 651420),
	DT_ENTRY1("barroombrawl", "160226", "a6b2641c76c1a28e5ff8f5188a06c63e", 637692),
	DT_ENTRY1("batman66", "r7/220303", "a692872f5d50d2d78b937c884a9d50b7", 949954),
	DT_ENTRY1("beasttorrackmoor", "071014", "80d093ceb324b7288b6c5715f8391d3d", 579578),
	DT_ENTRY1("beautyaustere", "180112", "7efa8da4a65c8e70f6783f30750f7a00", 2127234),
	DT_ENTRY1("beautyaustere", "180928", "41a6d2b620c211118e2b9586fd354ea7", 2127234),
	DT_ENTRY1("becauseyouremine", "161019", "643df12ae55ed54c9c1172753fc71d52", 648134),
	DT_ENTRY0("beingthere", "6a7f51d6c09acca156e3ceadce7edcb9", 6005766),
	DT_ENTRY0("beyondglulx", "64a351bc6757a58080b801a14d878fc2", 1303364),
	DT_ENTRY1("blackknife", "r1/210620", "077647a5bbec44dc32f663c2f793bf01", 691968),
	DT_ENTRY0("blindhouse", "0d79dbb034056f655be3363a14d6986d", 2011166),
	DT_ENTRY1("bluelacuna", "Sneak Preview r1/080402", "11607d5bb97efa405162821cdbe66dbb", 2995596),
	DT_ENTRY1("bluelacuna", "090304", "86c24b7fa879780038056d5e9a084a28", 5649260),
	DT_ENTRY1("bluelacuna", "Full Version r4/100717", "8a2cd2e898f7375d39393b56ed64c5dd", 5673294),
	DT_ENTRY1("bonehead", "120229", "34563c2af093239b5a908a64031eedac", 1804252),
	DT_ENTRY1("brainguzzlers", "160123", "23d22c7e8d7dff3660c436ef4951f4ae", 3210594),
	DT_ENTRY1("briar", "130707", "fb40823ab510ca052c8736163332ea6d", 766272),
	DT_ENTRY1("btyt", "130101", "97c6c3622d0d5a2f7a5e4f9ca521c13d", 412214),
	DT_ENTRY1("bullhockey", "181125", "8919f32151fdc862688fb3c27aa7c46d", 2036232),
	DT_ENTRY1("bullhockey", "181218", "8414393ff71519dc842cfe758ac2b0ad", 2066952),
	DT_ENTRY1("bullhockey", "181220", "a2ad2f228e37ea52062e4f4f110232d3", 2065672),
	DT_ENTRY1("bullhockey", "190103", "6cec5f7e1bfba0cbfa76bad81c197eba", 2065672),
	DT_ENTRY1("bullhockey", "190106", "877fd221c0f6e7f7393597a8c6a4e3ca", 2065672),
	DT_ENTRY0("bullhockey2", "e66411e7d47061243c7f47277727a2a8", 2892260),
	DT_ENTRY1("bureaucrocyglulx", "140401", "530a9efefff27ce37d75e5dc8de8ad5d", 565522),
	DT_ENTRY1("buygold", "160302", "7db70c24b2533800187a1884ca9eacf1", 897480),
	DT_ENTRY1("calm", "111201", "dba39ece18ebfbde9ebc93ccc5216fd8", 2012688),
	DT_ENTRY1("candlewindless", "170828", "8decde9d474d5888d46684b8958c3a3d", 2281490),
	DT_ENTRY1("canyouescape", "131027", "330ec51e1f138a5f28df687c749ac959", 339406),
	DT_ENTRY1("castronegroblues", "130314", "fa6a51335c716de20510bd418081295b", 695186),
	DT_ENTRY1("caveglulx", "040606", "67d3036084bb769ae925a8b6f3be84ed", 279960),
	DT_ENTRY1("cheesedoffglulx", "160315", "27a5288bce1b9aed55c150cba9f2e930", 666448),
	DT_ENTRY1("childrenloblolly", "r1/220117", "1e2ebaa7bc46054d38eed6283ce71517", 824276),
	DT_ENTRY1("chipmonk", "190725", "dfd2a54378d96e2e0de203b52879501e", 647590),
	DT_ENTRY1("chlorophyll", "150212", "447eae9f3c961baec28cbef9432839e7", 1089226),
	DT_ENTRY1("chnlsurf", "081122", "131aac0607a2ed5f3ae8c333bc981cd6", 409856),
	DT_ENTRY1("codetopia", "171103", "40f486f5a68fee9d99623167cf750874", 682480),
	DT_ENTRY1("colderlight", "120312", "eed41f2779bdf940f84b4e0a33036e69", 1192960),
	DT_ENTRY0("colorthetruth", "b9ea873d69fd82d1e0535d55b4b84cac", 1372266),
	DT_ENTRY0("comp01tr", "1d51522ee3057a3f7206fa83c151a6de", 149760),
	DT_ENTRY1("comehouse", "210813", "6e1c6b40d1ab32ffa2985ae457a8f291", 1526508),
	DT_ENTRY1("comehouse", "211213", "27662487116ce47c2b0112faebae1bb6", 1539308),
	DT_ENTRY1("confhist", "190603", "7409eea74565594355edb7fd6f64ee5c", 646882),
	DT_ENTRY1("cos", "030624", "21bbf38c4e358ff2fd34e3d7424c8d36", 8462908),
	DT_ENTRY1("cosmoserveglulx", "r1/171005", "a0e995309ba2b1bc0fda138da86ca366", 1798024),
	DT_ENTRY1("counterfeitmonkey", "160520", "24b94c1d870740880629983fc181d7b8", 14806568),
	DT_ENTRY1("counterfeitmonkey", "171224", "340232662aa8e9f4d45726e8ca7f9f5a", 12580166),
	DT_ENTRY1("counterfeitmonkey", "181204", "c3e41db7aa8642f40b157c51fa91a26b", 12348938),
	DT_ENTRY1("counterfeitmonkey", "200810", "493169aff19d6c1b42649197b7fbb6e0", 12400746),
	DT_ENTRY1("counterfeitmonkey", "210312", "dc67e9f95854b3be82ab33522c4db0e9", 11314624),
	DT_ENTRY1("countingcrabs", "090728", "ffc19674d99b4d6f530bb00287c83c7e", 1508676),
	DT_ENTRY1("crackcoldone", "170706", "c2d5bf64a0aadaead7640b5750826d55", 627136),
	DT_ENTRY1("crackcoldone", "170711", "d64bd51d8fe05dc190ac3589e11b6ea6", 627136),
	DT_ENTRY1("cragne", "181208", "082f518c0120d2323ce340bef8a2d5a9", 8869096),
	DT_ENTRY1("crashdisaster", "r15/220917", "82008663b8d3e7da04debed8b5380150", 1349544),
	DT_ENTRY1("crashdisaster", "r19/221124", "405241206e6368228c33ab826dd87832", 1391784),
	DT_ENTRY1("damesdeadites", "150116", "c34b65232be2c25e558c31349e62b716", 812810),
	DT_ENTRY0("dansenocturne", "9a60eadb746e34c7364cbe423b712e0c", 810990),
	DT_ENTRY1("darkcarnival", "130924", "e5102c61fcb3b192c6455f214f6ca01d", 1733174),
	DT_ENTRY1("darknessglulx", "130704", "5fd073140b9c9e0a312995e60e6761b9", 608574),
	DT_ENTRY1("deadcities", "081214", "0d276d62017b6b1b9e07b79e3fd98b5f", 1195136),
	DT_ENTRY1("deathoffthecuff", "130930", "8e48819a77855adf1a1879b2fb2e03ab", 1211826),
	DT_ENTRY1("delphinashouse", "150214", "5c6e7d0f23ccc3fb17d64bcfdc14ae5e", 2199754),
	DT_ENTRY0("desolation", "6a9f300f70d246e52dafbc65430e6cad", 675208),
	DT_ENTRY1("diaperquest", "171224", "31d355119d0aa4c719cd8093457857b3", 417101284),
	DT_ENTRY1("discovertheworld", "150731", "77b1b18260082d25f4de51318e885eaa", 17127846),
	DT_ENTRY1("doctorm", "120219", "7fb0073619cb071dd5d1be97285e6454", 1293208),
	DT_ENTRY0("donotmeddle", "7f2864618567e6d8f587ea5dc9afe879", 800588),
	DT_ENTRY1("douchebag", "150117", "20372d8a1cc2c6c8181f4ea7d6ec2a6c", 750454),
	DT_ENTRY1("downtheserpent", "150214", "276a492ca99e76827265a70f84bcddd7", 1456140),
	DT_ENTRY1("dptmb2aa", "200324", "8336c30f8b28a73583b9fdd7a753ae88", 565760),
	DT_ENTRY1("dracula1glulx", "071227", "5cb76c66a0087ac70d61e21d99cdf26a", 448324),
	DT_ENTRY1("dracula2glulx", "080819", "8b78b92771fc0f368ebc7fd0ff8e79bb", 696250),
	DT_ENTRY1("dragondemons", "000001", "ce5c6c3e9eb5c45d83edcdba263729e9", 982528),
	DT_ENTRY1("dragonglulx", "040211", "8daf42fd31e76a075fd2a831e6be23ac", 1625986),
	DT_ENTRY1("dragonpass", "r1/211111", "20511b3e33d0f9a72505e42ce3708b22", 919824),
	DT_ENTRY1("drhorror", "r1/211121", "f36db5fb5f4249d413b268cb9e20074c", 2914710),
	DT_ENTRY1("drolltolltroll", "131021", "518955b338fca036fa9611c86c30f9ae", 435544),
	DT_ENTRY1("dudewheresmyscapula", "160323", "95911f3a23498a24912f5cf64ddfb88d", 642518),
	DT_ENTRY1("duelspannedages", "100403", "4887e9c2e6df64ac85be17bedaed36f9", 628480),
	DT_ENTRY1("dungeonspuzzle", "180428", "6f9413eb4901da34adbdd79753094c2a", 662208),
	DT_ENTRY1("dungeontext1", "130317", "1c69e410ff3fa7c7dcf83875a7f3a963", 746466),
	DT_ENTRY1("dynamitepowers", "Director's Cut r2/210627", "be66a1e09cb19cff49a2fa115ff4d097", 1836560),
	DT_ENTRY1("eas2", "030112", "fc2b4a123489076679597a57d04c5acc", 845600),
	DT_ENTRY1("eatme", "171013", "5e9c50e06ae1f954b9dd41abcfc0f09b", 2570070),
	DT_ENTRY1("elsegar1", "200917", "76925bff593a871c2668bedafe099058", 863114),
	DT_ENTRY1("endlesssands", "150215", "2105d775eb759af04ab788e046d965e0", 982748),
	DT_ENTRY1("endlesssands", "150712", "55b31591423b011bb99be2724a6bdbe9", 1005788),
	DT_ENTRY1("endling", "090217", "52500f2301277154258d2a846d45aedb", 148908),
	DT_ENTRY1("enterpriseincidents", "020428", "ab2d1e4dd1ca079b502bc92b3ac4a1ac", 1067372),
	DT_ENTRY1("equivocalingredient", "090509", "537279579b7c0dd2f5d8213a84209c7f", 1285236),
	DT_ENTRY1("exigentseasons", "r1/210827", "959b453f617f5de41f5265226912236c", 1612108),
	DT_ENTRY1("exigentseasons", "r2/220219", "7ee8c390fbddb20b72934a517e52a17e", 1616972),
	DT_ENTRY1("everybodydies", "081116", "2ec12958967c78e39c5ef3b9ef8fd584", 4091308),
	DT_ENTRY1("fair", "161116", "eca63537d9198a10dd6a84bf51b097b6", 1190090),
	DT_ENTRY1("fairest", "r1/220331", "b39cff09fc0dafe9fc2218224c76d405", 1766826),
	DT_ENTRY1("familiar", "200702", "4e347fdc86a979e865fa790d94bbf30a", 2294330),
	DT_ENTRY1("farmquest", "111028", "e49e02b73047fb16427c8882035a4be6", 415940),
	DT_ENTRY1("fatfair", "r3/191118", "006e6b5b3edf2233e020a61edf4a59ad", 1383018),
	DT_ENTRY1("ferrousring", "1007276", "af11f50b1ef9ba444bd176de4ee22002", 432128),
	DT_ENTRY0("ferrousring", "e3763b5e021f6ee2c6e383bae2b4bc8a", 450560),
	DT_ENTRY1("ferrymansgate", "200928", "276ff9f09734b59364199fc948f9e221", 2655820),
	DT_ENTRY1("finalproject", "140517", "9ace3f9fa908a3b96a6153afa0e30720", 738248),
	DT_ENTRY1("flattenedlondon", "200926", "f3fa437bc2e99ceb97b43c5617f0d4db", 1785910),
	DT_ENTRY1("flattenedlondon", "r8/210106", "55a9d547c9222483e72e3e76871246cf", 1790262),
	DT_ENTRY1("flexiblesurvival", "110307", "0d225782edd27fffb7ab0e423e9bad4d", 860108),
	DT_ENTRY1("followingastar", "034107", "fec0b3c288daa456c3feff5e10bced8a", 1172892),
	DT_ENTRY0("followingastar", "4f88888ed4c75099e64ef8e05bd177cc", 1170332),
	DT_ENTRY1("foraplace", "200928", "0a27fe6717a60a99e7130ea54354eaf5", 1476540),
	DT_ENTRY1("further", "150117", "227bf3da188ae42e43b8b88b66561252", 682770),
	DT_ENTRY1("gaiawebch12", "r1/160104", "876c8ad8648b4035db67d09f38e9f4d4", 2458080),
	DT_ENTRY1("gatewayferrets", "191206", "0db20a85e6f044d0968dd1c6eea47c2f", 776178),
	DT_ENTRY1("genesisquest", "140319", "c51f6d78e73aa0d846a2e38d4c187cfc", 1647616),
	DT_ENTRY1("getout", "190823", "61d1b8622f47bf01027d6537dcdb256a", 641758),
	DT_ENTRY1("ghosteringtonnight", "150815", "29ee591bd93084b5a450f2324d47de3b", 1940030),
	DT_ENTRY1("ghostglulx", "r1/210716", "8a612292dd5c09cabb64ad0cb41d842b", 794292),
	DT_ENTRY1("ghostguessed", "r1/211117", "7b2920b6c3222e184037e2d1fdc166e8", 1368358),
	DT_ENTRY0("glkchess", "43a14ea7a35d7944504d3017f33fd40b", 252340),
	DT_ENTRY0("glkebook", "1dc4d02840ee7cbf61dc359bc6a69c22", 61162),
	DT_ENTRY1("greenmountains", "110116", "4049179c3a28703705de72be734e05bc", 337868),
	DT_ENTRY1("groovebillygoat", "140511", "bfe3b34019ab6d2df0b9a5b793414170", 853042),
	DT_ENTRY1("grooverland", "r4/210806", "d9438ba0fc0583a30f907b877f068710", 2180180),
	DT_ENTRY1("hardpuzzle1", "151117", "ee0a36c15599629bfc4fef9d3d83f70f", 601068),
	DT_ENTRY1("hardpuzzle2", "151209", "db2880a4bf6539b30b922c83d1f35877", 626752),
	DT_ENTRY1("hardpuzzle3", "160107", "9dffb3f6fc8daf2bf4a27b4b43745b93", 796682),
	DT_ENTRY1("haroldnight2003", "141007", "ac404358f94472c2e9c8bc07596995db", 949134),
	DT_ENTRY1("hercules", "r1/211121", "8883c8f48d19165bf53d9a4216240f1e", 1426246),
	DT_ENTRY1("herecomestreble", "160619", "573a53ce59a78c09bdfcf4f09b5cfd60", 666278),
	DT_ENTRY1("hlmarooned", "r1/220611", "db487dd770829aa94447eadfe3f260c6", 860582),
	DT_ENTRY1("hobbitglulx", "010911", "87212129f54fd80c1f31104eee222f2c", 183642),
	DT_ENTRY1("hobbitredux", "r2/170425", "766d0af2efc767d387ba30eeb0db81d2", 622482),
	DT_ENTRY1("hobbitredux", "r2/170425", "d0850bafc2ad394e37ee0a5d1d9c508e", 582656),
	DT_ENTRY1("houseofmemories", "200426", "bb74ef8a7831af2d99c9aaae1e02b743", 679844),
	DT_ENTRY1("houseofmystery", "180608", "97e29a1a074ab5b46f5b7edf9914a957", 1252656),
	DT_ENTRY1("houseofmystery", "180929", "4b34547babe73117e6575d559b71d1e5", 2486390),
	DT_ENTRY1("hungerdaemon","141202", "9908fa1aad277bbc968587ea388d179f", 1496460),
	DT_ENTRY1("illum", "180228", "f6babe0280f8334036751a2a943de1a9", 7233750),
	DT_ENTRY1("illum", "181001", "c2b6e0ab32c4035a903926448332e3a9", 7241942),
	DT_ENTRY1("illum", "190221", "5220fec6734d7320cbe989ae8f12c2e0", 7242454),
	DT_ENTRY1("illwind", "130515", "3904b4080d16b1e5d56caa6df64d5887", 1057002),
	DT_ENTRY1("immunesystem", "200330", "1080f88bd537e11557cc1efd43c5d4b4", 614052),
	DT_ENTRY1("improvorigins", "r2/220810", "d734064ca6f678017db416820eee43dc", 1006110),
	DT_ENTRY1("ingoodcompany", "161114", "8e7d4e242f7dff5d9e9be419e2da857b", 1628586),
	DT_ENTRY1("jackglulx", "r1/211026", "bebb45d2b6e1757b572ace1859a33a51", 924338),
	DT_ENTRY1("jadeite", "r1/201009", "1aad49311944d4e2e32b07a7d20120ab", 623962),
	DT_ENTRY1("jasonandmedea", "110307", "ce392dbb2b0c76f2c9961925dfb9229a", 646362),
	DT_ENTRY1("kerkerkruip", "140419", "879c34531bc7dbb66bad8fca651bc428", 22109534),
	DT_ENTRY0("kerkerkruip", "b4db28a5653a63fa389e37b65b078b57", 1306720),
	DT_ENTRY1("killerheadache", "121231", "ab18f553a035242a15f5a39f16f03173", 1382924),
	DT_ENTRY1("kingshredspatches", "090722", "87765824be7facf6400a392633f84602", 4340676),
	DT_ENTRY1("klaustrophobia", "110926", "d8751353ff883a1439c4c90cac2991fa", 3599478),
	DT_ENTRY1("koa", "000001", "f70361a47c2e9571a4fdc72ce7453197", 1085696),
	DT_ENTRY1("lasthouse", "200928", "94ca1a21467c2b2f07e9cf6afeeb818a", 933328),
	DT_ENTRY1("lastresort", "070213", "bc26a4383290d3c04657ea58841b3d91", 787200),
	DT_ENTRY1("limeergot", "151130", "1290543b3d72115bc31201ed244b5011", 1008590),
	DT_ENTRY1("limen", "r1/210814", "d196f9bb0ea07b178b6b3fb7b5eb8649", 683000),
	DT_ENTRY1("lmstvgglulx", "080404", "9dc7716acde7bc5bdc460f11f7ad51f9", 312920),
	DT_ENTRY1("lockdown", "150112", "556ecd86ad03658d443e8deaba126601", 1338172),
	DT_ENTRY1("lockeddoor10", "r1/220202", "10002a1896d514b08416cffbf673f8c1", 989882),
	DT_ENTRY1("lockeddoor11", "r1/220214", "d96f42aec8da45f0c194a28ce3c1892e", 1019760),
	DT_ENTRY1("lockkey", "1.12", "6f621089d571d2dada889e4367f4d20b", 269862),
	DT_ENTRY1("lonelytroll", "r1/220501", "05b1503fa7d757ec8417a777afa9a86e", 2334570),
	DT_ENTRY1("lostislandsofalabaz", "110524", "9f439a77eccf4813aebebbe8093e8c57", 3145932),
	DT_ENTRY1("lovelyassistant", "200923", "16931f135f38efaee72dac89a7c9ae27", 1051098),
	DT_ENTRY1("madametime", "r2/190902", "b8c0d099b3da134b7163cb4b07a3268b", 1182340),
	DT_ENTRY1("makechangeglulx", "120107", "0ee70eea03ca810bf0de3dcecfd9c741", 6456118),
	DT_ENTRY1("makingme", "r1/220209", "96f4346cdf887a6ced4026e13ecc64ea", 2082406),
	DT_ENTRY1("mgaeb", "110326", "9e79d4c25be31698254648579288e6dc", 676818),
	DT_ENTRY1("mollybutterthieves", "160704", "e8d72805a49b658df517a91857a7feaf", 1870384),
	DT_ENTRY1("moments1", "061113", "6a7092f959c8a731cb2651860a00a4eb", 684314),
	DT_ENTRY1("moments2", "070417", "6c18999a3689234664b3daef737811ca", 13970974),
	DT_ENTRY1("monksea", "200405", "7c4240d258d9041df3ec28f1eec462e9", 680152),
	DT_ENTRY1("moonbaseindigo", "150101", "d31c005adf9f03febf5888b7fc5cf864", 1331372),
	DT_ENTRY1("mugglestudies", "120314", "0053d3c68896176ae8637752f5a855ee", 1320898),
	DT_ENTRY1("mystery", "160508", "cbd8c64ebfe2c1d7da7d3739764283ae", 1127312),
	DT_ENTRY1("narco", "1.07", "5dc6eac35d115b03f40ec61ce6e90c9d", 505840),
	DT_ENTRY1("necronskeep", "110101", "880e7b8dc89efd3a6bd8410136e9132e", 750696),
	DT_ENTRY1("necronskeep", "180120", "d533b9a3e11bd99f32ec7dcdccbae903", 749160),
	DT_ENTRY1("necronskeep", "190114", "2db002f0b695a4050249c0cd822d9c7b", 1027002),
	DT_ENTRY1("newcat", "110929", "51d263a55473d4d1ce0bceebca93a878", 795092),
	DT_ENTRY1("nightfall", "090425", "7784b0b91d27a0995cbf0f8b2ee669bf", 1339348),
	DT_ENTRY1("nightmare", "150927", "5a1800ab91062b1edf96671d4de15fb5", 646038),
	DT_ENTRY1("nowheresville", "r1/221030", "86ecbe2738622a5a162a68704a4a3977", 1471426),
	DT_ENTRY1("nssri", "180606", "c8e18e3c0ea50ecab2723fa581997acc", 1376102),
	DT_ENTRY1("officegoose", "r11/200101", "3def1e8a27f8d12b26d93ede124d99f7", 571742),
	DT_ENTRY1("oldfogey", "160512", "bb1cc12fcc2c0d606d237cb8bed8ef7e", 612406),
	DT_ENTRY1("oldhhouse", "r1/221030", "bec430e7aad958baac37ba72b5a81c82", 849262),
	DT_ENTRY1("oliviasorphanorium", "121118", "f0719bf95ca31e2bf964ebf11628b9ba", 1279388),
	DT_ENTRY1("onefishtwofish", "r1/211025", "121e6cd8d048525f9a67ad7b127fd3bc", 906032),
	DT_ENTRY1("oppositelyopal", "150214", "e7bbe4bca68cf243c64528b464b99ebf", 1515910),
	DT_ENTRY1("ottumwaglulx", "021409", "1fc1da4f374493bee3a13c143beeba58", 537712),
	DT_ENTRY1("owlconsults", "171124", "d1d4bd725f5e64a80f97cfc6e687a8e8", 287488),
	DT_ENTRY1("oxygen", "150121", "31a6aaaf3bdfde86a93583e73d50b4fb", 927386),
	DT_ENTRY1("patanoir", "131204", "b328b1edff8f94715898ff0a58e845f9", 877876),
	DT_ENTRY1("phoenixfire", "190204", "1aab4fc41f54524f98988045aa6be1df", 767690),
	DT_ENTRY1("photopiaglulx", "10274", "eab3f6371531c78b2e80803e1636da7d", 627050),
	DT_ENTRY1("piedaterreblunders", "171216", "6195647baed23df20a1e16e02d046505", 1115466),
	DT_ENTRY0("pinched", "a6087088eddc38bbed669d531993c688", 1107350),
	DT_ENTRY1("pizzadelivery", "181115", "d47886a06ab5ec9ed256d56fefc75b8a", 620486),
	DT_ENTRY1("playinggames", "111127", "3e907a5feabc7ef36d019c866ec084c0", 630242),
	DT_ENTRY1("portfoliopiece", "170510", "efd348ae57ca688962388a410d273451", 636614),
	DT_ENTRY1("psychomanteum", "161029", "e88338c8e1ace3391eee928f352c83ad", 3059478),
	DT_ENTRY1("pythoglulx", "020223", "3bfe1fa8468e96538b084db5c5feac55", 437408),
	DT_ENTRY1("raidersstones", "r2/220116", "285cb947b9dbf4ad4ccd9606b4c34d44", 1485424),
	DT_ENTRY1("rar", "160423", "d45b8709505785738bb6f935c6e2cb2e", 881040),
	DT_ENTRY1("reorsbushcaveglulx", "170406 Censored", "10c52283c50482a876f7fcc19d19934e", 1377424),
	DT_ENTRY1("reorsbushcaveglulx", "170406 Explicit", "53ed4c8cd45aea30954e1442b169368e", 1496516),
	DT_ENTRY1("reorsbushcaveglulx", "170424 Censored", "67fa7a51a11494ae58b1cd298f99c1bc", 1377276),
	DT_ENTRY1("reorsbushcaveglulx", "170424 Explicit", "37883e3c63a18db1bed8bc4e81d13414", 1539506),
	DT_ENTRY1("returnstars", "r3/211226", "c95cd6045069fd91e0114dc10e8d19de", 1186674),
	DT_ENTRY1("risorgglulx", "060308", "86158d4fe6da56b253db871685f95c99", 545280),
	DT_ENTRY1("risorgglulx", "171024", "3eb4e5aecb2c899bec5db264928fa252", 568576),
	DT_ENTRY1("risorgglulx", "171114", "ba7417d44454c43a3fb9ffc31c5da0bc", 701928),
	DT_ENTRY1("robinandorchid", "140602", "2561b2f1f0b9d3550e6052d6e5fa2ac3", 1210868),
	DT_ENTRY1("rocketmanfromsea", "120507", "33c7faa1be533ce760f89da13997dbbf", 2210282),
	DT_ENTRY1("roguelikegoose", "200112", "c80283327325ce312164240d6515579f", 636244),
	DT_ENTRY1("rosewood", "131116", "c766929c3cc25a13b5a60f90b618d94e", 736304),
	DT_ENTRY1("rover", "091116", "88249e5938448be487267a4b609a45e7", 1741574),
	DT_ENTRY0("rover", "5a404fb92af606a86bdae9bbf91547c1", 1739014),
	DT_ENTRY1("safe", "110109", "95af9e7de6e31fdeff6bd3cf7969434d", 648720),
	DT_ENTRY1("sagebrushcactus", "100918", "de27a377b78387126b77552bccf0a085", 640246),
	DT_ENTRY1("sagesanctumscramble", "r1/200922", "bd21d0b625abb8bab93e83cc93fd35ee", 876800),
	DT_ENTRY1("sagesanctumscramble", "r2/201205", "15830904ce96b418e949f0e3b9318dec", 877568),
	DT_ENTRY1("samfortunepi", "090510", "f177d973432b7a27302f1a79c8106f72", 706326),
	DT_ENTRY1("scrollthief", "150729", "9c26a3dc0f4fb681bf79f681e63c0d76", 2367848),
	DT_ENTRY0("seasonalapocalypse", "5e951b117302169cdb77e832115937f0", 2207454),
	DT_ENTRY1("secretletter", "150107 Deluxe", "152f91e432a49c3f61a8ecd7bca1d6c4", 2274048),
	DT_ENTRY1("section1awakened", "150812", "e05b999f193566771ff08679d5512143", 625112),
	DT_ENTRY1("seedscafe", "r1/210206", "3014cd94a6505def8f3e1754b73d22f2", 652732),
	DT_ENTRY1("sensory", "000329", "7432f9e1d416034acf10e8a499368b9e", 202258),
	DT_ENTRY1("sensory", "000329", "7c5a00524809e4402ddf0554394e81bc", 132608),
	DT_ENTRY1("sequitur", "140813", "c7e384b1938915f17cc0b7d50f41d235", 1642480),
	DT_ENTRY1("shadowcathedral", "150228 Deluxe", "8da968205614859105c89e95179d268c", 2723072),
	DT_ENTRY1("shadowoperative", "200929", "3bb8da82f1d81e35ee152d5ecd6ba3e4", 1140422),
	DT_ENTRY1("shadowsdeep", "r1/220630", "4d0b65a40f50e1d04bfc5bdef31b5aa6", 1307402),
	DT_ENTRY1("shapes", "000001", "a011827749eeef8afe6f6b8d5bfb78db", 1254912),
	DT_ENTRY1("sheephere", "160416", "1de700b758ef6f975150a6bd8926880d", 621466),
	DT_ENTRY1("shufflingaround", "150328", "00b2a517ec539936b96e84fabb91e5db", 3208092),
	DT_ENTRY0("shufflingaround", "31ce78bff3833e5d2224abc4e63e6923", 3091868),
	DT_ENTRY1("signalerror", "111116", "739510541192f01467b319b70ed7bf1f", 2138394),
	DT_ENTRY0("sittm", "0c3d40b0340df7ff459ff7751015183a", 408576),
	DT_ENTRY0("sittm", "4a2ba3c1b9574b6292cbe361fc49af40", 409344),
	DT_ENTRY1("six", "120805", "2705921eee09a568959584be1929b6b7", 8663464),
	DT_ENTRY1("six", "170723", "2d1fdfe386c08fdacd620b7497bcd88f", 8661160),
	DT_ENTRY1("skiesabove", "r1/191120", "d2f2071d0432a657ddff53bd1a38370c", 1159352),
	DT_ENTRY1("skmmc", "150116", "46aee190f69d75592d72b1e3c573b6a8", 831452),
	DT_ENTRY1("slouchingbedlamglulx", "140613", "c3ee4e636fb1ef2a0438dc3a08d4c1eb", 982754),
	DT_ENTRY0("smittenkittens", "c3402d5d8b94675af5e3e0069366d4fd", 1240942),
	DT_ENTRY1("songmockingbird", "r2/220422", "1f0fe56c7c8bb1f87723493b60fa84a6", 1447318),
	DT_ENTRY1("spaceship", "090928", "e52390cba328a8c863150ce4651fa71f", 1429732),
	DT_ENTRY1("speedracer", "190617", "10d61f0fa2c3cbe122112f32d05e03a0", 613834),
	DT_ENTRY1("spellbound", "160728", "c37e0e19a2fe74edc2d1df90bc97e132", 1061586),
	DT_ENTRY1("spirI7wrak", "141218", "d7e58b86d1c6e06ecdc83ebbb7b20242", 2631214),
	DT_ENTRY1("standingshoulders", "200925", "78cb38272e79595781f5e1be65171a75", 836802),
	DT_ENTRY1("starlight", "151119", "ee4d2ed91518392981bf3cfd0fcf644d", 885152),
	DT_ENTRY0("stiffymakane", "f978ca1dafb3e44f1b29bd26527f342c", 2486436),
	DT_ENTRY1("sting", "r2/211211", "8e17a75bfadf744e64a06534d1fe4d83", 1152828),
	DT_ENTRY0("stuffoflegend", "447ea6caf1c51226b3f6a54d857b76b6", 1536382),
	DT_ENTRY1("subrosa", "160324", "30e7ded8624c26c04e8361d235f42c67", 1481628),
	DT_ENTRY1("superluminalvagranttwin", "160316", "7beb275a3e66b7b9840019caa3041723", 1162788),
	DT_ENTRY1("tacofiction", "130422", "766be6495cb312d8270587c4d45d7e6a", 1928530),
	DT_ENTRY1("tcom", "121103 (No Gfx)", "24feef55d07cc46bcc5479ce580cbe3e", 246272),
	DT_ENTRY1("tcom", "121103", "67504ebc3d525f6a29fa800b6e12229d", 326226),
	DT_ENTRY1("templeshorgil", "r2/190807", "2b5e689ac5ef0a57acdda20aa4cef496", 2029052),
	DT_ENTRY1("terminatorchaser", "r2/150315", "ac10ba4e7d15ebe4262cb3b9d683ef12", 1698614),
	DT_ENTRY1("terminatorrobotrescue", "150214", "596b41d3ecc38bfb9a6aee085f333591", 1054550),
	DT_ENTRY1("theabbey", "080626", "3abcc1b85a36efb73815e1cd37143210", 645274),
	DT_ENTRY1("theabsenceoflaw", "170102", "210e6dc1d5c0fc1f4340ae9ee5bdcf4e", 1332522),
	DT_ENTRY1("thebigfall", "r2/210711", "dad981d1fde0f573fd7c4b4d2652ca69", 1389634),
	DT_ENTRY1("thebigfall", "r2/210814", "7b5f8df5b909e2ca49ab7aedf1661f56", 1389378),
	DT_ENTRY1("thebox", "170813", "91ec66de5a2b6d9e9e889835857c03e7", 1371546),
	DT_ENTRY1("thecrew", "r6/211102", "b30f0d790b8dd11e9f16fbbe34a56cb3", 919628),
	DT_ENTRY1("theeleusinianmiseries", "200926", "4ca599f36ae1559356bb224879213382", 2265116),
	DT_ENTRY1("theeleusinianmiseries", "r3/201227", "325f0aad5ff624c7d4e9df5e8af39ce6", 2312476),
	DT_ENTRY1("thefourthriddle", "181228", "07f018d38c164615890adc44855fb15b", 1281176),
	DT_ENTRY0("thehours", "2d94f14e3ce959173da1ed35502f1419", 1281774),
	DT_ENTRY1("thehouseoffear", "111109", "f952621c0d7d8808ec4c339f0c1b3872", 1132748),
	DT_ENTRY1("theinformal7abbreviated", "150706", "79e489ca1095835e2de90b5a9ea0812c", 611172),
	DT_ENTRY1("theislandofdoctorwooby", "150811", "c6bf4a675821d51c1ec251ff2bfd4770", 1164724),
	DT_ENTRY1("thelaughinggnome", "160212", "c55fc26f587526618c4baf820b33f3f4", 728918),
	DT_ENTRY1("thelibrary", "141212", "a545e2f3c25715a0b693ada6407e2b54", 1201984),
	DT_ENTRY1("thelookout", "r8/211114", "b40a96283a8d12b16243cadbf506f691", 745114),
	DT_ENTRY1("thelostkingdomofcodetopia", "171113", "961fcb440ebd5f7738545a2f705c9785", 747220),
	DT_ENTRY1("thelostmountain", "r1/210228", "47ca99926b9b15ed327f07b22277d445", 1350882),
	DT_ENTRY1("themagpietakesthetrain", "200924", "19d8fc67b3dfbb7a1dc88fa02d26e6d4", 2315066),
	DT_ENTRY1("themaryjaneoftomorrow", "160605", "b8842f2deb9b283cccd272c0dbfc2369", 10344070),
	DT_ENTRY1("themuseum", "081128", "8285ac707a9a47900c380d8af9632d1b", 3266510),
	DT_ENTRY1("theoutcasts", "170312", "234a5a35fc846aca8a4363a773d032e1", 731070),
	DT_ENTRY1("thephoenixmove", "080821", "564e3f053220cb23342a6984cfcef8f9", 611890),
	DT_ENTRY1("therealmofaoria", "160412", "29f1e1568486fbcc95d06c470534c233", 4466630),
	DT_ENTRY1("therealmofaoria", "161205", "87e9e7411e535e335e580d16be255671", 6458822),
	DT_ENTRY1("theredroom", "r1/220404", "aa04c9f178abd8261fbfe8a4f4f3740a", 617372),
	DT_ENTRY1("thesimpletale", "121216", "ad56281f7fb97718269122c014230df6", 1348802),
	DT_ENTRY1("theskycrane", "160602", "f40afca1c0252a90a614c27b39a6bd82", 626632),
	DT_ENTRY1("thespectators", "r1/221107", "d58bafa06a075bb32632746c87c5147c", 1568488),
	DT_ENTRY1("thespywhoatelunch", "120102", "4d6d33ff7c740020067d85cdcb46678e", 839742),
	DT_ENTRY1("thestorm", "190107", "f0a0f037fec735bdfe770f1f171e03a8", 820842),
	DT_ENTRY1("thethiefofwovenwoods", "110513", "cf0cee73644411e8176c7320eb8b68d8", 388820),
	DT_ENTRY1("thetimemachine2021", "r3/210627", "92409db44e62a5d91ee6a0f0767294c7", 1150004),
	DT_ENTRY1("thetimemachine2021", "r4/210831", "cd93405a3c77a9351bab7ccae0a6a436", 1161268),
	DT_ENTRY1("thetinyhouse", "091210", "5e86e6852c049ac973af5175d61b60e9", 823552),
	DT_ENTRY1("thetraintoabaddon", "141107", "55a4a454fba273067cc127c4f1a8ce3a", 848180),
	DT_ENTRY1("thewaywardstory", "200929", "4fe03ab93289d4d8d53b04983010f529", 929536),
	DT_ENTRY1("thiefpokemon", "140111", "2bfabf36b6171ed487858c10af0ea88d", 358392),
	DT_ENTRY1("timecapsule", "r1/201005", "0d570e4c2cd8383fa45c99d000a40c2c", 613632),
	DT_ENTRY1("timeless", "190510", "29aeb64448b6df40399bbd41152e925a", 616386),
	DT_ENTRY1("todayisthesame", "190518", "ba4478b484043d7943f834c672d5835a", 1800722),
	DT_ENTRY1("tohellinahamper", "170412", "f12baa1762e29c9528baec31347a18b0", 973550),
	DT_ENTRY1("tohellinahamper", "r2/191217", "40cccc5fcce65c03e41dfa664487de10", 1978492),
	DT_ENTRY1("tomtrundle", "200928", "8d720c498a6a7115628f70b61eb413c6", 2885100),
	DT_ENTRY1("transparent", "150401", "3f4e5effb8ed8f4d0c3f277bb47ba161", 11084272),
	DT_ENTRY1("transparent", "150626 (No Sound)", "13dc495dc3ed802e663b193bd862b994", 2284454),
	DT_ENTRY1("trialofthetnuop", "170813", "d8a34dc6c9b0e2d037d8cc3de006f42b", 616062),
	DT_ENTRY1("trollslayer", "151112", "fa3dee31c195732ad6a13a6e0b54d625", 920230),
	DT_ENTRY1("tryagain", "160922", "64de60e3dbc7eb492a34a0a693156659", 626116),
	DT_ENTRY1("turbochesthair", "200928", "420f40b233e4b221e6fff2bec050dc23", 2091802),
	DT_ENTRY1("uglyoafs", "150403", "39ba113801d9b90d506b356f6b3ba25a", 660078),
	DT_ENTRY1("uie", "101122", "ed892c12a8b2d65fcda5ba6a228e04ed", 2016322),
	DT_ENTRY1("umwglulx", "200426", "c843d3a02c0f6862401c13b45a3e85b1", 635558),
	DT_ENTRY1("uncleclemswill", "200425", "60527f2feb48e14d1fdfa7b94a8838c1", 763614),
	DT_ENTRY1("underground", "r2/191215", "48966f89d00f4c8ce1fc2946636bd190", 3715706),
	DT_ENTRY1("undertheythunder", "200928", "bd069d2e3e841cea7a7d2694681b548a", 1070370),
	DT_ENTRY1("unscientificfiction", "090803", "de1c4a2bf4024eb4c0e5fee0e0fd4746", 679608),
	DT_ENTRY1("vainempires", "200928", "4b28e67ecabbb8e6db40e5e99f5e8140", 3914438),
	DT_ENTRY1("vainempires", "r2/210223", "adab9cfa61fbeb284fdeb6779f014028", 3920070),
	DT_ENTRY1("valleyofsteel", "140330", "88311986461cec17e776d82a5ac18416", 1853024),
	DT_ENTRY1("vampireltd", "200926", "7d5d5a10930db0adfcadf79860f3223f", 829986),
	DT_ENTRY1("vampireltd", "r4/210129", "8a879f2a2757822b03c3d91a3289a6d5", 889540),
	DT_ENTRY1("walking", "200626", "0a8f6530e5a619ad9e0764a645e8404d", 822256),
	DT_ENTRY1("walkneighborhood", "r1/221124", "593e57ec12999ee4ce6c2a2309ffb32c", 841136),
	DT_ENTRY1("wand", "171118", "b824638fc1d015b0837688322839ada0", 830208),
	DT_ENTRY1("winterstormdraco", "150928", "b4835af78525e56420f138c2e5f6806c", 812124),
	DT_ENTRY1("wishertheurgist", "160708", "4bbe0b3a29d57d1428e6cd6cf7c97fce", 824204),
	DT_ENTRY1("wizardsniffer", "171007", "834fbcad9b93f6fab461ad4b8ff48bb5", 1240012),
	DT_ENTRY1("wof", "100515", "7de6ef1ecdec5066f65b1283b9203dc6", 10185552),
	DT_ENTRY1("wordoftheday", "171129", "c45a9d68e80765ceff7654366fa47328", 4506970),
	DT_ENTRY1("wordsofpower", "021229 (No Sound)", "487ab63bce62d7fd86852b1974ba1a1c", 465306),
	DT_ENTRY1("wordsofpower", "021229", "dfb5064095b4d71291b81dd281d8c520", 6240896),
	DT_ENTRY1("yourdeath4acts", "r1/211123", "eadf48993ab9e2e8d841f60cef89d22d", 840054),
	DT_ENTRY1("zeldata", "200503", "5141a90761011ab8f70e4aa64b8b8f72", 1232604),
	DT_ENTRY1("zorkglulx", "080504", "94839db9d8437e493a4b254e6e540359", 1020160),

	// Apollo 18+20 IF Tribute Album
	DT_ENTRY0("apollo3glulx", "33cf75f5bcc2a28af85d83e4e3f3b846", 482978),
	DT_ENTRY0("apollo10glulx", "ac5fe600e5cf179738af4329f71304f8", 1897372),
	DT_ENTRY0("apollo12glulx", "bfadac2b1ac0eab7187e4a5166a72798", 883926),
	DT_ENTRY0("apollo15glulx", "c1e23a471ff61e3846b63cc21ff9edfa", 633818),
	DT_ENTRY0("apollo19glulx", "66b599c4aecd63caa59b00bfd5101f43", 466244),
	DT_ENTRY0("apollo33glulx", "74457b493e101e87463a0be645d2ab65", 411726),

	// Competition 2001
	DT_ENTRY1("bestof3", "010928", "53d50b3573afc12376ae5fbb342230d9", 930694),
	DT_ENTRY1("carma", "010928", "cc5077c525b44748443a0e39cdc079c6", 11205418),
	DT_ENTRY1("smtuc", "010928", "c6e58925e082f20542bd25a2395dd00d", 1439558),
	DT_ENTRY1("smtuc", "010928", "b0d09a4fa36ae1b00cccc80e4a4248d0", 194048),

	// Competition 2002
	DT_ENTRY1("eas2", "020925", "914e969da891835c24b3decdc6fa34c1", 842272),

	// Competition 2004
	DT_ENTRY1("eas3", "040929", "8f118c9fa10ef24a5551448d5ab2408f", 1293054),

	// Competition 2005
	DT_ENTRY1("beyondglulx", "20050930", "ad22a9d2a75f04f724ab18663399cca0", 1302846),
	DT_ENTRY1("cheiron", "050929", "bca1af6d8788c178ab42883f184e7955", 2434458),

	// Competition 2006
	DT_ENTRY1("floatpoint", "060930", "1350e61da647efffc0e36f705dbc90f4", 1377946),

	// Competition 2007
	DT_ENTRY1("chineseroom", "070930", "68e11adb8574ffc4b5698499f02686d6", 988416),
	DT_ENTRY1("varkana", "070930", "f92523a3a403d88aed1523de6fe12a33", 876932),

	// Competition 2008
	DT_ENTRY1("amo", "r/2080929", "5ab3b7c8b1446334f0703c61e4512cc4", 52505634),
	DT_ENTRY1("chnlsurf", "080929", "c4b2ae121f5f0e1ae2c98c3bd4a6b3d3", 398848),
	DT_ENTRY1("crywolf", "080929", "044a5209c2ecd4401ad2f7fa0cbed256", 911818),
	DT_ENTRY1("everybodydies", "080915", "58c45023b48266cba73c776418741313", 4091836),
	DT_ENTRY1("recess", "080929", "7437538b52eb78c427eb4e54e2fa1665", 712784),

	// Competition 2009
	DT_ENTRY1("brokenlegs", "090930", "4ff634e4183763bc9a34a61fad3dfd23", 1048314),
	DT_ENTRY1("earlgrey", "090930", "73730db01a1bb32ffd6e2baa1877e11f", 266752),
	DT_ENTRY1("gis", "090929", "9370bf33a539114878b8ab95be49e38f", 667934),
	DT_ENTRY0("nightfall", "1a13bdae770563bdfa09f25e40d6ea57", 1242580),
	DT_ENTRY1("resonance", "090930", "d51f6c4e99b9d283e65d836caf2f1324", 912226),

	// Competition 2010
	DT_ENTRY0("aotearoa", "f62a91448362426220f811c6612f42ea", 1896012),
	DT_ENTRY1("divismortis", "080126", "78e8e7f1b9350022c501eca735883d7e", 805644),
	DT_ENTRY1("gigantomania", "100930", "4c89679dc1aa12f5d6b7e121d09e22f3", 1734624),
	DT_ENTRY1("grisjaune", "100930", "849519ec9197682259d78f545fb7094f", 637952),
	DT_ENTRY1("oneeyeopen", "100929", "aeb6ffc0787d36f7105a91f5a3abe444", 1779174),
	DT_ENTRY1("oxygen", "100930", "743f21619656301039d9f5113b9af50e", 1013908),
	DT_ENTRY1("inerebus", "100930", "acda27283090aa366ef4ce99766391f0", 1986882),

	// Competition 2011
	DT_ENTRY1("awakemightydread", "111006", "48b3b409b565774a3cbf681225322080", 717456),
	DT_ENTRY1("beet", "110930", "d2cecb0fff0e3234ffbfac2256c09227", 1894218),
	DT_ENTRY1("deathofschlig", "111031", "0b9b3666a0c795185724ddbd1de171dc", 1483674),
	DT_ENTRY1("faninterference", "111014", "7d0362957c6666d4e569d32a03d0d854", 1509382),
	DT_ENTRY1("luster", "080126", "dc95b63ade63ddb122a3722adcfac573", 569202),
	DT_ENTRY1("patanoir", "r3/111201", "e03b27c359d71d7794ef68efe1952a72", 813876),
	DT_ENTRY1("sentencing", "111006", "4fdaaa41f63482e931296edd173f69bc", 1008888),
	DT_ENTRY1("tacofiction", "111009", "c0338f36c652d48a77380c95b8eec508", 1944464),

	// Competition 2012
	DT_ENTRY0("andromedaapoc", "8eb9d31ed63271fe36b9e18f979d8a87", 7116982),
	DT_ENTRY1("imos", "r3/121017", "c7f412b07c72ba8a6952e4ee74a37075", 716404),
	DT_ENTRY1("jdal", "120930", "193ea99f5067c64447dd2c74c7e3ab9d", 761022),
	DT_ENTRY1("kicker", "120929", "19d87058db3cf7503380f44929866ed5", 829156),

	// Competition 2013
	DT_ENTRY1("awbp", "130928", "e9256df20f20e02cb43112c60cc5034d", 499962),
	DT_ENTRY1("captverdeterre", "131003", "56c78de876c57b0e02725e4d8752f139", 1549998),
	DT_ENTRY1("coloratura", "080126", "db4b88094929abb89fcf19ab56204b05", 1403574),
	DT_ENTRY1("mazredugin", "131024", "510431bad4f9463b5f667cf22d414b85", 563948),
	DT_ENTRY1("ooof", "130929", "5ee413df68e3e66fdf356a5df8289f85", 1391318),
	DT_ENTRY1("robinorchid", "r3/131027", "c9eda35f6793f96e056b49b6b2ae41d1", 1184500),
	DT_ENTRY1("texbonaventure", "080126", "27b76acc9effd1dcf86110b74f31b61d", 2420514),
	DT_ENTRY1("cardewhouse", "080126", "f99076e11ff40c0bbc9d566143d71ca9", 477126),


	// French games
	DT_ENTRYL1("ekphrasis", Common::FR_FRA, "050718", "009ca5994d9e8fe6cfb400a9da00b123", 64609308),
	DT_ENTRYL0("lieuxcommunsglulx", Common::FR_FRA, "6e18273de25a0b882b0cf01770003146", 15659070),
	DT_ENTRYL1("sarvegneglulx", Common::FR_FRA, "061101", "518ab27b773bb51f57c6526655f38e6f", 594306),
	DT_ENTRYL1("scarabeekatana", Common::FR_FRA, "070906", "e2ca97ca5579b544765e744964c9624f", 651590),
	DT_ENTRYL1("templefeu", Common::FR_FRA, "070731", "73c3a0486d41a41c454108298014fac0", 2576096),

	// German games
	DT_ENTRYL1("dergarten", Common::DE_DEU, "180510", "b90eda22c098c5d70eb2a0cb5140dbe0", 2183442),
	DT_ENTRYL1("deronirischegarten", Common::DE_DEU, "180730", "eb41961e5772ca99c03ba49f6b4ceb62", 476352),
	DT_ENTRYL1("jaeger", Common::DE_DEU, "r1/210701", "4958d690aae92343b2cf4117fb65acd2", 1441682),
	DT_ENTRYL1("jaeger", Common::DE_DEU, "r4/211130", "392cc64126776d1cc9515ac66ed43b77", 1695248),
	DT_ENTRYL1("kleinehalbling", Common::DE_DEU, "r14/180019", "2250a4a81641a49874ed78fb3cd39533", 884946),
	DT_ENTRYL1("matthiasclaudius", Common::DE_DEU, "170328", "514f28c468487b3239cb2fbc7c4a2dac", 1007368),
	DT_ENTRYL1("matthiasclaudius", Common::DE_DEU, "171010", "437460fae6cd8b57d9e9599f5c29504f", 1010696),
	DT_ENTRYL1("matthiasclaudius", Common::DE_DEU, "180730", "bc2d409cc3ab7c65f52332d64e792bae", 1016584),
	DT_ENTRYL1("morgenwirdklausur", Common::DE_DEU, "170423", "b71391f995becb65992561d57ed80829", 724164),
	DT_ENTRYL1("morgenwirdklausur", Common::DE_DEU, "170430", "85a966e56c4e0fc7d10df9bc3824da95", 727492),
	DT_ENTRYL1("patanoirde", Common::DE_DEU, "131202", "9ed40b987510c7a8b7da4386ff8879b1", 969304),
	DT_ENTRYL1("spaterbesuch", Common::DE_DEU, "r2/191013", "24bd852ecb47a6f01cdaa9be80195f4a", 9608754),

	// Italian games
	DT_ENTRYL1("beyondglulx", Common::IT_ITA, "100115", "a0cd0a410cc99aa7ff661129b8ec5de8", 1331582),
	DT_ENTRYL1("beyondglulx", Common::IT_ITA, "210810", "a89d1095e7fc7c6ca72ffd8c3a6bcc67", 1332118),
	DT_ENTRYL1("beyondglulx", Common::IT_ITA, "210810", "09912bc978bb88459fa1bb8405f5962a", 353192), // zblorb
	DT_ENTRYL1("pietradellaluna", Common::IT_ITA, "110106", "8834e0273fc730b8f6dcd38bbba2894d", 1060656),
	DT_ENTRYL1("mancasolo", Common::IT_ITA, "398874", "de6d58b378dee41d273f7bb3c5da4220", 978440),
	DT_ENTRYL1("schizo", Common::IT_ITA, "180907", "3531f6066802f53f9b095b5221fac4d2", 6198900),
	DT_ENTRYL1("schizo", Common::IT_ITA, "180907", "30ff0bffbe7e1c11ea4a7ec30e0b8c76", 194560),
	DT_ENTRYL1("slendermanbase", Common::IT_ITA, "r3/140721", "6765e1c656f4dd1af25235bc9b11585c", 1156562),
	DT_ENTRYL1("slenderman", Common::IT_ITA, "r3/140721", "b6a73057d3ff8e54011eab2556c2332c", 13465166),
	DT_ENTRYL1("snuff", Common::IT_ITA, "180827", "1005bf49b80982997ed3b0930c390d5d", 135168),
	DT_ENTRYL1("villamorganaglulx", Common::IT_ITA, "090404", "88feac9efb31e7e6bd832bda02ff0cfa", 1263196),

	// Spanish games
	DT_ENTRYL1("alienlaaventura", Common::ES_ESP, "081124", "e09c0e91e53a07c768eb473deae9619c", 6884846),
	DT_ENTRYL1("conrumbo", Common::ES_ESP, "010527", "024946d9d10190694d90dedd34ab648e", 127744),
	DT_ENTRYL1("dracula1glulx", Common::ES_ESP, "071227", "a2266f816a8e6afa324ad98e8ddb707b", 467354),
	DT_ENTRYL1("dracula2glulx", Common::ES_ESP, "080819", "c9ff350c10f4ef88db667e58a3696938", 715450),
	DT_ENTRYL1("elultimohogarglulx", Common::ES_ESP, "021225", "08d4168a767dce4899640a000d2809d8", 663576),
	DT_ENTRYL1("hhorcusglulx", Common::ES_ESP, "100818", "48e7d8f6cd53506778e035eeab6c545c", 4191072),
	DT_ENTRYL1("kerulenglulx", Common::ES_ESP, "090720", "0f4c8d5fb20666d5e66da025c3167285", 6842790),
	DT_ENTRYL1("lanochedelensayo", Common::ES_ESP, "100122", "23845407e62d47b5d51267492137e05e", 2527892),
	DT_ENTRYL0("legado", Common::ES_ESP, "3f5652cfb07d22c1cf668c33fc92a611", 513472),
	DT_ENTRYL1("regente", Common::ES_ESP, "021129", "7c8608e214821c55bc9224ccfd5beb44", 273092),
	DT_ENTRYL0("rur", Common::ES_ESP, "4d7dab1227494292f37107da1729392e", 3432966),
	DT_ENTRYL1("rur", Common::ES_ESP, "Text Only", "de15e8cdd8523c774b66950a0232a0f9", 413184),

	// Swedish games
	DT_ENTRYL1("drakmagiglulx", Common::SE_SWE, "080419", "93db2e43fafb22b9e4d10f7d6f3a5136", 203630),
	DT_ENTRYL1("vanyarglulx", Common::SE_SWE, "030613", "4a80396f31f9cced2b6689341ac5d2cc", 278780),

	// Russian games
	DT_ENTRYL1("devoursglulx", Common::RU_RUS, "r2/220224", "65a51e53c1498823024dcec286971f19", 365312),
	DT_END_MARKER
};

} // End of namespace Glulx
} // End of namespace Glk
