% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapes.R
\name{scale_shape_tremmel}
\alias{scale_shape_tremmel}
\title{Shape scales from Tremmel (1995)}
\usage{
scale_shape_tremmel(overlap = FALSE, alt = TRUE, ...)
}
\arguments{
\item{overlap}{use an empty circle instead of a solid circle when
\code{n == 2}.}

\item{alt}{If \code{TRUE}, then when \code{n == 3},
use a solid circle, plus sign and
empty triangle. Otherwise use a solid circle, empty circle, and empty
triangle.}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{discrete_scale}}
  \describe{
    \item{\code{palette}}{A palette function that when called with a single integer
argument (the number of levels in the scale) returns the values that
they should take (e.g., \code{\link[scales:hue_pal]{scales::hue_pal()}}).}
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones
}}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} uses all the levels in the factor.}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{na.value}}{If \code{na.translate = TRUE}, what aesthetic value should the
missing values be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
    \item{\code{aesthetics}}{The names of the aesthetics that this scale works with.}
    \item{\code{scale_name}}{The name of the scale that should be used for error messages
associated with this scale.}
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}
}
\description{
Shape scales from Tremmel (1995)
}
\examples{
library("ggplot2")

p <- ggplot(mtcars, aes(x = mpg, y = hp, shape = factor(cyl))) +
  geom_point()

p + scale_shape_tremmel()
p + scale_shape_tremmel(alt = TRUE)
p + scale_shape_tremmel(overlap = TRUE)
}
\seealso{
\code{\link{tremmel_shape_pal}()} for a description of the palette.

Other shapes: 
\code{\link{circlefill_shape_pal}()},
\code{\link{cleveland_shape_pal}()},
\code{\link{scale_shape_circlefill}()},
\code{\link{scale_shape_cleveland}()},
\code{\link{tremmel_shape_pal}()}
}
\concept{shapes}
