(define (batch-normalmap in out)
           (let* ((image (car (gimp-file-load RUN-NONINTERACTIVE
                                              in in)))
                  (drawable (car (gimp-image-get-active-layer image))))
		     (print in)
             (gimp-layer-add-alpha drawable)
			 (gimp-levels drawable 0 0 255 1 2 255);; prevent 0 values
             (plug-in-normalmap RUN-NONINTERACTIVE image drawable
               1 ;;sobel 3x3
               0 0.7;;minz, scale
               1 ;;wrap
               0 ;;heightsource
               1 ;;alpha=height
               0 ;;noconvert
               0 ;;nodudv
               0 1;;noinvert
               0 ;;noswap
               1 ;;heightcontrast
               drawable) ;;nodrawable
			 (gimp-levels drawable 4 0 120 1 90 255)
             (gimp-file-save RUN-NONINTERACTIVE
                             image drawable out out)
             (gimp-image-delete image)))
(batch-normalmap "./textures/egyptsoc_trimd/v128-01cd.tga" "./textures/egyptsoc_trimd/v128-01cd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s128-04dr.tga" "./textures/egyptsoc_trimd/s128-04dr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v064-03cr.tga" "./textures/egyptsoc_trimd/v064-03cr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-03dd.tga" "./textures/egyptsoc_trimd/v128-03dd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/128-04dr.tga" "./textures/egyptsoc_trimd/128-04dr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-02dd.tga" "./textures/egyptsoc_trimd/v128-02dd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-04cd.tga" "./textures/egyptsoc_trimd/v128-04cd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v064-02cr.tga" "./textures/egyptsoc_trimd/v064-02cr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v064-02dr.tga" "./textures/egyptsoc_trimd/v064-02dr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s064-01fd.tga" "./textures/egyptsoc_trimd/s064-01fd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v064-02cd.tga" "./textures/egyptsoc_trimd/v064-02cd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-04fr.tga" "./textures/egyptsoc_trimd/v128-04fr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-01dr.tga" "./textures/egyptsoc_trimd/v128-01dr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s128-01dr.tga" "./textures/egyptsoc_trimd/s128-01dr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s064-03dd.tga" "./textures/egyptsoc_trimd/s064-03dd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s128-04dd.tga" "./textures/egyptsoc_trimd/s128-04dd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-02cd.tga" "./textures/egyptsoc_trimd/v128-02cd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-01cr.tga" "./textures/egyptsoc_trimd/v128-01cr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-02cr.tga" "./textures/egyptsoc_trimd/v128-02cr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s128-02cd.tga" "./textures/egyptsoc_trimd/s128-02cd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-04dr.tga" "./textures/egyptsoc_trimd/v128-04dr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s064-01ed.tga" "./textures/egyptsoc_trimd/s064-01ed_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v064-01cd.tga" "./textures/egyptsoc_trimd/v064-01cd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v064-02dd.tga" "./textures/egyptsoc_trimd/v064-02dd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v064-01dd.tga" "./textures/egyptsoc_trimd/v064-01dd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-04fd.tga" "./textures/egyptsoc_trimd/v128-04fd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s128-04cd.tga" "./textures/egyptsoc_trimd/s128-04cd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-03gd.tga" "./textures/egyptsoc_trimd/v128-03gd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s064-01fr.tga" "./textures/egyptsoc_trimd/s064-01fr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s064-02dr.tga" "./textures/egyptsoc_trimd/s064-02dr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s064-02dd.tga" "./textures/egyptsoc_trimd/s064-02dd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s064-02cd.tga" "./textures/egyptsoc_trimd/s064-02cd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s128-01dd.tga" "./textures/egyptsoc_trimd/s128-01dd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s064-04dd.tga" "./textures/egyptsoc_trimd/s064-04dd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-04cr.tga" "./textures/egyptsoc_trimd/v128-04cr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s064-01er.tga" "./textures/egyptsoc_trimd/s064-01er_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v064-03dd.tga" "./textures/egyptsoc_trimd/v064-03dd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s128-01cr.tga" "./textures/egyptsoc_trimd/s128-01cr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-03cr.tga" "./textures/egyptsoc_trimd/v128-03cr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v064-01dr.tga" "./textures/egyptsoc_trimd/v064-01dr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/128-04cr.tga" "./textures/egyptsoc_trimd/128-04cr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s064-04cd.tga" "./textures/egyptsoc_trimd/s064-04cd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s064-02cr.tga" "./textures/egyptsoc_trimd/s064-02cr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-01dd.tga" "./textures/egyptsoc_trimd/v128-01dd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-04gr.tga" "./textures/egyptsoc_trimd/v128-04gr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s128-02dd.tga" "./textures/egyptsoc_trimd/s128-02dd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v064-03dr.tga" "./textures/egyptsoc_trimd/v064-03dr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v064-03cd.tga" "./textures/egyptsoc_trimd/v064-03cd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s128-02dr.tga" "./textures/egyptsoc_trimd/s128-02dr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-04dd.tga" "./textures/egyptsoc_trimd/v128-04dd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v064-01cr.tga" "./textures/egyptsoc_trimd/v064-01cr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s128-02cr.tga" "./textures/egyptsoc_trimd/s128-02cr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-03dr.tga" "./textures/egyptsoc_trimd/v128-03dr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-02dr.tga" "./textures/egyptsoc_trimd/v128-02dr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s128-01cd.tga" "./textures/egyptsoc_trimd/s128-01cd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s128-04cr.tga" "./textures/egyptsoc_trimd/s128-04cr_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/v128-03cd.tga" "./textures/egyptsoc_trimd/v128-03cd_norm.tga")
(batch-normalmap "./textures/egyptsoc_trimd/s064-03cd.tga" "./textures/egyptsoc_trimd/s064-03cd_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone05a.tga" "./textures/egyptsoc_wall/stone05a_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone03d.tga" "./textures/egyptsoc_wall/stone03d_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone04c.tga" "./textures/egyptsoc_wall/stone04c_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone01a.tga" "./textures/egyptsoc_wall/stone01a_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone03c.tga" "./textures/egyptsoc_wall/stone03c_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone09d.tga" "./textures/egyptsoc_wall/stone09d_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone07b.tga" "./textures/egyptsoc_wall/stone07b_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/relief03c.tga" "./textures/egyptsoc_wall/relief03c_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone04b.tga" "./textures/egyptsoc_wall/stone04b_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone07c.tga" "./textures/egyptsoc_wall/stone07c_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone02a.tga" "./textures/egyptsoc_wall/stone02a_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone11a.tga" "./textures/egyptsoc_wall/stone11a_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone07a.tga" "./textures/egyptsoc_wall/stone07a_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/relief03b.tga" "./textures/egyptsoc_wall/relief03b_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone11b.tga" "./textures/egyptsoc_wall/stone11b_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone08b.tga" "./textures/egyptsoc_wall/stone08b_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone04a.tga" "./textures/egyptsoc_wall/stone04a_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone02d.tga" "./textures/egyptsoc_wall/stone02d_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone08c.tga" "./textures/egyptsoc_wall/stone08c_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone10a.tga" "./textures/egyptsoc_wall/stone10a_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/relief03d.tga" "./textures/egyptsoc_wall/relief03d_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone10d.tga" "./textures/egyptsoc_wall/stone10d_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone06b.tga" "./textures/egyptsoc_wall/stone06b_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone10b.tga" "./textures/egyptsoc_wall/stone10b_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone07d.tga" "./textures/egyptsoc_wall/stone07d_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone04d.tga" "./textures/egyptsoc_wall/stone04d_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/relief04b.tga" "./textures/egyptsoc_wall/relief04b_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone01d.tga" "./textures/egyptsoc_wall/stone01d_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone11d.tga" "./textures/egyptsoc_wall/stone11d_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone03a.tga" "./textures/egyptsoc_wall/stone03a_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone01b.tga" "./textures/egyptsoc_wall/stone01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone01c.tga" "./textures/egyptsoc_wall/stone01c_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone02b.tga" "./textures/egyptsoc_wall/stone02b_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/relief04a.tga" "./textures/egyptsoc_wall/relief04a_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/relief03a.tga" "./textures/egyptsoc_wall/relief03a_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone05b.tga" "./textures/egyptsoc_wall/stone05b_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone08d.tga" "./textures/egyptsoc_wall/stone08d_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone10c.tga" "./textures/egyptsoc_wall/stone10c_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone11c.tga" "./textures/egyptsoc_wall/stone11c_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/relief04d.tga" "./textures/egyptsoc_wall/relief04d_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone09b.tga" "./textures/egyptsoc_wall/stone09b_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone06e.tga" "./textures/egyptsoc_wall/stone06e_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone02c.tga" "./textures/egyptsoc_wall/stone02c_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone09a.tga" "./textures/egyptsoc_wall/stone09a_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone03b.tga" "./textures/egyptsoc_wall/stone03b_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone08a.tga" "./textures/egyptsoc_wall/stone08a_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/relief04c.tga" "./textures/egyptsoc_wall/relief04c_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone06a.tga" "./textures/egyptsoc_wall/stone06a_norm.tga")
(batch-normalmap "./textures/egyptsoc_wall/stone09c.tga" "./textures/egyptsoc_wall/stone09c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-03a.tga" "./textures/egyptsoc_trim/064-03a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-08a.tga" "./textures/egyptsoc_trim/064-08a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-02b.tga" "./textures/egyptsoc_trim/v128-02b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/lig_128-05a.tga" "./textures/egyptsoc_trim/lig_128-05a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/stepangle01b.tga" "./textures/egyptsoc_trim/stepangle01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/256-04b.tga" "./textures/egyptsoc_trim/256-04b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/048-02e.tga" "./textures/egyptsoc_trim/048-02e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/256-04d.tga" "./textures/egyptsoc_trim/256-04d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/256-04c.tga" "./textures/egyptsoc_trim/256-04c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-03e.tga" "./textures/egyptsoc_trim/v128-03e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-05i.tga" "./textures/egyptsoc_trim/128-05i_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-01a.tga" "./textures/egyptsoc_trim/v128-01a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-01d.tga" "./textures/egyptsoc_trim/v128-01d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-03c.tga" "./textures/egyptsoc_trim/064-03c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/t064-01b.tga" "./textures/egyptsoc_trim/t064-01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-04d.tga" "./textures/egyptsoc_trim/v128-04d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s128-02b.tga" "./textures/egyptsoc_trim/s128-02b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s128-02c.tga" "./textures/egyptsoc_trim/s128-02c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v096-01b.tga" "./textures/egyptsoc_trim/v096-01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v064-03b.tga" "./textures/egyptsoc_trim/v064-03b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-04f.tga" "./textures/egyptsoc_trim/v128-04f_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-01a.tga" "./textures/egyptsoc_trim/s064-01a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-06b.tga" "./textures/egyptsoc_trim/064-06b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-04b.tga" "./textures/egyptsoc_trim/128-04b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/048-02c.tga" "./textures/egyptsoc_trim/048-02c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-03b.tga" "./textures/egyptsoc_trim/s064-03b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/048-02f.tga" "./textures/egyptsoc_trim/048-02f_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-03c.tga" "./textures/egyptsoc_trim/032-03c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-05h.tga" "./textures/egyptsoc_trim/s064-05h_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s128-02d.tga" "./textures/egyptsoc_trim/s128-02d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-01a.tga" "./textures/egyptsoc_trim/032-01a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-05f.tga" "./textures/egyptsoc_trim/032-05f_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-05j.tga" "./textures/egyptsoc_trim/128-05j_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-04e.tga" "./textures/egyptsoc_trim/s064-04e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s128-04b.tga" "./textures/egyptsoc_trim/s128-04b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-02c.tga" "./textures/egyptsoc_trim/s064-02c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v064-03a.tga" "./textures/egyptsoc_trim/v064-03a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-02b.tga" "./textures/egyptsoc_trim/032-02b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v064-01a.tga" "./textures/egyptsoc_trim/v064-01a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v096-01c.tga" "./textures/egyptsoc_trim/v096-01c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-06a.tga" "./textures/egyptsoc_trim/032-06a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-02b.tga" "./textures/egyptsoc_trim/s064-02b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-06d.tga" "./textures/egyptsoc_trim/064-06d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-01c.tga" "./textures/egyptsoc_trim/v128-01c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-01pc.tga" "./textures/egyptsoc_trim/128-01pc_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-01pa.tga" "./textures/egyptsoc_trim/128-01pa_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-01b.tga" "./textures/egyptsoc_trim/s064-01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/048-01a.tga" "./textures/egyptsoc_trim/048-01a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-03f.tga" "./textures/egyptsoc_trim/v128-03f_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/048-02a.tga" "./textures/egyptsoc_trim/048-02a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/step01b.tga" "./textures/egyptsoc_trim/step01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-03c.tga" "./textures/egyptsoc_trim/v128-03c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-04d.tga" "./textures/egyptsoc_trim/032-04d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-04c.tga" "./textures/egyptsoc_trim/v128-04c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-03c.tga" "./textures/egyptsoc_trim/s064-03c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-02b.tga" "./textures/egyptsoc_trim/128-02b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-04a.tga" "./textures/egyptsoc_trim/v128-04a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-comb1.tga" "./textures/egyptsoc_trim/128-comb1_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v064-01c.tga" "./textures/egyptsoc_trim/v064-01c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-04g.tga" "./textures/egyptsoc_trim/v128-04g_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s128-02a.tga" "./textures/egyptsoc_trim/s128-02a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-01c.tga" "./textures/egyptsoc_trim/032-01c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s128-01a.tga" "./textures/egyptsoc_trim/s128-01a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-02c.tga" "./textures/egyptsoc_trim/v128-02c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-03b.tga" "./textures/egyptsoc_trim/032-03b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-05p.tga" "./textures/egyptsoc_trim/s064-05p_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/t064-02c.tga" "./textures/egyptsoc_trim/t064-02c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-05b.tga" "./textures/egyptsoc_trim/032-05b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-01b.tga" "./textures/egyptsoc_trim/v128-01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-07d.tga" "./textures/egyptsoc_trim/064-07d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-05d.tga" "./textures/egyptsoc_trim/128-05d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s128-04d.tga" "./textures/egyptsoc_trim/s128-04d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-05l.tga" "./textures/egyptsoc_trim/s064-05l_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-05f.tga" "./textures/egyptsoc_trim/s064-05f_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-02a.tga" "./textures/egyptsoc_trim/032-02a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-08b.tga" "./textures/egyptsoc_trim/064-08b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/048-02g.tga" "./textures/egyptsoc_trim/048-02g_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-01a.tga" "./textures/egyptsoc_trim/128-01a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-02pb.tga" "./textures/egyptsoc_trim/128-02pb_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-05i.tga" "./textures/egyptsoc_trim/s064-05i_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/stepangle01a.tga" "./textures/egyptsoc_trim/stepangle01a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-02pc.tga" "./textures/egyptsoc_trim/128-02pc_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-08c.tga" "./textures/egyptsoc_trim/064-08c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-02c.tga" "./textures/egyptsoc_trim/064-02c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-05f.tga" "./textures/egyptsoc_trim/128-05f_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-05b.tga" "./textures/egyptsoc_trim/s064-05b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-05o.tga" "./textures/egyptsoc_trim/s064-05o_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-03e.tga" "./textures/egyptsoc_trim/s064-03e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s128-01d.tga" "./textures/egyptsoc_trim/s128-01d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s128-04e.tga" "./textures/egyptsoc_trim/s128-04e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-07a.tga" "./textures/egyptsoc_trim/064-07a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-07e.tga" "./textures/egyptsoc_trim/064-07e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-02b.tga" "./textures/egyptsoc_trim/064-02b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-03a.tga" "./textures/egyptsoc_trim/128-03a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/256-03c.tga" "./textures/egyptsoc_trim/256-03c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-02e.tga" "./textures/egyptsoc_trim/s064-02e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-02a.tga" "./textures/egyptsoc_trim/v128-02a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/stepangle01c.tga" "./textures/egyptsoc_trim/stepangle01c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/t064-02d.tga" "./textures/egyptsoc_trim/t064-02d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/048-01c.tga" "./textures/egyptsoc_trim/048-01c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-04b.tga" "./textures/egyptsoc_trim/032-04b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/t064-01a.tga" "./textures/egyptsoc_trim/t064-01a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v064-02a.tga" "./textures/egyptsoc_trim/v064-02a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-05a.tga" "./textures/egyptsoc_trim/064-05a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-02d.tga" "./textures/egyptsoc_trim/v128-02d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-05c.tga" "./textures/egyptsoc_trim/064-05c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-03d.tga" "./textures/egyptsoc_trim/v128-03d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-03a.tga" "./textures/egyptsoc_trim/s064-03a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v064-03d.tga" "./textures/egyptsoc_trim/v064-03d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-01b.tga" "./textures/egyptsoc_trim/064-01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-04d.tga" "./textures/egyptsoc_trim/128-04d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/048-01b.tga" "./textures/egyptsoc_trim/048-01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-03b.tga" "./textures/egyptsoc_trim/064-03b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/stepangle01d.tga" "./textures/egyptsoc_trim/stepangle01d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-04a.tga" "./textures/egyptsoc_trim/128-04a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-02pa.tga" "./textures/egyptsoc_trim/128-02pa_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-03b.tga" "./textures/egyptsoc_trim/v128-03b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s128-01e.tga" "./textures/egyptsoc_trim/s128-01e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-05m.tga" "./textures/egyptsoc_trim/s064-05m_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v064-02c.tga" "./textures/egyptsoc_trim/v064-02c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-05d.tga" "./textures/egyptsoc_trim/s064-05d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v064-03e.tga" "./textures/egyptsoc_trim/v064-03e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-06c.tga" "./textures/egyptsoc_trim/064-06c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v064-02d.tga" "./textures/egyptsoc_trim/v064-02d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-05d.tga" "./textures/egyptsoc_trim/032-05d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-03d.tga" "./textures/egyptsoc_trim/s064-03d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-05g.tga" "./textures/egyptsoc_trim/128-05g_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/256-01a.tga" "./textures/egyptsoc_trim/256-01a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/256-03b.tga" "./textures/egyptsoc_trim/256-03b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/048-02d.tga" "./textures/egyptsoc_trim/048-02d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s128-02e.tga" "./textures/egyptsoc_trim/s128-02e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-03b.tga" "./textures/egyptsoc_trim/128-03b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-05c.tga" "./textures/egyptsoc_trim/s064-05c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-04a.tga" "./textures/egyptsoc_trim/064-04a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-01e.tga" "./textures/egyptsoc_trim/v128-01e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-05e.tga" "./textures/egyptsoc_trim/128-05e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-03a.tga" "./textures/egyptsoc_trim/032-03a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v064-01b.tga" "./textures/egyptsoc_trim/v064-01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s128-01b.tga" "./textures/egyptsoc_trim/s128-01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-05c.tga" "./textures/egyptsoc_trim/032-05c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-01c.tga" "./textures/egyptsoc_trim/s064-01c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/t064-02a.tga" "./textures/egyptsoc_trim/t064-02a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-05k.tga" "./textures/egyptsoc_trim/s064-05k_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v064-02e.tga" "./textures/egyptsoc_trim/v064-02e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-03g.tga" "./textures/egyptsoc_trim/v128-03g_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-05j.tga" "./textures/egyptsoc_trim/s064-05j_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-08d.tga" "./textures/egyptsoc_trim/064-08d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-02a.tga" "./textures/egyptsoc_trim/064-02a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-05n.tga" "./textures/egyptsoc_trim/s064-05n_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/step01a.tga" "./textures/egyptsoc_trim/step01a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v064-01e.tga" "./textures/egyptsoc_trim/v064-01e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-08f.tga" "./textures/egyptsoc_trim/064-08f_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-05h.tga" "./textures/egyptsoc_trim/128-05h_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-04c.tga" "./textures/egyptsoc_trim/064-04c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-01a.tga" "./textures/egyptsoc_trim/064-01a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-05b.tga" "./textures/egyptsoc_trim/128-05b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-04a.tga" "./textures/egyptsoc_trim/032-04a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-04b.tga" "./textures/egyptsoc_trim/s064-04b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-04c.tga" "./textures/egyptsoc_trim/032-04c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-02c.tga" "./textures/egyptsoc_trim/128-02c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-01f.tga" "./textures/egyptsoc_trim/s064-01f_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-05d.tga" "./textures/egyptsoc_trim/064-05d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-07b.tga" "./textures/egyptsoc_trim/064-07b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-02d.tga" "./textures/egyptsoc_trim/s064-02d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-06a.tga" "./textures/egyptsoc_trim/064-06a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-04c.tga" "./textures/egyptsoc_trim/128-04c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-05a.tga" "./textures/egyptsoc_trim/128-05a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-02a.tga" "./textures/egyptsoc_trim/s064-02a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-04e.tga" "./textures/egyptsoc_trim/v128-04e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-06c.tga" "./textures/egyptsoc_trim/032-06c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/256-03d.tga" "./textures/egyptsoc_trim/256-03d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/lig_128-05b.tga" "./textures/egyptsoc_trim/lig_128-05b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-01c.tga" "./textures/egyptsoc_trim/128-01c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-04a.tga" "./textures/egyptsoc_trim/s064-04a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v064-03c.tga" "./textures/egyptsoc_trim/v064-03c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-04b.tga" "./textures/egyptsoc_trim/v128-04b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s128-01c.tga" "./textures/egyptsoc_trim/s128-01c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-03c.tga" "./textures/egyptsoc_trim/128-03c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-02e.tga" "./textures/egyptsoc_trim/v128-02e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-01pb.tga" "./textures/egyptsoc_trim/128-01pb_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/t064-02b.tga" "./textures/egyptsoc_trim/t064-02b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/096-01c.tga" "./textures/egyptsoc_trim/096-01c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-05g.tga" "./textures/egyptsoc_trim/s064-05g_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s128-04c.tga" "./textures/egyptsoc_trim/s128-04c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v064-01d.tga" "./textures/egyptsoc_trim/v064-01d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-01b.tga" "./textures/egyptsoc_trim/032-01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-06b.tga" "./textures/egyptsoc_trim/032-06b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/256-03a.tga" "./textures/egyptsoc_trim/256-03a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-01c.tga" "./textures/egyptsoc_trim/064-01c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-05c.tga" "./textures/egyptsoc_trim/128-05c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/048-02h.tga" "./textures/egyptsoc_trim/048-02h_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-07c.tga" "./textures/egyptsoc_trim/064-07c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-01e.tga" "./textures/egyptsoc_trim/s064-01e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-04b.tga" "./textures/egyptsoc_trim/064-04b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v064-02b.tga" "./textures/egyptsoc_trim/v064-02b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/048-02b.tga" "./textures/egyptsoc_trim/048-02b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-01d.tga" "./textures/egyptsoc_trim/s064-01d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/256-04a.tga" "./textures/egyptsoc_trim/256-04a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-04d.tga" "./textures/egyptsoc_trim/s064-04d_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/256-01b.tga" "./textures/egyptsoc_trim/256-01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-05e.tga" "./textures/egyptsoc_trim/032-05e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-05a.tga" "./textures/egyptsoc_trim/s064-05a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-02c.tga" "./textures/egyptsoc_trim/032-02c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s128-04a.tga" "./textures/egyptsoc_trim/s128-04a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/032-05a.tga" "./textures/egyptsoc_trim/032-05a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-04c.tga" "./textures/egyptsoc_trim/s064-04c_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-08e.tga" "./textures/egyptsoc_trim/064-08e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/v128-03a.tga" "./textures/egyptsoc_trim/v128-03a_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-01b.tga" "./textures/egyptsoc_trim/128-01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/s064-05e.tga" "./textures/egyptsoc_trim/s064-05e_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/064-05b.tga" "./textures/egyptsoc_trim/064-05b_norm.tga")
(batch-normalmap "./textures/egyptsoc_trim/128-02a.tga" "./textures/egyptsoc_trim/128-02a_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/block01d.tga" "./textures/egyptsoc_mat/block01d_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/wood05b.tga" "./textures/egyptsoc_mat/wood05b_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/block01c.tga" "./textures/egyptsoc_mat/block01c_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/sand1b.tga" "./textures/egyptsoc_mat/sand1b_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/wood18.tga" "./textures/egyptsoc_mat/wood18_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/wood05a.tga" "./textures/egyptsoc_mat/wood05a_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/block01a.tga" "./textures/egyptsoc_mat/block01a_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/sand1a.tga" "./textures/egyptsoc_mat/sand1a_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/wood04.tga" "./textures/egyptsoc_mat/wood04_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/block02b.tga" "./textures/egyptsoc_mat/block02b_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/wood07.tga" "./textures/egyptsoc_mat/wood07_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/wood09.tga" "./textures/egyptsoc_mat/wood09_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/wood17.tga" "./textures/egyptsoc_mat/wood17_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/block01b.tga" "./textures/egyptsoc_mat/block01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/block02d.tga" "./textures/egyptsoc_mat/block02d_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/block02a.tga" "./textures/egyptsoc_mat/block02a_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/wood02.tga" "./textures/egyptsoc_mat/wood02_norm.tga")
(batch-normalmap "./textures/egyptsoc_mat/block02c.tga" "./textures/egyptsoc_mat/block02c_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/jumppad1ab.tga" "./textures/egyptsoc_floor/jumppad1ab_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block06a.tga" "./textures/egyptsoc_floor/block06a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/marker1ag.tga" "./textures/egyptsoc_floor/marker1ag_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/marker1bg.tga" "./textures/egyptsoc_floor/marker1bg_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block09b.tga" "./textures/egyptsoc_floor/block09b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block04a.tga" "./textures/egyptsoc_floor/block04a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block09a.tga" "./textures/egyptsoc_floor/block09a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/jumppad1ap.tga" "./textures/egyptsoc_floor/jumppad1ap_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block08a.tga" "./textures/egyptsoc_floor/block08a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block10b.tga" "./textures/egyptsoc_floor/block10b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block04b.tga" "./textures/egyptsoc_floor/block04b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/jumppad1br.tga" "./textures/egyptsoc_floor/jumppad1br_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/jumppad1ar.tga" "./textures/egyptsoc_floor/jumppad1ar_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block08b.tga" "./textures/egyptsoc_floor/block08b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/solidgrate3b.tga" "./textures/egyptsoc_floor/solidgrate3b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/grate2b.tga" "./textures/egyptsoc_floor/grate2b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/woodmgrid2a.tga" "./textures/egyptsoc_floor/woodmgrid2a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/solidgrate1b.tga" "./textures/egyptsoc_floor/solidgrate1b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/jumppad1bg.tga" "./textures/egyptsoc_floor/jumppad1bg_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block10c.tga" "./textures/egyptsoc_floor/block10c_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block08c.tga" "./textures/egyptsoc_floor/block08c_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/grate3b.tga" "./textures/egyptsoc_floor/grate3b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/solidgrate4b.tga" "./textures/egyptsoc_floor/solidgrate4b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/grate2a.tga" "./textures/egyptsoc_floor/grate2a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/solidgrate2b.tga" "./textures/egyptsoc_floor/solidgrate2b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/woodmgrid3a.tga" "./textures/egyptsoc_floor/woodmgrid3a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/grate3a.tga" "./textures/egyptsoc_floor/grate3a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/solidgrate3a.tga" "./textures/egyptsoc_floor/solidgrate3a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/woodmgrid1a.tga" "./textures/egyptsoc_floor/woodmgrid1a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/solidgrate1a.tga" "./textures/egyptsoc_floor/solidgrate1a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block07b.tga" "./textures/egyptsoc_floor/block07b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block06b.tga" "./textures/egyptsoc_floor/block06b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block01a.tga" "./textures/egyptsoc_floor/block01a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block02b.tga" "./textures/egyptsoc_floor/block02b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/woodmgrid1b.tga" "./textures/egyptsoc_floor/woodmgrid1b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/grate4a.tga" "./textures/egyptsoc_floor/grate4a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/grate1a.tga" "./textures/egyptsoc_floor/grate1a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block08d.tga" "./textures/egyptsoc_floor/block08d_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/grate4b.tga" "./textures/egyptsoc_floor/grate4b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block03a.tga" "./textures/egyptsoc_floor/block03a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/solidgrate2a.tga" "./textures/egyptsoc_floor/solidgrate2a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block03b.tga" "./textures/egyptsoc_floor/block03b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/marker1bb.tga" "./textures/egyptsoc_floor/marker1bb_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block01b.tga" "./textures/egyptsoc_floor/block01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/woodmgrid3b.tga" "./textures/egyptsoc_floor/woodmgrid3b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block07a.tga" "./textures/egyptsoc_floor/block07a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block02a.tga" "./textures/egyptsoc_floor/block02a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/marker1ab.tga" "./textures/egyptsoc_floor/marker1ab_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/solidgrate4a.tga" "./textures/egyptsoc_floor/solidgrate4a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/jumppad1ag.tga" "./textures/egyptsoc_floor/jumppad1ag_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/woodmgrid2b.tga" "./textures/egyptsoc_floor/woodmgrid2b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/block10a.tga" "./textures/egyptsoc_floor/block10a_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/grate1b.tga" "./textures/egyptsoc_floor/grate1b_norm.tga")
(batch-normalmap "./textures/egyptsoc_floor/jumppad1bb.tga" "./textures/egyptsoc_floor/jumppad1bb_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-02d.tga" "./textures/egyptsoc_sfx/lig_b064-02d_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-05y1.tga" "./textures/egyptsoc_sfx/lig_064-05y1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_128-05b1.tga" "./textures/egyptsoc_sfx/lig_128-05b1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-06y1.tga" "./textures/egyptsoc_sfx/lig_064-06y1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_128-05w2.tga" "./textures/egyptsoc_sfx/lig_128-05w2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_128-05r1.tga" "./textures/egyptsoc_sfx/lig_128-05r1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_v192-01bb.tga" "./textures/egyptsoc_sfx/lig_v192-01bb_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-04r1.tga" "./textures/egyptsoc_sfx/lig_032-04r1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-01c.tga" "./textures/egyptsoc_sfx/lig_b064-01c_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-05b1.tga" "./textures/egyptsoc_sfx/lig_064-05b1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-06b2.tga" "./textures/egyptsoc_sfx/lig_064-06b2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-04r1.tga" "./textures/egyptsoc_sfx/lig_064-04r1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-01e.tga" "./textures/egyptsoc_sfx/lig_b064-01e_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-02b1.tga" "./textures/egyptsoc_sfx/lig_064-02b1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-01r2.tga" "./textures/egyptsoc_sfx/lig_064-01r2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-01b1.tga" "./textures/egyptsoc_sfx/lig_064-01b1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-02y2.tga" "./textures/egyptsoc_sfx/lig_032-02y2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-06r2.tga" "./textures/egyptsoc_sfx/lig_064-06r2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-01r2.tga" "./textures/egyptsoc_sfx/lig_032-01r2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-02b2.tga" "./textures/egyptsoc_sfx/lig_064-02b2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-01w1.tga" "./textures/egyptsoc_sfx/lig_032-01w1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_v192-01yb.tga" "./textures/egyptsoc_sfx/lig_v192-01yb_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-02r2.tga" "./textures/egyptsoc_sfx/lig_032-02r2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-01w1.tga" "./textures/egyptsoc_sfx/lig_064-01w1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-04b1.tga" "./textures/egyptsoc_sfx/lig_064-04b1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-03r2.tga" "./textures/egyptsoc_sfx/lig_032-03r2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-01b2.tga" "./textures/egyptsoc_sfx/lig_032-01b2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-04y1.tga" "./textures/egyptsoc_sfx/lig_064-04y1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-06w2.tga" "./textures/egyptsoc_sfx/lig_064-06w2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-03y1.tga" "./textures/egyptsoc_sfx/lig_032-03y1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_128-05y2.tga" "./textures/egyptsoc_sfx/lig_128-05y2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-04b1.tga" "./textures/egyptsoc_sfx/lig_032-04b1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-03f.tga" "./textures/egyptsoc_sfx/lig_b064-03f_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-02w2.tga" "./textures/egyptsoc_sfx/lig_032-02w2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-01w2.tga" "./textures/egyptsoc_sfx/lig_064-01w2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_128-05r2.tga" "./textures/egyptsoc_sfx/lig_128-05r2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-02w1.tga" "./textures/egyptsoc_sfx/lig_064-02w1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-03e.tga" "./textures/egyptsoc_sfx/lig_b064-03e_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-02w2.tga" "./textures/egyptsoc_sfx/lig_064-02w2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-05r1.tga" "./textures/egyptsoc_sfx/lig_064-05r1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-06y2.tga" "./textures/egyptsoc_sfx/lig_064-06y2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-05w2.tga" "./textures/egyptsoc_sfx/lig_064-05w2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-02a.tga" "./textures/egyptsoc_sfx/lig_b064-02a_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-03w1.tga" "./textures/egyptsoc_sfx/lig_032-03w1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-06b1.tga" "./textures/egyptsoc_sfx/lig_064-06b1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-04y2.tga" "./textures/egyptsoc_sfx/lig_032-04y2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_v192-01wb.tga" "./textures/egyptsoc_sfx/lig_v192-01wb_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-01b.tga" "./textures/egyptsoc_sfx/lig_b064-01b_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-01d.tga" "./textures/egyptsoc_sfx/lig_b064-01d_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-03w2.tga" "./textures/egyptsoc_sfx/lig_032-03w2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-03b1.tga" "./textures/egyptsoc_sfx/lig_032-03b1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_v192-01ba.tga" "./textures/egyptsoc_sfx/lig_v192-01ba_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-03r1.tga" "./textures/egyptsoc_sfx/lig_032-03r1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-04w2.tga" "./textures/egyptsoc_sfx/lig_064-04w2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_v192-01ya.tga" "./textures/egyptsoc_sfx/lig_v192-01ya_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-04w1.tga" "./textures/egyptsoc_sfx/lig_032-04w1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-01y2.tga" "./textures/egyptsoc_sfx/lig_064-01y2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-04r2.tga" "./textures/egyptsoc_sfx/lig_064-04r2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-01a.tga" "./textures/egyptsoc_sfx/lig_b064-01a_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-03y2.tga" "./textures/egyptsoc_sfx/lig_032-03y2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-02c.tga" "./textures/egyptsoc_sfx/lig_b064-02c_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-03a.tga" "./textures/egyptsoc_sfx/lig_b064-03a_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-02b1.tga" "./textures/egyptsoc_sfx/lig_032-02b1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-02b.tga" "./textures/egyptsoc_sfx/lig_b064-02b_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-01b2.tga" "./textures/egyptsoc_sfx/lig_064-01b2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_128-05y1.tga" "./textures/egyptsoc_sfx/lig_128-05y1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-03d.tga" "./textures/egyptsoc_sfx/lig_b064-03d_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-03b.tga" "./textures/egyptsoc_sfx/lig_b064-03b_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-04y1.tga" "./textures/egyptsoc_sfx/lig_032-04y1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-02w1.tga" "./textures/egyptsoc_sfx/lig_032-02w1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-02r1.tga" "./textures/egyptsoc_sfx/lig_064-02r1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-06r1.tga" "./textures/egyptsoc_sfx/lig_064-06r1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-02r1.tga" "./textures/egyptsoc_sfx/lig_032-02r1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_v192-01wa.tga" "./textures/egyptsoc_sfx/lig_v192-01wa_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-04b2.tga" "./textures/egyptsoc_sfx/lig_064-04b2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-02y2.tga" "./textures/egyptsoc_sfx/lig_064-02y2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_128-05b2.tga" "./textures/egyptsoc_sfx/lig_128-05b2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-02e.tga" "./textures/egyptsoc_sfx/lig_b064-02e_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-06w1.tga" "./textures/egyptsoc_sfx/lig_064-06w1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-01w2.tga" "./textures/egyptsoc_sfx/lig_032-01w2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-02b2.tga" "./textures/egyptsoc_sfx/lig_032-02b2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-01y1.tga" "./textures/egyptsoc_sfx/lig_032-01y1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-02y1.tga" "./textures/egyptsoc_sfx/lig_032-02y1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-02y1.tga" "./textures/egyptsoc_sfx/lig_064-02y1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-04w2.tga" "./textures/egyptsoc_sfx/lig_032-04w2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-01b1.tga" "./textures/egyptsoc_sfx/lig_032-01b1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-01y1.tga" "./textures/egyptsoc_sfx/lig_064-01y1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-04y2.tga" "./textures/egyptsoc_sfx/lig_064-04y2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-02f.tga" "./textures/egyptsoc_sfx/lig_b064-02f_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-04b2.tga" "./textures/egyptsoc_sfx/lig_032-04b2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-04w1.tga" "./textures/egyptsoc_sfx/lig_064-04w1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-05y2.tga" "./textures/egyptsoc_sfx/lig_064-05y2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-05b2.tga" "./textures/egyptsoc_sfx/lig_064-05b2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_128-05w1.tga" "./textures/egyptsoc_sfx/lig_128-05w1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-05r2.tga" "./textures/egyptsoc_sfx/lig_064-05r2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-03b2.tga" "./textures/egyptsoc_sfx/lig_032-03b2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-01f.tga" "./textures/egyptsoc_sfx/lig_b064-01f_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-02r2.tga" "./textures/egyptsoc_sfx/lig_064-02r2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-04r2.tga" "./textures/egyptsoc_sfx/lig_032-04r2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-05w1.tga" "./textures/egyptsoc_sfx/lig_064-05w1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-01y2.tga" "./textures/egyptsoc_sfx/lig_032-01y2_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_032-01r1.tga" "./textures/egyptsoc_sfx/lig_032-01r1_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_b064-03c.tga" "./textures/egyptsoc_sfx/lig_b064-03c_norm.tga")
(batch-normalmap "./textures/egyptsoc_sfx/lig_064-01r1.tga" "./textures/egyptsoc_sfx/lig_064-01r1_norm.tga")
(gimp-quit 0)
