/* Generated from file: pss-vect.txt
 * with md5 hash: af66c6ca63a09d0443d5f78ff0e59c29
 */


typedef struct rsaKey {
  int n_l;
  unsigned char n[256];
  int e_l;
  unsigned char e[256];
  int d_l;
  unsigned char d[256];
  int p_l;
  unsigned char p[256];
  int q_l;
  unsigned char q[256];
  int dP_l;
  unsigned char dP[256];
  int dQ_l;
  unsigned char dQ[256];
  int qInv_l;
  unsigned char qInv[256];
} rsaKey_t;

typedef struct rsaData {
  const char* name;
  int o1_l;
  unsigned char o1[256];
  int o2_l;
  unsigned char o2[256];
  int o3_l;
  unsigned char o3[256];
} rsaData_t;

typedef struct testcase {
  const char* name;
  rsaKey_t rsa;
#ifdef LTC_TEST_EXT
  rsaData_t data[6];
#else
  rsaData_t data[1];
#endif /* LTC_TEST_EXT */
} testcase_t;

testcase_t testcases_pss[] =
    {
{
  "Example 1: A 1024-bit RSA Key Pair",
{
  /* RSA modulus n */
  128,
  { 0xa5, 0x6e, 0x4a, 0x0e, 0x70, 0x10, 0x17, 0x58, 0x9a, 0x51, 0x87, 0xdc, 0x7e, 0xa8, 0x41, 0xd1, 0x56, 0xf2, 0xec, 0x0e, 0x36, 0xad, 0x52, 0xa4, 0x4d, 0xfe, 0xb1, 0xe6, 0x1f, 0x7a, 0xd9, 0x91, 0xd8, 0xc5, 0x10, 0x56, 0xff, 0xed, 0xb1, 0x62, 0xb4, 0xc0, 0xf2, 0x83, 0xa1, 0x2a, 0x88, 0xa3, 0x94, 0xdf, 0xf5, 0x26, 0xab, 0x72, 0x91, 0xcb, 0xb3, 0x07, 0xce, 0xab, 0xfc, 0xe0, 0xb1, 0xdf, 0xd5, 0xcd, 0x95, 0x08, 0x09, 0x6d, 0x5b, 0x2b, 0x8b, 0x6d, 0xf5, 0xd6, 0x71, 0xef, 0x63, 0x77, 0xc0, 0x92, 0x1c, 0xb2, 0x3c, 0x27, 0x0a, 0x70, 0xe2, 0x59, 0x8e, 0x6f, 0xf8, 0x9d, 0x19, 0xf1, 0x05, 0xac, 0xc2, 0xd3, 0xf0, 0xcb, 0x35, 0xf2, 0x92, 0x80, 0xe1, 0x38, 0x6b, 0x6f, 0x64, 0xc4, 0xef, 0x22, 0xe1, 0xe1, 0xf2, 0x0d, 0x0c, 0xe8, 0xcf, 0xfb, 0x22, 0x49, 0xbd, 0x9a, 0x21, 0x37 }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  128,
  { 0x33, 0xa5, 0x04, 0x2a, 0x90, 0xb2, 0x7d, 0x4f, 0x54, 0x51, 0xca, 0x9b, 0xbb, 0xd0, 0xb4, 0x47, 0x71, 0xa1, 0x01, 0xaf, 0x88, 0x43, 0x40, 0xae, 0xf9, 0x88, 0x5f, 0x2a, 0x4b, 0xbe, 0x92, 0xe8, 0x94, 0xa7, 0x24, 0xac, 0x3c, 0x56, 0x8c, 0x8f, 0x97, 0x85, 0x3a, 0xd0, 0x7c, 0x02, 0x66, 0xc8, 0xc6, 0xa3, 0xca, 0x09, 0x29, 0xf1, 0xe8, 0xf1, 0x12, 0x31, 0x88, 0x44, 0x29, 0xfc, 0x4d, 0x9a, 0xe5, 0x5f, 0xee, 0x89, 0x6a, 0x10, 0xce, 0x70, 0x7c, 0x3e, 0xd7, 0xe7, 0x34, 0xe4, 0x47, 0x27, 0xa3, 0x95, 0x74, 0x50, 0x1a, 0x53, 0x26, 0x83, 0x10, 0x9c, 0x2a, 0xba, 0xca, 0xba, 0x28, 0x3c, 0x31, 0xb4, 0xbd, 0x2f, 0x53, 0xc3, 0xee, 0x37, 0xe3, 0x52, 0xce, 0xe3, 0x4f, 0x9e, 0x50, 0x3b, 0xd8, 0x0c, 0x06, 0x22, 0xad, 0x79, 0xc6, 0xdc, 0xee, 0x88, 0x35, 0x47, 0xc6, 0xa3, 0xb3, 0x25 }
,
  /* Prime p */
  64,
  { 0xe7, 0xe8, 0x94, 0x27, 0x20, 0xa8, 0x77, 0x51, 0x72, 0x73, 0xa3, 0x56, 0x05, 0x3e, 0xa2, 0xa1, 0xbc, 0x0c, 0x94, 0xaa, 0x72, 0xd5, 0x5c, 0x6e, 0x86, 0x29, 0x6b, 0x2d, 0xfc, 0x96, 0x79, 0x48, 0xc0, 0xa7, 0x2c, 0xbc, 0xcc, 0xa7, 0xea, 0xcb, 0x35, 0x70, 0x6e, 0x09, 0xa1, 0xdf, 0x55, 0xa1, 0x53, 0x5b, 0xd9, 0xb3, 0xcc, 0x34, 0x16, 0x0b, 0x3b, 0x6d, 0xcd, 0x3e, 0xda, 0x8e, 0x64, 0x43 }
,
  /* Prime q */
  64,
  { 0xb6, 0x9d, 0xca, 0x1c, 0xf7, 0xd4, 0xd7, 0xec, 0x81, 0xe7, 0x5b, 0x90, 0xfc, 0xca, 0x87, 0x4a, 0xbc, 0xde, 0x12, 0x3f, 0xd2, 0x70, 0x01, 0x80, 0xaa, 0x90, 0x47, 0x9b, 0x6e, 0x48, 0xde, 0x8d, 0x67, 0xed, 0x24, 0xf9, 0xf1, 0x9d, 0x85, 0xba, 0x27, 0x58, 0x74, 0xf5, 0x42, 0xcd, 0x20, 0xdc, 0x72, 0x3e, 0x69, 0x63, 0x36, 0x4a, 0x1f, 0x94, 0x25, 0x45, 0x2b, 0x26, 0x9a, 0x67, 0x99, 0xfd }
,
  /* p's CRT exponent dP */
  64,
  { 0x28, 0xfa, 0x13, 0x93, 0x86, 0x55, 0xbe, 0x1f, 0x8a, 0x15, 0x9c, 0xba, 0xca, 0x5a, 0x72, 0xea, 0x19, 0x0c, 0x30, 0x08, 0x9e, 0x19, 0xcd, 0x27, 0x4a, 0x55, 0x6f, 0x36, 0xc4, 0xf6, 0xe1, 0x9f, 0x55, 0x4b, 0x34, 0xc0, 0x77, 0x79, 0x04, 0x27, 0xbb, 0xdd, 0x8d, 0xd3, 0xed, 0xe2, 0x44, 0x83, 0x28, 0xf3, 0x85, 0xd8, 0x1b, 0x30, 0xe8, 0xe4, 0x3b, 0x2f, 0xff, 0xa0, 0x27, 0x86, 0x19, 0x79 }
,
  /* q's CRT exponent dQ */
  64,
  { 0x1a, 0x8b, 0x38, 0xf3, 0x98, 0xfa, 0x71, 0x20, 0x49, 0x89, 0x8d, 0x7f, 0xb7, 0x9e, 0xe0, 0xa7, 0x76, 0x68, 0x79, 0x12, 0x99, 0xcd, 0xfa, 0x09, 0xef, 0xc0, 0xe5, 0x07, 0xac, 0xb2, 0x1e, 0xd7, 0x43, 0x01, 0xef, 0x5b, 0xfd, 0x48, 0xbe, 0x45, 0x5e, 0xae, 0xb6, 0xe1, 0x67, 0x82, 0x55, 0x82, 0x75, 0x80, 0xa8, 0xe4, 0xe8, 0xe1, 0x41, 0x51, 0xd1, 0x51, 0x0a, 0x82, 0xa3, 0xf2, 0xe7, 0x29 }
,
  /* CRT coefficient qInv */
  64,
  { 0x27, 0x15, 0x6a, 0xba, 0x41, 0x26, 0xd2, 0x4a, 0x81, 0xf3, 0xa5, 0x28, 0xcb, 0xfb, 0x27, 0xf5, 0x68, 0x86, 0xf8, 0x40, 0xa9, 0xf6, 0xe8, 0x6e, 0x17, 0xa4, 0x4b, 0x94, 0xfe, 0x93, 0x19, 0x58, 0x4b, 0x8e, 0x22, 0xfd, 0xde, 0x1e, 0x5a, 0x2e, 0x3b, 0xd8, 0xaa, 0x5b, 0xa8, 0xd8, 0x58, 0x41, 0x94, 0xeb, 0x21, 0x90, 0xac, 0xf8, 0x32, 0xb8, 0x47, 0xf1, 0x3a, 0x3d, 0x24, 0xa7, 0x9f, 0x4d }

}
,
{{
  "RSASSA-PSS Signature Example 1.1",
  /* Message to be signed */
  217,
  { 0xcd, 0xc8, 0x7d, 0xa2, 0x23, 0xd7, 0x86, 0xdf, 0x3b, 0x45, 0xe0, 0xbb, 0xbc, 0x72, 0x13, 0x26, 0xd1, 0xee, 0x2a, 0xf8, 0x06, 0xcc, 0x31, 0x54, 0x75, 0xcc, 0x6f, 0x0d, 0x9c, 0x66, 0xe1, 0xb6, 0x23, 0x71, 0xd4, 0x5c, 0xe2, 0x39, 0x2e, 0x1a, 0xc9, 0x28, 0x44, 0xc3, 0x10, 0x10, 0x2f, 0x15, 0x6a, 0x0d, 0x8d, 0x52, 0xc1, 0xf4, 0xc4, 0x0b, 0xa3, 0xaa, 0x65, 0x09, 0x57, 0x86, 0xcb, 0x76, 0x97, 0x57, 0xa6, 0x56, 0x3b, 0xa9, 0x58, 0xfe, 0xd0, 0xbc, 0xc9, 0x84, 0xe8, 0xb5, 0x17, 0xa3, 0xd5, 0xf5, 0x15, 0xb2, 0x3b, 0x8a, 0x41, 0xe7, 0x4a, 0xa8, 0x67, 0x69, 0x3f, 0x90, 0xdf, 0xb0, 0x61, 0xa6, 0xe8, 0x6d, 0xfa, 0xae, 0xe6, 0x44, 0x72, 0xc0, 0x0e, 0x5f, 0x20, 0x94, 0x57, 0x29, 0xcb, 0xeb, 0xe7, 0x7f, 0x06, 0xce, 0x78, 0xe0, 0x8f, 0x40, 0x98, 0xfb, 0xa4, 0x1f, 0x9d, 0x61, 0x93, 0xc0, 0x31, 0x7e, 0x8b, 0x60, 0xd4, 0xb6, 0x08, 0x4a, 0xcb, 0x42, 0xd2, 0x9e, 0x38, 0x08, 0xa3, 0xbc, 0x37, 0x2d, 0x85, 0xe3, 0x31, 0x17, 0x0f, 0xcb, 0xf7, 0xcc, 0x72, 0xd0, 0xb7, 0x1c, 0x29, 0x66, 0x48, 0xb3, 0xa4, 0xd1, 0x0f, 0x41, 0x62, 0x95, 0xd0, 0x80, 0x7a, 0xa6, 0x25, 0xca, 0xb2, 0x74, 0x4f, 0xd9, 0xea, 0x8f, 0xd2, 0x23, 0xc4, 0x25, 0x37, 0x02, 0x98, 0x28, 0xbd, 0x16, 0xbe, 0x02, 0x54, 0x6f, 0x13, 0x0f, 0xd2, 0xe3, 0x3b, 0x93, 0x6d, 0x26, 0x76, 0xe0, 0x8a, 0xed, 0x1b, 0x73, 0x31, 0x8b, 0x75, 0x0a, 0x01, 0x67, 0xd0 }
,
  /* Salt */
  20,
  { 0xde, 0xe9, 0x59, 0xc7, 0xe0, 0x64, 0x11, 0x36, 0x14, 0x20, 0xff, 0x80, 0x18, 0x5e, 0xd5, 0x7f, 0x3e, 0x67, 0x76, 0xaf }
,
  /* Signature */
  128,
  { 0x90, 0x74, 0x30, 0x8f, 0xb5, 0x98, 0xe9, 0x70, 0x1b, 0x22, 0x94, 0x38, 0x8e, 0x52, 0xf9, 0x71, 0xfa, 0xac, 0x2b, 0x60, 0xa5, 0x14, 0x5a, 0xf1, 0x85, 0xdf, 0x52, 0x87, 0xb5, 0xed, 0x28, 0x87, 0xe5, 0x7c, 0xe7, 0xfd, 0x44, 0xdc, 0x86, 0x34, 0xe4, 0x07, 0xc8, 0xe0, 0xe4, 0x36, 0x0b, 0xc2, 0x26, 0xf3, 0xec, 0x22, 0x7f, 0x9d, 0x9e, 0x54, 0x63, 0x8e, 0x8d, 0x31, 0xf5, 0x05, 0x12, 0x15, 0xdf, 0x6e, 0xbb, 0x9c, 0x2f, 0x95, 0x79, 0xaa, 0x77, 0x59, 0x8a, 0x38, 0xf9, 0x14, 0xb5, 0xb9, 0xc1, 0xbd, 0x83, 0xc4, 0xe2, 0xf9, 0xf3, 0x82, 0xa0, 0xd0, 0xaa, 0x35, 0x42, 0xff, 0xee, 0x65, 0x98, 0x4a, 0x60, 0x1b, 0xc6, 0x9e, 0xb2, 0x8d, 0xeb, 0x27, 0xdc, 0xa1, 0x2c, 0x82, 0xc2, 0xd4, 0xc3, 0xf6, 0x6c, 0xd5, 0x00, 0xf1, 0xff, 0x2b, 0x99, 0x4d, 0x8a, 0x4e, 0x30, 0xcb, 0xb3, 0x3c }

}
,
#ifdef LTC_TEST_EXT
{
  "RSASSA-PSS Signature Example 1.2",
  /* Message to be signed */
  51,
  { 0x85, 0x13, 0x84, 0xcd, 0xfe, 0x81, 0x9c, 0x22, 0xed, 0x6c, 0x4c, 0xcb, 0x30, 0xda, 0xeb, 0x5c, 0xf0, 0x59, 0xbc, 0x8e, 0x11, 0x66, 0xb7, 0xe3, 0x53, 0x0c, 0x4c, 0x23, 0x3e, 0x2b, 0x5f, 0x8f, 0x71, 0xa1, 0xcc, 0xa5, 0x82, 0xd4, 0x3e, 0xcc, 0x72, 0xb1, 0xbc, 0xa1, 0x6d, 0xfc, 0x70, 0x13, 0x22, 0x6b, 0x9e }
,
  /* Salt */
  20,
  { 0xef, 0x28, 0x69, 0xfa, 0x40, 0xc3, 0x46, 0xcb, 0x18, 0x3d, 0xab, 0x3d, 0x7b, 0xff, 0xc9, 0x8f, 0xd5, 0x6d, 0xf4, 0x2d }
,
  /* Signature */
  128,
  { 0x3e, 0xf7, 0xf4, 0x6e, 0x83, 0x1b, 0xf9, 0x2b, 0x32, 0x27, 0x41, 0x42, 0xa5, 0x85, 0xff, 0xce, 0xfb, 0xdc, 0xa7, 0xb3, 0x2a, 0xe9, 0x0d, 0x10, 0xfb, 0x0f, 0x0c, 0x72, 0x99, 0x84, 0xf0, 0x4e, 0xf2, 0x9a, 0x9d, 0xf0, 0x78, 0x07, 0x75, 0xce, 0x43, 0x73, 0x9b, 0x97, 0x83, 0x83, 0x90, 0xdb, 0x0a, 0x55, 0x05, 0xe6, 0x3d, 0xe9, 0x27, 0x02, 0x8d, 0x9d, 0x29, 0xb2, 0x19, 0xca, 0x2c, 0x45, 0x17, 0x83, 0x25, 0x58, 0xa5, 0x5d, 0x69, 0x4a, 0x6d, 0x25, 0xb9, 0xda, 0xb6, 0x60, 0x03, 0xc4, 0xcc, 0xcd, 0x90, 0x78, 0x02, 0x19, 0x3b, 0xe5, 0x17, 0x0d, 0x26, 0x14, 0x7d, 0x37, 0xb9, 0x35, 0x90, 0x24, 0x1b, 0xe5, 0x1c, 0x25, 0x05, 0x5f, 0x47, 0xef, 0x62, 0x75, 0x2c, 0xfb, 0xe2, 0x14, 0x18, 0xfa, 0xfe, 0x98, 0xc2, 0x2c, 0x4d, 0x4d, 0x47, 0x72, 0x4f, 0xdb, 0x56, 0x69, 0xe8, 0x43 }

}
,
{
  "RSASSA-PSS Signature Example 1.3",
  /* Message to be signed */
  228,
  { 0xa4, 0xb1, 0x59, 0x94, 0x17, 0x61, 0xc4, 0x0c, 0x6a, 0x82, 0xf2, 0xb8, 0x0d, 0x1b, 0x94, 0xf5, 0xaa, 0x26, 0x54, 0xfd, 0x17, 0xe1, 0x2d, 0x58, 0x88, 0x64, 0x67, 0x9b, 0x54, 0xcd, 0x04, 0xef, 0x8b, 0xd0, 0x30, 0x12, 0xbe, 0x8d, 0xc3, 0x7f, 0x4b, 0x83, 0xaf, 0x79, 0x63, 0xfa, 0xff, 0x0d, 0xfa, 0x22, 0x54, 0x77, 0x43, 0x7c, 0x48, 0x01, 0x7f, 0xf2, 0xbe, 0x81, 0x91, 0xcf, 0x39, 0x55, 0xfc, 0x07, 0x35, 0x6e, 0xab, 0x3f, 0x32, 0x2f, 0x7f, 0x62, 0x0e, 0x21, 0xd2, 0x54, 0xe5, 0xdb, 0x43, 0x24, 0x27, 0x9f, 0xe0, 0x67, 0xe0, 0x91, 0x0e, 0x2e, 0x81, 0xca, 0x2c, 0xab, 0x31, 0xc7, 0x45, 0xe6, 0x7a, 0x54, 0x05, 0x8e, 0xb5, 0x0d, 0x99, 0x3c, 0xdb, 0x9e, 0xd0, 0xb4, 0xd0, 0x29, 0xc0, 0x6d, 0x21, 0xa9, 0x4c, 0xa6, 0x61, 0xc3, 0xce, 0x27, 0xfa, 0xe1, 0xd6, 0xcb, 0x20, 0xf4, 0x56, 0x4d, 0x66, 0xce, 0x47, 0x67, 0x58, 0x3d, 0x0e, 0x5f, 0x06, 0x02, 0x15, 0xb5, 0x90, 0x17, 0xbe, 0x85, 0xea, 0x84, 0x89, 0x39, 0x12, 0x7b, 0xd8, 0xc9, 0xc4, 0xd4, 0x7b, 0x51, 0x05, 0x6c, 0x03, 0x1c, 0xf3, 0x36, 0xf1, 0x7c, 0x99, 0x80, 0xf3, 0xb8, 0xf5, 0xb9, 0xb6, 0x87, 0x8e, 0x8b, 0x79, 0x7a, 0xa4, 0x3b, 0x88, 0x26, 0x84, 0x33, 0x3e, 0x17, 0x89, 0x3f, 0xe9, 0xca, 0xa6, 0xaa, 0x29, 0x9f, 0x7e, 0xd1, 0xa1, 0x8e, 0xe2, 0xc5, 0x48, 0x64, 0xb7, 0xb2, 0xb9, 0x9b, 0x72, 0x61, 0x8f, 0xb0, 0x25, 0x74, 0xd1, 0x39, 0xef, 0x50, 0xf0, 0x19, 0xc9, 0xee, 0xf4, 0x16, 0x97, 0x13, 0x38, 0xe7, 0xd4, 0x70 }
,
  /* Salt */
  20,
  { 0x71, 0x0b, 0x9c, 0x47, 0x47, 0xd8, 0x00, 0xd4, 0xde, 0x87, 0xf1, 0x2a, 0xfd, 0xce, 0x6d, 0xf1, 0x81, 0x07, 0xcc, 0x77 }
,
  /* Signature */
  128,
  { 0x66, 0x60, 0x26, 0xfb, 0xa7, 0x1b, 0xd3, 0xe7, 0xcf, 0x13, 0x15, 0x7c, 0xc2, 0xc5, 0x1a, 0x8e, 0x4a, 0xa6, 0x84, 0xaf, 0x97, 0x78, 0xf9, 0x18, 0x49, 0xf3, 0x43, 0x35, 0xd1, 0x41, 0xc0, 0x01, 0x54, 0xc4, 0x19, 0x76, 0x21, 0xf9, 0x62, 0x4a, 0x67, 0x5b, 0x5a, 0xbc, 0x22, 0xee, 0x7d, 0x5b, 0xaa, 0xff, 0xaa, 0xe1, 0xc9, 0xba, 0xca, 0x2c, 0xc3, 0x73, 0xb3, 0xf3, 0x3e, 0x78, 0xe6, 0x14, 0x3c, 0x39, 0x5a, 0x91, 0xaa, 0x7f, 0xac, 0xa6, 0x64, 0xeb, 0x73, 0x3a, 0xfd, 0x14, 0xd8, 0x82, 0x72, 0x59, 0xd9, 0x9a, 0x75, 0x50, 0xfa, 0xca, 0x50, 0x1e, 0xf2, 0xb0, 0x4e, 0x33, 0xc2, 0x3a, 0xa5, 0x1f, 0x4b, 0x9e, 0x82, 0x82, 0xef, 0xdb, 0x72, 0x8c, 0xc0, 0xab, 0x09, 0x40, 0x5a, 0x91, 0x60, 0x7c, 0x63, 0x69, 0x96, 0x1b, 0xc8, 0x27, 0x0d, 0x2d, 0x4f, 0x39, 0xfc, 0xe6, 0x12, 0xb1 }

}
,
{
  "RSASSA-PSS Signature Example 1.4",
  /* Message to be signed */
  9,
  { 0xbc, 0x65, 0x67, 0x47, 0xfa, 0x9e, 0xaf, 0xb3, 0xf0 }
,
  /* Salt */
  20,
  { 0x05, 0x6f, 0x00, 0x98, 0x5d, 0xe1, 0x4d, 0x8e, 0xf5, 0xce, 0xa9, 0xe8, 0x2f, 0x8c, 0x27, 0xbe, 0xf7, 0x20, 0x33, 0x5e }
,
  /* Signature */
  128,
  { 0x46, 0x09, 0x79, 0x3b, 0x23, 0xe9, 0xd0, 0x93, 0x62, 0xdc, 0x21, 0xbb, 0x47, 0xda, 0x0b, 0x4f, 0x3a, 0x76, 0x22, 0x64, 0x9a, 0x47, 0xd4, 0x64, 0x01, 0x9b, 0x9a, 0xea, 0xfe, 0x53, 0x35, 0x9c, 0x17, 0x8c, 0x91, 0xcd, 0x58, 0xba, 0x6b, 0xcb, 0x78, 0xbe, 0x03, 0x46, 0xa7, 0xbc, 0x63, 0x7f, 0x4b, 0x87, 0x3d, 0x4b, 0xab, 0x38, 0xee, 0x66, 0x1f, 0x19, 0x96, 0x34, 0xc5, 0x47, 0xa1, 0xad, 0x84, 0x42, 0xe0, 0x3d, 0xa0, 0x15, 0xb1, 0x36, 0xe5, 0x43, 0xf7, 0xab, 0x07, 0xc0, 0xc1, 0x3e, 0x42, 0x25, 0xb8, 0xde, 0x8c, 0xce, 0x25, 0xd4, 0xf6, 0xeb, 0x84, 0x00, 0xf8, 0x1f, 0x7e, 0x18, 0x33, 0xb7, 0xee, 0x6e, 0x33, 0x4d, 0x37, 0x09, 0x64, 0xca, 0x79, 0xfd, 0xb8, 0x72, 0xb4, 0xd7, 0x52, 0x23, 0xb5, 0xee, 0xb0, 0x81, 0x01, 0x59, 0x1f, 0xb5, 0x32, 0xd1, 0x55, 0xa6, 0xde, 0x87 }

}
,
{
  "RSASSA-PSS Signature Example 1.5",
  /* Message to be signed */
  149,
  { 0xb4, 0x55, 0x81, 0x54, 0x7e, 0x54, 0x27, 0x77, 0x0c, 0x76, 0x8e, 0x8b, 0x82, 0xb7, 0x55, 0x64, 0xe0, 0xea, 0x4e, 0x9c, 0x32, 0x59, 0x4d, 0x6b, 0xff, 0x70, 0x65, 0x44, 0xde, 0x0a, 0x87, 0x76, 0xc7, 0xa8, 0x0b, 0x45, 0x76, 0x55, 0x0e, 0xee, 0x1b, 0x2a, 0xca, 0xbc, 0x7e, 0x8b, 0x7d, 0x3e, 0xf7, 0xbb, 0x5b, 0x03, 0xe4, 0x62, 0xc1, 0x10, 0x47, 0xea, 0xdd, 0x00, 0x62, 0x9a, 0xe5, 0x75, 0x48, 0x0a, 0xc1, 0x47, 0x0f, 0xe0, 0x46, 0xf1, 0x3a, 0x2b, 0xf5, 0xaf, 0x17, 0x92, 0x1d, 0xc4, 0xb0, 0xaa, 0x8b, 0x02, 0xbe, 0xe6, 0x33, 0x49, 0x11, 0x65, 0x1d, 0x7f, 0x85, 0x25, 0xd1, 0x0f, 0x32, 0xb5, 0x1d, 0x33, 0xbe, 0x52, 0x0d, 0x3d, 0xdf, 0x5a, 0x70, 0x99, 0x55, 0xa3, 0xdf, 0xe7, 0x82, 0x83, 0xb9, 0xe0, 0xab, 0x54, 0x04, 0x6d, 0x15, 0x0c, 0x17, 0x7f, 0x03, 0x7f, 0xdc, 0xcc, 0x5b, 0xe4, 0xea, 0x5f, 0x68, 0xb5, 0xe5, 0xa3, 0x8c, 0x9d, 0x7e, 0xdc, 0xcc, 0xc4, 0x97, 0x5f, 0x45, 0x5a, 0x69, 0x09, 0xb4 }
,
  /* Salt */
  20,
  { 0x80, 0xe7, 0x0f, 0xf8, 0x6a, 0x08, 0xde, 0x3e, 0xc6, 0x09, 0x72, 0xb3, 0x9b, 0x4f, 0xbf, 0xdc, 0xea, 0x67, 0xae, 0x8e }
,
  /* Signature */
  128,
  { 0x1d, 0x2a, 0xad, 0x22, 0x1c, 0xa4, 0xd3, 0x1d, 0xdf, 0x13, 0x50, 0x92, 0x39, 0x01, 0x93, 0x98, 0xe3, 0xd1, 0x4b, 0x32, 0xdc, 0x34, 0xdc, 0x5a, 0xf4, 0xae, 0xae, 0xa3, 0xc0, 0x95, 0xaf, 0x73, 0x47, 0x9c, 0xf0, 0xa4, 0x5e, 0x56, 0x29, 0x63, 0x5a, 0x53, 0xa0, 0x18, 0x37, 0x76, 0x15, 0xb1, 0x6c, 0xb9, 0xb1, 0x3b, 0x3e, 0x09, 0xd6, 0x71, 0xeb, 0x71, 0xe3, 0x87, 0xb8, 0x54, 0x5c, 0x59, 0x60, 0xda, 0x5a, 0x64, 0x77, 0x6e, 0x76, 0x8e, 0x82, 0xb2, 0xc9, 0x35, 0x83, 0xbf, 0x10, 0x4c, 0x3f, 0xdb, 0x23, 0x51, 0x2b, 0x7b, 0x4e, 0x89, 0xf6, 0x33, 0xdd, 0x00, 0x63, 0xa5, 0x30, 0xdb, 0x45, 0x24, 0xb0, 0x1c, 0x3f, 0x38, 0x4c, 0x09, 0x31, 0x0e, 0x31, 0x5a, 0x79, 0xdc, 0xd3, 0xd6, 0x84, 0x02, 0x2a, 0x7f, 0x31, 0xc8, 0x65, 0xa6, 0x64, 0xe3, 0x16, 0x97, 0x8b, 0x75, 0x9f, 0xad }

}
,
{
  "RSASSA-PSS Signature Example 1.6",
  /* Message to be signed */
  233,
  { 0x10, 0xaa, 0xe9, 0xa0, 0xab, 0x0b, 0x59, 0x5d, 0x08, 0x41, 0x20, 0x7b, 0x70, 0x0d, 0x48, 0xd7, 0x5f, 0xae, 0xdd, 0xe3, 0xb7, 0x75, 0xcd, 0x6b, 0x4c, 0xc8, 0x8a, 0xe0, 0x6e, 0x46, 0x94, 0xec, 0x74, 0xba, 0x18, 0xf8, 0x52, 0x0d, 0x4f, 0x5e, 0xa6, 0x9c, 0xbb, 0xe7, 0xcc, 0x2b, 0xeb, 0xa4, 0x3e, 0xfd, 0xc1, 0x02, 0x15, 0xac, 0x4e, 0xb3, 0x2d, 0xc3, 0x02, 0xa1, 0xf5, 0x3d, 0xc6, 0xc4, 0x35, 0x22, 0x67, 0xe7, 0x93, 0x6c, 0xfe, 0xbf, 0x7c, 0x8d, 0x67, 0x03, 0x57, 0x84, 0xa3, 0x90, 0x9f, 0xa8, 0x59, 0xc7, 0xb7, 0xb5, 0x9b, 0x8e, 0x39, 0xc5, 0xc2, 0x34, 0x9f, 0x18, 0x86, 0xb7, 0x05, 0xa3, 0x02, 0x67, 0xd4, 0x02, 0xf7, 0x48, 0x6a, 0xb4, 0xf5, 0x8c, 0xad, 0x5d, 0x69, 0xad, 0xb1, 0x7a, 0xb8, 0xcd, 0x0c, 0xe1, 0xca, 0xf5, 0x02, 0x5a, 0xf4, 0xae, 0x24, 0xb1, 0xfb, 0x87, 0x94, 0xc6, 0x07, 0x0c, 0xc0, 0x9a, 0x51, 0xe2, 0xf9, 0x91, 0x13, 0x11, 0xe3, 0x87, 0x7d, 0x00, 0x44, 0xc7, 0x1c, 0x57, 0xa9, 0x93, 0x39, 0x50, 0x08, 0x80, 0x6b, 0x72, 0x3a, 0xc3, 0x83, 0x73, 0xd3, 0x95, 0x48, 0x18, 0x18, 0x52, 0x8c, 0x1e, 0x70, 0x53, 0x73, 0x92, 0x82, 0x05, 0x35, 0x29, 0x51, 0x0e, 0x93, 0x5c, 0xd0, 0xfa, 0x77, 0xb8, 0xfa, 0x53, 0xcc, 0x2d, 0x47, 0x4b, 0xd4, 0xfb, 0x3c, 0xc5, 0xc6, 0x72, 0xd6, 0xff, 0xdc, 0x90, 0xa0, 0x0f, 0x98, 0x48, 0x71, 0x2c, 0x4b, 0xcf, 0xe4, 0x6c, 0x60, 0x57, 0x36, 0x59, 0xb1, 0x1e, 0x64, 0x57, 0xe8, 0x61, 0xf0, 0xf6, 0x04, 0xb6, 0x13, 0x8d, 0x14, 0x4f, 0x8c, 0xe4, 0xe2, 0xda, 0x73 }
,
  /* Salt */
  20,
  { 0xa8, 0xab, 0x69, 0xdd, 0x80, 0x1f, 0x00, 0x74, 0xc2, 0xa1, 0xfc, 0x60, 0x64, 0x98, 0x36, 0xc6, 0x16, 0xd9, 0x96, 0x81 }
,
  /* Signature */
  128,
  { 0x2a, 0x34, 0xf6, 0x12, 0x5e, 0x1f, 0x6b, 0x0b, 0xf9, 0x71, 0xe8, 0x4f, 0xbd, 0x41, 0xc6, 0x32, 0xbe, 0x8f, 0x2c, 0x2a, 0xce, 0x7d, 0xe8, 0xb6, 0x92, 0x6e, 0x31, 0xff, 0x93, 0xe9, 0xaf, 0x98, 0x7f, 0xbc, 0x06, 0xe5, 0x1e, 0x9b, 0xe1, 0x4f, 0x51, 0x98, 0xf9, 0x1f, 0x3f, 0x95, 0x3b, 0xd6, 0x7d, 0xa6, 0x0a, 0x9d, 0xf5, 0x97, 0x64, 0xc3, 0xdc, 0x0f, 0xe0, 0x8e, 0x1c, 0xbe, 0xf0, 0xb7, 0x5f, 0x86, 0x8d, 0x10, 0xad, 0x3f, 0xba, 0x74, 0x9f, 0xef, 0x59, 0xfb, 0x6d, 0xac, 0x46, 0xa0, 0xd6, 0xe5, 0x04, 0x36, 0x93, 0x31, 0x58, 0x6f, 0x58, 0xe4, 0x62, 0x8f, 0x39, 0xaa, 0x27, 0x89, 0x82, 0x54, 0x3b, 0xc0, 0xee, 0xb5, 0x37, 0xdc, 0x61, 0x95, 0x80, 0x19, 0xb3, 0x94, 0xfb, 0x27, 0x3f, 0x21, 0x58, 0x58, 0xa0, 0xa0, 0x1a, 0xc4, 0xd6, 0x50, 0xb9, 0x55, 0xc6, 0x7f, 0x4c, 0x58 }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 2: A 1025-bit RSA Key Pair",
{
  /* RSA modulus n */
  129,
  { 0x01, 0xd4, 0x0c, 0x1b, 0xcf, 0x97, 0xa6, 0x8a, 0xe7, 0xcd, 0xbd, 0x8a, 0x7b, 0xf3, 0xe3, 0x4f, 0xa1, 0x9d, 0xcc, 0xa4, 0xef, 0x75, 0xa4, 0x74, 0x54, 0x37, 0x5f, 0x94, 0x51, 0x4d, 0x88, 0xfe, 0xd0, 0x06, 0xfb, 0x82, 0x9f, 0x84, 0x19, 0xff, 0x87, 0xd6, 0x31, 0x5d, 0xa6, 0x8a, 0x1f, 0xf3, 0xa0, 0x93, 0x8e, 0x9a, 0xbb, 0x34, 0x64, 0x01, 0x1c, 0x30, 0x3a, 0xd9, 0x91, 0x99, 0xcf, 0x0c, 0x7c, 0x7a, 0x8b, 0x47, 0x7d, 0xce, 0x82, 0x9e, 0x88, 0x44, 0xf6, 0x25, 0xb1, 0x15, 0xe5, 0xe9, 0xc4, 0xa5, 0x9c, 0xf8, 0xf8, 0x11, 0x3b, 0x68, 0x34, 0x33, 0x6a, 0x2f, 0xd2, 0x68, 0x9b, 0x47, 0x2c, 0xbb, 0x5e, 0x5c, 0xab, 0xe6, 0x74, 0x35, 0x0c, 0x59, 0xb6, 0xc1, 0x7e, 0x17, 0x68, 0x74, 0xfb, 0x42, 0xf8, 0xfc, 0x3d, 0x17, 0x6a, 0x01, 0x7e, 0xdc, 0x61, 0xfd, 0x32, 0x6c, 0x4b, 0x33, 0xc9 }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  128,
  { 0x02, 0x7d, 0x14, 0x7e, 0x46, 0x73, 0x05, 0x73, 0x77, 0xfd, 0x1e, 0xa2, 0x01, 0x56, 0x57, 0x72, 0x17, 0x6a, 0x7d, 0xc3, 0x83, 0x58, 0xd3, 0x76, 0x04, 0x56, 0x85, 0xa2, 0xe7, 0x87, 0xc2, 0x3c, 0x15, 0x57, 0x6b, 0xc1, 0x6b, 0x9f, 0x44, 0x44, 0x02, 0xd6, 0xbf, 0xc5, 0xd9, 0x8a, 0x3e, 0x88, 0xea, 0x13, 0xef, 0x67, 0xc3, 0x53, 0xec, 0xa0, 0xc0, 0xdd, 0xba, 0x92, 0x55, 0xbd, 0x7b, 0x8b, 0xb5, 0x0a, 0x64, 0x4a, 0xfd, 0xfd, 0x1d, 0xd5, 0x16, 0x95, 0xb2, 0x52, 0xd2, 0x2e, 0x73, 0x18, 0xd1, 0xb6, 0x68, 0x7a, 0x1c, 0x10, 0xff, 0x75, 0x54, 0x5f, 0x3d, 0xb0, 0xfe, 0x60, 0x2d, 0x5f, 0x2b, 0x7f, 0x29, 0x4e, 0x36, 0x01, 0xea, 0xb7, 0xb9, 0xd1, 0xce, 0xcd, 0x76, 0x7f, 0x64, 0x69, 0x2e, 0x3e, 0x53, 0x6c, 0xa2, 0x84, 0x6c, 0xb0, 0xc2, 0xdd, 0x48, 0x6a, 0x39, 0xfa, 0x75, 0xb1 }
,
  /* Prime p */
  65,
  { 0x01, 0x66, 0x01, 0xe9, 0x26, 0xa0, 0xf8, 0xc9, 0xe2, 0x6e, 0xca, 0xb7, 0x69, 0xea, 0x65, 0xa5, 0xe7, 0xc5, 0x2c, 0xc9, 0xe0, 0x80, 0xef, 0x51, 0x94, 0x57, 0xc6, 0x44, 0xda, 0x68, 0x91, 0xc5, 0xa1, 0x04, 0xd3, 0xea, 0x79, 0x55, 0x92, 0x9a, 0x22, 0xe7, 0xc6, 0x8a, 0x7a, 0xf9, 0xfc, 0xad, 0x77, 0x7c, 0x3c, 0xcc, 0x2b, 0x9e, 0x3d, 0x36, 0x50, 0xbc, 0xe4, 0x04, 0x39, 0x9b, 0x7e, 0x59, 0xd1 }
,
  /* Prime q */
  65,
  { 0x01, 0x4e, 0xaf, 0xa1, 0xd4, 0xd0, 0x18, 0x4d, 0xa7, 0xe3, 0x1f, 0x87, 0x7d, 0x12, 0x81, 0xdd, 0xda, 0x62, 0x56, 0x64, 0x86, 0x9e, 0x83, 0x79, 0xe6, 0x7a, 0xd3, 0xb7, 0x5e, 0xae, 0x74, 0xa5, 0x80, 0xe9, 0x82, 0x7a, 0xbd, 0x6e, 0xb7, 0xa0, 0x02, 0xcb, 0x54, 0x11, 0xf5, 0x26, 0x67, 0x97, 0x76, 0x8f, 0xb8, 0xe9, 0x5a, 0xe4, 0x0e, 0x3e, 0x8a, 0x01, 0xf3, 0x5f, 0xf8, 0x9e, 0x56, 0xc0, 0x79 }
,
  /* p's CRT exponent dP */
  64,
  { 0xe2, 0x47, 0xcc, 0xe5, 0x04, 0x93, 0x9b, 0x8f, 0x0a, 0x36, 0x09, 0x0d, 0xe2, 0x00, 0x93, 0x87, 0x55, 0xe2, 0x44, 0x4b, 0x29, 0x53, 0x9a, 0x7d, 0xa7, 0xa9, 0x02, 0xf6, 0x05, 0x68, 0x35, 0xc0, 0xdb, 0x7b, 0x52, 0x55, 0x94, 0x97, 0xcf, 0xe2, 0xc6, 0x1a, 0x80, 0x86, 0xd0, 0x21, 0x3c, 0x47, 0x2c, 0x78, 0x85, 0x18, 0x00, 0xb1, 0x71, 0xf6, 0x40, 0x1d, 0xe2, 0xe9, 0xc2, 0x75, 0x6f, 0x31 }
,
  /* q's CRT exponent dQ */
  64,
  { 0xb1, 0x2f, 0xba, 0x75, 0x78, 0x55, 0xe5, 0x86, 0xe4, 0x6f, 0x64, 0xc3, 0x8a, 0x70, 0xc6, 0x8b, 0x3f, 0x54, 0x8d, 0x93, 0xd7, 0x87, 0xb3, 0x99, 0x99, 0x9d, 0x4c, 0x8f, 0x0b, 0xbd, 0x25, 0x81, 0xc2, 0x1e, 0x19, 0xed, 0x00, 0x18, 0xa6, 0xd5, 0xd3, 0xdf, 0x86, 0x42, 0x4b, 0x3a, 0xbc, 0xad, 0x40, 0x19, 0x9d, 0x31, 0x49, 0x5b, 0x61, 0x30, 0x9f, 0x27, 0xc1, 0xbf, 0x55, 0xd4, 0x87, 0xc1 }
,
  /* CRT coefficient qInv */
  64,
  { 0x56, 0x4b, 0x1e, 0x1f, 0xa0, 0x03, 0xbd, 0xa9, 0x1e, 0x89, 0x09, 0x04, 0x25, 0xaa, 0xc0, 0x5b, 0x91, 0xda, 0x9e, 0xe2, 0x50, 0x61, 0xe7, 0x62, 0x8d, 0x5f, 0x51, 0x30, 0x4a, 0x84, 0x99, 0x2f, 0xdc, 0x33, 0x76, 0x2b, 0xd3, 0x78, 0xa5, 0x9f, 0x03, 0x0a, 0x33, 0x4d, 0x53, 0x2b, 0xd0, 0xda, 0xe8, 0xf2, 0x98, 0xea, 0x9e, 0xd8, 0x44, 0x63, 0x6a, 0xd5, 0xfb, 0x8c, 0xbd, 0xc0, 0x3c, 0xad }

}
,
{{
  "RSASSA-PSS Signature Example 2.1",
  /* Message to be signed */
  61,
  { 0xda, 0xba, 0x03, 0x20, 0x66, 0x26, 0x3f, 0xae, 0xdb, 0x65, 0x98, 0x48, 0x11, 0x52, 0x78, 0xa5, 0x2c, 0x44, 0xfa, 0xa3, 0xa7, 0x6f, 0x37, 0x51, 0x5e, 0xd3, 0x36, 0x32, 0x10, 0x72, 0xc4, 0x0a, 0x9d, 0x9b, 0x53, 0xbc, 0x05, 0x01, 0x40, 0x78, 0xad, 0xf5, 0x20, 0x87, 0x51, 0x46, 0xaa, 0xe7, 0x0f, 0xf0, 0x60, 0x22, 0x6d, 0xcb, 0x7b, 0x1f, 0x1f, 0xc2, 0x7e, 0x93, 0x60 }
,
  /* Salt */
  20,
  { 0x57, 0xbf, 0x16, 0x0b, 0xcb, 0x02, 0xbb, 0x1d, 0xc7, 0x28, 0x0c, 0xf0, 0x45, 0x85, 0x30, 0xb7, 0xd2, 0x83, 0x2f, 0xf7 }
,
  /* Signature */
  129,
  { 0x01, 0x4c, 0x5b, 0xa5, 0x33, 0x83, 0x28, 0xcc, 0xc6, 0xe7, 0xa9, 0x0b, 0xf1, 0xc0, 0xab, 0x3f, 0xd6, 0x06, 0xff, 0x47, 0x96, 0xd3, 0xc1, 0x2e, 0x4b, 0x63, 0x9e, 0xd9, 0x13, 0x6a, 0x5f, 0xec, 0x6c, 0x16, 0xd8, 0x88, 0x4b, 0xdd, 0x99, 0xcf, 0xdc, 0x52, 0x14, 0x56, 0xb0, 0x74, 0x2b, 0x73, 0x68, 0x68, 0xcf, 0x90, 0xde, 0x09, 0x9a, 0xdb, 0x8d, 0x5f, 0xfd, 0x1d, 0xef, 0xf3, 0x9b, 0xa4, 0x00, 0x7a, 0xb7, 0x46, 0xce, 0xfd, 0xb2, 0x2d, 0x7d, 0xf0, 0xe2, 0x25, 0xf5, 0x46, 0x27, 0xdc, 0x65, 0x46, 0x61, 0x31, 0x72, 0x1b, 0x90, 0xaf, 0x44, 0x53, 0x63, 0xa8, 0x35, 0x8b, 0x9f, 0x60, 0x76, 0x42, 0xf7, 0x8f, 0xab, 0x0a, 0xb0, 0xf4, 0x3b, 0x71, 0x68, 0xd6, 0x4b, 0xae, 0x70, 0xd8, 0x82, 0x78, 0x48, 0xd8, 0xef, 0x1e, 0x42, 0x1c, 0x57, 0x54, 0xdd, 0xf4, 0x2c, 0x25, 0x89, 0xb5, 0xb3 }

}
,
#ifdef LTC_TEST_EXT
{
  "RSASSA-PSS Signature Example 2.2",
  /* Message to be signed */
  234,
  { 0xe4, 0xf8, 0x60, 0x1a, 0x8a, 0x6d, 0xa1, 0xbe, 0x34, 0x44, 0x7c, 0x09, 0x59, 0xc0, 0x58, 0x57, 0x0c, 0x36, 0x68, 0xcf, 0xd5, 0x1d, 0xd5, 0xf9, 0xcc, 0xd6, 0xad, 0x44, 0x11, 0xfe, 0x82, 0x13, 0x48, 0x6d, 0x78, 0xa6, 0xc4, 0x9f, 0x93, 0xef, 0xc2, 0xca, 0x22, 0x88, 0xce, 0xbc, 0x2b, 0x9b, 0x60, 0xbd, 0x04, 0xb1, 0xe2, 0x20, 0xd8, 0x6e, 0x3d, 0x48, 0x48, 0xd7, 0x09, 0xd0, 0x32, 0xd1, 0xe8, 0xc6, 0xa0, 0x70, 0xc6, 0xaf, 0x9a, 0x49, 0x9f, 0xcf, 0x95, 0x35, 0x4b, 0x14, 0xba, 0x61, 0x27, 0xc7, 0x39, 0xde, 0x1b, 0xb0, 0xfd, 0x16, 0x43, 0x1e, 0x46, 0x93, 0x8a, 0xec, 0x0c, 0xf8, 0xad, 0x9e, 0xb7, 0x2e, 0x83, 0x2a, 0x70, 0x35, 0xde, 0x9b, 0x78, 0x07, 0xbd, 0xc0, 0xed, 0x8b, 0x68, 0xeb, 0x0f, 0x5a, 0xc2, 0x21, 0x6b, 0xe4, 0x0c, 0xe9, 0x20, 0xc0, 0xdb, 0x0e, 0xdd, 0xd3, 0x86, 0x0e, 0xd7, 0x88, 0xef, 0xac, 0xca, 0xca, 0x50, 0x2d, 0x8f, 0x2b, 0xd6, 0xd1, 0xa7, 0xc1, 0xf4, 0x1f, 0xf4, 0x6f, 0x16, 0x81, 0xc8, 0xf1, 0xf8, 0x18, 0xe9, 0xc4, 0xf6, 0xd9, 0x1a, 0x0c, 0x78, 0x03, 0xcc, 0xc6, 0x3d, 0x76, 0xa6, 0x54, 0x4d, 0x84, 0x3e, 0x08, 0x4e, 0x36, 0x3b, 0x8a, 0xcc, 0x55, 0xaa, 0x53, 0x17, 0x33, 0xed, 0xb5, 0xde, 0xe5, 0xb5, 0x19, 0x6e, 0x9f, 0x03, 0xe8, 0xb7, 0x31, 0xb3, 0x77, 0x64, 0x28, 0xd9, 0xe4, 0x57, 0xfe, 0x3f, 0xbc, 0xb3, 0xdb, 0x72, 0x74, 0x44, 0x2d, 0x78, 0x58, 0x90, 0xe9, 0xcb, 0x08, 0x54, 0xb6, 0x44, 0x4d, 0xac, 0xe7, 0x91, 0xd7, 0x27, 0x3d, 0xe1, 0x88, 0x97, 0x19, 0x33, 0x8a, 0x77, 0xfe }
,
  /* Salt */
  20,
  { 0x7f, 0x6d, 0xd3, 0x59, 0xe6, 0x04, 0xe6, 0x08, 0x70, 0xe8, 0x98, 0xe4, 0x7b, 0x19, 0xbf, 0x2e, 0x5a, 0x7b, 0x2a, 0x90 }
,
  /* Signature */
  129,
  { 0x01, 0x09, 0x91, 0x65, 0x6c, 0xca, 0x18, 0x2b, 0x7f, 0x29, 0xd2, 0xdb, 0xc0, 0x07, 0xe7, 0xae, 0x0f, 0xec, 0x15, 0x8e, 0xb6, 0x75, 0x9c, 0xb9, 0xc4, 0x5c, 0x5f, 0xf8, 0x7c, 0x76, 0x35, 0xdd, 0x46, 0xd1, 0x50, 0x88, 0x2f, 0x4d, 0xe1, 0xe9, 0xae, 0x65, 0xe7, 0xf7, 0xd9, 0x01, 0x8f, 0x68, 0x36, 0x95, 0x4a, 0x47, 0xc0, 0xa8, 0x1a, 0x8a, 0x6b, 0x6f, 0x83, 0xf2, 0x94, 0x4d, 0x60, 0x81, 0xb1, 0xaa, 0x7c, 0x75, 0x9b, 0x25, 0x4b, 0x2c, 0x34, 0xb6, 0x91, 0xda, 0x67, 0xcc, 0x02, 0x26, 0xe2, 0x0b, 0x2f, 0x18, 0xb4, 0x22, 0x12, 0x76, 0x1d, 0xcd, 0x4b, 0x90, 0x8a, 0x62, 0xb3, 0x71, 0xb5, 0x91, 0x8c, 0x57, 0x42, 0xaf, 0x4b, 0x53, 0x7e, 0x29, 0x69, 0x17, 0x67, 0x4f, 0xb9, 0x14, 0x19, 0x47, 0x61, 0x62, 0x1c, 0xc1, 0x9a, 0x41, 0xf6, 0xfb, 0x95, 0x3f, 0xbc, 0xbb, 0x64, 0x9d, 0xea }

}
,
{
  "RSASSA-PSS Signature Example 2.3",
  /* Message to be signed */
  102,
  { 0x52, 0xa1, 0xd9, 0x6c, 0x8a, 0xc3, 0x9e, 0x41, 0xe4, 0x55, 0x80, 0x98, 0x01, 0xb9, 0x27, 0xa5, 0xb4, 0x45, 0xc1, 0x0d, 0x90, 0x2a, 0x0d, 0xcd, 0x38, 0x50, 0xd2, 0x2a, 0x66, 0xd2, 0xbb, 0x07, 0x03, 0xe6, 0x7d, 0x58, 0x67, 0x11, 0x45, 0x95, 0xaa, 0xbf, 0x5a, 0x7a, 0xeb, 0x5a, 0x8f, 0x87, 0x03, 0x4b, 0xbb, 0x30, 0xe1, 0x3c, 0xfd, 0x48, 0x17, 0xa9, 0xbe, 0x76, 0x23, 0x00, 0x23, 0x60, 0x6d, 0x02, 0x86, 0xa3, 0xfa, 0xf8, 0xa4, 0xd2, 0x2b, 0x72, 0x8e, 0xc5, 0x18, 0x07, 0x9f, 0x9e, 0x64, 0x52, 0x6e, 0x3a, 0x0c, 0xc7, 0x94, 0x1a, 0xa3, 0x38, 0xc4, 0x37, 0x99, 0x7c, 0x68, 0x0c, 0xca, 0xc6, 0x7c, 0x66, 0xbf, 0xa1 }
,
  /* Salt */
  20,
  { 0xfc, 0xa8, 0x62, 0x06, 0x8b, 0xce, 0x22, 0x46, 0x72, 0x4b, 0x70, 0x8a, 0x05, 0x19, 0xda, 0x17, 0xe6, 0x48, 0x68, 0x8c }
,
  /* Signature */
  129,
  { 0x00, 0x7f, 0x00, 0x30, 0x01, 0x8f, 0x53, 0xcd, 0xc7, 0x1f, 0x23, 0xd0, 0x36, 0x59, 0xfd, 0xe5, 0x4d, 0x42, 0x41, 0xf7, 0x58, 0xa7, 0x50, 0xb4, 0x2f, 0x18, 0x5f, 0x87, 0x57, 0x85, 0x20, 0xc3, 0x07, 0x42, 0xaf, 0xd8, 0x43, 0x59, 0xb6, 0xe6, 0xe8, 0xd3, 0xed, 0x95, 0x9d, 0xc6, 0xfe, 0x48, 0x6b, 0xed, 0xc8, 0xe2, 0xcf, 0x00, 0x1f, 0x63, 0xa7, 0xab, 0xe1, 0x62, 0x56, 0xa1, 0xb8, 0x4d, 0xf0, 0xd2, 0x49, 0xfc, 0x05, 0xd3, 0x19, 0x4c, 0xe5, 0xf0, 0x91, 0x27, 0x42, 0xdb, 0xbf, 0x80, 0xdd, 0x17, 0x4f, 0x6c, 0x51, 0xf6, 0xba, 0xd7, 0xf1, 0x6c, 0xf3, 0x36, 0x4e, 0xba, 0x09, 0x5a, 0x06, 0x26, 0x7d, 0xc3, 0x79, 0x38, 0x03, 0xac, 0x75, 0x26, 0xae, 0xbe, 0x0a, 0x47, 0x5d, 0x38, 0xb8, 0xc2, 0x24, 0x7a, 0xb5, 0x1c, 0x48, 0x98, 0xdf, 0x70, 0x47, 0xdc, 0x6a, 0xdf, 0x52, 0xc6, 0xc4 }

}
,
{
  "RSASSA-PSS Signature Example 2.4",
  /* Message to be signed */
  30,
  { 0xa7, 0x18, 0x2c, 0x83, 0xac, 0x18, 0xbe, 0x65, 0x70, 0xa1, 0x06, 0xaa, 0x9d, 0x5c, 0x4e, 0x3d, 0xbb, 0xd4, 0xaf, 0xae, 0xb0, 0xc6, 0x0c, 0x4a, 0x23, 0xe1, 0x96, 0x9d, 0x79, 0xff }
,
  /* Salt */
  20,
  { 0x80, 0x70, 0xef, 0x2d, 0xe9, 0x45, 0xc0, 0x23, 0x87, 0x68, 0x4b, 0xa0, 0xd3, 0x30, 0x96, 0x73, 0x22, 0x35, 0xd4, 0x40 }
,
  /* Signature */
  129,
  { 0x00, 0x9c, 0xd2, 0xf4, 0xed, 0xbe, 0x23, 0xe1, 0x23, 0x46, 0xae, 0x8c, 0x76, 0xdd, 0x9a, 0xd3, 0x23, 0x0a, 0x62, 0x07, 0x61, 0x41, 0xf1, 0x6c, 0x15, 0x2b, 0xa1, 0x85, 0x13, 0xa4, 0x8e, 0xf6, 0xf0, 0x10, 0xe0, 0xe3, 0x7f, 0xd3, 0xdf, 0x10, 0xa1, 0xec, 0x62, 0x9a, 0x0c, 0xb5, 0xa3, 0xb5, 0xd2, 0x89, 0x30, 0x07, 0x29, 0x8c, 0x30, 0x93, 0x6a, 0x95, 0x90, 0x3b, 0x6b, 0xa8, 0x55, 0x55, 0xd9, 0xec, 0x36, 0x73, 0xa0, 0x61, 0x08, 0xfd, 0x62, 0xa2, 0xfd, 0xa5, 0x6d, 0x1c, 0xe2, 0xe8, 0x5c, 0x4d, 0xb6, 0xb2, 0x4a, 0x81, 0xca, 0x3b, 0x49, 0x6c, 0x36, 0xd4, 0xfd, 0x06, 0xeb, 0x7c, 0x91, 0x66, 0xd8, 0xe9, 0x48, 0x77, 0xc4, 0x2b, 0xea, 0x62, 0x2b, 0x3b, 0xfe, 0x92, 0x51, 0xfd, 0xc2, 0x1d, 0x8d, 0x53, 0x71, 0xba, 0xda, 0xd7, 0x8a, 0x48, 0x82, 0x14, 0x79, 0x63, 0x35, 0xb4, 0x0b }

}
,
{
  "RSASSA-PSS Signature Example 2.5",
  /* Message to be signed */
  56,
  { 0x86, 0xa8, 0x3d, 0x4a, 0x72, 0xee, 0x93, 0x2a, 0x4f, 0x56, 0x30, 0xaf, 0x65, 0x79, 0xa3, 0x86, 0xb7, 0x8f, 0xe8, 0x89, 0x99, 0xe0, 0xab, 0xd2, 0xd4, 0x90, 0x34, 0xa4, 0xbf, 0xc8, 0x54, 0xdd, 0x94, 0xf1, 0x09, 0x4e, 0x2e, 0x8c, 0xd7, 0xa1, 0x79, 0xd1, 0x95, 0x88, 0xe4, 0xae, 0xfc, 0x1b, 0x1b, 0xd2, 0x5e, 0x95, 0xe3, 0xdd, 0x46, 0x1f }
,
  /* Salt */
  20,
  { 0x17, 0x63, 0x9a, 0x4e, 0x88, 0xd7, 0x22, 0xc4, 0xfc, 0xa2, 0x4d, 0x07, 0x9a, 0x8b, 0x29, 0xc3, 0x24, 0x33, 0xb0, 0xc9 }
,
  /* Signature */
  129,
  { 0x00, 0xec, 0x43, 0x08, 0x24, 0x93, 0x1e, 0xbd, 0x3b, 0xaa, 0x43, 0x03, 0x4d, 0xae, 0x98, 0xba, 0x64, 0x6b, 0x8c, 0x36, 0x01, 0x3d, 0x16, 0x71, 0xc3, 0xcf, 0x1c, 0xf8, 0x26, 0x0c, 0x37, 0x4b, 0x19, 0xf8, 0xe1, 0xcc, 0x8d, 0x96, 0x50, 0x12, 0x40, 0x5e, 0x7e, 0x9b, 0xf7, 0x37, 0x86, 0x12, 0xdf, 0xcc, 0x85, 0xfc, 0xe1, 0x2c, 0xda, 0x11, 0xf9, 0x50, 0xbd, 0x0b, 0xa8, 0x87, 0x67, 0x40, 0x43, 0x6c, 0x1d, 0x25, 0x95, 0xa6, 0x4a, 0x1b, 0x32, 0xef, 0xcf, 0xb7, 0x4a, 0x21, 0xc8, 0x73, 0xb3, 0xcc, 0x33, 0xaa, 0xf4, 0xe3, 0xdc, 0x39, 0x53, 0xde, 0x67, 0xf0, 0x67, 0x4c, 0x04, 0x53, 0xb4, 0xfd, 0x9f, 0x60, 0x44, 0x06, 0xd4, 0x41, 0xb8, 0x16, 0x09, 0x8c, 0xb1, 0x06, 0xfe, 0x34, 0x72, 0xbc, 0x25, 0x1f, 0x81, 0x5f, 0x59, 0xdb, 0x2e, 0x43, 0x78, 0xa3, 0xad, 0xdc, 0x18, 0x1e, 0xcf }

}
,
{
  "RSASSA-PSS Signature Example 2.6",
  /* Message to be signed */
  26,
  { 0x04, 0x9f, 0x91, 0x54, 0xd8, 0x71, 0xac, 0x4a, 0x7c, 0x7a, 0xb4, 0x53, 0x25, 0xba, 0x75, 0x45, 0xa1, 0xed, 0x08, 0xf7, 0x05, 0x25, 0xb2, 0x66, 0x7c, 0xf1 }
,
  /* Salt */
  20,
  { 0x37, 0x81, 0x0d, 0xef, 0x10, 0x55, 0xed, 0x92, 0x2b, 0x06, 0x3d, 0xf7, 0x98, 0xde, 0x5d, 0x0a, 0xab, 0xf8, 0x86, 0xee }
,
  /* Signature */
  129,
  { 0x00, 0x47, 0x5b, 0x16, 0x48, 0xf8, 0x14, 0xa8, 0xdc, 0x0a, 0xbd, 0xc3, 0x7b, 0x55, 0x27, 0xf5, 0x43, 0xb6, 0x66, 0xbb, 0x6e, 0x39, 0xd3, 0x0e, 0x5b, 0x49, 0xd3, 0xb8, 0x76, 0xdc, 0xcc, 0x58, 0xea, 0xc1, 0x4e, 0x32, 0xa2, 0xd5, 0x5c, 0x26, 0x16, 0x01, 0x44, 0x56, 0xad, 0x2f, 0x24, 0x6f, 0xc8, 0xe3, 0xd5, 0x60, 0xda, 0x3d, 0xdf, 0x37, 0x9a, 0x1c, 0x0b, 0xd2, 0x00, 0xf1, 0x02, 0x21, 0xdf, 0x07, 0x8c, 0x21, 0x9a, 0x15, 0x1b, 0xc8, 0xd4, 0xec, 0x9d, 0x2f, 0xc2, 0x56, 0x44, 0x67, 0x81, 0x10, 0x14, 0xef, 0x15, 0xd8, 0xea, 0x01, 0xc2, 0xeb, 0xbf, 0xf8, 0xc2, 0xc8, 0xef, 0xab, 0x38, 0x09, 0x6e, 0x55, 0xfc, 0xbe, 0x32, 0x85, 0xc7, 0xaa, 0x55, 0x88, 0x51, 0x25, 0x4f, 0xaf, 0xfa, 0x92, 0xc1, 0xc7, 0x2b, 0x78, 0x75, 0x86, 0x63, 0xef, 0x45, 0x82, 0x84, 0x31, 0x39, 0xd7, 0xa6 }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 3: A 1026-bit RSA Key Pair",
{
  /* RSA modulus n */
  129,
  { 0x02, 0xf2, 0x46, 0xef, 0x45, 0x1e, 0xd3, 0xee, 0xbb, 0x9a, 0x31, 0x02, 0x00, 0xcc, 0x25, 0x85, 0x9c, 0x04, 0x8e, 0x4b, 0xe7, 0x98, 0x30, 0x29, 0x91, 0x11, 0x2e, 0xb6, 0x8c, 0xe6, 0xdb, 0x67, 0x4e, 0x28, 0x0d, 0xa2, 0x1f, 0xed, 0xed, 0x1a, 0xe7, 0x48, 0x80, 0xca, 0x52, 0x2b, 0x18, 0xdb, 0x24, 0x93, 0x85, 0x01, 0x28, 0x27, 0xc5, 0x15, 0xf0, 0xe4, 0x66, 0xa1, 0xff, 0xa6, 0x91, 0xd9, 0x81, 0x70, 0x57, 0x4e, 0x9d, 0x0e, 0xad, 0xb0, 0x87, 0x58, 0x6c, 0xa4, 0x89, 0x33, 0xda, 0x3c, 0xc9, 0x53, 0xd9, 0x5b, 0xd0, 0xed, 0x50, 0xde, 0x10, 0xdd, 0xcb, 0x67, 0x36, 0x10, 0x7d, 0x6c, 0x83, 0x1c, 0x7f, 0x66, 0x3e, 0x83, 0x3c, 0xa4, 0xc0, 0x97, 0xe7, 0x00, 0xce, 0x0f, 0xb9, 0x45, 0xf8, 0x8f, 0xb8, 0x5f, 0xe8, 0xe5, 0xa7, 0x73, 0x17, 0x25, 0x65, 0xb9, 0x14, 0xa4, 0x71, 0xa4, 0x43 }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  128,
  { 0x65, 0x14, 0x51, 0x73, 0x3b, 0x56, 0xde, 0x5a, 0xc0, 0xa6, 0x89, 0xa4, 0xae, 0xb6, 0xe6, 0x89, 0x4a, 0x69, 0x01, 0x4e, 0x07, 0x6c, 0x88, 0xdd, 0x7a, 0x66, 0x7e, 0xab, 0x32, 0x32, 0xbb, 0xcc, 0xd2, 0xfc, 0x44, 0xba, 0x2f, 0xa9, 0xc3, 0x1d, 0xb4, 0x6f, 0x21, 0xed, 0xd1, 0xfd, 0xb2, 0x3c, 0x5c, 0x12, 0x8a, 0x5d, 0xa5, 0xba, 0xb9, 0x1e, 0x7f, 0x95, 0x2b, 0x67, 0x75, 0x9c, 0x7c, 0xff, 0x70, 0x54, 0x15, 0xac, 0x9f, 0xa0, 0x90, 0x7c, 0x7c, 0xa6, 0x17, 0x8f, 0x66, 0x8f, 0xb9, 0x48, 0xd8, 0x69, 0xda, 0x4c, 0xc3, 0xb7, 0x35, 0x6f, 0x40, 0x08, 0xdf, 0xd5, 0x44, 0x9d, 0x32, 0xee, 0x02, 0xd9, 0xa4, 0x77, 0xeb, 0x69, 0xfc, 0x29, 0x26, 0x6e, 0x5d, 0x90, 0x70, 0x51, 0x23, 0x75, 0xa5, 0x0f, 0xbb, 0xcc, 0x27, 0xe2, 0x38, 0xad, 0x98, 0x42, 0x5f, 0x6e, 0xbb, 0xf8, 0x89, 0x91 }
,
  /* Prime p */
  65,
  { 0x01, 0xbd, 0x36, 0xe1, 0x8e, 0xce, 0x4b, 0x0f, 0xdb, 0x2e, 0x9c, 0x9d, 0x54, 0x8b, 0xd1, 0xa7, 0xd6, 0xe2, 0xc2, 0x1c, 0x6f, 0xdc, 0x35, 0x07, 0x4a, 0x1d, 0x05, 0xb1, 0xc6, 0xc8, 0xb3, 0xd5, 0x58, 0xea, 0x26, 0x39, 0xc9, 0xa9, 0xa4, 0x21, 0x68, 0x01, 0x69, 0x31, 0x72, 0x52, 0x55, 0x8b, 0xd1, 0x48, 0xad, 0x21, 0x5a, 0xac, 0x55, 0x0e, 0x2d, 0xcf, 0x12, 0xa8, 0x2d, 0x0e, 0xbf, 0xe8, 0x53 }
,
  /* Prime q */
  65,
  { 0x01, 0xb1, 0xb6, 0x56, 0xad, 0x86, 0xd8, 0xe1, 0x9d, 0x5d, 0xc8, 0x62, 0x92, 0xb3, 0xa1, 0x92, 0xfd, 0xf6, 0xe0, 0xdd, 0x37, 0x87, 0x7b, 0xad, 0x14, 0x82, 0x2f, 0xa0, 0x01, 0x90, 0xca, 0xb2, 0x65, 0xf9, 0x0d, 0x3f, 0x02, 0x05, 0x7b, 0x6f, 0x54, 0xd6, 0xec, 0xb1, 0x44, 0x91, 0xe5, 0xad, 0xea, 0xce, 0xbc, 0x48, 0xbf, 0x0e, 0xbd, 0x2a, 0x2a, 0xd2, 0x6d, 0x40, 0x2e, 0x54, 0xf6, 0x16, 0x51 }
,
  /* p's CRT exponent dP */
  64,
  { 0x1f, 0x27, 0x79, 0xfd, 0x2e, 0x3e, 0x5e, 0x6b, 0xae, 0x05, 0x53, 0x95, 0x18, 0xfb, 0xa0, 0xcd, 0x0e, 0xad, 0x1a, 0xa4, 0x51, 0x3a, 0x7c, 0xba, 0x18, 0xf1, 0xcf, 0x10, 0xe3, 0xf6, 0x81, 0x95, 0x69, 0x3d, 0x27, 0x8a, 0x0f, 0x0e, 0xe7, 0x2f, 0x89, 0xf9, 0xbc, 0x76, 0x0d, 0x80, 0xe2, 0xf9, 0xd0, 0x26, 0x1d, 0x51, 0x65, 0x01, 0xc6, 0xae, 0x39, 0xf1, 0x4a, 0x47, 0x6c, 0xe2, 0xcc, 0xf5 }
,
  /* q's CRT exponent dQ */
  65,
  { 0x01, 0x1a, 0x0d, 0x36, 0x79, 0x4b, 0x04, 0xa8, 0x54, 0xaa, 0xb4, 0xb2, 0x46, 0x2d, 0x43, 0x9a, 0x50, 0x46, 0xc9, 0x1d, 0x94, 0x0b, 0x2b, 0xc6, 0xf7, 0x5b, 0x62, 0x95, 0x6f, 0xef, 0x35, 0xa2, 0xa6, 0xe6, 0x3c, 0x53, 0x09, 0x81, 0x7f, 0x30, 0x7b, 0xbf, 0xf9, 0xd5, 0x9e, 0x7e, 0x33, 0x1b, 0xd3, 0x63, 0xf6, 0xd6, 0x68, 0x49, 0xb1, 0x83, 0x46, 0xad, 0xea, 0x16, 0x9f, 0x0a, 0xe9, 0xae, 0xc1 }
,
  /* CRT coefficient qInv */
  64,
  { 0x0b, 0x30, 0xf0, 0xec, 0xf5, 0x58, 0x75, 0x2f, 0xb3, 0xa6, 0xce, 0x4b, 0xa2, 0xb8, 0xc6, 0x75, 0xf6, 0x59, 0xeb, 0xa6, 0xc3, 0x76, 0x58, 0x5a, 0x1b, 0x39, 0x71, 0x2d, 0x03, 0x8a, 0xe3, 0xd2, 0xb4, 0x6f, 0xcb, 0x41, 0x8a, 0xe1, 0x5d, 0x09, 0x05, 0xda, 0x64, 0x40, 0xe1, 0x51, 0x3a, 0x30, 0xb9, 0xb7, 0xd6, 0x66, 0x8f, 0xbc, 0x5e, 0x88, 0xe5, 0xab, 0x7a, 0x17, 0x5e, 0x73, 0xba, 0x35 }

}
,
{{
  "RSASSA-PSS Signature Example 3.1",
  /* Message to be signed */
  30,
  { 0x59, 0x4b, 0x37, 0x33, 0x3b, 0xbb, 0x2c, 0x84, 0x52, 0x4a, 0x87, 0xc1, 0xa0, 0x1f, 0x75, 0xfc, 0xec, 0x0e, 0x32, 0x56, 0xf1, 0x08, 0xe3, 0x8d, 0xca, 0x36, 0xd7, 0x0d, 0x00, 0x57 }
,
  /* Salt */
  20,
  { 0xf3, 0x1a, 0xd6, 0xc8, 0xcf, 0x89, 0xdf, 0x78, 0xed, 0x77, 0xfe, 0xac, 0xbc, 0xc2, 0xf8, 0xb0, 0xa8, 0xe4, 0xcf, 0xaa }
,
  /* Signature */
  129,
  { 0x00, 0x88, 0xb1, 0x35, 0xfb, 0x17, 0x94, 0xb6, 0xb9, 0x6c, 0x4a, 0x3e, 0x67, 0x81, 0x97, 0xf8, 0xca, 0xc5, 0x2b, 0x64, 0xb2, 0xfe, 0x90, 0x7d, 0x6f, 0x27, 0xde, 0x76, 0x11, 0x24, 0x96, 0x4a, 0x99, 0xa0, 0x1a, 0x88, 0x27, 0x40, 0xec, 0xfa, 0xed, 0x6c, 0x01, 0xa4, 0x74, 0x64, 0xbb, 0x05, 0x18, 0x23, 0x13, 0xc0, 0x13, 0x38, 0xa8, 0xcd, 0x09, 0x72, 0x14, 0xcd, 0x68, 0xca, 0x10, 0x3b, 0xd5, 0x7d, 0x3b, 0xc9, 0xe8, 0x16, 0x21, 0x3e, 0x61, 0xd7, 0x84, 0xf1, 0x82, 0x46, 0x7a, 0xbf, 0x8a, 0x01, 0xcf, 0x25, 0x3e, 0x99, 0xa1, 0x56, 0xea, 0xa8, 0xe3, 0xe1, 0xf9, 0x0e, 0x3c, 0x6e, 0x4e, 0x3a, 0xa2, 0xd8, 0x3e, 0xd0, 0x34, 0x5b, 0x89, 0xfa, 0xfc, 0x9c, 0x26, 0x07, 0x7c, 0x14, 0xb6, 0xac, 0x51, 0x45, 0x4f, 0xa2, 0x6e, 0x44, 0x6e, 0x3a, 0x2f, 0x15, 0x3b, 0x2b, 0x16, 0x79, 0x7f }

}
,
#ifdef LTC_TEST_EXT
{
  "RSASSA-PSS Signature Example 3.2",
  /* Message to be signed */
  29,
  { 0x8b, 0x76, 0x95, 0x28, 0x88, 0x4a, 0x0d, 0x1f, 0xfd, 0x09, 0x0c, 0xf1, 0x02, 0x99, 0x3e, 0x79, 0x6d, 0xad, 0xcf, 0xbd, 0xdd, 0x38, 0xe4, 0x4f, 0xf6, 0x32, 0x4c, 0xa4, 0x51 }
,
  /* Salt */
  20,
  { 0xfc, 0xf9, 0xf0, 0xe1, 0xf1, 0x99, 0xa3, 0xd1, 0xd0, 0xda, 0x68, 0x1c, 0x5b, 0x86, 0x06, 0xfc, 0x64, 0x29, 0x39, 0xf7 }
,
  /* Signature */
  129,
  { 0x02, 0xa5, 0xf0, 0xa8, 0x58, 0xa0, 0x86, 0x4a, 0x4f, 0x65, 0x01, 0x7a, 0x7d, 0x69, 0x45, 0x4f, 0x3f, 0x97, 0x3a, 0x29, 0x99, 0x83, 0x9b, 0x7b, 0xbc, 0x48, 0xbf, 0x78, 0x64, 0x11, 0x69, 0x17, 0x95, 0x56, 0xf5, 0x95, 0xfa, 0x41, 0xf6, 0xff, 0x18, 0xe2, 0x86, 0xc2, 0x78, 0x30, 0x79, 0xbc, 0x09, 0x10, 0xee, 0x9c, 0xc3, 0x4f, 0x49, 0xba, 0x68, 0x11, 0x24, 0xf9, 0x23, 0xdf, 0xa8, 0x8f, 0x42, 0x61, 0x41, 0xa3, 0x68, 0xa5, 0xf5, 0xa9, 0x30, 0xc6, 0x28, 0xc2, 0xc3, 0xc2, 0x00, 0xe1, 0x8a, 0x76, 0x44, 0x72, 0x1a, 0x0c, 0xbe, 0xc6, 0xdd, 0x3f, 0x62, 0x79, 0xbd, 0xe3, 0xe8, 0xf2, 0xbe, 0x5e, 0x2d, 0x4e, 0xe5, 0x6f, 0x97, 0xe7, 0xce, 0xaf, 0x33, 0x05, 0x4b, 0xe7, 0x04, 0x2b, 0xd9, 0x1a, 0x63, 0xbb, 0x09, 0xf8, 0x97, 0xbd, 0x41, 0xe8, 0x11, 0x97, 0xde, 0xe9, 0x9b, 0x11, 0xaf }

}
,
{
  "RSASSA-PSS Signature Example 3.3",
  /* Message to be signed */
  167,
  { 0x1a, 0xbd, 0xba, 0x48, 0x9c, 0x5a, 0xda, 0x2f, 0x99, 0x5e, 0xd1, 0x6f, 0x19, 0xd5, 0xa9, 0x4d, 0x9e, 0x6e, 0xc3, 0x4a, 0x8d, 0x84, 0xf8, 0x45, 0x57, 0xd2, 0x6e, 0x5e, 0xf9, 0xb0, 0x2b, 0x22, 0x88, 0x7e, 0x3f, 0x9a, 0x4b, 0x69, 0x0a, 0xd1, 0x14, 0x92, 0x09, 0xc2, 0x0c, 0x61, 0x43, 0x1f, 0x0c, 0x01, 0x7c, 0x36, 0xc2, 0x65, 0x7b, 0x35, 0xd7, 0xb0, 0x7d, 0x3f, 0x5a, 0xd8, 0x70, 0x85, 0x07, 0xa9, 0xc1, 0xb8, 0x31, 0xdf, 0x83, 0x5a, 0x56, 0xf8, 0x31, 0x07, 0x18, 0x14, 0xea, 0x5d, 0x3d, 0x8d, 0x8f, 0x6a, 0xde, 0x40, 0xcb, 0xa3, 0x8b, 0x42, 0xdb, 0x7a, 0x2d, 0x3d, 0x7a, 0x29, 0xc8, 0xf0, 0xa7, 0x9a, 0x78, 0x38, 0xcf, 0x58, 0xa9, 0x75, 0x7f, 0xa2, 0xfe, 0x4c, 0x40, 0xdf, 0x9b, 0xaa, 0x19, 0x3b, 0xfc, 0x6f, 0x92, 0xb1, 0x23, 0xad, 0x57, 0xb0, 0x7a, 0xce, 0x3e, 0x6a, 0xc0, 0x68, 0xc9, 0xf1, 0x06, 0xaf, 0xd9, 0xee, 0xb0, 0x3b, 0x4f, 0x37, 0xc2, 0x5d, 0xbf, 0xbc, 0xfb, 0x30, 0x71, 0xf6, 0xf9, 0x77, 0x17, 0x66, 0xd0, 0x72, 0xf3, 0xbb, 0x07, 0x0a, 0xf6, 0x60, 0x55, 0x32, 0x97, 0x3a, 0xe2, 0x50, 0x51 }
,
  /* Salt */
  20,
  { 0x98, 0x6e, 0x7c, 0x43, 0xdb, 0xb6, 0x71, 0xbd, 0x41, 0xb9, 0xa7, 0xf4, 0xb6, 0xaf, 0xc8, 0x0e, 0x80, 0x5f, 0x24, 0x23 }
,
  /* Signature */
  129,
  { 0x02, 0x44, 0xbc, 0xd1, 0xc8, 0xc1, 0x69, 0x55, 0x73, 0x6c, 0x80, 0x3b, 0xe4, 0x01, 0x27, 0x2e, 0x18, 0xcb, 0x99, 0x08, 0x11, 0xb1, 0x4f, 0x72, 0xdb, 0x96, 0x41, 0x24, 0xd5, 0xfa, 0x76, 0x06, 0x49, 0xcb, 0xb5, 0x7a, 0xfb, 0x87, 0x55, 0xdb, 0xb6, 0x2b, 0xf5, 0x1f, 0x46, 0x6c, 0xf2, 0x3a, 0x0a, 0x16, 0x07, 0x57, 0x6e, 0x98, 0x3d, 0x77, 0x8f, 0xce, 0xff, 0xa9, 0x2d, 0xf7, 0x54, 0x8a, 0xea, 0x8e, 0xa4, 0xec, 0xad, 0x2c, 0x29, 0xdd, 0x9f, 0x95, 0xbc, 0x07, 0xfe, 0x91, 0xec, 0xf8, 0xbe, 0xe2, 0x55, 0xbf, 0xe8, 0x76, 0x2f, 0xd7, 0x69, 0x0a, 0xa9, 0xbf, 0xa4, 0xfa, 0x08, 0x49, 0xef, 0x72, 0x8c, 0x2c, 0x42, 0xc4, 0x53, 0x23, 0x64, 0x52, 0x2d, 0xf2, 0xab, 0x7f, 0x9f, 0x8a, 0x03, 0xb6, 0x3f, 0x7a, 0x49, 0x91, 0x75, 0x82, 0x86, 0x68, 0xf5, 0xef, 0x5a, 0x29, 0xe3, 0x80, 0x2c }

}
,
{
  "RSASSA-PSS Signature Example 3.4",
  /* Message to be signed */
  73,
  { 0x8f, 0xb4, 0x31, 0xf5, 0xee, 0x79, 0x2b, 0x6c, 0x2a, 0xc7, 0xdb, 0x53, 0xcc, 0x42, 0x86, 0x55, 0xae, 0xb3, 0x2d, 0x03, 0xf4, 0xe8, 0x89, 0xc5, 0xc2, 0x5d, 0xe6, 0x83, 0xc4, 0x61, 0xb5, 0x3a, 0xcf, 0x89, 0xf9, 0xf8, 0xd3, 0xaa, 0xbd, 0xf6, 0xb9, 0xf0, 0xc2, 0xa1, 0xde, 0x12, 0xe1, 0x5b, 0x49, 0xed, 0xb3, 0x91, 0x9a, 0x65, 0x2f, 0xe9, 0x49, 0x1c, 0x25, 0xa7, 0xfc, 0xe1, 0xf7, 0x22, 0xc2, 0x54, 0x36, 0x08, 0xb6, 0x9d, 0xc3, 0x75, 0xec }
,
  /* Salt */
  20,
  { 0xf8, 0x31, 0x2d, 0x9c, 0x8e, 0xea, 0x13, 0xec, 0x0a, 0x4c, 0x7b, 0x98, 0x12, 0x0c, 0x87, 0x50, 0x90, 0x87, 0xc4, 0x78 }
,
  /* Signature */
  129,
  { 0x01, 0x96, 0xf1, 0x2a, 0x00, 0x5b, 0x98, 0x12, 0x9c, 0x8d, 0xf1, 0x3c, 0x4c, 0xb1, 0x6f, 0x8a, 0xa8, 0x87, 0xd3, 0xc4, 0x0d, 0x96, 0xdf, 0x3a, 0x88, 0xe7, 0x53, 0x2e, 0xf3, 0x9c, 0xd9, 0x92, 0xf2, 0x73, 0xab, 0xc3, 0x70, 0xbc, 0x1b, 0xe6, 0xf0, 0x97, 0xcf, 0xeb, 0xbf, 0x01, 0x18, 0xfd, 0x9e, 0xf4, 0xb9, 0x27, 0x15, 0x5f, 0x3d, 0xf2, 0x2b, 0x90, 0x4d, 0x90, 0x70, 0x2d, 0x1f, 0x7b, 0xa7, 0xa5, 0x2b, 0xed, 0x8b, 0x89, 0x42, 0xf4, 0x12, 0xcd, 0x7b, 0xd6, 0x76, 0xc9, 0xd1, 0x8e, 0x17, 0x03, 0x91, 0xdc, 0xd3, 0x45, 0xc0, 0x6a, 0x73, 0x09, 0x64, 0xb3, 0xf3, 0x0b, 0xcc, 0xe0, 0xbb, 0x20, 0xba, 0x10, 0x6f, 0x9a, 0xb0, 0xee, 0xb3, 0x9c, 0xf8, 0xa6, 0x60, 0x7f, 0x75, 0xc0, 0x34, 0x7f, 0x0a, 0xf7, 0x9f, 0x16, 0xaf, 0xa0, 0x81, 0xd2, 0xc9, 0x2d, 0x1e, 0xe6, 0xf8, 0x36, 0xb8 }

}
,
{
  "RSASSA-PSS Signature Example 3.5",
  /* Message to be signed */
  115,
  { 0xfe, 0xf4, 0x16, 0x1d, 0xfa, 0xaf, 0x9c, 0x52, 0x95, 0x05, 0x1d, 0xfc, 0x1f, 0xf3, 0x81, 0x0c, 0x8c, 0x9e, 0xc2, 0xe8, 0x66, 0xf7, 0x07, 0x54, 0x22, 0xc8, 0xec, 0x42, 0x16, 0xa9, 0xc4, 0xff, 0x49, 0x42, 0x7d, 0x48, 0x3c, 0xae, 0x10, 0xc8, 0x53, 0x4a, 0x41, 0xb2, 0xfd, 0x15, 0xfe, 0xe0, 0x69, 0x60, 0xec, 0x6f, 0xb3, 0xf7, 0xa7, 0xe9, 0x4a, 0x2f, 0x8a, 0x2e, 0x3e, 0x43, 0xdc, 0x4a, 0x40, 0x57, 0x6c, 0x30, 0x97, 0xac, 0x95, 0x3b, 0x1d, 0xe8, 0x6f, 0x0b, 0x4e, 0xd3, 0x6d, 0x64, 0x4f, 0x23, 0xae, 0x14, 0x42, 0x55, 0x29, 0x62, 0x24, 0x64, 0xca, 0x0c, 0xbf, 0x0b, 0x17, 0x41, 0x34, 0x72, 0x38, 0x15, 0x7f, 0xab, 0x59, 0xe4, 0xde, 0x55, 0x24, 0x09, 0x6d, 0x62, 0xba, 0xec, 0x63, 0xac, 0x64 }
,
  /* Salt */
  20,
  { 0x50, 0x32, 0x7e, 0xfe, 0xc6, 0x29, 0x2f, 0x98, 0x01, 0x9f, 0xc6, 0x7a, 0x2a, 0x66, 0x38, 0x56, 0x3e, 0x9b, 0x6e, 0x2d }
,
  /* Signature */
  129,
  { 0x02, 0x1e, 0xca, 0x3a, 0xb4, 0x89, 0x22, 0x64, 0xec, 0x22, 0x41, 0x1a, 0x75, 0x2d, 0x92, 0x22, 0x10, 0x76, 0xd4, 0xe0, 0x1c, 0x0e, 0x6f, 0x0d, 0xde, 0x9a, 0xfd, 0x26, 0xba, 0x5a, 0xcf, 0x6d, 0x73, 0x9e, 0xf9, 0x87, 0x54, 0x5d, 0x16, 0x68, 0x3e, 0x56, 0x74, 0xc9, 0xe7, 0x0f, 0x1d, 0xe6, 0x49, 0xd7, 0xe6, 0x1d, 0x48, 0xd0, 0xca, 0xeb, 0x4f, 0xb4, 0xd8, 0xb2, 0x4f, 0xba, 0x84, 0xa6, 0xe3, 0x10, 0x8f, 0xee, 0x7d, 0x07, 0x05, 0x97, 0x32, 0x66, 0xac, 0x52, 0x4b, 0x4a, 0xd2, 0x80, 0xf7, 0xae, 0x17, 0xdc, 0x59, 0xd9, 0x6d, 0x33, 0x51, 0x58, 0x6b, 0x5a, 0x3b, 0xdb, 0x89, 0x5d, 0x1e, 0x1f, 0x78, 0x20, 0xac, 0x61, 0x35, 0xd8, 0x75, 0x34, 0x80, 0x99, 0x83, 0x82, 0xba, 0x32, 0xb7, 0x34, 0x95, 0x59, 0x60, 0x8c, 0x38, 0x74, 0x52, 0x90, 0xa8, 0x5e, 0xf4, 0xe9, 0xf9, 0xbd, 0x83 }

}
,
{
  "RSASSA-PSS Signature Example 3.6",
  /* Message to be signed */
  22,
  { 0xef, 0xd2, 0x37, 0xbb, 0x09, 0x8a, 0x44, 0x3a, 0xee, 0xb2, 0xbf, 0x6c, 0x3f, 0x8c, 0x81, 0xb8, 0xc0, 0x1b, 0x7f, 0xcb, 0x3f, 0xeb }
,
  /* Salt */
  20,
  { 0xb0, 0xde, 0x3f, 0xc2, 0x5b, 0x65, 0xf5, 0xaf, 0x96, 0xb1, 0xd5, 0xcc, 0x3b, 0x27, 0xd0, 0xc6, 0x05, 0x30, 0x87, 0xb3 }
,
  /* Signature */
  129,
  { 0x01, 0x2f, 0xaf, 0xec, 0x86, 0x2f, 0x56, 0xe9, 0xe9, 0x2f, 0x60, 0xab, 0x0c, 0x77, 0x82, 0x4f, 0x42, 0x99, 0xa0, 0xca, 0x73, 0x4e, 0xd2, 0x6e, 0x06, 0x44, 0xd5, 0xd2, 0x22, 0xc7, 0xf0, 0xbd, 0xe0, 0x39, 0x64, 0xf8, 0xe7, 0x0a, 0x5c, 0xb6, 0x5e, 0xd4, 0x4e, 0x44, 0xd5, 0x6a, 0xe0, 0xed, 0xf1, 0xff, 0x86, 0xca, 0x03, 0x2c, 0xc5, 0xdd, 0x44, 0x04, 0xdb, 0xb7, 0x6a, 0xb8, 0x54, 0x58, 0x6c, 0x44, 0xee, 0xd8, 0x33, 0x6d, 0x08, 0xd4, 0x57, 0xce, 0x6c, 0x03, 0x69, 0x3b, 0x45, 0xc0, 0xf1, 0xef, 0xef, 0x93, 0x62, 0x4b, 0x95, 0xb8, 0xec, 0x16, 0x9c, 0x61, 0x6d, 0x20, 0xe5, 0x53, 0x8e, 0xbc, 0x0b, 0x67, 0x37, 0xa6, 0xf8, 0x2b, 0x4b, 0xc0, 0x57, 0x09, 0x24, 0xfc, 0x6b, 0x35, 0x75, 0x9a, 0x33, 0x48, 0x42, 0x62, 0x79, 0xf8, 0xb3, 0xd7, 0x74, 0x4e, 0x2d, 0x22, 0x24, 0x26, 0xce }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 4: A 1027-bit RSA Key Pair",
{
  /* RSA modulus n */
  129,
  { 0x05, 0x4a, 0xdb, 0x78, 0x86, 0x44, 0x7e, 0xfe, 0x6f, 0x57, 0xe0, 0x36, 0x8f, 0x06, 0xcf, 0x52, 0xb0, 0xa3, 0x37, 0x07, 0x60, 0xd1, 0x61, 0xce, 0xf1, 0x26, 0xb9, 0x1b, 0xe7, 0xf8, 0x9c, 0x42, 0x1b, 0x62, 0xa6, 0xec, 0x1d, 0xa3, 0xc3, 0x11, 0xd7, 0x5e, 0xd5, 0x0e, 0x0a, 0xb5, 0xff, 0xf3, 0xfd, 0x33, 0x8a, 0xcc, 0x3a, 0xa8, 0xa4, 0xe7, 0x7e, 0xe2, 0x63, 0x69, 0xac, 0xb8, 0x1b, 0xa9, 0x00, 0xfa, 0x83, 0xf5, 0x30, 0x0c, 0xf9, 0xbb, 0x6c, 0x53, 0xad, 0x1d, 0xc8, 0xa1, 0x78, 0xb8, 0x15, 0xdb, 0x42, 0x35, 0xa9, 0xa9, 0xda, 0x0c, 0x06, 0xde, 0x4e, 0x61, 0x5e, 0xa1, 0x27, 0x7c, 0xe5, 0x59, 0xe9, 0xc1, 0x08, 0xde, 0x58, 0xc1, 0x4a, 0x81, 0xaa, 0x77, 0xf5, 0xa6, 0xf8, 0xd1, 0x33, 0x54, 0x94, 0x49, 0x88, 0x48, 0xc8, 0xb9, 0x59, 0x40, 0x74, 0x0b, 0xe7, 0xbf, 0x7c, 0x37, 0x05 }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  128,
  { 0xfa, 0x04, 0x1f, 0x8c, 0xd9, 0x69, 0x7c, 0xee, 0xd3, 0x8e, 0xc8, 0xca, 0xa2, 0x75, 0x52, 0x3b, 0x4d, 0xd7, 0x2b, 0x09, 0xa3, 0x01, 0xd3, 0x54, 0x1d, 0x72, 0xf5, 0xd3, 0x1c, 0x05, 0xcb, 0xce, 0x2d, 0x69, 0x83, 0xb3, 0x61, 0x83, 0xaf, 0x10, 0x69, 0x0b, 0xd4, 0x6c, 0x46, 0x13, 0x1e, 0x35, 0x78, 0x94, 0x31, 0xa5, 0x56, 0x77, 0x1d, 0xd0, 0x04, 0x9b, 0x57, 0x46, 0x1b, 0xf0, 0x60, 0xc1, 0xf6, 0x84, 0x72, 0xe8, 0xa6, 0x7c, 0x25, 0xf3, 0x57, 0xe5, 0xb6, 0xb4, 0x73, 0x8f, 0xa5, 0x41, 0xa7, 0x30, 0x34, 0x6b, 0x4a, 0x07, 0x64, 0x9a, 0x2d, 0xfa, 0x80, 0x6a, 0x69, 0xc9, 0x75, 0xb6, 0xab, 0xa6, 0x46, 0x78, 0xac, 0xc7, 0xf5, 0x91, 0x3e, 0x89, 0xc6, 0x22, 0xf2, 0xd8, 0xab, 0xb1, 0xe3, 0xe3, 0x25, 0x54, 0xe3, 0x9d, 0xf9, 0x4b, 0xa6, 0x0c, 0x00, 0x2e, 0x38, 0x7d, 0x90, 0x11 }
,
  /* Prime p */
  65,
  { 0x02, 0x92, 0x32, 0x33, 0x6d, 0x28, 0x38, 0x94, 0x5d, 0xba, 0x9d, 0xd7, 0x72, 0x3f, 0x4e, 0x62, 0x4a, 0x05, 0xf7, 0x37, 0x5b, 0x92, 0x7a, 0x87, 0xab, 0xe6, 0xa8, 0x93, 0xa1, 0x65, 0x8f, 0xd4, 0x9f, 0x47, 0xf6, 0xc7, 0xb0, 0xfa, 0x59, 0x6c, 0x65, 0xfa, 0x68, 0xa2, 0x3f, 0x0a, 0xb4, 0x32, 0x96, 0x2d, 0x18, 0xd4, 0x34, 0x3b, 0xd6, 0xfd, 0x67, 0x1a, 0x5e, 0xa8, 0xd1, 0x48, 0x41, 0x39, 0x95 }
,
  /* Prime q */
  65,
  { 0x02, 0x0e, 0xf5, 0xef, 0xe7, 0xc5, 0x39, 0x4a, 0xed, 0x22, 0x72, 0xf7, 0xe8, 0x1a, 0x74, 0xf4, 0xc0, 0x2d, 0x14, 0x58, 0x94, 0xcb, 0x1b, 0x3c, 0xab, 0x23, 0xa9, 0xa0, 0x71, 0x0a, 0x2a, 0xfc, 0x7e, 0x33, 0x29, 0xac, 0xbb, 0x74, 0x3d, 0x01, 0xf6, 0x80, 0xc4, 0xd0, 0x2a, 0xfb, 0x4c, 0x8f, 0xde, 0x7e, 0x20, 0x93, 0x08, 0x11, 0xbb, 0x2b, 0x99, 0x57, 0x88, 0xb5, 0xe8, 0x72, 0xc2, 0x0b, 0xb1 }
,
  /* p's CRT exponent dP */
  65,
  { 0x02, 0x6e, 0x7e, 0x28, 0x01, 0x0e, 0xcf, 0x24, 0x12, 0xd9, 0x52, 0x3a, 0xd7, 0x04, 0x64, 0x7f, 0xb4, 0xfe, 0x9b, 0x66, 0xb1, 0xa6, 0x81, 0x58, 0x1b, 0x0e, 0x15, 0x55, 0x3a, 0x89, 0xb1, 0x54, 0x28, 0x28, 0x89, 0x8f, 0x27, 0x24, 0x3e, 0xba, 0xb4, 0x5f, 0xf5, 0xe1, 0xac, 0xb9, 0xd4, 0xdf, 0x1b, 0x05, 0x1f, 0xbc, 0x62, 0x82, 0x4d, 0xbc, 0x6f, 0x6c, 0x93, 0x26, 0x1a, 0x78, 0xb9, 0xa7, 0x59 }
,
  /* q's CRT exponent dQ */
  65,
  { 0x01, 0x2d, 0xdc, 0xc8, 0x6e, 0xf6, 0x55, 0x99, 0x8c, 0x39, 0xdd, 0xae, 0x11, 0x71, 0x86, 0x69, 0xe5, 0xe4, 0x6c, 0xf1, 0x49, 0x5b, 0x07, 0xe1, 0x3b, 0x10, 0x14, 0xcd, 0x69, 0xb3, 0xaf, 0x68, 0x30, 0x4a, 0xd2, 0xa6, 0xb6, 0x43, 0x21, 0xe7, 0x8b, 0xf3, 0xbb, 0xca, 0x9b, 0xb4, 0x94, 0xe9, 0x1d, 0x45, 0x17, 0x17, 0xe2, 0xd9, 0x75, 0x64, 0xc6, 0x54, 0x94, 0x65, 0xd0, 0x20, 0x5c, 0xf4, 0x21 }
,
  /* CRT coefficient qInv */
  65,
  { 0x01, 0x06, 0x00, 0xc4, 0xc2, 0x18, 0x47, 0x45, 0x9f, 0xe5, 0x76, 0x70, 0x3e, 0x2e, 0xbe, 0xca, 0xe8, 0xa5, 0x09, 0x4e, 0xe6, 0x3f, 0x53, 0x6b, 0xf4, 0xac, 0x68, 0xd3, 0xc1, 0x3e, 0x5e, 0x4f, 0x12, 0xac, 0x5c, 0xc1, 0x0a, 0xb6, 0xa2, 0xd0, 0x5a, 0x19, 0x92, 0x14, 0xd1, 0x82, 0x47, 0x47, 0xd5, 0x51, 0x90, 0x96, 0x36, 0xb7, 0x74, 0xc2, 0x2c, 0xac, 0x0b, 0x83, 0x75, 0x99, 0xab, 0xcc, 0x75 }

}
,
{{
  "RSASSA-PSS Signature Example 4.1",
  /* Message to be signed */
  8,
  { 0x9f, 0xb0, 0x3b, 0x82, 0x7c, 0x82, 0x17, 0xd9 }
,
  /* Salt */
  20,
  { 0xed, 0x7c, 0x98, 0xc9, 0x5f, 0x30, 0x97, 0x4f, 0xbe, 0x4f, 0xbd, 0xdc, 0xf0, 0xf2, 0x8d, 0x60, 0x21, 0xc0, 0xe9, 0x1d }
,
  /* Signature */
  129,
  { 0x03, 0x23, 0xd5, 0xb7, 0xbf, 0x20, 0xba, 0x45, 0x39, 0x28, 0x9a, 0xe4, 0x52, 0xae, 0x42, 0x97, 0x08, 0x0f, 0xef, 0xf4, 0x51, 0x84, 0x23, 0xff, 0x48, 0x11, 0xa8, 0x17, 0x83, 0x7e, 0x7d, 0x82, 0xf1, 0x83, 0x6c, 0xdf, 0xab, 0x54, 0x51, 0x4f, 0xf0, 0x88, 0x7b, 0xdd, 0xee, 0xbf, 0x40, 0xbf, 0x99, 0xb0, 0x47, 0xab, 0xc3, 0xec, 0xfa, 0x6a, 0x37, 0xa3, 0xef, 0x00, 0xf4, 0xa0, 0xc4, 0xa8, 0x8a, 0xae, 0x09, 0x04, 0xb7, 0x45, 0xc8, 0x46, 0xc4, 0x10, 0x7e, 0x87, 0x97, 0x72, 0x3e, 0x8a, 0xc8, 0x10, 0xd9, 0xe3, 0xd9, 0x5d, 0xfa, 0x30, 0xff, 0x49, 0x66, 0xf4, 0xd7, 0x5d, 0x13, 0x76, 0x8d, 0x20, 0x85, 0x7f, 0x2b, 0x14, 0x06, 0xf2, 0x64, 0xcf, 0xe7, 0x5e, 0x27, 0xd7, 0x65, 0x2f, 0x4b, 0x5e, 0xd3, 0x57, 0x5f, 0x28, 0xa7, 0x02, 0xf8, 0xc4, 0xed, 0x9c, 0xf9, 0xb2, 0xd4, 0x49, 0x48 }

}
,
#ifdef LTC_TEST_EXT
{
  "RSASSA-PSS Signature Example 4.2",
  /* Message to be signed */
  167,
  { 0x0c, 0xa2, 0xad, 0x77, 0x79, 0x7e, 0xce, 0x86, 0xde, 0x5b, 0xf7, 0x68, 0x75, 0x0d, 0xdb, 0x5e, 0xd6, 0xa3, 0x11, 0x6a, 0xd9, 0x9b, 0xbd, 0x17, 0xed, 0xf7, 0xf7, 0x82, 0xf0, 0xdb, 0x1c, 0xd0, 0x5b, 0x0f, 0x67, 0x74, 0x68, 0xc5, 0xea, 0x42, 0x0d, 0xc1, 0x16, 0xb1, 0x0e, 0x80, 0xd1, 0x10, 0xde, 0x2b, 0x04, 0x61, 0xea, 0x14, 0xa3, 0x8b, 0xe6, 0x86, 0x20, 0x39, 0x2e, 0x7e, 0x89, 0x3c, 0xb4, 0xea, 0x93, 0x93, 0xfb, 0x88, 0x6c, 0x20, 0xff, 0x79, 0x06, 0x42, 0x30, 0x5b, 0xf3, 0x02, 0x00, 0x38, 0x92, 0xe5, 0x4d, 0xf9, 0xf6, 0x67, 0x50, 0x9d, 0xc5, 0x39, 0x20, 0xdf, 0x58, 0x3f, 0x50, 0xa3, 0xdd, 0x61, 0xab, 0xb6, 0xfa, 0xb7, 0x5d, 0x60, 0x03, 0x77, 0xe3, 0x83, 0xe6, 0xac, 0xa6, 0x71, 0x0e, 0xee, 0xa2, 0x71, 0x56, 0xe0, 0x67, 0x52, 0xc9, 0x4c, 0xe2, 0x5a, 0xe9, 0x9f, 0xcb, 0xf8, 0x59, 0x2d, 0xbe, 0x2d, 0x7e, 0x27, 0x45, 0x3c, 0xb4, 0x4d, 0xe0, 0x71, 0x00, 0xeb, 0xb1, 0xa2, 0xa1, 0x98, 0x11, 0xa4, 0x78, 0xad, 0xbe, 0xab, 0x27, 0x0f, 0x94, 0xe8, 0xfe, 0x36, 0x9d, 0x90, 0xb3, 0xca, 0x61, 0x2f, 0x9f }
,
  /* Salt */
  20,
  { 0x22, 0xd7, 0x1d, 0x54, 0x36, 0x3a, 0x42, 0x17, 0xaa, 0x55, 0x11, 0x3f, 0x05, 0x9b, 0x33, 0x84, 0xe3, 0xe5, 0x7e, 0x44 }
,
  /* Signature */
  129,
  { 0x04, 0x9d, 0x01, 0x85, 0x84, 0x5a, 0x26, 0x4d, 0x28, 0xfe, 0xb1, 0xe6, 0x9e, 0xda, 0xec, 0x09, 0x06, 0x09, 0xe8, 0xe4, 0x6d, 0x93, 0xab, 0xb3, 0x83, 0x71, 0xce, 0x51, 0xf4, 0xaa, 0x65, 0xa5, 0x99, 0xbd, 0xaa, 0xa8, 0x1d, 0x24, 0xfb, 0xa6, 0x6a, 0x08, 0xa1, 0x16, 0xcb, 0x64, 0x4f, 0x3f, 0x1e, 0x65, 0x3d, 0x95, 0xc8, 0x9d, 0xb8, 0xbb, 0xd5, 0xda, 0xac, 0x27, 0x09, 0xc8, 0x98, 0x40, 0x00, 0x17, 0x84, 0x10, 0xa7, 0xc6, 0xaa, 0x86, 0x67, 0xdd, 0xc3, 0x8c, 0x74, 0x1f, 0x71, 0x0e, 0xc8, 0x66, 0x5a, 0xa9, 0x05, 0x2b, 0xe9, 0x29, 0xd4, 0xe3, 0xb1, 0x67, 0x82, 0xc1, 0x66, 0x21, 0x14, 0xc5, 0x41, 0x4b, 0xb0, 0x35, 0x34, 0x55, 0xc3, 0x92, 0xfc, 0x28, 0xf3, 0xdb, 0x59, 0x05, 0x4b, 0x5f, 0x36, 0x5c, 0x49, 0xe1, 0xd1, 0x56, 0xf8, 0x76, 0xee, 0x10, 0xcb, 0x4f, 0xd7, 0x05, 0x98 }

}
,
{
  "RSASSA-PSS Signature Example 4.3",
  /* Message to be signed */
  83,
  { 0x28, 0x80, 0x62, 0xaf, 0xc0, 0x8f, 0xcd, 0xb7, 0xc5, 0xf8, 0x65, 0x0b, 0x29, 0x83, 0x73, 0x00, 0x46, 0x1d, 0xd5, 0x67, 0x6c, 0x17, 0xa2, 0x0a, 0x3c, 0x8f, 0xb5, 0x14, 0x89, 0x49, 0xe3, 0xf7, 0x3d, 0x66, 0xb3, 0xae, 0x82, 0xc7, 0x24, 0x0e, 0x27, 0xc5, 0xb3, 0xec, 0x43, 0x28, 0xee, 0x7d, 0x6d, 0xdf, 0x6a, 0x6a, 0x0c, 0x9b, 0x5b, 0x15, 0xbc, 0xda, 0x19, 0x6a, 0x9d, 0x0c, 0x76, 0xb1, 0x19, 0xd5, 0x34, 0xd8, 0x5a, 0xbd, 0x12, 0x39, 0x62, 0xd5, 0x83, 0xb7, 0x6c, 0xe9, 0xd1, 0x80, 0xbc, 0xe1, 0xca }
,
  /* Salt */
  20,
  { 0x4a, 0xf8, 0x70, 0xfb, 0xc6, 0x51, 0x60, 0x12, 0xca, 0x91, 0x6c, 0x70, 0xba, 0x86, 0x2a, 0xc7, 0xe8, 0x24, 0x36, 0x17 }
,
  /* Signature */
  129,
  { 0x03, 0xfb, 0xc4, 0x10, 0xa2, 0xce, 0xd5, 0x95, 0x00, 0xfb, 0x99, 0xf9, 0xe2, 0xaf, 0x27, 0x81, 0xad, 0xa7, 0x4e, 0x13, 0x14, 0x56, 0x24, 0x60, 0x27, 0x82, 0xe2, 0x99, 0x48, 0x13, 0xee, 0xfc, 0xa0, 0x51, 0x9e, 0xcd, 0x25, 0x3b, 0x85, 0x5f, 0xb6, 0x26, 0xa9, 0x0d, 0x77, 0x1e, 0xae, 0x02, 0x8b, 0x0c, 0x47, 0xa1, 0x99, 0xcb, 0xd9, 0xf8, 0xe3, 0x26, 0x97, 0x34, 0xaf, 0x41, 0x63, 0x59, 0x90, 0x90, 0x71, 0x3a, 0x3f, 0xa9, 0x10, 0xfa, 0x09, 0x60, 0x65, 0x27, 0x21, 0x43, 0x2b, 0x97, 0x10, 0x36, 0xa7, 0x18, 0x1a, 0x2b, 0xc0, 0xca, 0xb4, 0x3b, 0x0b, 0x59, 0x8b, 0xc6, 0x21, 0x74, 0x61, 0xd7, 0xdb, 0x30, 0x5f, 0xf7, 0xe9, 0x54, 0xc5, 0xb5, 0xbb, 0x23, 0x1c, 0x39, 0xe7, 0x91, 0xaf, 0x6b, 0xcf, 0xa7, 0x6b, 0x14, 0x7b, 0x08, 0x13, 0x21, 0xf7, 0x26, 0x41, 0x48, 0x2a, 0x2a, 0xad }

}
,
{
  "RSASSA-PSS Signature Example 4.4",
  /* Message to be signed */
  49,
  { 0x6f, 0x4f, 0x9a, 0xb9, 0x50, 0x11, 0x99, 0xce, 0xf5, 0x5c, 0x6c, 0xf4, 0x08, 0xfe, 0x7b, 0x36, 0xc5, 0x57, 0xc4, 0x9d, 0x42, 0x0a, 0x47, 0x63, 0xd2, 0x46, 0x3c, 0x8a, 0xd4, 0x4b, 0x3c, 0xfc, 0x5b, 0xe2, 0x74, 0x2c, 0x0e, 0x7d, 0x9b, 0x0f, 0x66, 0x08, 0xf0, 0x8c, 0x7f, 0x47, 0xb6, 0x93, 0xee }
,
  /* Salt */
  20,
  { 0x40, 0xd2, 0xe1, 0x80, 0xfa, 0xe1, 0xea, 0xc4, 0x39, 0xc1, 0x90, 0xb5, 0x6c, 0x2c, 0x0e, 0x14, 0xdd, 0xf9, 0xa2, 0x26 }
,
  /* Signature */
  129,
  { 0x04, 0x86, 0x64, 0x4b, 0xc6, 0x6b, 0xf7, 0x5d, 0x28, 0x33, 0x5a, 0x61, 0x79, 0xb1, 0x08, 0x51, 0xf4, 0x3f, 0x09, 0xbd, 0xed, 0x9f, 0xac, 0x1a, 0xf3, 0x32, 0x52, 0xbb, 0x99, 0x53, 0xba, 0x42, 0x98, 0xcd, 0x64, 0x66, 0xb2, 0x75, 0x39, 0xa7, 0x0a, 0xda, 0xa3, 0xf8, 0x9b, 0x3d, 0xb3, 0xc7, 0x4a, 0xb6, 0x35, 0xd1, 0x22, 0xf4, 0xee, 0x7c, 0xe5, 0x57, 0xa6, 0x1e, 0x59, 0xb8, 0x2f, 0xfb, 0x78, 0x66, 0x30, 0xe5, 0xf9, 0xdb, 0x53, 0xc7, 0x7d, 0x9a, 0x0c, 0x12, 0xfa, 0xb5, 0x95, 0x8d, 0x4c, 0x2c, 0xe7, 0xda, 0xa8, 0x07, 0xcd, 0x89, 0xba, 0x2c, 0xc7, 0xfc, 0xd0, 0x2f, 0xf4, 0x70, 0xca, 0x67, 0xb2, 0x29, 0xfc, 0xce, 0x81, 0x4c, 0x85, 0x2c, 0x73, 0xcc, 0x93, 0xbe, 0xa3, 0x5b, 0xe6, 0x84, 0x59, 0xce, 0x47, 0x8e, 0x9d, 0x46, 0x55, 0xd1, 0x21, 0xc8, 0x47, 0x2f, 0x37, 0x1d, 0x4f }

}
,
{
  "RSASSA-PSS Signature Example 4.5",
  /* Message to be signed */
  187,
  { 0xe1, 0x7d, 0x20, 0x38, 0x5d, 0x50, 0x19, 0x55, 0x82, 0x3c, 0x3f, 0x66, 0x62, 0x54, 0xc1, 0xd3, 0xdd, 0x36, 0xad, 0x51, 0x68, 0xb8, 0xf1, 0x8d, 0x28, 0x6f, 0xdc, 0xf6, 0x7a, 0x7d, 0xad, 0x94, 0x09, 0x70, 0x85, 0xfa, 0xb7, 0xed, 0x86, 0xfe, 0x21, 0x42, 0xa2, 0x87, 0x71, 0x71, 0x79, 0x97, 0xef, 0x1a, 0x7a, 0x08, 0x88, 0x4e, 0xfc, 0x39, 0x35, 0x6d, 0x76, 0x07, 0x7a, 0xaf, 0x82, 0x45, 0x9a, 0x7f, 0xad, 0x45, 0x84, 0x88, 0x75, 0xf2, 0x81, 0x9b, 0x09, 0x89, 0x37, 0xfe, 0x92, 0x3b, 0xcc, 0x9d, 0xc4, 0x42, 0xd7, 0x2d, 0x75, 0x4d, 0x81, 0x20, 0x25, 0x09, 0x0c, 0x9b, 0xc0, 0x3d, 0xb3, 0x08, 0x0c, 0x13, 0x8d, 0xd6, 0x3b, 0x35, 0x5d, 0x0b, 0x4b, 0x85, 0xd6, 0x68, 0x8a, 0xc1, 0x9f, 0x4d, 0xe1, 0x50, 0x84, 0xa0, 0xba, 0x4e, 0x37, 0x3b, 0x93, 0xef, 0x4a, 0x55, 0x50, 0x96, 0x69, 0x19, 0x15, 0xdc, 0x23, 0xc0, 0x0e, 0x95, 0x4c, 0xde, 0xb2, 0x0a, 0x47, 0xcd, 0x55, 0xd1, 0x6c, 0x3d, 0x86, 0x81, 0xd4, 0x6e, 0xd7, 0xf2, 0xed, 0x5e, 0xa4, 0x27, 0x95, 0xbe, 0x17, 0xba, 0xed, 0x25, 0xf0, 0xf4, 0xd1, 0x13, 0xb3, 0x63, 0x6a, 0xdd, 0xd5, 0x85, 0xf1, 0x6a, 0x8b, 0x5a, 0xec, 0x0c, 0x8f, 0xa9, 0xc5, 0xf0, 0x3c, 0xbf, 0x3b, 0x9b, 0x73 }
,
  /* Salt */
  20,
  { 0x24, 0x97, 0xdc, 0x2b, 0x46, 0x15, 0xdf, 0xae, 0x5a, 0x66, 0x3d, 0x49, 0xff, 0xd5, 0x6b, 0xf7, 0xef, 0xc1, 0x13, 0x04 }
,
  /* Signature */
  129,
  { 0x02, 0x2a, 0x80, 0x04, 0x53, 0x53, 0x90, 0x4c, 0xb3, 0x0c, 0xbb, 0x54, 0x2d, 0x7d, 0x49, 0x90, 0x42, 0x1a, 0x6e, 0xec, 0x16, 0xa8, 0x02, 0x9a, 0x84, 0x22, 0xad, 0xfd, 0x22, 0xd6, 0xaf, 0xf8, 0xc4, 0xcc, 0x02, 0x94, 0xaf, 0x11, 0x0a, 0x0c, 0x06, 0x7e, 0xc8, 0x6a, 0x7d, 0x36, 0x41, 0x34, 0x45, 0x9b, 0xb1, 0xae, 0x8f, 0xf8, 0x36, 0xd5, 0xa8, 0xa2, 0x57, 0x98, 0x40, 0x99, 0x6b, 0x32, 0x0b, 0x19, 0xf1, 0x3a, 0x13, 0xfa, 0xd3, 0x78, 0xd9, 0x31, 0xa6, 0x56, 0x25, 0xda, 0xe2, 0x73, 0x9f, 0x0c, 0x53, 0x67, 0x0b, 0x35, 0xd9, 0xd3, 0xcb, 0xac, 0x08, 0xe7, 0x33, 0xe4, 0xec, 0x2b, 0x83, 0xaf, 0x4b, 0x91, 0x96, 0xd6, 0x3e, 0x7c, 0x4f, 0xf1, 0xdd, 0xea, 0xe2, 0xa1, 0x22, 0x79, 0x1a, 0x12, 0x5b, 0xfe, 0xa8, 0xde, 0xb0, 0xde, 0x8c, 0xcf, 0x1f, 0x4f, 0xfa, 0xf6, 0xe6, 0xfb, 0x0a }

}
,
{
  "RSASSA-PSS Signature Example 4.6",
  /* Message to be signed */
  166,
  { 0xaf, 0xbc, 0x19, 0xd4, 0x79, 0x24, 0x90, 0x18, 0xfd, 0xf4, 0xe0, 0x9f, 0x61, 0x87, 0x26, 0x44, 0x04, 0x95, 0xde, 0x11, 0xdd, 0xee, 0xe3, 0x88, 0x72, 0xd7, 0x75, 0xfc, 0xea, 0x74, 0xa2, 0x38, 0x96, 0xb5, 0x34, 0x3c, 0x9c, 0x38, 0xd4, 0x6a, 0xf0, 0xdb, 0xa2, 0x24, 0xd0, 0x47, 0x58, 0x0c, 0xc6, 0x0a, 0x65, 0xe9, 0x39, 0x1c, 0xf9, 0xb5, 0x9b, 0x36, 0xa8, 0x60, 0x59, 0x8d, 0x4e, 0x82, 0x16, 0x72, 0x2f, 0x99, 0x3b, 0x91, 0xcf, 0xae, 0x87, 0xbc, 0x25, 0x5a, 0xf8, 0x9a, 0x6a, 0x19, 0x9b, 0xca, 0x4a, 0x39, 0x1e, 0xad, 0xbc, 0x3a, 0x24, 0x90, 0x3c, 0x0b, 0xd6, 0x67, 0x36, 0x8f, 0x6b, 0xe7, 0x8e, 0x3f, 0xea, 0xbf, 0xb4, 0xff, 0xd4, 0x63, 0x12, 0x27, 0x63, 0x74, 0x0f, 0xfb, 0xbe, 0xfe, 0xab, 0x9a, 0x25, 0x56, 0x4b, 0xc5, 0xd1, 0xc2, 0x4c, 0x93, 0xe4, 0x22, 0xf7, 0x50, 0x73, 0xe2, 0xad, 0x72, 0xbf, 0x45, 0xb1, 0x0d, 0xf0, 0x0b, 0x52, 0xa1, 0x47, 0x12, 0x8e, 0x73, 0xfe, 0xe3, 0x3f, 0xa3, 0xf0, 0x57, 0x7d, 0x77, 0xf8, 0x0f, 0xbc, 0x2d, 0xf1, 0xbe, 0xd3, 0x13, 0x29, 0x0c, 0x12, 0x77, 0x7f, 0x50 }
,
  /* Salt */
  20,
  { 0xa3, 0x34, 0xdb, 0x6f, 0xae, 0xbf, 0x11, 0x08, 0x1a, 0x04, 0xf8, 0x7c, 0x2d, 0x62, 0x1c, 0xde, 0xc7, 0x93, 0x0b, 0x9b }
,
  /* Signature */
  129,
  { 0x00, 0x93, 0x8d, 0xcb, 0x6d, 0x58, 0x30, 0x46, 0x06, 0x5f, 0x69, 0xc7, 0x8d, 0xa7, 0xa1, 0xf1, 0x75, 0x70, 0x66, 0xa7, 0xfa, 0x75, 0x12, 0x5a, 0x9d, 0x29, 0x29, 0xf0, 0xb7, 0x9a, 0x60, 0xb6, 0x27, 0xb0, 0x82, 0xf1, 0x1f, 0x5b, 0x19, 0x6f, 0x28, 0xeb, 0x9d, 0xaa, 0x6f, 0x21, 0xc0, 0x5e, 0x51, 0x40, 0xf6, 0xae, 0xf1, 0x73, 0x7d, 0x20, 0x23, 0x07, 0x5c, 0x05, 0xec, 0xf0, 0x4a, 0x02, 0x8c, 0x68, 0x6a, 0x2a, 0xb3, 0xe7, 0xd5, 0xa0, 0x66, 0x4f, 0x29, 0x5c, 0xe1, 0x29, 0x95, 0xe8, 0x90, 0x90, 0x8b, 0x6a, 0xd2, 0x1f, 0x08, 0x39, 0xeb, 0x65, 0xb7, 0x03, 0x93, 0xa7, 0xb5, 0xaf, 0xd9, 0x87, 0x1d, 0xe0, 0xca, 0xa0, 0xce, 0xde, 0xc5, 0xb8, 0x19, 0x62, 0x67, 0x56, 0x20, 0x9d, 0x13, 0xab, 0x1e, 0x7b, 0xb9, 0x54, 0x6a, 0x26, 0xff, 0x37, 0xe9, 0xa5, 0x1a, 0xf9, 0xfd, 0x56, 0x2e }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 5: A 1028-bit RSA Key Pair",
{
  /* RSA modulus n */
  129,
  { 0x0d, 0x10, 0xf6, 0x61, 0xf2, 0x99, 0x40, 0xf5, 0xed, 0x39, 0xaa, 0x26, 0x09, 0x66, 0xde, 0xb4, 0x78, 0x43, 0x67, 0x9d, 0x2b, 0x6f, 0xb2, 0x5b, 0x3d, 0xe3, 0x70, 0xf3, 0xac, 0x7c, 0x19, 0x91, 0x63, 0x91, 0xfd, 0x25, 0xfb, 0x52, 0x7e, 0xbf, 0xa6, 0xa4, 0xb4, 0xdf, 0x45, 0xa1, 0x75, 0x9d, 0x99, 0x6c, 0x4b, 0xb4, 0xeb, 0xd1, 0x88, 0x28, 0xc4, 0x4f, 0xc5, 0x2d, 0x01, 0x91, 0x87, 0x17, 0x40, 0x52, 0x5f, 0x47, 0xa4, 0xb0, 0xcc, 0x8d, 0xa3, 0x25, 0xed, 0x8a, 0xa6, 0x76, 0xb0, 0xd0, 0xf6, 0x26, 0xe0, 0xa7, 0x7f, 0x07, 0x69, 0x21, 0x70, 0xac, 0xac, 0x80, 0x82, 0xf4, 0x2f, 0xaa, 0x7d, 0xc7, 0xcd, 0x12, 0x3e, 0x73, 0x0e, 0x31, 0xa8, 0x79, 0x85, 0x20, 0x4c, 0xab, 0xcb, 0xe6, 0x67, 0x0d, 0x43, 0xa2, 0xdd, 0x2b, 0x2d, 0xde, 0xf5, 0xe0, 0x53, 0x92, 0xfc, 0x21, 0x3b, 0xc5, 0x07 }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  129,
  { 0x03, 0xce, 0x08, 0xb1, 0x04, 0xff, 0xf3, 0x96, 0xa9, 0x79, 0xbd, 0x3e, 0x4e, 0x46, 0x92, 0x5b, 0x63, 0x19, 0xdd, 0xb6, 0x3a, 0xcb, 0xcf, 0xd8, 0x19, 0xf1, 0x7d, 0x16, 0xb8, 0x07, 0x7b, 0x3a, 0x87, 0x10, 0x1f, 0xf3, 0x4b, 0x77, 0xfe, 0x48, 0xb8, 0xb2, 0x05, 0xa9, 0x6e, 0x91, 0x51, 0xba, 0x8e, 0xce, 0xa6, 0x4d, 0x0c, 0xce, 0x7b, 0x23, 0xc3, 0xe6, 0xa6, 0xb8, 0x30, 0x58, 0xbc, 0x49, 0xda, 0xe8, 0x16, 0xae, 0x73, 0x6d, 0xb5, 0xa4, 0x70, 0x8e, 0x2a, 0xd4, 0x35, 0x23, 0x2b, 0x56, 0x7f, 0x90, 0x96, 0xce, 0x59, 0xff, 0x28, 0x06, 0x1e, 0x79, 0xab, 0x1c, 0x02, 0xd7, 0x17, 0xe6, 0xb2, 0x3c, 0xea, 0x6d, 0xb8, 0xeb, 0x51, 0x92, 0xfa, 0x7c, 0x1e, 0xab, 0x22, 0x7d, 0xba, 0x74, 0x62, 0x1c, 0x45, 0x60, 0x18, 0x96, 0xee, 0xf1, 0x37, 0x92, 0xc8, 0x44, 0x0b, 0xeb, 0x15, 0xaa, 0xc1 }
,
  /* Prime p */
  65,
  { 0x03, 0xf2, 0xf3, 0x31, 0xf4, 0x14, 0x2d, 0x4f, 0x24, 0xb4, 0x3a, 0xa1, 0x02, 0x79, 0xa8, 0x96, 0x52, 0xd4, 0xe7, 0x53, 0x72, 0x21, 0xa1, 0xa7, 0xb2, 0xa2, 0x5d, 0xeb, 0x55, 0x1e, 0x5d, 0xe9, 0xac, 0x49, 0x74, 0x11, 0xc2, 0x27, 0xa9, 0x4e, 0x45, 0xf9, 0x1c, 0x2d, 0x1c, 0x13, 0xcc, 0x04, 0x6c, 0xf4, 0xce, 0x14, 0xe3, 0x2d, 0x05, 0x87, 0x34, 0x21, 0x0d, 0x44, 0xa8, 0x7e, 0xe1, 0xb7, 0x3f }
,
  /* Prime q */
  65,
  { 0x03, 0x4f, 0x09, 0x0d, 0x73, 0xb5, 0x58, 0x03, 0x03, 0x0c, 0xf0, 0x36, 0x1a, 0x5d, 0x80, 0x81, 0xbf, 0xb7, 0x9f, 0x85, 0x15, 0x23, 0xfe, 0xac, 0x0a, 0x21, 0x24, 0xd0, 0x8d, 0x40, 0x13, 0xff, 0x08, 0x48, 0x77, 0x71, 0xa8, 0x70, 0xd0, 0x47, 0x9d, 0xc0, 0x68, 0x6c, 0x62, 0xf7, 0x71, 0x8d, 0xfe, 0xcf, 0x02, 0x4b, 0x17, 0xc9, 0x26, 0x76, 0x78, 0x05, 0x91, 0x71, 0x33, 0x9c, 0xc0, 0x08, 0x39 }
,
  /* p's CRT exponent dP */
  65,
  { 0x02, 0xaa, 0x66, 0x3a, 0xdb, 0xf5, 0x1a, 0xb8, 0x87, 0xa0, 0x18, 0xcb, 0x42, 0x6e, 0x78, 0xbc, 0x2f, 0xe1, 0x82, 0xdc, 0xb2, 0xf7, 0xbc, 0xb5, 0x04, 0x41, 0xd1, 0x7f, 0xdf, 0x0f, 0x06, 0x79, 0x8b, 0x50, 0x71, 0xc6, 0xe2, 0xf5, 0xfe, 0xb4, 0xd5, 0x4a, 0xd8, 0x18, 0x23, 0x11, 0xc1, 0xef, 0x62, 0xd4, 0xc4, 0x9f, 0x18, 0xd1, 0xf5, 0x1f, 0x54, 0xb2, 0xd2, 0xcf, 0xfb, 0xa4, 0xda, 0x1b, 0xe5 }
,
  /* q's CRT exponent dQ */
  65,
  { 0x02, 0xbb, 0xe7, 0x06, 0x07, 0x8b, 0x5c, 0x0b, 0x39, 0x15, 0x12, 0xd4, 0x11, 0xdb, 0x1b, 0x19, 0x9b, 0x5a, 0x56, 0x64, 0xb8, 0x40, 0x42, 0xea, 0xd3, 0x7f, 0xe9, 0x94, 0xae, 0x72, 0xb9, 0x53, 0x2d, 0xfb, 0xfb, 0x3e, 0x9e, 0x69, 0x81, 0xa0, 0xfb, 0xb8, 0x06, 0x51, 0x31, 0x41, 0xb7, 0xc2, 0x16, 0x3f, 0xe5, 0x6c, 0x39, 0x5e, 0x4b, 0xfa, 0xee, 0x57, 0xe3, 0x83, 0x3f, 0x9b, 0x91, 0x8d, 0xf9 }
,
  /* CRT coefficient qInv */
  64,
  { 0x02, 0x42, 0xb6, 0xcd, 0x00, 0xd3, 0x0a, 0x76, 0x7a, 0xee, 0x9a, 0x89, 0x8e, 0xad, 0x45, 0x3c, 0x8e, 0xae, 0xa6, 0x3d, 0x50, 0x0b, 0x7d, 0x1e, 0x00, 0x71, 0x3e, 0xda, 0xe5, 0x1c, 0xe3, 0x6b, 0x23, 0xb6, 0x64, 0xdf, 0x26, 0xe6, 0x3e, 0x26, 0x6e, 0xc8, 0xf7, 0x6e, 0x6e, 0x63, 0xed, 0x1b, 0xa4, 0x1e, 0xb0, 0x33, 0xb1, 0x20, 0xf7, 0xea, 0x52, 0x12, 0xae, 0x21, 0xa9, 0x8f, 0xbc, 0x16 }

}
,
{{
  "RSASSA-PSS Signature Example 5.1",
  /* Message to be signed */
  154,
  { 0x30, 0xc7, 0xd5, 0x57, 0x45, 0x8b, 0x43, 0x6d, 0xec, 0xfd, 0xc1, 0x4d, 0x06, 0xcb, 0x7b, 0x96, 0xb0, 0x67, 0x18, 0xc4, 0x8d, 0x7d, 0xe5, 0x74, 0x82, 0xa8, 0x68, 0xae, 0x7f, 0x06, 0x58, 0x70, 0xa6, 0x21, 0x65, 0x06, 0xd1, 0x1b, 0x77, 0x93, 0x23, 0xdf, 0xdf, 0x04, 0x6c, 0xf5, 0x77, 0x51, 0x29, 0x13, 0x4b, 0x4d, 0x56, 0x89, 0xe4, 0xd9, 0xc0, 0xce, 0x1e, 0x12, 0xd7, 0xd4, 0xb0, 0x6c, 0xb5, 0xfc, 0x58, 0x20, 0xde, 0xcf, 0xa4, 0x1b, 0xaf, 0x59, 0xbf, 0x25, 0x7b, 0x32, 0xf0, 0x25, 0xb7, 0x67, 0x9b, 0x44, 0x5b, 0x94, 0x99, 0xc9, 0x25, 0x55, 0x14, 0x58, 0x85, 0x99, 0x2f, 0x1b, 0x76, 0xf8, 0x48, 0x91, 0xee, 0x4d, 0x3b, 0xe0, 0xf5, 0x15, 0x0f, 0xd5, 0x90, 0x1e, 0x3a, 0x4c, 0x8e, 0xd4, 0x3f, 0xd3, 0x6b, 0x61, 0xd0, 0x22, 0xe6, 0x5a, 0xd5, 0x00, 0x8d, 0xbf, 0x33, 0x29, 0x3c, 0x22, 0xbf, 0xbf, 0xd0, 0x73, 0x21, 0xf0, 0xf1, 0xd5, 0xfa, 0x9f, 0xdf, 0x00, 0x14, 0xc2, 0xfc, 0xb0, 0x35, 0x8a, 0xad, 0x0e, 0x35, 0x4b, 0x0d, 0x29 }
,
  /* Salt */
  20,
  { 0x08, 0x1b, 0x23, 0x3b, 0x43, 0x56, 0x77, 0x50, 0xbd, 0x6e, 0x78, 0xf3, 0x96, 0xa8, 0x8b, 0x9f, 0x6a, 0x44, 0x51, 0x51 }
,
  /* Signature */
  129,
  { 0x0b, 0xa3, 0x73, 0xf7, 0x6e, 0x09, 0x21, 0xb7, 0x0a, 0x8f, 0xbf, 0xe6, 0x22, 0xf0, 0xbf, 0x77, 0xb2, 0x8a, 0x3d, 0xb9, 0x8e, 0x36, 0x10, 0x51, 0xc3, 0xd7, 0xcb, 0x92, 0xad, 0x04, 0x52, 0x91, 0x5a, 0x4d, 0xe9, 0xc0, 0x17, 0x22, 0xf6, 0x82, 0x3e, 0xeb, 0x6a, 0xdf, 0x7e, 0x0c, 0xa8, 0x29, 0x0f, 0x5d, 0xe3, 0xe5, 0x49, 0x89, 0x0a, 0xc2, 0xa3, 0xc5, 0x95, 0x0a, 0xb2, 0x17, 0xba, 0x58, 0x59, 0x08, 0x94, 0x95, 0x2d, 0xe9, 0x6f, 0x8d, 0xf1, 0x11, 0xb2, 0x57, 0x52, 0x15, 0xda, 0x6c, 0x16, 0x15, 0x90, 0xc7, 0x45, 0xbe, 0x61, 0x24, 0x76, 0xee, 0x57, 0x8e, 0xd3, 0x84, 0xab, 0x33, 0xe3, 0xec, 0xe9, 0x74, 0x81, 0xa2, 0x52, 0xf5, 0xc7, 0x9a, 0x98, 0xb5, 0x53, 0x2a, 0xe0, 0x0c, 0xdd, 0x62, 0xf2, 0xec, 0xc0, 0xcd, 0x1b, 0xae, 0xfe, 0x80, 0xd8, 0x0b, 0x96, 0x21, 0x93, 0xec, 0x1d }

}
,
#ifdef LTC_TEST_EXT
{
  "RSASSA-PSS Signature Example 5.2",
  /* Message to be signed */
  209,
  { 0xe7, 0xb3, 0x2e, 0x15, 0x56, 0xea, 0x1b, 0x27, 0x95, 0x04, 0x6a, 0xc6, 0x97, 0x39, 0xd2, 0x2a, 0xc8, 0x96, 0x6b, 0xf1, 0x1c, 0x11, 0x6f, 0x61, 0x4b, 0x16, 0x67, 0x40, 0xe9, 0x6b, 0x90, 0x65, 0x3e, 0x57, 0x50, 0x94, 0x5f, 0xcf, 0x77, 0x21, 0x86, 0xc0, 0x37, 0x90, 0xa0, 0x7f, 0xda, 0x32, 0x3e, 0x1a, 0x61, 0x91, 0x6b, 0x06, 0xee, 0x21, 0x57, 0xdb, 0x3d, 0xff, 0x80, 0xd6, 0x7d, 0x5e, 0x39, 0xa5, 0x3a, 0xe2, 0x68, 0xc8, 0xf0, 0x9e, 0xd9, 0x9a, 0x73, 0x20, 0x05, 0xb0, 0xbc, 0x6a, 0x04, 0xaf, 0x4e, 0x08, 0xd5, 0x7a, 0x00, 0xe7, 0x20, 0x1b, 0x30, 0x60, 0xef, 0xaa, 0xdb, 0x73, 0x11, 0x3b, 0xfc, 0x08, 0x7f, 0xd8, 0x37, 0x09, 0x3a, 0xa2, 0x52, 0x35, 0xb8, 0xc1, 0x49, 0xf5, 0x62, 0x15, 0xf0, 0x31, 0xc2, 0x4a, 0xd5, 0xbd, 0xe7, 0xf2, 0x99, 0x60, 0xdf, 0x7d, 0x52, 0x40, 0x70, 0xf7, 0x44, 0x9c, 0x6f, 0x78, 0x50, 0x84, 0xbe, 0x1a, 0x0f, 0x73, 0x30, 0x47, 0xf3, 0x36, 0xf9, 0x15, 0x47, 0x38, 0x67, 0x45, 0x47, 0xdb, 0x02, 0xa9, 0xf4, 0x4d, 0xfc, 0x6e, 0x60, 0x30, 0x10, 0x81, 0xe1, 0xce, 0x99, 0x84, 0x7f, 0x3b, 0x5b, 0x60, 0x1f, 0xf0, 0x6b, 0x4d, 0x57, 0x76, 0xa9, 0x74, 0x0b, 0x9a, 0xa0, 0xd3, 0x40, 0x58, 0xfd, 0x3b, 0x90, 0x6e, 0x4f, 0x78, 0x59, 0xdf, 0xb0, 0x7d, 0x71, 0x73, 0xe5, 0xe6, 0xf6, 0x35, 0x0a, 0xda, 0xc2, 0x1f, 0x27, 0xb2, 0x30, 0x74, 0x69 }
,
  /* Salt */
  20,
  { 0xbd, 0x0c, 0xe1, 0x95, 0x49, 0xd0, 0x70, 0x01, 0x20, 0xcb, 0xe5, 0x10, 0x77, 0xdb, 0xbb, 0xb0, 0x0a, 0x8d, 0x8b, 0x09 }
,
  /* Signature */
  129,
  { 0x08, 0x18, 0x0d, 0xe8, 0x25, 0xe4, 0xb8, 0xb0, 0x14, 0xa3, 0x2d, 0xa8, 0xba, 0x76, 0x15, 0x55, 0x92, 0x12, 0x04, 0xf2, 0xf9, 0x0d, 0x5f, 0x24, 0xb7, 0x12, 0x90, 0x8f, 0xf8, 0x4f, 0x3e, 0x22, 0x0a, 0xd1, 0x79, 0x97, 0xc0, 0xdd, 0x6e, 0x70, 0x66, 0x30, 0xba, 0x3e, 0x84, 0xad, 0xd4, 0xd5, 0xe7, 0xab, 0x00, 0x4e, 0x58, 0x07, 0x4b, 0x54, 0x97, 0x09, 0x56, 0x5d, 0x43, 0xad, 0x9e, 0x97, 0xb5, 0xa7, 0xa1, 0xa2, 0x9e, 0x85, 0xb9, 0xf9, 0x0f, 0x4a, 0xaf, 0xcd, 0xf5, 0x83, 0x21, 0xde, 0x8c, 0x59, 0x74, 0xef, 0x9a, 0xbf, 0x2d, 0x52, 0x6f, 0x33, 0xc0, 0xf2, 0xf8, 0x2e, 0x95, 0xd1, 0x58, 0xea, 0x6b, 0x81, 0xf1, 0x73, 0x6d, 0xb8, 0xd1, 0xaf, 0x3d, 0x6a, 0xc6, 0xa8, 0x3b, 0x32, 0xd1, 0x8b, 0xae, 0x0f, 0xf1, 0xb2, 0xfe, 0x27, 0xde, 0x4c, 0x76, 0xed, 0x8c, 0x79, 0x80, 0xa3, 0x4e }

}
,
{
  "RSASSA-PSS Signature Example 5.3",
  /* Message to be signed */
  223,
  { 0x8d, 0x83, 0x96, 0xe3, 0x65, 0x07, 0xfe, 0x1e, 0xf6, 0xa1, 0x90, 0x17, 0x54, 0x8e, 0x0c, 0x71, 0x66, 0x74, 0xc2, 0xfe, 0xc2, 0x33, 0xad, 0xb2, 0xf7, 0x75, 0x66, 0x5e, 0xc4, 0x1f, 0x2b, 0xd0, 0xba, 0x39, 0x6b, 0x06, 0x1a, 0x9d, 0xaa, 0x7e, 0x86, 0x6f, 0x7c, 0x23, 0xfd, 0x35, 0x31, 0x95, 0x43, 0x00, 0xa3, 0x42, 0xf9, 0x24, 0x53, 0x5e, 0xa1, 0x49, 0x8c, 0x48, 0xf6, 0xc8, 0x79, 0x93, 0x28, 0x65, 0xfc, 0x02, 0x00, 0x0c, 0x52, 0x87, 0x23, 0xb7, 0xad, 0x03, 0x35, 0x74, 0x5b, 0x51, 0x20, 0x9a, 0x0a, 0xfe, 0xd9, 0x32, 0xaf, 0x8f, 0x08, 0x87, 0xc2, 0x19, 0x00, 0x4d, 0x2a, 0xbd, 0x89, 0x4e, 0xa9, 0x25, 0x59, 0xee, 0x31, 0x98, 0xaf, 0x3a, 0x73, 0x4f, 0xe9, 0xb9, 0x63, 0x8c, 0x26, 0x3a, 0x72, 0x8a, 0xd9, 0x5a, 0x5a, 0xe8, 0xce, 0x3e, 0xb1, 0x58, 0x39, 0xf3, 0xaa, 0x78, 0x52, 0xbb, 0x39, 0x07, 0x06, 0xe7, 0x76, 0x0e, 0x43, 0xa7, 0x12, 0x91, 0xa2, 0xe3, 0xf8, 0x27, 0x23, 0x7d, 0xed, 0xa8, 0x51, 0x87, 0x4c, 0x51, 0x76, 0x65, 0xf5, 0x45, 0xf2, 0x72, 0x38, 0xdf, 0x86, 0x55, 0x7f, 0x37, 0x5d, 0x09, 0xcc, 0xd8, 0xbd, 0x15, 0xd8, 0xcc, 0xf6, 0x1f, 0x5d, 0x78, 0xca, 0x5c, 0x7f, 0x5c, 0xde, 0x78, 0x2e, 0x6b, 0xf5, 0xd0, 0x05, 0x70, 0x56, 0xd4, 0xba, 0xd9, 0x8b, 0x3d, 0x2f, 0x95, 0x75, 0xe8, 0x24, 0xab, 0x7a, 0x33, 0xff, 0x57, 0xb0, 0xac, 0x10, 0x0a, 0xb0, 0xd6, 0xea, 0xd7, 0xaa, 0x0b, 0x50, 0xf6, 0xe4, 0xd3, 0xe5, 0xec, 0x0b, 0x96, 0x6b }
,
  /* Salt */
  20,
  { 0x81, 0x57, 0x79, 0xa9, 0x1b, 0x3a, 0x8b, 0xd0, 0x49, 0xbf, 0x2a, 0xeb, 0x92, 0x01, 0x42, 0x77, 0x22, 0x22, 0xc9, 0xca }
,
  /* Signature */
  129,
  { 0x05, 0xe0, 0xfd, 0xbd, 0xf6, 0xf7, 0x56, 0xef, 0x73, 0x31, 0x85, 0xcc, 0xfa, 0x8c, 0xed, 0x2e, 0xb6, 0xd0, 0x29, 0xd9, 0xd5, 0x6e, 0x35, 0x56, 0x1b, 0x5d, 0xb8, 0xe7, 0x02, 0x57, 0xee, 0x6f, 0xd0, 0x19, 0xd2, 0xf0, 0xbb, 0xf6, 0x69, 0xfe, 0x9b, 0x98, 0x21, 0xe7, 0x8d, 0xf6, 0xd4, 0x1e, 0x31, 0x60, 0x8d, 0x58, 0x28, 0x0f, 0x31, 0x8e, 0xe3, 0x4f, 0x55, 0x99, 0x41, 0xc8, 0xdf, 0x13, 0x28, 0x75, 0x74, 0xba, 0xc0, 0x00, 0xb7, 0xe5, 0x8d, 0xc4, 0xf4, 0x14, 0xba, 0x49, 0xfb, 0x12, 0x7f, 0x9d, 0x0f, 0x89, 0x36, 0x63, 0x8c, 0x76, 0xe8, 0x53, 0x56, 0xc9, 0x94, 0xf7, 0x97, 0x50, 0xf7, 0xfa, 0x3c, 0xf4, 0xfd, 0x48, 0x2d, 0xf7, 0x5e, 0x3f, 0xb9, 0x97, 0x8c, 0xd0, 0x61, 0xf7, 0xab, 0xb1, 0x75, 0x72, 0xe6, 0xe6, 0x3e, 0x0b, 0xde, 0x12, 0xcb, 0xdc, 0xf1, 0x8c, 0x68, 0xb9, 0x79 }

}
,
{
  "RSASSA-PSS Signature Example 5.4",
  /* Message to be signed */
  13,
  { 0x32, 0x8c, 0x65, 0x9e, 0x0a, 0x64, 0x37, 0x43, 0x3c, 0xce, 0xb7, 0x3c, 0x14 }
,
  /* Salt */
  20,
  { 0x9a, 0xec, 0x4a, 0x74, 0x80, 0xd5, 0xbb, 0xc4, 0x29, 0x20, 0xd7, 0xca, 0x23, 0x5d, 0xb6, 0x74, 0x98, 0x9c, 0x9a, 0xac }
,
  /* Signature */
  129,
  { 0x0b, 0xc9, 0x89, 0x85, 0x3b, 0xc2, 0xea, 0x86, 0x87, 0x32, 0x71, 0xce, 0x18, 0x3a, 0x92, 0x3a, 0xb6, 0x5e, 0x8a, 0x53, 0x10, 0x0e, 0x6d, 0xf5, 0xd8, 0x7a, 0x24, 0xc4, 0x19, 0x4e, 0xb7, 0x97, 0x81, 0x3e, 0xe2, 0xa1, 0x87, 0xc0, 0x97, 0xdd, 0x87, 0x2d, 0x59, 0x1d, 0xa6, 0x0c, 0x56, 0x86, 0x05, 0xdd, 0x7e, 0x74, 0x2d, 0x5a, 0xf4, 0xe3, 0x3b, 0x11, 0x67, 0x8c, 0xcb, 0x63, 0x90, 0x32, 0x04, 0xa3, 0xd0, 0x80, 0xb0, 0x90, 0x2c, 0x89, 0xab, 0xa8, 0x86, 0x8f, 0x00, 0x9c, 0x0f, 0x1c, 0x0c, 0xb8, 0x58, 0x10, 0xbb, 0xdd, 0x29, 0x12, 0x1a, 0xbb, 0x84, 0x71, 0xff, 0x2d, 0x39, 0xe4, 0x9f, 0xd9, 0x2d, 0x56, 0xc6, 0x55, 0xc8, 0xe0, 0x37, 0xad, 0x18, 0xfa, 0xfb, 0xdc, 0x92, 0xc9, 0x58, 0x63, 0xf7, 0xf6, 0x1e, 0xa9, 0xef, 0xa2, 0x8f, 0xea, 0x40, 0x13, 0x69, 0xd1, 0x9d, 0xae, 0xa1 }

}
,
{
  "RSASSA-PSS Signature Example 5.5",
  /* Message to be signed */
  228,
  { 0xf3, 0x7b, 0x96, 0x23, 0x79, 0xa4, 0x7d, 0x41, 0x5a, 0x37, 0x6e, 0xec, 0x89, 0x73, 0x15, 0x0b, 0xcb, 0x34, 0xed, 0xd5, 0xab, 0x65, 0x40, 0x41, 0xb6, 0x14, 0x30, 0x56, 0x0c, 0x21, 0x44, 0x58, 0x2b, 0xa1, 0x33, 0xc8, 0x67, 0xd8, 0x52, 0xd6, 0xb8, 0xe2, 0x33, 0x21, 0x90, 0x13, 0x02, 0xec, 0xb4, 0x5b, 0x09, 0xec, 0x88, 0xb1, 0x52, 0x71, 0x78, 0xfa, 0x04, 0x32, 0x63, 0xf3, 0x06, 0x7d, 0x9f, 0xfe, 0x97, 0x30, 0x32, 0xa9, 0x9f, 0x4c, 0xb0, 0x8a, 0xd2, 0xc7, 0xe0, 0xa2, 0x45, 0x6c, 0xdd, 0x57, 0xa7, 0xdf, 0x56, 0xfe, 0x60, 0x53, 0x52, 0x7a, 0x5a, 0xeb, 0x67, 0xd7, 0xe5, 0x52, 0x06, 0x3c, 0x1c, 0xa9, 0x7b, 0x1b, 0xef, 0xfa, 0x7b, 0x39, 0xe9, 0x97, 0xca, 0xf2, 0x78, 0x78, 0xea, 0x0f, 0x62, 0xcb, 0xeb, 0xc8, 0xc2, 0x1d, 0xf4, 0xc8, 0x89, 0xa2, 0x02, 0x85, 0x1e, 0x94, 0x90, 0x88, 0x49, 0x0c, 0x24, 0x9b, 0x6e, 0x9a, 0xcf, 0x1d, 0x80, 0x63, 0xf5, 0xbe, 0x23, 0x43, 0x98, 0x9b, 0xf9, 0x5c, 0x4d, 0xa0, 0x1a, 0x2b, 0xe7, 0x8b, 0x4a, 0xb6, 0xb3, 0x78, 0x01, 0x5b, 0xc3, 0x79, 0x57, 0xf7, 0x69, 0x48, 0xb5, 0xe5, 0x8e, 0x44, 0x0c, 0x28, 0x45, 0x3d, 0x40, 0xd7, 0xcf, 0xd5, 0x7e, 0x7d, 0x69, 0x06, 0x00, 0x47, 0x4a, 0xb5, 0xe7, 0x59, 0x73, 0xb1, 0xea, 0x0c, 0x5f, 0x1e, 0x45, 0xd1, 0x41, 0x90, 0xaf, 0xe2, 0xf4, 0xeb, 0x6d, 0x3b, 0xdf, 0x71, 0xf1, 0xd2, 0xf8, 0xbb, 0x15, 0x6a, 0x1c, 0x29, 0x5d, 0x04, 0xaa, 0xeb, 0x9d, 0x68, 0x9d, 0xce, 0x79, 0xed, 0x62, 0xbc, 0x44, 0x3e }
,
  /* Salt */
  20,
  { 0xe2, 0x0c, 0x1e, 0x98, 0x78, 0x51, 0x2c, 0x39, 0x97, 0x0f, 0x58, 0x37, 0x5e, 0x15, 0x49, 0xa6, 0x8b, 0x64, 0xf3, 0x1d }
,
  /* Signature */
  129,
  { 0x0a, 0xef, 0xa9, 0x43, 0xb6, 0x98, 0xb9, 0x60, 0x9e, 0xdf, 0x89, 0x8a, 0xd2, 0x27, 0x44, 0xac, 0x28, 0xdc, 0x23, 0x94, 0x97, 0xce, 0xa3, 0x69, 0xcb, 0xbd, 0x84, 0xf6, 0x5c, 0x95, 0xc0, 0xad, 0x77, 0x6b, 0x59, 0x47, 0x40, 0x16, 0x4b, 0x59, 0xa7, 0x39, 0xc6, 0xff, 0x7c, 0x2f, 0x07, 0xc7, 0xc0, 0x77, 0xa8, 0x6d, 0x95, 0x23, 0x8f, 0xe5, 0x1e, 0x1f, 0xcf, 0x33, 0x57, 0x4a, 0x4a, 0xe0, 0x68, 0x4b, 0x42, 0xa3, 0xf6, 0xbf, 0x67, 0x7d, 0x91, 0x82, 0x0c, 0xa8, 0x98, 0x74, 0x46, 0x7b, 0x2c, 0x23, 0xad, 0xd7, 0x79, 0x69, 0xc8, 0x07, 0x17, 0x43, 0x0d, 0x0e, 0xfc, 0x1d, 0x36, 0x95, 0x89, 0x2c, 0xe8, 0x55, 0xcb, 0x7f, 0x70, 0x11, 0x63, 0x0f, 0x4d, 0xf2, 0x6d, 0xef, 0x8d, 0xdf, 0x36, 0xfc, 0x23, 0x90, 0x5f, 0x57, 0xfa, 0x62, 0x43, 0xa4, 0x85, 0xc7, 0x70, 0xd5, 0x68, 0x1f, 0xcd }

}
,
{
  "RSASSA-PSS Signature Example 5.6",
  /* Message to be signed */
  138,
  { 0xc6, 0x10, 0x3c, 0x33, 0x0c, 0x1e, 0xf7, 0x18, 0xc1, 0x41, 0xe4, 0x7b, 0x8f, 0xa8, 0x59, 0xbe, 0x4d, 0x5b, 0x96, 0x25, 0x9e, 0x7d, 0x14, 0x20, 0x70, 0xec, 0xd4, 0x85, 0x83, 0x9d, 0xba, 0x5a, 0x83, 0x69, 0xc1, 0x7c, 0x11, 0x14, 0x03, 0x5e, 0x53, 0x2d, 0x19, 0x5c, 0x74, 0xf4, 0x4a, 0x04, 0x76, 0xa2, 0xd3, 0xe8, 0xa4, 0xda, 0x21, 0x00, 0x16, 0xca, 0xce, 0xd0, 0xe3, 0x67, 0xcb, 0x86, 0x77, 0x10, 0xa4, 0xb5, 0xaa, 0x2d, 0xf2, 0xb8, 0xe5, 0xda, 0xf5, 0xfd, 0xc6, 0x47, 0x80, 0x7d, 0x4d, 0x5e, 0xbb, 0x6c, 0x56, 0xb9, 0x76, 0x3c, 0xcd, 0xae, 0x4d, 0xea, 0x33, 0x08, 0xeb, 0x0a, 0xc2, 0xa8, 0x95, 0x01, 0xcb, 0x20, 0x9d, 0x26, 0x39, 0xfa, 0x5b, 0xf8, 0x7c, 0xe7, 0x90, 0x74, 0x7d, 0x3c, 0xb2, 0xd2, 0x95, 0xe8, 0x45, 0x64, 0xf2, 0xf6, 0x37, 0x82, 0x4f, 0x0c, 0x13, 0x02, 0x81, 0x29, 0xb0, 0xaa, 0x4a, 0x42, 0x2d, 0x16, 0x22, 0x82 }
,
  /* Salt */
  20,
  { 0x23, 0x29, 0x1e, 0x4a, 0x33, 0x07, 0xe8, 0xbb, 0xb7, 0x76, 0x62, 0x3a, 0xb3, 0x4e, 0x4a, 0x5f, 0x4c, 0xc8, 0xa8, 0xdb }
,
  /* Signature */
  129,
  { 0x02, 0x80, 0x2d, 0xcc, 0xfa, 0x8d, 0xfa, 0xf5, 0x27, 0x9b, 0xf0, 0xb4, 0xa2, 0x9b, 0xa1, 0xb1, 0x57, 0x61, 0x1f, 0xae, 0xaa, 0xf4, 0x19, 0xb8, 0x91, 0x9d, 0x15, 0x94, 0x19, 0x00, 0xc1, 0x33, 0x9e, 0x7e, 0x92, 0xe6, 0xfa, 0xe5, 0x62, 0xc5, 0x3e, 0x6c, 0xc8, 0xe8, 0x41, 0x04, 0xb1, 0x10, 0xbc, 0xe0, 0x3a, 0xd1, 0x85, 0x25, 0xe3, 0xc4, 0x9a, 0x0e, 0xad, 0xad, 0x5d, 0x3f, 0x28, 0xf2, 0x44, 0xa8, 0xed, 0x89, 0xed, 0xba, 0xfb, 0xb6, 0x86, 0x27, 0x7c, 0xfa, 0x8a, 0xe9, 0x09, 0x71, 0x4d, 0x6b, 0x28, 0xf4, 0xbf, 0x8e, 0x29, 0x3a, 0xa0, 0x4c, 0x41, 0xef, 0xe7, 0xc0, 0xa8, 0x12, 0x66, 0xd5, 0xc0, 0x61, 0xe2, 0x57, 0x5b, 0xe0, 0x32, 0xaa, 0x46, 0x46, 0x74, 0xff, 0x71, 0x62, 0x62, 0x19, 0xbd, 0x74, 0xcc, 0x45, 0xf0, 0xe7, 0xed, 0x4e, 0x3f, 0xf9, 0x6e, 0xee, 0x75, 0x8e, 0x8f }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 6: A 1029-bit RSA Key Pair",
{
  /* RSA modulus n */
  129,
  { 0x16, 0x4c, 0xa3, 0x1c, 0xff, 0x60, 0x9f, 0x3a, 0x0e, 0x71, 0x01, 0xb0, 0x39, 0xf2, 0xe4, 0xfe, 0x6d, 0xd3, 0x75, 0x19, 0xab, 0x98, 0x59, 0x8d, 0x17, 0x9e, 0x17, 0x49, 0x96, 0x59, 0x80, 0x71, 0xf4, 0x7d, 0x3a, 0x04, 0x55, 0x91, 0x58, 0xd7, 0xbe, 0x37, 0x3c, 0xf1, 0xaa, 0x53, 0xf0, 0xaa, 0x6e, 0xf0, 0x90, 0x39, 0xe5, 0x67, 0x8c, 0x2a, 0x4c, 0x63, 0x90, 0x05, 0x14, 0xc8, 0xc4, 0xf8, 0xaa, 0xed, 0x5d, 0xe1, 0x2a, 0x5f, 0x10, 0xb0, 0x9c, 0x31, 0x1a, 0xf8, 0xc0, 0xff, 0xb5, 0xb7, 0xa2, 0x97, 0xf2, 0xef, 0xc6, 0x3b, 0x8d, 0x6b, 0x05, 0x10, 0x93, 0x1f, 0x0b, 0x98, 0xe4, 0x8b, 0xf5, 0xfc, 0x6e, 0xc4, 0xe7, 0xb8, 0xdb, 0x1f, 0xfa, 0xeb, 0x08, 0xc3, 0x8e, 0x02, 0xad, 0xb8, 0xf0, 0x3a, 0x48, 0x22, 0x9c, 0x99, 0xe9, 0x69, 0x43, 0x1f, 0x61, 0xcb, 0x8c, 0x4d, 0xc6, 0x98, 0xd1 }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  129,
  { 0x03, 0xb6, 0x64, 0xee, 0x3b, 0x75, 0x66, 0x72, 0x3f, 0xc6, 0xea, 0xf2, 0x8a, 0xbb, 0x43, 0x0a, 0x39, 0x80, 0xf1, 0x12, 0x6c, 0x81, 0xde, 0x8a, 0xd7, 0x09, 0xea, 0xb3, 0x9a, 0xc9, 0xdc, 0xd0, 0xb1, 0x55, 0x0b, 0x37, 0x29, 0xd8, 0x70, 0x68, 0xe9, 0x52, 0x00, 0x9d, 0xf5, 0x44, 0x53, 0x4c, 0x1f, 0x50, 0x82, 0x9a, 0x78, 0xf4, 0x59, 0x1e, 0xb8, 0xfd, 0x57, 0x14, 0x04, 0x26, 0xa6, 0xbb, 0x04, 0x05, 0xb6, 0xa6, 0xf5, 0x1a, 0x57, 0xd9, 0x26, 0x7b, 0x7b, 0xbc, 0x65, 0x33, 0x91, 0xa6, 0x99, 0xa2, 0xa9, 0x0d, 0xac, 0x8a, 0xe2, 0x26, 0xbc, 0xc6, 0x0f, 0xa8, 0xcd, 0x93, 0x4c, 0x73, 0xc7, 0xb0, 0x3b, 0x1f, 0x6b, 0x81, 0x81, 0x58, 0x63, 0x18, 0x38, 0xa8, 0x61, 0x2e, 0x6e, 0x6e, 0xa9, 0x2b, 0xe2, 0x4f, 0x83, 0x24, 0xfa, 0xf5, 0xb1, 0xfd, 0x85, 0x87, 0x22, 0x52, 0x67, 0xba, 0x6f }
,
  /* Prime p */
  65,
  { 0x04, 0xf0, 0x54, 0x8c, 0x96, 0x26, 0xab, 0x1e, 0xbf, 0x12, 0x44, 0x93, 0x47, 0x41, 0xd9, 0x9a, 0x06, 0x22, 0x0e, 0xfa, 0x2a, 0x58, 0x56, 0xaa, 0x0e, 0x75, 0x73, 0x0b, 0x2e, 0xc9, 0x6a, 0xdc, 0x86, 0xbe, 0x89, 0x4f, 0xa2, 0x80, 0x3b, 0x53, 0xa5, 0xe8, 0x5d, 0x27, 0x6a, 0xcb, 0xd2, 0x9a, 0xb8, 0x23, 0xf8, 0x0a, 0x73, 0x91, 0xbb, 0x54, 0xa5, 0x05, 0x16, 0x72, 0xfb, 0x04, 0xee, 0xb5, 0x43 }
,
  /* Prime q */
  65,
  { 0x04, 0x83, 0xe0, 0xae, 0x47, 0x91, 0x55, 0x87, 0x74, 0x3f, 0xf3, 0x45, 0x36, 0x2b, 0x55, 0x5d, 0x39, 0x62, 0xd9, 0x8b, 0xb6, 0xf1, 0x5f, 0x84, 0x8b, 0x4c, 0x92, 0xb1, 0x77, 0x1c, 0xa8, 0xed, 0x10, 0x7d, 0x8d, 0x3e, 0xe6, 0x5e, 0xc4, 0x45, 0x17, 0xdd, 0x0f, 0xaa, 0x48, 0x1a, 0x38, 0x7e, 0x90, 0x2f, 0x7a, 0x2e, 0x74, 0x7c, 0x26, 0x9e, 0x7e, 0xa4, 0x44, 0x80, 0xbc, 0x53, 0x8b, 0x8e, 0x5b }
,
  /* p's CRT exponent dP */
  65,
  { 0x03, 0xa8, 0xe8, 0xae, 0xa9, 0x92, 0x0c, 0x1a, 0xa3, 0xb2, 0xf0, 0xd8, 0x46, 0xe4, 0xb8, 0x50, 0xd8, 0x1c, 0xa3, 0x06, 0xa5, 0x1c, 0x83, 0x54, 0x4f, 0x94, 0x9f, 0x64, 0xf9, 0x0d, 0xcf, 0x3f, 0x8e, 0x26, 0x61, 0xf0, 0x7e, 0x56, 0x12, 0x20, 0xa1, 0x80, 0x38, 0x8f, 0xbe, 0x27, 0x3e, 0x70, 0xe2, 0xe5, 0xdc, 0xa8, 0x3a, 0x0e, 0x13, 0x48, 0xdd, 0x64, 0x90, 0xc7, 0x31, 0xd6, 0xec, 0xe1, 0xab }
,
  /* q's CRT exponent dQ */
  65,
  { 0x01, 0x35, 0xbd, 0xcd, 0xb6, 0x0b, 0xf2, 0x19, 0x7c, 0x43, 0x6e, 0xd3, 0x4b, 0x32, 0xcd, 0x8b, 0x4f, 0xc7, 0x77, 0x78, 0x83, 0x2b, 0xa7, 0x67, 0x03, 0x55, 0x1f, 0xb2, 0x42, 0xb3, 0x01, 0x69, 0x95, 0x93, 0xaf, 0x77, 0xfd, 0x8f, 0xc3, 0x94, 0xa8, 0x52, 0x6a, 0xd2, 0x3c, 0xc4, 0x1a, 0x03, 0x80, 0x6b, 0xd8, 0x97, 0xfe, 0x4b, 0x0e, 0xa6, 0x46, 0x55, 0x8a, 0xad, 0xdc, 0xc9, 0x9e, 0x8a, 0x25 }
,
  /* CRT coefficient qInv */
  65,
  { 0x03, 0x04, 0xc0, 0x3d, 0x9c, 0x73, 0x65, 0x03, 0xa9, 0x84, 0xab, 0xbd, 0x9b, 0xa2, 0x23, 0x01, 0x40, 0x7c, 0x4a, 0x2a, 0xb1, 0xdd, 0x85, 0x76, 0x64, 0x81, 0xb6, 0x0d, 0x45, 0x40, 0x11, 0x52, 0xe6, 0x92, 0xbe, 0x14, 0xf4, 0x12, 0x1d, 0x9a, 0xa3, 0xfd, 0x6e, 0x0b, 0x4d, 0x1d, 0x3a, 0x97, 0x35, 0x38, 0xa3, 0x1d, 0x42, 0xee, 0x6e, 0x1e, 0x5e, 0xf6, 0x20, 0x23, 0x1a, 0x2b, 0xba, 0xf3, 0x5f }

}
,
{{
  "RSASSA-PSS Signature Example 6.1",
  /* Message to be signed */
  109,
  { 0x0a, 0x20, 0xb7, 0x74, 0xad, 0xdc, 0x2f, 0xa5, 0x12, 0x45, 0xed, 0x7c, 0xb9, 0xda, 0x60, 0x9e, 0x50, 0xca, 0xc6, 0x63, 0x6a, 0x52, 0x54, 0x3f, 0x97, 0x45, 0x8e, 0xed, 0x73, 0x40, 0xf8, 0xd5, 0x3f, 0xfc, 0x64, 0x91, 0x8f, 0x94, 0x90, 0x78, 0xee, 0x03, 0xef, 0x60, 0xd4, 0x2b, 0x5f, 0xec, 0x24, 0x60, 0x50, 0xbd, 0x55, 0x05, 0xcd, 0x8c, 0xb5, 0x97, 0xba, 0xd3, 0xc4, 0xe7, 0x13, 0xb0, 0xef, 0x30, 0x64, 0x4e, 0x76, 0xad, 0xab, 0xb0, 0xde, 0x01, 0xa1, 0x56, 0x1e, 0xfb, 0x25, 0x51, 0x58, 0xc7, 0x4f, 0xc8, 0x01, 0xe6, 0xe9, 0x19, 0xe5, 0x81, 0xb4, 0x6f, 0x0f, 0x0d, 0xdd, 0x08, 0xe4, 0xf3, 0x4c, 0x78, 0x10, 0xb5, 0xed, 0x83, 0x18, 0xf9, 0x1d, 0x7c, 0x8c }
,
  /* Salt */
  20,
  { 0x5b, 0x4e, 0xa2, 0xef, 0x62, 0x9c, 0xc2, 0x2f, 0x3b, 0x53, 0x8e, 0x01, 0x69, 0x04, 0xb4, 0x7b, 0x1e, 0x40, 0xbf, 0xd5 }
,
  /* Signature */
  129,
  { 0x04, 0xc0, 0xcf, 0xac, 0xec, 0x04, 0xe5, 0xba, 0xdb, 0xec, 0xe1, 0x59, 0xa5, 0xa1, 0x10, 0x3f, 0x69, 0xb3, 0xf3, 0x2b, 0xa5, 0x93, 0xcb, 0x4c, 0xc4, 0xb1, 0xb7, 0xab, 0x45, 0x59, 0x16, 0xa9, 0x6a, 0x27, 0xcd, 0x26, 0x78, 0xea, 0x0f, 0x46, 0xba, 0x37, 0xf7, 0xfc, 0x9c, 0x86, 0x32, 0x5f, 0x29, 0x73, 0x3b, 0x38, 0x9f, 0x1d, 0x97, 0xf4, 0x3e, 0x72, 0x01, 0xc0, 0xf3, 0x48, 0xfc, 0x45, 0xfe, 0x42, 0x89, 0x23, 0x35, 0x36, 0x2e, 0xee, 0x01, 0x8b, 0x5b, 0x16, 0x1f, 0x2f, 0x93, 0x93, 0x03, 0x12, 0x25, 0xc7, 0x13, 0x01, 0x2a, 0x57, 0x6b, 0xc8, 0x8e, 0x23, 0x05, 0x24, 0x89, 0x86, 0x8d, 0x90, 0x10, 0xcb, 0xf0, 0x33, 0xec, 0xc5, 0x68, 0xe8, 0xbc, 0x15, 0x2b, 0xdc, 0x59, 0xd5, 0x60, 0xe4, 0x12, 0x91, 0x91, 0x5d, 0x28, 0x56, 0x52, 0x08, 0xe2, 0x2a, 0xee, 0xc9, 0xef, 0x85, 0xd1 }

}
,
#ifdef LTC_TEST_EXT
{
  "RSASSA-PSS Signature Example 6.2",
  /* Message to be signed */
  199,
  { 0x2a, 0xaf, 0xf6, 0x63, 0x1f, 0x62, 0x1c, 0xe6, 0x15, 0x76, 0x0a, 0x9e, 0xbc, 0xe9, 0x4b, 0xb3, 0x33, 0x07, 0x7a, 0xd8, 0x64, 0x88, 0xc8, 0x61, 0xd4, 0xb7, 0x6d, 0x29, 0xc1, 0xf4, 0x87, 0x46, 0xc6, 0x11, 0xae, 0x1e, 0x03, 0xce, 0xd4, 0x44, 0x5d, 0x7c, 0xfa, 0x1f, 0xe5, 0xf6, 0x2e, 0x1b, 0x3f, 0x08, 0x45, 0x2b, 0xde, 0x3b, 0x6e, 0xf8, 0x19, 0x73, 0xba, 0xfb, 0xb5, 0x7f, 0x97, 0xbc, 0xee, 0xf8, 0x73, 0x98, 0x53, 0x95, 0xb8, 0x26, 0x05, 0x89, 0xaa, 0x88, 0xcb, 0x7d, 0xb5, 0x0a, 0xb4, 0x69, 0x26, 0x2e, 0x55, 0x1b, 0xdc, 0xd9, 0xa5, 0x6f, 0x27, 0x5a, 0x0a, 0xc4, 0xfe, 0x48, 0x47, 0x00, 0xc3, 0x5f, 0x3d, 0xbf, 0x2b, 0x46, 0x9e, 0xde, 0x86, 0x47, 0x41, 0xb8, 0x6f, 0xa5, 0x91, 0x72, 0xa3, 0x60, 0xba, 0x95, 0xa0, 0x2e, 0x13, 0x9b, 0xe5, 0x0d, 0xdf, 0xb7, 0xcf, 0x0b, 0x42, 0xfa, 0xea, 0xbb, 0xfb, 0xba, 0xa8, 0x6a, 0x44, 0x97, 0x69, 0x9c, 0x4f, 0x2d, 0xfd, 0x5b, 0x08, 0x40, 0x6a, 0xf7, 0xe1, 0x41, 0x44, 0x42, 0x7c, 0x25, 0x3e, 0xc0, 0xef, 0xa2, 0x0e, 0xaf, 0x9a, 0x8b, 0xe8, 0xcd, 0x49, 0xce, 0x1f, 0x1b, 0xc4, 0xe9, 0x3e, 0x61, 0x9c, 0xf2, 0xaa, 0x8e, 0xd4, 0xfb, 0x39, 0xbc, 0x85, 0x90, 0xd0, 0xf7, 0xb9, 0x64, 0x88, 0xf7, 0x31, 0x7a, 0xc9, 0xab, 0xf7, 0xbe, 0xe4, 0xe3, 0xa0, 0xe7, 0x15 }
,
  /* Salt */
  20,
  { 0x83, 0x14, 0x6a, 0x9e, 0x78, 0x27, 0x22, 0xc2, 0x8b, 0x01, 0x4f, 0x98, 0xb4, 0x26, 0x7b, 0xda, 0x2a, 0xc9, 0x50, 0x4f }
,
  /* Signature */
  129,
  { 0x0a, 0x23, 0x14, 0x25, 0x0c, 0xf5, 0x2b, 0x6e, 0x4e, 0x90, 0x8d, 0xe5, 0xb3, 0x56, 0x46, 0xbc, 0xaa, 0x24, 0x36, 0x1d, 0xa8, 0x16, 0x0f, 0xb0, 0xf9, 0x25, 0x75, 0x90, 0xab, 0x3a, 0xce, 0x42, 0xb0, 0xdc, 0x3e, 0x77, 0xad, 0x2d, 0xb7, 0xc2, 0x03, 0xa2, 0x0b, 0xd9, 0x52, 0xfb, 0xb5, 0x6b, 0x15, 0x67, 0x04, 0x6e, 0xcf, 0xaa, 0x93, 0x3d, 0x7b, 0x10, 0x00, 0xc3, 0xde, 0x9f, 0xf0, 0x5b, 0x7d, 0x98, 0x9b, 0xa4, 0x6f, 0xd4, 0x3b, 0xc4, 0xc2, 0xd0, 0xa3, 0x98, 0x6b, 0x7f, 0xfa, 0x13, 0x47, 0x1d, 0x37, 0xeb, 0x5b, 0x47, 0xd6, 0x47, 0x07, 0xbd, 0x29, 0x0c, 0xfd, 0x6a, 0x9f, 0x39, 0x3a, 0xd0, 0x8e, 0xc1, 0xe3, 0xbd, 0x71, 0xbb, 0x57, 0x92, 0x61, 0x50, 0x35, 0xcd, 0xaf, 0x2d, 0x89, 0x29, 0xae, 0xd3, 0xbe, 0x09, 0x83, 0x79, 0x37, 0x7e, 0x77, 0x7c, 0xe7, 0x9a, 0xaa, 0x47, 0x73 }

}
,
{
  "RSASSA-PSS Signature Example 6.3",
  /* Message to be signed */
  62,
  { 0x0f, 0x61, 0x95, 0xd0, 0x4a, 0x6e, 0x6f, 0xc7, 0xe2, 0xc9, 0x60, 0x0d, 0xbf, 0x84, 0x0c, 0x39, 0xea, 0x8d, 0x4d, 0x62, 0x4f, 0xd5, 0x35, 0x07, 0x01, 0x6b, 0x0e, 0x26, 0x85, 0x8a, 0x5e, 0x0a, 0xec, 0xd7, 0xad, 0xa5, 0x43, 0xae, 0x5c, 0x0a, 0xb3, 0xa6, 0x25, 0x99, 0xcb, 0xa0, 0xa5, 0x4e, 0x6b, 0xf4, 0x46, 0xe2, 0x62, 0xf9, 0x89, 0x97, 0x8f, 0x9d, 0xdf, 0x5e, 0x9a, 0x41 }
,
  /* Salt */
  20,
  { 0xa8, 0x7b, 0x8a, 0xed, 0x07, 0xd7, 0xb8, 0xe2, 0xda, 0xf1, 0x4d, 0xdc, 0xa4, 0xac, 0x68, 0xc4, 0xd0, 0xaa, 0xbf, 0xf8 }
,
  /* Signature */
  129,
  { 0x08, 0x6d, 0xf6, 0xb5, 0x00, 0x09, 0x8c, 0x12, 0x0f, 0x24, 0xff, 0x84, 0x23, 0xf7, 0x27, 0xd9, 0xc6, 0x1a, 0x5c, 0x90, 0x07, 0xd3, 0xb6, 0xa3, 0x1c, 0xe7, 0xcf, 0x8f, 0x3c, 0xbe, 0xc1, 0xa2, 0x6b, 0xb2, 0x0e, 0x2b, 0xd4, 0xa0, 0x46, 0x79, 0x32, 0x99, 0xe0, 0x3e, 0x37, 0xa2, 0x1b, 0x40, 0x19, 0x4f, 0xb0, 0x45, 0xf9, 0x0b, 0x18, 0xbf, 0x20, 0xa4, 0x79, 0x92, 0xcc, 0xd7, 0x99, 0xcf, 0x9c, 0x05, 0x9c, 0x29, 0x9c, 0x05, 0x26, 0x85, 0x49, 0x54, 0xaa, 0xde, 0x8a, 0x6a, 0xd9, 0xd9, 0x7e, 0xc9, 0x1a, 0x11, 0x45, 0x38, 0x3f, 0x42, 0x46, 0x8b, 0x23, 0x1f, 0x4d, 0x72, 0xf2, 0x37, 0x06, 0xd9, 0x85, 0x3c, 0x3f, 0xa4, 0x3c, 0xe8, 0xac, 0xe8, 0xbf, 0xe7, 0x48, 0x49, 0x87, 0xa1, 0xec, 0x6a, 0x16, 0xc8, 0xda, 0xf8, 0x1f, 0x7c, 0x8b, 0xf4, 0x27, 0x74, 0x70, 0x7a, 0x9d, 0xf4, 0x56 }

}
,
{
  "RSASSA-PSS Signature Example 6.4",
  /* Message to be signed */
  112,
  { 0x33, 0x7d, 0x25, 0xfe, 0x98, 0x10, 0xeb, 0xca, 0x0d, 0xe4, 0xd4, 0x65, 0x8d, 0x3c, 0xeb, 0x8e, 0x0f, 0xe4, 0xc0, 0x66, 0xab, 0xa3, 0xbc, 0xc4, 0x8b, 0x10, 0x5d, 0x3b, 0xf7, 0xe0, 0x25, 0x7d, 0x44, 0xfe, 0xce, 0xa6, 0x59, 0x6f, 0x4d, 0x0c, 0x59, 0xa0, 0x84, 0x02, 0x83, 0x36, 0x78, 0xf7, 0x06, 0x20, 0xf9, 0x13, 0x8d, 0xfe, 0xb7, 0xde, 0xd9, 0x05, 0xe4, 0xa6, 0xd5, 0xf0, 0x5c, 0x47, 0x3d, 0x55, 0x93, 0x66, 0x52, 0xe2, 0xa5, 0xdf, 0x43, 0xc0, 0xcf, 0xda, 0x7b, 0xac, 0xaf, 0x30, 0x87, 0xf4, 0x52, 0x4b, 0x06, 0xcf, 0x42, 0x15, 0x7d, 0x01, 0x53, 0x97, 0x39, 0xf7, 0xfd, 0xde, 0xc9, 0xd5, 0x81, 0x25, 0xdf, 0x31, 0xa3, 0x2e, 0xab, 0x06, 0xc1, 0x9b, 0x71, 0xf1, 0xd5, 0xbf }
,
  /* Salt */
  20,
  { 0xa3, 0x79, 0x32, 0xf8, 0xa7, 0x49, 0x4a, 0x94, 0x2d, 0x6f, 0x76, 0x74, 0x38, 0xe7, 0x24, 0xd6, 0xd0, 0xc0, 0xef, 0x18 }
,
  /* Signature */
  129,
  { 0x0b, 0x5b, 0x11, 0xad, 0x54, 0x98, 0x63, 0xff, 0xa9, 0xc5, 0x1a, 0x14, 0xa1, 0x10, 0x6c, 0x2a, 0x72, 0xcc, 0x8b, 0x64, 0x6e, 0x5c, 0x72, 0x62, 0x50, 0x97, 0x86, 0x10, 0x5a, 0x98, 0x47, 0x76, 0x53, 0x4c, 0xa9, 0xb5, 0x4c, 0x1c, 0xc6, 0x4b, 0xf2, 0xd5, 0xa4, 0x4f, 0xd7, 0xe8, 0xa6, 0x9d, 0xb6, 0x99, 0xd5, 0xea, 0x52, 0x08, 0x7a, 0x47, 0x48, 0xfd, 0x2a, 0xbc, 0x1a, 0xfe, 0xd1, 0xe5, 0xd6, 0xf7, 0xc8, 0x90, 0x25, 0x53, 0x0b, 0xda, 0xa2, 0x21, 0x3d, 0x7e, 0x03, 0x0f, 0xa5, 0x5d, 0xf6, 0xf3, 0x4b, 0xcf, 0x1c, 0xe4, 0x6d, 0x2e, 0xdf, 0x4e, 0x3a, 0xe4, 0xf3, 0xb0, 0x18, 0x91, 0xa0, 0x68, 0xc9, 0xe3, 0xa4, 0x4b, 0xbc, 0x43, 0x13, 0x3e, 0xda, 0xd6, 0xec, 0xb9, 0xf3, 0x54, 0x00, 0xc4, 0x25, 0x2a, 0x57, 0x62, 0xd6, 0x57, 0x44, 0xb9, 0x9c, 0xb9, 0xf4, 0xc5, 0x59, 0x32, 0x9f }

}
,
{
  "RSASSA-PSS Signature Example 6.5",
  /* Message to be signed */
  176,
  { 0x84, 0xec, 0x50, 0x2b, 0x07, 0x2e, 0x82, 0x87, 0x78, 0x9d, 0x8f, 0x92, 0x35, 0x82, 0x9e, 0xa3, 0xb1, 0x87, 0xaf, 0xd4, 0xd4, 0xc7, 0x85, 0x61, 0x1b, 0xda, 0x5f, 0x9e, 0xb3, 0xcb, 0x96, 0x71, 0x7e, 0xfa, 0x70, 0x07, 0x22, 0x7f, 0x1c, 0x08, 0xcb, 0xcb, 0x97, 0x2e, 0x66, 0x72, 0x35, 0xe0, 0xfb, 0x7d, 0x43, 0x1a, 0x65, 0x70, 0x32, 0x6d, 0x2e, 0xcc, 0xe3, 0x5a, 0xdb, 0x37, 0x3d, 0xc7, 0x53, 0xb3, 0xbe, 0x5f, 0x82, 0x9b, 0x89, 0x17, 0x54, 0x93, 0x19, 0x3f, 0xab, 0x16, 0xba, 0xdb, 0x41, 0x37, 0x1b, 0x3a, 0xac, 0x0a, 0xe6, 0x70, 0x07, 0x6f, 0x24, 0xbe, 0xf4, 0x20, 0xc1, 0x35, 0xad, 0xd7, 0xce, 0xe8, 0xd3, 0x5f, 0xbc, 0x94, 0x4d, 0x79, 0xfa, 0xfb, 0x9e, 0x30, 0x7a, 0x13, 0xb0, 0xf5, 0x56, 0xcb, 0x65, 0x4a, 0x06, 0xf9, 0x73, 0xed, 0x22, 0x67, 0x23, 0x30, 0x19, 0x7e, 0xf5, 0xa7, 0x48, 0xbf, 0x82, 0x6a, 0x5d, 0xb2, 0x38, 0x3a, 0x25, 0x36, 0x4b, 0x68, 0x6b, 0x93, 0x72, 0xbb, 0x23, 0x39, 0xae, 0xb1, 0xac, 0x9e, 0x98, 0x89, 0x32, 0x7d, 0x01, 0x6f, 0x16, 0x70, 0x77, 0x6d, 0xb0, 0x62, 0x01, 0xad, 0xbd, 0xca, 0xf8, 0xa5, 0xe3, 0xb7, 0x4e, 0x10, 0x8b, 0x73 }
,
  /* Salt */
  20,
  { 0x7b, 0x79, 0x0c, 0x1d, 0x62, 0xf7, 0xb8, 0x4e, 0x94, 0xdf, 0x6a, 0xf2, 0x89, 0x17, 0xcf, 0x57, 0x10, 0x18, 0x11, 0x0e }
,
  /* Signature */
  129,
  { 0x02, 0xd7, 0x1f, 0xa9, 0xb5, 0x3e, 0x46, 0x54, 0xfe, 0xfb, 0x7f, 0x08, 0x38, 0x5c, 0xf6, 0xb0, 0xae, 0x3a, 0x81, 0x79, 0x42, 0xeb, 0xf6, 0x6c, 0x35, 0xac, 0x67, 0xf0, 0xb0, 0x69, 0x95, 0x2a, 0x3c, 0xe9, 0xc7, 0xe1, 0xf1, 0xb0, 0x2e, 0x48, 0x0a, 0x95, 0x00, 0x83, 0x6d, 0xe5, 0xd6, 0x4c, 0xdb, 0x7e, 0xcd, 0xe0, 0x45, 0x42, 0xf7, 0xa7, 0x99, 0x88, 0x78, 0x7e, 0x24, 0xc2, 0xba, 0x05, 0xf5, 0xfd, 0x48, 0x2c, 0x02, 0x3e, 0xd5, 0xc3, 0x0e, 0x04, 0x83, 0x9d, 0xc4, 0x4b, 0xed, 0x2a, 0x3a, 0x3a, 0x4f, 0xee, 0x01, 0x11, 0x3c, 0x89, 0x1a, 0x47, 0xd3, 0x2e, 0xb8, 0x02, 0x5c, 0x28, 0xcb, 0x05, 0x0b, 0x5c, 0xdb, 0x57, 0x6c, 0x70, 0xfe, 0x76, 0xef, 0x52, 0x34, 0x05, 0xc0, 0x84, 0x17, 0xfa, 0xf3, 0x50, 0xb0, 0x37, 0xa4, 0x3c, 0x37, 0x93, 0x39, 0xfc, 0xb1, 0x8d, 0x3a, 0x35, 0x6b }

}
,
{
  "RSASSA-PSS Signature Example 6.6",
  /* Message to be signed */
  139,
  { 0x99, 0x06, 0xd8, 0x9f, 0x97, 0xa9, 0xfd, 0xed, 0xd3, 0xcc, 0xd8, 0x24, 0xdb, 0x68, 0x73, 0x26, 0xf3, 0x0f, 0x00, 0xaa, 0x25, 0xa7, 0xfc, 0xa2, 0xaf, 0xcb, 0x3b, 0x0f, 0x86, 0xcd, 0x41, 0xe7, 0x3f, 0x0e, 0x8f, 0xf7, 0xd2, 0xd8, 0x3f, 0x59, 0xe2, 0x8e, 0xd3, 0x1a, 0x5a, 0x0d, 0x55, 0x15, 0x23, 0x37, 0x4d, 0xe2, 0x2e, 0x4c, 0x7e, 0x8f, 0xf5, 0x68, 0xb3, 0x86, 0xee, 0x3d, 0xc4, 0x11, 0x63, 0xf1, 0x0b, 0xf6, 0x7b, 0xb0, 0x06, 0x26, 0x1c, 0x90, 0x82, 0xf9, 0xaf, 0x90, 0xbf, 0x1d, 0x90, 0x49, 0xa6, 0xb9, 0xfa, 0xe7, 0x1c, 0x7f, 0x84, 0xfb, 0xe6, 0xe5, 0x5f, 0x02, 0x78, 0x9d, 0xe7, 0x74, 0xf2, 0x30, 0xf1, 0x15, 0x02, 0x6a, 0x4b, 0x4e, 0x96, 0xc5, 0x5b, 0x04, 0xa9, 0x5d, 0xa3, 0xaa, 0xcb, 0xb2, 0xce, 0xce, 0x8f, 0x81, 0x76, 0x4a, 0x1f, 0x1c, 0x99, 0x51, 0x54, 0x11, 0x08, 0x7c, 0xf7, 0xd3, 0x4a, 0xed, 0xed, 0x09, 0x32, 0xc1, 0x83 }
,
  /* Salt */
  20,
  { 0xfb, 0xbe, 0x05, 0x90, 0x25, 0xb6, 0x9b, 0x89, 0xfb, 0x14, 0xae, 0x22, 0x89, 0xe7, 0xaa, 0xaf, 0xe6, 0x0c, 0x0f, 0xcd }
,
  /* Signature */
  129,
  { 0x0a, 0x40, 0xa1, 0x6e, 0x2f, 0xe2, 0xb3, 0x8d, 0x1d, 0xf9, 0x05, 0x46, 0x16, 0x7c, 0xf9, 0x46, 0x9c, 0x9e, 0x3c, 0x36, 0x81, 0xa3, 0x44, 0x2b, 0x4b, 0x2c, 0x2f, 0x58, 0x1d, 0xeb, 0x38, 0x5c, 0xe9, 0x9f, 0xc6, 0x18, 0x8b, 0xb0, 0x2a, 0x84, 0x1d, 0x56, 0xe7, 0x6d, 0x30, 0x18, 0x91, 0xe2, 0x45, 0x60, 0x55, 0x0f, 0xcc, 0x2a, 0x26, 0xb5, 0x5f, 0x4c, 0xcb, 0x26, 0xd8, 0x37, 0xd3, 0x50, 0xa1, 0x54, 0xbc, 0xac, 0xa8, 0x39, 0x2d, 0x98, 0xfa, 0x67, 0x95, 0x9e, 0x97, 0x27, 0xb7, 0x8c, 0xad, 0x03, 0x26, 0x9f, 0x56, 0x96, 0x8f, 0xc5, 0x6b, 0x68, 0xbd, 0x67, 0x99, 0x26, 0xd8, 0x3c, 0xc9, 0xcb, 0x21, 0x55, 0x50, 0x64, 0x5c, 0xcd, 0xa3, 0x1c, 0x76, 0x0f, 0xf3, 0x58, 0x88, 0x94, 0x3d, 0x2d, 0x8a, 0x1d, 0x35, 0x1e, 0x81, 0xe5, 0xd0, 0x7b, 0x86, 0x18, 0x2e, 0x75, 0x10, 0x81, 0xef }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 7: A 1030-bit RSA Key Pair",
{
  /* RSA modulus n */
  129,
  { 0x37, 0xc9, 0xda, 0x4a, 0x66, 0xc8, 0xc4, 0x08, 0xb8, 0xda, 0x27, 0xd0, 0xc9, 0xd7, 0x9f, 0x8c, 0xcb, 0x1e, 0xaf, 0xc1, 0xd2, 0xfe, 0x48, 0x74, 0x6d, 0x94, 0x0b, 0x7c, 0x4e, 0xf5, 0xde, 0xe1, 0x8a, 0xd1, 0x26, 0x47, 0xce, 0xfa, 0xa0, 0xc4, 0xb3, 0x18, 0x8b, 0x22, 0x1c, 0x51, 0x53, 0x86, 0x75, 0x9b, 0x93, 0xf0, 0x20, 0x24, 0xb2, 0x5a, 0xb9, 0x24, 0x2f, 0x83, 0x57, 0xd8, 0xf3, 0xfd, 0x49, 0x64, 0x0e, 0xe5, 0xe6, 0x43, 0xea, 0xf6, 0xc6, 0x4d, 0xee, 0xfa, 0x70, 0x89, 0x72, 0x7c, 0x8f, 0xf0, 0x39, 0x93, 0x33, 0x39, 0x15, 0xc6, 0xef, 0x21, 0xbf, 0x59, 0x75, 0xb6, 0xe5, 0x0d, 0x11, 0x8b, 0x51, 0x00, 0x8e, 0xc3, 0x3e, 0x9f, 0x01, 0xa0, 0xa5, 0x45, 0xa1, 0x0a, 0x83, 0x6a, 0x43, 0xdd, 0xbc, 0xa9, 0xd8, 0xb5, 0xc5, 0xd3, 0x54, 0x80, 0x22, 0xd7, 0x06, 0x4e, 0xa2, 0x9a, 0xb3 }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  128,
  { 0x3b, 0xed, 0x99, 0x90, 0x52, 0xd9, 0x57, 0xbc, 0x06, 0xd6, 0x51, 0xee, 0xf6, 0xe3, 0xa9, 0x80, 0x94, 0xb1, 0x62, 0x1b, 0xd3, 0x8b, 0x54, 0x49, 0xbd, 0x6c, 0x4a, 0xea, 0x3d, 0xe7, 0xe0, 0x84, 0x67, 0x9a, 0x44, 0x84, 0xde, 0xd2, 0x5b, 0xe0, 0xf0, 0x82, 0x6c, 0xf3, 0x37, 0x78, 0x25, 0x41, 0x4b, 0x14, 0xd4, 0xd6, 0x1d, 0xb1, 0x4d, 0xe6, 0x26, 0xfb, 0xb8, 0x0e, 0x5f, 0x4f, 0xae, 0xc9, 0x56, 0xf9, 0xa0, 0xa2, 0xd2, 0x4f, 0x99, 0x57, 0x63, 0x80, 0xf0, 0x84, 0xeb, 0x62, 0xe4, 0x6a, 0x57, 0xd5, 0x54, 0x27, 0x8b, 0x53, 0x56, 0x26, 0x19, 0x3c, 0xe0, 0x20, 0x60, 0x57, 0x5e, 0xb6, 0x6c, 0x57, 0x98, 0xd3, 0x6f, 0x6c, 0x5d, 0x40, 0xfb, 0x00, 0xd8, 0x09, 0xb4, 0x2a, 0x73, 0x10, 0x2c, 0x1c, 0x74, 0xee, 0x95, 0xbd, 0x71, 0x42, 0x0f, 0xff, 0xef, 0x63, 0x18, 0xb5, 0x2c, 0x29 }
,
  /* Prime p */
  65,
  { 0x07, 0xee, 0xfb, 0x42, 0x4b, 0x0e, 0x3a, 0x40, 0xe4, 0x20, 0x8e, 0xe5, 0xaf, 0xb2, 0x80, 0xb2, 0x23, 0x17, 0x30, 0x81, 0x14, 0xdd, 0xe0, 0xb4, 0xb6, 0x4f, 0x73, 0x01, 0x84, 0xec, 0x68, 0xda, 0x6c, 0xe2, 0x86, 0x7a, 0x9f, 0x48, 0xed, 0x77, 0x26, 0xd5, 0xe2, 0x61, 0x4e, 0xd0, 0x4a, 0x54, 0x10, 0x73, 0x6c, 0x8c, 0x71, 0x4e, 0xe7, 0x02, 0x47, 0x42, 0x98, 0xc6, 0x29, 0x2a, 0xf0, 0x75, 0x35 }
,
  /* Prime q */
  65,
  { 0x07, 0x08, 0x30, 0xdb, 0xf9, 0x47, 0xea, 0xc0, 0x22, 0x8d, 0xe2, 0x63, 0x14, 0xb5, 0x9b, 0x66, 0x99, 0x4c, 0xc6, 0x0e, 0x83, 0x60, 0xe7, 0x5d, 0x38, 0x76, 0x29, 0x8f, 0x8f, 0x8a, 0x7d, 0x14, 0x1d, 0xa0, 0x64, 0xe5, 0xca, 0x02, 0x6a, 0x97, 0x3e, 0x28, 0xf2, 0x54, 0x73, 0x8c, 0xee, 0x66, 0x9c, 0x72, 0x1b, 0x03, 0x4c, 0xb5, 0xf8, 0xe2, 0x44, 0xda, 0xdd, 0x7c, 0xd1, 0xe1, 0x59, 0xd5, 0x47 }
,
  /* p's CRT exponent dP */
  65,
  { 0x05, 0x24, 0xd2, 0x0c, 0x3d, 0x95, 0xcf, 0xf7, 0x5a, 0xf2, 0x31, 0x34, 0x83, 0x22, 0x7d, 0x87, 0x02, 0x71, 0x7a, 0xa5, 0x76, 0xde, 0x15, 0x5f, 0x96, 0x05, 0x15, 0x50, 0x1a, 0xdb, 0x1d, 0x70, 0xe1, 0xc0, 0x4d, 0xe9, 0x1b, 0x75, 0xb1, 0x61, 0xdb, 0xf0, 0x39, 0x83, 0x56, 0x12, 0x7e, 0xde, 0xda, 0x7b, 0xbc, 0x19, 0xa3, 0x2d, 0xc1, 0x62, 0x1c, 0xc9, 0xf5, 0x3c, 0x26, 0x5d, 0x0c, 0xe3, 0x31 }
,
  /* q's CRT exponent dQ */
  65,
  { 0x05, 0xf9, 0x84, 0xa1, 0xf2, 0x3c, 0x93, 0x8d, 0x6a, 0x0e, 0x89, 0x72, 0x4b, 0xcf, 0x3d, 0xd9, 0x3f, 0x99, 0x46, 0x92, 0x60, 0x37, 0xfe, 0x7c, 0x6b, 0x13, 0xa2, 0x9e, 0x52, 0x84, 0x85, 0x5f, 0x89, 0x08, 0x95, 0x91, 0xd4, 0x40, 0x97, 0x56, 0x27, 0xbf, 0x5c, 0x9e, 0x3a, 0x8b, 0x5c, 0xa7, 0x9c, 0x77, 0x2a, 0xd2, 0x73, 0xe4, 0x0d, 0x32, 0x1a, 0xf4, 0xa6, 0xc9, 0x7d, 0xfd, 0xed, 0x78, 0xd3 }
,
  /* CRT coefficient qInv */
  64,
  { 0xdd, 0xd9, 0x18, 0xad, 0xad, 0xa2, 0x9d, 0xca, 0xb9, 0x81, 0xff, 0x9a, 0xcb, 0xa4, 0x25, 0x70, 0x23, 0xc0, 0x9a, 0x38, 0x01, 0xcc, 0xce, 0x09, 0x8c, 0xe2, 0x68, 0xf8, 0x55, 0xd0, 0xdf, 0x57, 0x0c, 0xd6, 0xe7, 0xb9, 0xb1, 0x4b, 0xd9, 0xa5, 0xa9, 0x25, 0x4c, 0xbc, 0x31, 0x5b, 0xe6, 0xf8, 0xba, 0x1e, 0x25, 0x46, 0xdd, 0xd5, 0x69, 0xc5, 0xea, 0x19, 0xee, 0xd8, 0x35, 0x3b, 0xde, 0x5e }

}
,
{{
  "RSASSA-PSS Signature Example 7.1",
  /* Message to be signed */
  255,
  { 0x9e, 0xad, 0x0e, 0x01, 0x94, 0x56, 0x40, 0x67, 0x4e, 0xb4, 0x1c, 0xad, 0x43, 0x5e, 0x23, 0x74, 0xea, 0xef, 0xa8, 0xad, 0x71, 0x97, 0xd9, 0x79, 0x13, 0xc4, 0x49, 0x57, 0xd8, 0xd8, 0x3f, 0x40, 0xd7, 0x6e, 0xe6, 0x0e, 0x39, 0xbf, 0x9c, 0x0f, 0x9e, 0xaf, 0x30, 0x21, 0x42, 0x1a, 0x07, 0x4d, 0x1a, 0xde, 0x96, 0x2c, 0x6e, 0x9d, 0x3d, 0xc3, 0xbb, 0x17, 0x4f, 0xe4, 0xdf, 0xe6, 0x52, 0xb0, 0x91, 0x15, 0x49, 0x5b, 0x8f, 0xd2, 0x79, 0x41, 0x74, 0x02, 0x0a, 0x06, 0x02, 0xb5, 0xca, 0x51, 0x84, 0x8c, 0xfc, 0x96, 0xce, 0x5e, 0xb5, 0x7f, 0xc0, 0xa2, 0xad, 0xc1, 0xdd, 0xa3, 0x6a, 0x7c, 0xc4, 0x52, 0x64, 0x1a, 0x14, 0x91, 0x1b, 0x37, 0xe4, 0x5b, 0xfa, 0x11, 0xda, 0xa5, 0xc7, 0xec, 0xdb, 0x74, 0xf6, 0xd0, 0x10, 0x0d, 0x1d, 0x3e, 0x39, 0xe7, 0x52, 0x80, 0x0e, 0x20, 0x33, 0x97, 0xde, 0x02, 0x33, 0x07, 0x7b, 0x9a, 0x88, 0x85, 0x55, 0x37, 0xfa, 0xe9, 0x27, 0xf9, 0x24, 0x38, 0x0d, 0x78, 0x0f, 0x98, 0xe1, 0x8d, 0xcf, 0xf3, 0x9c, 0x5e, 0xa7, 0x41, 0xb1, 0x7d, 0x6f, 0xdd, 0x18, 0x85, 0xbc, 0x9d, 0x58, 0x14, 0x82, 0xd7, 0x71, 0xce, 0xb5, 0x62, 0xd7, 0x8a, 0x8b, 0xf8, 0x8f, 0x0c, 0x75, 0xb1, 0x13, 0x63, 0xe5, 0xe3, 0x6c, 0xd4, 0x79, 0xce, 0xb0, 0x54, 0x5f, 0x9d, 0xa8, 0x42, 0x03, 0xe0, 0xe6, 0xe5, 0x08, 0x37, 0x5c, 0xc9, 0xe8, 0x44, 0xb8, 0x8b, 0x7a, 0xc7, 0xa0, 0xa2, 0x01, 0xea, 0x0f, 0x1b, 0xee, 0x9a, 0x2c, 0x57, 0x79, 0x20, 0xca, 0x02, 0xc0, 0x1b, 0x9d, 0x83, 0x20, 0xe9, 0x74, 0xa5, 0x6f, 0x4e, 0xfb, 0x57, 0x63, 0xb9, 0x62, 0x55, 0xab, 0xbf, 0x80, 0x37, 0xbf, 0x18, 0x02, 0xcf, 0x01, 0x8f, 0x56, 0x37, 0x94, 0x93, 0xe5, 0x69, 0xa9 }
,
  /* Salt */
  20,
  { 0xb7, 0x86, 0x7a, 0x59, 0x95, 0x8c, 0xb5, 0x43, 0x28, 0xf8, 0x77, 0x5e, 0x65, 0x46, 0xec, 0x06, 0xd2, 0x7e, 0xaa, 0x50 }
,
  /* Signature */
  129,
  { 0x18, 0x7f, 0x39, 0x07, 0x23, 0xc8, 0x90, 0x25, 0x91, 0xf0, 0x15, 0x4b, 0xae, 0x6d, 0x4e, 0xcb, 0xff, 0xe0, 0x67, 0xf0, 0xe8, 0xb7, 0x95, 0x47, 0x6e, 0xa4, 0xf4, 0xd5, 0x1c, 0xcc, 0x81, 0x05, 0x20, 0xbb, 0x3c, 0xa9, 0xbc, 0xa7, 0xd0, 0xb1, 0xf2, 0xea, 0x8a, 0x17, 0xd8, 0x73, 0xfa, 0x27, 0x57, 0x0a, 0xcd, 0x64, 0x2e, 0x38, 0x08, 0x56, 0x1c, 0xb9, 0xe9, 0x75, 0xcc, 0xfd, 0x80, 0xb2, 0x3d, 0xc5, 0x77, 0x1c, 0xdb, 0x33, 0x06, 0xa5, 0xf2, 0x31, 0x59, 0xda, 0xcb, 0xd3, 0xaa, 0x2d, 0xb9, 0x3d, 0x46, 0xd7, 0x66, 0xe0, 0x9e, 0xd1, 0x5d, 0x90, 0x0a, 0xd8, 0x97, 0xa8, 0xd2, 0x74, 0xdc, 0x26, 0xb4, 0x7e, 0x99, 0x4a, 0x27, 0xe9, 0x7e, 0x22, 0x68, 0xa7, 0x66, 0x53, 0x3a, 0xe4, 0xb5, 0xe4, 0x2a, 0x2f, 0xca, 0xf7, 0x55, 0xc1, 0xc4, 0x79, 0x4b, 0x29, 0x4c, 0x60, 0x55, 0x58, 0x23 }

}
,
#ifdef LTC_TEST_EXT
{
  "RSASSA-PSS Signature Example 7.2",
  /* Message to be signed */
  57,
  { 0x8d, 0x80, 0xd2, 0xd0, 0x8d, 0xbd, 0x19, 0xc1, 0x54, 0xdf, 0x3f, 0x14, 0x67, 0x3a, 0x14, 0xbd, 0x03, 0x73, 0x52, 0x31, 0xf2, 0x4e, 0x86, 0xbf, 0x15, 0x3d, 0x0e, 0x69, 0xe7, 0x4c, 0xbf, 0xf7, 0xb1, 0x83, 0x6e, 0x66, 0x4d, 0xe8, 0x3f, 0x68, 0x01, 0x24, 0x37, 0x0f, 0xc0, 0xf9, 0x6c, 0x9b, 0x65, 0xc0, 0x7a, 0x36, 0x6b, 0x64, 0x4c, 0x4a, 0xb3 }
,
  /* Salt */
  20,
  { 0x0c, 0x09, 0x58, 0x22, 0x66, 0xdf, 0x08, 0x63, 0x10, 0x82, 0x1b, 0xa7, 0xe1, 0x8d, 0xf6, 0x4d, 0xfe, 0xe6, 0xde, 0x09 }
,
  /* Signature */
  129,
  { 0x10, 0xfd, 0x89, 0x76, 0x8a, 0x60, 0xa6, 0x77, 0x88, 0xab, 0xb5, 0x85, 0x6a, 0x78, 0x7c, 0x85, 0x61, 0xf3, 0xed, 0xcf, 0x9a, 0x83, 0xe8, 0x98, 0xf7, 0xdc, 0x87, 0xab, 0x8c, 0xce, 0x79, 0x42, 0x9b, 0x43, 0xe5, 0x69, 0x06, 0x94, 0x1a, 0x88, 0x61, 0x94, 0xf1, 0x37, 0xe5, 0x91, 0xfe, 0x7c, 0x33, 0x95, 0x55, 0x36, 0x1f, 0xbb, 0xe1, 0xf2, 0x4f, 0xeb, 0x2d, 0x4b, 0xcd, 0xb8, 0x06, 0x01, 0xf3, 0x09, 0x6b, 0xc9, 0x13, 0x2d, 0xee, 0xa6, 0x0a, 0xe1, 0x30, 0x82, 0xf4, 0x4f, 0x9a, 0xd4, 0x1c, 0xd6, 0x28, 0x93, 0x6a, 0x4d, 0x51, 0x17, 0x6e, 0x42, 0xfc, 0x59, 0xcb, 0x76, 0xdb, 0x81, 0x5c, 0xe5, 0xab, 0x4d, 0xb9, 0x9a, 0x10, 0x4a, 0xaf, 0xea, 0x68, 0xf5, 0xd3, 0x30, 0x32, 0x9e, 0xbf, 0x25, 0x8d, 0x4e, 0xde, 0x16, 0x06, 0x4b, 0xd1, 0xd0, 0x03, 0x93, 0xd5, 0xe1, 0x57, 0x0e, 0xb8 }

}
,
{
  "RSASSA-PSS Signature Example 7.3",
  /* Message to be signed */
  92,
  { 0x80, 0x84, 0x05, 0xcd, 0xfc, 0x1a, 0x58, 0xb9, 0xbb, 0x03, 0x97, 0xc7, 0x20, 0x72, 0x2a, 0x81, 0xff, 0xfb, 0x76, 0x27, 0x8f, 0x33, 0x59, 0x17, 0xef, 0x9c, 0x47, 0x38, 0x14, 0xb3, 0xe0, 0x16, 0xba, 0x29, 0x73, 0xcd, 0x27, 0x65, 0xf8, 0xf3, 0xf8, 0x2d, 0x6c, 0xc3, 0x8a, 0xa7, 0xf8, 0x55, 0x18, 0x27, 0xfe, 0x8d, 0x1e, 0x38, 0x84, 0xb7, 0xe6, 0x1c, 0x94, 0x68, 0x3b, 0x8f, 0x82, 0xf1, 0x84, 0x3b, 0xda, 0xe2, 0x25, 0x7e, 0xee, 0xc9, 0x81, 0x2a, 0xd4, 0xc2, 0xcf, 0x28, 0x3c, 0x34, 0xe0, 0xb0, 0xae, 0x0f, 0xe3, 0xcb, 0x99, 0x0c, 0xf8, 0x8f, 0x2e, 0xf9 }
,
  /* Salt */
  20,
  { 0x28, 0x03, 0x9d, 0xcf, 0xe1, 0x06, 0xd3, 0xb8, 0x29, 0x66, 0x11, 0x25, 0x8c, 0x4a, 0x56, 0x65, 0x1c, 0x9e, 0x92, 0xdd }
,
  /* Signature */
  129,
  { 0x2b, 0x31, 0xfd, 0xe9, 0x98, 0x59, 0xb9, 0x77, 0xaa, 0x09, 0x58, 0x6d, 0x8e, 0x27, 0x46, 0x62, 0xb2, 0x5a, 0x2a, 0x64, 0x06, 0x40, 0xb4, 0x57, 0xf5, 0x94, 0x05, 0x1c, 0xb1, 0xe7, 0xf7, 0xa9, 0x11, 0x86, 0x54, 0x55, 0x24, 0x29, 0x26, 0xcf, 0x88, 0xfe, 0x80, 0xdf, 0xa3, 0xa7, 0x5b, 0xa9, 0x68, 0x98, 0x44, 0xa1, 0x1e, 0x63, 0x4a, 0x82, 0xb0, 0x75, 0xaf, 0xbd, 0x69, 0xc1, 0x2a, 0x0d, 0xf9, 0xd2, 0x5f, 0x84, 0xad, 0x49, 0x45, 0xdf, 0x3d, 0xc8, 0xfe, 0x90, 0xc3, 0xce, 0xfd, 0xf2, 0x6e, 0x95, 0xf0, 0x53, 0x43, 0x04, 0xb5, 0xbd, 0xba, 0x20, 0xd3, 0xe5, 0x64, 0x0a, 0x2e, 0xbf, 0xb8, 0x98, 0xaa, 0xc3, 0x5a, 0xe4, 0x0f, 0x26, 0xfc, 0xe5, 0x56, 0x3c, 0x2f, 0x9f, 0x24, 0xf3, 0x04, 0x2a, 0xf7, 0x6f, 0x3c, 0x70, 0x72, 0xd6, 0x87, 0xbb, 0xfb, 0x95, 0x9a, 0x88, 0x46, 0x0a, 0xf1 }

}
,
{
  "RSASSA-PSS Signature Example 7.4",
  /* Message to be signed */
  231,
  { 0xf3, 0x37, 0xb9, 0xba, 0xd9, 0x37, 0xde, 0x22, 0xa1, 0xa0, 0x52, 0xdf, 0xf1, 0x11, 0x34, 0xa8, 0xce, 0x26, 0x97, 0x62, 0x02, 0x98, 0x19, 0x39, 0xb9, 0x1e, 0x07, 0x15, 0xae, 0x5e, 0x60, 0x96, 0x49, 0xda, 0x1a, 0xdf, 0xce, 0xf3, 0xf4, 0xcc, 0xa5, 0x9b, 0x23, 0x83, 0x60, 0xe7, 0xd1, 0xe4, 0x96, 0xc7, 0xbf, 0x4b, 0x20, 0x4b, 0x5a, 0xcf, 0xf9, 0xbb, 0xd6, 0x16, 0x6a, 0x1d, 0x87, 0xa3, 0x6e, 0xf2, 0x24, 0x73, 0x73, 0x75, 0x10, 0x39, 0xf8, 0xa8, 0x00, 0xb8, 0x39, 0x98, 0x07, 0xb3, 0xa8, 0x5f, 0x44, 0x89, 0x34, 0x97, 0xc0, 0xd0, 0x5f, 0xb7, 0x01, 0x7b, 0x82, 0x22, 0x81, 0x52, 0xde, 0x6f, 0x25, 0xe6, 0x11, 0x6d, 0xcc, 0x75, 0x03, 0xc7, 0x86, 0xc8, 0x75, 0xc2, 0x8f, 0x3a, 0xa6, 0x07, 0xe9, 0x4a, 0xb0, 0xf1, 0x98, 0x63, 0xab, 0x1b, 0x50, 0x73, 0x77, 0x0b, 0x0c, 0xd5, 0xf5, 0x33, 0xac, 0xde, 0x30, 0xc6, 0xfb, 0x95, 0x3c, 0xf3, 0xda, 0x68, 0x02, 0x64, 0xe3, 0x0f, 0xc1, 0x1b, 0xff, 0x9a, 0x19, 0xbf, 0xfa, 0xb4, 0x77, 0x9b, 0x62, 0x23, 0xc3, 0xfb, 0x3f, 0xe0, 0xf7, 0x1a, 0xba, 0xde, 0x4e, 0xb7, 0xc0, 0x9c, 0x41, 0xe2, 0x4c, 0x22, 0xd2, 0x3f, 0xa1, 0x48, 0xe6, 0xa1, 0x73, 0xfe, 0xb6, 0x39, 0x84, 0xd1, 0xbc, 0x6e, 0xe3, 0xa0, 0x2d, 0x91, 0x5b, 0x75, 0x2c, 0xea, 0xf9, 0x2a, 0x30, 0x15, 0xec, 0xeb, 0x38, 0xca, 0x58, 0x6c, 0x68, 0x01, 0xb3, 0x7c, 0x34, 0xce, 0xfb, 0x2c, 0xff, 0x25, 0xea, 0x23, 0xc0, 0x86, 0x62, 0xdc, 0xab, 0x26, 0xa7, 0xa9, 0x3a, 0x28, 0x5d, 0x05, 0xd3, 0x04, 0x4c }
,
  /* Salt */
  20,
  { 0xa7, 0x78, 0x21, 0xeb, 0xbb, 0xef, 0x24, 0x62, 0x8e, 0x4e, 0x12, 0xe1, 0xd0, 0xea, 0x96, 0xde, 0x39, 0x8f, 0x7b, 0x0f }
,
  /* Signature */
  129,
  { 0x32, 0xc7, 0xca, 0x38, 0xff, 0x26, 0x94, 0x9a, 0x15, 0x00, 0x0c, 0x4b, 0xa0, 0x4b, 0x2b, 0x13, 0xb3, 0x5a, 0x38, 0x10, 0xe5, 0x68, 0x18, 0x4d, 0x7e, 0xca, 0xba, 0xa1, 0x66, 0xb7, 0xff, 0xab, 0xdd, 0xf2, 0xb6, 0xcf, 0x4b, 0xa0, 0x71, 0x24, 0x92, 0x37, 0x90, 0xf2, 0xe5, 0xb1, 0xa5, 0xbe, 0x04, 0x0a, 0xea, 0x36, 0xfe, 0x13, 0x2e, 0xc1, 0x30, 0xe1, 0xf1, 0x05, 0x67, 0x98, 0x2d, 0x17, 0xac, 0x3e, 0x89, 0xb8, 0xd2, 0x6c, 0x30, 0x94, 0x03, 0x4e, 0x76, 0x2d, 0x2e, 0x03, 0x12, 0x64, 0xf0, 0x11, 0x70, 0xbe, 0xec, 0xb3, 0xd1, 0x43, 0x9e, 0x05, 0x84, 0x6f, 0x25, 0x45, 0x83, 0x67, 0xa7, 0xd9, 0xc0, 0x20, 0x60, 0x44, 0x46, 0x72, 0x67, 0x1e, 0x64, 0xe8, 0x77, 0x86, 0x45, 0x59, 0xca, 0x19, 0xb2, 0x07, 0x4d, 0x58, 0x8a, 0x28, 0x1b, 0x58, 0x04, 0xd2, 0x37, 0x72, 0xfb, 0xbe, 0x19 }

}
,
{
  "RSASSA-PSS Signature Example 7.5",
  /* Message to be signed */
  51,
  { 0x45, 0x01, 0x3c, 0xeb, 0xaf, 0xd9, 0x60, 0xb2, 0x55, 0x47, 0x6a, 0x8e, 0x25, 0x98, 0xb9, 0xaa, 0x32, 0xef, 0xbe, 0x6d, 0xc1, 0xf3, 0x4f, 0x4a, 0x49, 0x8d, 0x8c, 0xf5, 0xa2, 0xb4, 0x54, 0x8d, 0x08, 0xc5, 0x5d, 0x5f, 0x95, 0xf7, 0xbc, 0xc9, 0x61, 0x91, 0x63, 0x05, 0x6f, 0x2d, 0x58, 0xb5, 0x2f, 0xa0, 0x32 }
,
  /* Salt */
  20,
  { 0x9d, 0x5a, 0xd8, 0xeb, 0x45, 0x21, 0x34, 0xb6, 0x5d, 0xc3, 0xa9, 0x8b, 0x6a, 0x73, 0xb5, 0xf7, 0x41, 0x60, 0x9c, 0xd6 }
,
  /* Signature */
  129,
  { 0x07, 0xeb, 0x65, 0x1d, 0x75, 0xf1, 0xb5, 0x2b, 0xc2, 0x63, 0xb2, 0xe1, 0x98, 0x33, 0x6e, 0x99, 0xfb, 0xeb, 0xc4, 0xf3, 0x32, 0x04, 0x9a, 0x92, 0x2a, 0x10, 0x81, 0x56, 0x07, 0xee, 0x2d, 0x98, 0x9d, 0xb3, 0xa4, 0x49, 0x5b, 0x7d, 0xcc, 0xd3, 0x8f, 0x58, 0xa2, 0x11, 0xfb, 0x7e, 0x19, 0x31, 0x71, 0xa3, 0xd8, 0x91, 0x13, 0x24, 0x37, 0xeb, 0xca, 0x44, 0xf3, 0x18, 0xb2, 0x80, 0x50, 0x9e, 0x52, 0xb5, 0xfa, 0x98, 0xfc, 0xce, 0x82, 0x05, 0xd9, 0x69, 0x7c, 0x8e, 0xe4, 0xb7, 0xff, 0x59, 0xd4, 0xc5, 0x9c, 0x79, 0x03, 0x8a, 0x19, 0x70, 0xbd, 0x2a, 0x0d, 0x45, 0x1e, 0xcd, 0xc5, 0xef, 0x11, 0xd9, 0x97, 0x9c, 0x9d, 0x35, 0xf8, 0xc7, 0x0a, 0x61, 0x63, 0x71, 0x76, 0x07, 0x89, 0x0d, 0x58, 0x6a, 0x7c, 0x6d, 0xc0, 0x1c, 0x79, 0xf8, 0x6a, 0x8f, 0x28, 0xe8, 0x52, 0x35, 0xf8, 0xc2, 0xf1 }

}
,
{
  "RSASSA-PSS Signature Example 7.6",
  /* Message to be signed */
  184,
  { 0x23, 0x58, 0x09, 0x70, 0x86, 0xc8, 0x99, 0x32, 0x3e, 0x75, 0xd9, 0xc9, 0x0d, 0x0c, 0x09, 0xf1, 0x2d, 0x9d, 0x54, 0xed, 0xfb, 0xdf, 0x70, 0xa9, 0xc2, 0xeb, 0x5a, 0x04, 0xd8, 0xf3, 0x6b, 0x9b, 0x2b, 0xdf, 0x2a, 0xab, 0xe0, 0xa5, 0xbd, 0xa1, 0x96, 0x89, 0x37, 0xf9, 0xd6, 0xeb, 0xd3, 0xb6, 0xb2, 0x57, 0xef, 0xb3, 0x13, 0x6d, 0x41, 0x31, 0xf9, 0xac, 0xb5, 0x9b, 0x85, 0xe2, 0x60, 0x2c, 0x2a, 0x3f, 0xcd, 0xc8, 0x35, 0x49, 0x4a, 0x1f, 0x4e, 0x5e, 0xc1, 0x8b, 0x22, 0x6c, 0x80, 0x23, 0x2b, 0x36, 0xa7, 0x5a, 0x45, 0xfd, 0xf0, 0x9a, 0x7e, 0xa9, 0xe9, 0x8e, 0xfb, 0xde, 0x14, 0x50, 0xd1, 0x19, 0x4b, 0xf1, 0x2e, 0x15, 0xa4, 0xc5, 0xf9, 0xeb, 0x5c, 0x0b, 0xce, 0x52, 0x69, 0xe0, 0xc3, 0xb2, 0x8c, 0xfa, 0xb6, 0x55, 0xd8, 0x1a, 0x61, 0xa2, 0x0b, 0x4b, 0xe2, 0xf5, 0x44, 0x59, 0xbb, 0x25, 0xa0, 0xdb, 0x94, 0xc5, 0x22, 0x18, 0xbe, 0x10, 0x9a, 0x74, 0x26, 0xde, 0x83, 0x01, 0x44, 0x24, 0x78, 0x9a, 0xaa, 0x90, 0xe5, 0x05, 0x6e, 0x63, 0x2a, 0x69, 0x81, 0x15, 0xe2, 0x82, 0xc1, 0xa5, 0x64, 0x10, 0xf2, 0x6c, 0x20, 0x72, 0xf1, 0x93, 0x48, 0x1a, 0x9d, 0xcd, 0x88, 0x05, 0x72, 0x00, 0x5e, 0x64, 0xf4, 0x08, 0x2e, 0xcf }
,
  /* Salt */
  20,
  { 0x3f, 0x2e, 0xfc, 0x59, 0x58, 0x80, 0xa7, 0xd4, 0x7f, 0xcf, 0x3c, 0xba, 0x04, 0x98, 0x3e, 0xa5, 0x4c, 0x4b, 0x73, 0xfb }
,
  /* Signature */
  129,
  { 0x18, 0xda, 0x3c, 0xdc, 0xfe, 0x79, 0xbf, 0xb7, 0x7f, 0xd9, 0xc3, 0x2f, 0x37, 0x7a, 0xd3, 0x99, 0x14, 0x6f, 0x0a, 0x8e, 0x81, 0x06, 0x20, 0x23, 0x32, 0x71, 0xa6, 0xe3, 0xed, 0x32, 0x48, 0x90, 0x3f, 0x5c, 0xdc, 0x92, 0xdc, 0x79, 0xb5, 0x5d, 0x3e, 0x11, 0x61, 0x5a, 0xa0, 0x56, 0xa7, 0x95, 0x85, 0x37, 0x92, 0xa3, 0x99, 0x8c, 0x34, 0x9c, 0xa5, 0xc4, 0x57, 0xe8, 0xca, 0x7d, 0x29, 0xd7, 0x96, 0xaa, 0x24, 0xf8, 0x34, 0x91, 0x70, 0x9b, 0xef, 0xcf, 0xb1, 0x51, 0x0e, 0xa5, 0x13, 0xc9, 0x28, 0x29, 0xa3, 0xf0, 0x0b, 0x10, 0x4f, 0x65, 0x56, 0x34, 0xf3, 0x20, 0x75, 0x2e, 0x13, 0x0e, 0xc0, 0xcc, 0xf6, 0x75, 0x4f, 0xf8, 0x93, 0xdb, 0x30, 0x29, 0x32, 0xbb, 0x02, 0x5e, 0xb6, 0x0e, 0x87, 0x82, 0x25, 0x98, 0xfc, 0x61, 0x9e, 0x0e, 0x98, 0x17, 0x37, 0xa9, 0xa4, 0xc4, 0x15, 0x2d, 0x33 }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 8: A 1031-bit RSA Key Pair",
{
  /* RSA modulus n */
  129,
  { 0x49, 0x53, 0x70, 0xa1, 0xfb, 0x18, 0x54, 0x3c, 0x16, 0xd3, 0x63, 0x1e, 0x31, 0x63, 0x25, 0x5d, 0xf6, 0x2b, 0xe6, 0xee, 0xe8, 0x90, 0xd5, 0xf2, 0x55, 0x09, 0xe4, 0xf7, 0x78, 0xa8, 0xea, 0x6f, 0xbb, 0xbc, 0xdf, 0x85, 0xdf, 0xf6, 0x4e, 0x0d, 0x97, 0x20, 0x03, 0xab, 0x36, 0x81, 0xfb, 0xba, 0x6d, 0xd4, 0x1f, 0xd5, 0x41, 0x82, 0x9b, 0x2e, 0x58, 0x2d, 0xe9, 0xf2, 0xa4, 0xa4, 0xe0, 0xa2, 0xd0, 0x90, 0x0b, 0xef, 0x47, 0x53, 0xdb, 0x3c, 0xee, 0x0e, 0xe0, 0x6c, 0x7d, 0xfa, 0xe8, 0xb1, 0xd5, 0x3b, 0x59, 0x53, 0x21, 0x8f, 0x9c, 0xce, 0xea, 0x69, 0x5b, 0x08, 0x66, 0x8e, 0xde, 0xaa, 0xdc, 0xed, 0x94, 0x63, 0xb1, 0xd7, 0x90, 0xd5, 0xeb, 0xf2, 0x7e, 0x91, 0x15, 0xb4, 0x6c, 0xad, 0x4d, 0x9a, 0x2b, 0x8e, 0xfa, 0xb0, 0x56, 0x1b, 0x08, 0x10, 0x34, 0x47, 0x39, 0xad, 0xa0, 0x73, 0x3f }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  128,
  { 0x6c, 0x66, 0xff, 0xe9, 0x89, 0x80, 0xc3, 0x8f, 0xcd, 0xea, 0xb5, 0x15, 0x98, 0x98, 0x83, 0x61, 0x65, 0xf4, 0xb4, 0xb8, 0x17, 0xc4, 0xf6, 0xa8, 0xd4, 0x86, 0xee, 0x4e, 0xa9, 0x13, 0x0f, 0xe9, 0xb9, 0x09, 0x2b, 0xd1, 0x36, 0xd1, 0x84, 0xf9, 0x5f, 0x50, 0x4a, 0x60, 0x7e, 0xac, 0x56, 0x58, 0x46, 0xd2, 0xfd, 0xd6, 0x59, 0x7a, 0x89, 0x67, 0xc7, 0x39, 0x6e, 0xf9, 0x5a, 0x6e, 0xee, 0xbb, 0x45, 0x78, 0xa6, 0x43, 0x96, 0x6d, 0xca, 0x4d, 0x8e, 0xe3, 0xde, 0x84, 0x2d, 0xe6, 0x32, 0x79, 0xc6, 0x18, 0x15, 0x9c, 0x1a, 0xb5, 0x4a, 0x89, 0x43, 0x7b, 0x6a, 0x61, 0x20, 0xe4, 0x93, 0x0a, 0xfb, 0x52, 0xa4, 0xba, 0x6c, 0xed, 0x8a, 0x49, 0x47, 0xac, 0x64, 0xb3, 0x0a, 0x34, 0x97, 0xcb, 0xe7, 0x01, 0xc2, 0xd6, 0x26, 0x6d, 0x51, 0x72, 0x19, 0xad, 0x0e, 0xc6, 0xd3, 0x47, 0xdb, 0xe9 }
,
  /* Prime p */
  65,
  { 0x08, 0xda, 0xd7, 0xf1, 0x13, 0x63, 0xfa, 0xa6, 0x23, 0xd5, 0xd6, 0xd5, 0xe8, 0xa3, 0x19, 0x32, 0x8d, 0x82, 0x19, 0x0d, 0x71, 0x27, 0xd2, 0x84, 0x6c, 0x43, 0x9b, 0x0a, 0xb7, 0x26, 0x19, 0xb0, 0xa4, 0x3a, 0x95, 0x32, 0x0e, 0x4e, 0xc3, 0x4f, 0xc3, 0xa9, 0xce, 0xa8, 0x76, 0x42, 0x23, 0x05, 0xbd, 0x76, 0xc5, 0xba, 0x7b, 0xe9, 0xe2, 0xf4, 0x10, 0xc8, 0x06, 0x06, 0x45, 0xa1, 0xd2, 0x9e, 0xdb }
,
  /* Prime q */
  65,
  { 0x08, 0x47, 0xe7, 0x32, 0x37, 0x6f, 0xc7, 0x90, 0x0f, 0x89, 0x8e, 0xa8, 0x2e, 0xb2, 0xb0, 0xfc, 0x41, 0x85, 0x65, 0xfd, 0xae, 0x62, 0xf7, 0xd9, 0xec, 0x4c, 0xe2, 0x21, 0x7b, 0x97, 0x99, 0x0d, 0xd2, 0x72, 0xdb, 0x15, 0x7f, 0x99, 0xf6, 0x3c, 0x0d, 0xcb, 0xb9, 0xfb, 0xac, 0xdb, 0xd4, 0xc4, 0xda, 0xdb, 0x6d, 0xf6, 0x77, 0x56, 0x35, 0x8c, 0xa4, 0x17, 0x48, 0x25, 0xb4, 0x8f, 0x49, 0x70, 0x6d }
,
  /* p's CRT exponent dP */
  65,
  { 0x05, 0xc2, 0xa8, 0x3c, 0x12, 0x4b, 0x36, 0x21, 0xa2, 0xaa, 0x57, 0xea, 0x2c, 0x3e, 0xfe, 0x03, 0x5e, 0xff, 0x45, 0x60, 0xf3, 0x3d, 0xde, 0xbb, 0x7a, 0xda, 0xb8, 0x1f, 0xce, 0x69, 0xa0, 0xc8, 0xc2, 0xed, 0xc1, 0x65, 0x20, 0xdd, 0xa8, 0x3d, 0x59, 0xa2, 0x3b, 0xe8, 0x67, 0x96, 0x3a, 0xc6, 0x5f, 0x2c, 0xc7, 0x10, 0xbb, 0xcf, 0xb9, 0x6e, 0xe1, 0x03, 0xde, 0xb7, 0x71, 0xd1, 0x05, 0xfd, 0x85 }
,
  /* q's CRT exponent dQ */
  65,
  { 0x04, 0xca, 0xe8, 0xaa, 0x0d, 0x9f, 0xaa, 0x16, 0x5c, 0x87, 0xb6, 0x82, 0xec, 0x14, 0x0b, 0x8e, 0xd3, 0xb5, 0x0b, 0x24, 0x59, 0x4b, 0x7a, 0x3b, 0x2c, 0x22, 0x0b, 0x36, 0x69, 0xbb, 0x81, 0x9f, 0x98, 0x4f, 0x55, 0x31, 0x0a, 0x1a, 0xe7, 0x82, 0x36, 0x51, 0xd4, 0xa0, 0x2e, 0x99, 0x44, 0x79, 0x72, 0x59, 0x51, 0x39, 0x36, 0x34, 0x34, 0xe5, 0xe3, 0x0a, 0x7e, 0x7d, 0x24, 0x15, 0x51, 0xe1, 0xb9 }
,
  /* CRT coefficient qInv */
  65,
  { 0x07, 0xd3, 0xe4, 0x7b, 0xf6, 0x86, 0x60, 0x0b, 0x11, 0xac, 0x28, 0x3c, 0xe8, 0x8d, 0xbb, 0x3f, 0x60, 0x51, 0xe8, 0xef, 0xd0, 0x46, 0x80, 0xe4, 0x4c, 0x17, 0x1e, 0xf5, 0x31, 0xb8, 0x0b, 0x2b, 0x7c, 0x39, 0xfc, 0x76, 0x63, 0x20, 0xe2, 0xcf, 0x15, 0xd8, 0xd9, 0x98, 0x20, 0xe9, 0x6f, 0xf3, 0x0d, 0xc6, 0x96, 0x91, 0x83, 0x9c, 0x4b, 0x40, 0xd7, 0xb0, 0x6e, 0x45, 0x30, 0x7d, 0xc9, 0x1f, 0x3f }

}
,
{{
  "RSASSA-PSS Signature Example 8.1",
  /* Message to be signed */
  172,
  { 0x81, 0x33, 0x2f, 0x4b, 0xe6, 0x29, 0x48, 0x41, 0x5e, 0xa1, 0xd8, 0x99, 0x79, 0x2e, 0xea, 0xcf, 0x6c, 0x6e, 0x1d, 0xb1, 0xda, 0x8b, 0xe1, 0x3b, 0x5c, 0xea, 0x41, 0xdb, 0x2f, 0xed, 0x46, 0x70, 0x92, 0xe1, 0xff, 0x39, 0x89, 0x14, 0xc7, 0x14, 0x25, 0x97, 0x75, 0xf5, 0x95, 0xf8, 0x54, 0x7f, 0x73, 0x56, 0x92, 0xa5, 0x75, 0xe6, 0x92, 0x3a, 0xf7, 0x8f, 0x22, 0xc6, 0x99, 0x7d, 0xdb, 0x90, 0xfb, 0x6f, 0x72, 0xd7, 0xbb, 0x0d, 0xd5, 0x74, 0x4a, 0x31, 0xde, 0xcd, 0x3d, 0xc3, 0x68, 0x58, 0x49, 0x83, 0x6e, 0xd3, 0x4a, 0xec, 0x59, 0x63, 0x04, 0xad, 0x11, 0x84, 0x3c, 0x4f, 0x88, 0x48, 0x9f, 0x20, 0x97, 0x35, 0xf5, 0xfb, 0x7f, 0xda, 0xf7, 0xce, 0xc8, 0xad, 0xdc, 0x58, 0x18, 0x16, 0x8f, 0x88, 0x0a, 0xcb, 0xf4, 0x90, 0xd5, 0x10, 0x05, 0xb7, 0xa8, 0xe8, 0x4e, 0x43, 0xe5, 0x42, 0x87, 0x97, 0x75, 0x71, 0xdd, 0x99, 0xee, 0xa4, 0xb1, 0x61, 0xeb, 0x2d, 0xf1, 0xf5, 0x10, 0x8f, 0x12, 0xa4, 0x14, 0x2a, 0x83, 0x32, 0x2e, 0xdb, 0x05, 0xa7, 0x54, 0x87, 0xa3, 0x43, 0x5c, 0x9a, 0x78, 0xce, 0x53, 0xed, 0x93, 0xbc, 0x55, 0x08, 0x57, 0xd7, 0xa9, 0xfb }
,
  /* Salt */
  20,
  { 0x1d, 0x65, 0x49, 0x1d, 0x79, 0xc8, 0x64, 0xb3, 0x73, 0x00, 0x9b, 0xe6, 0xf6, 0xf2, 0x46, 0x7b, 0xac, 0x4c, 0x78, 0xfa }
,
  /* Signature */
  129,
  { 0x02, 0x62, 0xac, 0x25, 0x4b, 0xfa, 0x77, 0xf3, 0xc1, 0xac, 0xa2, 0x2c, 0x51, 0x79, 0xf8, 0xf0, 0x40, 0x42, 0x2b, 0x3c, 0x5b, 0xaf, 0xd4, 0x0a, 0x8f, 0x21, 0xcf, 0x0f, 0xa5, 0xa6, 0x67, 0xcc, 0xd5, 0x99, 0x3d, 0x42, 0xdb, 0xaf, 0xb4, 0x09, 0xc5, 0x20, 0xe2, 0x5f, 0xce, 0x2b, 0x1e, 0xe1, 0xe7, 0x16, 0x57, 0x7f, 0x1e, 0xfa, 0x17, 0xf3, 0xda, 0x28, 0x05, 0x2f, 0x40, 0xf0, 0x41, 0x9b, 0x23, 0x10, 0x6d, 0x78, 0x45, 0xaa, 0xf0, 0x11, 0x25, 0xb6, 0x98, 0xe7, 0xa4, 0xdf, 0xe9, 0x2d, 0x39, 0x67, 0xbb, 0x00, 0xc4, 0xd0, 0xd3, 0x5b, 0xa3, 0x55, 0x2a, 0xb9, 0xa8, 0xb3, 0xee, 0xf0, 0x7c, 0x7f, 0xec, 0xdb, 0xc5, 0x42, 0x4a, 0xc4, 0xdb, 0x1e, 0x20, 0xcb, 0x37, 0xd0, 0xb2, 0x74, 0x47, 0x69, 0x94, 0x0e, 0xa9, 0x07, 0xe1, 0x7f, 0xbb, 0xca, 0x67, 0x3b, 0x20, 0x52, 0x23, 0x80, 0xc5 }

}
,
#ifdef LTC_TEST_EXT
{
  "RSASSA-PSS Signature Example 8.2",
  /* Message to be signed */
  38,
  { 0xe2, 0xf9, 0x6e, 0xaf, 0x0e, 0x05, 0xe7, 0xba, 0x32, 0x6e, 0xcc, 0xa0, 0xba, 0x7f, 0xd2, 0xf7, 0xc0, 0x23, 0x56, 0xf3, 0xce, 0xde, 0x9d, 0x0f, 0xaa, 0xbf, 0x4f, 0xcc, 0x8e, 0x60, 0xa9, 0x73, 0xe5, 0x59, 0x5f, 0xd9, 0xea, 0x08 }
,
  /* Salt */
  20,
  { 0x43, 0x5c, 0x09, 0x8a, 0xa9, 0x90, 0x9e, 0xb2, 0x37, 0x7f, 0x12, 0x48, 0xb0, 0x91, 0xb6, 0x89, 0x87, 0xff, 0x18, 0x38 }
,
  /* Signature */
  129,
  { 0x27, 0x07, 0xb9, 0xad, 0x51, 0x15, 0xc5, 0x8c, 0x94, 0xe9, 0x32, 0xe8, 0xec, 0x0a, 0x28, 0x0f, 0x56, 0x33, 0x9e, 0x44, 0xa1, 0xb5, 0x8d, 0x4d, 0xdc, 0xff, 0x2f, 0x31, 0x2e, 0x5f, 0x34, 0xdc, 0xfe, 0x39, 0xe8, 0x9c, 0x6a, 0x94, 0xdc, 0xee, 0x86, 0xdb, 0xbd, 0xae, 0x5b, 0x79, 0xba, 0x4e, 0x08, 0x19, 0xa9, 0xe7, 0xbf, 0xd9, 0xd9, 0x82, 0xe7, 0xee, 0x6c, 0x86, 0xee, 0x68, 0x39, 0x6e, 0x8b, 0x3a, 0x14, 0xc9, 0xc8, 0xf3, 0x4b, 0x17, 0x8e, 0xb7, 0x41, 0xf9, 0xd3, 0xf1, 0x21, 0x10, 0x9b, 0xf5, 0xc8, 0x17, 0x2f, 0xad, 0xa2, 0xe7, 0x68, 0xf9, 0xea, 0x14, 0x33, 0x03, 0x2c, 0x00, 0x4a, 0x8a, 0xa0, 0x7e, 0xb9, 0x90, 0x00, 0x0a, 0x48, 0xdc, 0x94, 0xc8, 0xba, 0xc8, 0xaa, 0xbe, 0x2b, 0x09, 0xb1, 0xaa, 0x46, 0xc0, 0xa2, 0xaa, 0x0e, 0x12, 0xf6, 0x3f, 0xbb, 0xa7, 0x75, 0xba, 0x7e }

}
,
{
  "RSASSA-PSS Signature Example 8.3",
  /* Message to be signed */
  151,
  { 0xe3, 0x5c, 0x6e, 0xd9, 0x8f, 0x64, 0xa6, 0xd5, 0xa6, 0x48, 0xfc, 0xab, 0x8a, 0xdb, 0x16, 0x33, 0x1d, 0xb3, 0x2e, 0x5d, 0x15, 0xc7, 0x4a, 0x40, 0xed, 0xf9, 0x4c, 0x3d, 0xc4, 0xa4, 0xde, 0x79, 0x2d, 0x19, 0x08, 0x89, 0xf2, 0x0f, 0x1e, 0x24, 0xed, 0x12, 0x05, 0x4a, 0x6b, 0x28, 0x79, 0x8f, 0xcb, 0x42, 0xd1, 0xc5, 0x48, 0x76, 0x9b, 0x73, 0x4c, 0x96, 0x37, 0x31, 0x42, 0x09, 0x2a, 0xed, 0x27, 0x76, 0x03, 0xf4, 0x73, 0x8d, 0xf4, 0xdc, 0x14, 0x46, 0x58, 0x6d, 0x0e, 0xc6, 0x4d, 0xa4, 0xfb, 0x60, 0x53, 0x6d, 0xb2, 0xae, 0x17, 0xfc, 0x7e, 0x3c, 0x04, 0xbb, 0xfb, 0xbb, 0xd9, 0x07, 0xbf, 0x11, 0x7c, 0x08, 0x63, 0x6f, 0xa1, 0x6f, 0x95, 0xf5, 0x1a, 0x62, 0x16, 0x93, 0x4d, 0x3e, 0x34, 0xf8, 0x50, 0x30, 0xf1, 0x7b, 0xbb, 0xc5, 0xba, 0x69, 0x14, 0x40, 0x58, 0xaf, 0xf0, 0x81, 0xe0, 0xb1, 0x9c, 0xf0, 0x3c, 0x17, 0x19, 0x5c, 0x5e, 0x88, 0x8b, 0xa5, 0x8f, 0x6f, 0xe0, 0xa0, 0x2e, 0x5c, 0x3b, 0xda, 0x97, 0x19, 0xa7 }
,
  /* Salt */
  20,
  { 0xc6, 0xeb, 0xbe, 0x76, 0xdf, 0x0c, 0x4a, 0xea, 0x32, 0xc4, 0x74, 0x17, 0x5b, 0x2f, 0x13, 0x68, 0x62, 0xd0, 0x45, 0x29 }
,
  /* Signature */
  129,
  { 0x2a, 0xd2, 0x05, 0x09, 0xd7, 0x8c, 0xf2, 0x6d, 0x1b, 0x6c, 0x40, 0x61, 0x46, 0x08, 0x6e, 0x4b, 0x0c, 0x91, 0xa9, 0x1c, 0x2b, 0xd1, 0x64, 0xc8, 0x7b, 0x96, 0x6b, 0x8f, 0xaa, 0x42, 0xaa, 0x0c, 0xa4, 0x46, 0x02, 0x23, 0x23, 0xba, 0x4b, 0x1a, 0x1b, 0x89, 0x70, 0x6d, 0x7f, 0x4c, 0x3b, 0xe5, 0x7d, 0x7b, 0x69, 0x70, 0x2d, 0x16, 0x8a, 0xb5, 0x95, 0x5e, 0xe2, 0x90, 0x35, 0x6b, 0x8c, 0x4a, 0x29, 0xed, 0x46, 0x7d, 0x54, 0x7e, 0xc2, 0x3c, 0xba, 0xdf, 0x28, 0x6c, 0xcb, 0x58, 0x63, 0xc6, 0x67, 0x9d, 0xa4, 0x67, 0xfc, 0x93, 0x24, 0xa1, 0x51, 0xc7, 0xec, 0x55, 0xaa, 0xc6, 0xdb, 0x40, 0x84, 0xf8, 0x27, 0x26, 0x82, 0x5c, 0xfe, 0x1a, 0xa4, 0x21, 0xbc, 0x64, 0x04, 0x9f, 0xb4, 0x2f, 0x23, 0x14, 0x8f, 0x9c, 0x25, 0xb2, 0xdc, 0x30, 0x04, 0x37, 0xc3, 0x8d, 0x42, 0x8a, 0xa7, 0x5f, 0x96 }

}
,
{
  "RSASSA-PSS Signature Example 8.4",
  /* Message to be signed */
  204,
  { 0xdb, 0xc5, 0xf7, 0x50, 0xa7, 0xa1, 0x4b, 0xe2, 0xb9, 0x3e, 0x83, 0x8d, 0x18, 0xd1, 0x4a, 0x86, 0x95, 0xe5, 0x2e, 0x8a, 0xdd, 0x9c, 0x0a, 0xc7, 0x33, 0xb8, 0xf5, 0x6d, 0x27, 0x47, 0xe5, 0x29, 0xa0, 0xcc, 0xa5, 0x32, 0xdd, 0x49, 0xb9, 0x02, 0xae, 0xfe, 0xd5, 0x14, 0x44, 0x7f, 0x9e, 0x81, 0xd1, 0x61, 0x95, 0xc2, 0x85, 0x38, 0x68, 0xcb, 0x9b, 0x30, 0xf7, 0xd0, 0xd4, 0x95, 0xc6, 0x9d, 0x01, 0xb5, 0xc5, 0xd5, 0x0b, 0x27, 0x04, 0x5d, 0xb3, 0x86, 0x6c, 0x23, 0x24, 0xa4, 0x4a, 0x11, 0x0b, 0x17, 0x17, 0x74, 0x6d, 0xe4, 0x57, 0xd1, 0xc8, 0xc4, 0x5c, 0x3c, 0xd2, 0xa9, 0x29, 0x70, 0xc3, 0xd5, 0x96, 0x32, 0x05, 0x5d, 0x4c, 0x98, 0xa4, 0x1d, 0x6e, 0x99, 0xe2, 0xa3, 0xdd, 0xd5, 0xf7, 0xf9, 0x97, 0x9a, 0xb3, 0xcd, 0x18, 0xf3, 0x75, 0x05, 0xd2, 0x51, 0x41, 0xde, 0x2a, 0x1b, 0xff, 0x17, 0xb3, 0xa7, 0xdc, 0xe9, 0x41, 0x9e, 0xcc, 0x38, 0x5c, 0xf1, 0x1d, 0x72, 0x84, 0x0f, 0x19, 0x95, 0x3f, 0xd0, 0x50, 0x92, 0x51, 0xf6, 0xca, 0xfd, 0xe2, 0x89, 0x3d, 0x0e, 0x75, 0xc7, 0x81, 0xba, 0x7a, 0x50, 0x12, 0xca, 0x40, 0x1a, 0x4f, 0xa9, 0x9e, 0x04, 0xb3, 0xc3, 0x24, 0x9f, 0x92, 0x6d, 0x5a, 0xfe, 0x82, 0xcc, 0x87, 0xda, 0xb2, 0x2c, 0x3c, 0x1b, 0x10, 0x5d, 0xe4, 0x8e, 0x34, 0xac, 0xe9, 0xc9, 0x12, 0x4e, 0x59, 0x59, 0x7a, 0xc7, 0xeb, 0xf8 }
,
  /* Salt */
  20,
  { 0x02, 0x1f, 0xdc, 0xc6, 0xeb, 0xb5, 0xe1, 0x9b, 0x1c, 0xb1, 0x6e, 0x9c, 0x67, 0xf2, 0x76, 0x81, 0x65, 0x7f, 0xe2, 0x0a }
,
  /* Signature */
  129,
  { 0x1e, 0x24, 0xe6, 0xe5, 0x86, 0x28, 0xe5, 0x17, 0x50, 0x44, 0xa9, 0xeb, 0x6d, 0x83, 0x7d, 0x48, 0xaf, 0x12, 0x60, 0xb0, 0x52, 0x0e, 0x87, 0x32, 0x7d, 0xe7, 0x89, 0x7e, 0xe4, 0xd5, 0xb9, 0xf0, 0xdf, 0x0b, 0xe3, 0xe0, 0x9e, 0xd4, 0xde, 0xa8, 0xc1, 0x45, 0x4f, 0xf3, 0x42, 0x3b, 0xb0, 0x8e, 0x17, 0x93, 0x24, 0x5a, 0x9d, 0xf8, 0xbf, 0x6a, 0xb3, 0x96, 0x8c, 0x8e, 0xdd, 0xc3, 0xb5, 0x32, 0x85, 0x71, 0xc7, 0x7f, 0x09, 0x1c, 0xc5, 0x78, 0x57, 0x69, 0x12, 0xdf, 0xeb, 0xd1, 0x64, 0xb9, 0xde, 0x54, 0x54, 0xfe, 0x0b, 0xe1, 0xc1, 0xf6, 0x38, 0x5b, 0x32, 0x83, 0x60, 0xce, 0x67, 0xec, 0x7a, 0x05, 0xf6, 0xe3, 0x0e, 0xb4, 0x5c, 0x17, 0xc4, 0x8a, 0xc7, 0x00, 0x41, 0xd2, 0xca, 0xb6, 0x7f, 0x0a, 0x2a, 0xe7, 0xaa, 0xfd, 0xcc, 0x8d, 0x24, 0x5e, 0xa3, 0x44, 0x2a, 0x63, 0x00, 0xcc, 0xc7 }

}
,
{
  "RSASSA-PSS Signature Example 8.5",
  /* Message to be signed */
  101,
  { 0x04, 0xdc, 0x25, 0x1b, 0xe7, 0x2e, 0x88, 0xe5, 0x72, 0x34, 0x85, 0xb6, 0x38, 0x3a, 0x63, 0x7e, 0x2f, 0xef, 0xe0, 0x76, 0x60, 0xc5, 0x19, 0xa5, 0x60, 0xb8, 0xbc, 0x18, 0xbd, 0xed, 0xb8, 0x6e, 0xae, 0x23, 0x64, 0xea, 0x53, 0xba, 0x9d, 0xca, 0x6e, 0xb3, 0xd2, 0xe7, 0xd6, 0xb8, 0x06, 0xaf, 0x42, 0xb3, 0xe8, 0x7f, 0x29, 0x1b, 0x4a, 0x88, 0x81, 0xd5, 0xbf, 0x57, 0x2c, 0xc9, 0xa8, 0x5e, 0x19, 0xc8, 0x6a, 0xcb, 0x28, 0xf0, 0x98, 0xf9, 0xda, 0x03, 0x83, 0xc5, 0x66, 0xd3, 0xc0, 0xf5, 0x8c, 0xfd, 0x8f, 0x39, 0x5d, 0xcf, 0x60, 0x2e, 0x5c, 0xd4, 0x0e, 0x8c, 0x71, 0x83, 0xf7, 0x14, 0x99, 0x6e, 0x22, 0x97, 0xef }
,
  /* Salt */
  20,
  { 0xc5, 0x58, 0xd7, 0x16, 0x7c, 0xbb, 0x45, 0x08, 0xad, 0xa0, 0x42, 0x97, 0x1e, 0x71, 0xb1, 0x37, 0x7e, 0xea, 0x42, 0x69 }
,
  /* Signature */
  129,
  { 0x33, 0x34, 0x1b, 0xa3, 0x57, 0x6a, 0x13, 0x0a, 0x50, 0xe2, 0xa5, 0xcf, 0x86, 0x79, 0x22, 0x43, 0x88, 0xd5, 0x69, 0x3f, 0x5a, 0xcc, 0xc2, 0x35, 0xac, 0x95, 0xad, 0xd6, 0x8e, 0x5e, 0xb1, 0xee, 0xc3, 0x16, 0x66, 0xd0, 0xca, 0x7a, 0x1c, 0xda, 0x6f, 0x70, 0xa1, 0xaa, 0x76, 0x2c, 0x05, 0x75, 0x2a, 0x51, 0x95, 0x0c, 0xdb, 0x8a, 0xf3, 0xc5, 0x37, 0x9f, 0x18, 0xcf, 0xe6, 0xb5, 0xbc, 0x55, 0xa4, 0x64, 0x82, 0x26, 0xa1, 0x5e, 0x91, 0x2e, 0xf1, 0x9a, 0xd7, 0x7a, 0xde, 0xea, 0x91, 0x1d, 0x67, 0xcf, 0xef, 0xd6, 0x9b, 0xa4, 0x3f, 0xa4, 0x11, 0x91, 0x35, 0xff, 0x64, 0x21, 0x17, 0xba, 0x98, 0x5a, 0x7e, 0x01, 0x00, 0x32, 0x5e, 0x95, 0x19, 0xf1, 0xca, 0x6a, 0x92, 0x16, 0xbd, 0xa0, 0x55, 0xb5, 0x78, 0x50, 0x15, 0x29, 0x11, 0x25, 0xe9, 0x0d, 0xcd, 0x07, 0xa2, 0xca, 0x96, 0x73, 0xee }

}
,
{
  "RSASSA-PSS Signature Example 8.6",
  /* Message to be signed */
  132,
  { 0x0e, 0xa3, 0x7d, 0xf9, 0xa6, 0xfe, 0xa4, 0xa8, 0xb6, 0x10, 0x37, 0x3c, 0x24, 0xcf, 0x39, 0x0c, 0x20, 0xfa, 0x6e, 0x21, 0x35, 0xc4, 0x00, 0xc8, 0xa3, 0x4f, 0x5c, 0x18, 0x3a, 0x7e, 0x8e, 0xa4, 0xc9, 0xae, 0x09, 0x0e, 0xd3, 0x17, 0x59, 0xf4, 0x2d, 0xc7, 0x77, 0x19, 0xcc, 0xa4, 0x00, 0xec, 0xdc, 0xc5, 0x17, 0xac, 0xfc, 0x7a, 0xc6, 0x90, 0x26, 0x75, 0xb2, 0xef, 0x30, 0xc5, 0x09, 0x66, 0x5f, 0x33, 0x21, 0x48, 0x2f, 0xc6, 0x9a, 0x9f, 0xb5, 0x70, 0xd1, 0x5e, 0x01, 0xc8, 0x45, 0xd0, 0xd8, 0xe5, 0x0d, 0x2a, 0x24, 0xcb, 0xf1, 0xcf, 0x0e, 0x71, 0x49, 0x75, 0xa5, 0xdb, 0x7b, 0x18, 0xd9, 0xe9, 0xe9, 0xcb, 0x91, 0xb5, 0xcb, 0x16, 0x86, 0x90, 0x60, 0xed, 0x18, 0xb7, 0xb5, 0x62, 0x45, 0x50, 0x3f, 0x0c, 0xaf, 0x90, 0x35, 0x2b, 0x8d, 0xe8, 0x1c, 0xb5, 0xa1, 0xd9, 0xc6, 0x33, 0x60, 0x92, 0xf0, 0xcd }
,
  /* Salt */
  20,
  { 0x76, 0xfd, 0x4e, 0x64, 0xfd, 0xc9, 0x8e, 0xb9, 0x27, 0xa0, 0x40, 0x3e, 0x35, 0xa0, 0x84, 0xe7, 0x6b, 0xa9, 0xf9, 0x2a }
,
  /* Signature */
  129,
  { 0x1e, 0xd1, 0xd8, 0x48, 0xfb, 0x1e, 0xdb, 0x44, 0x12, 0x9b, 0xd9, 0xb3, 0x54, 0x79, 0x5a, 0xf9, 0x7a, 0x06, 0x9a, 0x7a, 0x00, 0xd0, 0x15, 0x10, 0x48, 0x59, 0x3e, 0x0c, 0x72, 0xc3, 0x51, 0x7f, 0xf9, 0xff, 0x2a, 0x41, 0xd0, 0xcb, 0x5a, 0x0a, 0xc8, 0x60, 0xd7, 0x36, 0xa1, 0x99, 0x70, 0x4f, 0x7c, 0xb6, 0xa5, 0x39, 0x86, 0xa8, 0x8b, 0xbd, 0x8a, 0xbc, 0xc0, 0x07, 0x6a, 0x2c, 0xe8, 0x47, 0x88, 0x00, 0x31, 0x52, 0x5d, 0x44, 0x9d, 0xa2, 0xac, 0x78, 0x35, 0x63, 0x74, 0xc5, 0x36, 0xe3, 0x43, 0xfa, 0xa7, 0xcb, 0xa4, 0x2a, 0x5a, 0xaa, 0x65, 0x06, 0x08, 0x77, 0x91, 0xc0, 0x6a, 0x8e, 0x98, 0x93, 0x35, 0xae, 0xd1, 0x9b, 0xfa, 0xb2, 0xd5, 0xe6, 0x7e, 0x27, 0xfb, 0x0c, 0x28, 0x75, 0xaf, 0x89, 0x6c, 0x21, 0xb6, 0xe8, 0xe7, 0x30, 0x9d, 0x04, 0xe4, 0xf6, 0x72, 0x7e, 0x69, 0x46, 0x3e }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 9: A 1536-bit RSA Key Pair",
{
  /* RSA modulus n */
  192,
  { 0xe6, 0xbd, 0x69, 0x2a, 0xc9, 0x66, 0x45, 0x79, 0x04, 0x03, 0xfd, 0xd0, 0xf5, 0xbe, 0xb8, 0xb9, 0xbf, 0x92, 0xed, 0x10, 0x00, 0x7f, 0xc3, 0x65, 0x04, 0x64, 0x19, 0xdd, 0x06, 0xc0, 0x5c, 0x5b, 0x5b, 0x2f, 0x48, 0xec, 0xf9, 0x89, 0xe4, 0xce, 0x26, 0x91, 0x09, 0x97, 0x9c, 0xbb, 0x40, 0xb4, 0xa0, 0xad, 0x24, 0xd2, 0x24, 0x83, 0xd1, 0xee, 0x31, 0x5a, 0xd4, 0xcc, 0xb1, 0x53, 0x42, 0x68, 0x35, 0x26, 0x91, 0xc5, 0x24, 0xf6, 0xdd, 0x8e, 0x6c, 0x29, 0xd2, 0x24, 0xcf, 0x24, 0x69, 0x73, 0xae, 0xc8, 0x6c, 0x5b, 0xf6, 0xb1, 0x40, 0x1a, 0x85, 0x0d, 0x1b, 0x9a, 0xd1, 0xbb, 0x8c, 0xbc, 0xec, 0x47, 0xb0, 0x6f, 0x0f, 0x8c, 0x7f, 0x45, 0xd3, 0xfc, 0x8f, 0x31, 0x92, 0x99, 0xc5, 0x43, 0x3d, 0xdb, 0xc2, 0xb3, 0x05, 0x3b, 0x47, 0xde, 0xd2, 0xec, 0xd4, 0xa4, 0xca, 0xef, 0xd6, 0x14, 0x83, 0x3d, 0xc8, 0xbb, 0x62, 0x2f, 0x31, 0x7e, 0xd0, 0x76, 0xb8, 0x05, 0x7f, 0xe8, 0xde, 0x3f, 0x84, 0x48, 0x0a, 0xd5, 0xe8, 0x3e, 0x4a, 0x61, 0x90, 0x4a, 0x4f, 0x24, 0x8f, 0xb3, 0x97, 0x02, 0x73, 0x57, 0xe1, 0xd3, 0x0e, 0x46, 0x31, 0x39, 0x81, 0x5c, 0x6f, 0xd4, 0xfd, 0x5a, 0xc5, 0xb8, 0x17, 0x2a, 0x45, 0x23, 0x0e, 0xcb, 0x63, 0x18, 0xa0, 0x4f, 0x14, 0x55, 0xd8, 0x4e, 0x5a, 0x8b }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  192,
  { 0x6a, 0x7f, 0xd8, 0x4f, 0xb8, 0x5f, 0xad, 0x07, 0x3b, 0x34, 0x40, 0x6d, 0xb7, 0x4f, 0x8d, 0x61, 0xa6, 0xab, 0xc1, 0x21, 0x96, 0xa9, 0x61, 0xdd, 0x79, 0x56, 0x5e, 0x9d, 0xa6, 0xe5, 0x18, 0x7b, 0xce, 0x2d, 0x98, 0x02, 0x50, 0xf7, 0x35, 0x95, 0x75, 0x35, 0x92, 0x70, 0xd9, 0x15, 0x90, 0xbb, 0x0e, 0x42, 0x7c, 0x71, 0x46, 0x0b, 0x55, 0xd5, 0x14, 0x10, 0xb1, 0x91, 0xbc, 0xf3, 0x09, 0xfe, 0xa1, 0x31, 0xa9, 0x2c, 0x8e, 0x70, 0x27, 0x38, 0xfa, 0x71, 0x9f, 0x1e, 0x00, 0x41, 0xf5, 0x2e, 0x40, 0xe9, 0x1f, 0x22, 0x9f, 0x4d, 0x96, 0xa1, 0xe6, 0xf1, 0x72, 0xe1, 0x55, 0x96, 0xb4, 0x51, 0x0a, 0x6d, 0xae, 0xc2, 0x61, 0x05, 0xf2, 0xbe, 0xbc, 0x53, 0x31, 0x6b, 0x87, 0xbd, 0xf2, 0x13, 0x11, 0x66, 0x60, 0x70, 0xe8, 0xdf, 0xee, 0x69, 0xd5, 0x2c, 0x71, 0xa9, 0x76, 0xca, 0xae, 0x79, 0xc7, 0x2b, 0x68, 0xd2, 0x85, 0x80, 0xdc, 0x68, 0x6d, 0x9f, 0x51, 0x29, 0xd2, 0x25, 0xf8, 0x2b, 0x3d, 0x61, 0x55, 0x13, 0xa8, 0x82, 0xb3, 0xdb, 0x91, 0x41, 0x6b, 0x48, 0xce, 0x08, 0x88, 0x82, 0x13, 0xe3, 0x7e, 0xeb, 0x9a, 0xf8, 0x00, 0xd8, 0x1c, 0xab, 0x32, 0x8c, 0xe4, 0x20, 0x68, 0x99, 0x03, 0xc0, 0x0c, 0x7b, 0x5f, 0xd3, 0x1b, 0x75, 0x50, 0x3a, 0x6d, 0x41, 0x96, 0x84, 0xd6, 0x29 }
,
  /* Prime p */
  96,
  { 0xf8, 0xeb, 0x97, 0xe9, 0x8d, 0xf1, 0x26, 0x64, 0xee, 0xfd, 0xb7, 0x61, 0x59, 0x6a, 0x69, 0xdd, 0xcd, 0x0e, 0x76, 0xda, 0xec, 0xe6, 0xed, 0x4b, 0xf5, 0xa1, 0xb5, 0x0a, 0xc0, 0x86, 0xf7, 0x92, 0x8a, 0x4d, 0x2f, 0x87, 0x26, 0xa7, 0x7e, 0x51, 0x5b, 0x74, 0xda, 0x41, 0x98, 0x8f, 0x22, 0x0b, 0x1c, 0xc8, 0x7a, 0xa1, 0xfc, 0x81, 0x0c, 0xe9, 0x9a, 0x82, 0xf2, 0xd1, 0xce, 0x82, 0x1e, 0xdc, 0xed, 0x79, 0x4c, 0x69, 0x41, 0xf4, 0x2c, 0x7a, 0x1a, 0x0b, 0x8c, 0x4d, 0x28, 0xc7, 0x5e, 0xc6, 0x0b, 0x65, 0x22, 0x79, 0xf6, 0x15, 0x4a, 0x76, 0x2a, 0xed, 0x16, 0x5d, 0x47, 0xde, 0xe3, 0x67 }
,
  /* Prime q */
  96,
  { 0xed, 0x4d, 0x71, 0xd0, 0xa6, 0xe2, 0x4b, 0x93, 0xc2, 0xe5, 0xf6, 0xb4, 0xbb, 0xe0, 0x5f, 0x5f, 0xb0, 0xaf, 0xa0, 0x42, 0xd2, 0x04, 0xfe, 0x33, 0x78, 0xd3, 0x65, 0xc2, 0xf2, 0x88, 0xb6, 0xa8, 0xda, 0xd7, 0xef, 0xe4, 0x5d, 0x15, 0x3e, 0xef, 0x40, 0xca, 0xcc, 0x7b, 0x81, 0xff, 0x93, 0x40, 0x02, 0xd1, 0x08, 0x99, 0x4b, 0x94, 0xa5, 0xe4, 0x72, 0x8c, 0xd9, 0xc9, 0x63, 0x37, 0x5a, 0xe4, 0x99, 0x65, 0xbd, 0xa5, 0x5c, 0xbf, 0x0e, 0xfe, 0xd8, 0xd6, 0x55, 0x3b, 0x40, 0x27, 0xf2, 0xd8, 0x62, 0x08, 0xa6, 0xe6, 0xb4, 0x89, 0xc1, 0x76, 0x12, 0x80, 0x92, 0xd6, 0x29, 0xe4, 0x9d, 0x3d }
,
  /* p's CRT exponent dP */
  96,
  { 0x2b, 0xb6, 0x8b, 0xdd, 0xfb, 0x0c, 0x4f, 0x56, 0xc8, 0x55, 0x8b, 0xff, 0xaf, 0x89, 0x2d, 0x80, 0x43, 0x03, 0x78, 0x41, 0xe7, 0xfa, 0x81, 0xcf, 0xa6, 0x1a, 0x38, 0xc5, 0xe3, 0x9b, 0x90, 0x1c, 0x8e, 0xe7, 0x11, 0x22, 0xa5, 0xda, 0x22, 0x27, 0xbd, 0x6c, 0xde, 0xeb, 0x48, 0x14, 0x52, 0xc1, 0x2a, 0xd3, 0xd6, 0x1d, 0x5e, 0x4f, 0x77, 0x6a, 0x0a, 0xb5, 0x56, 0x59, 0x1b, 0xef, 0xe3, 0xe5, 0x9e, 0x5a, 0x7f, 0xdd, 0xb8, 0x34, 0x5e, 0x1f, 0x2f, 0x35, 0xb9, 0xf4, 0xce, 0xe5, 0x7c, 0x32, 0x41, 0x4c, 0x08, 0x6a, 0xec, 0x99, 0x3e, 0x93, 0x53, 0xe4, 0x80, 0xd9, 0xee, 0xc6, 0x28, 0x9f }
,
  /* q's CRT exponent dQ */
  96,
  { 0x4f, 0xf8, 0x97, 0x70, 0x9f, 0xad, 0x07, 0x97, 0x46, 0x49, 0x45, 0x78, 0xe7, 0x0f, 0xd8, 0x54, 0x61, 0x30, 0xee, 0xab, 0x56, 0x27, 0xc4, 0x9b, 0x08, 0x0f, 0x05, 0xee, 0x4a, 0xd9, 0xf3, 0xe4, 0xb7, 0xcb, 0xa9, 0xd6, 0xa5, 0xdf, 0xf1, 0x13, 0xa4, 0x1c, 0x34, 0x09, 0x33, 0x68, 0x33, 0xf1, 0x90, 0x81, 0x6d, 0x8a, 0x6b, 0xc4, 0x2e, 0x9b, 0xec, 0x56, 0xb7, 0x56, 0x7d, 0x0f, 0x3c, 0x9c, 0x69, 0x6d, 0xb6, 0x19, 0xb2, 0x45, 0xd9, 0x01, 0xdd, 0x85, 0x6d, 0xb7, 0xc8, 0x09, 0x2e, 0x77, 0xe9, 0xa1, 0xcc, 0xcd, 0x56, 0xee, 0x4d, 0xba, 0x42, 0xc5, 0xfd, 0xb6, 0x1a, 0xec, 0x26, 0x69 }
,
  /* CRT coefficient qInv */
  96,
  { 0x77, 0xb9, 0xd1, 0x13, 0x7b, 0x50, 0x40, 0x4a, 0x98, 0x27, 0x29, 0x31, 0x6e, 0xfa, 0xfc, 0x7d, 0xfe, 0x66, 0xd3, 0x4e, 0x5a, 0x18, 0x26, 0x00, 0xd5, 0xf3, 0x0a, 0x0a, 0x85, 0x12, 0x05, 0x1c, 0x56, 0x0d, 0x08, 0x1d, 0x4d, 0x0a, 0x18, 0x35, 0xec, 0x3d, 0x25, 0xa6, 0x0f, 0x4e, 0x4d, 0x6a, 0xa9, 0x48, 0xb2, 0xbf, 0x3d, 0xbb, 0x5b, 0x12, 0x4c, 0xbb, 0xc3, 0x48, 0x92, 0x55, 0xa3, 0xa9, 0x48, 0x37, 0x2f, 0x69, 0x78, 0x49, 0x67, 0x45, 0xf9, 0x43, 0xe1, 0xdb, 0x4f, 0x18, 0x38, 0x2c, 0xea, 0xa5, 0x05, 0xdf, 0xc6, 0x57, 0x57, 0xbb, 0x3f, 0x85, 0x7a, 0x58, 0xdc, 0xe5, 0x21, 0x56 }

}
,
{{
  "RSASSA-PSS Signature Example 9.1",
  /* Message to be signed */
  211,
  { 0xa8, 0x8e, 0x26, 0x58, 0x55, 0xe9, 0xd7, 0xca, 0x36, 0xc6, 0x87, 0x95, 0xf0, 0xb3, 0x1b, 0x59, 0x1c, 0xd6, 0x58, 0x7c, 0x71, 0xd0, 0x60, 0xa0, 0xb3, 0xf7, 0xf3, 0xea, 0xef, 0x43, 0x79, 0x59, 0x22, 0x02, 0x8b, 0xc2, 0xb6, 0xad, 0x46, 0x7c, 0xfc, 0x2d, 0x7f, 0x65, 0x9c, 0x53, 0x85, 0xaa, 0x70, 0xba, 0x36, 0x72, 0xcd, 0xde, 0x4c, 0xfe, 0x49, 0x70, 0xcc, 0x79, 0x04, 0x60, 0x1b, 0x27, 0x88, 0x72, 0xbf, 0x51, 0x32, 0x1c, 0x4a, 0x97, 0x2f, 0x3c, 0x95, 0x57, 0x0f, 0x34, 0x45, 0xd4, 0xf5, 0x79, 0x80, 0xe0, 0xf2, 0x0d, 0xf5, 0x48, 0x46, 0xe6, 0xa5, 0x2c, 0x66, 0x8f, 0x12, 0x88, 0xc0, 0x3f, 0x95, 0x00, 0x6e, 0xa3, 0x2f, 0x56, 0x2d, 0x40, 0xd5, 0x2a, 0xf9, 0xfe, 0xb3, 0x2f, 0x0f, 0xa0, 0x6d, 0xb6, 0x5b, 0x58, 0x8a, 0x23, 0x7b, 0x34, 0xe5, 0x92, 0xd5, 0x5c, 0xf9, 0x79, 0xf9, 0x03, 0xa6, 0x42, 0xef, 0x64, 0xd2, 0xed, 0x54, 0x2a, 0xa8, 0xc7, 0x7d, 0xc1, 0xdd, 0x76, 0x2f, 0x45, 0xa5, 0x93, 0x03, 0xed, 0x75, 0xe5, 0x41, 0xca, 0x27, 0x1e, 0x2b, 0x60, 0xca, 0x70, 0x9e, 0x44, 0xfa, 0x06, 0x61, 0x13, 0x1e, 0x8d, 0x5d, 0x41, 0x63, 0xfd, 0x8d, 0x39, 0x85, 0x66, 0xce, 0x26, 0xde, 0x87, 0x30, 0xe7, 0x2f, 0x9c, 0xca, 0x73, 0x76, 0x41, 0xc2, 0x44, 0x15, 0x94, 0x20, 0x63, 0x70, 0x28, 0xdf, 0x0a, 0x18, 0x07, 0x9d, 0x62, 0x08, 0xea, 0x8b, 0x47, 0x11, 0xa2, 0xc7, 0x50, 0xf5 }
,
  /* Salt */
  20,
  { 0xc0, 0xa4, 0x25, 0x31, 0x3d, 0xf8, 0xd7, 0x56, 0x4b, 0xd2, 0x43, 0x4d, 0x31, 0x15, 0x23, 0xd5, 0x25, 0x7e, 0xed, 0x80 }
,
  /* Signature */
  192,
  { 0x58, 0x61, 0x07, 0x22, 0x6c, 0x3c, 0xe0, 0x13, 0xa7, 0xc8, 0xf0, 0x4d, 0x1a, 0x6a, 0x29, 0x59, 0xbb, 0x4b, 0x8e, 0x20, 0x5b, 0xa4, 0x3a, 0x27, 0xb5, 0x0f, 0x12, 0x41, 0x11, 0xbc, 0x35, 0xef, 0x58, 0x9b, 0x03, 0x9f, 0x59, 0x32, 0x18, 0x7c, 0xb6, 0x96, 0xd7, 0xd9, 0xa3, 0x2c, 0x0c, 0x38, 0x30, 0x0a, 0x5c, 0xdd, 0xa4, 0x83, 0x4b, 0x62, 0xd2, 0xeb, 0x24, 0x0a, 0xf3, 0x3f, 0x79, 0xd1, 0x3d, 0xfb, 0xf0, 0x95, 0xbf, 0x59, 0x9e, 0x0d, 0x96, 0x86, 0x94, 0x8c, 0x19, 0x64, 0x74, 0x7b, 0x67, 0xe8, 0x9c, 0x9a, 0xba, 0x5c, 0xd8, 0x50, 0x16, 0x23, 0x6f, 0x56, 0x6c, 0xc5, 0x80, 0x2c, 0xb1, 0x3e, 0xad, 0x51, 0xbc, 0x7c, 0xa6, 0xbe, 0xf3, 0xb9, 0x4d, 0xcb, 0xdb, 0xb1, 0xd5, 0x70, 0x46, 0x97, 0x71, 0xdf, 0x0e, 0x00, 0xb1, 0xa8, 0xa0, 0x67, 0x77, 0x47, 0x2d, 0x23, 0x16, 0x27, 0x9e, 0xda, 0xe8, 0x64, 0x74, 0x66, 0x8d, 0x4e, 0x1e, 0xff, 0xf9, 0x5f, 0x1d, 0xe6, 0x1c, 0x60, 0x20, 0xda, 0x32, 0xae, 0x92, 0xbb, 0xf1, 0x65, 0x20, 0xfe, 0xf3, 0xcf, 0x4d, 0x88, 0xf6, 0x11, 0x21, 0xf2, 0x4b, 0xbd, 0x9f, 0xe9, 0x1b, 0x59, 0xca, 0xf1, 0x23, 0x5b, 0x2a, 0x93, 0xff, 0x81, 0xfc, 0x40, 0x3a, 0xdd, 0xf4, 0xeb, 0xde, 0xa8, 0x49, 0x34, 0xa9, 0xcd, 0xaf, 0x8e, 0x1a, 0x9e }

}
,
#ifdef LTC_TEST_EXT
{
  "RSASSA-PSS Signature Example 9.2",
  /* Message to be signed */
  107,
  { 0xc8, 0xc9, 0xc6, 0xaf, 0x04, 0xac, 0xda, 0x41, 0x4d, 0x22, 0x7e, 0xf2, 0x3e, 0x08, 0x20, 0xc3, 0x73, 0x2c, 0x50, 0x0d, 0xc8, 0x72, 0x75, 0xe9, 0x5b, 0x0d, 0x09, 0x54, 0x13, 0x99, 0x3c, 0x26, 0x58, 0xbc, 0x1d, 0x98, 0x85, 0x81, 0xba, 0x87, 0x9c, 0x2d, 0x20, 0x1f, 0x14, 0xcb, 0x88, 0xce, 0xd1, 0x53, 0xa0, 0x19, 0x69, 0xa7, 0xbf, 0x0a, 0x7b, 0xe7, 0x9c, 0x84, 0xc1, 0x48, 0x6b, 0xc1, 0x2b, 0x3f, 0xa6, 0xc5, 0x98, 0x71, 0xb6, 0x82, 0x7c, 0x8c, 0xe2, 0x53, 0xca, 0x5f, 0xef, 0xa8, 0xa8, 0xc6, 0x90, 0xbf, 0x32, 0x6e, 0x8e, 0x37, 0xcd, 0xb9, 0x6d, 0x90, 0xa8, 0x2e, 0xba, 0xb6, 0x9f, 0x86, 0x35, 0x0e, 0x18, 0x22, 0xe8, 0xbd, 0x53, 0x6a, 0x2e }
,
  /* Salt */
  20,
  { 0xb3, 0x07, 0xc4, 0x3b, 0x48, 0x50, 0xa8, 0xda, 0xc2, 0xf1, 0x5f, 0x32, 0xe3, 0x78, 0x39, 0xef, 0x8c, 0x5c, 0x0e, 0x91 }
,
  /* Signature */
  192,
  { 0x80, 0xb6, 0xd6, 0x43, 0x25, 0x52, 0x09, 0xf0, 0xa4, 0x56, 0x76, 0x38, 0x97, 0xac, 0x9e, 0xd2, 0x59, 0xd4, 0x59, 0xb4, 0x9c, 0x28, 0x87, 0xe5, 0x88, 0x2e, 0xcb, 0x44, 0x34, 0xcf, 0xd6, 0x6d, 0xd7, 0xe1, 0x69, 0x93, 0x75, 0x38, 0x1e, 0x51, 0xcd, 0x7f, 0x55, 0x4f, 0x2c, 0x27, 0x17, 0x04, 0xb3, 0x99, 0xd4, 0x2b, 0x4b, 0xe2, 0x54, 0x0a, 0x0e, 0xca, 0x61, 0x95, 0x1f, 0x55, 0x26, 0x7f, 0x7c, 0x28, 0x78, 0xc1, 0x22, 0x84, 0x2d, 0xad, 0xb2, 0x8b, 0x01, 0xbd, 0x5f, 0x8c, 0x02, 0x5f, 0x7e, 0x22, 0x84, 0x18, 0xa6, 0x73, 0xc0, 0x3d, 0x6b, 0xc0, 0xc7, 0x36, 0xd0, 0xa2, 0x95, 0x46, 0xbd, 0x67, 0xf7, 0x86, 0xd9, 0xd6, 0x92, 0xcc, 0xea, 0x77, 0x8d, 0x71, 0xd9, 0x8c, 0x20, 0x63, 0xb7, 0xa7, 0x10, 0x92, 0x18, 0x7a, 0x4d, 0x35, 0xaf, 0x10, 0x81, 0x11, 0xd8, 0x3e, 0x83, 0xea, 0xe4, 0x6c, 0x46, 0xaa, 0x34, 0x27, 0x7e, 0x06, 0x04, 0x45, 0x89, 0x90, 0x37, 0x88, 0xf1, 0xd5, 0xe7, 0xce, 0xe2, 0x5f, 0xb4, 0x85, 0xe9, 0x29, 0x49, 0x11, 0x88, 0x14, 0xd6, 0xf2, 0xc3, 0xee, 0x36, 0x14, 0x89, 0x01, 0x6f, 0x32, 0x7f, 0xb5, 0xbc, 0x51, 0x7e, 0xb5, 0x04, 0x70, 0xbf, 0xfa, 0x1a, 0xfa, 0x5f, 0x4c, 0xe9, 0xaa, 0x0c, 0xe5, 0xb8, 0xee, 0x19, 0xbf, 0x55, 0x01, 0xb9, 0x58 }

}
,
{
  "RSASSA-PSS Signature Example 9.3",
  /* Message to be signed */
  222,
  { 0x0a, 0xfa, 0xd4, 0x2c, 0xcd, 0x4f, 0xc6, 0x06, 0x54, 0xa5, 0x50, 0x02, 0xd2, 0x28, 0xf5, 0x2a, 0x4a, 0x5f, 0xe0, 0x3b, 0x8b, 0xbb, 0x08, 0xca, 0x82, 0xda, 0xca, 0x55, 0x8b, 0x44, 0xdb, 0xe1, 0x26, 0x6e, 0x50, 0xc0, 0xe7, 0x45, 0xa3, 0x6d, 0x9d, 0x29, 0x04, 0xe3, 0x40, 0x8a, 0xbc, 0xd1, 0xfd, 0x56, 0x99, 0x94, 0x06, 0x3f, 0x4a, 0x75, 0xcc, 0x72, 0xf2, 0xfe, 0xe2, 0xa0, 0xcd, 0x89, 0x3a, 0x43, 0xaf, 0x1c, 0x5b, 0x8b, 0x48, 0x7d, 0xf0, 0xa7, 0x16, 0x10, 0x02, 0x4e, 0x4f, 0x6d, 0xdf, 0x9f, 0x28, 0xad, 0x08, 0x13, 0xc1, 0xaa, 0xb9, 0x1b, 0xcb, 0x3c, 0x90, 0x64, 0xd5, 0xff, 0x74, 0x2d, 0xef, 0xfe, 0xa6, 0x57, 0x09, 0x41, 0x39, 0x36, 0x9e, 0x5e, 0xa6, 0xf4, 0xa9, 0x63, 0x19, 0xa5, 0xcc, 0x82, 0x24, 0x14, 0x5b, 0x54, 0x50, 0x62, 0x75, 0x8f, 0xef, 0xd1, 0xfe, 0x34, 0x09, 0xae, 0x16, 0x92, 0x59, 0xc6, 0xcd, 0xfd, 0x6b, 0x5f, 0x29, 0x58, 0xe3, 0x14, 0xfa, 0xec, 0xbe, 0x69, 0xd2, 0xca, 0xce, 0x58, 0xee, 0x55, 0x17, 0x9a, 0xb9, 0xb3, 0xe6, 0xd1, 0xec, 0xc1, 0x4a, 0x55, 0x7c, 0x5f, 0xeb, 0xe9, 0x88, 0x59, 0x52, 0x64, 0xfc, 0x5d, 0xa1, 0xc5, 0x71, 0x46, 0x2e, 0xca, 0x79, 0x8a, 0x18, 0xa1, 0xa4, 0x94, 0x0c, 0xda, 0xb4, 0xa3, 0xe9, 0x20, 0x09, 0xcc, 0xd4, 0x2e, 0x1e, 0x94, 0x7b, 0x13, 0x14, 0xe3, 0x22, 0x38, 0xa2, 0xde, 0xce, 0x7d, 0x23, 0xa8, 0x9b, 0x5b, 0x30, 0xc7, 0x51, 0xfd, 0x0a, 0x4a, 0x43, 0x0d, 0x2c, 0x54, 0x85, 0x94 }
,
  /* Salt */
  20,
  { 0x9a, 0x2b, 0x00, 0x7e, 0x80, 0x97, 0x8b, 0xbb, 0x19, 0x2c, 0x35, 0x4e, 0xb7, 0xda, 0x9a, 0xed, 0xfc, 0x74, 0xdb, 0xf5 }
,
  /* Signature */
  192,
  { 0x48, 0x44, 0x08, 0xf3, 0x89, 0x8c, 0xd5, 0xf5, 0x34, 0x83, 0xf8, 0x08, 0x19, 0xef, 0xbf, 0x27, 0x08, 0xc3, 0x4d, 0x27, 0xa8, 0xb2, 0xa6, 0xfa, 0xe8, 0xb3, 0x22, 0xf9, 0x24, 0x02, 0x37, 0xf9, 0x81, 0x81, 0x7a, 0xca, 0x18, 0x46, 0xf1, 0x08, 0x4d, 0xaa, 0x6d, 0x7c, 0x07, 0x95, 0xf6, 0xe5, 0xbf, 0x1a, 0xf5, 0x9c, 0x38, 0xe1, 0x85, 0x84, 0x37, 0xce, 0x1f, 0x7e, 0xc4, 0x19, 0xb9, 0x8c, 0x87, 0x36, 0xad, 0xf6, 0xdd, 0x9a, 0x00, 0xb1, 0x80, 0x6d, 0x2b, 0xd3, 0xad, 0x0a, 0x73, 0x77, 0x5e, 0x05, 0xf5, 0x2d, 0xfe, 0xf3, 0xa5, 0x9a, 0xb4, 0xb0, 0x81, 0x43, 0xf0, 0xdf, 0x05, 0xcd, 0x1a, 0xd9, 0xd0, 0x4b, 0xec, 0xec, 0xa6, 0xda, 0xa4, 0xa2, 0x12, 0x98, 0x03, 0xe2, 0x00, 0xcb, 0xc7, 0x77, 0x87, 0xca, 0xf4, 0xc1, 0xd0, 0x66, 0x3a, 0x6c, 0x59, 0x87, 0xb6, 0x05, 0x95, 0x20, 0x19, 0x78, 0x2c, 0xaf, 0x2e, 0xc1, 0x42, 0x6d, 0x68, 0xfb, 0x94, 0xed, 0x1d, 0x4b, 0xe8, 0x16, 0xa7, 0xed, 0x08, 0x1b, 0x77, 0xe6, 0xab, 0x33, 0x0b, 0x3f, 0xfc, 0x07, 0x38, 0x20, 0xfe, 0xcd, 0xe3, 0x72, 0x7f, 0xcb, 0xe2, 0x95, 0xee, 0x61, 0xa0, 0x50, 0xa3, 0x43, 0x65, 0x86, 0x37, 0xc3, 0xfd, 0x65, 0x9c, 0xfb, 0x63, 0x73, 0x6d, 0xe3, 0x2d, 0x9f, 0x90, 0xd3, 0xc2, 0xf6, 0x3e, 0xca }

}
,
{
  "RSASSA-PSS Signature Example 9.4",
  /* Message to be signed */
  248,
  { 0x1d, 0xfd, 0x43, 0xb4, 0x6c, 0x93, 0xdb, 0x82, 0x62, 0x9b, 0xda, 0xe2, 0xbd, 0x0a, 0x12, 0xb8, 0x82, 0xea, 0x04, 0xc3, 0xb4, 0x65, 0xf5, 0xcf, 0x93, 0x02, 0x3f, 0x01, 0x05, 0x96, 0x26, 0xdb, 0xbe, 0x99, 0xf2, 0x6b, 0xb1, 0xbe, 0x94, 0x9d, 0xdd, 0xd1, 0x6d, 0xc7, 0xf3, 0xde, 0xbb, 0x19, 0xa1, 0x94, 0x62, 0x7f, 0x0b, 0x22, 0x44, 0x34, 0xdf, 0x7d, 0x87, 0x00, 0xe9, 0xe9, 0x8b, 0x06, 0xe3, 0x60, 0xc1, 0x2f, 0xdb, 0xe3, 0xd1, 0x9f, 0x51, 0xc9, 0x68, 0x4e, 0xb9, 0x08, 0x9e, 0xcb, 0xb0, 0xa2, 0xf0, 0x45, 0x03, 0x99, 0xd3, 0xf5, 0x9e, 0xac, 0x72, 0x94, 0x08, 0x5d, 0x04, 0x4f, 0x53, 0x93, 0xc6, 0xce, 0x73, 0x74, 0x23, 0xd8, 0xb8, 0x6c, 0x41, 0x53, 0x70, 0xd3, 0x89, 0xe3, 0x0b, 0x9f, 0x0a, 0x3c, 0x02, 0xd2, 0x5d, 0x00, 0x82, 0xe8, 0xad, 0x6f, 0x3f, 0x1e, 0xf2, 0x4a, 0x45, 0xc3, 0xcf, 0x82, 0xb3, 0x83, 0x36, 0x70, 0x63, 0xa4, 0xd4, 0x61, 0x3e, 0x42, 0x64, 0xf0, 0x1b, 0x2d, 0xac, 0x2e, 0x5a, 0xa4, 0x20, 0x43, 0xf8, 0xfb, 0x5f, 0x69, 0xfa, 0x87, 0x1d, 0x14, 0xfb, 0x27, 0x3e, 0x76, 0x7a, 0x53, 0x1c, 0x40, 0xf0, 0x2f, 0x34, 0x3b, 0xc2, 0xfb, 0x45, 0xa0, 0xc7, 0xe0, 0xf6, 0xbe, 0x25, 0x61, 0x92, 0x3a, 0x77, 0x21, 0x1d, 0x66, 0xa6, 0xe2, 0xdb, 0xb4, 0x3c, 0x36, 0x63, 0x50, 0xbe, 0xae, 0x22, 0xda, 0x3a, 0xc2, 0xc1, 0xf5, 0x07, 0x70, 0x96, 0xfc, 0xb5, 0xc4, 0xbf, 0x25, 0x5f, 0x75, 0x74, 0x35, 0x1a, 0xe0, 0xb1, 0xe1, 0xf0, 0x36, 0x32, 0x81, 0x7c, 0x08, 0x56, 0xd4, 0xa8, 0xba, 0x97, 0xaf, 0xbd, 0xc8, 0xb8, 0x58, 0x55, 0x40, 0x2b, 0xc5, 0x69, 0x26, 0xfc, 0xec, 0x20, 0x9f, 0x9e, 0xa8 }
,
  /* Salt */
  20,
  { 0x70, 0xf3, 0x82, 0xbd, 0xdf, 0x4d, 0x5d, 0x2d, 0xd8, 0x8b, 0x3b, 0xc7, 0xb7, 0x30, 0x8b, 0xe6, 0x32, 0xb8, 0x40, 0x45 }
,
  /* Signature */
  192,
  { 0x84, 0xeb, 0xeb, 0x48, 0x1b, 0xe5, 0x98, 0x45, 0xb4, 0x64, 0x68, 0xba, 0xfb, 0x47, 0x1c, 0x01, 0x12, 0xe0, 0x2b, 0x23, 0x5d, 0x84, 0xb5, 0xd9, 0x11, 0xcb, 0xd1, 0x92, 0x6e, 0xe5, 0x07, 0x4a, 0xe0, 0x42, 0x44, 0x95, 0xcb, 0x20, 0xe8, 0x23, 0x08, 0xb8, 0xeb, 0xb6, 0x5f, 0x41, 0x9a, 0x03, 0xfb, 0x40, 0xe7, 0x2b, 0x78, 0x98, 0x1d, 0x88, 0xaa, 0xd1, 0x43, 0x05, 0x36, 0x85, 0x17, 0x2c, 0x97, 0xb2, 0x9c, 0x8b, 0x7b, 0xf0, 0xae, 0x73, 0xb5, 0xb2, 0x26, 0x3c, 0x40, 0x3d, 0xa0, 0xed, 0x2f, 0x80, 0xff, 0x74, 0x50, 0xaf, 0x78, 0x28, 0xeb, 0x8b, 0x86, 0xf0, 0x02, 0x8b, 0xd2, 0xa8, 0xb1, 0x76, 0xa4, 0xd2, 0x28, 0xcc, 0xce, 0xa1, 0x83, 0x94, 0xf2, 0x38, 0xb0, 0x9f, 0xf7, 0x58, 0xcc, 0x00, 0xbc, 0x04, 0x30, 0x11, 0x52, 0x35, 0x57, 0x42, 0xf2, 0x82, 0xb5, 0x4e, 0x66, 0x3a, 0x91, 0x9e, 0x70, 0x9d, 0x8d, 0xa2, 0x4a, 0xde, 0x55, 0x00, 0xa7, 0xb9, 0xaa, 0x50, 0x22, 0x6e, 0x0c, 0xa5, 0x29, 0x23, 0xe6, 0xc2, 0xd8, 0x60, 0xec, 0x50, 0xff, 0x48, 0x0f, 0xa5, 0x74, 0x77, 0xe8, 0x2b, 0x05, 0x65, 0xf4, 0x37, 0x9f, 0x79, 0xc7, 0x72, 0xd5, 0xc2, 0xda, 0x80, 0xaf, 0x9f, 0xbf, 0x32, 0x5e, 0xce, 0x6f, 0xc2, 0x0b, 0x00, 0x96, 0x16, 0x14, 0xbe, 0xe8, 0x9a, 0x18, 0x3e }

}
,
{
  "RSASSA-PSS Signature Example 9.5",
  /* Message to be signed */
  234,
  { 0x1b, 0xdc, 0x6e, 0x7c, 0x98, 0xfb, 0x8c, 0xf5, 0x4e, 0x9b, 0x09, 0x7b, 0x66, 0xa8, 0x31, 0xe9, 0xcf, 0xe5, 0x2d, 0x9d, 0x48, 0x88, 0x44, 0x8e, 0xe4, 0xb0, 0x97, 0x80, 0x93, 0xba, 0x1d, 0x7d, 0x73, 0xae, 0x78, 0xb3, 0xa6, 0x2b, 0xa4, 0xad, 0x95, 0xcd, 0x28, 0x9c, 0xcb, 0x9e, 0x00, 0x52, 0x26, 0xbb, 0x3d, 0x17, 0x8b, 0xcc, 0xaa, 0x82, 0x1f, 0xb0, 0x44, 0xa4, 0xe2, 0x1e, 0xe9, 0x76, 0x96, 0xc1, 0x4d, 0x06, 0x78, 0xc9, 0x4c, 0x2d, 0xae, 0x93, 0xb0, 0xad, 0x73, 0x92, 0x22, 0x18, 0x55, 0x3d, 0xaa, 0x7e, 0x44, 0xeb, 0xe5, 0x77, 0x25, 0xa7, 0xa4, 0x5c, 0xc7, 0x2b, 0x9b, 0x21, 0x38, 0xa6, 0xb1, 0x7c, 0x8d, 0xb4, 0x11, 0xce, 0x82, 0x79, 0xee, 0x12, 0x41, 0xaf, 0xf0, 0xa8, 0xbe, 0xc6, 0xf7, 0x7f, 0x87, 0xed, 0xb0, 0xc6, 0x9c, 0xb2, 0x72, 0x36, 0xe3, 0x43, 0x5a, 0x80, 0x0b, 0x19, 0x2e, 0x4f, 0x11, 0xe5, 0x19, 0xe3, 0xfe, 0x30, 0xfc, 0x30, 0xea, 0xcc, 0xca, 0x4f, 0xbb, 0x41, 0x76, 0x90, 0x29, 0xbf, 0x70, 0x8e, 0x81, 0x7a, 0x9e, 0x68, 0x38, 0x05, 0xbe, 0x67, 0xfa, 0x10, 0x09, 0x84, 0x68, 0x3b, 0x74, 0x83, 0x8e, 0x3b, 0xcf, 0xfa, 0x79, 0x36, 0x6e, 0xed, 0x1d, 0x48, 0x1c, 0x76, 0x72, 0x91, 0x18, 0x83, 0x8f, 0x31, 0xba, 0x8a, 0x04, 0x8a, 0x93, 0xc1, 0xbe, 0x44, 0x24, 0x59, 0x8e, 0x8d, 0xf6, 0x32, 0x8b, 0x7a, 0x77, 0x88, 0x0a, 0x3f, 0x9c, 0x7e, 0x2e, 0x8d, 0xfc, 0xa8, 0xeb, 0x5a, 0x26, 0xfb, 0x86, 0xbd, 0xc5, 0x56, 0xd4, 0x2b, 0xbe, 0x01, 0xd9, 0xfa, 0x6e, 0xd8, 0x06, 0x46, 0x49, 0x1c, 0x93, 0x41 }
,
  /* Salt */
  20,
  { 0xd6, 0x89, 0x25, 0x7a, 0x86, 0xef, 0xfa, 0x68, 0x21, 0x2c, 0x5e, 0x0c, 0x61, 0x9e, 0xca, 0x29, 0x5f, 0xb9, 0x1b, 0x67 }
,
  /* Signature */
  192,
  { 0x82, 0x10, 0x2d, 0xf8, 0xcb, 0x91, 0xe7, 0x17, 0x99, 0x19, 0xa0, 0x4d, 0x26, 0xd3, 0x35, 0xd6, 0x4f, 0xbc, 0x2f, 0x87, 0x2c, 0x44, 0x83, 0x39, 0x43, 0x24, 0x1d, 0xe8, 0x45, 0x48, 0x10, 0x27, 0x4c, 0xdf, 0x3d, 0xb5, 0xf4, 0x2d, 0x42, 0x3d, 0xb1, 0x52, 0xaf, 0x71, 0x35, 0xf7, 0x01, 0x42, 0x0e, 0x39, 0xb4, 0x94, 0xa6, 0x7c, 0xbf, 0xd1, 0x9f, 0x91, 0x19, 0xda, 0x23, 0x3a, 0x23, 0xda, 0x5c, 0x64, 0x39, 0xb5, 0xba, 0x0d, 0x2b, 0xc3, 0x73, 0xee, 0xe3, 0x50, 0x70, 0x01, 0x37, 0x8d, 0x4a, 0x40, 0x73, 0x85, 0x6b, 0x7f, 0xe2, 0xab, 0xa0, 0xb5, 0xee, 0x93, 0xb2, 0x7f, 0x4a, 0xfe, 0xc7, 0xd4, 0xd1, 0x20, 0x92, 0x1c, 0x83, 0xf6, 0x06, 0x76, 0x5b, 0x02, 0xc1, 0x9e, 0x4d, 0x6a, 0x1a, 0x3b, 0x95, 0xfa, 0x4c, 0x42, 0x29, 0x51, 0xbe, 0x4f, 0x52, 0x13, 0x10, 0x77, 0xef, 0x17, 0x17, 0x97, 0x29, 0xcd, 0xdf, 0xbd, 0xb5, 0x69, 0x50, 0xdb, 0xac, 0xee, 0xfe, 0x78, 0xcb, 0x16, 0x64, 0x0a, 0x09, 0x9e, 0xa5, 0x6d, 0x24, 0x38, 0x9e, 0xef, 0x10, 0xf8, 0xfe, 0xcb, 0x31, 0xba, 0x3e, 0xa3, 0xb2, 0x27, 0xc0, 0xa8, 0x66, 0x98, 0xbb, 0x89, 0xe3, 0xe9, 0x36, 0x39, 0x05, 0xbf, 0x22, 0x77, 0x7b, 0x2a, 0x3a, 0xa5, 0x21, 0xb6, 0x5b, 0x4c, 0xef, 0x76, 0xd8, 0x3b, 0xde, 0x4c }

}
,
{
  "RSASSA-PSS Signature Example 9.6",
  /* Message to be signed */
  165,
  { 0x88, 0xc7, 0xa9, 0xf1, 0x36, 0x04, 0x01, 0xd9, 0x0e, 0x53, 0xb1, 0x01, 0xb6, 0x1c, 0x53, 0x25, 0xc3, 0xc7, 0x5d, 0xb1, 0xb4, 0x11, 0xfb, 0xeb, 0x8e, 0x83, 0x0b, 0x75, 0xe9, 0x6b, 0x56, 0x67, 0x0a, 0xd2, 0x45, 0x40, 0x4e, 0x16, 0x79, 0x35, 0x44, 0xee, 0x35, 0x4b, 0xc6, 0x13, 0xa9, 0x0c, 0xc9, 0x84, 0x87, 0x15, 0xa7, 0x3d, 0xb5, 0x89, 0x3e, 0x7f, 0x6d, 0x27, 0x98, 0x15, 0xc0, 0xc1, 0xde, 0x83, 0xef, 0x8e, 0x29, 0x56, 0xe3, 0xa5, 0x6e, 0xd2, 0x6a, 0x88, 0x8d, 0x7a, 0x9c, 0xdc, 0xd0, 0x42, 0xf4, 0xb1, 0x6b, 0x7f, 0xa5, 0x1e, 0xf1, 0xa0, 0x57, 0x36, 0x62, 0xd1, 0x6a, 0x30, 0x2d, 0x0e, 0xc5, 0xb2, 0x85, 0xd2, 0xe0, 0x3a, 0xd9, 0x65, 0x29, 0xc8, 0x7b, 0x3d, 0x37, 0x4d, 0xb3, 0x72, 0xd9, 0x5b, 0x24, 0x43, 0xd0, 0x61, 0xb6, 0xb1, 0xa3, 0x50, 0xba, 0x87, 0x80, 0x7e, 0xd0, 0x83, 0xaf, 0xd1, 0xeb, 0x05, 0xc3, 0xf5, 0x2f, 0x4e, 0xba, 0x5e, 0xd2, 0x22, 0x77, 0x14, 0xfd, 0xb5, 0x0b, 0x9d, 0x9d, 0x9d, 0xd6, 0x81, 0x4f, 0x62, 0xf6, 0x27, 0x2f, 0xcd, 0x5c, 0xdb, 0xce, 0x7a, 0x9e, 0xf7, 0x97 }
,
  /* Salt */
  20,
  { 0xc2, 0x5f, 0x13, 0xbf, 0x67, 0xd0, 0x81, 0x67, 0x1a, 0x04, 0x81, 0xa1, 0xf1, 0x82, 0x0d, 0x61, 0x3b, 0xba, 0x22, 0x76 }
,
  /* Signature */
  192,
  { 0xa7, 0xfd, 0xb0, 0xd2, 0x59, 0x16, 0x5c, 0xa2, 0xc8, 0x8d, 0x00, 0xbb, 0xf1, 0x02, 0x8a, 0x86, 0x7d, 0x33, 0x76, 0x99, 0xd0, 0x61, 0x19, 0x3b, 0x17, 0xa9, 0x64, 0x8e, 0x14, 0xcc, 0xbb, 0xaa, 0xde, 0xac, 0xaa, 0xcd, 0xec, 0x81, 0x5e, 0x75, 0x71, 0x29, 0x4e, 0xbb, 0x8a, 0x11, 0x7a, 0xf2, 0x05, 0xfa, 0x07, 0x8b, 0x47, 0xb0, 0x71, 0x2c, 0x19, 0x9e, 0x3a, 0xd0, 0x51, 0x35, 0xc5, 0x04, 0xc2, 0x4b, 0x81, 0x70, 0x51, 0x15, 0x74, 0x08, 0x02, 0x48, 0x79, 0x92, 0xff, 0xd5, 0x11, 0xd4, 0xaf, 0xc6, 0xb8, 0x54, 0x49, 0x1e, 0xb3, 0xf0, 0xdd, 0x52, 0x31, 0x39, 0x54, 0x2f, 0xf1, 0x5c, 0x31, 0x01, 0xee, 0x85, 0x54, 0x35, 0x17, 0xc6, 0xa3, 0xc7, 0x94, 0x17, 0xc6, 0x7e, 0x2d, 0xd9, 0xaa, 0x74, 0x1e, 0x9a, 0x29, 0xb0, 0x6d, 0xcb, 0x59, 0x3c, 0x23, 0x36, 0xb3, 0x67, 0x0a, 0xe3, 0xaf, 0xba, 0xc7, 0xc3, 0xe7, 0x6e, 0x21, 0x54, 0x73, 0xe8, 0x66, 0xe3, 0x38, 0xca, 0x24, 0x4d, 0xe0, 0x0b, 0x62, 0x62, 0x4d, 0x6b, 0x94, 0x26, 0x82, 0x2c, 0xea, 0xe9, 0xf8, 0xcc, 0x46, 0x08, 0x95, 0xf4, 0x12, 0x50, 0x07, 0x3f, 0xd4, 0x5c, 0x5a, 0x1e, 0x7b, 0x42, 0x5c, 0x20, 0x4a, 0x42, 0x3a, 0x69, 0x91, 0x59, 0xf6, 0x90, 0x3e, 0x71, 0x0b, 0x37, 0xa7, 0xbb, 0x2b, 0xc8, 0x04, 0x9f }

}
,
#endif /* LTC_TEST_EXT */
}
},
{
  "Example 10: A 2048-bit RSA Key Pair",
{
  /* RSA modulus n */
  256,
  { 0xa5, 0xdd, 0x86, 0x7a, 0xc4, 0xcb, 0x02, 0xf9, 0x0b, 0x94, 0x57, 0xd4, 0x8c, 0x14, 0xa7, 0x70, 0xef, 0x99, 0x1c, 0x56, 0xc3, 0x9c, 0x0e, 0xc6, 0x5f, 0xd1, 0x1a, 0xfa, 0x89, 0x37, 0xce, 0xa5, 0x7b, 0x9b, 0xe7, 0xac, 0x73, 0xb4, 0x5c, 0x00, 0x17, 0x61, 0x5b, 0x82, 0xd6, 0x22, 0xe3, 0x18, 0x75, 0x3b, 0x60, 0x27, 0xc0, 0xfd, 0x15, 0x7b, 0xe1, 0x2f, 0x80, 0x90, 0xfe, 0xe2, 0xa7, 0xad, 0xcd, 0x0e, 0xef, 0x75, 0x9f, 0x88, 0xba, 0x49, 0x97, 0xc7, 0xa4, 0x2d, 0x58, 0xc9, 0xaa, 0x12, 0xcb, 0x99, 0xae, 0x00, 0x1f, 0xe5, 0x21, 0xc1, 0x3b, 0xb5, 0x43, 0x14, 0x45, 0xa8, 0xd5, 0xae, 0x4f, 0x5e, 0x4c, 0x7e, 0x94, 0x8a, 0xc2, 0x27, 0xd3, 0x60, 0x40, 0x71, 0xf2, 0x0e, 0x57, 0x7e, 0x90, 0x5f, 0xbe, 0xb1, 0x5d, 0xfa, 0xf0, 0x6d, 0x1d, 0xe5, 0xae, 0x62, 0x53, 0xd6, 0x3a, 0x6a, 0x21, 0x20, 0xb3, 0x1a, 0x5d, 0xa5, 0xda, 0xbc, 0x95, 0x50, 0x60, 0x0e, 0x20, 0xf2, 0x7d, 0x37, 0x39, 0xe2, 0x62, 0x79, 0x25, 0xfe, 0xa3, 0xcc, 0x50, 0x9f, 0x21, 0xdf, 0xf0, 0x4e, 0x6e, 0xea, 0x45, 0x49, 0xc5, 0x40, 0xd6, 0x80, 0x9f, 0xf9, 0x30, 0x7e, 0xed, 0xe9, 0x1f, 0xff, 0x58, 0x73, 0x3d, 0x83, 0x85, 0xa2, 0x37, 0xd6, 0xd3, 0x70, 0x5a, 0x33, 0xe3, 0x91, 0x90, 0x09, 0x92, 0x07, 0x0d, 0xf7, 0xad, 0xf1, 0x35, 0x7c, 0xf7, 0xe3, 0x70, 0x0c, 0xe3, 0x66, 0x7d, 0xe8, 0x3f, 0x17, 0xb8, 0xdf, 0x17, 0x78, 0xdb, 0x38, 0x1d, 0xce, 0x09, 0xcb, 0x4a, 0xd0, 0x58, 0xa5, 0x11, 0x00, 0x1a, 0x73, 0x81, 0x98, 0xee, 0x27, 0xcf, 0x55, 0xa1, 0x3b, 0x75, 0x45, 0x39, 0x90, 0x65, 0x82, 0xec, 0x8b, 0x17, 0x4b, 0xd5, 0x8d, 0x5d, 0x1f, 0x3d, 0x76, 0x7c, 0x61, 0x37, 0x21, 0xae, 0x05 }
,
  /* RSA public exponent e */
  3,
  { 0x01, 0x00, 0x01 }
,
  /* RSA private exponent d */
  256,
  { 0x2d, 0x2f, 0xf5, 0x67, 0xb3, 0xfe, 0x74, 0xe0, 0x61, 0x91, 0xb7, 0xfd, 0xed, 0x6d, 0xe1, 0x12, 0x29, 0x0c, 0x67, 0x06, 0x92, 0x43, 0x0d, 0x59, 0x69, 0x18, 0x40, 0x47, 0xda, 0x23, 0x4c, 0x96, 0x93, 0xde, 0xed, 0x16, 0x73, 0xed, 0x42, 0x95, 0x39, 0xc9, 0x69, 0xd3, 0x72, 0xc0, 0x4d, 0x6b, 0x47, 0xe0, 0xf5, 0xb8, 0xce, 0xe0, 0x84, 0x3e, 0x5c, 0x22, 0x83, 0x5d, 0xbd, 0x3b, 0x05, 0xa0, 0x99, 0x79, 0x84, 0xae, 0x60, 0x58, 0xb1, 0x1b, 0xc4, 0x90, 0x7c, 0xbf, 0x67, 0xed, 0x84, 0xfa, 0x9a, 0xe2, 0x52, 0xdf, 0xb0, 0xd0, 0xcd, 0x49, 0xe6, 0x18, 0xe3, 0x5d, 0xfd, 0xfe, 0x59, 0xbc, 0xa3, 0xdd, 0xd6, 0x6c, 0x33, 0xce, 0xbb, 0xc7, 0x7a, 0xd4, 0x41, 0xaa, 0x69, 0x5e, 0x13, 0xe3, 0x24, 0xb5, 0x18, 0xf0, 0x1c, 0x60, 0xf5, 0xa8, 0x5c, 0x99, 0x4a, 0xd1, 0x79, 0xf2, 0xa6, 0xb5, 0xfb, 0xe9, 0x34, 0x02, 0xb1, 0x17, 0x67, 0xbe, 0x01, 0xbf, 0x07, 0x34, 0x44, 0xd6, 0xba, 0x1d, 0xd2, 0xbc, 0xa5, 0xbd, 0x07, 0x4d, 0x4a, 0x5f, 0xae, 0x35, 0x31, 0xad, 0x13, 0x03, 0xd8, 0x4b, 0x30, 0xd8, 0x97, 0x31, 0x8c, 0xbb, 0xba, 0x04, 0xe0, 0x3c, 0x2e, 0x66, 0xde, 0x6d, 0x91, 0xf8, 0x2f, 0x96, 0xea, 0x1d, 0x4b, 0xb5, 0x4a, 0x5a, 0xae, 0x10, 0x2d, 0x59, 0x46, 0x57, 0xf5, 0xc9, 0x78, 0x95, 0x53, 0x51, 0x2b, 0x29, 0x6d, 0xea, 0x29, 0xd8, 0x02, 0x31, 0x96, 0x35, 0x7e, 0x3e, 0x3a, 0x6e, 0x95, 0x8f, 0x39, 0xe3, 0xc2, 0x34, 0x40, 0x38, 0xea, 0x60, 0x4b, 0x31, 0xed, 0xc6, 0xf0, 0xf7, 0xff, 0x6e, 0x71, 0x81, 0xa5, 0x7c, 0x92, 0x82, 0x6a, 0x26, 0x8f, 0x86, 0x76, 0x8e, 0x96, 0xf8, 0x78, 0x56, 0x2f, 0xc7, 0x1d, 0x85, 0xd6, 0x9e, 0x44, 0x86, 0x12, 0xf7, 0x04, 0x8f }
,
  /* Prime p */
  128,
  { 0xcf, 0xd5, 0x02, 0x83, 0xfe, 0xee, 0xb9, 0x7f, 0x6f, 0x08, 0xd7, 0x3c, 0xbc, 0x7b, 0x38, 0x36, 0xf8, 0x2b, 0xbc, 0xd4, 0x99, 0x47, 0x9f, 0x5e, 0x6f, 0x76, 0xfd, 0xfc, 0xb8, 0xb3, 0x8c, 0x4f, 0x71, 0xdc, 0x9e, 0x88, 0xbd, 0x6a, 0x6f, 0x76, 0x37, 0x1a, 0xfd, 0x65, 0xd2, 0xaf, 0x18, 0x62, 0xb3, 0x2a, 0xfb, 0x34, 0xa9, 0x5f, 0x71, 0xb8, 0xb1, 0x32, 0x04, 0x3f, 0xfe, 0xbe, 0x3a, 0x95, 0x2b, 0xaf, 0x75, 0x92, 0x44, 0x81, 0x48, 0xc0, 0x3f, 0x9c, 0x69, 0xb1, 0xd6, 0x8e, 0x4c, 0xe5, 0xcf, 0x32, 0xc8, 0x6b, 0xaf, 0x46, 0xfe, 0xd3, 0x01, 0xca, 0x1a, 0xb4, 0x03, 0x06, 0x9b, 0x32, 0xf4, 0x56, 0xb9, 0x1f, 0x71, 0x89, 0x8a, 0xb0, 0x81, 0xcd, 0x8c, 0x42, 0x52, 0xef, 0x52, 0x71, 0x91, 0x5c, 0x97, 0x94, 0xb8, 0xf2, 0x95, 0x85, 0x1d, 0xa7, 0x51, 0x0f, 0x99, 0xcb, 0x73, 0xeb }
,
  /* Prime q */
  128,
  { 0xcc, 0x4e, 0x90, 0xd2, 0xa1, 0xb3, 0xa0, 0x65, 0xd3, 0xb2, 0xd1, 0xf5, 0xa8, 0xfc, 0xe3, 0x1b, 0x54, 0x44, 0x75, 0x66, 0x4e, 0xab, 0x56, 0x1d, 0x29, 0x71, 0xb9, 0x9f, 0xb7, 0xbe, 0xf8, 0x44, 0xe8, 0xec, 0x1f, 0x36, 0x0b, 0x8c, 0x2a, 0xc8, 0x35, 0x96, 0x92, 0x97, 0x1e, 0xa6, 0xa3, 0x8f, 0x72, 0x3f, 0xcc, 0x21, 0x1f, 0x5d, 0xbc, 0xb1, 0x77, 0xa0, 0xfd, 0xac, 0x51, 0x64, 0xa1, 0xd4, 0xff, 0x7f, 0xbb, 0x4e, 0x82, 0x99, 0x86, 0x35, 0x3c, 0xb9, 0x83, 0x65, 0x9a, 0x14, 0x8c, 0xdd, 0x42, 0x0c, 0x7d, 0x31, 0xba, 0x38, 0x22, 0xea, 0x90, 0xa3, 0x2b, 0xe4, 0x6c, 0x03, 0x0e, 0x8c, 0x17, 0xe1, 0xfa, 0x0a, 0xd3, 0x78, 0x59, 0xe0, 0x6b, 0x0a, 0xa6, 0xfa, 0x3b, 0x21, 0x6d, 0x9c, 0xbe, 0x6c, 0x0e, 0x22, 0x33, 0x97, 0x69, 0xc0, 0xa6, 0x15, 0x91, 0x3e, 0x5d, 0xa7, 0x19, 0xcf }
,
  /* p's CRT exponent dP */
  128,
  { 0x1c, 0x2d, 0x1f, 0xc3, 0x2f, 0x6b, 0xc4, 0x00, 0x4f, 0xd8, 0x5d, 0xfd, 0xe0, 0xfb, 0xbf, 0x9a, 0x4c, 0x38, 0xf9, 0xc7, 0xc4, 0xe4, 0x1d, 0xea, 0x1a, 0xa8, 0x82, 0x34, 0xa2, 0x01, 0xcd, 0x92, 0xf3, 0xb7, 0xda, 0x52, 0x65, 0x83, 0xa9, 0x8a, 0xd8, 0x5b, 0xb3, 0x60, 0xfb, 0x98, 0x3b, 0x71, 0x1e, 0x23, 0x44, 0x9d, 0x56, 0x1d, 0x17, 0x78, 0xd7, 0xa5, 0x15, 0x48, 0x6b, 0xcb, 0xf4, 0x7b, 0x46, 0xc9, 0xe9, 0xe1, 0xa3, 0xa1, 0xf7, 0x70, 0x00, 0xef, 0xbe, 0xb0, 0x9a, 0x8a, 0xfe, 0x47, 0xe5, 0xb8, 0x57, 0xcd, 0xa9, 0x9c, 0xb1, 0x6d, 0x7f, 0xff, 0x9b, 0x71, 0x2e, 0x3b, 0xd6, 0x0c, 0xa9, 0x6d, 0x9c, 0x79, 0x73, 0xd6, 0x16, 0xd4, 0x69, 0x34, 0xa9, 0xc0, 0x50, 0x28, 0x1c, 0x00, 0x43, 0x99, 0xce, 0xff, 0x1d, 0xb7, 0xdd, 0xa7, 0x87, 0x66, 0xa8, 0xa9, 0xb9, 0xcb, 0x08, 0x73 }
,
  /* q's CRT exponent dQ */
  128,
  { 0xcb, 0x3b, 0x3c, 0x04, 0xca, 0xa5, 0x8c, 0x60, 0xbe, 0x7d, 0x9b, 0x2d, 0xeb, 0xb3, 0xe3, 0x96, 0x43, 0xf4, 0xf5, 0x73, 0x97, 0xbe, 0x08, 0x23, 0x6a, 0x1e, 0x9e, 0xaf, 0xaa, 0x70, 0x65, 0x36, 0xe7, 0x1c, 0x3a, 0xcf, 0xe0, 0x1c, 0xc6, 0x51, 0xf2, 0x3c, 0x9e, 0x05, 0x85, 0x8f, 0xee, 0x13, 0xbb, 0x6a, 0x8a, 0xfc, 0x47, 0xdf, 0x4e, 0xdc, 0x9a, 0x4b, 0xa3, 0x0b, 0xce, 0xcb, 0x73, 0xd0, 0x15, 0x78, 0x52, 0x32, 0x7e, 0xe7, 0x89, 0x01, 0x5c, 0x2e, 0x8d, 0xee, 0x7b, 0x9f, 0x05, 0xa0, 0xf3, 0x1a, 0xc9, 0x4e, 0xb6, 0x17, 0x31, 0x64, 0x74, 0x0c, 0x5c, 0x95, 0x14, 0x7c, 0xd5, 0xf3, 0xb5, 0xae, 0x2c, 0xb4, 0xa8, 0x37, 0x87, 0xf0, 0x1d, 0x8a, 0xb3, 0x1f, 0x27, 0xc2, 0xd0, 0xee, 0xa2, 0xdd, 0x8a, 0x11, 0xab, 0x90, 0x6a, 0xba, 0x20, 0x7c, 0x43, 0xc6, 0xee, 0x12, 0x53, 0x31 }
,
  /* CRT coefficient qInv */
  128,
  { 0x12, 0xf6, 0xb2, 0xcf, 0x13, 0x74, 0xa7, 0x36, 0xfa, 0xd0, 0x56, 0x16, 0x05, 0x0f, 0x96, 0xab, 0x4b, 0x61, 0xd1, 0x17, 0x7c, 0x7f, 0x9d, 0x52, 0x5a, 0x29, 0xf3, 0xd1, 0x80, 0xe7, 0x76, 0x67, 0xe9, 0x9d, 0x99, 0xab, 0xf0, 0x52, 0x5d, 0x07, 0x58, 0x66, 0x0f, 0x37, 0x52, 0x65, 0x5b, 0x0f, 0x25, 0xb8, 0xdf, 0x84, 0x31, 0xd9, 0xa8, 0xff, 0x77, 0xc1, 0x6c, 0x12, 0xa0, 0xa5, 0x12, 0x2a, 0x9f, 0x0b, 0xf7, 0xcf, 0xd5, 0xa2, 0x66, 0xa3, 0x5c, 0x15, 0x9f, 0x99, 0x12, 0x08, 0xb9, 0x03, 0x16, 0xff, 0x44, 0x4f, 0x3e, 0x0b, 0x6b, 0xd0, 0xe9, 0x3b, 0x8a, 0x7a, 0x24, 0x48, 0xe9, 0x57, 0xe3, 0xdd, 0xa6, 0xcf, 0xcf, 0x22, 0x66, 0xb1, 0x06, 0x01, 0x3a, 0xc4, 0x68, 0x08, 0xd3, 0xb3, 0x88, 0x7b, 0x3b, 0x00, 0x34, 0x4b, 0xaa, 0xc9, 0x53, 0x0b, 0x4c, 0xe7, 0x08, 0xfc, 0x32, 0xb6 }

}
,
{{
  "RSASSA-PSS Signature Example 10.1",
  /* Message to be signed */
  29,
  { 0x88, 0x31, 0x77, 0xe5, 0x12, 0x6b, 0x9b, 0xe2, 0xd9, 0xa9, 0x68, 0x03, 0x27, 0xd5, 0x37, 0x0c, 0x6f, 0x26, 0x86, 0x1f, 0x58, 0x20, 0xc4, 0x3d, 0xa6, 0x7a, 0x3a, 0xd6, 0x09 }
,
  /* Salt */
  20,
  { 0x04, 0xe2, 0x15, 0xee, 0x6f, 0xf9, 0x34, 0xb9, 0xda, 0x70, 0xd7, 0x73, 0x0c, 0x87, 0x34, 0xab, 0xfc, 0xec, 0xde, 0x89 }
,
  /* Signature */
  256,
  { 0x82, 0xc2, 0xb1, 0x60, 0x09, 0x3b, 0x8a, 0xa3, 0xc0, 0xf7, 0x52, 0x2b, 0x19, 0xf8, 0x73, 0x54, 0x06, 0x6c, 0x77, 0x84, 0x7a, 0xbf, 0x2a, 0x9f, 0xce, 0x54, 0x2d, 0x0e, 0x84, 0xe9, 0x20, 0xc5, 0xaf, 0xb4, 0x9f, 0xfd, 0xfd, 0xac, 0xe1, 0x65, 0x60, 0xee, 0x94, 0xa1, 0x36, 0x96, 0x01, 0x14, 0x8e, 0xba, 0xd7, 0xa0, 0xe1, 0x51, 0xcf, 0x16, 0x33, 0x17, 0x91, 0xa5, 0x72, 0x7d, 0x05, 0xf2, 0x1e, 0x74, 0xe7, 0xeb, 0x81, 0x14, 0x40, 0x20, 0x69, 0x35, 0xd7, 0x44, 0x76, 0x5a, 0x15, 0xe7, 0x9f, 0x01, 0x5c, 0xb6, 0x6c, 0x53, 0x2c, 0x87, 0xa6, 0xa0, 0x59, 0x61, 0xc8, 0xbf, 0xad, 0x74, 0x1a, 0x9a, 0x66, 0x57, 0x02, 0x28, 0x94, 0x39, 0x3e, 0x72, 0x23, 0x73, 0x97, 0x96, 0xc0, 0x2a, 0x77, 0x45, 0x5d, 0x0f, 0x55, 0x5b, 0x0e, 0xc0, 0x1d, 0xdf, 0x25, 0x9b, 0x62, 0x07, 0xfd, 0x0f, 0xd5, 0x76, 0x14, 0xce, 0xf1, 0xa5, 0x57, 0x3b, 0xaa, 0xff, 0x4e, 0xc0, 0x00, 0x69, 0x95, 0x16, 0x59, 0xb8, 0x5f, 0x24, 0x30, 0x0a, 0x25, 0x16, 0x0c, 0xa8, 0x52, 0x2d, 0xc6, 0xe6, 0x72, 0x7e, 0x57, 0xd0, 0x19, 0xd7, 0xe6, 0x36, 0x29, 0xb8, 0xfe, 0x5e, 0x89, 0xe2, 0x5c, 0xc1, 0x5b, 0xeb, 0x3a, 0x64, 0x75, 0x77, 0x55, 0x92, 0x99, 0x28, 0x0b, 0x9b, 0x28, 0xf7, 0x9b, 0x04, 0x09, 0x00, 0x0b, 0xe2, 0x5b, 0xbd, 0x96, 0x40, 0x8b, 0xa3, 0xb4, 0x3c, 0xc4, 0x86, 0x18, 0x4d, 0xd1, 0xc8, 0xe6, 0x25, 0x53, 0xfa, 0x1a, 0xf4, 0x04, 0x0f, 0x60, 0x66, 0x3d, 0xe7, 0xf5, 0xe4, 0x9c, 0x04, 0x38, 0x8e, 0x25, 0x7f, 0x1c, 0xe8, 0x9c, 0x95, 0xda, 0xb4, 0x8a, 0x31, 0x5d, 0x9b, 0x66, 0xb1, 0xb7, 0x62, 0x82, 0x33, 0x87, 0x6f, 0xf2, 0x38, 0x52, 0x30, 0xd0, 0x70, 0xd0, 0x7e, 0x16, 0x66 }

}
,
#ifdef LTC_TEST_EXT
{
  "RSASSA-PSS Signature Example 10.2",
  /* Message to be signed */
  128,
  { 0xdd, 0x67, 0x0a, 0x01, 0x46, 0x58, 0x68, 0xad, 0xc9, 0x3f, 0x26, 0x13, 0x19, 0x57, 0xa5, 0x0c, 0x52, 0xfb, 0x77, 0x7c, 0xdb, 0xaa, 0x30, 0x89, 0x2c, 0x9e, 0x12, 0x36, 0x11, 0x64, 0xec, 0x13, 0x97, 0x9d, 0x43, 0x04, 0x81, 0x18, 0xe4, 0x44, 0x5d, 0xb8, 0x7b, 0xee, 0x58, 0xdd, 0x98, 0x7b, 0x34, 0x25, 0xd0, 0x20, 0x71, 0xd8, 0xdb, 0xae, 0x80, 0x70, 0x8b, 0x03, 0x9d, 0xbb, 0x64, 0xdb, 0xd1, 0xde, 0x56, 0x57, 0xd9, 0xfe, 0xd0, 0xc1, 0x18, 0xa5, 0x41, 0x43, 0x74, 0x2e, 0x0f, 0xf3, 0xc8, 0x7f, 0x74, 0xe4, 0x58, 0x57, 0x64, 0x7a, 0xf3, 0xf7, 0x9e, 0xb0, 0xa1, 0x4c, 0x9d, 0x75, 0xea, 0x9a, 0x1a, 0x04, 0xb7, 0xcf, 0x47, 0x8a, 0x89, 0x7a, 0x70, 0x8f, 0xd9, 0x88, 0xf4, 0x8e, 0x80, 0x1e, 0xdb, 0x0b, 0x70, 0x39, 0xdf, 0x8c, 0x23, 0xbb, 0x3c, 0x56, 0xf4, 0xe8, 0x21, 0xac }
,
  /* Salt */
  20,
  { 0x8b, 0x2b, 0xdd, 0x4b, 0x40, 0xfa, 0xf5, 0x45, 0xc7, 0x78, 0xdd, 0xf9, 0xbc, 0x1a, 0x49, 0xcb, 0x57, 0xf9, 0xb7, 0x1b }
,
  /* Signature */
  256,
  { 0x14, 0xae, 0x35, 0xd9, 0xdd, 0x06, 0xba, 0x92, 0xf7, 0xf3, 0xb8, 0x97, 0x97, 0x8a, 0xed, 0x7c, 0xd4, 0xbf, 0x5f, 0xf0, 0xb5, 0x85, 0xa4, 0x0b, 0xd4, 0x6c, 0xe1, 0xb4, 0x2c, 0xd2, 0x70, 0x30, 0x53, 0xbb, 0x90, 0x44, 0xd6, 0x4e, 0x81, 0x3d, 0x8f, 0x96, 0xdb, 0x2d, 0xd7, 0x00, 0x7d, 0x10, 0x11, 0x8f, 0x6f, 0x8f, 0x84, 0x96, 0x09, 0x7a, 0xd7, 0x5e, 0x1f, 0xf6, 0x92, 0x34, 0x1b, 0x28, 0x92, 0xad, 0x55, 0xa6, 0x33, 0xa1, 0xc5, 0x5e, 0x7f, 0x0a, 0x0a, 0xd5, 0x9a, 0x0e, 0x20, 0x3a, 0x5b, 0x82, 0x78, 0xae, 0xc5, 0x4d, 0xd8, 0x62, 0x2e, 0x28, 0x31, 0xd8, 0x71, 0x74, 0xf8, 0xca, 0xff, 0x43, 0xee, 0x6c, 0x46, 0x44, 0x53, 0x45, 0xd8, 0x4a, 0x59, 0x65, 0x9b, 0xfb, 0x92, 0xec, 0xd4, 0xc8, 0x18, 0x66, 0x86, 0x95, 0xf3, 0x47, 0x06, 0xf6, 0x68, 0x28, 0xa8, 0x99, 0x59, 0x63, 0x7f, 0x2b, 0xf3, 0xe3, 0x25, 0x1c, 0x24, 0xbd, 0xba, 0x4d, 0x4b, 0x76, 0x49, 0xda, 0x00, 0x22, 0x21, 0x8b, 0x11, 0x9c, 0x84, 0xe7, 0x9a, 0x65, 0x27, 0xec, 0x5b, 0x8a, 0x5f, 0x86, 0x1c, 0x15, 0x99, 0x52, 0xe2, 0x3e, 0xc0, 0x5e, 0x1e, 0x71, 0x73, 0x46, 0xfa, 0xef, 0xe8, 0xb1, 0x68, 0x68, 0x25, 0xbd, 0x2b, 0x26, 0x2f, 0xb2, 0x53, 0x10, 0x66, 0xc0, 0xde, 0x09, 0xac, 0xde, 0x2e, 0x42, 0x31, 0x69, 0x07, 0x28, 0xb5, 0xd8, 0x5e, 0x11, 0x5a, 0x2f, 0x6b, 0x92, 0xb7, 0x9c, 0x25, 0xab, 0xc9, 0xbd, 0x93, 0x99, 0xff, 0x8b, 0xcf, 0x82, 0x5a, 0x52, 0xea, 0x1f, 0x56, 0xea, 0x76, 0xdd, 0x26, 0xf4, 0x3b, 0xaa, 0xfa, 0x18, 0xbf, 0xa9, 0x2a, 0x50, 0x4c, 0xbd, 0x35, 0x69, 0x9e, 0x26, 0xd1, 0xdc, 0xc5, 0xa2, 0x88, 0x73, 0x85, 0xf3, 0xc6, 0x32, 0x32, 0xf0, 0x6f, 0x32, 0x44, 0xc3 }

}
,
{
  "RSASSA-PSS Signature Example 10.3",
  /* Message to be signed */
  110,
  { 0x48, 0xb2, 0xb6, 0xa5, 0x7a, 0x63, 0xc8, 0x4c, 0xea, 0x85, 0x9d, 0x65, 0xc6, 0x68, 0x28, 0x4b, 0x08, 0xd9, 0x6b, 0xdc, 0xaa, 0xbe, 0x25, 0x2d, 0xb0, 0xe4, 0xa9, 0x6c, 0xb1, 0xba, 0xc6, 0x01, 0x93, 0x41, 0xdb, 0x6f, 0xbe, 0xfb, 0x8d, 0x10, 0x6b, 0x0e, 0x90, 0xed, 0xa6, 0xbc, 0xc6, 0xc6, 0x26, 0x2f, 0x37, 0xe7, 0xea, 0x9c, 0x7e, 0x5d, 0x22, 0x6b, 0xd7, 0xdf, 0x85, 0xec, 0x5e, 0x71, 0xef, 0xff, 0x2f, 0x54, 0xc5, 0xdb, 0x57, 0x7f, 0xf7, 0x29, 0xff, 0x91, 0xb8, 0x42, 0x49, 0x1d, 0xe2, 0x74, 0x1d, 0x0c, 0x63, 0x16, 0x07, 0xdf, 0x58, 0x6b, 0x90, 0x5b, 0x23, 0xb9, 0x1a, 0xf1, 0x3d, 0xa1, 0x23, 0x04, 0xbf, 0x83, 0xec, 0xa8, 0xa7, 0x3e, 0x87, 0x1f, 0xf9, 0xdb }
,
  /* Salt */
  20,
  { 0x4e, 0x96, 0xfc, 0x1b, 0x39, 0x8f, 0x92, 0xb4, 0x46, 0x71, 0x01, 0x0c, 0x0d, 0xc3, 0xef, 0xd6, 0xe2, 0x0c, 0x2d, 0x73 }
,
  /* Signature */
  256,
  { 0x6e, 0x3e, 0x4d, 0x7b, 0x6b, 0x15, 0xd2, 0xfb, 0x46, 0x01, 0x3b, 0x89, 0x00, 0xaa, 0x5b, 0xbb, 0x39, 0x39, 0xcf, 0x2c, 0x09, 0x57, 0x17, 0x98, 0x70, 0x42, 0x02, 0x6e, 0xe6, 0x2c, 0x74, 0xc5, 0x4c, 0xff, 0xd5, 0xd7, 0xd5, 0x7e, 0xfb, 0xbf, 0x95, 0x0a, 0x0f, 0x5c, 0x57, 0x4f, 0xa0, 0x9d, 0x3f, 0xc1, 0xc9, 0xf5, 0x13, 0xb0, 0x5b, 0x4f, 0xf5, 0x0d, 0xd8, 0xdf, 0x7e, 0xdf, 0xa2, 0x01, 0x02, 0x85, 0x4c, 0x35, 0xe5, 0x92, 0x18, 0x01, 0x19, 0xa7, 0x0c, 0xe5, 0xb0, 0x85, 0x18, 0x2a, 0xa0, 0x2d, 0x9e, 0xa2, 0xaa, 0x90, 0xd1, 0xdf, 0x03, 0xf2, 0xda, 0xae, 0x88, 0x5b, 0xa2, 0xf5, 0xd0, 0x5a, 0xfd, 0xac, 0x97, 0x47, 0x6f, 0x06, 0xb9, 0x3b, 0x5b, 0xc9, 0x4a, 0x1a, 0x80, 0xaa, 0x91, 0x16, 0xc4, 0xd6, 0x15, 0xf3, 0x33, 0xb0, 0x98, 0x89, 0x2b, 0x25, 0xff, 0xac, 0xe2, 0x66, 0xf5, 0xdb, 0x5a, 0x5a, 0x3b, 0xcc, 0x10, 0xa8, 0x24, 0xed, 0x55, 0xaa, 0xd3, 0x5b, 0x72, 0x78, 0x34, 0xfb, 0x8c, 0x07, 0xda, 0x28, 0xfc, 0xf4, 0x16, 0xa5, 0xd9, 0xb2, 0x22, 0x4f, 0x1f, 0x8b, 0x44, 0x2b, 0x36, 0xf9, 0x1e, 0x45, 0x6f, 0xde, 0xa2, 0xd7, 0xcf, 0xe3, 0x36, 0x72, 0x68, 0xde, 0x03, 0x07, 0xa4, 0xc7, 0x4e, 0x92, 0x41, 0x59, 0xed, 0x33, 0x39, 0x3d, 0x5e, 0x06, 0x55, 0x53, 0x1c, 0x77, 0x32, 0x7b, 0x89, 0x82, 0x1b, 0xde, 0xdf, 0x88, 0x01, 0x61, 0xc7, 0x8c, 0xd4, 0x19, 0x6b, 0x54, 0x19, 0xf7, 0xac, 0xc3, 0xf1, 0x3e, 0x5e, 0xbf, 0x16, 0x1b, 0x6e, 0x7c, 0x67, 0x24, 0x71, 0x6c, 0xa3, 0x3b, 0x85, 0xc2, 0xe2, 0x56, 0x40, 0x19, 0x2a, 0xc2, 0x85, 0x96, 0x51, 0xd5, 0x0b, 0xde, 0x7e, 0xb9, 0x76, 0xe5, 0x1c, 0xec, 0x82, 0x8b, 0x98, 0xb6, 0x56, 0x3b, 0x86, 0xbb }

}
,
{
  "RSASSA-PSS Signature Example 10.4",
  /* Message to be signed */
  81,
  { 0x0b, 0x87, 0x77, 0xc7, 0xf8, 0x39, 0xba, 0xf0, 0xa6, 0x4b, 0xbb, 0xdb, 0xc5, 0xce, 0x79, 0x75, 0x5c, 0x57, 0xa2, 0x05, 0xb8, 0x45, 0xc1, 0x74, 0xe2, 0xd2, 0xe9, 0x05, 0x46, 0xa0, 0x89, 0xc4, 0xe6, 0xec, 0x8a, 0xdf, 0xfa, 0x23, 0xa7, 0xea, 0x97, 0xba, 0xe6, 0xb6, 0x5d, 0x78, 0x2b, 0x82, 0xdb, 0x5d, 0x2b, 0x5a, 0x56, 0xd2, 0x2a, 0x29, 0xa0, 0x5e, 0x7c, 0x44, 0x33, 0xe2, 0xb8, 0x2a, 0x62, 0x1a, 0xbb, 0xa9, 0x0a, 0xdd, 0x05, 0xce, 0x39, 0x3f, 0xc4, 0x8a, 0x84, 0x05, 0x42, 0x45, 0x1a }
,
  /* Salt */
  20,
  { 0xc7, 0xcd, 0x69, 0x8d, 0x84, 0xb6, 0x51, 0x28, 0xd8, 0x83, 0x5e, 0x3a, 0x8b, 0x1e, 0xb0, 0xe0, 0x1c, 0xb5, 0x41, 0xec }
,
  /* Signature */
  256,
  { 0x34, 0x04, 0x7f, 0xf9, 0x6c, 0x4d, 0xc0, 0xdc, 0x90, 0xb2, 0xd4, 0xff, 0x59, 0xa1, 0xa3, 0x61, 0xa4, 0x75, 0x4b, 0x25, 0x5d, 0x2e, 0xe0, 0xaf, 0x7d, 0x8b, 0xf8, 0x7c, 0x9b, 0xc9, 0xe7, 0xdd, 0xee, 0xde, 0x33, 0x93, 0x4c, 0x63, 0xca, 0x1c, 0x0e, 0x3d, 0x26, 0x2c, 0xb1, 0x45, 0xef, 0x93, 0x2a, 0x1f, 0x2c, 0x0a, 0x99, 0x7a, 0xa6, 0xa3, 0x4f, 0x8e, 0xae, 0xe7, 0x47, 0x7d, 0x82, 0xcc, 0xf0, 0x90, 0x95, 0xa6, 0xb8, 0xac, 0xad, 0x38, 0xd4, 0xee, 0xc9, 0xfb, 0x7e, 0xab, 0x7a, 0xd0, 0x2d, 0xa1, 0xd1, 0x1d, 0x8e, 0x54, 0xc1, 0x82, 0x5e, 0x55, 0xbf, 0x58, 0xc2, 0xa2, 0x32, 0x34, 0xb9, 0x02, 0xbe, 0x12, 0x4f, 0x9e, 0x90, 0x38, 0xa8, 0xf6, 0x8f, 0xa4, 0x5d, 0xab, 0x72, 0xf6, 0x6e, 0x09, 0x45, 0xbf, 0x1d, 0x8b, 0xac, 0xc9, 0x04, 0x4c, 0x6f, 0x07, 0x09, 0x8c, 0x9f, 0xce, 0xc5, 0x8a, 0x3a, 0xab, 0x10, 0x0c, 0x80, 0x51, 0x78, 0x15, 0x5f, 0x03, 0x0a, 0x12, 0x4c, 0x45, 0x0e, 0x5a, 0xcb, 0xda, 0x47, 0xd0, 0xe4, 0xf1, 0x0b, 0x80, 0xa2, 0x3f, 0x80, 0x3e, 0x77, 0x4d, 0x02, 0x3b, 0x00, 0x15, 0xc2, 0x0b, 0x9f, 0x9b, 0xbe, 0x7c, 0x91, 0x29, 0x63, 0x38, 0xd5, 0xec, 0xb4, 0x71, 0xca, 0xfb, 0x03, 0x20, 0x07, 0xb6, 0x7a, 0x60, 0xbe, 0x5f, 0x69, 0x50, 0x4a, 0x9f, 0x01, 0xab, 0xb3, 0xcb, 0x46, 0x7b, 0x26, 0x0e, 0x2b, 0xce, 0x86, 0x0b, 0xe8, 0xd9, 0x5b, 0xf9, 0x2c, 0x0c, 0x8e, 0x14, 0x96, 0xed, 0x1e, 0x52, 0x85, 0x93, 0xa4, 0xab, 0xb6, 0xdf, 0x46, 0x2d, 0xde, 0x8a, 0x09, 0x68, 0xdf, 0xfe, 0x46, 0x83, 0x11, 0x68, 0x57, 0xa2, 0x32, 0xf5, 0xeb, 0xf6, 0xc8, 0x5b, 0xe2, 0x38, 0x74, 0x5a, 0xd0, 0xf3, 0x8f, 0x76, 0x7a, 0x5f, 0xdb, 0xf4, 0x86, 0xfb }

}
,
{
  "RSASSA-PSS Signature Example 10.5",
  /* Message to be signed */
  81,
  { 0xf1, 0x03, 0x6e, 0x00, 0x8e, 0x71, 0xe9, 0x64, 0xda, 0xdc, 0x92, 0x19, 0xed, 0x30, 0xe1, 0x7f, 0x06, 0xb4, 0xb6, 0x8a, 0x95, 0x5c, 0x16, 0xb3, 0x12, 0xb1, 0xed, 0xdf, 0x02, 0x8b, 0x74, 0x97, 0x6b, 0xed, 0x6b, 0x3f, 0x6a, 0x63, 0xd4, 0xe7, 0x78, 0x59, 0x24, 0x3c, 0x9c, 0xcc, 0xdc, 0x98, 0x01, 0x65, 0x23, 0xab, 0xb0, 0x24, 0x83, 0xb3, 0x55, 0x91, 0xc3, 0x3a, 0xad, 0x81, 0x21, 0x3b, 0xb7, 0xc7, 0xbb, 0x1a, 0x47, 0x0a, 0xab, 0xc1, 0x0d, 0x44, 0x25, 0x6c, 0x4d, 0x45, 0x59, 0xd9, 0x16 }
,
  /* Salt */
  20,
  { 0xef, 0xa8, 0xbf, 0xf9, 0x62, 0x12, 0xb2, 0xf4, 0xa3, 0xf3, 0x71, 0xa1, 0x0d, 0x57, 0x41, 0x52, 0x65, 0x5f, 0x5d, 0xfb }
,
  /* Signature */
  256,
  { 0x7e, 0x09, 0x35, 0xea, 0x18, 0xf4, 0xd6, 0xc1, 0xd1, 0x7c, 0xe8, 0x2e, 0xb2, 0xb3, 0x83, 0x6c, 0x55, 0xb3, 0x84, 0x58, 0x9c, 0xe1, 0x9d, 0xfe, 0x74, 0x33, 0x63, 0xac, 0x99, 0x48, 0xd1, 0xf3, 0x46, 0xb7, 0xbf, 0xdd, 0xfe, 0x92, 0xef, 0xd7, 0x8a, 0xdb, 0x21, 0xfa, 0xef, 0xc8, 0x9a, 0xde, 0x42, 0xb1, 0x0f, 0x37, 0x40, 0x03, 0xfe, 0x12, 0x2e, 0x67, 0x42, 0x9a, 0x1c, 0xb8, 0xcb, 0xd1, 0xf8, 0xd9, 0x01, 0x45, 0x64, 0xc4, 0x4d, 0x12, 0x01, 0x16, 0xf4, 0x99, 0x0f, 0x1a, 0x6e, 0x38, 0x77, 0x4c, 0x19, 0x4b, 0xd1, 0xb8, 0x21, 0x32, 0x86, 0xb0, 0x77, 0xb0, 0x49, 0x9d, 0x2e, 0x7b, 0x3f, 0x43, 0x4a, 0xb1, 0x22, 0x89, 0xc5, 0x56, 0x68, 0x4d, 0xee, 0xd7, 0x81, 0x31, 0x93, 0x4b, 0xb3, 0xdd, 0x65, 0x37, 0x23, 0x6f, 0x7c, 0x6f, 0x3d, 0xcb, 0x09, 0xd4, 0x76, 0xbe, 0x07, 0x72, 0x1e, 0x37, 0xe1, 0xce, 0xed, 0x9b, 0x2f, 0x7b, 0x40, 0x68, 0x87, 0xbd, 0x53, 0x15, 0x73, 0x05, 0xe1, 0xc8, 0xb4, 0xf8, 0x4d, 0x73, 0x3b, 0xc1, 0xe1, 0x86, 0xfe, 0x06, 0xcc, 0x59, 0xb6, 0xed, 0xb8, 0xf4, 0xbd, 0x7f, 0xfe, 0xfd, 0xf4, 0xf7, 0xba, 0x9c, 0xfb, 0x9d, 0x57, 0x06, 0x89, 0xb5, 0xa1, 0xa4, 0x10, 0x9a, 0x74, 0x6a, 0x69, 0x08, 0x93, 0xdb, 0x37, 0x99, 0x25, 0x5a, 0x0c, 0xb9, 0x21, 0x5d, 0x2d, 0x1c, 0xd4, 0x90, 0x59, 0x0e, 0x95, 0x2e, 0x8c, 0x87, 0x86, 0xaa, 0x00, 0x11, 0x26, 0x52, 0x52, 0x47, 0x0c, 0x04, 0x1d, 0xfb, 0xc3, 0xee, 0xc7, 0xc3, 0xcb, 0xf7, 0x1c, 0x24, 0x86, 0x9d, 0x11, 0x5c, 0x0c, 0xb4, 0xa9, 0x56, 0xf5, 0x6d, 0x53, 0x0b, 0x80, 0xab, 0x58, 0x9a, 0xcf, 0xef, 0xc6, 0x90, 0x75, 0x1d, 0xdf, 0x36, 0xe8, 0xd3, 0x83, 0xf8, 0x3c, 0xed, 0xd2, 0xcc }

}
,
{
  "RSASSA-PSS Signature Example 10.6",
  /* Message to be signed */
  163,
  { 0x25, 0xf1, 0x08, 0x95, 0xa8, 0x77, 0x16, 0xc1, 0x37, 0x45, 0x0b, 0xb9, 0x51, 0x9d, 0xfa, 0xa1, 0xf2, 0x07, 0xfa, 0xa9, 0x42, 0xea, 0x88, 0xab, 0xf7, 0x1e, 0x9c, 0x17, 0x98, 0x00, 0x85, 0xb5, 0x55, 0xae, 0xba, 0xb7, 0x62, 0x64, 0xae, 0x2a, 0x3a, 0xb9, 0x3c, 0x2d, 0x12, 0x98, 0x11, 0x91, 0xdd, 0xac, 0x6f, 0xb5, 0x94, 0x9e, 0xb3, 0x6a, 0xee, 0x3c, 0x5d, 0xa9, 0x40, 0xf0, 0x07, 0x52, 0xc9, 0x16, 0xd9, 0x46, 0x08, 0xfa, 0x7d, 0x97, 0xba, 0x6a, 0x29, 0x15, 0xb6, 0x88, 0xf2, 0x03, 0x23, 0xd4, 0xe9, 0xd9, 0x68, 0x01, 0xd8, 0x9a, 0x72, 0xab, 0x58, 0x92, 0xdc, 0x21, 0x17, 0xc0, 0x74, 0x34, 0xfc, 0xf9, 0x72, 0xe0, 0x58, 0xcf, 0x8c, 0x41, 0xca, 0x4b, 0x4f, 0xf5, 0x54, 0xf7, 0xd5, 0x06, 0x8a, 0xd3, 0x15, 0x5f, 0xce, 0xd0, 0xf3, 0x12, 0x5b, 0xc0, 0x4f, 0x91, 0x93, 0x37, 0x8a, 0x8f, 0x5c, 0x4c, 0x3b, 0x8c, 0xb4, 0xdd, 0x6d, 0x1c, 0xc6, 0x9d, 0x30, 0xec, 0xca, 0x6e, 0xaa, 0x51, 0xe3, 0x6a, 0x05, 0x73, 0x0e, 0x9e, 0x34, 0x2e, 0x85, 0x5b, 0xaf, 0x09, 0x9d, 0xef, 0xb8, 0xaf, 0xd7 }
,
  /* Salt */
  20,
  { 0xad, 0x8b, 0x15, 0x23, 0x70, 0x36, 0x46, 0x22, 0x4b, 0x66, 0x0b, 0x55, 0x08, 0x85, 0x91, 0x7c, 0xa2, 0xd1, 0xdf, 0x28 }
,
  /* Signature */
  256,
  { 0x6d, 0x3b, 0x5b, 0x87, 0xf6, 0x7e, 0xa6, 0x57, 0xaf, 0x21, 0xf7, 0x54, 0x41, 0x97, 0x7d, 0x21, 0x80, 0xf9, 0x1b, 0x2c, 0x5f, 0x69, 0x2d, 0xe8, 0x29, 0x55, 0x69, 0x6a, 0x68, 0x67, 0x30, 0xd9, 0xb9, 0x77, 0x8d, 0x97, 0x07, 0x58, 0xcc, 0xb2, 0x60, 0x71, 0xc2, 0x20, 0x9f, 0xfb, 0xd6, 0x12, 0x5b, 0xe2, 0xe9, 0x6e, 0xa8, 0x1b, 0x67, 0xcb, 0x9b, 0x93, 0x08, 0x23, 0x9f, 0xda, 0x17, 0xf7, 0xb2, 0xb6, 0x4e, 0xcd, 0xa0, 0x96, 0xb6, 0xb9, 0x35, 0x64, 0x0a, 0x5a, 0x1c, 0xb4, 0x2a, 0x91, 0x55, 0xb1, 0xc9, 0xef, 0x7a, 0x63, 0x3a, 0x02, 0xc5, 0x9f, 0x0d, 0x6e, 0xe5, 0x9b, 0x85, 0x2c, 0x43, 0xb3, 0x50, 0x29, 0xe7, 0x3c, 0x94, 0x0f, 0xf0, 0x41, 0x0e, 0x8f, 0x11, 0x4e, 0xed, 0x46, 0xbb, 0xd0, 0xfa, 0xe1, 0x65, 0xe4, 0x2b, 0xe2, 0x52, 0x8a, 0x40, 0x1c, 0x3b, 0x28, 0xfd, 0x81, 0x8e, 0xf3, 0x23, 0x2d, 0xca, 0x9f, 0x4d, 0x2a, 0x0f, 0x51, 0x66, 0xec, 0x59, 0xc4, 0x23, 0x96, 0xd6, 0xc1, 0x1d, 0xbc, 0x12, 0x15, 0xa5, 0x6f, 0xa1, 0x71, 0x69, 0xdb, 0x95, 0x75, 0x34, 0x3e, 0xf3, 0x4f, 0x9d, 0xe3, 0x2a, 0x49, 0xcd, 0xc3, 0x17, 0x49, 0x22, 0xf2, 0x29, 0xc2, 0x3e, 0x18, 0xe4, 0x5d, 0xf9, 0x35, 0x31, 0x19, 0xec, 0x43, 0x19, 0xce, 0xdc, 0xe7, 0xa1, 0x7c, 0x64, 0x08, 0x8c, 0x1f, 0x6f, 0x52, 0xbe, 0x29, 0x63, 0x41, 0x00, 0xb3, 0x91, 0x9d, 0x38, 0xf3, 0xd1, 0xed, 0x94, 0xe6, 0x89, 0x1e, 0x66, 0xa7, 0x3b, 0x8f, 0xb8, 0x49, 0xf5, 0x87, 0x4d, 0xf5, 0x94, 0x59, 0xe2, 0x98, 0xc7, 0xbb, 0xce, 0x2e, 0xee, 0x78, 0x2a, 0x19, 0x5a, 0xa6, 0x6f, 0xe2, 0xd0, 0x73, 0x2b, 0x25, 0xe5, 0x95, 0xf5, 0x7d, 0x3e, 0x06, 0x1b, 0x1f, 0xc3, 0xe4, 0x06, 0x3b, 0xf9, 0x8f }

}
,
#endif /* LTC_TEST_EXT */
}
},
};

