/***********************************************************************************

    Copyright (C) 2007-2020 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_WIDGETTABLE_HEADER
#define LIFEOGRAPH_WIDGETTABLE_HEADER


#include <gtkmm/drawingarea.h>
#include <gtkmm/builder.h>

#include "../helpers.hpp"
#include "table.hpp"
#include "widget_entrypicker.hpp"
#include "widget_picker.hpp"


namespace LIFEO
{

using namespace HELPERS;


class WidgetTable : public Gtk::DrawingArea, public Table
{
    public:
        WidgetTable();
        ~WidgetTable() {}

        Gtk::Widget*                get_widget()
        { return m_Bx_main; }

        void                        set_diary( Diary* diary );
        void                        set_filter( const Ustring& );

        void                        refresh_editability()
        {
            m_flag_editable = ( m_p2diary ? m_p2diary->is_in_edit_mode() : false );
            m_Bx_edit->set_visible( m_flag_editable );
        }

        void                        show_table_Po( int, int );
        void                        show_column_Po();

        void                        refresh() override
        {
            if( Glib::RefPtr< Gdk::Window > window = get_window() )
                window->invalidate( false );
        }

        void                        calculate_and_plot( bool = true );
        void                        sort_and_plot();

        std::string                 get_as_string();
        void                        set_from_string( const Ustring& );

        void                        copy_delimited_text();

        SignalVoid                  signal_changed()
        { return m_Sg_changed; }
        SignalVoidEntry             signal_entry_clicked()
        { return m_Sg_entry_clicked; }

    protected:
        void                        on_size_allocate( Gtk::Allocation& ) override;
        bool                        on_scroll_event( GdkEventScroll* ) override;
        bool                        on_button_press_event( GdkEventButton* ) override;
        bool                        on_button_release_event( GdkEventButton* ) override;
        bool                        on_motion_notify_event( GdkEventMotion* ) override;
        bool                        on_leave_notify_event( GdkEventCrossing* ) override;
        bool                        on_draw( const Cairo::RefPtr< Cairo::Context >& ) override;

        void                        handle_base_changed();
        void                        handle_tag_filter_changed( Entry* );
        void                        handle_grouping_toggled();
        void                        handle_col_renamed();
        void                        handle_col_type_changed();
        void                        handle_col_tag_changed( Entry* );
        void                        handle_col_value_type_changed();
        void                        handle_col_conditional_toggled();
        void                        handle_col_cond_num_changed();

        void                        update_child_widget_visibilities();
        void                        update_scrollbar();

        Glib::RefPtr< Gtk::Builder >
                                    m_builder;

        Gtk::Scrollbar*             m_Sb_vert;
        Glib::RefPtr< Gtk::Adjustment > m_Aj_vert;
        Gtk::Box*                   m_Bx_main;

        Gtk::Popover*               m_Po_table;
        Gtk::Box*                   m_Bx_edit;
        WidgetPicker< Filter >*     m_WP_main_filter;
        WidgetEntryPicker*          m_WEP_tag_filter;
        Gtk::Button*                m_B_col_add;
        Gtk::RadioButton*           m_RB_entry_based;
        Gtk::RadioButton*           m_RB_para_based;
        Gtk::ModelButton*           m_MoB_copy_delimited_text;

        Gtk::Popover*               m_Po_column;
        EntryClear*                 m_E_col_name;
        Gtk::ComboBoxText*          m_CB_col_type;
        WidgetEntryPicker*          m_WEP_tag_picker;
        Gtk::Box*                   m_Bx_value_type;
        Gtk::ComboBoxText*          m_CB_value_type;
        Gtk::Box*                   m_Bx_sub_tag_type;
        Gtk::ComboBoxText*          m_CB_sub_tag_type;
        Gtk::ModelButton*           m_MoB_conditional;
        Gtk::Box*                   m_Bx_conditions;
        Gtk::Box*                   m_Bx_cond_num;
        Gtk::Box*                   m_Bx_cond_sub;
        Gtk::ComboBoxText*          m_CB_cond_rel_lo;
        Gtk::ComboBoxText*          m_CB_cond_rel_hi;
        Gtk::Entry*                 m_E_cond_num_v_lo;
        Gtk::Entry*                 m_E_cond_num_v_hi;
        WidgetPicker< Filter >*     m_WP_col_filter;
        Gtk::Button*                m_B_col_dismiss;
        Gtk::Button*                m_B_col_move_prev;
        Gtk::Button*                m_B_col_move_next;

        Action                      m_A_group_by_first_col;
        Action                      m_A_conditional;

        SignalVoid                  m_Sg_changed;
        SignalVoidEntry             m_Sg_entry_clicked;

        TableColumn*                m_p2col_sel;

        bool                        m_flag_editable{ false };
};

} // end of namespace LIFEO

#endif
