/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.parser.ParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.testng.AnnotationConverter;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotation;
import org.testng.internal.annotations.JDK14TagFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTestConverter {
    private static File[] m_fileNames;
    private static Map<String, String> m_convertedTags;
    private File m_outDir;
    private JavaDocBuilder m_qdox;
    private HashMap<String, Class<IAnnotation>> m_annotationMap;

    private static boolean isTestNGTag(DocletTag tag) {
        return tag.getName().startsWith("testng.");
    }

    private String lineForTag(DocletTag tag) {
        assert (AnnotationTestConverter.isTestNGTag(tag)) : "We assume we only get @testng tags";
        String originalName = tag.getName().substring(7);
        StringBuilder builder = new StringBuilder("  @");
        builder.append(AnnotationTestConverter.tagForOriginalName(originalName));
        Map parameters = tag.getNamedParameterMap();
        if (parameters.size() > 0) {
            builder.append("(");
            Iterator keyIterator = parameters.keySet().iterator();
            while (keyIterator.hasNext()) {
                String key = keyIterator.next().toString();
                Class<?> expectedValueType = this.expectedValueTypeForKey(tag, key);
                String value = tag.getNamedParameter(key);
                if (key.equals("value")) {
                    this.insertArrayOfValues(builder, value, expectedValueType.getComponentType());
                } else if (expectedValueType.isArray()) {
                    builder.append(key);
                    builder.append("=");
                    this.insertArrayOfValues(builder, value, expectedValueType.getComponentType());
                } else {
                    builder.append(key);
                    builder.append("=");
                    builder.append(this.prefixForClass(expectedValueType));
                    builder.append(value);
                    builder.append(this.suffixForClass(expectedValueType));
                }
                if (!keyIterator.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(")");
        }
        return builder.toString();
    }

    private Class<?> expectedValueTypeForKey(DocletTag tag, String key) {
        Class<IAnnotation> annotationClass = this.m_annotationMap.get(tag.getName());
        if (annotationClass == null) {
            AnnotationTestConverter.ppp("Found unknown testng annotation " + tag.getName() + " in file " + tag.getContext().getSource().getFile().getAbsolutePath() + " at line " + tag.getLineNumber());
            return String.class;
        }
        String methodName = "get" + key.substring(0, 1).toUpperCase() + key.substring(1);
        Method method = null;
        try {
            method = annotationClass.getMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            AnnotationTestConverter.ppp("Found unknown testng parameter " + key + " in annotation " + tag.getName() + " in file " + tag.getContext().getSource().getFile().getAbsolutePath() + " at line " + tag.getLineNumber());
            return String.class;
        }
        return method.getReturnType();
    }

    private void insertArrayOfValues(StringBuilder builder, String value, Class<?> type) {
        String[] values = Utils.stringToArray(value);
        builder.append("{");
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append(this.prefixForClass(type));
            builder.append(values[i]);
            builder.append(this.suffixForClass(type));
        }
        builder.append("}");
    }

    private String suffixForClass(Class<?> type) {
        if (String.class.isAssignableFrom(type)) {
            return "\"";
        }
        if (Class.class.isAssignableFrom(type)) {
            return ".class";
        }
        return "";
    }

    private Object prefixForClass(Class<?> type) {
        if (String.class.isAssignableFrom(type)) {
            return "\"";
        }
        if (Class.class.isAssignableFrom(type)) {
            return "";
        }
        return "";
    }

    private static String tagForOriginalName(String originalName) {
        String tag = m_convertedTags.get(originalName);
        if (tag != null) {
            return tag;
        }
        StringBuilder builder = new StringBuilder(originalName.length());
        boolean toCap = true;
        for (char c : originalName.toCharArray()) {
            if (c == '-') {
                toCap = true;
                continue;
            }
            if (toCap) {
                builder.append(String.valueOf(c).toUpperCase());
                toCap = false;
                continue;
            }
            builder.append(c);
        }
        tag = builder.toString();
        m_convertedTags.put(originalName, tag);
        return tag;
    }

    private static void ppp(String s) {
        if (AnnotationConverter.getLogLevel() >= 1) {
            System.out.println("[AnnotationTestConverter]" + s);
        }
    }

    public AnnotationTestConverter(File[] files, File destDir) {
        m_fileNames = files;
        this.m_outDir = destDir;
        this.m_qdox = new JavaDocBuilder();
        Class[] annotations = AnnotationHelper.getAllAnnotations();
        this.m_annotationMap = new HashMap(annotations.length);
        JDK14TagFactory factory = new JDK14TagFactory();
        for (Class clazz : annotations) {
            this.m_annotationMap.put(factory.getTagName(clazz), clazz);
        }
    }

    public int convert() {
        JavaSource[] sources;
        for (File f : m_fileNames) {
            try {
                this.m_qdox.addSource(f);
            }
            catch (ParseException e) {
                AnnotationTestConverter.ppp("Cannot parse file " + f.getAbsolutePath() + " - skipping");
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }
        int converted = 0;
        for (JavaSource source : sources = this.m_qdox.getSources()) {
            File file = source.getFile();
            try {
                List<String> lines = this.fileToLines(file);
                int lineCount = lines.size();
                List<String> finalLines = this.insertAnnotations(source, lines);
                if (finalLines.size() <= lineCount) continue;
                AnnotationTestConverter.ppp("Writing file " + file.getAbsolutePath());
                this.writeFile(file, source.getPackage(), finalLines);
                ++converted;
            }
            catch (IOException ioe) {
                AnnotationTestConverter.ppp("failed to process " + file);
                ioe.printStackTrace();
            }
        }
        return converted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> fileToLines(File file) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            String line = br.readLine();
            while (null != line) {
                result.add(line);
                line = br.readLine();
            }
        }
        finally {
            br.close();
        }
        return result;
    }

    private File getPackageOutputDir(File outDir, String packageName) {
        if (packageName == null) {
            packageName = "";
        }
        return new File(outDir, packageName.replace('.', File.separatorChar));
    }

    private List<String> insertAnnotations(JavaSource source, List<String> lines) {
        int oldLinesLength = lines.size();
        AbstractJavaEntity[] entities = new AbstractJavaEntity[lines.size()];
        JavaClass[] classes = source.getClasses();
        if (classes != null) {
            for (JavaClass cd : classes) {
                this.iterateClassesFromSource(cd, entities);
            }
        }
        int i = entities.length;
        while (--i >= 0) {
            DocletTag[] tags;
            AbstractJavaEntity entity = entities[i];
            if (entity == null) continue;
            for (DocletTag tag : tags = entity.getTags()) {
                if (!AnnotationTestConverter.isTestNGTag(tag)) continue;
                lines.add(i, this.lineForTag(tag));
            }
        }
        if (oldLinesLength == lines.size()) {
            return lines;
        }
        int lineCount = 0;
        for (String line : lines) {
            ++lineCount;
            if (!(line = line.trim()).startsWith("import")) continue;
            lines.add(lineCount - 1, "import org.testng.annotations.*;");
            break;
        }
        return lines;
    }

    private void iterateClassesFromSource(JavaClass cd, AbstractJavaEntity[] entities) {
        JavaClass[] childClasses;
        int lineNumber = cd.getLineNumber();
        if (lineNumber == 0) {
            System.out.append("Found class " + cd.getFullyQualifiedName() + " at line 0 in source " + cd.getParentSource().getURL().toExternalForm() + "\n");
        } else {
            assert (entities[lineNumber - 1] == null) : "Can't have class and method declarations in the same place!";
            entities[lineNumber - 1] = cd;
        }
        for (JavaClass nc : childClasses = cd.getNestedClasses()) {
            this.iterateClassesFromSource(nc, entities);
        }
        JavaMethod[] methods = cd.getMethods();
        if (methods != null) {
            for (JavaMethod md : methods) {
                int methodLineNumber = md.getLineNumber();
                if (methodLineNumber == 0) {
                    System.out.append("Found method " + md.getName() + " at line 0 in class " + cd.getFullyQualifiedName() + " in source " + cd.getParentSource().getURL().toExternalForm() + "\n");
                    continue;
                }
                assert (entities[methodLineNumber - 1] == null) : "Can't have class and method declarations in the same place!";
                entities[methodLineNumber - 1] = md;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File filePath, String packageName, List<String> lines) {
        String fileName = filePath.getName();
        File file = this.m_outDir == null ? filePath : new File(this.getPackageOutputDir(this.m_outDir, packageName), fileName);
        File parentDir = file.getParentFile();
        parentDir.mkdirs();
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(file);
            bw = new BufferedWriter(fw);
            assert (null != lines) : "NO LINES FOR " + filePath;
            for (String l : lines) {
                bw.write(l);
                bw.write(10);
            }
            AnnotationTestConverter.ppp("Wrote " + file.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != bw) {
                    bw.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (null != fw) {
                    fw.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    static {
        m_convertedTags = new HashMap<String, String>();
    }
}

