/***********************************************************************************************
 * File Info: $Id: StackedDataProcessor.java,v 1.3 2002/12/04 02:38:13 nathaniel_auvil Exp $
 * Copyright (C) 2002
 * Author: Nathaniel G. Auvil
 * Contributor(s):
 *
 * Copyright 2002 (C) Nathaniel G. Auvil. All Rights Reserved.
 *
 * Redistribution and use of this software and associated documentation ("Software"), with or
 * without modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain copyright statements and notices.
 * 	Redistributions must also contain a copy of this document.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of
 * 	conditions and the following disclaimer in the documentation and/or other materials
 * 	provided with the distribution.
 *
 * 3. The name "jCharts" or "Nathaniel G. Auvil" must not be used to endorse or promote
 * 	products derived from this Software without prior written permission of Nathaniel G.
 * 	Auvil.  For written permission, please contact nathaniel_auvil@users.sourceforge.net
 *
 * 4. Products derived from this Software may not be called "jCharts" nor may "jCharts" appear
 * 	in their names without prior written permission of Nathaniel G. Auvil. jCharts is a
 * 	registered trademark of Nathaniel G. Auvil.
 *
 * 5. Due credit should be given to the jCharts Project (http://jcharts.sourceforge.net/).
 *
 * THIS SOFTWARE IS PROVIDED BY Nathaniel G. Auvil AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * jCharts OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE
 ************************************************************************************************/

package org.jCharts.chartData.processors;


import org.jCharts.chartData.interfaces.IAxisChartDataSet;


/*********************************************************************************************
 * Notes:
 *  1) Stacked data cannot have any negative values.  I don't think i have ever seen a
 *        stacked bar chart with negative values just as a side observation.
 *
 *        ---->There has been one request for this though...
 *
 *
 *
 **********************************************************************************************/
abstract class StackedDataProcessor
{

	/*******************************************************************************************
	 * <pre>This method should do a single pass through the data set and calculate all needed values,
	 *  such as: min, max, sum, etc... so that we can do this in one pass through the data.
	 *  Rather than once for each.</pre>
	 *
	 * @param iAxisChartDataSet
	 * @param axisChartDataProcessor
	 ********************************************************************************************/
	public static final void processData( IAxisChartDataSet iAxisChartDataSet,
													  AxisChartDataProcessor axisChartDataProcessor )
	{
		double value;

		//LOOP
		for( int i=0; i < iAxisChartDataSet.getNumberOfDataItems(); i++ )
		{
			value=0.0d;

			//LOOP
			for( int j=0; j < iAxisChartDataSet.getNumberOfDataSets(); j++ )
			{
				value+=iAxisChartDataSet.getValue( j, i );
			}

			if( value > axisChartDataProcessor.getMaxValue() )
			{
				axisChartDataProcessor.setMaxValue( value );
			}

			if( value < axisChartDataProcessor.getMinValue() )
			{
				axisChartDataProcessor.setMinValue( value );
			}
		}
	}

}
