#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:resource-room-confroom@example.com"
QUOTA=rooms

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"

# Add collective scheduling tests.

cat > "$PREFS/$USER/scheduling_function" <<EOF
schedule_across_quota $QUOTA
EOF

# Set delegates for recurring event handling.

cat <<EOF | "$SET_DELEGATES" "$QUOTA" $SET_DELEGATES_ARGS
$USER
EOF

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out0.tmp

   grep -q 'METHOD:REPLY' out0.tmp \
&& ! grep -q '^FREEBUSY' out0.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-recurring-indefinitely.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out2.tmp

   grep -q 'METHOD:REPLY' out2.tmp \
&& grep -q 'ATTENDEE;PARTSTAT=ACCEPTED' out2.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out3.tmp

   grep -q 'METHOD:REPLY' out3.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141114T090000Z/20141114T100000Z' out3.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141212T090000Z/20141212T100000Z' out3.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20150109T090000Z/20150109T100000Z' out3.tmp \
&& echo "Success" \
|| echo "Failed"

"$FREEBUSY_SCRIPT" "$USER" $FREEBUSY_ARGS $ARGS 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_providers" \
|  tee out3p.tmp \
|  grep -q 'event14@example.com' \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-cancel-recurring-indefinitely.txt" 2>> $ERROR
echo "Cancel..."

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out4.tmp

   grep -q 'METHOD:REPLY' out4.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141114T090000Z/20141114T100000Z' out4.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20141212T090000Z/20141212T100000Z' out4.tmp \
&& ! grep -q 'FREEBUSY;FBTYPE=BUSY:20150109T090000Z/20150109T100000Z' out4.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_providers" \
>  out4p.tmp

   ! grep -q 'event14@example.com' "out4p.tmp" \
&& echo "Success" \
|| echo "Failed"

# Re-add event to test scheduling and presence in the freebusy-providers file.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-recurring-indefinitely.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out5.tmp

   grep -q 'METHOD:REPLY' out5.tmp \
&& grep -q 'ATTENDEE;PARTSTAT=ACCEPTED' out5.tmp \
&& echo "Success" \
|| echo "Failed"

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/fb-request-all.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out6.tmp

   grep -q 'METHOD:REPLY' out6.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141114T090000Z/20141114T100000Z' out6.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20141212T090000Z/20141212T100000Z' out6.tmp \
&& grep -q 'FREEBUSY;FBTYPE=BUSY:20150109T090000Z/20150109T100000Z' out6.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy_providers" \
|  tee out6p.tmp \
|  grep -q 'event14@example.com' \
&& echo "Success" \
|| echo "Failed"
