#!/bin/sh

. "`dirname \"$0\"`/common.sh"

USER="mailto:resource-room-confroom@example.com"
SENDER="mailto:paul.boddie@example.com"

mkdir -p "$PREFS/$USER"
echo 'Europe/Oslo' > "$PREFS/$USER/TZID"
echo 'share' > "$PREFS/$USER/freebusy_sharing"

mkdir -p "$PREFS/$SENDER"
echo 'Europe/Oslo' > "$PREFS/$SENDER/TZID"
echo 'always' > "$PREFS/$SENDER/event_refreshing"

# Publish an event, testing registration in the outgoing handler.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-request-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
|  tee out0f.tmp \
|  grep -q "^20141212T090000Z${TAB}20141212T100000Z" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the recipient.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-request-recurring.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out1.tmp

   grep -q 'METHOD:REPLY' out1.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
| tee out1f.tmp \
| grep -q "^20141212T090000Z${TAB}20141212T100000Z" \
&& echo "Success" \
|| echo "Failed"

# Present the response to the sender.

  "$PERSON_SCRIPT" $ARGS < out1.tmp 2>> $ERROR \
| "$SHOWMAIL" \
> out2.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy_other" "$USER" \
|  tee out2o.tmp \
|  grep -q "^20141212T090000Z${TAB}20141212T100000Z" \
&& echo "Success" \
|| echo "Failed"

# Attempt to add an occurrence to the event.

"$OUTGOING_SCRIPT" $ARGS < "$TEMPLATES/event-add-recurring.txt" 2>> $ERROR

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy" \
>  out2f.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out2f.tmp" \
&& grep -q "^20150109T090000Z${TAB}20150109T100000Z" "out2f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the request to the recipient.

  "$RESOURCE_SCRIPT" $ARGS < "$TEMPLATES/event-add-recurring.txt" 2>> $ERROR \
| "$SHOWMAIL" \
> out3.tmp

   grep -q 'METHOD:REFRESH' out3.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out3f.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out3f.tmp" \
&& ! grep -q "^20150109T090000Z${TAB}20150109T100000Z" "out3f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the refresh message to the organiser.

  "$PERSON_SCRIPT" $ARGS < out3.tmp 2>> $ERROR \
| tee out4r.tmp \
| "$SHOWMAIL" \
> out4.tmp

   grep -q 'METHOD:REQUEST' out4.tmp \
&& echo "Success" \
|| echo "Failed"

# Present the request to the recipient.

  "$RESOURCE_SCRIPT" $ARGS < out4r.tmp 2>> $ERROR \
| tee out5r.tmp \
| "$SHOWMAIL" \
> out5.tmp

   grep -q 'METHOD:REPLY' out5.tmp \
&& echo "Success" \
|| echo "Failed"

   "$LIST_SCRIPT" $LIST_ARGS "$USER" "freebusy" \
>  out5f.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out5f.tmp" \
&& grep -q "^20150109T090000Z${TAB}20150109T100000Z" "out5f.tmp" \
&& echo "Success" \
|| echo "Failed"

# Present the response to the sender.

  "$PERSON_SCRIPT" $ARGS < out5r.tmp 2>> $ERROR \
| "$SHOWMAIL" \
> out6.tmp

   "$LIST_SCRIPT" $LIST_ARGS "$SENDER" "freebusy_other" "$USER" \
>  out6o.tmp

   grep -q "^20141212T090000Z${TAB}20141212T100000Z" "out6o.tmp" \
&& grep -q "^20150109T090000Z${TAB}20150109T100000Z" "out6o.tmp" \
&& echo "Success" \
|| echo "Failed"
