from __future__ import division
# Phi/Psi corrections in Angstrom and Radials
mean_devs = {
  (-170, -180) : (0.049550, -1.365156), # 20
  (-170, -170) : (0.061914, -1.302955), # 15
  (-170, 140) : (0.018052, -1.036140), # 38
  (-170, 150) : (0.020163, 0.123001), # 118
  (-170, 160) : (0.042103, 0.352317), # 88
  (-170, 170) : (0.025892, 0.231050), # 50
  (-170, 180) : (0.025302, -0.468369), # 29
  (-160, -180) : (0.057001, -1.155432), # 118
  (-160, -170) : (0.075089, -1.103274), # 111
  (-160, -160) : (0.090149, -1.068440), # 19
  (-160, 130) : (0.039635, -1.595599), # 71
  (-160, 140) : (0.040717, -1.178413), # 345
  (-160, 150) : (0.031006, -0.631406), # 815
  (-160, 160) : (0.030637, -0.255023), # 481
  (-160, 170) : (0.036209, -0.887382), # 215
  (-160, 180) : (0.049678, -0.972393), # 91
  (-150, -180) : (0.063231, -1.204149), # 156
  (-150, -170) : (0.093747, -1.245855), # 221
  (-150, -160) : (0.110259, -1.173415), # 55
  (-150, -150) : (0.119173, -1.048102), # 11
  (-150, 70) : (0.109246, -1.436683), # 11
  (-150, 100) : (0.016870, 1.261394), # 16
  (-150, 110) : (0.014843, 0.226984), # 26
  (-150, 120) : (0.007231, -1.881933), # 67
  (-150, 130) : (0.026692, -1.316864), # 399
  (-150, 140) : (0.036544, -1.122675), # 1363
  (-150, 150) : (0.033307, -0.905880), # 1584
  (-150, 160) : (0.013128, 0.520000), # 802
  (-150, 170) : (0.010319, 0.698299), # 528
  (-150, 180) : (0.038365, -1.186074), # 194
  (-140, -180) : (0.019265, -0.891252), # 209
  (-140, -170) : (0.074903, -1.288633), # 190
  (-140, -160) : (0.099643, -1.304220), # 58
  (-140, -60) : (0.036511, -1.934976), # 10
  (-140, -50) : (0.020390, -1.413221), # 13
  (-140, -40) : (0.054543, -1.997157), # 19
  (-140, -30) : (0.032308, -2.348681), # 40
  (-140, -20) : (0.020212, -2.871677), # 32
  (-140, -10) : (0.023584, 3.091411), # 47
  (-140, 0) : (0.020750, -2.903858), # 57
  (-140, 10) : (0.012618, 1.784568), # 52
  (-140, 20) : (0.015194, -2.052851), # 57
  (-140, 30) : (0.035980, -1.401803), # 38
  (-140, 40) : (0.058374, -1.600626), # 41
  (-140, 50) : (0.051648, -1.515088), # 28
  (-140, 60) : (0.038177, -1.599613), # 47
  (-140, 70) : (0.032887, -1.161127), # 73
  (-140, 80) : (0.026385, -1.064209), # 69
  (-140, 90) : (0.021460, 0.488537), # 90
  (-140, 100) : (0.018371, 0.783490), # 117
  (-140, 110) : (0.021516, 1.144046), # 324
  (-140, 120) : (0.026010, 1.283004), # 1107
  (-140, 130) : (0.026880, 1.041345), # 3175
  (-140, 140) : (0.018895, 0.110288), # 3774
  (-140, 150) : (0.006147, -1.458823), # 2843
  (-140, 160) : (0.020552, 2.080739), # 3748
  (-140, 170) : (0.025585, 1.611233), # 2066
  (-140, 180) : (0.021373, 1.338623), # 415
  (-130, -180) : (0.012043, -0.021143), # 241
  (-130, -170) : (0.054159, -1.273289), # 180
  (-130, -160) : (0.088994, -1.218163), # 42
  (-130, -150) : (0.122937, -1.458231), # 15
  (-130, -130) : (0.131552, -1.418952), # 10
  (-130, -110) : (0.114484, -1.679634), # 11
  (-130, -100) : (0.105238, -1.614406), # 19
  (-130, -90) : (0.094361, -1.571760), # 22
  (-130, -80) : (0.057128, -1.419428), # 37
  (-130, -70) : (0.050658, -1.506634), # 45
  (-130, -60) : (0.041920, -1.493183), # 127
  (-130, -50) : (0.025034, -1.319652), # 102
  (-130, -40) : (0.034413, -1.646455), # 72
  (-130, -30) : (0.041951, -2.361769), # 134
  (-130, -20) : (0.033552, -2.548512), # 339
  (-130, -10) : (0.031362, -2.509145), # 463
  (-130, 0) : (0.030653, -2.214520), # 411
  (-130, 10) : (0.035544, -1.938858), # 429
  (-130, 20) : (0.042475, -1.782784), # 388
  (-130, 30) : (0.050013, -1.701592), # 204
  (-130, 40) : (0.061592, -1.746808), # 111
  (-130, 50) : (0.052377, -1.525836), # 87
  (-130, 60) : (0.059328, -1.564873), # 156
  (-130, 70) : (0.033370, -1.193630), # 241
  (-130, 80) : (0.030040, -1.209023), # 259
  (-130, 90) : (0.019938, -0.778578), # 371
  (-130, 100) : (0.015119, 0.024557), # 540
  (-130, 110) : (0.013872, 0.473948), # 1556
  (-130, 120) : (0.018762, 0.856128), # 5350
  (-130, 130) : (0.024537, 0.775759), # 10018
  (-130, 140) : (0.021757, 0.189548), # 6125
  (-130, 150) : (0.019320, -2.120221), # 4420
  (-130, 160) : (0.011985, -2.807838), # 5541
  (-130, 170) : (0.008424, 1.464966), # 2682
  (-130, 180) : (0.007781, 0.335084), # 516
  (-120, -180) : (0.020201, -0.583944), # 136
  (-120, -170) : (0.044362, -1.187173), # 105
  (-120, -160) : (0.103213, -1.380213), # 19
  (-120, -150) : (0.137329, -1.425471), # 14
  (-120, -140) : (0.123860, -1.520745), # 18
  (-120, -120) : (0.145469, -1.685984), # 12
  (-120, -100) : (0.115619, -1.454392), # 24
  (-120, -90) : (0.088552, -1.461104), # 49
  (-120, -80) : (0.076517, -1.424832), # 53
  (-120, -70) : (0.062049, -1.499595), # 103
  (-120, -60) : (0.048748, -1.567948), # 268
  (-120, -50) : (0.036514, -1.343291), # 300
  (-120, -40) : (0.033217, -1.193991), # 185
  (-120, -30) : (0.048596, -2.046378), # 263
  (-120, -20) : (0.039134, -2.277348), # 834
  (-120, -10) : (0.045336, -2.134732), # 1130
  (-120, 0) : (0.042131, -1.975516), # 1004
  (-120, 10) : (0.047162, -1.885206), # 965
  (-120, 20) : (0.055900, -1.750376), # 736
  (-120, 30) : (0.067468, -1.685184), # 370
  (-120, 40) : (0.082705, -1.661855), # 94
  (-120, 50) : (0.071805, -1.479517), # 27
  (-120, 60) : (0.056182, -1.699440), # 35
  (-120, 70) : (0.042695, -1.299105), # 64
  (-120, 80) : (0.036354, -0.972223), # 164
  (-120, 90) : (0.026345, -0.668965), # 353
  (-120, 100) : (0.022344, -0.284005), # 875
  (-120, 110) : (0.016754, 0.134904), # 2846
  (-120, 120) : (0.020314, 0.504932), # 8906
  (-120, 130) : (0.025599, 0.494024), # 12513
  (-120, 140) : (0.024110, 0.036028), # 5162
  (-120, 150) : (0.027583, -1.911514), # 2815
  (-120, 160) : (0.018357, -2.141355), # 2923
  (-120, 170) : (0.002685, -1.182005), # 1345
  (-120, 180) : (0.012794, 0.899157), # 271
  (-110, -180) : (0.020302, -0.539360), # 103
  (-110, -170) : (0.045964, -1.100257), # 69
  (-110, -160) : (0.101836, -1.419587), # 21
  (-110, -110) : (0.141269, -1.617385), # 15
  (-110, -100) : (0.090499, -1.515868), # 12
  (-110, -90) : (0.112456, -1.483316), # 39
  (-110, -80) : (0.082511, -1.462064), # 43
  (-110, -70) : (0.066743, -1.366924), # 66
  (-110, -60) : (0.052689, -1.556954), # 313
  (-110, -50) : (0.035405, -1.294403), # 449
  (-110, -40) : (0.033034, -1.126312), # 364
  (-110, -30) : (0.039906, -1.868330), # 385
  (-110, -20) : (0.039462, -2.191435), # 1101
  (-110, -10) : (0.042720, -2.032685), # 1301
  (-110, 0) : (0.044337, -1.955462), # 1211
  (-110, 10) : (0.050687, -1.850999), # 1164
  (-110, 20) : (0.074537, -1.776126), # 739
  (-110, 30) : (0.073438, -1.729610), # 176
  (-110, 40) : (0.068073, -1.545617), # 25
  (-110, 50) : (0.084774, -1.608609), # 20
  (-110, 70) : (0.068767, -1.422700), # 11
  (-110, 80) : (0.038246, -1.036423), # 39
  (-110, 90) : (0.028355, -0.782633), # 146
  (-110, 100) : (0.024372, -0.355253), # 861
  (-110, 110) : (0.021384, 0.062896), # 3263
  (-110, 120) : (0.022644, 0.354043), # 8430
  (-110, 130) : (0.027559, 0.416022), # 9564
  (-110, 140) : (0.027582, 0.032000), # 3331
  (-110, 150) : (0.028450, -1.783171), # 1348
  (-110, 160) : (0.011444, -2.022455), # 1273
  (-110, 170) : (0.009221, 0.988024), # 747
  (-110, 180) : (0.013346, 0.506752), # 167
  (-100, -180) : (0.026550, -1.006244), # 64
  (-100, -170) : (0.047491, -1.299208), # 45
  (-100, -160) : (0.098003, -1.067016), # 18
  (-100, -90) : (0.103557, -1.536353), # 19
  (-100, -80) : (0.064340, -1.228401), # 20
  (-100, -70) : (0.069614, -1.415190), # 63
  (-100, -60) : (0.043236, -1.466092), # 235
  (-100, -50) : (0.030474, -1.124824), # 637
  (-100, -40) : (0.031935, -0.842089), # 570
  (-100, -30) : (0.037162, -1.831043), # 452
  (-100, -20) : (0.035966, -2.191461), # 959
  (-100, -10) : (0.036727, -2.099965), # 1181
  (-100, 0) : (0.037745, -2.033873), # 1527
  (-100, 10) : (0.053294, -1.889857), # 1140
  (-100, 20) : (0.069319, -1.767639), # 356
  (-100, 30) : (0.058876, -1.726461), # 56
  (-100, 40) : (0.080889, -1.727530), # 13
  (-100, 50) : (0.055765, -1.470243), # 11
  (-100, 60) : (0.086338, -1.339816), # 10
  (-100, 70) : (0.057849, -1.088528), # 22
  (-100, 80) : (0.049807, -1.085779), # 49
  (-100, 90) : (0.044412, -0.873121), # 162
  (-100, 100) : (0.028526, -0.564497), # 704
  (-100, 110) : (0.021515, -0.154181), # 2712
  (-100, 120) : (0.023266, 0.253349), # 6061
  (-100, 130) : (0.028780, 0.329319), # 6134
  (-100, 140) : (0.030100, -0.008752), # 1865
  (-100, 150) : (0.022278, -1.597963), # 749
  (-100, 160) : (0.003216, -2.605795), # 857
  (-100, 170) : (0.020645, 1.108763), # 587
  (-100, 180) : (0.014140, 0.493174), # 112
  (-90, -180) : (0.024069, -0.184560), # 70
  (-90, -170) : (0.029746, -1.019338), # 42
  (-90, -160) : (0.087128, -1.244615), # 17
  (-90, -80) : (0.092674, -1.398006), # 10
  (-90, -70) : (0.075682, -1.501963), # 57
  (-90, -60) : (0.050670, -1.467858), # 246
  (-90, -50) : (0.031855, -1.056899), # 869
  (-90, -40) : (0.035088, -0.912457), # 881
  (-90, -30) : (0.039647, -1.654133), # 609
  (-90, -20) : (0.031801, -2.204988), # 1096
  (-90, -10) : (0.032941, -2.174507), # 1536
  (-90, 0) : (0.040028, -2.075319), # 1541
  (-90, 10) : (0.048272, -1.864656), # 498
  (-90, 20) : (0.036162, -1.745751), # 65
  (-90, 30) : (0.076182, -1.720288), # 11
  (-90, 40) : (0.060475, -1.528850), # 12
  (-90, 50) : (0.062981, -1.353062), # 30
  (-90, 60) : (0.068002, -1.430626), # 43
  (-90, 70) : (0.082973, -1.432560), # 94
  (-90, 80) : (0.058332, -1.270607), # 174
  (-90, 90) : (0.046763, -1.109996), # 237
  (-90, 100) : (0.032252, -0.789186), # 654
  (-90, 110) : (0.022119, -0.228749), # 1985
  (-90, 120) : (0.023290, 0.089086), # 4107
  (-90, 130) : (0.029349, 0.208108), # 4265
  (-90, 140) : (0.033119, 0.025702), # 1361
  (-90, 150) : (0.019320, -1.251412), # 611
  (-90, 160) : (0.006435, 1.480017), # 991
  (-90, 170) : (0.030071, 1.155611), # 750
  (-90, 180) : (0.013655, 0.681110), # 121
  (-80, -180) : (0.029219, 0.975904), # 57
  (-80, -170) : (0.018153, -0.289771), # 39
  (-80, -70) : (0.052267, -1.278431), # 26
  (-80, -60) : (0.053630, -1.478415), # 238
  (-80, -50) : (0.036664, -1.151567), # 1520
  (-80, -40) : (0.046021, -1.205287), # 2053
  (-80, -30) : (0.066238, -1.704252), # 1306
  (-80, -20) : (0.045418, -2.081017), # 1517
  (-80, -10) : (0.044507, -2.156505), # 1841
  (-80, 0) : (0.055942, -1.976845), # 782
  (-80, 10) : (0.051569, -1.730693), # 106
  (-80, 20) : (0.059472, -1.417223), # 12
  (-80, 50) : (0.044843, -1.138036), # 12
  (-80, 60) : (0.057541, -1.412400), # 30
  (-80, 70) : (0.058434, -1.246599), # 47
  (-80, 80) : (0.065177, -1.333386), # 115
  (-80, 90) : (0.051972, -1.222017), # 145
  (-80, 100) : (0.027379, -1.038035), # 324
  (-80, 110) : (0.022798, -0.650943), # 1015
  (-80, 120) : (0.021245, -0.090978), # 3012
  (-80, 130) : (0.028761, 0.034609), # 3745
  (-80, 140) : (0.035951, -0.224708), # 1522
  (-80, 150) : (0.022774, -1.483888), # 749
  (-80, 160) : (0.009368, 1.758587), # 1396
  (-80, 170) : (0.032761, 1.228420), # 1068
  (-80, 180) : (0.027707, 0.925598), # 132
  (-70, -180) : (0.029428, -0.916867), # 11
  (-70, -70) : (0.078989, -1.604932), # 14
  (-70, -60) : (0.067833, -1.575521), # 338
  (-70, -50) : (0.043806, -1.260921), # 8931
  (-70, -40) : (0.057974, -1.350021), # 18437
  (-70, -30) : (0.086643, -1.743579), # 5466
  (-70, -20) : (0.063855, -1.924049), # 3188
  (-70, -10) : (0.062583, -2.039382), # 1767
  (-70, 0) : (0.076094, -1.915072), # 211
  (-70, 100) : (0.029367, -0.965774), # 29
  (-70, 110) : (0.023370, -0.790983), # 231
  (-70, 120) : (0.019760, -0.351804), # 1741
  (-70, 130) : (0.027246, -0.147492), # 3620
  (-70, 140) : (0.035486, -0.338000), # 1986
  (-70, 150) : (0.023444, -1.456776), # 1104
  (-70, 160) : (0.005271, 2.064000), # 1513
  (-70, 170) : (0.032476, 1.217765), # 703
  (-70, 180) : (0.025962, 0.537475), # 59
  (-60, -60) : (0.072864, -1.601202), # 450
  (-60, -50) : (0.043768, -1.280323), # 26626
  (-60, -40) : (0.053091, -1.288759), # 27435
  (-60, -30) : (0.073267, -1.638106), # 4938
  (-60, -20) : (0.063365, -1.823522), # 1981
  (-60, -10) : (0.070535, -2.018727), # 180
  (-60, 110) : (0.015829, -0.089742), # 19
  (-60, 120) : (0.020209, -0.516126), # 628
  (-60, 130) : (0.026746, -0.411061), # 2770
  (-60, 140) : (0.034796, -0.677663), # 1878
  (-60, 150) : (0.033090, -1.529894), # 757
  (-60, 160) : (0.010986, -1.994987), # 385
  (-60, 170) : (0.012828, 0.921095), # 63
  (-50, -60) : (0.067985, -1.643455), # 144
  (-50, -50) : (0.048293, -1.407642), # 2949
  (-50, -40) : (0.057609, -1.402431), # 2087
  (-50, -30) : (0.064019, -1.567539), # 455
  (-50, -20) : (0.059792, -1.837948), # 25
  (-50, 120) : (0.022375, -0.404878), # 198
  (-50, 130) : (0.030409, -0.403231), # 965
  (-50, 140) : (0.038102, -0.660292), # 500
  (-50, 150) : (0.033009, -1.366422), # 65
  (-40, -60) : (0.075435, -1.585837), # 38
  (-40, -50) : (0.063522, -1.466494), # 89
  (-40, -40) : (0.030933, -1.040291), # 31
  (-40, 120) : (0.023705, -0.127188), # 45
  (-40, 130) : (0.034840, 0.145776), # 53
  (-40, 140) : (0.039154, -0.324727), # 14
  (30, 60) : (0.100102, -1.924173), # 15
  (40, 40) : (0.193829, -1.862797), # 26
  (40, 50) : (0.132890, -1.814257), # 34
  (40, 60) : (0.125440, -1.814568), # 23
  (50, 30) : (0.188323, -1.913469), # 17
  (50, 40) : (0.135526, -1.811708), # 49
  (50, 50) : (0.110870, -1.802751), # 43
  (50, 60) : (0.082030, -1.670572), # 31
  (60, 20) : (0.126827, -2.075309), # 11
  (60, 30) : (0.108168, -1.908051), # 18
  (60, 40) : (0.097393, -1.764670), # 25
  (60, 50) : (0.080664, -1.583414), # 28
  (60, 60) : (0.112186, -1.810857), # 32
  (60, 70) : (0.118897, -1.881325), # 19
  (70, -70) : (0.095564, -2.060879), # 13
  (70, -60) : (0.125255, -2.063900), # 52
  (70, -50) : (0.108760, -1.961748), # 42
  (70, -10) : (0.169191, -2.241270), # 11
  (70, 0) : (0.152242, -2.226916), # 28
  (70, 10) : (0.142707, -2.146702), # 21
  (70, 20) : (0.140770, -2.064541), # 12
  (70, 160) : (0.118717, -2.459335), # 21
  (70, 170) : (0.099620, -2.616466), # 22
  (80, -60) : (0.148950, -2.012767), # 22
  (80, -50) : (0.138297, -1.996977), # 17
  (80, -10) : (0.180035, -2.381612), # 24
  (80, 0) : (0.172353, -2.325002), # 28
  (80, 10) : (0.178491, -2.156893), # 13
}

if __name__ == '__main__':
  from mmtbx.validation.mean_devs_others_phi_psi import mean_devs as others_phi_psi
  for phi_psi in [(0,0), (-60,-60)]:
    print(phi_psi, mean_devs.get(phi_psi, None), others_phi_psi.get(phi_psi, None))

