/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitAnimationList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSWebKitAnimation.h"
#include "WebKitAnimation.h"
#include "WebKitAnimationList.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebKitAnimationListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationListLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitAnimationListTable = { 5, 3, JSWebKitAnimationListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWebKitAnimationListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitAnimationListConstructorTable = { 1, 0, JSWebKitAnimationListConstructorTableValues, 0 };
const ClassInfo JSWebKitAnimationListConstructor::s_info = { "WebKitAnimationListConstructor", &Base::s_info, &JSWebKitAnimationListConstructorTable, 0, CREATE_METHOD_TABLE(JSWebKitAnimationListConstructor) };

JSWebKitAnimationListConstructor::JSWebKitAnimationListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebKitAnimationListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebKitAnimationListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWebKitAnimationListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitAnimationListConstructor, JSDOMWrapper>(exec, &JSWebKitAnimationListConstructorTable, jsCast<JSWebKitAnimationListConstructor*>(cell), propertyName, slot);
}

bool JSWebKitAnimationListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitAnimationListConstructor, JSDOMWrapper>(exec, &JSWebKitAnimationListConstructorTable, jsCast<JSWebKitAnimationListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWebKitAnimationListPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWebKitAnimationListPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitAnimationListPrototypeTable = { 2, 1, JSWebKitAnimationListPrototypeTableValues, 0 };
const ClassInfo JSWebKitAnimationListPrototype::s_info = { "WebKitAnimationListPrototype", &Base::s_info, &JSWebKitAnimationListPrototypeTable, 0, CREATE_METHOD_TABLE(JSWebKitAnimationListPrototype) };

JSObject* JSWebKitAnimationListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitAnimationList>(exec, globalObject);
}

bool JSWebKitAnimationListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebKitAnimationListPrototype* thisObject = jsCast<JSWebKitAnimationListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSWebKitAnimationListPrototypeTable, thisObject, propertyName, slot);
}

bool JSWebKitAnimationListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebKitAnimationListPrototype* thisObject = jsCast<JSWebKitAnimationListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSWebKitAnimationListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSWebKitAnimationList::s_info = { "WebKitAnimationList", &Base::s_info, &JSWebKitAnimationListTable, 0 , CREATE_METHOD_TABLE(JSWebKitAnimationList) };

JSWebKitAnimationList::JSWebKitAnimationList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebKitAnimationList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSWebKitAnimationList::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebKitAnimationList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebKitAnimationListPrototype::create(exec->globalData(), globalObject, JSWebKitAnimationListPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSWebKitAnimationList::destroy(JSC::JSCell* cell)
{
    JSWebKitAnimationList* thisObject = static_cast<JSWebKitAnimationList*>(cell);
    thisObject->JSWebKitAnimationList::~JSWebKitAnimationList();
}

JSWebKitAnimationList::~JSWebKitAnimationList()
{
    releaseImplIfNotNull();
}

bool JSWebKitAnimationList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebKitAnimationList* thisObject = jsCast<JSWebKitAnimationList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSWebKitAnimationList>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<WebKitAnimationList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSWebKitAnimationList, Base>(exec, &JSWebKitAnimationListTable, thisObject, propertyName, slot);
}

bool JSWebKitAnimationList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebKitAnimationList* thisObject = jsCast<JSWebKitAnimationList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSWebKitAnimationListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<WebKitAnimationList*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSWebKitAnimationList, Base>(exec, &JSWebKitAnimationListTable, thisObject, propertyName, descriptor);
}

bool JSWebKitAnimationList::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSWebKitAnimationList* thisObject = jsCast<JSWebKitAnimationList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<WebKitAnimationList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsWebKitAnimationListLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitAnimationList* castedThis = jsCast<JSWebKitAnimationList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimationList* impl = static_cast<WebKitAnimationList*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsWebKitAnimationListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitAnimationList* domObject = jsCast<JSWebKitAnimationList*>(asObject(slotBase));
    return JSWebKitAnimationList::getConstructor(exec, domObject->globalObject());
}

void JSWebKitAnimationList::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSWebKitAnimationList* thisObject = jsCast<JSWebKitAnimationList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<WebKitAnimationList*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSWebKitAnimationList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitAnimationListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWebKitAnimationListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitAnimationList::s_info))
        return throwVMTypeError(exec);
    JSWebKitAnimationList* castedThis = jsCast<JSWebKitAnimationList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitAnimationList::s_info);
    WebKitAnimationList* impl = static_cast<WebKitAnimationList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned index(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}


JSValue JSWebKitAnimationList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSWebKitAnimationList* thisObj = jsCast<JSWebKitAnimationList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<WebKitAnimationList*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSWebKitAnimationList* jsWebKitAnimationList)
{
    if (jsWebKitAnimationList->hasCustomProperties())
        return true;
    return false;
}

bool JSWebKitAnimationListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWebKitAnimationList* jsWebKitAnimationList = jsCast<JSWebKitAnimationList*>(handle.get().asCell());
    if (!isObservable(jsWebKitAnimationList))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSWebKitAnimationListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWebKitAnimationList* jsWebKitAnimationList = jsCast<JSWebKitAnimationList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebKitAnimationList->impl(), jsWebKitAnimationList);
    jsWebKitAnimationList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebKitAnimationList* impl)
{
    return wrap<JSWebKitAnimationList>(exec, globalObject, impl);
}

WebKitAnimationList* toWebKitAnimationList(JSC::JSValue value)
{
    return value.inherits(&JSWebKitAnimationList::s_info) ? jsCast<JSWebKitAnimationList*>(asObject(value))->impl() : 0;
}

}
