/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGTextPositioningElement.h"

#include "JSSVGAnimatedLengthList.h"
#include "JSSVGAnimatedNumberList.h"
#include "SVGTextPositioningElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGTextPositioningElementTableValues[] =
{
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPositioningElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPositioningElementY), (intptr_t)0, NoIntrinsic },
    { "dx", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPositioningElementDx), (intptr_t)0, NoIntrinsic },
    { "dy", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPositioningElementDy), (intptr_t)0, NoIntrinsic },
    { "rotate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPositioningElementRotate), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextPositioningElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTextPositioningElementTable = { 17, 15, JSSVGTextPositioningElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGTextPositioningElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTextPositioningElementConstructorTable = { 1, 0, JSSVGTextPositioningElementConstructorTableValues, 0 };
const ClassInfo JSSVGTextPositioningElementConstructor::s_info = { "SVGTextPositioningElementConstructor", &Base::s_info, &JSSVGTextPositioningElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGTextPositioningElementConstructor) };

JSSVGTextPositioningElementConstructor::JSSVGTextPositioningElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGTextPositioningElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGTextPositioningElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGTextPositioningElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTextPositioningElementConstructor, JSDOMWrapper>(exec, &JSSVGTextPositioningElementConstructorTable, jsCast<JSSVGTextPositioningElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGTextPositioningElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGTextPositioningElementConstructor, JSDOMWrapper>(exec, &JSSVGTextPositioningElementConstructorTable, jsCast<JSSVGTextPositioningElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGTextPositioningElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTextPositioningElementPrototypeTable = { 1, 0, JSSVGTextPositioningElementPrototypeTableValues, 0 };
const ClassInfo JSSVGTextPositioningElementPrototype::s_info = { "SVGTextPositioningElementPrototype", &Base::s_info, &JSSVGTextPositioningElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGTextPositioningElementPrototype) };

JSObject* JSSVGTextPositioningElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTextPositioningElement>(exec, globalObject);
}

const ClassInfo JSSVGTextPositioningElement::s_info = { "SVGTextPositioningElement", &Base::s_info, &JSSVGTextPositioningElementTable, 0 , CREATE_METHOD_TABLE(JSSVGTextPositioningElement) };

JSSVGTextPositioningElement::JSSVGTextPositioningElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGTextPositioningElement> impl)
    : JSSVGTextContentElement(structure, globalObject, impl)
{
}

void JSSVGTextPositioningElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGTextPositioningElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGTextPositioningElementPrototype::create(exec->globalData(), globalObject, JSSVGTextPositioningElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGTextContentElementPrototype::self(exec, globalObject)));
}

bool JSSVGTextPositioningElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGTextPositioningElement* thisObject = jsCast<JSSVGTextPositioningElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGTextPositioningElement, Base>(exec, &JSSVGTextPositioningElementTable, thisObject, propertyName, slot);
}

bool JSSVGTextPositioningElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGTextPositioningElement* thisObject = jsCast<JSSVGTextPositioningElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGTextPositioningElement, Base>(exec, &JSSVGTextPositioningElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGTextPositioningElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextPositioningElement* castedThis = jsCast<JSSVGTextPositioningElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPositioningElement* impl = static_cast<SVGTextPositioningElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLengthList> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTextPositioningElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextPositioningElement* castedThis = jsCast<JSSVGTextPositioningElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPositioningElement* impl = static_cast<SVGTextPositioningElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLengthList> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTextPositioningElementDx(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextPositioningElement* castedThis = jsCast<JSSVGTextPositioningElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPositioningElement* impl = static_cast<SVGTextPositioningElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLengthList> obj = impl->dxAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTextPositioningElementDy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextPositioningElement* castedThis = jsCast<JSSVGTextPositioningElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPositioningElement* impl = static_cast<SVGTextPositioningElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLengthList> obj = impl->dyAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTextPositioningElementRotate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextPositioningElement* castedThis = jsCast<JSSVGTextPositioningElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextPositioningElement* impl = static_cast<SVGTextPositioningElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumberList> obj = impl->rotateAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTextPositioningElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextPositioningElement* domObject = jsCast<JSSVGTextPositioningElement*>(asObject(slotBase));
    return JSSVGTextPositioningElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGTextPositioningElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGTextPositioningElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
