/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGClipPathElement.h"

#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGClipPathElement.h"
#include "SVGElement.h"
#include "SVGMatrix.h"
#include "SVGRect.h"
#include "SVGStringList.h"
#include "StylePropertySet.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGClipPathElementTableValues[] =
{
    { "clipPathUnits", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementClipPathUnits), (intptr_t)0, NoIntrinsic },
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementXmllang), (intptr_t)setJSSVGClipPathElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementXmlspace), (intptr_t)setJSSVGClipPathElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementClassName), (intptr_t)0, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementStyle), (intptr_t)0, NoIntrinsic },
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementTransform), (intptr_t)0, NoIntrinsic },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGClipPathElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGClipPathElementTable = { 35, 31, JSSVGClipPathElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGClipPathElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGClipPathElementConstructorTable = { 1, 0, JSSVGClipPathElementConstructorTableValues, 0 };
const ClassInfo JSSVGClipPathElementConstructor::s_info = { "SVGClipPathElementConstructor", &Base::s_info, &JSSVGClipPathElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGClipPathElementConstructor) };

JSSVGClipPathElementConstructor::JSSVGClipPathElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGClipPathElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGClipPathElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGClipPathElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGClipPathElementConstructor, JSDOMWrapper>(exec, &JSSVGClipPathElementConstructorTable, jsCast<JSSVGClipPathElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGClipPathElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGClipPathElementConstructor, JSDOMWrapper>(exec, &JSSVGClipPathElementConstructorTable, jsCast<JSSVGClipPathElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGClipPathElementPrototypeTableValues[] =
{
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGClipPathElementPrototypeFunctionHasExtension), (intptr_t)1, NoIntrinsic },
    { "getPresentationAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGClipPathElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1, NoIntrinsic },
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGClipPathElementPrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGClipPathElementPrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGClipPathElementPrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGClipPathElementPrototypeFunctionGetTransformToElement), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGClipPathElementPrototypeTable = { 17, 15, JSSVGClipPathElementPrototypeTableValues, 0 };
const ClassInfo JSSVGClipPathElementPrototype::s_info = { "SVGClipPathElementPrototype", &Base::s_info, &JSSVGClipPathElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGClipPathElementPrototype) };

JSObject* JSSVGClipPathElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGClipPathElement>(exec, globalObject);
}

bool JSSVGClipPathElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGClipPathElementPrototype* thisObject = jsCast<JSSVGClipPathElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGClipPathElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGClipPathElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGClipPathElementPrototype* thisObject = jsCast<JSSVGClipPathElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGClipPathElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGClipPathElement::s_info = { "SVGClipPathElement", &Base::s_info, &JSSVGClipPathElementTable, 0 , CREATE_METHOD_TABLE(JSSVGClipPathElement) };

JSSVGClipPathElement::JSSVGClipPathElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGClipPathElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGClipPathElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGClipPathElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGClipPathElementPrototype::create(exec->globalData(), globalObject, JSSVGClipPathElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGClipPathElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGClipPathElement* thisObject = jsCast<JSSVGClipPathElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGClipPathElement, Base>(exec, &JSSVGClipPathElementTable, thisObject, propertyName, slot);
}

bool JSSVGClipPathElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGClipPathElement* thisObject = jsCast<JSSVGClipPathElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGClipPathElement, Base>(exec, &JSSVGClipPathElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGClipPathElementClipPathUnits(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = impl->clipPathUnitsAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGClipPathElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGClipPathElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGClipPathElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGClipPathElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGClipPathElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGClipPathElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGClipPathElementClassName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGClipPathElementStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsSVGClipPathElementTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGClipPathElementNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGClipPathElementFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


JSValue jsSVGClipPathElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGClipPathElement* domObject = jsCast<JSSVGClipPathElement*>(asObject(slotBase));
    return JSSVGClipPathElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGClipPathElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGClipPathElement* thisObject = jsCast<JSSVGClipPathElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGClipPathElement, Base>(exec, propertyName, value, &JSSVGClipPathElementTable, thisObject, slot);
}

void setJSSVGClipPathElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(thisObject);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    impl->setXmllang(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSSVGClipPathElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(thisObject);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    impl->setXmlspace(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


JSValue JSSVGClipPathElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGClipPathElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGClipPathElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGClipPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGClipPathElement::s_info);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    const String& extension(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGClipPathElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGClipPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGClipPathElement::s_info);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getPresentationAttribute(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGClipPathElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGClipPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGClipPathElement::s_info);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGClipPathElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGClipPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGClipPathElement::s_info);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGClipPathElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGClipPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGClipPathElement::s_info);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGClipPathElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGClipPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGClipPathElement* castedThis = jsCast<JSSVGClipPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGClipPathElement::s_info);
    SVGClipPathElement* impl = static_cast<SVGClipPathElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
