/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInternalSettings.h"

#include "ExceptionCode.h"
#include "InternalSettings.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSInternalSettingsPrototypeTableValues[] =
{
    { "setForceCompositingMode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetForceCompositingMode), (intptr_t)1, NoIntrinsic },
    { "setEnableCompositingForFixedPosition", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetEnableCompositingForFixedPosition), (intptr_t)1, NoIntrinsic },
    { "setEnableCompositingForScrollableFrames", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetEnableCompositingForScrollableFrames), (intptr_t)1, NoIntrinsic },
    { "setAcceleratedDrawingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetAcceleratedDrawingEnabled), (intptr_t)1, NoIntrinsic },
    { "setAcceleratedFiltersEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetAcceleratedFiltersEnabled), (intptr_t)1, NoIntrinsic },
    { "setMockScrollbarsEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetMockScrollbarsEnabled), (intptr_t)1, NoIntrinsic },
    { "setPasswordEchoEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetPasswordEchoEnabled), (intptr_t)1, NoIntrinsic },
    { "setPasswordEchoDurationInSeconds", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetPasswordEchoDurationInSeconds), (intptr_t)1, NoIntrinsic },
    { "setFixedElementsLayoutRelativeToFrame", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetFixedElementsLayoutRelativeToFrame), (intptr_t)1, NoIntrinsic },
    { "setUnifiedTextCheckingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetUnifiedTextCheckingEnabled), (intptr_t)1, NoIntrinsic },
    { "unifiedTextCheckingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionUnifiedTextCheckingEnabled), (intptr_t)0, NoIntrinsic },
    { "setTouchEventEmulationEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetTouchEventEmulationEnabled), (intptr_t)1, NoIntrinsic },
    { "setDeviceSupportsTouch", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetDeviceSupportsTouch), (intptr_t)1, NoIntrinsic },
    { "setDeviceSupportsMouse", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetDeviceSupportsMouse), (intptr_t)1, NoIntrinsic },
    { "setShadowDOMEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetShadowDOMEnabled), (intptr_t)1, NoIntrinsic },
    { "setAuthorShadowDOMForAnyElementEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetAuthorShadowDOMForAnyElementEnabled), (intptr_t)1, NoIntrinsic },
    { "setStyleScopedEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetStyleScopedEnabled), (intptr_t)1, NoIntrinsic },
    { "setStandardFontFamily", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetStandardFontFamily), (intptr_t)2, NoIntrinsic },
    { "setSerifFontFamily", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetSerifFontFamily), (intptr_t)2, NoIntrinsic },
    { "setSansSerifFontFamily", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetSansSerifFontFamily), (intptr_t)2, NoIntrinsic },
    { "setFixedFontFamily", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetFixedFontFamily), (intptr_t)2, NoIntrinsic },
    { "setCursiveFontFamily", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetCursiveFontFamily), (intptr_t)2, NoIntrinsic },
    { "setFantasyFontFamily", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetFantasyFontFamily), (intptr_t)2, NoIntrinsic },
    { "setPictographFontFamily", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetPictographFontFamily), (intptr_t)2, NoIntrinsic },
    { "setTextAutosizingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetTextAutosizingEnabled), (intptr_t)1, NoIntrinsic },
    { "setTextAutosizingWindowSizeOverride", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetTextAutosizingWindowSizeOverride), (intptr_t)2, NoIntrinsic },
    { "setTextAutosizingFontScaleFactor", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetTextAutosizingFontScaleFactor), (intptr_t)1, NoIntrinsic },
    { "setResolutionOverride", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetResolutionOverride), (intptr_t)2, NoIntrinsic },
    { "setMediaTypeOverride", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetMediaTypeOverride), (intptr_t)1, NoIntrinsic },
    { "setEnableScrollAnimator", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetEnableScrollAnimator), (intptr_t)1, NoIntrinsic },
    { "scrollAnimatorEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionScrollAnimatorEnabled), (intptr_t)0, NoIntrinsic },
    { "setCSSExclusionsEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetCSSExclusionsEnabled), (intptr_t)1, NoIntrinsic },
    { "setCSSVariablesEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetCSSVariablesEnabled), (intptr_t)1, NoIntrinsic },
    { "cssVariablesEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionCssVariablesEnabled), (intptr_t)0, NoIntrinsic },
    { "setCanStartMedia", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetCanStartMedia), (intptr_t)1, NoIntrinsic },
    { "setMediaPlaybackRequiresUserGesture", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetMediaPlaybackRequiresUserGesture), (intptr_t)1, NoIntrinsic },
    { "setEditingBehavior", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetEditingBehavior), (intptr_t)1, NoIntrinsic },
    { "setFixedPositionCreatesStackingContext", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetFixedPositionCreatesStackingContext), (intptr_t)1, NoIntrinsic },
    { "setSyncXHRInDocumentsEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetSyncXHRInDocumentsEnabled), (intptr_t)1, NoIntrinsic },
    { "setWindowFocusRestricted", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetWindowFocusRestricted), (intptr_t)1, NoIntrinsic },
    { "setDialogElementEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetDialogElementEnabled), (intptr_t)1, NoIntrinsic },
    { "setLangAttributeAwareFormControlUIEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetLangAttributeAwareFormControlUIEnabled), (intptr_t)1, NoIntrinsic },
#if ENABLE(VIDEO_TRACK)
    { "setShouldDisplayTrackKind", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetShouldDisplayTrackKind), (intptr_t)2, NoIntrinsic },
#endif
#if ENABLE(VIDEO_TRACK)
    { "shouldDisplayTrackKind", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionShouldDisplayTrackKind), (intptr_t)1, NoIntrinsic },
#endif
    { "setMemoryInfoEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetMemoryInfoEnabled), (intptr_t)1, NoIntrinsic },
    { "setStorageBlockingPolicy", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetStorageBlockingPolicy), (intptr_t)1, NoIntrinsic },
    { "setImagesEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalSettingsPrototypeFunctionSetImagesEnabled), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSInternalSettingsPrototypeTable = { 136, 127, JSInternalSettingsPrototypeTableValues, 0 };
const ClassInfo JSInternalSettingsPrototype::s_info = { "InternalSettingsPrototype", &Base::s_info, &JSInternalSettingsPrototypeTable, 0, CREATE_METHOD_TABLE(JSInternalSettingsPrototype) };

JSObject* JSInternalSettingsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSInternalSettings>(exec, globalObject);
}

bool JSInternalSettingsPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSInternalSettingsPrototype* thisObject = jsCast<JSInternalSettingsPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSInternalSettingsPrototypeTable, thisObject, propertyName, slot);
}

bool JSInternalSettingsPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSInternalSettingsPrototype* thisObject = jsCast<JSInternalSettingsPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSInternalSettingsPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSInternalSettings::s_info = { "InternalSettings", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSInternalSettings) };

JSInternalSettings::JSInternalSettings(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<InternalSettings> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSInternalSettings::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSInternalSettings::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSInternalSettingsPrototype::create(exec->globalData(), globalObject, JSInternalSettingsPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSInternalSettings::destroy(JSC::JSCell* cell)
{
    JSInternalSettings* thisObject = static_cast<JSInternalSettings*>(cell);
    thisObject->JSInternalSettings::~JSInternalSettings();
}

JSInternalSettings::~JSInternalSettings()
{
    releaseImplIfNotNull();
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetForceCompositingMode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setForceCompositingMode(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetEnableCompositingForFixedPosition(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setEnableCompositingForFixedPosition(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetEnableCompositingForScrollableFrames(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setEnableCompositingForScrollableFrames(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetAcceleratedDrawingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAcceleratedDrawingEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetAcceleratedFiltersEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAcceleratedFiltersEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetMockScrollbarsEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMockScrollbarsEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetPasswordEchoEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setPasswordEchoEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetPasswordEchoDurationInSeconds(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    double durationInSeconds(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setPasswordEchoDurationInSeconds(durationInSeconds, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetFixedElementsLayoutRelativeToFrame(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFixedElementsLayoutRelativeToFrame(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetUnifiedTextCheckingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setUnifiedTextCheckingEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionUnifiedTextCheckingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = jsBoolean(impl->unifiedTextCheckingEnabled(ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTouchEventEmulationEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setTouchEventEmulationEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetDeviceSupportsTouch(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDeviceSupportsTouch(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetDeviceSupportsMouse(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDeviceSupportsMouse(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShadowDOMEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShadowDOMEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetAuthorShadowDOMForAnyElementEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool isEnabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAuthorShadowDOMForAnyElementEnabled(isEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetStyleScopedEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool isEnabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setStyleScopedEnabled(isEnabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetStandardFontFamily(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& family(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& script(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setStandardFontFamily(family, script, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetSerifFontFamily(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& family(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& script(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSerifFontFamily(family, script, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetSansSerifFontFamily(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& family(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& script(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSansSerifFontFamily(family, script, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetFixedFontFamily(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& family(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& script(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFixedFontFamily(family, script, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetCursiveFontFamily(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& family(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& script(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCursiveFontFamily(family, script, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetFantasyFontFamily(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& family(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& script(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFantasyFontFamily(family, script, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetPictographFontFamily(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& family(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& script(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setPictographFontFamily(family, script, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTextAutosizingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setTextAutosizingEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTextAutosizingWindowSizeOverride(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int width(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int height(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setTextAutosizingWindowSizeOverride(width, height, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetTextAutosizingFontScaleFactor(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    float fontScaleFactor(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setTextAutosizingFontScaleFactor(fontScaleFactor, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetResolutionOverride(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int dotsPerCSSInchHorizontally(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int dotsPerCSSInchVertically(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setResolutionOverride(dotsPerCSSInchHorizontally, dotsPerCSSInchVertically, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetMediaTypeOverride(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& mediaTypeOverride(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMediaTypeOverride(mediaTypeOverride, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetEnableScrollAnimator(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setEnableScrollAnimator(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionScrollAnimatorEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = jsBoolean(impl->scrollAnimatorEnabled(ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetCSSExclusionsEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCSSExclusionsEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetCSSVariablesEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCSSVariablesEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionCssVariablesEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = jsBoolean(impl->cssVariablesEnabled(ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetCanStartMedia(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCanStartMedia(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetMediaPlaybackRequiresUserGesture(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMediaPlaybackRequiresUserGesture(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetEditingBehavior(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& behavior(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setEditingBehavior(behavior, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetFixedPositionCreatesStackingContext(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool creates(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFixedPositionCreatesStackingContext(creates, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetSyncXHRInDocumentsEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSyncXHRInDocumentsEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetWindowFocusRestricted(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool restricted(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setWindowFocusRestricted(restricted, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetDialogElementEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDialogElementEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetLangAttributeAwareFormControlUIEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setLangAttributeAwareFormControlUIEnabled(enabled);
    return JSValue::encode(jsUndefined());
}

#if ENABLE(VIDEO_TRACK)
EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetShouldDisplayTrackKind(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& kind(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShouldDisplayTrackKind(kind, enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(VIDEO_TRACK)
EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionShouldDisplayTrackKind(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& trackKind(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->shouldDisplayTrackKind(trackKind, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#endif

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetMemoryInfoEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMemoryInfoEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetStorageBlockingPolicy(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& policy(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setStorageBlockingPolicy(policy, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalSettingsPrototypeFunctionSetImagesEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternalSettings::s_info))
        return throwVMTypeError(exec);
    JSInternalSettings* castedThis = jsCast<JSInternalSettings*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternalSettings::s_info);
    InternalSettings* impl = static_cast<InternalSettings*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setImagesEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSInternalSettings* jsInternalSettings)
{
    if (jsInternalSettings->hasCustomProperties())
        return true;
    return false;
}

bool JSInternalSettingsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSInternalSettings* jsInternalSettings = jsCast<JSInternalSettings*>(handle.get().asCell());
    if (!isObservable(jsInternalSettings))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSInternalSettingsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSInternalSettings* jsInternalSettings = jsCast<JSInternalSettings*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsInternalSettings->impl(), jsInternalSettings);
    jsInternalSettings->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, InternalSettings* impl)
{
    return wrap<JSInternalSettings>(exec, globalObject, impl);
}

InternalSettings* toInternalSettings(JSC::JSValue value)
{
    return value.inherits(&JSInternalSettings::s_info) ? jsCast<JSInternalSettings*>(asObject(value))->impl() : 0;
}

}
