/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCompositionEvent.h"

#include "CompositionEvent.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMWindow.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCompositionEventTableValues[] =
{
    { "data", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCompositionEventData), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCompositionEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCompositionEventTable = { 4, 3, JSCompositionEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSCompositionEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCompositionEventConstructorTable = { 1, 0, JSCompositionEventConstructorTableValues, 0 };
const ClassInfo JSCompositionEventConstructor::s_info = { "CompositionEventConstructor", &Base::s_info, &JSCompositionEventConstructorTable, 0, CREATE_METHOD_TABLE(JSCompositionEventConstructor) };

JSCompositionEventConstructor::JSCompositionEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCompositionEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSCompositionEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCompositionEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCompositionEventConstructor, JSDOMWrapper>(exec, &JSCompositionEventConstructorTable, jsCast<JSCompositionEventConstructor*>(cell), propertyName, slot);
}

bool JSCompositionEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCompositionEventConstructor, JSDOMWrapper>(exec, &JSCompositionEventConstructorTable, jsCast<JSCompositionEventConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCompositionEventPrototypeTableValues[] =
{
    { "initCompositionEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCompositionEventPrototypeFunctionInitCompositionEvent), (intptr_t)5, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCompositionEventPrototypeTable = { 2, 1, JSCompositionEventPrototypeTableValues, 0 };
const ClassInfo JSCompositionEventPrototype::s_info = { "CompositionEventPrototype", &Base::s_info, &JSCompositionEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSCompositionEventPrototype) };

JSObject* JSCompositionEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCompositionEvent>(exec, globalObject);
}

bool JSCompositionEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCompositionEventPrototype* thisObject = jsCast<JSCompositionEventPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSCompositionEventPrototypeTable, thisObject, propertyName, slot);
}

bool JSCompositionEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCompositionEventPrototype* thisObject = jsCast<JSCompositionEventPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCompositionEventPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSCompositionEvent::s_info = { "CompositionEvent", &Base::s_info, &JSCompositionEventTable, 0 , CREATE_METHOD_TABLE(JSCompositionEvent) };

JSCompositionEvent::JSCompositionEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CompositionEvent> impl)
    : JSUIEvent(structure, globalObject, impl)
{
}

void JSCompositionEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSCompositionEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCompositionEventPrototype::create(exec->globalData(), globalObject, JSCompositionEventPrototype::createStructure(exec->globalData(), globalObject, JSUIEventPrototype::self(exec, globalObject)));
}

bool JSCompositionEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCompositionEvent* thisObject = jsCast<JSCompositionEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSCompositionEvent, Base>(exec, &JSCompositionEventTable, thisObject, propertyName, slot);
}

bool JSCompositionEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCompositionEvent* thisObject = jsCast<JSCompositionEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSCompositionEvent, Base>(exec, &JSCompositionEventTable, thisObject, propertyName, descriptor);
}

JSValue jsCompositionEventData(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCompositionEvent* castedThis = jsCast<JSCompositionEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CompositionEvent* impl = static_cast<CompositionEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->data());
    return result;
}


JSValue jsCompositionEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCompositionEvent* domObject = jsCast<JSCompositionEvent*>(asObject(slotBase));
    return JSCompositionEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSCompositionEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCompositionEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCompositionEventPrototypeFunctionInitCompositionEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCompositionEvent::s_info))
        return throwVMTypeError(exec);
    JSCompositionEvent* castedThis = jsCast<JSCompositionEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCompositionEvent::s_info);
    CompositionEvent* impl = static_cast<CompositionEvent*>(castedThis->impl());
    const String& typeArg(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool canBubbleArg(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool cancelableArg(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    DOMWindow* viewArg(toDOMWindow(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& dataArg(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->initCompositionEvent(typeArg, canBubbleArg, cancelableArg, viewArg, dataArg);
    return JSValue::encode(jsUndefined());
}


}
