; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv32 -global-isel < %s | FileCheck %s --check-prefixes=CHECK,CHECKI,RV32
; RUN: llc -mtriple=riscv64 -global-isel < %s | FileCheck %s --check-prefixes=CHECK,CHECKI,RV64
; RUN: llc -mtriple=riscv32 -mattr=+f -global-isel < %s | FileCheck %s --check-prefixes=CHECK,CHECKIF,RV32
; RUN: llc -mtriple=riscv64 -mattr=+f -global-isel < %s | FileCheck %s --check-prefixes=CHECK,CHECKIF,RV64

define i1 @phi_i1(i1 %cnd, i1 %a, i1 %b) {
; CHECK-LABEL: phi_i1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a3, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    andi a3, a3, 1
; CHECK-NEXT:    bnez a3, .LBB0_2
; CHECK-NEXT:  # %bb.1: # %cond.false
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:  .LBB0_2: # %cond.end
; CHECK-NEXT:    ret
entry:
  br i1 %cnd, label %cond.end, label %cond.false

cond.false:                                       ; preds = %entry
  br label %cond.end

cond.end:                                         ; preds = %entry, %cond.false
  %cond = phi i1 [ %b, %cond.false ], [ %a, %entry ]
  ret i1 %cond
}

define i8 @phi_i8(i1 %cnd, i8 %a, i8 %b) {
; CHECK-LABEL: phi_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a3, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    andi a3, a3, 1
; CHECK-NEXT:    bnez a3, .LBB1_2
; CHECK-NEXT:  # %bb.1: # %cond.false
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:  .LBB1_2: # %cond.end
; CHECK-NEXT:    ret
entry:
  br i1 %cnd, label %cond.end, label %cond.false

cond.false:                                       ; preds = %entry
  br label %cond.end

cond.end:                                         ; preds = %entry, %cond.false
  %cond = phi i8 [ %b, %cond.false ], [ %a, %entry ]
  ret i8 %cond
}

define i16 @phi_i16(i1 %cnd, i16 %a, i16 %b) {
; CHECK-LABEL: phi_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a3, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    andi a3, a3, 1
; CHECK-NEXT:    bnez a3, .LBB2_2
; CHECK-NEXT:  # %bb.1: # %cond.false
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:  .LBB2_2: # %cond.end
; CHECK-NEXT:    ret
entry:
  br i1 %cnd, label %cond.end, label %cond.false

cond.false:                                       ; preds = %entry
  br label %cond.end

cond.end:                                         ; preds = %entry, %cond.false
  %cond = phi i16 [ %b, %cond.false ], [ %a, %entry ]
  ret i16 %cond
}

define i32 @phi_i32(i1 %cnd, i32 %a, i32 %b) {
; CHECK-LABEL: phi_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a3, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    andi a3, a3, 1
; CHECK-NEXT:    bnez a3, .LBB3_2
; CHECK-NEXT:  # %bb.1: # %cond.false
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:  .LBB3_2: # %cond.end
; CHECK-NEXT:    ret
entry:
  br i1 %cnd, label %cond.end, label %cond.false

cond.false:                                       ; preds = %entry
  br label %cond.end

cond.end:                                         ; preds = %entry, %cond.false
  %cond = phi i32 [ %b, %cond.false ], [ %a, %entry ]
  ret i32 %cond
}

define i64 @phi_i64(i1 %cnd, i64 %a, i64 %b) {
; RV32-LABEL: phi_i64:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    mv a5, a0
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    mv a1, a2
; RV32-NEXT:    andi a5, a5, 1
; RV32-NEXT:    bnez a5, .LBB4_2
; RV32-NEXT:  # %bb.1: # %cond.false
; RV32-NEXT:    mv a0, a3
; RV32-NEXT:    mv a1, a4
; RV32-NEXT:  .LBB4_2: # %cond.end
; RV32-NEXT:    ret
;
; RV64-LABEL: phi_i64:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    mv a3, a0
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    andi a3, a3, 1
; RV64-NEXT:    bnez a3, .LBB4_2
; RV64-NEXT:  # %bb.1: # %cond.false
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB4_2: # %cond.end
; RV64-NEXT:    ret
entry:
  br i1 %cnd, label %cond.end, label %cond.false

cond.false:                                       ; preds = %entry
  br label %cond.end

cond.end:                                         ; preds = %entry, %cond.false
  %cond = phi i64 [ %b, %cond.false ], [ %a, %entry ]
  ret i64 %cond
}

define ptr @phi_ptr(i1 %cnd, ptr %a, ptr %b) {
; CHECK-LABEL: phi_ptr:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mv a3, a0
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:    andi a3, a3, 1
; CHECK-NEXT:    bnez a3, .LBB5_2
; CHECK-NEXT:  # %bb.1: # %cond.false
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:  .LBB5_2: # %cond.end
; CHECK-NEXT:    ret
entry:
  br i1 %cnd, label %cond.end, label %cond.false

cond.false:                                       ; preds = %entry
  br label %cond.end

cond.end:                                         ; preds = %entry, %cond.false
  %cond = phi ptr [ %b, %cond.false ], [ %a, %entry ]
  ret ptr %cond
}

define float @phi_float(i1 %cnd, float %a, float %b) {
; CHECKI-LABEL: phi_float:
; CHECKI:       # %bb.0: # %entry
; CHECKI-NEXT:    mv a3, a0
; CHECKI-NEXT:    mv a0, a1
; CHECKI-NEXT:    andi a3, a3, 1
; CHECKI-NEXT:    bnez a3, .LBB6_2
; CHECKI-NEXT:  # %bb.1: # %cond.false
; CHECKI-NEXT:    mv a0, a2
; CHECKI-NEXT:  .LBB6_2: # %cond.end
; CHECKI-NEXT:    ret
;
; CHECKIF-LABEL: phi_float:
; CHECKIF:       # %bb.0: # %entry
; CHECKIF-NEXT:    andi a0, a0, 1
; CHECKIF-NEXT:    bnez a0, .LBB6_2
; CHECKIF-NEXT:  # %bb.1: # %cond.false
; CHECKIF-NEXT:    fmv.s fa0, fa1
; CHECKIF-NEXT:  .LBB6_2: # %cond.end
; CHECKIF-NEXT:    ret
entry:
  br i1 %cnd, label %cond.end, label %cond.false

cond.false:                                       ; preds = %entry
  br label %cond.end

cond.end:                                         ; preds = %entry, %cond.false
  %cond = phi float [ %b, %cond.false ], [ %a, %entry ]
  ret float %cond
}
