; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --scrub-attributes
; RUN: opt < %s -passes=argpromotion -S | FileCheck %s

declare void @sink(i32)

define internal void @test(ptr %X) !dbg !2 {
; CHECK-LABEL: define {{[^@]+}}@test
; CHECK-SAME: (i32 [[X_0_VAL_0_VAL:%.*]]) !dbg [[DBG3:![0-9]+]] {
; CHECK-NEXT:    call void @sink(i32 [[X_0_VAL_0_VAL]])
; CHECK-NEXT:    ret void
;
  %1 = load ptr, ptr %X, align 8
  %2 = load i32, ptr %1, align 8
  call void @sink(i32 %2)
  ret void
}

%struct.pair = type { i32, i32 }

; Do not promote because there is a store of the pointer %P itself. Even if %P
; had been promoted as a byval argument, the result would have been not
; optimizable for SROA.
define internal void @test_byval(ptr byval(%struct.pair) align 4 %P) {
; CHECK-LABEL: define {{[^@]+}}@test_byval
; CHECK-SAME: (ptr byval([[STRUCT_PAIR:%.*]]) align 4 [[P:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = alloca ptr, align 8
; CHECK-NEXT:    store ptr [[P]], ptr [[TMP1]], align 8
; CHECK-NEXT:    ret void
;
  %1 = alloca ptr, align 8
  store ptr %P, ptr %1, align 8 ; to protect from promotion
  ret void
}

define void @caller(ptr %Y, ptr %P) {
; CHECK-LABEL: define {{[^@]+}}@caller
; CHECK-SAME: (ptr [[Y:%.*]], ptr [[P:%.*]]) {
; CHECK-NEXT:    [[Y_VAL:%.*]] = load ptr, ptr [[Y]], align 8, !dbg [[DBG4:![0-9]+]]
; CHECK-NEXT:    [[Y_VAL_VAL:%.*]] = load i32, ptr [[Y_VAL]], align 8, !dbg [[DBG4]]
; CHECK-NEXT:    call void @test(i32 [[Y_VAL_VAL]]), !dbg [[DBG4]]
; CHECK-NEXT:    call void @test_byval(ptr byval([[STRUCT_PAIR:%.*]]) align 4 [[P]]), !dbg [[DBG5:![0-9]+]]
; CHECK-NEXT:    ret void
;
  call void @test(ptr %Y), !dbg !1

  call void @test_byval(ptr byval(%struct.pair) align 4 %P), !dbg !6
  ret void
}


!llvm.module.flags = !{!0}
!llvm.dbg.cu = !{!3}

!0 = !{i32 2, !"Debug Info Version", i32 3}
!1 = !DILocation(line: 8, scope: !2)
!2 = distinct !DISubprogram(name: "test", file: !5, line: 3, isLocal: true, isDefinition: true, virtualIndex: 6, flags: DIFlagPrototyped, isOptimized: false, unit: !3, scopeLine: 3, scope: null)
!3 = distinct !DICompileUnit(language: DW_LANG_C_plus_plus, producer: "clang version 3.5.0 ", isOptimized: false, emissionKind: LineTablesOnly, file: !5)
!5 = !DIFile(filename: "test.c", directory: "")
!6 = !DILocation(line: 9, scope: !2)
