; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: llc -mtriple=riscv64 -mattr=+v,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64
;
; SABD
;

define <8 x i8> @sabd_8b_as_16b(<8 x i8> %a, <8 x i8> %b) {
;
; CHECK-LABEL: sabd_8b_as_16b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a.sext = sext <8 x i8> %a to <8 x i16>
  %b.sext = sext <8 x i8> %b to <8 x i16>
  %sub = sub <8 x i16> %a.sext, %b.sext
  %abs = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %sub, i1 true)
  %trunc = trunc <8 x i16> %abs to <8 x i8>
  ret <8 x i8> %trunc
}

define <8 x i8> @sabd_8b_as_32b(<8 x i8> %a, <8 x i8> %b) {
;
; CHECK-LABEL: sabd_8b_as_32b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a.sext = sext <8 x i8> %a to <8 x i32>
  %b.sext = sext <8 x i8> %b to <8 x i32>
  %sub = sub <8 x i32> %a.sext, %b.sext
  %abs = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %sub, i1 true)
  %trunc = trunc <8 x i32> %abs to <8 x i8>
  ret <8 x i8> %trunc
}

define <16 x i8> @sabd_16b(<16 x i8> %a, <16 x i8> %b) {
;
; CHECK-LABEL: sabd_16b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a.sext = sext <16 x i8> %a to <16 x i16>
  %b.sext = sext <16 x i8> %b to <16 x i16>
  %sub = sub <16 x i16> %a.sext, %b.sext
  %abs = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %sub, i1 true)
  %trunc = trunc <16 x i16> %abs to <16 x i8>
  ret <16 x i8> %trunc
}

define <4 x i16> @sabd_4h(<4 x i16> %a, <4 x i16> %b) {
;
; CHECK-LABEL: sabd_4h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a.sext = sext <4 x i16> %a to <4 x i32>
  %b.sext = sext <4 x i16> %b to <4 x i32>
  %sub = sub <4 x i32> %a.sext, %b.sext
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %sub, i1 true)
  %trunc = trunc <4 x i32> %abs to <4 x i16>
  ret <4 x i16> %trunc
}

define <4 x i16> @sabd_4h_promoted_ops(<4 x i8> %a, <4 x i8> %b) {
;
; CHECK-LABEL: sabd_4h_promoted_ops:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v9, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v9
; CHECK-NEXT:    ret
  %a.sext = sext <4 x i8> %a to <4 x i16>
  %b.sext = sext <4 x i8> %b to <4 x i16>
  %sub = sub <4 x i16> %a.sext, %b.sext
  %abs = call <4 x i16> @llvm.abs.v4i16(<4 x i16> %sub, i1 true)
  ret <4 x i16> %abs
}

define <8 x i16> @sabd_8h(<8 x i16> %a, <8 x i16> %b) {
;
; CHECK-LABEL: sabd_8h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a.sext = sext <8 x i16> %a to <8 x i32>
  %b.sext = sext <8 x i16> %b to <8 x i32>
  %sub = sub <8 x i32> %a.sext, %b.sext
  %abs = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %sub, i1 true)
  %trunc = trunc <8 x i32> %abs to <8 x i16>
  ret <8 x i16> %trunc
}

define <8 x i16> @sabd_8h_promoted_ops(<8 x i8> %a, <8 x i8> %b) {
;
; CHECK-LABEL: sabd_8h_promoted_ops:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v9, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v9
; CHECK-NEXT:    ret
  %a.sext = sext <8 x i8> %a to <8 x i16>
  %b.sext = sext <8 x i8> %b to <8 x i16>
  %sub = sub <8 x i16> %a.sext, %b.sext
  %abs = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %sub, i1 true)
  ret <8 x i16> %abs
}

define <2 x i32> @sabd_2s(<2 x i32> %a, <2 x i32> %b) {
;
; CHECK-LABEL: sabd_2s:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a.sext = sext <2 x i32> %a to <2 x i64>
  %b.sext = sext <2 x i32> %b to <2 x i64>
  %sub = sub <2 x i64> %a.sext, %b.sext
  %abs = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %sub, i1 true)
  %trunc = trunc <2 x i64> %abs to <2 x i32>
  ret <2 x i32> %trunc
}

define <2 x i32> @sabd_2s_promoted_ops(<2 x i16> %a, <2 x i16> %b) {
;
; CHECK-LABEL: sabd_2s_promoted_ops:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v9, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v9
; CHECK-NEXT:    ret
  %a.sext = sext <2 x i16> %a to <2 x i32>
  %b.sext = sext <2 x i16> %b to <2 x i32>
  %sub = sub <2 x i32> %a.sext, %b.sext
  %abs = call <2 x i32> @llvm.abs.v2i32(<2 x i32> %sub, i1 true)
  ret <2 x i32> %abs
}

define <4 x i32> @sabd_4s(<4 x i32> %a, <4 x i32> %b) {
;
; CHECK-LABEL: sabd_4s:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a.sext = sext <4 x i32> %a to <4 x i64>
  %b.sext = sext <4 x i32> %b to <4 x i64>
  %sub = sub <4 x i64> %a.sext, %b.sext
  %abs = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %sub, i1 true)
  %trunc = trunc <4 x i64> %abs to <4 x i32>
  ret <4 x i32> %trunc
}

define <4 x i32> @sabd_4s_promoted_ops(<4 x i16> %a, <4 x i16> %b) {
;
; CHECK-LABEL: sabd_4s_promoted_ops:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v9, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v9
; CHECK-NEXT:    ret
  %a.sext = sext <4 x i16> %a to <4 x i32>
  %b.sext = sext <4 x i16> %b to <4 x i32>
  %sub = sub <4 x i32> %a.sext, %b.sext
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %sub, i1 true)
  ret <4 x i32> %abs
}

define <2 x i64> @sabd_2d(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: sabd_2d:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a.sext = sext <2 x i64> %a to <2 x i128>
  %b.sext = sext <2 x i64> %b to <2 x i128>
  %sub = sub <2 x i128> %a.sext, %b.sext
  %abs = call <2 x i128> @llvm.abs.v2i128(<2 x i128> %sub, i1 true)
  %trunc = trunc <2 x i128> %abs to <2 x i64>
  ret <2 x i64> %trunc
}

define <2 x i64> @sabd_2d_promoted_ops(<2 x i32> %a, <2 x i32> %b) {
;
; CHECK-LABEL: sabd_2d_promoted_ops:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v9, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v9
; CHECK-NEXT:    ret
  %a.sext = sext <2 x i32> %a to <2 x i64>
  %b.sext = sext <2 x i32> %b to <2 x i64>
  %sub = sub <2 x i64> %a.sext, %b.sext
  %abs = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %sub, i1 true)
  ret <2 x i64> %abs
}

;
; UABD
;

define <8 x i8> @uabd_8b(<8 x i8> %a, <8 x i8> %b) {
;
; CHECK-LABEL: uabd_8b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a.zext = zext <8 x i8> %a to <8 x i16>
  %b.zext = zext <8 x i8> %b to <8 x i16>
  %sub = sub <8 x i16> %a.zext, %b.zext
  %abs = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %sub, i1 true)
  %trunc = trunc <8 x i16> %abs to <8 x i8>
  ret <8 x i8> %trunc
}

define <16 x i8> @uabd_16b(<16 x i8> %a, <16 x i8> %b) {
;
; CHECK-LABEL: uabd_16b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a.zext = zext <16 x i8> %a to <16 x i16>
  %b.zext = zext <16 x i8> %b to <16 x i16>
  %sub = sub <16 x i16> %a.zext, %b.zext
  %abs = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %sub, i1 true)
  %trunc = trunc <16 x i16> %abs to <16 x i8>
  ret <16 x i8> %trunc
}

define <4 x i16> @uabd_4h(<4 x i16> %a, <4 x i16> %b) {
;
; CHECK-LABEL: uabd_4h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a.zext = zext <4 x i16> %a to <4 x i32>
  %b.zext = zext <4 x i16> %b to <4 x i32>
  %sub = sub <4 x i32> %a.zext, %b.zext
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %sub, i1 true)
  %trunc = trunc <4 x i32> %abs to <4 x i16>
  ret <4 x i16> %trunc
}

define <4 x i16> @uabd_4h_promoted_ops(<4 x i8> %a, <4 x i8> %b) {
;
; CHECK-LABEL: uabd_4h_promoted_ops:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v9, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v9
; CHECK-NEXT:    ret
  %a.zext = zext <4 x i8> %a to <4 x i16>
  %b.zext = zext <4 x i8> %b to <4 x i16>
  %sub = sub <4 x i16> %a.zext, %b.zext
  %abs = call <4 x i16> @llvm.abs.v4i16(<4 x i16> %sub, i1 true)
  ret <4 x i16> %abs
}

define <8 x i16> @uabd_8h(<8 x i16> %a, <8 x i16> %b) {
;
; CHECK-LABEL: uabd_8h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a.zext = zext <8 x i16> %a to <8 x i32>
  %b.zext = zext <8 x i16> %b to <8 x i32>
  %sub = sub <8 x i32> %a.zext, %b.zext
  %abs = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %sub, i1 true)
  %trunc = trunc <8 x i32> %abs to <8 x i16>
  ret <8 x i16> %trunc
}

define <8 x i16> @uabd_8h_promoted_ops(<8 x i8> %a, <8 x i8> %b) {
;
; CHECK-LABEL: uabd_8h_promoted_ops:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v9, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v9
; CHECK-NEXT:    ret
  %a.zext = zext <8 x i8> %a to <8 x i16>
  %b.zext = zext <8 x i8> %b to <8 x i16>
  %sub = sub <8 x i16> %a.zext, %b.zext
  %abs = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %sub, i1 true)
  ret <8 x i16> %abs
}

define <2 x i32> @uabd_2s(<2 x i32> %a, <2 x i32> %b) {
;
; CHECK-LABEL: uabd_2s:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a.zext = zext <2 x i32> %a to <2 x i64>
  %b.zext = zext <2 x i32> %b to <2 x i64>
  %sub = sub <2 x i64> %a.zext, %b.zext
  %abs = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %sub, i1 true)
  %trunc = trunc <2 x i64> %abs to <2 x i32>
  ret <2 x i32> %trunc
}

define <2 x i32> @uabd_2s_promoted_ops(<2 x i16> %a, <2 x i16> %b) {
;
; CHECK-LABEL: uabd_2s_promoted_ops:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v9, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v9
; CHECK-NEXT:    ret
  %a.zext = zext <2 x i16> %a to <2 x i32>
  %b.zext = zext <2 x i16> %b to <2 x i32>
  %sub = sub <2 x i32> %a.zext, %b.zext
  %abs = call <2 x i32> @llvm.abs.v2i32(<2 x i32> %sub, i1 true)
  ret <2 x i32> %abs
}

define <4 x i32> @uabd_4s(<4 x i32> %a, <4 x i32> %b) {
;
; CHECK-LABEL: uabd_4s:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a.zext = zext <4 x i32> %a to <4 x i64>
  %b.zext = zext <4 x i32> %b to <4 x i64>
  %sub = sub <4 x i64> %a.zext, %b.zext
  %abs = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %sub, i1 true)
  %trunc = trunc <4 x i64> %abs to <4 x i32>
  ret <4 x i32> %trunc
}

define <4 x i32> @uabd_4s_promoted_ops(<4 x i16> %a, <4 x i16> %b) {
;
; CHECK-LABEL: uabd_4s_promoted_ops:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v9, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v9
; CHECK-NEXT:    ret
  %a.zext = zext <4 x i16> %a to <4 x i32>
  %b.zext = zext <4 x i16> %b to <4 x i32>
  %sub = sub <4 x i32> %a.zext, %b.zext
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %sub, i1 true)
  ret <4 x i32> %abs
}

define <2 x i64> @uabd_2d(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: uabd_2d:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a.zext = zext <2 x i64> %a to <2 x i128>
  %b.zext = zext <2 x i64> %b to <2 x i128>
  %sub = sub <2 x i128> %a.zext, %b.zext
  %abs = call <2 x i128> @llvm.abs.v2i128(<2 x i128> %sub, i1 true)
  %trunc = trunc <2 x i128> %abs to <2 x i64>
  ret <2 x i64> %trunc
}

define <2 x i64> @uabd_2d_promoted_ops(<2 x i32> %a, <2 x i32> %b) {
;
; CHECK-LABEL: uabd_2d_promoted_ops:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v9, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v9
; CHECK-NEXT:    ret
  %a.zext = zext <2 x i32> %a to <2 x i64>
  %b.zext = zext <2 x i32> %b to <2 x i64>
  %sub = sub <2 x i64> %a.zext, %b.zext
  %abs = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %sub, i1 true)
  ret <2 x i64> %abs
}

define <16 x i8> @uabd_v16i8_nuw(<16 x i8> %a, <16 x i8> %b) {
;
; CHECK-LABEL: uabd_v16i8_nuw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vsub.vv v8, v8, v9
; CHECK-NEXT:    vrsub.vi v9, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    ret
  %sub = sub nuw <16 x i8> %a, %b
  %abs = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %sub, i1 true)
  ret <16 x i8> %abs
}

define <8 x i16> @uabd_v8i16_nuw(<8 x i16> %a, <8 x i16> %b) {
;
; CHECK-LABEL: uabd_v8i16_nuw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vsub.vv v8, v8, v9
; CHECK-NEXT:    vrsub.vi v9, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    ret
  %sub = sub nuw <8 x i16> %a, %b
  %abs = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %sub, i1 true)
  ret <8 x i16> %abs
}

define <4 x i32> @uabd_v4i32_nuw(<4 x i32> %a, <4 x i32> %b) {
;
; CHECK-LABEL: uabd_v4i32_nuw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vsub.vv v8, v8, v9
; CHECK-NEXT:    vrsub.vi v9, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    ret
  %sub = sub nuw <4 x i32> %a, %b
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %sub, i1 true)
  ret <4 x i32> %abs
}

define <2 x i64> @uabd_v2i64_nuw(<2 x i64> %a, <2 x i64> %b) {
;
; CHECK-LABEL: uabd_v2i64_nuw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vsub.vv v8, v8, v9
; CHECK-NEXT:    vrsub.vi v9, v8, 0
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    ret
  %sub = sub nuw <2 x i64> %a, %b
  %abs = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %sub, i1 true)
  ret <2 x i64> %abs
}

define <16 x i8> @sabd_v16i8_nsw(<16 x i8> %a, <16 x i8> %b) {
;
; CHECK-LABEL: sabd_v16i8_nsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %sub = sub nsw <16 x i8> %a, %b
  %abs = call <16 x i8> @llvm.abs.v16i8(<16 x i8> %sub, i1 true)
  ret <16 x i8> %abs
}

define <8 x i16> @sabd_v8i16_nsw(<8 x i16> %a, <8 x i16> %b) {
;
; CHECK-LABEL: sabd_v8i16_nsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %sub = sub nsw <8 x i16> %a, %b
  %abs = call <8 x i16> @llvm.abs.v8i16(<8 x i16> %sub, i1 true)
  ret <8 x i16> %abs
}

define <4 x i32> @sabd_v4i32_nsw(<4 x i32> %a, <4 x i32> %b) {
;
; CHECK-LABEL: sabd_v4i32_nsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %sub = sub nsw <4 x i32> %a, %b
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %sub, i1 true)
  ret <4 x i32> %abs
}

define <2 x i64> @sabd_v2i64_nsw(<2 x i64> %a, <2 x i64> %b) {
;
; CHECK-LABEL: sabd_v2i64_nsw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %sub = sub nsw <2 x i64> %a, %b
  %abs = call <2 x i64> @llvm.abs.v2i64(<2 x i64> %sub, i1 true)
  ret <2 x i64> %abs
}

define <16 x i8> @smaxmin_v16i8(<16 x i8> %0, <16 x i8> %1) {
;
; CHECK-LABEL: smaxmin_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a = tail call <16 x i8> @llvm.smax.v16i8(<16 x i8> %0, <16 x i8> %1)
  %b = tail call <16 x i8> @llvm.smin.v16i8(<16 x i8> %0, <16 x i8> %1)
  %sub = sub <16 x i8> %a, %b
  ret <16 x i8> %sub
}

define <8 x i16> @smaxmin_v8i16(<8 x i16> %0, <8 x i16> %1) {
;
; CHECK-LABEL: smaxmin_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a = tail call <8 x i16> @llvm.smax.v8i16(<8 x i16> %0, <8 x i16> %1)
  %b = tail call <8 x i16> @llvm.smin.v8i16(<8 x i16> %0, <8 x i16> %1)
  %sub = sub <8 x i16> %a, %b
  ret <8 x i16> %sub
}

define <4 x i32> @smaxmin_v4i32(<4 x i32> %0, <4 x i32> %1) {
;
; CHECK-LABEL: smaxmin_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a = tail call <4 x i32> @llvm.smax.v4i32(<4 x i32> %0, <4 x i32> %1)
  %b = tail call <4 x i32> @llvm.smin.v4i32(<4 x i32> %0, <4 x i32> %1)
  %sub = sub <4 x i32> %a, %b
  ret <4 x i32> %sub
}

define <2 x i64> @smaxmin_v2i64(<2 x i64> %0, <2 x i64> %1) {
;
; CHECK-LABEL: smaxmin_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vmin.vv v10, v8, v9
; CHECK-NEXT:    vmax.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a = tail call <2 x i64> @llvm.smax.v2i64(<2 x i64> %0, <2 x i64> %1)
  %b = tail call <2 x i64> @llvm.smin.v2i64(<2 x i64> %0, <2 x i64> %1)
  %sub = sub <2 x i64> %a, %b
  ret <2 x i64> %sub
}

define <16 x i8> @umaxmin_v16i8(<16 x i8> %0, <16 x i8> %1) {
;
; CHECK-LABEL: umaxmin_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a = tail call <16 x i8> @llvm.umax.v16i8(<16 x i8> %0, <16 x i8> %1)
  %b = tail call <16 x i8> @llvm.umin.v16i8(<16 x i8> %0, <16 x i8> %1)
  %sub = sub <16 x i8> %a, %b
  ret <16 x i8> %sub
}

define <8 x i16> @umaxmin_v8i16(<8 x i16> %0, <8 x i16> %1) {
;
; CHECK-LABEL: umaxmin_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a = tail call <8 x i16> @llvm.umax.v8i16(<8 x i16> %0, <8 x i16> %1)
  %b = tail call <8 x i16> @llvm.umin.v8i16(<8 x i16> %0, <8 x i16> %1)
  %sub = sub <8 x i16> %a, %b
  ret <8 x i16> %sub
}

define <4 x i32> @umaxmin_v4i32(<4 x i32> %0, <4 x i32> %1) {
;
; CHECK-LABEL: umaxmin_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a = tail call <4 x i32> @llvm.umax.v4i32(<4 x i32> %0, <4 x i32> %1)
  %b = tail call <4 x i32> @llvm.umin.v4i32(<4 x i32> %0, <4 x i32> %1)
  %sub = sub <4 x i32> %a, %b
  ret <4 x i32> %sub
}

define <2 x i64> @umaxmin_v2i64(<2 x i64> %0, <2 x i64> %1) {
;
; CHECK-LABEL: umaxmin_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a = tail call <2 x i64> @llvm.umax.v2i64(<2 x i64> %0, <2 x i64> %1)
  %b = tail call <2 x i64> @llvm.umin.v2i64(<2 x i64> %0, <2 x i64> %1)
  %sub = sub <2 x i64> %a, %b
  ret <2 x i64> %sub
}

define <16 x i8> @umaxmin_v16i8_com1(<16 x i8> %0, <16 x i8> %1) {
;
; CHECK-LABEL: umaxmin_v16i8_com1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vminu.vv v10, v8, v9
; CHECK-NEXT:    vmaxu.vv v8, v8, v9
; CHECK-NEXT:    vsub.vv v8, v8, v10
; CHECK-NEXT:    ret
  %a = tail call <16 x i8> @llvm.umax.v16i8(<16 x i8> %0, <16 x i8> %1)
  %b = tail call <16 x i8> @llvm.umin.v16i8(<16 x i8> %1, <16 x i8> %0)
  %sub = sub <16 x i8> %a, %b
  ret <16 x i8> %sub
}

declare <8 x i8> @llvm.abs.v8i8(<8 x i8>, i1)
declare <16 x i8> @llvm.abs.v16i8(<16 x i8>, i1)

declare <4 x i16> @llvm.abs.v4i16(<4 x i16>, i1)
declare <8 x i16> @llvm.abs.v8i16(<8 x i16>, i1)
declare <16 x i16> @llvm.abs.v16i16(<16 x i16>, i1)

declare <2 x i32> @llvm.abs.v2i32(<2 x i32>, i1)
declare <4 x i32> @llvm.abs.v4i32(<4 x i32>, i1)
declare <8 x i32> @llvm.abs.v8i32(<8 x i32>, i1)

declare <2 x i64> @llvm.abs.v2i64(<2 x i64>, i1)
declare <4 x i64> @llvm.abs.v4i64(<4 x i64>, i1)

declare <2 x i128> @llvm.abs.v2i128(<2 x i128>, i1)

declare <16 x i8> @llvm.smax.v16i8(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.smax.v8i16(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.smax.v4i32(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.smax.v2i64(<2 x i64>, <2 x i64>)
declare <16 x i8> @llvm.smin.v16i8(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.smin.v8i16(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.smin.v4i32(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.smin.v2i64(<2 x i64>, <2 x i64>)
declare <16 x i8> @llvm.umax.v16i8(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.umax.v8i16(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.umax.v4i32(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.umax.v2i64(<2 x i64>, <2 x i64>)
declare <16 x i8> @llvm.umin.v16i8(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.umin.v8i16(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.umin.v4i32(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.umin.v2i64(<2 x i64>, <2 x i64>)

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; RV32: {{.*}}
; RV64: {{.*}}
