# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=mips64el -mcpu=i6400 --mattr=msa -iterations=1 < %s | FileCheck %s
  .abicalls
  .text
  .globl	i6400
  .p2align	3
  .type	i6400,@function
  .ent i6400
i6400:
  .set	noat
  lw	$1, 0($sp)
  lw	$2, 8($sp)
  move	$3, $1
  mul	$3, $2, $3
  sw	$3, 8($sp)
  div	$2, $1
  sw	$2, 0($sp)
  add	$4, $2, $3
  clo $5, $4
  sw	$4, 8($sp)
  sw	$5, 24($sp)
  ld.d    $w1, 0($2)
  ld.d    $w2, 0($3)
  add_a.d	$w0, $w1, $w2
  fmsub.d $w3, $w1, $w2
  st.d    $w0, 16($sp)
  st.d    $w3, 32($sp)
  .end	i6400

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      17
# CHECK-NEXT: Total Cycles:      59
# CHECK-NEXT: Total uOps:        17

# CHECK:      Dispatch Width:    2
# CHECK-NEXT: uOps Per Cycle:    0.29
# CHECK-NEXT: IPC:               0.29
# CHECK-NEXT: Block RThroughput: 8.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     1.00    *                   lw	$1, 0($sp)
# CHECK-NEXT:  1      3     1.00    *                   lw	$2, 8($sp)
# CHECK-NEXT:  1      1     0.50                        move	$3, $1
# CHECK-NEXT:  1      4     1.00                        mul	$3, $2, $3
# CHECK-NEXT:  1      1     1.00           *            sw	$3, 8($sp)
# CHECK-NEXT:  1      32    1.00                        div	$2, $1
# CHECK-NEXT:  1      1     1.00           *            sw	$2, 0($sp)
# CHECK-NEXT:  1      1     0.50                  U     add	$4, $2, $3
# CHECK-NEXT:  1      1     0.50                        clo	$5, $4
# CHECK-NEXT:  1      1     1.00           *            sw	$4, 8($sp)
# CHECK-NEXT:  1      1     1.00           *            sw	$5, 24($sp)
# CHECK-NEXT:  1      3     2.00    *                   ld.d	$w1, 0($2)
# CHECK-NEXT:  1      3     2.00    *                   ld.d	$w2, 0($3)
# CHECK-NEXT:  1      2     2.00                        add_a.d	$w0, $w1, $w2
# CHECK-NEXT:  1      8     2.00                        fmsub.d	$w3, $w1, $w2
# CHECK-NEXT:  1      3     1.00           *            st.d	$w0, 16($sp)
# CHECK-NEXT:  1      3     1.00           *            st.d	$w3, 32($sp)

# CHECK:      Resources:
# CHECK-NEXT: [0]   - I6400AGEN
# CHECK-NEXT: [1]   - I6400Atomic
# CHECK-NEXT: [2]   - I6400CTRL
# CHECK-NEXT: [3.0] - I6400FPU
# CHECK-NEXT: [3.1] - I6400FPU
# CHECK-NEXT: [3.2] - I6400FPU
# CHECK-NEXT: [4]   - I6400FPUApu
# CHECK-NEXT: [5]   - I6400FPUFloatL
# CHECK-NEXT: [6]   - I6400FPULong
# CHECK-NEXT: [7]   - I6400FPUShort
# CHECK-NEXT: [8]   - I6400IssueALU0
# CHECK-NEXT: [9]   - I6400IssueALU1
# CHECK-NEXT: [10]  - I6400IssueCTU
# CHECK-NEXT: [11]  - I6400IssueLSU
# CHECK-NEXT: [12]  - I6400MDU

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3.0]  [3.1]  [3.2]  [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]
# CHECK-NEXT: 8.00    -      -     2.00   2.00   4.00    -      -     2.00   6.00   1.00   2.00    -     8.00   2.00

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3.0]  [3.1]  [3.2]  [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   Instructions:
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -     1.00    -     lw	$1, 0($sp)
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -     1.00    -     lw	$2, 8($sp)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -     move	$3, $1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   mul	$3, $2, $3
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -     1.00    -     sw	$3, 8($sp)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -     1.00   div	$2, $1
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -     1.00    -     sw	$2, 0($sp)
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     add	$4, $2, $3
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -     clo	$5, $4
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -     1.00    -     sw	$4, 8($sp)
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -     1.00    -     sw	$5, 24($sp)
# CHECK-NEXT:  -      -      -      -      -     2.00    -      -      -     2.00    -      -      -      -      -     ld.d	$w1, 0($2)
# CHECK-NEXT:  -      -      -      -     2.00    -      -      -      -     2.00    -      -      -      -      -     ld.d	$w2, 0($3)
# CHECK-NEXT:  -      -      -     2.00    -      -      -      -      -     2.00    -      -      -      -      -     add_a.d	$w0, $w1, $w2
# CHECK-NEXT:  -      -      -      -      -     2.00    -      -     2.00    -      -      -      -      -      -     fmsub.d	$w3, $w1, $w2
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -     1.00    -     st.d	$w0, 16($sp)
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -      -      -      -      -      -     1.00    -     st.d	$w3, 32($sp)
