; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel=0 -march=amdgcn -mcpu=gfx1200 < %s | FileCheck %s
; RUN: llc -global-isel=1 -march=amdgcn -mcpu=gfx1200 < %s | FileCheck %s

define amdgpu_gs void @test_ds_bvh_stack_push4_pop1(i32 %addr, i32 %data0, <4 x i32> %data1) {
; CHECK-LABEL: test_ds_bvh_stack_push4_pop1:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ds_bvh_stack_push4_pop1_rtn_b32 v1, v0, v1, v[2:5]
; CHECK-NEXT:    s_wait_dscnt 0x0
; CHECK-NEXT:    export prim v1, off, off, off done
; CHECK-NEXT:    s_endpgm
  %pair = call { i32, i32 } @llvm.amdgcn.ds.bvh.stack.push4.pop1.rtn(i32 %addr, i32 %data0, <4 x i32> %data1, i32 0)
  %vdst = extractvalue { i32, i32 } %pair, 0
  %newaddr = extractvalue { i32, i32 } %pair, 1
  call void @llvm.amdgcn.exp.i32(i32 20, i32 1, i32 %vdst, i32 %newaddr, i32 poison, i32 poison, i1 true, i1 false)
  ret void
}

define amdgpu_gs void @test_ds_bvh_stack_push4_pop1_1(i32 %addr, i32 %data0, <4 x i32> %data1) {
; CHECK-LABEL: test_ds_bvh_stack_push4_pop1_1:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ds_bvh_stack_push4_pop1_rtn_b32 v1, v0, v1, v[2:5] offset:1
; CHECK-NEXT:    s_wait_dscnt 0x0
; CHECK-NEXT:    export prim v1, off, off, off done
; CHECK-NEXT:    s_endpgm
  %pair = call { i32, i32 } @llvm.amdgcn.ds.bvh.stack.push4.pop1.rtn(i32 %addr, i32 %data0, <4 x i32> %data1, i32 1)
  %vdst = extractvalue { i32, i32 } %pair, 0
  %newaddr = extractvalue { i32, i32 } %pair, 1
  call void @llvm.amdgcn.exp.i32(i32 20, i32 1, i32 %vdst, i32 %newaddr, i32 poison, i32 poison, i1 true, i1 false)
  ret void
}

define amdgpu_gs void @test_ds_bvh_stack_push8_pop1(i32 %addr, i32 %data0, <8 x i32> %data1) {
; CHECK-LABEL: test_ds_bvh_stack_push8_pop1:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ds_bvh_stack_push8_pop1_rtn_b32 v1, v0, v1, v[2:9]
; CHECK-NEXT:    s_wait_dscnt 0x0
; CHECK-NEXT:    export prim v1, off, off, off done
; CHECK-NEXT:    s_endpgm
  %pair = call { i32, i32 } @llvm.amdgcn.ds.bvh.stack.push8.pop1.rtn(i32 %addr, i32 %data0, <8 x i32> %data1, i32 0)
  %vdst = extractvalue { i32, i32 } %pair, 0
  %newaddr = extractvalue { i32, i32 } %pair, 1
  call void @llvm.amdgcn.exp.i32(i32 20, i32 1, i32 %vdst, i32 %newaddr, i32 poison, i32 poison, i1 true, i1 false)
  ret void
}

define amdgpu_gs void @test_ds_bvh_stack_push8_pop1_1(i32 %addr, i32 %data0, <8 x i32> %data1) {
; CHECK-LABEL: test_ds_bvh_stack_push8_pop1_1:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ds_bvh_stack_push8_pop1_rtn_b32 v1, v0, v1, v[2:9] offset:1
; CHECK-NEXT:    s_wait_dscnt 0x0
; CHECK-NEXT:    export prim v1, off, off, off done
; CHECK-NEXT:    s_endpgm
  %pair = call { i32, i32 } @llvm.amdgcn.ds.bvh.stack.push8.pop1.rtn(i32 %addr, i32 %data0, <8 x i32> %data1, i32 1)
  %vdst = extractvalue { i32, i32 } %pair, 0
  %newaddr = extractvalue { i32, i32 } %pair, 1
  call void @llvm.amdgcn.exp.i32(i32 20, i32 1, i32 %vdst, i32 %newaddr, i32 poison, i32 poison, i1 true, i1 false)
  ret void
}

define amdgpu_gs void @test_ds_bvh_stack_push8_pop2(i32 %addr, i32 %data0, <8 x i32> %data1, ptr addrspace(1) %out1, ptr addrspace(1) %out2) {
; CHECK-LABEL: test_ds_bvh_stack_push8_pop2:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ds_bvh_stack_push8_pop2_rtn_b64 v[1:2], v0, v1, v[2:9]
; CHECK-NEXT:    s_wait_dscnt 0x0
; CHECK-NEXT:    export prim v1, off, off, off done
; CHECK-NEXT:    s_endpgm
  %pair = call { i64, i32 } @llvm.amdgcn.ds.bvh.stack.push8.pop2.rtn(i32 %addr, i32 %data0, <8 x i32> %data1, i32 0)
  %vdst = extractvalue { i64, i32 } %pair, 0
  %newaddr = extractvalue { i64, i32 } %pair, 1
  %vdst.v2i32 = bitcast i64 %vdst to <2 x i32>
  %vdst.lo = extractelement <2 x i32> %vdst.v2i32, i32 0
  %vdst.hi = extractelement <2 x i32> %vdst.v2i32, i32 1
  call void @llvm.amdgcn.exp.i32(i32 20, i32 1, i32 %vdst.lo, i32 %vdst.hi, i32 %newaddr, i32 poison, i1 true, i1 false)
  ret void
}

define amdgpu_gs void @test_ds_bvh_stack_push8_pop2_1(i32 %addr, i32 %data0, <8 x i32> %data1, ptr addrspace(1) %out1, ptr addrspace(1) %out2) {
; CHECK-LABEL: test_ds_bvh_stack_push8_pop2_1:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ds_bvh_stack_push8_pop2_rtn_b64 v[1:2], v0, v1, v[2:9] offset:1
; CHECK-NEXT:    s_wait_dscnt 0x0
; CHECK-NEXT:    export prim v1, off, off, off done
; CHECK-NEXT:    s_endpgm
  %pair = call { i64, i32 } @llvm.amdgcn.ds.bvh.stack.push8.pop2.rtn(i32 %addr, i32 %data0, <8 x i32> %data1, i32 1)
  %vdst = extractvalue { i64, i32 } %pair, 0
  %newaddr = extractvalue { i64, i32 } %pair, 1
  %vdst.v2i32 = bitcast i64 %vdst to <2 x i32>
  %vdst.lo = extractelement <2 x i32> %vdst.v2i32, i32 0
  %vdst.hi = extractelement <2 x i32> %vdst.v2i32, i32 1
  call void @llvm.amdgcn.exp.i32(i32 20, i32 1, i32 %vdst.lo, i32 %vdst.hi, i32 %newaddr, i32 poison, i1 true, i1 false)
  ret void
}
