unit OUUNIT;

INTERFACE
uses use32;

function commandstr(var ith:integer;{ returns TRUE if the ITH parameter of   }
         var str:string):boolean; { the command line not starting with - or /}
                                  { exists and is returned in STR            }
function commandopt(var ith:integer;{ returns TRUE if the ITH parameter of   }
         var opt:string;          { command line starting with - or / exists }
         var str:string):boolean; { the parameter is divided into two parts  }
                                  { the first (Option key -- till : or the   }
                                  { first character) in returned in OPT, the }
                                  { rest (Option value -- without possible :)}
                                  { in STR                                   }
procedure dosreport(msg:string;   { writes MSG string followed by the        }
          haltcode:integer);      { error message generated by DosError      }
                                  { if HALTCODE is nonnegative, then halt is }
                                  { exicuted with exit code HALTCODE         }
function checkfile(fname:string;  { returns TRUE, if file FNAME exists in    }
         inpatha:string;          { the directories given in INPATHA or in   }
         inpathb:string;          { INPATHB (in this case INA is returned    }
         var ina:boolean):boolean;{ false) - pathes are separated by         }
                                  { semicolon). immediately after return,    }
                                  { the DosError can be checked              }

IMPLEMENTATION
uses dos;

function commandstr;
var i,k     :integer;
    param   :string;
begin; k:=ith; inc(ith);
for i:=1 to paramcount do
  begin;  param:=paramstr(i);             { take the i-th parameter }
  if (param[1]<>'/') and (param[1]<>'-') then
    begin;  dec(k);                       { until zero }
    if k=0 then                           { we found the ITH parameter}
      begin;  str:=param;  commandstr:=true;  exit;  end;
    end;
  end;
commandstr:=false;  str:=''; exit;        { ITH parameter not found }
end;

function commandopt;
var i,j,k   :integer;
    param   :string;
begin; k:=ith; inc(ith);
for i:=1 to paramcount do
  begin;  param:=paramstr(i);             { take the i-th parameter }
  if (param[1]='/') or (param[1]='-') then
    begin;  dec(k);                       { until zero }
    if k=0 then                           { we found the ITH parameter }
      begin;  str:=param;
      delete(str,1,1);                    { to remove option mark }
      j:=pos(':',str);                    { position of : }
      if j>0 then delete(str,j,1) else  j:=2;
      opt:=copy(str,1,j-1);               { Option key }
      str:=copy(str,j,255);               { Option value }
      commandopt:=true;
      exit;
      end;
    end;
  end;
commandopt:=false;
opt:='';  str:='';  exit;                 { ITH parameter not found }
end;

procedure dosreport;
begin; msg:=msg+'  -  ';
case DosError of
   0: ;
   2: writeln(msg+'File not found.');
   3: writeln(msg+'Path not found.');
   5: writeln(msg+'Access denied.');
   6: writeln(msg+'Invalid handle.');
   8: writeln(msg+'Not enough memory.');
  10: writeln(msg+'Invalid environment.');
  11: writeln(msg+'Invalid format.');
  18: writeln(msg+'No more files.');
  else writeln(msg+'Unknown DosError.');
  end;
if haltcode>=0 then halt(haltcode);
end;

function checkfile(fname:string;inpatha,inpathb:string;var ina:boolean):boolean;
const found :boolean  = false;          { file not found yet }
var dir     :dirstr;
    name    :namestr;
    ext     :extstr;
    foundfile:searchrec;
    partpath:string;
    naux:integer;
begin; naux:=length(inpatha);
if (naux>0) and (inpatha[naux]<>';') then { all pathes must end by semicolon }
  inpatha:=inpatha+';';
inpatha:=inpatha+inpathb;
fsplit(fname,dir,name,ext);             { to gain only the directory }
if (length(inpatha)=0) and (dir='') then { just file in the current directory }
  dir:='a';
if dir<>'' then                         { file with explicite path }
  begin;
  findfirst(fname,anyfile,foundfile);
  if DosError=0 then checkfile:=true
  else checkfile:=false;
  exit;
  end;
if inpatha[length(inpatha)]<>';' then   { all pathes must end by semicolon }
  inpatha:=inpatha+';';
while (length(inpatha)>0) and not found do { scans all directories }
  begin;  naux:=pos(';',inpatha);
  partpath:=copy(inpatha,1,naux-1);     { take the next path }
  delete(inpatha,1,naux);               { discard it in the list }
  naux:=length(partpath);                      { remember its length }
  if (naux>0) and (partpath[naux]<>'\') then   { path must end by \ }
    partpath:=partpath+'\';
  findfirst(partpath+name+ext,anyfile,foundfile);
  if DosError=0 then found:=true;
  end;
if found then                           { to decide in which path (a or b) }
  begin; naux:=length(partpath);
  if partpath[naux]='\' then delete(partpath,naux,1);
  if pos(partpath,inpathb)>0 then ina:=false else ina:=true;
  end;
checkfile:=found;
end;

end.

